/* The actual codes used */
#include <exec/types.h>

#include "prog_codes.h"

/* To decode an instruction, you use its code (from codes.h). Therefore,
  if these are changed, you must change these keycodes as well */
struct KeyCode keycodes[] = {
   {ONECODE, 11},
   {ONECODE, 12},
   {ONECODE, 13},
   {ONECODE, 14},
   {ONECODE, 15},
   {ONECODE, 16},
   {ONECODE, 10},
   {ONECODE, 23},
   {ONECODE, 24},
   {ONECODE, 25},
   {ONECODE, 26},
   {ONECODE, 20},
   {ONECODE, 31},
   {ONECODE, 33},
   {ONECODE, 34},
   {ONECODE, 36},
   {ONECODE, 30},
   {ONECODE, 48},
   {ONECODE, 49},
   {ONECODE, 40},
/* f codes */
   {TWOCODE, 42, 16},
   {TWOCODE, 42, 10},
   {TWOCODE, 42, 23},
   {TWOCODE, 42, 26},
   {TWOCODE_9, 42, 4},
   {TWOCODE_9, 42, 5},
   {TWOCODE_9, 42, 6},
   {TWOCODE, 42, 20},
   {TWOCODE, 42, 31},
   {TWOCODE, 42, 32},
   {TWOCODE, 42, 34},
   {TWOCODE, 42, 36},
   {TWOCODE_9, 42, 1},
   {TWOCODE_9, 42, 2},
   {TWOCODE_9, 42, 3},
   {TWOCODE, 42, 30},
   {TWOCODE, 42, 44},
   {TWOCODE_9, 42,0},
   {TWOCODE, 42, 48},
   {TWOCODE, 42, 49},
   {TWOCODE, 42, 40},
/* g codes */
   {TWOCODE, 43, 11},
   {TWOCODE, 43, 12},
   {TWOCODE, 43, 13},
   {TWOCODE, 43, 14},
   {TWOCODE, 43, 15},
   {TWOCODE, 43, 16},
   {TWOCODE_9, 43, 7},
   {TWOCODE_9, 43, 8},
   {TWOCODE_9, 43, 9},
   {TWOCODE, 43, 10},
   {TWOCODE, 43, 23},
   {TWOCODE, 43, 24},
   {TWOCODE, 43, 25},
   {TWOCODE, 43, 26},
   {TWOCODE, 43, 20},
   {TWOCODE, 43, 32},
   {TWOCODE, 43, 33},
   {TWOCODE, 43, 34},
   {TWOCODE, 43, 35},
   {TWOCODE, 43, 36},
   {TWOCODE_9, 43, 1},
   {TWOCODE_9, 43, 2},
   {TWOCODE_9, 43, 3},
   {TWOCODE, 43, 30},
   {TWOCODE, 43, 44},
   {TWOCODE_9, 43, 0},
   {TWOCODE, 43, 48},
   {TWOCODE, 43, 49},
   {TWOCODE, 43, 40},
/* Miscellaneous */
   {TWOCODE, 45, 36},
   {TWOCODE, 45, 49},
/* ARC */
   {THREECODE, 42, 22, 23},
   {THREECODE, 42, 22, 24},
   {THREECODE, 42, 22, 25},
   {THREECODE, 43, 22, 23},
   {THREECODE, 43, 22, 24},
   {THREECODE, 43, 22, 25},
/* Flags */
   {THREECODE, 43, 4, 0},
   {THREECODE, 43, 4, 1},
   {THREECODE, 43, 5, 0},
   {THREECODE, 43, 5, 1},
   {THREECODE, 43, 6, 0},
   {THREECODE, 43, 6, 1},
/* Figures */
   {ONECODE, 0},
   {ONECODE, 1},
   {ONECODE, 2},
   {ONECODE, 3},
   {ONECODE, 4},
   {ONECODE, 5},
   {ONECODE, 6},
   {ONECODE, 7},
   {ONECODE, 8},
   {ONECODE, 9},
/* FIX, SCI, ENG */
   {THREECODE, 42, 7, 0},
   {THREECODE, 42, 7, 1},
   {THREECODE, 42, 7, 2},
   {THREECODE, 42, 7, 3},
   {THREECODE, 42, 7, 4},
   {THREECODE, 42, 7, 5},
   {THREECODE, 42, 7, 6},
   {THREECODE, 42, 7, 7},
   {THREECODE, 42, 7, 8},
   {THREECODE, 42, 7, 9},

   {THREECODE, 42, 8, 0},
   {THREECODE, 42, 8, 1},
   {THREECODE, 42, 8, 2},
   {THREECODE, 42, 8, 3},
   {THREECODE, 42, 8, 4},
   {THREECODE, 42, 8, 5},
   {THREECODE, 42, 8, 6},
   {THREECODE, 42, 8, 7},

   {THREECODE, 42, 9, 0},
   {THREECODE, 42, 9, 1},
   {THREECODE, 42, 9, 2},
   {THREECODE, 42, 9, 3},
   {THREECODE, 42, 9, 4},
   {THREECODE, 42, 9, 5},
   {THREECODE, 42, 9, 6},
   {THREECODE, 42, 9, 7},
/* LBL, GTO, GSB */
   {THREECODE, 42, 21, 0},
   {THREECODE, 42, 21, 1},
   {THREECODE, 42, 21, 2},
   {THREECODE, 42, 21, 3},
   {THREECODE, 42, 21, 4},
   {THREECODE, 42, 21, 5},
   {THREECODE, 42, 21, 6},
   {THREECODE, 42, 21, 7},
   {THREECODE, 42, 21, 8},
   {THREECODE, 42, 21, 9},
   {THREECODE, 42, 21, 11},
   {THREECODE, 42, 21, 12},
   {THREECODE, 42, 21, 13},
   {THREECODE, 42, 21, 14},
   {THREECODE, 42, 21, 15},

   {TWOCODE_9, 22, 0},
   {TWOCODE_9, 22, 1},
   {TWOCODE_9, 22, 2},
   {TWOCODE_9, 22, 3},
   {TWOCODE_9, 22, 4},
   {TWOCODE_9, 22, 5},
   {TWOCODE_9, 22, 6},
   {TWOCODE_9, 22, 7},
   {TWOCODE_9, 22, 8},
   {TWOCODE_9, 22, 9},
   {TWOCODE, 22, 11},
   {TWOCODE, 22, 12},
   {TWOCODE, 22, 13},
   {TWOCODE, 22, 14},
   {TWOCODE, 22, 15},
   {TWOCODE, 22, 25},

   {TWOCODE_9, 32, 0},
   {TWOCODE_9, 32, 1},
   {TWOCODE_9, 32, 2},
   {TWOCODE_9, 32, 3},
   {TWOCODE_9, 32, 4},
   {TWOCODE_9, 32, 5},
   {TWOCODE_9, 32, 6},
   {TWOCODE_9, 32, 7},
   {TWOCODE_9, 32, 8},
   {TWOCODE_9, 32, 9},
   {TWOCODE, 32, 11},
   {TWOCODE, 32, 12},
   {TWOCODE, 32, 13},
   {TWOCODE, 32, 14},
   {TWOCODE, 32, 15},
   {TWOCODE, 32, 25},
/* STO, STO +, STO -, STO *, STO / */
   {TWOCODE_9, 44, 0},
   {TWOCODE_9, 44, 1},
   {TWOCODE_9, 44, 2},
   {TWOCODE_9, 44, 3},
   {TWOCODE_9, 44, 4},
   {TWOCODE_9, 44, 5},
   {TWOCODE_9, 44, 6},
   {TWOCODE_9, 44, 7},
   {TWOCODE_9, 44, 8},
   {TWOCODE_9, 44, 9},
   {TWOCODE_PT, 44, 0},
   {TWOCODE_PT, 44, 1},
   {TWOCODE_PT, 44, 2},
   {TWOCODE_PT, 44, 3},
   {TWOCODE_PT, 44, 4},
   {TWOCODE_PT, 44, 5},
   {TWOCODE_PT, 44, 6},
   {TWOCODE_PT, 44, 7},
   {TWOCODE_PT, 44, 8},
   {TWOCODE_PT, 44, 9},
   {TWOCODE, 44, 25},
   {TWOCODE, 44, 24},

   {THREECODE, 44, 40, 0},
   {THREECODE, 44, 40, 1},
   {THREECODE, 44, 40, 2},
   {THREECODE, 44, 40, 3},
   {THREECODE, 44, 40, 4},
   {THREECODE, 44, 40, 5},
   {THREECODE, 44, 40, 6},
   {THREECODE, 44, 40, 7},
   {THREECODE, 44, 40, 8},
   {THREECODE, 44, 40, 9},
   {THREECODE_PT, 44, 40, 0},
   {THREECODE_PT, 44, 40, 1},
   {THREECODE_PT, 44, 40, 2},
   {THREECODE_PT, 44, 40, 3},
   {THREECODE_PT, 44, 40, 4},
   {THREECODE_PT, 44, 40, 5},
   {THREECODE_PT, 44, 40, 6},
   {THREECODE_PT, 44, 40, 7},
   {THREECODE_PT, 44, 40, 8},
   {THREECODE_PT, 44, 40, 9},
   {THREECODE, 44, 40, 25},
   {THREECODE, 44, 40, 24},

   {THREECODE, 44, 30, 0},
   {THREECODE, 44, 30, 1},
   {THREECODE, 44, 30, 2},
   {THREECODE, 44, 30, 3},
   {THREECODE, 44, 30, 4},
   {THREECODE, 44, 30, 5},
   {THREECODE, 44, 30, 6},
   {THREECODE, 44, 30, 7},
   {THREECODE, 44, 30, 8},
   {THREECODE, 44, 30, 9},
   {THREECODE_PT, 44, 30, 0},
   {THREECODE_PT, 44, 30, 1},
   {THREECODE_PT, 44, 30, 2},
   {THREECODE_PT, 44, 30, 3},
   {THREECODE_PT, 44, 30, 4},
   {THREECODE_PT, 44, 30, 5},
   {THREECODE_PT, 44, 30, 6},
   {THREECODE_PT, 44, 30, 7},
   {THREECODE_PT, 44, 30, 8},
   {THREECODE_PT, 44, 30, 9},
   {THREECODE, 44, 30, 25},
   {THREECODE, 44, 30, 24},

   {THREECODE, 44, 20, 0},
   {THREECODE, 44, 20, 1},
   {THREECODE, 44, 20, 2},
   {THREECODE, 44, 20, 3},
   {THREECODE, 44, 20, 4},
   {THREECODE, 44, 20, 5},
   {THREECODE, 44, 20, 6},
   {THREECODE, 44, 20, 7},
   {THREECODE, 44, 20, 8},
   {THREECODE, 44, 20, 9},
   {THREECODE_PT, 44, 20, 0},
   {THREECODE_PT, 44, 20, 1},
   {THREECODE_PT, 44, 20, 2},
   {THREECODE_PT, 44, 20, 3},
   {THREECODE_PT, 44, 20, 4},
   {THREECODE_PT, 44, 20, 5},
   {THREECODE_PT, 44, 20, 6},
   {THREECODE_PT, 44, 20, 7},
   {THREECODE_PT, 44, 20, 8},
   {THREECODE_PT, 44, 20, 9},
   {THREECODE, 44, 20, 25},
   {THREECODE, 44, 20, 24},

   {THREECODE, 44, 10, 0},
   {THREECODE, 44, 10, 1},
   {THREECODE, 44, 10, 2},
   {THREECODE, 44, 10, 3},
   {THREECODE, 44, 10, 4},
   {THREECODE, 44, 10, 5},
   {THREECODE, 44, 10, 6},
   {THREECODE, 44, 10, 7},
   {THREECODE, 44, 10, 8},
   {THREECODE, 44, 10, 9},
   {THREECODE_PT, 44, 10, 0},
   {THREECODE_PT, 44, 10, 1},
   {THREECODE_PT, 44, 10, 2},
   {THREECODE_PT, 44, 10, 3},
   {THREECODE_PT, 44, 10, 4},
   {THREECODE_PT, 44, 10, 5},
   {THREECODE_PT, 44, 10, 6},
   {THREECODE_PT, 44, 10, 7},
   {THREECODE_PT, 44, 10, 8},
   {THREECODE_PT, 44, 10, 9},
   {THREECODE, 44, 10, 25},
   {THREECODE, 44, 10, 24},

/* RCL */
   {TWOCODE_9, 45, 0},
   {TWOCODE_9, 45, 1},
   {TWOCODE_9, 45, 2},
   {TWOCODE_9, 45, 3},
   {TWOCODE_9, 45, 4},
   {TWOCODE_9, 45, 5},
   {TWOCODE_9, 45, 6},
   {TWOCODE_9, 45, 7},
   {TWOCODE_9, 45, 8},
   {TWOCODE_9, 45, 9},
   {TWOCODE_PT, 45, 0},
   {TWOCODE_PT, 45, 1},
   {TWOCODE_PT, 45, 2},
   {TWOCODE_PT, 45, 3},
   {TWOCODE_PT, 45, 4},
   {TWOCODE_PT, 45, 5},
   {TWOCODE_PT, 45, 6},
   {TWOCODE_PT, 45, 7},
   {TWOCODE_PT, 45, 8},
   {TWOCODE_PT, 45, 9},
   {TWOCODE, 45, 25},
   {TWOCODE, 45, 24},
};
