#define __USE_INLINE__

#include <proto/exec.h>
#include <exec/io.h>
#include <devices/clipboard.h>
#include <datatypes/textclass.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "internal.h"

#if !defined(__AROS__)
#define AROS_LONG2BE(x) (x)
#define AROS_BE2LONG(x) (x)
#endif

struct IOClipReq *clipboardIO;


BOOL CBOpen(LONG unit)
{
  struct MsgPort *m;
  BOOL ret = FALSE;

  if((m = CreateMsgPort()))
  {
	if((clipboardIO = (struct IOClipReq *) CreateIORequest(m,sizeof(struct IOClipReq))))
	{
	  if(!OpenDevice("clipboard.device", unit,
	  (struct IORequest *) clipboardIO, 0))
		ret = TRUE;
	  if(!ret)
		DeleteIORequest((struct IORequest *)clipboardIO);
	}
	if(!ret)
	  DeleteMsgPort(m);
  }

  return ret;
}

void CBClose(void)
{
  if(clipboardIO)
  {
	CloseDevice((struct IORequest *)clipboardIO);
	DeleteMsgPort(clipboardIO->io_Message.mn_ReplyPort);
	DeleteIORequest((struct IORequest *)clipboardIO);
  }
}

void CBWrite(void *data, int length)
{
   clipboardIO->io_Command = CMD_WRITE;
   clipboardIO->io_Data = data;
   clipboardIO->io_Length = length;
   DoIO((struct IORequest *)clipboardIO);
}

void CBCut(double s)
{
  ULONG i, out, len;
  UBYTE buf[70];

  sprintf(buf, "%.11f", s);
  // Need function to remove trailing zeros
  len = strlen(buf);

	while (buf[len-1] == '0')
	{
		len = len-1;
	}
  len = ((len+1)/2)*2;

  clipboardIO->io_Offset = 0;
  clipboardIO->io_ClipID = 0;
  i = ID_FORM;
  out = AROS_LONG2BE(i);
  CBWrite(&out, 4);

  i = len + 12;
  out = AROS_LONG2BE(i);
  CBWrite(&out, 4);

  i = ID_FTXT;
  out = AROS_LONG2BE(i);
  CBWrite(&out, 4);

  i = ID_CHRS;
  out = AROS_LONG2BE(i);
  CBWrite(&out, 4);

  out = AROS_LONG2BE(len);
  CBWrite(&out, 4);
  CBWrite(buf, len);

  clipboardIO->io_Command = CMD_UPDATE;
  DoIO((struct IORequest *)clipboardIO);
}

void CBRead(void *data, int length)
{
  clipboardIO->io_Command = CMD_READ;
  clipboardIO->io_Data = data;
  clipboardIO->io_Length = length;
  DoIO((struct IORequest *)clipboardIO);
}

BOOL CBPaste(double *s)
{
   int length;
   BOOL success = FALSE;
   ULONG check;

   clipboardIO->io_ClipID = 0;
   clipboardIO->io_Offset = 0;

   CBRead(&check, 4);
   if(check == AROS_LONG2BE(ID_FORM))
   {
	 CBRead(&check, 4);
	 CBRead(&check, 4);
	 if(check == AROS_LONG2BE(ID_FTXT))
	 // look for CHRS until EOF
	 while ((clipboardIO->io_Actual == clipboardIO->io_Length) && (success == FALSE))
	 {
	   CBRead(&check, 4);
	   if(check == AROS_LONG2BE(ID_CHRS))
	   {
		 UBYTE string[70];

		 CBRead(&length, 4);
                 length = AROS_BE2LONG(length);
		 if(length > 69)
		   length = 69;
		CBRead(string, length);
		string[length] = '\0';
		*s = atof(string);
		success = TRUE;
	   }
	 } // endwhile
   }

   while(clipboardIO->io_Actual != 0)
	  CBRead(NULL, 1 << 30);

   return(success);
}
