/*
------------------------------------------------------------
	MicroCon - A tiny, simple SDL text console
------------------------------------------------------------
 * (C) David Olofson <david@olofson.net>, 2004
 *
 * This software is released under the terms of the LGPL.
 */

#ifndef UCON_H
#define UCON_H

#include "SDL.h"

/* User mark bits */
#define	UCON_MARK__PUBLIC	0x0fff

/* Reserved mark bits */
#define	UCON_MARK__PRIVATE	(~UCON_MARK__PUBLIC)
#define	UCON_MARK_CURSOR	0x4000
#define	UCON_MARK_CHANGED	0x8000

typedef struct UCON_console UCON_console;

typedef struct UCON_char
{
	unsigned short	c;
	unsigned short	marks;
} UCON_char;

typedef void (*UCON_drawc_cb)(UCON_console *uc, int x, int y, UCON_char *c);

struct UCON_console
{
	unsigned	w, h;	/* Size of buffer */
	int		cx, cy;	/* Cursor pos */
	unsigned short	mark;	/* Mark flags (applied to printed chars) */
	UCON_char	*buf;
	UCON_drawc_cb	drawc;
	int		changed;
	void		*user;
};


UCON_console *ucon_open(int w, int h, UCON_drawc_cb drawc);
void ucon_close(UCON_console *uc);
void ucon_render(UCON_console *uc, int refresh);
void ucon_scroll(UCON_console *uc);
void ucon_locate(UCON_console *uc, int x, int y);
void ucon_puts(UCON_console *uc, const char *s);
void ucon_putc(UCON_console *uc, int c);
void ucon_setc(UCON_console *uc, int x, int y, int c, int marks);

#endif	/* UCON_H */
