/*
 * UAE - The Un*x Amiga Emulator
 *
 * Support for mapping raw keys to UAE input events;
 *
 * Copyright 2004 Richard Drummond
 */

/*
 * Default mapping from raw scancodes to UAE input events
 */

#define RAWKEYS_COMMON \
     RAWKEY_ESCAPE,		UAEKEY_ESCAPE}, \
\
    {RAWKEY_F1,			UAEKEY_F1}, \
    {RAWKEY_F2,			UAEKEY_F2}, \
    {RAWKEY_F3,			UAEKEY_F3}, \
    {RAWKEY_F4,			UAEKEY_F4}, \
    {RAWKEY_F5,			UAEKEY_F5}, \
    {RAWKEY_F6,			UAEKEY_F6}, \
    {RAWKEY_F7,			UAEKEY_F7}, \
    {RAWKEY_F8,			UAEKEY_F8}, \
    {RAWKEY_F9,			UAEKEY_F9}, \
    {RAWKEY_F10,		UAEKEY_F10}, \
\
    {RAWKEY_1,			UAEKEY_1}, \
    {RAWKEY_2,			UAEKEY_2}, \
    {RAWKEY_3,			UAEKEY_3}, \
    {RAWKEY_4,			UAEKEY_4}, \
    {RAWKEY_5,			UAEKEY_5}, \
    {RAWKEY_6,			UAEKEY_6}, \
    {RAWKEY_7,			UAEKEY_7}, \
    {RAWKEY_8,			UAEKEY_8}, \
    {RAWKEY_9,			UAEKEY_9}, \
    {RAWKEY_0,			UAEKEY_0}, \
\
    {RAWKEY_TAB,		UAEKEY_TAB}, \
    {RAWKEY_ENTER,		UAEKEY_ENTER}, \
    {RAWKEY_BACKSPACE,		UAEKEY_BACKSPACE}, \
    {RAWKEY_SPACE,		UAEKEY_SPACE}, \
\
    {RAWKEY_A,			UAEKEY_A}, \
    {RAWKEY_B,			UAEKEY_B}, \
    {RAWKEY_C,			UAEKEY_C}, \
    {RAWKEY_D,			UAEKEY_D}, \
    {RAWKEY_E,			UAEKEY_E}, \
    {RAWKEY_F,			UAEKEY_F}, \
    {RAWKEY_G,			UAEKEY_G}, \
    {RAWKEY_H,			UAEKEY_H}, \
    {RAWKEY_I,			UAEKEY_I}, \
    {RAWKEY_J,			UAEKEY_J}, \
    {RAWKEY_K,			UAEKEY_K}, \
    {RAWKEY_L,			UAEKEY_L}, \
    {RAWKEY_M,			UAEKEY_M}, \
    {RAWKEY_N,			UAEKEY_N}, \
    {RAWKEY_O,			UAEKEY_O}, \
    {RAWKEY_P,			UAEKEY_P}, \
    {RAWKEY_Q,			UAEKEY_Q}, \
    {RAWKEY_R,			UAEKEY_R}, \
    {RAWKEY_S,			UAEKEY_S}, \
    {RAWKEY_T,			UAEKEY_T}, \
    {RAWKEY_U,			UAEKEY_U}, \
    {RAWKEY_V,			UAEKEY_V}, \
    {RAWKEY_W,			UAEKEY_W}, \
    {RAWKEY_X,			UAEKEY_X}, \
    {RAWKEY_Y,			UAEKEY_Y}, \
    {RAWKEY_Z,			UAEKEY_Z}, \
\
    {RAWKEY_MINUS,		UAEKEY_MINUS}, \
    {RAWKEY_EQUALS,		UAEKEY_EQUALS}, \
    {RAWKEY_LEFTBRACKET,	UAEKEY_LEFTBRACKET}, \
    {RAWKEY_RIGHTBRACKET,	UAEKEY_RIGHTBRACKET}, \
    {RAWKEY_BACKSLASH,		UAEKEY_BACKSLASH}, \
    {RAWKEY_SEMICOLON,		UAEKEY_SEMICOLON}, \
    {RAWKEY_SINGLEQUOTE,	UAEKEY_SINGLEQUOTE}, \
    {RAWKEY_COMMA,		UAEKEY_COMMA}, \
    {RAWKEY_PERIOD,		UAEKEY_PERIOD}, \
    {RAWKEY_SLASH,		UAEKEY_SLASH}, \
    {RAWKEY_GRAVE,		UAEKEY_GRAVE}, \
    {RAWKEY_LTGT,		UAEKEY_LTGT}, \
\
    {RAWKEY_NUMPAD_1,		UAEKEY_NUMPAD1}, \
    {RAWKEY_NUMPAD_2,		UAEKEY_NUMPAD2}, \
    {RAWKEY_NUMPAD_3,		UAEKEY_NUMPAD3}, \
    {RAWKEY_NUMPAD_4,		UAEKEY_NUMPAD4}, \
    {RAWKEY_NUMPAD_5,		UAEKEY_NUMPAD5}, \
    {RAWKEY_NUMPAD_6,		UAEKEY_NUMPAD6}, \
    {RAWKEY_NUMPAD_7,		UAEKEY_NUMPAD7}, \
    {RAWKEY_NUMPAD_8,		UAEKEY_NUMPAD8}, \
    {RAWKEY_NUMPAD_9,		UAEKEY_NUMPAD9}, \
    {RAWKEY_NUMPAD_0,		UAEKEY_NUMPAD0}, \
    {RAWKEY_NUMPAD_DIVIDE,	UAEKEY_NUMPAD_DIVIDE}, \
    {RAWKEY_NUMPAD_MULTIPLY,	UAEKEY_NUMPAD_MULTIPLY}, \
    {RAWKEY_NUMPAD_MINUS,	UAEKEY_NUMPAD_MINUS}, \
    {RAWKEY_NUMPAD_PLUS,	UAEKEY_NUMPAD_PLUS}, \
    {RAWKEY_NUMPAD_PERIOD,	UAEKEY_NUMPAD_PERIOD}, \
    {RAWKEY_NUMPAD_ENTER,	UAEKEY_NUMPAD_ENTER}, \
    {RAWKEY_NUMLOCK,		UAEKEY_NUMLOCK}, \
\
    {RAWKEY_INSERT,		UAEKEY_INSERT}, \
    {RAWKEY_DELETE,		UAEKEY_DELETE}, \
    {RAWKEY_HOME,		UAEKEY_HOME}, \
    {RAWKEY_END,		UAEKEY_END}, \
    {RAWKEY_PAGEUP,		UAEKEY_PAGEUP}, \
    {RAWKEY_PAGEDOWN,		UAEKEY_PAGEDOWN}, \
\
    {RAWKEY_CURSOR_UP,		UAEKEY_CURSOR_UP}, \
    {RAWKEY_CURSOR_DOWN,	UAEKEY_CURSOR_DOWN}, \
    {RAWKEY_CURSOR_LEFT,	UAEKEY_CURSOR_LEFT}, \
    {RAWKEY_CURSOR_RIGHT,	UAEKEY_CURSOR_RIGHT}, \
\
    {RAWKEY_LEFT_CTRL,		UAEKEY_LEFT_CTRL}, \
    {RAWKEY_LEFT_SHIFT,		UAEKEY_LEFT_SHIFT}, \
    {RAWKEY_LEFT_ALT,		UAEKEY_LEFT_ALT}, \
    {RAWKEY_LEFT_SUPER,		UAEKEY_LEFT_SUPER}, \
    {RAWKEY_RIGHT_SUPER,	UAEKEY_RIGHT_SUPER}, \
    {RAWKEY_RIGHT_ALT,		UAEKEY_RIGHT_ALT}, \
    {RAWKEY_RIGHT_SHIFT,	UAEKEY_RIGHT_SHIFT}, \
    {RAWKEY_RIGHT_CTRL,		UAEKEY_RIGHT_CTRL}, \
    {RAWKEY_CAPSLOCK,		UAEKEY_CAPSLOCK

#define RAWKEYS_END  -1, 0

/*
 * These aren't in the common mapping
 * since not all platforms have these keys
 *
    {RAWKEY_F11,		UAEKEY_F11},
    {RAWKEY_F12,		UAEKEY_F12},

    {RAWKEY_PRINTSCR,		UAEKEY_PRINTSCR},
    {RAWKEY_SCROLL_LOCK,	UAEKEY_SCROLL_LOCK},
    {RAWKEY_PAUSE,		UAEKEY_PAUSE},

    {RAWKEY_NUMPAD_EQUALS,	UAEKEY_NUMPAD_EQUALS},
    {RAWKEY_NUMPAD_LPAREN,      UAEKEY_NUMPAD_LPAREN},
    {RAWKEY_NUMPAD_RPAREN,      UAEKEY_NUMPAD_RPAREN},

    {RAWKEY_HELP,		UAEKEY_HELP},

    {RAWKEY_MENU,		UAEKEY_MENU},

    {RAWKEY_POWER,		UAEKEY_POWER},
    {RAWKEY_SLEEP,		UAEKEY_SLEEP},
    {RAWKEY_WAKE,		UAEKEY_WAKE},
*/
