/*
    Tiny_Tetris_SDL :  A tiny and simply Tetris with SDL
    Copyright (C) 2008-2009 Loc Bartoletti
    http://coder.tuxfamily.org/

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Loc Bartoletti
    coder@tuxfamily.org
*/
/*! \mainpage Tiny_Tetris_SDL
 *
 * \section intro_sec Introduction
 *
 * Tiny_Tetris_SDL is a tiny and simple tetris coding in C and SDL/SDL_image/SDL_ttf libraries and without sound.<br>
 * The gameplay is based on http://fr.wikipedia.org/wiki/Tetris#Gameplay_d.C3.A9taill.C3.A9.<br>
 * SDL : 1.2.13<br>
 * SDL_ttf : 2.0.9<br>
 * SDL_image : 1.2.7<br>
 *
 * \section algo_sec Algorithm
 *
 * The game is purely graphical without matrix calcul.<br>
 * When there is color in tetronimo that's mind there is already block.<br>
 * So when a block move we check if it move on a black space.<br>
 *
 * \section game_sec The game
 *
 * Tetromino : 22 lines by 10 colones<br>
 * Speed : Max level speed : 15<br>
 * High score : Only the best. Calculate by points. Draw also level and total number of lines.<br>
 * Block : The same as original. Each block in each rotate position have an unique number ID.<br>
 *
 * \section change_sec Change Log
 *
 * - Change Fullscreen mode by argument (Tiny_Tetris_SDL --fullscreen/-f) or batch file include for windows<br>
 * - Add Level mode by argument (Tiny_Tetris_SDL -l XX/--level XX where XX is the level less than 15. -k/--keep-level to keep the define level for this session<br>
 *
 * \section copy_sec Copyrights
 *
 * <br>
 * <b> The game, icon and image is free under GPL license.</b>
 *
 *
 * Tiny_Tetris_SDL :  A tiny and simply Tetris with SDL<br>
 * Copyright (C) 2008-2009 Loc Bartoletti<br>
 * http://coder.tuxfamily.org/<br>
 *
 * This program is free software: you can redistribute it and/or modify<br>
 * it under the terms of the GNU General Public License as published by<br>
 * the Free Software Foundation, either version 3 of the License, or<br>
 * (at your option) any later version.<br>
 *
 * This program is distributed in the hope that it will be useful,<br>
 * but WITHOUT ANY WARRANTY; without even the implied warranty of<br>
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<br>
 * GNU General Public License for more details.<br>

 * You should have received a copy of the GNU General Public License<br>
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.<br>
 *
 *
 * Loc Bartoletti<br>
 * coder@tuxfamily.org<br>
 *
 * <br>
 * \b Font
 *
 *
 * Soviet Truetype Font for Windows version 2<br>
 *
 * 2003 Iconian Fonts - Daniel Zadorozny<br>
 *
 * http://www.iconian.com/<br>
 *
 * This font may be freely distributed and is free for all non-commercial uses.  This font is e-mailware; that is, if you like it, please e-mail the author at:<br>
 *
 * iconian@aol.com<br>
 *
 */

/*!
* \file main.c
* \brief Main and engine of Tiny_Tetris_SDL
* \author L. Bartoletti
* \version 1.3
* \date 08 March 2009
*/

#include "main.h"

/**
 * \ingroup A
 */

/**
 * \defgroup Global_variables Global variables
 */

/*@{*/
/** The main SDL_Surface for the screen */
SDL_Surface *global_ecran = NULL;

/** SDL_Surface for draw the next block */
SDL_Surface *prochBloc = NULL;

/** SDL_Surface for draw the current block */
SDL_Surface *curBloc = NULL;

/** Copy of main SDL_Surface screen to put the current block with is move on screen */
SDL_Surface *copy_ecran = NULL;

/** SDL_Rect The cordinate of the current block */
SDL_Rect position_ecran;

/** Number of the next block */
int nBloc;

/** Number of the current block */
int cBloc;

/** Number of points */
long points = 0;

/** Current level */
int niveau;

/** Defined level */
int level;

/** Keep or not the defined level in game */
int keepLevel;

/** Number of lines */
int nbLignes = 0;

/** Total number of lines */
int nbTotLignes = 0;

/** Variable to continue or not */
int continuer = 1;

/** Number of block defined **/
int nb_block_img_min, nb_block_img_max;
/*@}*/



/*!
* \fn int main (int argc, char *argv[])
* \brief the main.
* \param argc
* \param *argv[]
*/

int main (int argc, char *argv[])
{

    /** \code

    /* Variable to set or not fullscreen mode in argc/argv */
    int fullscreen;
    /* check if fullscreen send by arg */
    int fullscreen_bord_x, fullscreen_bord_y;

    int i;

    /* set parameters */
    keepLevel = 0;
    fullscreen = 0;
    fullscreen_bord_x = 0;
    fullscreen_bord_y = 0;
    niveau = level = 0;
    nb_block_img_min = 1;
    nb_block_img_max = 28;

    /* Don't forget to quit SDL_ttf */
    atexit(TTF_Quit);
    /* Don't forget to quit SDL */
    atexit(SDL_Quit);

    /* Initialize random */
    srand((unsigned)time(NULL));

    /* Call function to initialize SDL & SDL_ttf*/
    if (initialisationSDLetTTF() != EXIT_SUCCESS)
    {
        fprintf(stderr, "Echec lors de l'initialisation SDL.\n");
        exit (EXIT_FAILURE);
    }

    /* if program launched without args the GUI is created */
    if (argc == 1)
    {

        /* Call function to create the main window */
        if (creationFenetre(2) != EXIT_SUCCESS)
        {
            fprintf(stderr, "Echec lors de la cration de la Fentre.\n");
            exit (EXIT_FAILURE);
        }

        int start = 0;
        /* make the menu */


        SDL_Color couleurTexteJaune = {255, 255, 0, 0};
        int w_char_texte = 15;
        int h_char_texte = 37;
        /* Write title */
        writeTexte(global_ecran, "TINY TETRIS SDL", couleurTexteJaune, global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2, 0);
        /* Mode */
        writeTexte(global_ecran, "MODE", couleurTexteJaune, global_ecran->w/2-(strlen("MODE")*w_char_texte)/2, 50);
        writeTexte(global_ecran, "TINY", couleurTexteJaune, global_ecran->w/2-(strlen("TINY")*w_char_texte)/2, 100);
        writeTexte(global_ecran, "<", couleurTexteJaune, global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2, 50);
        writeTexte(global_ecran, ">", couleurTexteJaune, global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20, 50);
        /* Block */
        writeTexte(global_ecran, "BLOCK", couleurTexteJaune, global_ecran->w/2-(strlen("BLOCK")*w_char_texte)/2, 150);
        int block=0;
        writeTexte(global_ecran, "NORMAL", couleurTexteJaune, global_ecran->w/2-(strlen("NORMAL")*w_char_texte)/2, 200);
        writeTexte(global_ecran, "<", couleurTexteJaune, global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2, 150);
        writeTexte(global_ecran, ">", couleurTexteJaune, global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20, 150);
        /* Level */
        writeTexte(global_ecran, "LEVEL", couleurTexteJaune, global_ecran->w/2-(strlen("LEVEL")*w_char_texte)/2, 250);
        writeTexte(global_ecran, "0", couleurTexteJaune, global_ecran->w/2-(strlen("0")*w_char_texte)/2, 300);
        writeTexte(global_ecran, "<", couleurTexteJaune, global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2, 250);
        writeTexte(global_ecran, ">", couleurTexteJaune, global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20, 250);
        /* Keep level - ration button */
        writeTexte(global_ecran, "KEEP", couleurTexteJaune, global_ecran->w/2-(strlen("KEEP")*w_char_texte)/2, 350);
        /* Start */

        /* Write start */
        writeTexte(global_ecran, "START", couleurTexteJaune, 400, 400);
        /* Write title */


        SDL_Flip(global_ecran);
        /* menu loop */
        do
        {
            SDL_Event event;
            while (SDL_PollEvent(&event))
            {
                /* on regarde */
                switch (event.type)
                {
                case SDL_QUIT:
                    exit(1);
                    break;

                case SDL_MOUSEBUTTONUP:
                {

                    /* Mode */
                    if ((event.button.y >= 50) && (event.button.y <= 50 + h_char_texte ))
                    {
                        if ( (event.button.x >= global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2) && (event.button.x <= global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2 + strlen("<")*w_char_texte) )
                        {

                            if (fullscreen ==0)
                                fullscreen=2;
                            else fullscreen--;


                        }
                        else if ( (event.button.x >= global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20) && (event.button.x <= global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20 + strlen("<")*w_char_texte)  )
                        {

                            if (fullscreen ==2)
                                fullscreen=0;
                            else
                                fullscreen++;

                        }
                        SDL_Rect clear;
                        clear.y = 100;
                        clear.x = 0;
                        clear.h = h_char_texte;
                        clear.w = global_ecran->w;

                        SDL_FillRect(global_ecran, &clear, SDL_MapRGB(global_ecran->format, 0,0,0));
                        switch (fullscreen)
                        {

                        case 0:
                            writeTexte(global_ecran, "TINY", couleurTexteJaune, global_ecran->w/2-(strlen("TINY")*w_char_texte)/2, 100);
                            break;
                        case 1:
                            writeTexte(global_ecran, "FULLSCREEN", couleurTexteJaune, global_ecran->w/2-(strlen("FULLSCREEN")*w_char_texte)/2, 100);
                            break;
                        case 2:
                            writeTexte(global_ecran, "TINY 640x480", couleurTexteJaune, global_ecran->w/2-(strlen("TINY 640x480")*w_char_texte)/2, 100);
                            break;
                        default:
                            break;
                        }
                    }

                    /* Block */
                    if ((event.button.y >= 150) && (event.button.y <= 150 + h_char_texte ))
                    {
                        if ( (event.button.x >= global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2) && (event.button.x <= global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2 + strlen("<")*w_char_texte) )
                        {

                            if (block ==0)
                                block=2;
                            else block--;


                        }
                        else if ( (event.button.x >= global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20) && (event.button.x <= global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20 + strlen("<")*w_char_texte)  )
                        {

                            if (block ==2)
                                block=0;
                            else
                                block++;

                        }
                        SDL_Rect clear;
                        clear.y = 200;
                        clear.x = 0;
                        clear.h = h_char_texte;
                        clear.w = global_ecran->w;

                        SDL_FillRect(global_ecran, &clear, SDL_MapRGB(global_ecran->format, 0,0,0));
                        switch (block)
                        {


                        case 0:
                            nb_block_img_min = 1;
                            nb_block_img_max = 28;
                            writeTexte(global_ecran, "NORMAL", couleurTexteJaune, global_ecran->w/2-(strlen("NORMAL")*w_char_texte)/2, 200);
                            break;
                        case 1:
                            nb_block_img_min = 29;
                            nb_block_img_max = 52;
                            writeTexte(global_ecran, "V2", couleurTexteJaune, global_ecran->w/2-(strlen("V2")*w_char_texte)/2, 200);
                            break;
                        case 2:
                            nb_block_img_min = 1;
                            nb_block_img_max = 52;
                            writeTexte(global_ecran, "NORMAL + V2", couleurTexteJaune, global_ecran->w/2-(strlen("NORMAL + V2")*w_char_texte)/2, 200);
                            break;
                        default:
                            break;
                        }
                    }
                    /* Level */
                    if ((event.button.y >= 250) && (event.button.y <= 250 + h_char_texte ))
                    {
                        if ( (event.button.x >= global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2) && (event.button.x <= global_ecran->w/2-(strlen("TINY TETRIS SDL")*w_char_texte)/2 + strlen("<")*w_char_texte) )
                        {

                            if (level ==0)
                                level=15;
                            else level--;


                        }
                        else if ( (event.button.x >= global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20) && (event.button.x <= global_ecran->w/2+(strlen("TINY TETRIS SDL")*w_char_texte)/2-20 + strlen("<")*w_char_texte)  )
                        {

                            if (level ==15)
                                level=0;
                            else
                                level++;

                        }
                        niveau = level;
                        SDL_Rect clear;
                        clear.y = 300;
                        clear.x = 0;
                        clear.h = h_char_texte;
                        clear.w = global_ecran->w;

                        SDL_FillRect(global_ecran, &clear, SDL_MapRGB(global_ecran->format, 0,0,0));
                        char *lvl = malloc(3*sizeof(char*));
                        sprintf(lvl, "%d", level);
                        writeTexte(global_ecran, lvl, couleurTexteJaune, global_ecran->w/2-(strlen(lvl)*w_char_texte)/2, 300);


                    }
                    /* Keep level - like ration button */
                    if (((event.button.y >= 350) && (event.button.y <= 350 + h_char_texte )) && ((event.button.y >= global_ecran->w/2-(strlen("KEEP")*w_char_texte)) && (event.button.y <= global_ecran->w/2+(strlen("KEEP")*w_char_texte))))
                    {
                        if (keepLevel == 0)
                        {
                        SDL_Color couleurTexteBlanc = {255,255,255,0};
                        writeTexte(global_ecran, "KEEP", couleurTexteBlanc, global_ecran->w/2-(strlen("KEEP")*w_char_texte)/2, 350);
                        keepLevel = 1;
                        }
                        else
                        {
writeTexte(global_ecran, "KEEP", couleurTexteJaune, global_ecran->w/2-(strlen("KEEP")*w_char_texte)/2, 350);
                        keepLevel = 0;
                        }
                    }


                    /* Start */


                    if ( (event.button.x >= 400) && (event.button.x <= 400 + strlen("START")*w_char_texte) && (event.button.y >= 400) && (event.button.y <= 400 + h_char_texte ))
                    {
                        start = 1;
                    }

                }
                break;
                default:
                    break;
                }
            }
            SDL_Flip(global_ecran);
        }
        while (start != 1);

    }

    /* else if the program was launched with args */
    /* parse it */
    else
    {
        for (i = 1; i < argc; i++)
        {
            if ((strstr(argv[i], "--fullscreen")) || (strstr(argv[i], "-f")))
            {
                fullscreen_bord_x = FULLSCREEN_BORD_X;
                fullscreen_bord_y = FULLSCREEN_BORD_Y;

                fullscreen = 1;
            }
        }

        for (i = 1; i < argc; i++)
        {
            if ((strstr(argv[i], "--level")) || (strstr(argv[i], "-l")))
            {
                if (i+1 < argc)
                {
                    if ( (strtol(argv[i+1], NULL, 10) <= 15) && (strtol(argv[i+1], NULL, 10) >= 0))
                    {
                        level = niveau = (int)strtol(argv[i+1], NULL, 10);
                    }
                }
            }
        }

        for (i = 1; i < argc; i++)
        {
            if ((strstr(argv[i], "--keep-level")) || (strstr(argv[i], "-k")))
            {
                keepLevel = 1;
            }
        }


        for (i = 1; i < argc; i++)
        {
            if ((strstr(argv[i], "--block")) || (strstr(argv[i], "-b")))
            {
                if (i+1 < argc)
                {
                    if (strtol(argv[i+1], NULL, 10) == 1)
                    {
                        nb_block_img_min = 1;
                        nb_block_img_max = 28;
                    }
                    else if (strtol(argv[i+1], NULL, 10) == 2)
                    {
                        nb_block_img_min = 29;
                        nb_block_img_max = 52;
                    }
                    else if (strtol(argv[i+1], NULL, 10) == 3)
                    {
                        nb_block_img_min = 1;
                        nb_block_img_max = 52;
                    }
                }
            }
        }

    }



    /* Call function to create the main window */
    if (creationFenetre(fullscreen) != EXIT_SUCCESS)
    {
        fprintf(stderr, "Echec lors de la cration de la Fentre.\n");
        exit (EXIT_FAILURE);
    }

    /* Variable to exit or not the game. But why exit ? ;) */
    int quitte = 0;


    /* main loop */
    /* do game while exit... */
    do
    {

        /* clear screen */
        SDL_Rect clean;
        clean.x = clean.y = 0;
        clean.h = global_ecran->h;
        clean.w = global_ecran->w;
        SDL_FillRect(global_ecran, &clean, SDL_MapRGB(global_ecran->format, 0,0,0));
        SDL_Flip(global_ecran);


        /* call engine of game */
        moteur(fullscreen);


        /* after death... */
        /* pause and */
        /* wait until response */
        /* if key press is R : play */
        /* also : bye */
        SDL_Event event;
        unsigned int ticks = 500 + SDL_GetTicks();
        while (ticks != SDL_GetTicks())
        {
            while (SDL_PollEvent(&event));
        }
        if ( SDL_WaitEvent(&event))
        {

            if (event.key.keysym.sym == SDLK_r)
            {

                points = 0;
                if (keepLevel == 1)
                    niveau = level;
                else
                    niveau = 0;
                nbLignes = 0;
                nbTotLignes = 0;
                continuer = 1;
                quitte = 0;
            }
            else quitte = 1;
        }


    }
    while (quitte == 0);




    /* return true */
    return EXIT_SUCCESS;


    /** \endcode */

}


/*!
* \fn int initialisationSDLetTTF(void)
* \brief initialisation of SDL and SDL_TTF
*/
int initialisationSDLetTTF(void)
{

    /** \code

    /* return variable positionning on true */
    int retour = EXIT_SUCCESS;

    /* initialize SDL video */
    /* if false return = failure */
    if ( SDL_Init( SDL_INIT_VIDEO) < 0 )
    {
        fprintf(stderr, "Impossible d'initialiser la SDL: %s\n", SDL_GetError() );
        retour =  EXIT_FAILURE;
    }

    /* initialize SDL ttf */
    /* if false return = failure */
    if (TTF_Init() == -1)
    {
        fprintf(stderr, "Erreur d'initialisation de TTF_Init : %s\n", TTF_GetError());
        retour =  EXIT_FAILURE;
    }


    /* return the initilization : succes or failure */
    /* if failure : exit */
    return retour;


    /** \endcode */

}

/*!
* \fn int creationFenetre(int fullscreen)
* \brief Make test to create windows.
* \param fullscreen enable or disable variable for fullscreen mode
*/
int creationFenetre(int fullscreen)
{


    /** \code

    /* return variable positionning on true */
    int retour = EXIT_SUCCESS;

    /* load icon to SetIcon */
    SDL_Surface *icone = IMG_Load("data/tetris_sdl_icon.png");
    if (!icone)
    {
        #if(!WIN32)
        SDL_Surface *icone = IMG_Load("/usr/local/share/Tiny_Tetris_SDL/data/tetris_sdl_icon.png");
        if(!icone)
        {
            fprintf(stderr, "Impossible de charger l'image: %s\n", IMG_GetError());
            retour = EXIT_FAILURE;
        }
        #else
        fprintf(stderr, "Impossible de charger l'image: %s\n", IMG_GetError());
        retour = EXIT_FAILURE;
        #endif
    }

    /* Draw icon */
    SDL_WM_SetIcon(icone, NULL);

    /* make the main screen */
    if (fullscreen == 1)
    {
        global_ecran = SDL_SetVideoMode(640, 480, 32, SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN);
        if ( !global_ecran )
        {
            fprintf(stderr, "Impossible d'afficher en 640x480 video: %s\n", SDL_GetError());
            retour = EXIT_FAILURE;
        }
    }
    else if (fullscreen == 2)
    {
        global_ecran = SDL_SetVideoMode(640, 480, 32, SDL_HWSURFACE|SDL_DOUBLEBUF);
        if ( !global_ecran )
        {
            fprintf(stderr, "Impossible d'afficher en 640x480 video: %s\n", SDL_GetError());
            retour = EXIT_FAILURE;
        }
    }
    else
    {
        global_ecran = SDL_SetVideoMode(280, 170, 32, SDL_HWSURFACE|SDL_DOUBLEBUF);
        if ( !global_ecran )
        {
            fprintf(stderr, "Impossible d'afficher en 280x170 video: %s\n", SDL_GetError());
            retour = EXIT_FAILURE;
        }
    }

    /* write the Caption */
    SDL_WM_SetCaption ("Tiny_Tetris_SDL", NULL);


    /* Flip me */
    SDL_Flip(global_ecran);

    /* Free icone SDL_Surface */
    SDL_FreeSurface(icone);



    /* return the initilization : succes or failure */
    /* if failure : exit */
    return retour;


    /** \endcode */
}


/*!
* \fn void moteur(int fullscreen)
* \brief Engine of the game
* \param fullscreen enable or disable variable for fullscreen mode
*/
void moteur(int fullscreen)
{


    /** \code
    /** in case of fullscreen make correction */
    int fullscreen_bord_x, fullscreen_bord_y;
    if (fullscreen == 1)
    {
        fullscreen_bord_x = FULLSCREEN_BORD_X;
        fullscreen_bord_y = FULLSCREEN_BORD_Y;

        SDL_ShowCursor(SDL_DISABLE);
    }
    else
    {
        fullscreen_bord_x = 0;
        fullscreen_bord_y = 0;
    }
    /* Variables for the block */
    SDL_Rect posBloc;

    /* coordinate of the block at start */
    posBloc.x = BORD_X + (NB_COL/2)*BLOC + fullscreen_bord_x;
    posBloc.y = BORD_Y + fullscreen_bord_y;

    /* random the current and the next block */
    cBloc = (int)(nb_block_img_min + ((double) rand() * (nb_block_img_max- nb_block_img_min) / RAND_MAX));

    nBloc = (int)(nb_block_img_min + ((double) rand() * (nb_block_img_max- nb_block_img_min) / RAND_MAX));



    /* load image of the randomize block */
    prochBloc = chargeIMG(nBloc);
    curBloc = chargeIMG(cBloc);

    /* draw the interface : tetronimo and next bloc */
    dessineInterface(global_ecran, fullscreen);
    posProchBloc(global_ecran, prochBloc, fullscreen);


    /* load variable for block down delay */
    Uint32 ticks=-DELAY,ticks_keys=0;

    /* Enable Key Repeat with default value */
    SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);

    /* make a screen copy to refresh screen */
    copy_ecran = SDL_CreateRGBSurface(SDL_HWSURFACE, global_ecran->w, global_ecran->h, 32, 0, 0, 0, 0);
    position_ecran.x = position_ecran.y = 0;
    SDL_BlitSurface(global_ecran, NULL, copy_ecran, &position_ecran);


    /* write informations */
    affichage(global_ecran, niveau, nbLignes, points, fullscreen);
    affichBest(global_ecran);


    /* main engine loop */
    while (continuer)
    {

        /* check the time */
        /* if time is down block down alone */
        /* if your in time you can move block */
        if (SDL_GetTicks() >= ticks_keys+DELAY_KEYS)
        {
            ticks_keys = SDL_GetTicks() ;
            posBloc = actionTouche(posBloc, fullscreen);
        }
        if (SDL_GetTicks() >= ticks+DELAY)
        {
            if ((niveau*SPEED_FACTOR) >= DELAY)
                ticks = SDL_GetTicks()-DELAY;
            else
                ticks = SDL_GetTicks() - (niveau*SPEED_FACTOR);

            /* down the Bloc */
            posBloc = VerifSiBlocBouge(posBloc,  0, 1, fullscreen);

        }

        /* Flip me */
        SDL_Flip(global_ecran);
    }


    /* Draw the game over */
    gameOver(global_ecran, points, nbTotLignes, niveau);
    SDL_Flip(global_ecran);

    /* pause */
    SDL_Delay(2000);




    /** \endcode */


}

/*!
* \fn SDL_Rect actionTouche(SDL_Rect posBloc, int fullscreen)
* \brief check of handle event
* \param posBloc the position of bloc for calcul
* \param fullscreen enable or disable variable for fullscreen mode
*/
SDL_Rect actionTouche(SDL_Rect posBloc, int fullscreen)
{



    /** \code
    /** in case of fullscreen make correction */
    int fullscreen_bord_x, fullscreen_bord_y;
    if (fullscreen == 1)
    {
        fullscreen_bord_x = FULLSCREEN_BORD_X;
        fullscreen_bord_y = FULLSCREEN_BORD_Y;
    }
    else
    {
        fullscreen_bord_x = 0;
        fullscreen_bord_y = 0;
    }
    /* catch event */
    SDL_Event event;
    while ( SDL_PollEvent(&event) )
    {

        switch (event.type)
        {

            /* quit = ... quit ... */
        case SDL_QUIT:
            exit(0);
            break;

        case SDL_KEYDOWN:
            switch (event.key.keysym.sym)
            {
                /* left : check if you can move left and move*/
            case SDLK_LEFT:
                posBloc = VerifSiBlocBouge(posBloc,  -1, 0, fullscreen);
                break;
                /* left : check if you can move right and move */
            case SDLK_RIGHT:
                posBloc = VerifSiBlocBouge(posBloc,  1, 0, fullscreen);
                break;
                /* left : check if you can move down and move */
            case SDLK_DOWN:
                posBloc = VerifSiBlocBouge(posBloc,  0, 1, fullscreen);
                break;
                /* left : check if you can move down on the block and move */
                /* do while the block down */
            case SDLK_SPACE:
                do
                {
                    posBloc = VerifSiBlocBouge(posBloc,  0, 1, fullscreen);
                }
                while (posBloc.y != BORD_Y + fullscreen_bord_y);
                break;
                /* up : check if you can rotate */
                /* load image */
                /* there is 4 images/blocks so a little calcul is need */
            case SDLK_UP:
                if (cBloc % 4 == 0)
                {
                    int retour;
                    retour = VerifSiBlocTourne(posBloc, cBloc, cBloc - 3);
                    if (retour == 1)
                    {
                        cBloc -=3;
                    }
                }
                else
                {
                    int retour;
                    retour = VerifSiBlocTourne(posBloc, cBloc, cBloc + 1);
                    if (retour == 1)
                    {
                        cBloc += 1;
                    }
                }

                break;
                /* p : pause */
            case SDLK_p:
                /* when press for first time : write "pause" */
                pause(global_ecran, 1, fullscreen);
                SDL_Flip(global_ecran);
                while (1)
                {
                    if (SDL_PollEvent(&event))
                    {
                        /* when press the second time : unwrite "pause" */
                        if (event.type == SDL_KEYDOWN)
                        {
                            pause(global_ecran, 0, fullscreen);
                            break;
                        }
                    }
                }
                break;
                /* r : restart */
            case SDLK_r:
                continuer = 0;
                break;
                /* quit...*/
            case SDLK_ESCAPE:
                exit(0);
                break;
            default:
                break;
            }

        default:
            break;

        }

    }
    /* return the position of the block after moving */
    return posBloc;


    /** \endcode */
}

/*!
* \fn SDL_Rect VerifSiBlocBouge(SDL_Rect posBloc, int x, int y, int fullscreen)
* \brief check if the bloc can move and send its position in return
* \param x Coordinate x of moving
* \param y Coordinate y of moving
* \param posBloc the position of bloc for calcul
* \param fullscreen enable or disable variable for fullscreen mode
*/
SDL_Rect VerifSiBlocBouge(SDL_Rect posBloc, int x, int y, int fullscreen)
{

    /** \code
    /** in case of fullscreen make correction */
    int fullscreen_bord_x, fullscreen_bord_y;
    if (fullscreen == 1)
    {
        fullscreen_bord_x = FULLSCREEN_BORD_X;
        fullscreen_bord_y = FULLSCREEN_BORD_Y;
    }
    else
    {
        fullscreen_bord_x = 0;
        fullscreen_bord_y = 0;
    }

    /* Variables for check pixel color on screen and current block */
    Uint32 pixBloc, pixEcran;
    Uint8 rEcran, gEcran, bEcran;
    Uint8 rBloc, gBloc, bBloc;
    int posX, posY;
    int xm, ym;
    posX = posBloc.x;
    posY = posBloc.y;
    int posBX, posBY;
    posBX = 0;
    posBY = 0;
    int result = 1;
    int sEcran, sBloc;


    /* undraw the screen where there are colored pixels on blocks */

    for (xm = 0; xm < curBloc->w; xm++)
    {
        for (ym = 0; ym < curBloc->h; ym++)
        {
            /* check if the pixel is colored */
            pixBloc = getpixel(curBloc, posBX+xm, posBY+ym);
            SDL_GetRGB(pixBloc, curBloc->format, &rBloc, &gBloc, &bBloc);
            sBloc = rBloc + gBloc + bBloc;

            /* if colored (not black) */
            if (sBloc != 0)
            {
                /* I wanna see it painted, painted, painted, painted black */
                /* Yeah! */
                /* (c) Rolling Stones */
                putpixel(global_ecran, posX+xm, posY+ym, SDL_MapRGB(global_ecran->format, 0, 0, 0));
            }
        }
    }


    /* Set position of block */
    posX = posBloc.x + x*BLOC;
    posY = posBloc.y + y*BLOC;

    /* check each pixel of block on the screen */
    for (xm = 0; xm < curBloc->w; xm++)
    {
        for (ym = 0; ym < curBloc->h; ym++)
        {

            /* get pixel of block and screen on the same coordinate */
            pixEcran = getpixel(global_ecran, posX+xm, posY+ym);
            pixBloc = getpixel(curBloc, posBX+xm, posBY+ym);
            SDL_GetRGB(pixEcran, global_ecran->format, &rEcran, &gEcran, &bEcran);
            SDL_GetRGB(pixBloc, curBloc->format, &rBloc, &gBloc, &bBloc);

            /* add value r, g, b */
            /* 0 is black other values is colored */
            sEcran = rEcran + gEcran + bEcran;
            sBloc = rBloc + gBloc + bBloc;


            /* if block is colored and screen too */
            /* you can't move */
            if ((sBloc != 0) && (sEcran != 0))
            {
                result = 0;
            }
        }
    }

    /* if you can't move */
    if (result == 0)
    {

        /* redraw the block */
        SDL_BlitSurface(global_ecran, NULL, copy_ecran, &position_ecran);
        SDL_BlitSurface(curBloc, NULL, global_ecran, &posBloc);

        /* if was a down */
        if (y == 1)
        {


            /* check if there are fulled lines */
            int nbLigneSuit = VerifLigne(global_ecran, fullscreen);
            SDL_BlitSurface(global_ecran, NULL, copy_ecran, &position_ecran);


            /* add points */
            /* the system of points is : */
            /* f(p, n)= p(n+1) */
            /* p : point of line */
            /* n : level */
            switch (nbLigneSuit)
            {
            case 1:
                points += (40 * (niveau +1));
                break;
            case 2:
                points += (100 * (niveau +1));
                break;
            case 3:
                points += (300 * (niveau +1));
                break;
            case 4:
                points += (1200 * (niveau +1));
                break;
            default:
                break;
            }

            /* add some stats */
            nbLignes += nbLigneSuit;
            nbTotLignes += nbLigneSuit;

            /* each 10 lines we access a new level */
            if (nbLignes >= 10)
            {
                niveau += 1;
                nbLignes -= 10;
            }


            /* redraw stat */
            affichage(global_ecran, niveau, nbLignes, points, fullscreen);

            /* New block */
            /* set values of next block */
            SDL_Rect cadre;
            cadre.x = BORD_X + NB_COL*BLOC + ESPACE + BLOC + BLOC + fullscreen_bord_x;
            cadre.y = BORD_Y + BLOC + fullscreen_bord_y;
            cadre.w = BLOC * 6;
            cadre.h = BLOC * 5;
            /* clear the frame of next block */
            SDL_FillRect(global_ecran, &cadre, SDL_MapRGB(global_ecran->format, 0, 0, 0));

            /* set value of next current block */
            posBloc.x = BORD_X + (NB_COL/2)*BLOC + fullscreen_bord_x;
            posBloc.y = BORD_Y + fullscreen_bord_y;

            /* the current block is now the ex new block */
            cBloc = nBloc;

            /* random a futur block */
            nBloc = (int)(nb_block_img_min + ((double) rand() * (nb_block_img_max- nb_block_img_min) / RAND_MAX));


            /* load image of the next block and draw it */
            prochBloc = chargeIMG(nBloc);
            posProchBloc(global_ecran, prochBloc, fullscreen);

            /* load the current block */
            curBloc = chargeIMG(cBloc);


            /* after load the current block check if the game can continue */
            if (verifGameOver(global_ecran, curBloc, posBloc) == 0)
            {
                continuer = 0;
            }
        }

    }

    /* else if you can move */
    else
    {

        /* set values of moving */
        posBloc.x += x*BLOC;
        posBloc.y += y*BLOC;

        /* draw the block at new position */
        SDL_BlitSurface(global_ecran, NULL, copy_ecran, &position_ecran);
        SDL_BlitSurface(curBloc, NULL, global_ecran, &posBloc);
    }


    /* free copy_ecran */
    copy_ecran = NULL;
    /* return the position of current block */
    return posBloc;


    /** \endcode */
}

/*!
* \fn int VerifSiBlocTourne(SDL_Rect posBloc, int numCurBloc, int numBloc)
* \brief check if the bloc can rotate and send it in return
* \param posBloc the position of bloc for calcul
* \param numCurBloc The image number of current bloc
* \param numBloc The image number of the probably next current bloc
*/
int VerifSiBlocTourne(SDL_Rect posBloc, int numCurBloc, int numBloc)
{


    /** \code


    /* return variable positionning on true */
    int ret;


    /* Variables for check pixel color on screen and current block */
    int x,y;
    Uint32 pixBloc, pixEcran;
    Uint8 rEcran, gEcran, bEcran;
    Uint8 rBloc, gBloc, bBloc;
    int posX, posY;
    posX = posBloc.x;
    posY = posBloc.y;
    int posBX, posBY;
    posBX = 0;
    posBY = 0;
    int result = 1;
    int sEcran, sBloc;


    /* undraw the screen where there are colored pixels on blocks */

    for (x = 0; x < curBloc->w; x++)
    {
        for (y = 0; y < curBloc->h; y++)
        {
            /* check if the pixel is colored */
            pixBloc = getpixel(curBloc, posBX+x, posBY+y);
            SDL_GetRGB(pixBloc, curBloc->format, &rBloc, &gBloc, &bBloc);
            sBloc = rBloc + gBloc + bBloc;

            /* if colored (not black) */
            if (sBloc != 0)
            {
                /* I wanna see it painted, painted, painted, painted black */
                /* Yeah! */
                /* (c) Rolling Stones */
                putpixel(global_ecran, posX+x, posY+y, SDL_MapRGB(global_ecran->format, 0, 0, 0));
            }
        }
    }

    /* load image of the hypothetic futur rotated block for test */
    curBloc = chargeIMG(numBloc);

    /* check each pixel of block on the screen */

    for (x = 0; x < curBloc->w; x++)
    {
        for (y = 0; y < curBloc->h; y++)
        {
            /* get pixel of block and screen on the same coordinate */
            pixEcran = getpixel(global_ecran, posX+x, posY+y);
            pixBloc = getpixel(curBloc, posBX+x, posBY+y);
            SDL_GetRGB(pixEcran, global_ecran->format, &rEcran, &gEcran, &bEcran);
            SDL_GetRGB(pixBloc, curBloc->format, &rBloc, &gBloc, &bBloc);

            /* add value r, g, b */
            /* 0 is black other values is colored */
            sEcran = rEcran + gEcran + bEcran;
            sBloc = rBloc + gBloc + bBloc;


            /* if block is colored and screen too */
            /* you can't move */
            if ((sBloc != 0) && (sEcran != 0))
            {
                result = 0;
            }
        }
    }

    /* if you can't rotate */
    if (result == 0)
    {

        /* reload the current image of block */
        curBloc = chargeIMG(numCurBloc);


        /* and redraw it */
        SDL_BlitSurface(global_ecran, NULL, copy_ecran, &position_ecran);
        SDL_BlitSurface(curBloc, NULL, global_ecran, &posBloc);
        /* return : you can't rotate */
        ret = 0;
    }
    /* if you can rotate */
    else
    {
        /* draw the rotated block */
        SDL_BlitSurface(global_ecran, NULL, copy_ecran, &position_ecran);
        SDL_BlitSurface(curBloc, NULL, global_ecran, &posBloc);
        /* return : you can rotate */
        ret = 1;
    }


    /* free copy_ecran */
    copy_ecran = NULL;
    /* return if you can or not rotate */
    return ret;


    /** \endcode */
}
