// gcc hello.c -lmui
#ifdef __AROS__
#include <clib/boopsistubs.h>
#endif
#include <exec/types.h> 
#include <libraries/mui.h>    
#include <libraries/asl.h>     
#include <proto/exec.h>     
#include <proto/intuition.h>
#include <proto/graphics.h>     
#include <proto/muimaster.h>
#include <proto/exec.h>
#include <exec/tasks.h>
     
     int main(void)
     {
         Object *wnd, *app, *but;
     
         // GUI creation
         app = ApplicationObject,
             SubWindow, wnd = WindowObject,
                 MUIA_Window_Title, "Hello world!",
                 WindowContents, VGroup,
                     Child, TextObject,
                         MUIA_Text_Contents, "\33cHello world!\nHow are you?",
                         End,
                     Child, but = SimpleButton("_Ok"),
                     End,
                 End,
             End;
     
         if (app != NULL)
         {
             ULONG sigs = 0;
     
             // Click Close gadget or hit Escape to quit
             DoMethod(wnd, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
                      (IPTR)app, 2,
                      MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
     
             // Click the button to quit
             DoMethod(but, MUIM_Notify, MUIA_Pressed, FALSE,
                      (IPTR)app, 2,
                      MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
     
             // Open the window
             set(wnd, MUIA_Window_Open, TRUE);
     
             // Check that the window opened
             if (XGET(wnd, MUIA_Window_Open))
             {
                 // Main loop
                 while((LONG)DoMethod(app, MUIM_Application_NewInput, (IPTR)&sigs)
                       != MUIV_Application_ReturnID_Quit)
                 {
                     if (sigs)
                     {
                         sigs = Wait(sigs | SIGBREAKF_CTRL_C);
                         if (sigs & SIGBREAKF_CTRL_C)
                             break;
                     }
                 }
             }
             // Destroy our application and all its objects
             MUI_DisposeObject(app);
         }
         
         return 0;
     }
