/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IF = 258,
     THEN = 259,
     ELSE = 260,
     ON = 261,
     GOTO = 262,
     GOSUB = 263,
     RETURN = 264,
     LET = 265,
     INPUT = 266,
     PRINT = 267,
     READ = 268,
     DATA = 269,
     DIM = 270,
     FOR = 271,
     TO = 272,
     NEXT = 273,
     STEP = 274,
     END = 275,
     STOP = 276,
     REM = 277,
     RESTORE = 278,
     INT = 279,
     FIX = 280,
     SGN = 281,
     SIN = 282,
     COS = 283,
     RND = 284,
     POW = 285,
     LOG = 286,
     EXP = 287,
     TAN = 288,
     ATN2 = 289,
     ATN = 290,
     ABS = 291,
     SQR = 292,
     LEN = 293,
     LEFTSTR = 294,
     MIDSTR = 295,
     RIGHTSTR = 296,
     CHRSTR = 297,
     STRSTR = 298,
     STRINGSTR = 299,
     VAL = 300,
     ASC = 301,
     TAB = 302,
     MOUSEX = 303,
     MOUSEY = 304,
     MOUSEB = 305,
     XSIZE = 306,
     YSIZE = 307,
     TICKS = 308,
     KEY = 309,
     KEYCODE = 310,
     INKEYSTR = 311,
     MOVE = 312,
     PEN = 313,
     LINE = 314,
     COLOR = 315,
     CLEAR = 316,
     RANDOM = 317,
     CLS = 318,
     FILL = 319,
     HOME = 320,
     CIRCLE = 321,
     DISC = 322,
     TEST = 323,
     BOX = 324,
     RECT = 325,
     SLEEP = 326,
     SPOT = 327,
     UPDATE = 328,
     INTEGER = 329,
     REAL = 330,
     NUMSYMBOL = 331,
     STRINGSYMBOL = 332,
     STRING = 333,
     ARC = 334,
     WEDGE = 335,
     SHINIT = 336,
     SHDONE = 337,
     SHEND = 338,
     SHLINE = 339,
     SHCURVE = 340,
     SHCUBIC = 341,
     ROUND = 342,
     ROTATE = 343,
     LF = 344,
     TONE = 345,
     ADSR = 346,
     WAVE = 347,
     FREQ = 348,
     DUR = 349,
     FMUL = 350,
     VOL = 351,
     WSIN = 352,
     WSQR = 353,
     WTRI = 354,
     WSAW = 355,
     QUIET = 356,
     NOTE = 357,
     OROR = 358,
     ANDAND = 359,
     GE = 360,
     LE = 361,
     GT = 362,
     LT = 363,
     NE = 364,
     XOR = 365,
     OR = 366,
     AND = 367,
     LL = 368,
     RR = 369,
     MOD = 370,
     POWER = 371,
     UNARY = 372
   };
#endif
#define IF 258
#define THEN 259
#define ELSE 260
#define ON 261
#define GOTO 262
#define GOSUB 263
#define RETURN 264
#define LET 265
#define INPUT 266
#define PRINT 267
#define READ 268
#define DATA 269
#define DIM 270
#define FOR 271
#define TO 272
#define NEXT 273
#define STEP 274
#define END 275
#define STOP 276
#define REM 277
#define RESTORE 278
#define INT 279
#define FIX 280
#define SGN 281
#define SIN 282
#define COS 283
#define RND 284
#define POW 285
#define LOG 286
#define EXP 287
#define TAN 288
#define ATN2 289
#define ATN 290
#define ABS 291
#define SQR 292
#define LEN 293
#define LEFTSTR 294
#define MIDSTR 295
#define RIGHTSTR 296
#define CHRSTR 297
#define STRSTR 298
#define STRINGSTR 299
#define VAL 300
#define ASC 301
#define TAB 302
#define MOUSEX 303
#define MOUSEY 304
#define MOUSEB 305
#define XSIZE 306
#define YSIZE 307
#define TICKS 308
#define KEY 309
#define KEYCODE 310
#define INKEYSTR 311
#define MOVE 312
#define PEN 313
#define LINE 314
#define COLOR 315
#define CLEAR 316
#define RANDOM 317
#define CLS 318
#define FILL 319
#define HOME 320
#define CIRCLE 321
#define DISC 322
#define TEST 323
#define BOX 324
#define RECT 325
#define SLEEP 326
#define SPOT 327
#define UPDATE 328
#define INTEGER 329
#define REAL 330
#define NUMSYMBOL 331
#define STRINGSYMBOL 332
#define STRING 333
#define ARC 334
#define WEDGE 335
#define SHINIT 336
#define SHDONE 337
#define SHEND 338
#define SHLINE 339
#define SHCURVE 340
#define SHCUBIC 341
#define ROUND 342
#define ROTATE 343
#define LF 344
#define TONE 345
#define ADSR 346
#define WAVE 347
#define FREQ 348
#define DUR 349
#define FMUL 350
#define VOL 351
#define WSIN 352
#define WSQR 353
#define WTRI 354
#define WSAW 355
#define QUIET 356
#define NOTE 357
#define OROR 358
#define ANDAND 359
#define GE 360
#define LE 361
#define GT 362
#define LT 363
#define NE 364
#define XOR 365
#define OR 366
#define AND 367
#define LL 368
#define RR 369
#define MOD 370
#define POWER 371
#define UNARY 372




/* Copy the first part of user declarations.  */
#line 1 "grammar.y"

/*
   SDL_basic written by David Ashley, released 20080621 under the GPL
   http://www.linuxmotors.com/SDL_basic
   dashxdr@gmail.com
*/


#include <ctype.h>
#include <stdarg.h>
#include "misc.h"

#define NAMELEN 16

typedef struct tokeninfo {
	char *at;
	union
	{
		double real;
		char *start;
		int integer;
		char name[NAMELEN];
		char string[256];
		int count;
		step *step;
		void *pointer;
	} value;
} tokeninfo;

typedef struct {
	int stepoff;
	char *at;
} lineref;


#define MAXSTEPS 100000
#define MAXLINEREFS 65536
typedef struct parse_state {
	bc *bc;
	int res;
	char *yypntr;
	char *yystart;
	char *yylast;
	step *nextstep;
	step steps[MAXSTEPS];
	int numlinerefs;
	variable *rankfailure;
	char errormsg[128];
	char *errorpos;
	lineref linerefs[MAXLINEREFS];
} ps;

static void rankcheck(ps *ps, int var, int rank);

static void addlineref(ps *ps, char *at)
{
	ps->linerefs[ps->numlinerefs].at = at;
	ps->linerefs[ps->numlinerefs++].stepoff = ps->nextstep - ps->steps;
}

static void addline(ps *ps, int number, int stepnum, char *at)
{
bc *bc = ps->bc;
	bc->lm[bc->numlines].step = stepnum;
	bc->lm[bc->numlines].src = at;
	bc->lm[bc->numlines++].linenumber = number;
}

static void adddata(ps *ps, double v)
{
	if(ps->bc->datanum < MAXDATA)
		ps->bc->data[ps->bc->datanum++] = v;
}

// returns linemap associated with this line
static linemap *findlinemap(ps *ps, int want)
{
int low, high, mid;
bc *bc=ps->bc;
	low = 0;
	high=bc->numlines;
	if(!high) return 0;
	for(;;)
	{
		mid = (low+high) >> 1;
		if(mid==low) break;
		if(want < bc->lm[mid].linenumber)
			high=mid;
		else
			low=mid;
	}
	if(want == bc->lm[mid].linenumber)
		return bc->lm + mid;
	else
		return 0;
}

// returns program step associated with this line
static int findline(ps *ps, int want)
{
linemap *lm;
	lm = findlinemap(ps, want);
	if(!lm)
		return -1;
	else
		return lm->step;
}

void seterror(ps *ps, char *p, char *msg, ...)
{
va_list ap;
	va_start(ap, msg);
	vsnprintf(ps->errormsg, sizeof(ps->errormsg), msg, ap);
	va_end(ap);
	ps->errorpos = p;
}

#define MAX (sizeof(int)*8/MODIFIER_BITS - 1)
int append_modifier(ps *ps, char *pos, int oldvalue, int toadd)
{
int i;
int t;
char *p;

	for(i=0;i<MAX;++i)
	{
		t=(oldvalue >> (i*MODIFIER_BITS)) & ((1<<MODIFIER_BITS)-1);
		if(t == toadd)
		{
			if(toadd == RENDER_ROUND) p="ROUND";
			else if(toadd == RENDER_ROTATE) p="ROTATE";
			else p="";
			seterror(ps, pos, "Duplicate modifier %s", p);
			break;
		}
	}
	if(i==MAX)
		oldvalue = (oldvalue<<MODIFIER_BITS) | toadd;
	return oldvalue;
}


static int fixuplinerefs(ps *ps)
{
bc *bc=ps->bc;
int i;
int o;
int at;
int line;

	for(i=0;i<ps->numlinerefs;++i)
	{
		o=ps->linerefs[i].stepoff;
		at=findline(ps, ps->steps[o+1].i);
		if(at<0)
		{
			for(line=0;line<bc->numlines;++line)
				if(bc->lm[line].step > o)
					break;
			tprintf(ps->bc,
				"Unresolved line reference on line %d\n",
				bc->lm[line-1].linenumber);
			return -1;
		}
		ps->steps[o+1].i = at - o;
	}
	return 0;
}


static void emitfunc(ps *ps, void (*func)())
{
	ps->nextstep++ -> func = func;
}

static void emitint(ps *ps, int i)
{
	ps->nextstep++ -> i = i;
}

static void emitfuncint(ps *ps, void (*func)(), int v)
{
	emitfunc(ps, func);
	emitint(ps, v);
}

static void emitdouble(ps *ps, double val)
{
	ps->nextstep++ -> d = val;
}

static void emitpushd(ps *ps, double val)
{
	emitfunc(ps, pushd);
	emitdouble(ps, val);
}

static void emitpushs(ps *ps, char *s)
{
int len=strlen(s);
step ts;
int i;
	emitfunc(ps, pushs);
	i=0;
	ts.str[i++]=len;
	do
	{
		if(*s)
			ts.str[i++] = *s++;
		if(i==STEPSIZE || !*s)
		{
			while(i<STEPSIZE)
				ts.str[i++] = 0;
			*ps->nextstep++ = ts;
			i=0;
		}
	} while(*s);
}

#define YYDEBUG 0
#define YYSTYPE tokeninfo

#define PS ((ps *)parm)


#define YYPARSE_PARAM parm
#define YYLEX_PARAM parm

int yylex(YYSTYPE *lvalp, ps *parm);
void yyerror(char *s);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
typedef int YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 553 "parse.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  164
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1607

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  130
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  60
/* YYNRULES -- Number of rules. */
#define YYNRULES  214
/* YYNRULES -- Number of states. */
#define YYNSTATES  404

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   372

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     126,   127,   118,   116,   124,   117,     2,   119,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   123,   128,
       2,   105,     2,   125,   129,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     120,   121,   122
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    10,    13,    19,    21,
      23,    27,    34,    44,    47,    50,    52,    55,    58,    60,
      62,    65,    68,    71,    73,    75,    78,    81,    83,    86,
      89,    93,    96,    99,   103,   105,   107,   109,   112,   115,
     118,   120,   122,   130,   133,   136,   138,   140,   145,   150,
     153,   156,   159,   162,   166,   168,   170,   173,   175,   176,
     178,   180,   183,   186,   189,   190,   192,   194,   195,   197,
     200,   204,   207,   209,   212,   215,   218,   221,   223,   225,
     227,   229,   231,   233,   234,   235,   236,   237,   240,   241,
     243,   245,   247,   249,   250,   252,   254,   258,   264,   272,
     282,   294,   296,   298,   300,   304,   309,   314,   316,   320,
     322,   326,   328,   332,   334,   336,   338,   340,   342,   346,
     348,   350,   352,   357,   359,   364,   366,   370,   371,   373,
     377,   380,   382,   384,   387,   389,   391,   395,   401,   403,
     407,   409,   413,   415,   417,   421,   425,   428,   432,   436,
     440,   444,   448,   452,   456,   460,   464,   468,   472,   476,
     480,   484,   488,   492,   496,   500,   504,   508,   512,   514,
     516,   518,   520,   524,   527,   530,   533,   536,   539,   542,
     545,   548,   551,   554,   557,   560,   563,   566,   569,   572,
     575,   578,   581,   584,   586,   588,   590,   592,   594,   596,
     598,   600,   602,   606,   609,   611,   613,   615,   617,   620,
     627,   634,   643,   646,   649
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     131,     0,    -1,    -1,   132,    -1,   135,    -1,   133,    -1,
     132,   133,    -1,   148,   134,   148,   135,    89,    -1,    74,
      -1,   136,    -1,   135,   123,   136,    -1,     3,   182,   153,
     146,   152,   148,    -1,     3,   182,   153,   146,   152,     5,
     147,   152,   148,    -1,     7,    74,    -1,    10,   181,    -1,
     181,    -1,   145,   173,    -1,    15,   161,    -1,    20,    -1,
      21,    -1,    71,   154,    -1,    58,   154,    -1,    60,   160,
      -1,    63,    -1,    65,    -1,    66,   156,    -1,    67,   156,
      -1,    64,    -1,    57,   155,    -1,    59,   155,    -1,    69,
     157,   137,    -1,    79,   158,    -1,    80,   159,    -1,    70,
     157,   137,    -1,    81,    -1,    82,    -1,    83,    -1,    84,
     155,    -1,    85,   157,    -1,    86,   159,    -1,    72,    -1,
      73,    -1,    16,   151,   105,   182,    17,   182,   149,    -1,
      18,   150,    -1,     8,    74,    -1,     9,    -1,    22,    -1,
       6,   182,     7,   164,    -1,     6,   182,     8,   164,    -1,
      11,   178,    -1,    13,   168,    -1,    14,   165,    -1,   101,
     140,    -1,    90,   141,   142,    -1,    62,    -1,    23,    -1,
      61,   154,    -1,    68,    -1,    -1,   138,    -1,   139,    -1,
     138,   139,    -1,    87,   182,    -1,    88,   182,    -1,    -1,
     182,    -1,   182,    -1,    -1,   143,    -1,   124,   144,    -1,
     143,   124,   144,    -1,    91,   187,    -1,    92,    -1,    93,
     182,    -1,    94,   182,    -1,    96,   182,    -1,    95,   182,
      -1,    97,    -1,    99,    -1,    98,    -1,   100,    -1,    12,
      -1,   125,    -1,    -1,    -1,    -1,    -1,    19,   182,    -1,
      -1,   151,    -1,    76,    -1,   135,    -1,    74,    -1,    -1,
       4,    -1,   182,    -1,   182,   124,   182,    -1,   182,   124,
     182,   124,   182,    -1,   182,   124,   182,   124,   182,   124,
     182,    -1,   182,   124,   182,   124,   182,   124,   182,   124,
     182,    -1,   182,   124,   182,   124,   182,   124,   182,   124,
     182,   124,   182,    -1,   156,    -1,   157,    -1,   162,    -1,
     161,   124,   162,    -1,    76,   126,   163,   127,    -1,    77,
     126,   163,   127,    -1,    74,    -1,   163,   124,    74,    -1,
      74,    -1,   164,   124,    74,    -1,   166,    -1,   165,   124,
     166,    -1,   167,    -1,    78,    -1,    74,    -1,    75,    -1,
     169,    -1,   168,   124,   169,    -1,   170,    -1,   171,    -1,
      76,    -1,    76,   126,   172,   127,    -1,    77,    -1,    77,
     126,   172,   127,    -1,   182,    -1,   172,   124,   182,    -1,
      -1,   175,    -1,   173,   174,   175,    -1,   173,   174,    -1,
     128,    -1,   124,    -1,   129,   182,    -1,   182,    -1,   187,
      -1,   126,   182,   127,    -1,   126,   182,   124,   182,   127,
      -1,   179,    -1,    78,   128,   179,    -1,   180,    -1,   179,
     124,   180,    -1,   170,    -1,   171,    -1,   170,   105,   182,
      -1,   171,   105,   187,    -1,   117,   182,    -1,   126,   182,
     127,    -1,   182,   116,   182,    -1,   182,   117,   182,    -1,
     182,   118,   182,    -1,   182,   119,   182,    -1,   182,   121,
     182,    -1,   182,   114,   182,    -1,   182,   115,   182,    -1,
     182,   105,   182,    -1,   182,   110,   182,    -1,   182,   109,
     182,    -1,   182,   108,   182,    -1,   182,   107,   182,    -1,
     182,   106,   182,    -1,   182,   113,   182,    -1,   182,   112,
     182,    -1,   182,   111,   182,    -1,   182,   104,   182,    -1,
     182,   103,   182,    -1,   187,   105,   187,    -1,   187,   110,
     187,    -1,   184,    -1,   185,    -1,   170,    -1,   167,    -1,
     126,   187,   127,    -1,    24,   176,    -1,    25,   176,    -1,
      26,   176,    -1,    27,   176,    -1,    28,   176,    -1,    29,
     176,    -1,    30,   177,    -1,    31,   176,    -1,    32,   176,
      -1,    33,   176,    -1,    35,   176,    -1,    34,   177,    -1,
      36,   176,    -1,    37,   176,    -1,    71,   176,    -1,    54,
     176,    -1,   102,   176,    -1,    38,   183,    -1,    45,   183,
      -1,    46,   183,    -1,    48,    -1,    49,    -1,    50,    -1,
      51,    -1,    52,    -1,    53,    -1,    55,    -1,    56,    -1,
     188,    -1,   187,   116,   188,    -1,   187,   188,    -1,    78,
      -1,   186,    -1,   189,    -1,   171,    -1,    47,   176,    -1,
      39,   126,   187,   124,   182,   127,    -1,    41,   126,   187,
     124,   182,   127,    -1,    40,   126,   187,   124,   182,   124,
     182,   127,    -1,    42,   176,    -1,    43,   176,    -1,    44,
     126,   182,   124,   187,   127,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   264,   264,   266,   267,   271,   272,   276,   282,   286,
     287,   290,   292,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   344,   345,
     349,   350,   355,   356,   360,   361,   365,   368,   369,   373,
     374,   378,   379,   380,   381,   382,   383,   384,   385,   386,
     387,   391,   392,   395,   400,   404,   407,   408,   411,   412,
     416,   420,   421,   424,   425,   429,   433,   436,   439,   443,
     448,   453,   454,   459,   460,   464,   467,   472,   473,   477,
     479,   485,   486,   490,   491,   495,   496,   501,   502,   506,
     507,   510,   511,   517,   518,   524,   525,   528,   529,   530,
     531,   534,   535,   539,   540,   541,   545,   549,   553,   554,
     560,   561,   565,   566,   570,   571,   575,   576,   577,   578,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   603,   607,   608,   609,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   630,   631,   632,   633,   634,   635,   636,
     639,   643,   644,   645,   649,   650,   651,   652,   653,   657,
     658,   659,   661,   662,   663
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IF", "THEN", "ELSE", "ON", "GOTO", 
  "GOSUB", "RETURN", "LET", "INPUT", "PRINT", "READ", "DATA", "DIM", 
  "FOR", "TO", "NEXT", "STEP", "END", "STOP", "REM", "RESTORE", "INT", 
  "FIX", "SGN", "SIN", "COS", "RND", "POW", "LOG", "EXP", "TAN", "ATN2", 
  "ATN", "ABS", "SQR", "LEN", "LEFTSTR", "MIDSTR", "RIGHTSTR", "CHRSTR", 
  "STRSTR", "STRINGSTR", "VAL", "ASC", "TAB", "MOUSEX", "MOUSEY", 
  "MOUSEB", "XSIZE", "YSIZE", "TICKS", "KEY", "KEYCODE", "INKEYSTR", 
  "MOVE", "PEN", "LINE", "COLOR", "CLEAR", "RANDOM", "CLS", "FILL", 
  "HOME", "CIRCLE", "DISC", "TEST", "BOX", "RECT", "SLEEP", "SPOT", 
  "UPDATE", "INTEGER", "REAL", "NUMSYMBOL", "STRINGSYMBOL", "STRING", 
  "ARC", "WEDGE", "SHINIT", "SHDONE", "SHEND", "SHLINE", "SHCURVE", 
  "SHCUBIC", "ROUND", "ROTATE", "LF", "TONE", "ADSR", "WAVE", "FREQ", 
  "DUR", "FMUL", "VOL", "WSIN", "WSQR", "WTRI", "WSAW", "QUIET", "NOTE", 
  "OROR", "ANDAND", "'='", "GE", "LE", "GT", "LT", "NE", "XOR", "OR", 
  "AND", "LL", "RR", "'+'", "'-'", "'*'", "'/'", "MOD", "POWER", "UNARY", 
  "':'", "','", "'?'", "'('", "')'", "';'", "'@'", "$accept", "program", 
  "prog2", "line", "linenumber", "statements", "statement", "extrarender", 
  "erlist", "eritem", "silist", "tonenumber", "otonelist", "tonelist", 
  "toneitem", "print", "fixif", "fixifelse", "mark", "optstep", 
  "optforvar", "forvar", "stint", "optthen", "num1", "num2", "num3", 
  "num4", "num5", "num6", "num34", "dimarraylist", "dimarrayvar", 
  "dimlist", "linelist", "datalist", "dataentry", "real", "readlist", 
  "readvar", "numvar", "stringvar", "numlist", "printlist", "printsep", 
  "printitem", "singlenumpar", "doublenumpar", "inputlist", "inputlist2", 
  "inputvar", "assignexpr", "numexpr", "singlestringpar", "numfunc", 
  "special", "specialstr", "stringexpr", "sitem", "stringfunc", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,    61,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    43,    45,    42,    47,
     370,   371,   372,    58,    44,    63,    40,    41,    59,    64
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,   130,   131,   131,   131,   132,   132,   133,   134,   135,
     135,   136,   136,   136,   136,   136,   136,   136,   136,   136,
     136,   136,   136,   136,   136,   136,   136,   136,   136,   136,
     136,   136,   136,   136,   136,   136,   136,   136,   136,   136,
     136,   136,   136,   136,   136,   136,   136,   136,   136,   136,
     136,   136,   136,   136,   136,   136,   136,   136,   137,   137,
     138,   138,   139,   139,   140,   140,   141,   142,   142,   143,
     143,   144,   144,   144,   144,   144,   144,   144,   144,   144,
     144,   145,   145,   146,   147,   148,   149,   149,   150,   150,
     151,   152,   152,   153,   153,   154,   155,   156,   157,   158,
     159,   160,   160,   161,   161,   162,   162,   163,   163,   164,
     164,   165,   165,   166,   166,   167,   167,   168,   168,   169,
     169,   170,   170,   171,   171,   172,   172,   173,   173,   173,
     173,   174,   174,   175,   175,   175,   176,   177,   178,   178,
     179,   179,   180,   180,   181,   181,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   183,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   185,   185,   185,   185,   185,   185,   185,
     186,   187,   187,   187,   188,   188,   188,   188,   188,   189,
     189,   189,   189,   189,   189
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     1,     2,     5,     1,     1,
       3,     6,     9,     2,     2,     1,     2,     2,     1,     1,
       2,     2,     2,     1,     1,     2,     2,     1,     2,     2,
       3,     2,     2,     3,     1,     1,     1,     2,     2,     2,
       1,     1,     7,     2,     2,     1,     1,     4,     4,     2,
       2,     2,     2,     3,     1,     1,     2,     1,     0,     1,
       1,     2,     2,     2,     0,     1,     1,     0,     1,     2,
       3,     2,     1,     2,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     0,     0,     0,     0,     2,     0,     1,
       1,     1,     1,     0,     1,     1,     3,     5,     7,     9,
      11,     1,     1,     1,     3,     4,     4,     1,     3,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     3,     1,
       1,     1,     4,     1,     4,     1,     3,     0,     1,     3,
       2,     1,     1,     2,     1,     1,     3,     5,     1,     3,
       1,     3,     1,     1,     3,     3,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     3,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     2,     1,     1,     1,     1,     2,     6,
       6,     8,     2,     2,     6
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,    45,     0,     0,    81,     0,
       0,     0,     0,    88,    18,    19,    46,    55,     0,     0,
       0,     0,     0,    54,    23,    27,    24,     0,     0,    57,
       0,     0,     0,    40,    41,   121,   123,     0,     0,    34,
      35,    36,     0,     0,     0,     0,    64,    82,     0,     3,
       5,     4,     9,   127,     0,     0,     0,    15,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,   196,   197,   198,     0,   199,
     200,     0,   115,   116,   204,     0,     0,     0,   171,   170,
     207,    93,   168,   169,   205,     0,   201,   206,     0,    13,
      44,    14,     0,   142,   143,    49,   138,   140,    50,   117,
     119,   120,   114,    51,   111,   113,     0,     0,    17,   103,
      90,     0,    43,    89,    28,     0,    21,    95,    29,   101,
     102,    22,     0,    56,    25,     0,    26,    58,     0,    58,
      20,     0,     0,    31,     0,    32,     0,    37,    38,    39,
      67,    66,    52,    65,     1,     6,     0,     0,    16,   128,
     134,   135,     8,    85,     0,     0,     0,   173,   174,   175,
     176,   177,   178,     0,   179,   180,   181,   182,   184,   183,
     185,   186,     0,   190,     0,     0,     0,   212,   213,     0,
     191,   192,   208,   188,   187,   189,   146,     0,    94,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    83,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,    59,    60,
       0,    33,     0,   125,     0,     0,     0,     0,    53,    68,
      10,   133,   132,   131,   130,     0,   144,   145,     0,     0,
       0,     0,     0,     0,     0,   147,   165,   164,   155,   160,
     159,   158,   157,   156,   163,   162,   161,   153,   154,   148,
     149,   150,   151,   152,     0,   166,   167,   202,   109,    47,
      48,   139,   141,   118,   112,   107,     0,     0,   104,     0,
      96,     0,     0,    62,    63,    61,     0,     0,   122,   124,
       0,     0,     0,    72,     0,     0,     0,     0,    77,    79,
      78,    80,    69,     0,   129,     0,   136,     0,   172,     0,
       0,     0,     0,    92,    91,    85,     0,     0,   105,   106,
       0,     0,     0,     0,   126,     0,     0,    71,    73,    74,
      76,    75,    70,     7,     0,     0,     0,     0,     0,    84,
      11,   110,   108,    86,    97,    97,     0,     0,     0,   137,
     209,     0,   210,   214,     0,     0,    42,     0,     0,     0,
       0,    85,    87,    98,     0,     0,   211,    12,     0,     0,
      99,     0,     0,   100
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    48,    49,    50,   173,   344,    52,   247,   248,   249,
     162,   160,   258,   259,   332,    53,   294,   384,    54,   386,
     132,   131,   345,   227,   136,   134,   139,   140,   153,   155,
     141,   128,   129,   306,   299,   123,   124,    98,   118,   119,
      99,   100,   252,   168,   264,   169,   177,   184,   115,   116,
     117,    57,   135,   193,   102,   103,   104,   105,   106,   107
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -192
static const short yypact[] =
{
     396,   796,   796,   -66,   -60,  -192,   -52,   -11,  -192,   -52,
     -62,    14,   -22,   -22,  -192,  -192,  -192,  -192,   796,   796,
     796,   796,   796,  -192,  -192,  -192,  -192,   796,   796,  -192,
     796,   796,   796,  -192,  -192,   -85,   -43,   796,   796,  -192,
    -192,  -192,   796,   796,   796,   796,   796,  -192,   120,    50,
    -192,     8,  -192,   690,    70,    41,    42,  -192,    19,    19,
      19,    19,    19,    19,    22,    19,    19,    19,    22,    19,
      19,    19,    23,    26,    27,    29,    19,    19,    33,    23,
      23,    19,  -192,  -192,  -192,  -192,  -192,  -192,    19,  -192,
    -192,    19,  -192,  -192,  -192,    19,   796,   796,  -192,  -192,
    -192,     0,  -192,  -192,  -192,   847,  -192,  -192,   257,  -192,
    -192,  -192,    32,  -192,  -192,  -192,    38,  -192,    43,  -192,
    -192,  -192,  -192,    44,  -192,  -192,    39,    48,    46,  -192,
    -192,    64,  -192,  -192,  -192,  1011,  -192,  1451,  -192,  -192,
    -192,  -192,  1033,  -192,  -192,  1055,  -192,    47,  1077,    47,
    -192,   796,   796,  -192,  1099,  -192,  1121,  -192,  -192,  -192,
      52,  1451,  -192,  1451,  -192,  -192,   588,   796,   -90,  -192,
    1451,   847,  -192,  -192,   796,   713,   796,  -192,  -192,  -192,
    -192,  -192,  -192,   796,  -192,  -192,  -192,  -192,  -192,  -192,
    -192,  -192,   713,  -192,   713,   713,   713,  -192,  -192,   796,
    -192,  -192,  -192,  -192,  -192,  -192,  -192,   861,  -192,   796,
     796,   796,   796,   796,   796,   796,   796,   796,   796,   796,
     796,   796,   796,   796,   796,   796,   796,  -192,   713,   713,
     713,  -192,    97,    97,   -52,   -52,   -52,   -62,   103,   103,
      14,   796,   796,   796,   796,   796,   796,  -192,    47,  -192,
     796,  -192,  -105,  1451,   -76,   796,   796,   -18,  -192,    54,
    -192,  1451,  -192,  -192,   690,   588,  1451,    86,   886,  1143,
      16,   585,   737,   837,  1165,  -192,  1469,  1486,   174,   174,
     174,   174,   174,   174,   193,   193,   275,   -19,   -19,   -86,
     -86,    58,    58,  -192,   492,    86,    86,  -192,  -192,    56,
      56,    38,  -192,  -192,  -192,  -192,   -74,   -63,  -192,   324,
    1451,  1187,  1209,  1451,  1451,  -192,  1231,   796,  -192,  -192,
    1253,  1275,   713,  -192,   796,   796,   796,   796,  -192,  -192,
    -192,  -192,  -192,   -18,  -192,   -84,  -192,   796,  -192,   796,
     796,   796,   713,  -192,     8,   178,   110,   112,  -192,  -192,
     796,   796,   796,   796,  1451,   796,   796,    86,  1451,  1451,
    1451,  1451,  -192,  -192,   911,   936,  1297,   961,    45,  -192,
    -192,  -192,  -192,   425,  1319,  1451,  1319,  1341,  1363,  -192,
    -192,   796,  -192,  -192,   492,   796,  -192,   796,   796,   796,
     986,  -192,  1451,  1451,  1385,  1407,  -192,  -192,   796,   796,
    1451,  1429,   796,  1451
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -192,  -192,  -192,   136,  -192,     2,    21,    51,  -192,   -59,
    -192,  -192,  -192,  -192,  -145,  -192,  -192,  -192,  -164,  -192,
    -192,   179,  -191,  -192,   -15,   -14,   111,   -20,  -192,   150,
    -192,  -192,   -44,   -42,   -34,  -192,   -36,    -7,  -192,   -33,
      40,    62,    53,  -192,  -192,   -57,   867,   161,  -192,   -30,
      -4,   227,    -1,    61,  -192,  -192,  -192,   -38,   -35,  -192
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -86
static const short yytable[] =
{
     101,   108,    51,   125,   208,   363,   138,   143,   109,   265,
     147,   149,    92,    93,   110,   171,   122,   150,   137,   317,
     142,   137,   318,   158,    35,    36,   145,   145,   157,   148,
     148,   137,   224,   225,   262,   226,   154,   156,   263,   166,
      55,   151,   148,   156,   161,   163,    55,   113,   317,   120,
     347,   319,   170,   348,   130,    73,    74,    75,    76,    77,
      78,   347,    56,    81,   349,    35,    36,   112,    56,   114,
     231,   121,    90,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   152,    73,    74,    75,    76,    77,    78,
     126,   127,    81,    36,    94,   206,   207,   222,   223,   224,
     225,    90,   226,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     164,   226,    36,    94,   -85,    73,    74,    75,    76,    77,
      78,   166,   230,    81,   245,   246,   231,   267,   144,   146,
     200,   201,    90,   338,   172,   176,   174,   175,   183,   192,
     253,   253,   194,   195,   270,   196,   271,   272,   273,   199,
     234,   230,   235,    36,    94,   238,   261,   236,   237,   241,
     240,   298,   383,   266,   239,   268,   257,   305,   333,   226,
     346,   370,   269,   369,   371,   165,   372,   260,   362,   315,
     295,   296,   133,   391,   159,   297,   308,   307,   274,   300,
     251,   304,   230,   303,   301,   254,    55,   334,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   171,   397,    56,   188,
     125,   302,   231,   111,     0,   231,   231,   231,   231,     0,
     309,   310,   311,   312,   313,   314,     0,     0,     0,   316,
       0,     0,     0,     0,   320,   321,     0,     0,     0,     0,
     231,   231,     0,   170,   232,   233,     0,   335,     0,     0,
       0,     0,     0,     0,   113,   113,   120,     0,     0,     0,
       0,     0,     0,     0,   357,   217,   218,   219,   220,   221,
     222,   223,   224,   225,     0,   226,   114,   114,   121,     0,
       0,     0,     0,     0,   368,    55,   219,   220,   221,   222,
     223,   224,   225,     0,   226,     0,   354,     0,     0,     0,
       0,     0,   231,   358,   359,   360,   361,    56,     0,     0,
       0,     0,     0,   231,    55,     0,   364,     0,   365,   366,
     367,   350,     0,     0,     0,     0,     0,     0,     0,   373,
     374,   375,   376,     0,   377,   378,    56,     0,     0,     0,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,     0,   226,     0,
     390,     0,     0,     0,   392,     0,   393,   394,   395,   220,
     221,   222,   223,   224,   225,     0,   226,   400,   401,     1,
       0,   403,     2,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,     0,    13,     0,    14,    15,    16,    17,
       0,     0,     0,     0,    55,     0,     0,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   385,   226,    56,     0,     0,     0,
       0,     0,     0,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
     -85,     0,    35,    36,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     0,    46,     2,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,     0,
      13,     0,    14,    15,    16,    17,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,     0,   226,     0,     0,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,   343,     0,    35,    36,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     1,     0,    46,     2,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,     0,    13,     0,    14,    15,
      16,    17,     0,     0,     0,     0,     0,    47,     0,     0,
       0,     0,     0,     0,    73,    74,    75,    76,    77,    78,
       0,     0,    81,     0,     0,     0,     0,     0,     0,     0,
       0,    90,     0,     0,     0,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    36,    94,    35,    36,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,   339,
       0,     0,     0,    47,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,     0,     0,
       0,     0,    73,    74,    75,    76,    77,    78,     0,     0,
      81,    91,     0,     0,    92,    93,    35,    36,    94,    90,
       0,     0,     0,     0,     0,     0,    73,    74,    75,    76,
      77,    78,     0,     0,    81,     0,     0,     0,     0,     0,
      36,    94,    95,    90,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    96,     0,     0,
       0,     0,     0,     0,    36,    94,    97,     0,     0,   167,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,   230,     0,     0,     0,     0,     0,     0,
       0,   340,     0,     0,     0,     0,     0,    91,     0,     0,
      92,    93,    35,    36,    94,     0,    73,    74,    75,    76,
      77,    78,     0,     0,    81,     0,    73,    74,    75,    76,
      77,    78,     0,    90,    81,     0,     0,     0,    95,     0,
       0,     0,     0,    90,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    96,    36,    94,     0,     0,     0,     0,
       0,     0,    97,     0,    36,    94,   178,   179,   180,   181,
     182,     0,   185,   186,   187,     0,   189,   190,   191,     0,
       0,     0,     0,   197,   198,     0,     0,     0,   202,     0,
       0,     0,   228,   230,     0,   203,     0,   229,   204,     0,
       0,   341,   205,   230,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,     0,     0,     0,   275,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,     0,   226,     0,     0,
       0,     0,     0,   336,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,     0,     0,     0,   379,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,     0,   226,     0,     0,
       0,     0,     0,   380,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,     0,     0,     0,   382,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,     0,   226,     0,     0,
       0,     0,     0,   396,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,   242,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,     0,   226,     0,     0,   243,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,     0,   226,     0,     0,   244,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,     0,   226,     0,
       0,   250,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,     0,
     226,     0,     0,   255,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,   256,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,     0,   226,     0,     0,   337,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,     0,   226,     0,     0,   342,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,     0,   226,     0,
       0,   351,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,     0,
     226,     0,     0,   352,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,   353,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,     0,   226,     0,     0,   355,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,     0,   226,     0,     0,   356,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,     0,   226,     0,
       0,   381,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,     0,
     226,     0,     0,   387,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,     0,     0,   388,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,     0,   226,     0,     0,   389,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,     0,   226,     0,     0,   398,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,     0,   226,     0,
       0,   399,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,     0,
     226,     0,     0,   402,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,     0,   226,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,     0,
     226,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,     0,   226
};

static const short yycheck[] =
{
       1,     2,     0,    10,     4,    89,    20,    22,    74,   173,
      30,    31,    74,    75,    74,    53,    78,    32,    19,   124,
      21,    22,   127,    43,    76,    77,    27,    28,    42,    30,
      31,    32,   118,   119,   124,   121,    37,    38,   128,   123,
       0,   126,    43,    44,    45,    46,     6,     7,   124,     9,
     124,   127,    53,   127,    76,    39,    40,    41,    42,    43,
      44,   124,     0,    47,   127,    76,    77,    78,     6,     7,
     105,     9,    56,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   126,    39,    40,    41,    42,    43,    44,
      76,    77,    47,    77,    78,    96,    97,   116,   117,   118,
     119,    56,   121,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
       0,   121,    77,    78,    74,    39,    40,    41,    42,    43,
      44,   123,   116,    47,    87,    88,   171,   175,    27,    28,
      79,    80,    56,   127,    74,   126,   105,   105,   126,   126,
     151,   152,   126,   126,   192,   126,   194,   195,   196,   126,
     128,   116,   124,    77,    78,   126,   167,   124,   124,   105,
     124,    74,   127,   174,   126,   176,   124,    74,   124,   121,
     124,   345,   183,     5,    74,    49,    74,   166,   333,   248,
     228,   229,    13,   384,    44,   230,   240,   239,   199,   233,
     149,   237,   116,   236,   234,   152,   166,   264,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   264,   391,   166,    68,
     237,   235,   267,     6,    -1,   270,   271,   272,   273,    -1,
     241,   242,   243,   244,   245,   246,    -1,    -1,    -1,   250,
      -1,    -1,    -1,    -1,   255,   256,    -1,    -1,    -1,    -1,
     295,   296,    -1,   264,     7,     8,    -1,   265,    -1,    -1,
      -1,    -1,    -1,    -1,   234,   235,   236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   322,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   234,   235,   236,    -1,
      -1,    -1,    -1,    -1,   342,   265,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,    -1,   317,    -1,    -1,    -1,
      -1,    -1,   357,   324,   325,   326,   327,   265,    -1,    -1,
      -1,    -1,    -1,   368,   294,    -1,   337,    -1,   339,   340,
     341,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,
     351,   352,   353,    -1,   355,   356,   294,    -1,    -1,    -1,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,    -1,
     381,    -1,    -1,    -1,   385,    -1,   387,   388,   389,   114,
     115,   116,   117,   118,   119,    -1,   121,   398,   399,     3,
      -1,   402,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    -1,    18,    -1,    20,    21,    22,    23,
      -1,    -1,    -1,    -1,   384,    -1,    -1,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    19,   121,   384,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,   101,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    -1,
      18,    -1,    20,    21,    22,    23,    -1,    -1,    -1,    -1,
      -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,    -1,    -1,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    86,    -1,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,    -1,   101,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    -1,    18,    -1,    20,    21,
      22,    23,    -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,
      -1,    -1,    -1,    -1,    39,    40,    41,    42,    43,    44,
      -1,    -1,    47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    56,    -1,    -1,    -1,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    77,    78,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,
      -1,    -1,    -1,   125,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    -1,    -1,
      -1,    -1,    39,    40,    41,    42,    43,    44,    -1,    -1,
      47,    71,    -1,    -1,    74,    75,    76,    77,    78,    56,
      -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    41,    42,
      43,    44,    -1,    -1,    47,    -1,    -1,    -1,    -1,    -1,
      77,    78,   102,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    78,   126,    -1,    -1,   129,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,   116,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   124,    -1,    -1,    -1,    -1,    -1,    71,    -1,    -1,
      74,    75,    76,    77,    78,    -1,    39,    40,    41,    42,
      43,    44,    -1,    -1,    47,    -1,    39,    40,    41,    42,
      43,    44,    -1,    56,    47,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   117,    77,    78,    -1,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    77,    78,    59,    60,    61,    62,
      63,    -1,    65,    66,    67,    -1,    69,    70,    71,    -1,
      -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    81,    -1,
      -1,    -1,   105,   116,    -1,    88,    -1,   110,    91,    -1,
      -1,   124,    95,   116,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,    -1,    -1,    -1,   127,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,    -1,    -1,
      -1,    -1,    -1,   127,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,    -1,    -1,    -1,   127,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,    -1,    -1,
      -1,    -1,    -1,   127,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,    -1,    -1,    -1,   127,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,    -1,    -1,
      -1,    -1,    -1,   127,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,   124,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,    -1,    -1,   124,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,    -1,    -1,   124,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,    -1,
      -1,   124,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,    -1,    -1,   124,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,   124,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,    -1,    -1,   124,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,    -1,    -1,   124,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,    -1,
      -1,   124,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,    -1,    -1,   124,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,   124,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,    -1,    -1,   124,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,    -1,    -1,   124,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,    -1,
      -1,   124,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,    -1,    -1,   124,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,    -1,    -1,   124,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,    -1,    -1,   124,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,    -1,    -1,   124,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,    -1,
      -1,   124,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,    -1,    -1,   124,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     3,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    18,    20,    21,    22,    23,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    76,    77,    79,    80,    81,
      82,    83,    84,    85,    86,    90,   101,   125,   131,   132,
     133,   135,   136,   145,   148,   170,   171,   181,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    71,    74,    75,    78,   102,   117,   126,   167,   170,
     171,   182,   184,   185,   186,   187,   188,   189,   182,    74,
      74,   181,    78,   170,   171,   178,   179,   180,   168,   169,
     170,   171,    78,   165,   166,   167,    76,    77,   161,   162,
      76,   151,   150,   151,   155,   182,   154,   182,   155,   156,
     157,   160,   182,   154,   156,   182,   156,   157,   182,   157,
     154,   126,   126,   158,   182,   159,   182,   155,   157,   159,
     141,   182,   140,   182,     0,   133,   123,   129,   173,   175,
     182,   187,    74,   134,   105,   105,   126,   176,   176,   176,
     176,   176,   176,   126,   177,   176,   176,   176,   177,   176,
     176,   176,   126,   183,   126,   126,   126,   176,   176,   126,
     183,   183,   176,   176,   176,   176,   182,   182,     4,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   121,   153,   105,   110,
     116,   188,     7,     8,   128,   124,   124,   124,   126,   126,
     124,   105,   124,   124,   124,    87,    88,   137,   138,   139,
     124,   137,   172,   182,   172,   124,   124,   124,   142,   143,
     136,   182,   124,   128,   174,   148,   182,   187,   182,   182,
     187,   187,   187,   187,   182,   127,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   146,   187,   187,   188,    74,   164,
     164,   179,   180,   169,   166,    74,   163,   163,   162,   182,
     182,   182,   182,   182,   182,   139,   182,   124,   127,   127,
     182,   182,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   144,   124,   175,   135,   127,   124,   127,   124,
     124,   124,   124,    74,   135,   152,   124,   124,   127,   127,
      17,   124,   124,   124,   182,   124,   124,   187,   182,   182,
     182,   182,   144,    89,   182,   182,   182,   182,   187,     5,
     148,    74,    74,   182,   182,   182,   182,   182,   182,   127,
     127,   124,   127,   127,   147,    19,   149,   124,   124,   124,
     182,   152,   182,   182,   182,   182,   127,   148,   124,   124,
     182,   182,   124,   182
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 7:
#line 276 "grammar.y"
    {addline(PS, yyvsp[-3].value.integer,
					yyvsp[-4].value.step - PS->steps,
					yyvsp[-3].at);}
    break;

  case 11:
#line 291 "grammar.y"
    {yyvsp[-2].value.step[1].i = yyvsp[0].value.step - yyvsp[-2].value.step;}
    break;

  case 12:
#line 293 "grammar.y"
    {yyvsp[-5].value.step[1].i = yyvsp[-2].value.step - yyvsp[-5].value.step;
		yyvsp[-2].value.step[-1].i = yyvsp[0].value.step - yyvsp[-2].value.step+2;}
    break;

  case 13:
#line 295 "grammar.y"
    {addlineref(PS, yyvsp[0].at);emitfuncint(PS, rjmp, yyvsp[0].value.integer);}
    break;

  case 14:
#line 296 "grammar.y"
    {/* implemented */;}
    break;

  case 15:
#line 297 "grammar.y"
    {/* implemented */;}
    break;

  case 16:
#line 298 "grammar.y"
    {if(yyvsp[0].value.integer) emitfunc(PS, lf);}
    break;

  case 18:
#line 300 "grammar.y"
    {emitfunc(PS, performend);}
    break;

  case 19:
#line 301 "grammar.y"
    {emitfunc(PS, performstop);}
    break;

  case 20:
#line 302 "grammar.y"
    {emitfunc(PS, sleepd);emitfunc(PS, pop);}
    break;

  case 21:
#line 303 "grammar.y"
    {emitfunc(PS, performpen);}
    break;

  case 22:
#line 304 "grammar.y"
    {if(yyvsp[0].value.count==3) emitfunc(PS, color3);
			else emitfunc(PS, color4);}
    break;

  case 23:
#line 306 "grammar.y"
    {emitfunc(PS, cls);}
    break;

  case 24:
#line 307 "grammar.y"
    {emitfunc(PS, home);}
    break;

  case 25:
#line 308 "grammar.y"
    {emitfunc(PS, performcircle);}
    break;

  case 26:
#line 309 "grammar.y"
    {emitfunc(PS, performdisc);}
    break;

  case 27:
#line 310 "grammar.y"
    {emitfunc(PS, performfill);}
    break;

  case 28:
#line 311 "grammar.y"
    {emitfunc(PS, performmove);}
    break;

  case 29:
#line 312 "grammar.y"
    {emitfunc(PS, performline);}
    break;

  case 30:
#line 313 "grammar.y"
    {emitfuncint(PS, box, yyvsp[0].value.integer);}
    break;

  case 31:
#line 314 "grammar.y"
    {emitfunc(PS, arc);}
    break;

  case 32:
#line 315 "grammar.y"
    {emitfunc(PS, wedge);}
    break;

  case 33:
#line 316 "grammar.y"
    {emitfuncint(PS, rect, yyvsp[0].value.integer);}
    break;

  case 34:
#line 317 "grammar.y"
    {emitfunc(PS, shinit);}
    break;

  case 35:
#line 318 "grammar.y"
    {emitfunc(PS, shdone);}
    break;

  case 36:
#line 319 "grammar.y"
    {emitfunc(PS, shend);}
    break;

  case 37:
#line 320 "grammar.y"
    {emitfunc(PS, shline);}
    break;

  case 38:
#line 321 "grammar.y"
    {emitfunc(PS, shcurve);}
    break;

  case 39:
#line 322 "grammar.y"
    {emitfunc(PS, shcubic);}
    break;

  case 40:
#line 323 "grammar.y"
    {emitfunc(PS, spot);}
    break;

  case 41:
#line 324 "grammar.y"
    {emitfunc(PS, forceupdate);}
    break;

  case 42:
#line 326 "grammar.y"
    {emitfuncint(PS, pushav, yyvsp[-5].value.integer);emitfunc(PS, performfor);}
    break;

  case 44:
#line 328 "grammar.y"
    {addlineref(PS, yyvsp[0].at);emitfuncint(PS, rcall, yyvsp[0].value.integer);}
    break;

  case 45:
#line 329 "grammar.y"
    {emitfunc(PS, ret);}
    break;

  case 46:
#line 330 "grammar.y"
    {/* do nothing */;}
    break;

  case 47:
#line 331 "grammar.y"
    {emitfuncint(PS, ongoto, yyvsp[0].value.count);}
    break;

  case 48:
#line 332 "grammar.y"
    {emitfuncint(PS, ongosub, yyvsp[0].value.count);}
    break;

  case 49:
#line 333 "grammar.y"
    {emitfuncint(PS, input, yyvsp[0].value.count);}
    break;

  case 50:
#line 334 "grammar.y"
    {/* implemented */;}
    break;

  case 51:
#line 335 "grammar.y"
    {/* implemented */;}
    break;

  case 53:
#line 337 "grammar.y"
    {emitfunc(PS, soundgo);}
    break;

  case 57:
#line 341 "grammar.y"
    {rendertest(PS->bc);}
    break;

  case 58:
#line 344 "grammar.y"
    {yyval.value.integer = 0;}
    break;

  case 61:
#line 350 "grammar.y"
    {yyval.value.integer =
				append_modifier(PS, yyvsp[-1].at, yyvsp[-1].value.integer,
					yyvsp[0].value.integer);}
    break;

  case 62:
#line 355 "grammar.y"
    {yyval.value.integer = RENDER_ROUND;}
    break;

  case 63:
#line 356 "grammar.y"
    {yyval.value.integer = RENDER_ROTATE;}
    break;

  case 64:
#line 360 "grammar.y"
    {emitpushd(PS, 0.0);emitfunc(PS, quiet);}
    break;

  case 65:
#line 361 "grammar.y"
    {emitfunc(PS, quiet);}
    break;

  case 66:
#line 365 "grammar.y"
    {emitfunc(PS, setsound);}
    break;

  case 73:
#line 380 "grammar.y"
    {emitfunc(PS, freq);}
    break;

  case 74:
#line 381 "grammar.y"
    {emitfunc(PS, dur);}
    break;

  case 75:
#line 382 "grammar.y"
    {emitfunc(PS, vol);}
    break;

  case 76:
#line 383 "grammar.y"
    {emitfunc(PS, fmul);}
    break;

  case 77:
#line 384 "grammar.y"
    {emitfunc(PS, wsin);}
    break;

  case 78:
#line 385 "grammar.y"
    {emitfunc(PS, wtri);}
    break;

  case 79:
#line 386 "grammar.y"
    {emitfunc(PS, wsqr);}
    break;

  case 80:
#line 387 "grammar.y"
    {emitfunc(PS, wsaw);}
    break;

  case 83:
#line 395 "grammar.y"
    {emitfunc(PS, skip2ne);
		yyval.value.step = PS->nextstep;
		emitfuncint(PS, rjmp, 0);}
    break;

  case 84:
#line 400 "grammar.y"
    {emitfuncint(PS, rjmp, 0); // true side to skip over false
		yyval.value.step = PS->nextstep;;}
    break;

  case 85:
#line 404 "grammar.y"
    {yyval.value.step = PS->nextstep;}
    break;

  case 86:
#line 407 "grammar.y"
    { emitpushd(PS, 1.0);}
    break;

  case 88:
#line 411 "grammar.y"
    {emitfunc(PS, performnext);}
    break;

  case 89:
#line 412 "grammar.y"
    {emitfuncint(PS, pushav, yyvsp[0].value.integer);emitfunc(PS, performnext1);}
    break;

  case 92:
#line 421 "grammar.y"
    {addlineref(PS, yyvsp[0].at);emitfuncint(PS, rjmp, yyvsp[0].value.integer);}
    break;

  case 95:
#line 429 "grammar.y"
    {yyval.value.count=1;}
    break;

  case 96:
#line 433 "grammar.y"
    {yyval.value.count = 2;}
    break;

  case 97:
#line 436 "grammar.y"
    {yyval.value.count = 3;}
    break;

  case 98:
#line 439 "grammar.y"
    {yyval.value.count = 4;}
    break;

  case 99:
#line 444 "grammar.y"
    {yyval.value.count = 5;}
    break;

  case 100:
#line 449 "grammar.y"
    {yyval.value.count = 6;}
    break;

  case 105:
#line 464 "grammar.y"
    {emitfuncint(PS, pushav, yyvsp[-3].value.integer);
				emitfuncint(PS, dimd, yyvsp[-1].value.count);
				rankcheck(PS, yyvsp[-3].value.integer, yyvsp[-1].value.count);}
    break;

  case 106:
#line 467 "grammar.y"
    {emitfuncint(PS, pushav, yyvsp[-3].value.integer);
				emitfuncint(PS, dims, yyvsp[-1].value.count);
				rankcheck(PS, yyvsp[-3].value.integer, yyvsp[-1].value.count);}
    break;

  case 107:
#line 472 "grammar.y"
    {yyval.value.count = 1;emitfuncint(PS, pushi, yyvsp[0].value.integer);}
    break;

  case 108:
#line 473 "grammar.y"
    {yyval.value.count = yyvsp[-2].value.count + 1;
				emitfuncint(PS, pushi, yyvsp[0].value.integer);}
    break;

  case 109:
#line 477 "grammar.y"
    {yyval.value.count = 1;addlineref(PS, yyvsp[0].at);
				emitfuncint(PS, pushea, yyvsp[0].value.integer);}
    break;

  case 110:
#line 479 "grammar.y"
    {yyval.value.count = yyvsp[-2].value.count + 1;
				addlineref(PS, yyvsp[0].at);
				emitfuncint(PS, pushea, yyvsp[0].value.integer);}
    break;

  case 113:
#line 490 "grammar.y"
    {adddata(PS, yyvsp[0].value.real);}
    break;

  case 115:
#line 495 "grammar.y"
    {yyval.value.real = (double)yyvsp[0].value.integer;}
    break;

  case 119:
#line 506 "grammar.y"
    {emitfunc(PS, readd);}
    break;

  case 121:
#line 510 "grammar.y"
    {emitfuncint(PS, pushvd, yyvsp[0].value.integer);}
    break;

  case 122:
#line 512 "grammar.y"
    {emitfuncint(PS, arrayd, yyvsp[-3].value.integer);
			rankcheck(PS, yyvsp[-3].value.integer, yyvsp[-1].value.count);}
    break;

  case 123:
#line 517 "grammar.y"
    {emitfuncint(PS, pushvs, yyvsp[0].value.integer);}
    break;

  case 124:
#line 519 "grammar.y"
    {emitfuncint(PS, arrays, yyvsp[-3].value.integer);
			rankcheck(PS, yyvsp[-3].value.integer, yyvsp[-1].value.count);}
    break;

  case 125:
#line 524 "grammar.y"
    {yyval.value.count = 1;}
    break;

  case 126:
#line 525 "grammar.y"
    {yyval.value.count = yyvsp[-2].value.count + 1;}
    break;

  case 127:
#line 528 "grammar.y"
    {yyval.value.integer = 1;}
    break;

  case 128:
#line 529 "grammar.y"
    {yyval.value.integer = 1;}
    break;

  case 129:
#line 530 "grammar.y"
    {yyval.value.integer = 1;}
    break;

  case 130:
#line 531 "grammar.y"
    {yyval.value.integer = 0;}
    break;

  case 132:
#line 535 "grammar.y"
    {emitfunc(PS, tab);}
    break;

  case 133:
#line 539 "grammar.y"
    {emitfunc(PS, printat);}
    break;

  case 134:
#line 540 "grammar.y"
    {emitfunc(PS, printd);}
    break;

  case 135:
#line 541 "grammar.y"
    {emitfunc(PS, prints);}
    break;

  case 139:
#line 554 "grammar.y"
    {yyval.value.count = yyvsp[0].value.count;
				emitpushs(PS, yyvsp[-2].value.string);
				emitfunc(PS, prints);}
    break;

  case 140:
#line 560 "grammar.y"
    {yyval.value.count = 1;}
    break;

  case 141:
#line 561 "grammar.y"
    {yyval.value.count = yyvsp[-2].value.count + 1;}
    break;

  case 142:
#line 565 "grammar.y"
    {emitfuncint(PS, pushi, 0);}
    break;

  case 143:
#line 566 "grammar.y"
    {emitfuncint(PS, pushi, 1);}
    break;

  case 144:
#line 570 "grammar.y"
    {emitfunc(PS, assignd);}
    break;

  case 145:
#line 571 "grammar.y"
    {emitfunc(PS, assigns);}
    break;

  case 146:
#line 575 "grammar.y"
    {emitfunc(PS, chs);}
    break;

  case 148:
#line 577 "grammar.y"
    {emitfunc(PS, addd);}
    break;

  case 149:
#line 578 "grammar.y"
    {emitfunc(PS, subd);}
    break;

  case 150:
#line 579 "grammar.y"
    {emitfunc(PS, muld);}
    break;

  case 151:
#line 580 "grammar.y"
    {emitfunc(PS, divd);}
    break;

  case 152:
#line 581 "grammar.y"
    {emitfunc(PS, powerd);}
    break;

  case 155:
#line 584 "grammar.y"
    {emitfunc(PS, eqd);}
    break;

  case 156:
#line 585 "grammar.y"
    {emitfunc(PS, ned);}
    break;

  case 157:
#line 586 "grammar.y"
    {emitfunc(PS, ltd);}
    break;

  case 158:
#line 587 "grammar.y"
    {emitfunc(PS, gtd);}
    break;

  case 159:
#line 588 "grammar.y"
    {emitfunc(PS, led);}
    break;

  case 160:
#line 589 "grammar.y"
    {emitfunc(PS, ged);}
    break;

  case 161:
#line 590 "grammar.y"
    {emitfunc(PS, andd);}
    break;

  case 162:
#line 591 "grammar.y"
    {emitfunc(PS, ord);}
    break;

  case 163:
#line 592 "grammar.y"
    {emitfunc(PS, xord);}
    break;

  case 164:
#line 593 "grammar.y"
    {emitfunc(PS, andandd);}
    break;

  case 165:
#line 594 "grammar.y"
    {emitfunc(PS, orord);}
    break;

  case 166:
#line 595 "grammar.y"
    {emitfunc(PS, eqs);}
    break;

  case 167:
#line 596 "grammar.y"
    {emitfunc(PS, nes);}
    break;

  case 170:
#line 599 "grammar.y"
    {emitfunc(PS, evald);}
    break;

  case 171:
#line 600 "grammar.y"
    {emitpushd(PS, yyvsp[0].value.real);}
    break;

  case 173:
#line 607 "grammar.y"
    {emitfunc(PS, intd);}
    break;

  case 174:
#line 608 "grammar.y"
    {emitfunc(PS, fixd);}
    break;

  case 175:
#line 609 "grammar.y"
    {emitfunc(PS, sgnd);}
    break;

  case 176:
#line 610 "grammar.y"
    {emitfunc(PS, sind);}
    break;

  case 177:
#line 611 "grammar.y"
    {emitfunc(PS, cosd);}
    break;

  case 178:
#line 612 "grammar.y"
    {emitfunc(PS, rndd);}
    break;

  case 179:
#line 613 "grammar.y"
    {emitfunc(PS, powd);}
    break;

  case 180:
#line 614 "grammar.y"
    {emitfunc(PS, logd);}
    break;

  case 181:
#line 615 "grammar.y"
    {emitfunc(PS, expd);}
    break;

  case 182:
#line 616 "grammar.y"
    {emitfunc(PS, tand);}
    break;

  case 183:
#line 617 "grammar.y"
    {emitfunc(PS, atnd);}
    break;

  case 184:
#line 618 "grammar.y"
    {emitfunc(PS, atn2d);}
    break;

  case 185:
#line 619 "grammar.y"
    {emitfunc(PS, absd);}
    break;

  case 186:
#line 620 "grammar.y"
    {emitfunc(PS, sqrd);}
    break;

  case 187:
#line 621 "grammar.y"
    {emitfunc(PS, sleepd);}
    break;

  case 188:
#line 622 "grammar.y"
    {emitfunc(PS, keyd);}
    break;

  case 189:
#line 623 "grammar.y"
    {emitfunc(PS, note);}
    break;

  case 190:
#line 624 "grammar.y"
    {emitfunc(PS, lend);}
    break;

  case 191:
#line 625 "grammar.y"
    {emitfunc(PS, vald);}
    break;

  case 192:
#line 626 "grammar.y"
    {emitfunc(PS, ascd);}
    break;

  case 193:
#line 630 "grammar.y"
    {emitfunc(PS, mousexd);}
    break;

  case 194:
#line 631 "grammar.y"
    {emitfunc(PS, mouseyd);}
    break;

  case 195:
#line 632 "grammar.y"
    {emitfunc(PS, mousebd);}
    break;

  case 196:
#line 633 "grammar.y"
    {emitpushd(PS, PS->bc->xsize);}
    break;

  case 197:
#line 634 "grammar.y"
    {emitpushd(PS, PS->bc->ysize);}
    break;

  case 198:
#line 635 "grammar.y"
    {emitfunc(PS, ticksd);}
    break;

  case 199:
#line 636 "grammar.y"
    {emitfunc(PS, keycoded);}
    break;

  case 200:
#line 639 "grammar.y"
    {emitfunc(PS, inkey);}
    break;

  case 202:
#line 644 "grammar.y"
    {emitfunc(PS, adds);}
    break;

  case 203:
#line 645 "grammar.y"
    {emitfunc(PS, adds);}
    break;

  case 204:
#line 649 "grammar.y"
    {emitpushs(PS, yyvsp[0].value.string);}
    break;

  case 207:
#line 652 "grammar.y"
    {emitfunc(PS, evals);}
    break;

  case 208:
#line 653 "grammar.y"
    {emitfunc(PS, tabstr);}
    break;

  case 209:
#line 657 "grammar.y"
    {emitfunc(PS, leftstr);}
    break;

  case 210:
#line 658 "grammar.y"
    {emitfunc(PS, rightstr);}
    break;

  case 211:
#line 660 "grammar.y"
    {emitfunc(PS, midstr);}
    break;

  case 212:
#line 661 "grammar.y"
    {emitfunc(PS, chrstr);}
    break;

  case 213:
#line 662 "grammar.y"
    {emitfunc(PS, performstrstr);}
    break;

  case 214:
#line 663 "grammar.y"
    {emitfunc(PS, stringstr);}
    break;


    }

/* Line 991 of yacc.c.  */
#line 2881 "parse.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 663 "grammar.y"


void yyerror(char *s)
{
}

static void rankcheck(ps *ps, int var, int rank)
{
variable *v;
	v=ps->bc->vvars + var;
	if(!v->rank)
		v->rank = rank;
	else
		if(v->rank != rank)
			ps->rankfailure = v;
}


int findvar(ps *ps, char *name)
{
int i;
variable *v;
bc *bc = ps->bc;
	v=bc->vvars;
	for(i=0;i<bc->numvars;++i, ++v)
		if(!strcmp(v->name, name))
			return i;
	if(bc->numvars < MAXVARIABLES)
	{
		memset(v, 0, sizeof(*v));
		strcpy(v->name, name);
		return bc->numvars++;
	}
//WARNING
	return -1; // ran out
}

static inline char at(ps *ps)
{
	return *ps->yypntr;
}
static inline char get(ps *ps)
{
	return *ps->yypntr++;
}
static inline char back(ps *ps)
{
	return *--ps->yypntr;
}

static int iskeyword(ps *ps, char *want)
{
char *p1=ps->yypntr;
char *p2=want;

	while(*p2)
	{
		if(tolower(*p1)!=*p2)
			break;
		++p1;
		++p2;
	}
	if(!*p2)
	{
		ps->yypntr += p2-want;
		return 1;
	}
	return 0;
}

int yylex(YYSTYPE *ti, ps *parm)
{
char ch;
ps *ps=parm;

	while(get(ps)==' ');
	back(ps);
	ps->yylast = ps->yypntr;
	ti->at = ps->yypntr;
if(0){char *p=ps->yypntr, csave;
while(*p && *p++ != '\n');
csave = *--p;
*p = 0;
printf("here:%s\n", ps->yypntr);
*p = csave;
}

// alphabetized for readability -- but atn2 must be before atn, keycode < key
	if(iskeyword(ps, "abs")) return ABS;
	if(iskeyword(ps, "adsr")) return ADSR;
	if(iskeyword(ps, "and")) return ANDAND;
	if(iskeyword(ps, "arc")) return ARC;
	if(iskeyword(ps, "asc")) return ASC;
	if(iskeyword(ps, "atn2")) return ATN2; // order critical!
	if(iskeyword(ps, "atn")) return ATN;
	if(iskeyword(ps, "box")) return BOX;
	if(iskeyword(ps, "chr$")) return CHRSTR;
	if(iskeyword(ps, "circle")) return CIRCLE;
	if(iskeyword(ps, "clear")) return CLEAR;
	if(iskeyword(ps, "cls")) return CLS;
	if(iskeyword(ps, "color")) return COLOR;
	if(iskeyword(ps, "cos")) return COS;
	if(iskeyword(ps, "data")) return DATA;
	if(iskeyword(ps, "dim")) return DIM;
	if(iskeyword(ps, "disc")) return DISC;
	if(iskeyword(ps, "dur")) return DUR;
	if(iskeyword(ps, "else")) return ELSE;
	if(iskeyword(ps, "end")) return END;
	if(iskeyword(ps, "exp")) return EXP;
	if(iskeyword(ps, "fill")) return FILL;
	if(iskeyword(ps, "fix")) return FIX;
	if(iskeyword(ps, "fmul")) return FMUL;
	if(iskeyword(ps, "for")) return FOR;
	if(iskeyword(ps, "freq")) return FREQ;
	if(iskeyword(ps, "gosub")) return GOSUB;
	if(iskeyword(ps, "goto")) return GOTO;
	if(iskeyword(ps, "home")) return HOME;
	if(iskeyword(ps, "if")) return IF;
	if(iskeyword(ps, "inkey$")) return INKEYSTR;
	if(iskeyword(ps, "input")) return INPUT;
	if(iskeyword(ps, "int")) return INT;
	if(iskeyword(ps, "keycode")) return KEYCODE;
	if(iskeyword(ps, "key")) return KEY;
	if(iskeyword(ps, "left$")) return LEFTSTR;
	if(iskeyword(ps, "len")) return LEN;
	if(iskeyword(ps, "let")) return LET;
	if(iskeyword(ps, "line")) return LINE;
	if(iskeyword(ps, "log")) return LOG;
	if(iskeyword(ps, "mid$")) return MIDSTR;
	if(iskeyword(ps, "mod")) return MOD;
	if(iskeyword(ps, "mouseb")) return MOUSEB;
	if(iskeyword(ps, "mousex")) return MOUSEX;
	if(iskeyword(ps, "mousey")) return MOUSEY;
	if(iskeyword(ps, "move")) return MOVE;
	if(iskeyword(ps, "next")) return NEXT;
	if(iskeyword(ps, "note")) return NOTE;
	if(iskeyword(ps, "on")) return ON;
	if(iskeyword(ps, "or")) return OROR;
	if(iskeyword(ps, "pen")) return PEN;
	if(iskeyword(ps, "pow")) return POW;
	if(iskeyword(ps, "print")) return PRINT;
	if(iskeyword(ps, "random")) return RANDOM;
	if(iskeyword(ps, "read")) return READ;
	if(iskeyword(ps, "rect")) return RECT;
	if(iskeyword(ps, "rem") || at(ps) == '\'')
	{
		while((ch=get(ps)) && ch!='\n');
		back(ps);
		return REM;
	}
	if(iskeyword(ps, "restore")) return RESTORE;
	if(iskeyword(ps, "return")) return RETURN;
	if(iskeyword(ps, "right$")) return RIGHTSTR;
	if(iskeyword(ps, "rnd")) return RND;
	if(iskeyword(ps, "rotate")) return ROTATE;
	if(iskeyword(ps, "round")) return ROUND;
	if(iskeyword(ps, "sgn")) return SGN;
	if(iskeyword(ps, "quiet")) return QUIET;
	if(iskeyword(ps, "shcubic")) return SHCUBIC;
	if(iskeyword(ps, "shcurve")) return SHCURVE;
	if(iskeyword(ps, "shdone")) return SHDONE;
	if(iskeyword(ps, "shend")) return SHEND;
	if(iskeyword(ps, "shinit")) return SHINIT;
	if(iskeyword(ps, "shline")) return SHLINE;
	if(iskeyword(ps, "sin")) return SIN;
	if(iskeyword(ps, "sleep")) return SLEEP;
	if(iskeyword(ps, "spot")) return SPOT;
	if(iskeyword(ps, "sqr")) return SQR;
	if(iskeyword(ps, "step")) return STEP;
	if(iskeyword(ps, "stop")) return STOP;
	if(iskeyword(ps, "str$")) return STRSTR;
	if(iskeyword(ps, "string$")) return STRINGSTR;
	if(iskeyword(ps, "tab")) return TAB;
	if(iskeyword(ps, "tan")) return TAN;
	if(iskeyword(ps, "test")) return TEST;
	if(iskeyword(ps, "then")) return THEN;
	if(iskeyword(ps, "ticks")) return TICKS;
	if(iskeyword(ps, "tone")) return TONE;
	if(iskeyword(ps, "to")) return TO;
	if(iskeyword(ps, "update")) return UPDATE;
	if(iskeyword(ps, "val")) return VAL;
	if(iskeyword(ps, "vol")) return VOL;
	if(iskeyword(ps, "wave")) return WAVE;
	if(iskeyword(ps, "wedge")) return WEDGE;
	if(iskeyword(ps, "wsaw")) return WSAW;
	if(iskeyword(ps, "wsin")) return WSIN;
	if(iskeyword(ps, "wsqr")) return WSQR;
	if(iskeyword(ps, "wtri")) return WTRI;
	if(iskeyword(ps, "xsize")) return XSIZE;
	if(iskeyword(ps, "ysize")) return YSIZE;

	ch=get(ps);
	switch(ch)
	{
	case '?': return ch;
	case '@': return ch;
	case ',': return ch;
	case ';': return ch;
	case ':': return ch;
	case '(': return ch;
	case ')': return ch;
	case '+': return ch;
	case '-': return ch;
	case '*': return ch;
	case '/': return ch;
	case '&': return AND;
	case '|': return OR;
	case '^': return XOR;
	case '\n': return LF;
	case '=': return ch;
	case '~': return POWER;
	case 0: back(ps);
		return 0;
	case '>':
		ch=get(ps);
		if(ch=='>') return RR;
		if(ch=='=') return GE;
		back(ps);
		return GT;
	case '<':
		ch=get(ps);
		if(ch=='>') return NE;
		if(ch=='=') return LE;
		if(ch=='<') return LL;
		back(ps);
		return LT;
	}
	ch=back(ps);

	if(isdigit(ch) || ch=='.')
	{
		double intpart;
		double fracpart=0.0;
		int isreal = (ch=='.');

		intpart = 0.0;
		while(isdigit(ch=get(ps))) {intpart=intpart*10 + ch - '0';}
		if(ch=='.')
		{
			double power = 1;
			isreal = 1;
			while(isdigit(ch=get(ps)))
			{
				fracpart = fracpart*10 + ch - '0';
				power *= 10;
			}
			fracpart /= power;
		}
		back(ps);
		if(isreal)
		{
			ti->value.real = intpart + fracpart;
			return REAL;
		}
		ti->value.integer = intpart;
		return INTEGER;
	}
	if(isalpha(ch))
	{
		int t=0;
		char name[NAMELEN];
		for(;;)
		{
			ch=get(ps);
			if(!isalpha(ch) && !isdigit(ch))
				break;
			if(t<sizeof(name)-2)
				name[t++] = tolower(ch);
		}
		if(ch=='$')
		{
			name[t++] = ch;
			name[t] = 0;
			ti->value.integer = findvar(ps, name);
			return STRINGSYMBOL;
		}
		back(ps);
		name[t] = 0;
		ti->value.integer = findvar(ps, name);
		return NUMSYMBOL;
	}
	if(ch=='"')
	{
		get(ps);
		int t=0;
		for(;;)
		{
			ch=get(ps);
			if(!ch) {back(ps);return -1;} // nonterminated string
			if(ch=='\\')
			{
				ch=get(ps);
				if(!ch || ch=='\n')
					{back(ps);return -1;} // nonterminated
			} else if(ch=='"')
				break;
			if(t<sizeof(ti->value.string)-1)
				ti->value.string[t++] = ch;
		}
		ti->value.string[t] = 0;
		return STRING;
	}
	return -1;
}

char *myindex(char *p, char want)
{
	while(*p && *p!=want) ++p;
	if(*p) return p;
	else return 0;
}

void freeold(bc *bc)
{
int i;
int j,size;
bstring **s;
variable *v;

	for(i=0,v=bc->vvars;i<bc->numvars;++i,++v)
	{
		if(!v->pointer)
			continue;
		if(myindex(v->name, '$'))
		{
			if(v->rank)
			{
				s=v->pointer;
				size=v->dimensions[v->rank];
				for(j=0;j<size;++j)
					if(s[j])
						free_bstring(bc, s[j]);
			} else
				if(v->value.s)
					free_bstring(bc, v->value.s);
			v->value.s = 0;
		}
		free(v->pointer);
		v->pointer = 0;
	}

	bc->numvars = 0;
}

void pruninit(bc *bc)
{
	bc->time = 0.0;
	bc->soundtime = 0.0; // NEEDS A MUTEX!!!!
	memset(bc->sounds, 0, sizeof(bc->sounds));
	memset(bc->isounds, 0, sizeof(bc->isounds));
	bc->numvars = 0;
	bc->datanum=0;
	bc->datapull=0;
	bc->flags = 0;
	bc->gosubsp = 0;
	bc->numfors = 0;
	bc->gx=0;
	bc->gy=0;
	bc->gred=255;
	bc->ggreen=255;
	bc->gblue=255;
	bc->galpha=255;
	bc->pen = 1.0;
	bc->shape_numpoints = 0;
	bc->shape_numcontours = 0;
	freeold(bc);
	bc->starttime = SDL_GetTicks();
	memset(bc->vvars, sizeof(bc->vvars), 0);
	reset_waitbase(bc);
}

void dump_data_init(ps *ps)
{
	emitfuncint(ps, rcall, 0); // call to load up all the data...
}

void dump_data_finish(ps *ps)
{
bc *bc=ps->bc;
int i;
	bc->base[1].i = ps->nextstep - bc->base; // fixup initial rcall
	for(i=0;i<bc->datanum;++i)
	{
		emitfunc(ps, datad);
		emitdouble(ps, bc->data[i]);
	}

	emitfunc(ps, ret);
}

char *recover_line(ps *ps, char *put, int len, char *p)
{
int n;
	while(p>ps->yystart && p[-1] != '\n') --p;
	n=0;
	for(n=0;p[n] && p[n]!='\n' && n<len-1;++n)
		put[n] = p[n];
	put[n] = 0;
	return p;
}

ps *newps(bc *bc, char *take)
{
struct parse_state *ps;
int i;
char linecopy[1024];
	ps = malloc(sizeof(struct parse_state));
	if(!ps)
	{
		tprintf(bc, "Out of memory.\n");
		return 0;
	}
	memset(ps, 0, sizeof(*ps));
	ps->bc = bc;
	ps->nextstep = ps->steps;
	bc->base = ps->steps;
	ps->yypntr = take;
	ps->yystart = take;
	dump_data_init(ps);

	bc->numlines=0;


	ps->res=yyparse(ps);


	if(ps->res)
	{
		int n;
		char *p;
		tprintf(bc, "Parse error\n");

		p=recover_line(ps, linecopy, sizeof(linecopy), ps->yylast);
		tprintf(bc, "%s\n", linecopy);

		n=ps->yylast - p;
		if(n>sizeof(linecopy)-1)
			n=sizeof(linecopy)-1;
		memset(linecopy, ' ', n);
		linecopy[n]=0;
		tprintf(bc, "%s^\n", linecopy);
	} else if(ps->errormsg[0])
	{
		ps->res = -1;
		recover_line(ps, linecopy, sizeof(linecopy), ps->errorpos);
		tprintf(bc, "%s\n", linecopy);
		tprintf(bc, "%s\n", ps->errormsg);
	} else
	{
		emitfunc(ps, performend);
		dump_data_finish(ps);
		ps->res = fixuplinerefs(ps);
		if(!ps->res && ps->rankfailure)
		{
			tprintf(bc, "Array variable '%s' changes "
					"rank within program\n",
					ps->rankfailure->name);
			ps->res = -1;
		}
		for(i=0;i<bc->numvars;++i)	// clear out all the ranks
			bc->vvars[i].rank = 0;
	}
	return ps;
}

void parseline(bc *bc, char *line)
{
ps *ps;
	ps = newps(bc, line);
	if(ps)
	{
		if(!ps->res)
		{
			bc->flags &= ~BF_RUNNING;
//			disassemble(ps->steps, ps->nextstep - ps->steps);
			reset_waitbase(bc);
			vmachine(bc, ps->steps, bc->vstack);
		}
		free(ps);
	}
}

// I think it's an insertion sort, works great if they're already sorted
void sortlinerefs(ps *ps)
{
lineref *p1, *p2, *s, *e, t;
	s=ps->linerefs;
	e = s + ps->numlinerefs;
	for(p1 = s+1;p1<e;++p1)
	{
		t=*p1;
		p2=p1;
		while(p2>s && p2[-1].at > t.at)
		{
			*p2 = p2[-1];
			--p2;
		}
		*p2=t;
	}
}

void renumber(bc *bc, int delta, int start)
{
ps *ps;
int len;
char *put;
char *take, *end;
lineref *lr, *s;
int n;
int v;
char temp[32];
linemap *lm;

	ps = newps(bc, bc->program);
	if(!ps || ps->res)
		return;
// we know all the line references are good, the parser has to fix them
	sortlinerefs(ps); // just to be safe...we work 'em from back to front

// pass 1, replace all the references with the new values
	put = bc->program + sizeof(bc->program);
	*--put = 0;
	end = bc->program + strlen(bc->program);
	s = ps->linerefs;
	lr = ps->linerefs + ps->numlinerefs;
	while(lr > s)
	{
		--lr;
		take = lr->at;
		v=0;
		while(isdigit(*take))
			v=v*10 + *take++ - '0';
		len = end - take;
		put -= len;
		memmove(put, take, len);
		end = lr->at;
		lm=findlinemap(ps, v); // we know we find it...
		if(!lm)
		{
			tprintf(bc, "The world is insane...giving up.\n");
			free(ps);
			return;
		}
		n = lm - bc->lm;
		len = sprintf(temp, "%d", start+n*delta);
		put -= len;
		memcpy(put, temp, len);
	}
	len = end - bc->program;
	put -= len;
	memmove(put, bc->program, len);

// pass 2, fix up the line numbers themselves
	take = put;
	n = start;
	put = bc->program;
	while(*take)
	{
		while(isdigit(*take)) ++take;
		put += sprintf(put, "%d", n);
		n += delta;
		while((*put++ = *take) && *take++ != '\n');
	}
	*put = 0;
	free(ps);
}

void parse(bc *bc, int runit)
{
ps *ps;

	pruninit(bc);
	ps = newps(bc, bc->program);

	if(ps)
	{
		if(!ps->res)
		{
			if(!runit)
			{
				tprintf(bc, "Program parsed correctly\n");
				disassemble(bc, ps->steps,
					ps->nextstep - ps->steps);
			} else
			{
				bc->flags |= BF_RUNNING;
				vmachine(bc, ps->steps, bc->vstack);
			}
		}
		free(ps);
	}
}




