#!/SDK/Local/C/perl

# This is a simple test / example and how to program using the Reaction wrapper.
# It certainly isn't an example of how to do it properly though! Merely the
# types of things you need to do.



use strict;

use Reaction qw (:all TT_ULONG TT_APTR TT_STRPTR);
use Reaction::Menu ':all';
use Reaction::Classes::Window qw [ WindowObject RA_OpenWindow RA_Iconify RA_CloseWindow];
use Reaction::Gadgets::Layout qw [ LayoutObject ];
use Reaction::Gadgets::Button qw [ ButtonObject ];

require "utility/tagitem.ph";
require "reaction/reaction.ph";
require "intuition/intuition.ph";
require "classes/window.ph";
require "gadgets/layout.ph";
require "gadgets/button.ph";
require "libraries/gadtools.ph";

use constant {
    GID_1 => 1,
    GID_2 => 2,
    GID_3 => 3

};

use constant {
    MENU_ITEM_1 => 1,
    MENU_ITEM_2 => 2,
    MENU_ITEM_3 => 3,
    MENU_ITEM_4 => 4,
    MENU_ITEM_5 => 5,
    MENU_ITEM_6 => 6,
    MENU_ITEM_7 => 7,
    MENU_ITEM_8 => 8,

};

my $window = 0;

my $pageLayout;
my $title = "Diary";

my $newmenus = 0;

 $newmenus = MakeNewMenuArray(9,
                                    (&NM_TITLE, strtobuffer("Testing"),0,0,0,0),
                                    ( &NM_ITEM, strtobuffer("Menu Item 1"),0,0,0,MENU_ITEM_1),
                                    ( &NM_ITEM, strtobuffer("Menu Item 2"),0,0,0,MENU_ITEM_2),
                                    ( &NM_ITEM, strtobuffer("Menu Item 3"),0,0,0,MENU_ITEM_3),
                                    (&NM_TITLE, strtobuffer("Next"),0,0,0,0),
                                    ( &NM_ITEM, strtobuffer("Menu Item 4"),0,0,0,MENU_ITEM_4),
                                    ( &NM_ITEM, strtobuffer("Menu Item 5"),0,0,0,MENU_ITEM_5),
                                    ( &NM_ITEM, strtobuffer("Menu Item 6"),0,0,0,MENU_ITEM_6),

                                    (&NM_END,0,0,0,0,0)
                                  );

my $windowMenu = 0;
my $screen = LockPubScreen("Workbench");
my $dri = 0;
my $vi = 0;
if ($screen)
{
    print "Locked pubscreen ... $screen\n";

    $dri = GetScreenDrawInfo($screen);
    print "dri $dri\n";
    $vi = GetVisualInfo($screen);
    print "vi $vi\n";
    $windowMenu = CreateMenus($newmenus, &TAG_DONE);
    print "Window Menu $windowMenu\n";
    LayoutMenus($windowMenu,$vi,&GTMN_FrontPen,GetDrawInfoPen($dri,&MENUTEXTPEN),&TAG_DONE);
    UnlockPubScreen($screen);

}

print ("tags types ... ", &TT_ULONG, &TT_STRPTR, &TT_APTR, "\n");

$window = Reaction::Classes::Window::WindowObject(
                      &WINDOW_IconifyGadget,5,1,
                        &WA_CloseGadget,&TT_ULONG,1,
                        &WA_DepthGadget,&TT_ULONG,1,
                        &WA_SizeGadget,&TT_ULONG,1,
                        &WA_DragBar,&TT_ULONG,1,
                        &WA_InnerHeight,&TT_ULONG,400,
                        &WA_InnerWidth,&TT_ULONG,400,
                        &WA_Title,&TT_STRPTR,$title,
                        &WA_IDCMP,&TT_ULONG,&IDCMP_RAWKEY|&IDCMP_MENUPICK,
                        &WINDOW_IconifyGadget,&TT_ULONG,&TRUE,
                        &WINDOW_IconTitle,&TT_STRPTR,"Diary",
                        &WINDOW_MenuStrip,&TT_APTR,$windowMenu,
                       &WINDOW_Layout, &TT_APTR,$pageLayout = LayoutObject(
                            &LAYOUT_Orientation, &TT_ULONG, &LAYOUT_ORIENT_VERT,
                            &LAYOUT_SpaceOuter, &TT_ULONG,1,
                            &LAYOUT_AddChild, &TT_APTR, &ButtonObject(
                                &GA_Text,&TT_STRPTR,"Test Button 1",
                                &GA_ID,&TT_ULONG,GID_1,
                                &GA_RELVERIFY,&TT_ULONG,1,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, &ButtonObject(
                                &GA_Text,&TT_STRPTR,"Test Button 2",
                                &GA_ID, &TT_ULONG,GID_2,
                                &GA_RELVERIFY,&TT_ULONG,1,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR,&ButtonObject(
                                &GA_Text,&TT_STRPTR,"Test Button 3",
                                &GA_ID, &TT_ULONG,GID_3,
                                &GA_RELVERIFY,&TT_ULONG,1,
                                &TAG_DONE),

                            &TAG_DONE),
                        &TAG_DONE);

print ("$window, &WINDOW_IconifyGadget, &WA_CloseGadget" ,  &TAG_DONE,  "\n");

my $win = 0;
$win = Reaction::Classes::Window::RA_OpenWindow($window);
if ($win)
{
    my $signal;
    my $sigflag;
    my $tret;
    my $tt;
    $signal = Reaction::GetAttr(&WINDOW_SigMask, $window, TT_ULONG, $sigflag);
    $tret  = Reaction::GetAttr(&WA_Title,$window,TT_STRPTR,$tt);
    printf "signal %08x %08x\n" ,$signal ,$sigflag;
    print  "$tt $tret \n";
    if($signal)
    {
        my $code = 0;
        my $sig;
        my $die = 1;
        CLOSELOOP:
        while ($die)
        {
            $sig = Reaction::Wait($sigflag);
            if($sig == $sigflag)
            {
                my $result;
                HI:
                while ((($result, $code) = Reaction::Classes::Window::RA_HandleInput($window)) && $result != &WMHI_LASTMSG)
                {
                    SWITCHCLASS:
                    {
                        (($result & &WMHI_CLASSMASK) == &WMHI_CLOSEWINDOW)  and do
                        {
                            $die = 0;
                            last SWITCHCLASS;
                        };

                        (($result & &WMHI_CLASSMASK) == &WMHI_GADGETUP)    and do
                        {
                            SWITCHGADGET:
                            {
                                my $gad = ($result & &WMHI_GADGETMASK);
                                print "gad $gad\n";
                                $gad == GID_1 and print("Gadget One Clicked\n"),last SWITCHGADGET;
                                $gad == GID_2 and print("Gadget Two Clicked\n"),last SWITCHGADGET;
                                $gad == GID_3 and print("Gadget Three Clicked\n"),last SWITCHGADGET;

                            }
                            last SWITCHCLASS;
                        };
                        (($result & &WMHI_CLASSMASK) == &WMHI_MENUPICK)      and do
                        {

                            print "code $code\n";
                            my $mid = GetMenuItemUserData($windowMenu, $code);
                            print "Menu $mid Selected\n";
                            last SWITCHCLASS;
                        };
                    }
                }
            }
        }
    }
    Reaction::Classes::Window::RA_CloseWindow($window);

}

Reaction::DisposeObject($window);

if ($newmenus)
{
    print "Freeing newmenus\n";
    FreeNewMenuArray($newmenus);
}

if($windowMenu)
{
    print "freeing windowMenu\n";
    FreeMenus($windowMenu);
}

if($dri)
{
    print "freeing dri\n";
    FreeScreenDrawInfo($screen, $dri);
}
if($vi)
{
    print "freeing vi\n";
    FreeVisualInfo($vi);
}

print "$win $window\n";
exit;
