require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&INLINE4_GRAPHICS_H)) {
    eval 'sub INLINE4_GRAPHICS_H () {1;}' unless defined(&INLINE4_GRAPHICS_H);
    unless(defined(&EXEC_TYPES_H)) {
	require 'exec/types.ph';
    }
    unless(defined(&EXEC_EXEC_H)) {
	require 'exec/exec.ph';
    }
    unless(defined(&EXEC_INTERFACES_H)) {
	require 'exec/interfaces.ph';
    }
    unless(defined(&GRAPHICS_GFX_H)) {
	require 'graphics/gfx.ph';
    }
    unless(defined(&GRAPHICS_DISPLAYINFO_H)) {
	require 'graphics/displayinfo.ph';
    }
    unless(defined(&GRAPHICS_GELS_H)) {
	require 'graphics/gels.ph';
    }
    unless(defined(&GRAPHICS_RASTPORT_H)) {
	require 'graphics/rastport.ph';
    }
    unless(defined(&GRAPHICS_VIEW_H)) {
	require 'graphics/view.ph';
    }
    unless(defined(&GRAPHICS_COPPER_H)) {
	require 'graphics/copper.ph';
    }
    unless(defined(&GRAPHICS_CLIP_H)) {
	require 'graphics/clip.ph';
    }
    unless(defined(&GRAPHICS_REGIONS_H)) {
	require 'graphics/regions.ph';
    }
    unless(defined(&GRAPHICS_SCALE_H)) {
	require 'graphics/scale.ph';
    }
    unless(defined(&GRAPHICS_SPRITE_H)) {
	require 'graphics/sprite.ph';
    }
    unless(defined(&GRAPHICS_TEXT_H)) {
	require 'graphics/text.ph';
    }
    unless(defined(&HARDWARE_BLIT_H)) {
	require 'hardware/blit.ph';
    }
    eval 'sub BltBitMap {
        local($srcBitMap, $xSrc, $ySrc, $destBitMap, $xDest, $yDest, $xSize, $ySize, $minterm, $mask, $tempA) = @_;
	    eval q( ($IGraphics->{BltBitMap})($srcBitMap, $xSrc, $ySrc, $destBitMap, $xDest, $yDest, $xSize, $ySize, $minterm, $mask, $tempA));
    }' unless defined(&BltBitMap);
    eval 'sub BltTemplate {
        local($source, $xSrc, $srcMod, $destRP, $xDest, $yDest, $xSize, $ySize) = @_;
	    eval q( ($IGraphics->{BltTemplate})($source, $xSrc, $srcMod, $destRP, $xDest, $yDest, $xSize, $ySize));
    }' unless defined(&BltTemplate);
    eval 'sub ClearEOL {
        local($rp) = @_;
	    eval q( ($IGraphics->{ClearEOL})($rp));
    }' unless defined(&ClearEOL);
    eval 'sub ClearScreen {
        local($rp) = @_;
	    eval q( ($IGraphics->{ClearScreen})($rp));
    }' unless defined(&ClearScreen);
    eval 'sub TextLength {
        local($rp, $string, $count) = @_;
	    eval q( ($IGraphics->{TextLength})($rp, $string, $count));
    }' unless defined(&TextLength);
    eval 'sub Text {
        local($rp, $string, $count) = @_;
	    eval q( ($IGraphics->{Text})($rp, $string, $count));
    }' unless defined(&Text);
    eval 'sub SetFont {
        local($rp, $textFont) = @_;
	    eval q( ($IGraphics->{SetFont})($rp, $textFont));
    }' unless defined(&SetFont);
    eval 'sub OpenFont {
        local($textAttr) = @_;
	    eval q( ($IGraphics->{OpenFont})($textAttr));
    }' unless defined(&OpenFont);
    eval 'sub CloseFont {
        local($textFont) = @_;
	    eval q( ($IGraphics->{CloseFont})($textFont));
    }' unless defined(&CloseFont);
    eval 'sub AskSoftStyle {
        local($rp) = @_;
	    eval q( ($IGraphics->{AskSoftStyle})($rp));
    }' unless defined(&AskSoftStyle);
    eval 'sub SetSoftStyle {
        local($rp, $style, $enable) = @_;
	    eval q( ($IGraphics->{SetSoftStyle})($rp, $style, $enable));
    }' unless defined(&SetSoftStyle);
    eval 'sub AddBob {
        local($bob, $rp) = @_;
	    eval q( ($IGraphics->{AddBob})($bob, $rp));
    }' unless defined(&AddBob);
    eval 'sub AddVSprite {
        local($vSprite, $rp) = @_;
	    eval q( ($IGraphics->{AddVSprite})($vSprite, $rp));
    }' unless defined(&AddVSprite);
    eval 'sub DoCollision {
        local($rp) = @_;
	    eval q( ($IGraphics->{DoCollision})($rp));
    }' unless defined(&DoCollision);
    eval 'sub DrawGList {
        local($rp, $vp) = @_;
	    eval q( ($IGraphics->{DrawGList})($rp, $vp));
    }' unless defined(&DrawGList);
    eval 'sub InitGels {
        local($head, $tail, $gelsInfo) = @_;
	    eval q( ($IGraphics->{InitGels})($head, $tail, $gelsInfo));
    }' unless defined(&InitGels);
    eval 'sub InitMasks {
        local($vSprite) = @_;
	    eval q( ($IGraphics->{InitMasks})($vSprite));
    }' unless defined(&InitMasks);
    eval 'sub RemIBob {
        local($bob, $rp, $vp) = @_;
	    eval q( ($IGraphics->{RemIBob})($bob, $rp, $vp));
    }' unless defined(&RemIBob);
    eval 'sub RemVSprite {
        local($vSprite) = @_;
	    eval q( ($IGraphics->{RemVSprite})($vSprite));
    }' unless defined(&RemVSprite);
    eval 'sub SetCollision {
        local($num, $routine, $gelsInfo) = @_;
	    eval q( ($IGraphics->{SetCollision})($num, $routine, $gelsInfo));
    }' unless defined(&SetCollision);
    eval 'sub SortGList {
        local($rp) = @_;
	    eval q( ($IGraphics->{SortGList})($rp));
    }' unless defined(&SortGList);
    eval 'sub AddAnimOb {
        local($anOb, $anKey, $rp) = @_;
	    eval q( ($IGraphics->{AddAnimOb})($anOb, $anKey, $rp));
    }' unless defined(&AddAnimOb);
    eval 'sub Animate {
        local($anKey, $rp) = @_;
	    eval q( ($IGraphics->{Animate})($anKey, $rp));
    }' unless defined(&Animate);
    eval 'sub GetGBuffers {
        local($anOb, $rp, $flag) = @_;
	    eval q( ($IGraphics->{GetGBuffers})($anOb, $rp, $flag));
    }' unless defined(&GetGBuffers);
    eval 'sub InitGMasks {
        local($anOb) = @_;
	    eval q( ($IGraphics->{InitGMasks})($anOb));
    }' unless defined(&InitGMasks);
    eval 'sub DrawEllipse {
        local($rp, $xCenter, $yCenter, $a, $b) = @_;
	    eval q( ($IGraphics->{DrawEllipse})($rp, $xCenter, $yCenter, $a, $b));
    }' unless defined(&DrawEllipse);
    eval 'sub AreaEllipse {
        local($rp, $xCenter, $yCenter, $a, $b) = @_;
	    eval q( ($IGraphics->{AreaEllipse})($rp, $xCenter, $yCenter, $a, $b));
    }' unless defined(&AreaEllipse);
    eval 'sub LoadRGB4 {
        local($vp, $colors, $count) = @_;
	    eval q( ($IGraphics->{LoadRGB4})($vp, $colors, $count));
    }' unless defined(&LoadRGB4);
    eval 'sub InitRastPort {
        local($rp) = @_;
	    eval q( ($IGraphics->{InitRastPort})($rp));
    }' unless defined(&InitRastPort);
    eval 'sub InitVPort {
        local($vp) = @_;
	    eval q( ($IGraphics->{InitVPort})($vp));
    }' unless defined(&InitVPort);
    eval 'sub MrgCop {
        local($view) = @_;
	    eval q( ($IGraphics->{MrgCop})($view));
    }' unless defined(&MrgCop);
    eval 'sub MakeVPort {
        local($view, $vp) = @_;
	    eval q( ($IGraphics->{MakeVPort})($view, $vp));
    }' unless defined(&MakeVPort);
    eval 'sub LoadView {
        local($view) = @_;
	    eval q( ($IGraphics->{LoadView})($view));
    }' unless defined(&LoadView);
    eval 'sub WaitBlit () {
        eval q( ($IGraphics->{WaitBlit})());
    }' unless defined(&WaitBlit);
    eval 'sub SetRast {
        local($rp, $pen) = @_;
	    eval q( ($IGraphics->{SetRast})($rp, $pen));
    }' unless defined(&SetRast);
    eval 'sub Move {
        local($rp, $x, $y) = @_;
	    eval q( ($IGraphics->{Move})($rp, $x, $y));
    }' unless defined(&Move);
    eval 'sub Draw {
        local($rp, $x, $y) = @_;
	    eval q( ($IGraphics->{Draw})($rp, $x, $y));
    }' unless defined(&Draw);
    eval 'sub AreaMove {
        local($rp, $x, $y) = @_;
	    eval q( ($IGraphics->{AreaMove})($rp, $x, $y));
    }' unless defined(&AreaMove);
    eval 'sub AreaDraw {
        local($rp, $x, $y) = @_;
	    eval q( ($IGraphics->{AreaDraw})($rp, $x, $y));
    }' unless defined(&AreaDraw);
    eval 'sub AreaEnd {
        local($rp) = @_;
	    eval q( ($IGraphics->{AreaEnd})($rp));
    }' unless defined(&AreaEnd);
    eval 'sub WaitTOF () {
        eval q( ($IGraphics->{WaitTOF})());
    }' unless defined(&WaitTOF);
    eval 'sub QBlit {
        local($blit) = @_;
	    eval q( ($IGraphics->{QBlit})($blit));
    }' unless defined(&QBlit);
    eval 'sub InitArea {
        local($areaInfo, $vectorBuffer, $maxVectors) = @_;
	    eval q( ($IGraphics->{InitArea})($areaInfo, $vectorBuffer, $maxVectors));
    }' unless defined(&InitArea);
    eval 'sub SetRGB4 {
        local($vp, $colindex, $red, $green, $blue) = @_;
	    eval q( ($IGraphics->{SetRGB4})($vp, $colindex, $red, $green, $blue));
    }' unless defined(&SetRGB4);
    eval 'sub QBSBlit {
        local($blit) = @_;
	    eval q( ($IGraphics->{QBSBlit})($blit));
    }' unless defined(&QBSBlit);
    eval 'sub BltClear {
        local($memBlock, $byteCount, $flags) = @_;
	    eval q( ($IGraphics->{BltClear})($memBlock, $byteCount, $flags));
    }' unless defined(&BltClear);
    eval 'sub RectFill {
        local($rp, $xMin, $yMin, $xMax, $yMax) = @_;
	    eval q( ($IGraphics->{RectFill})($rp, $xMin, $yMin, $xMax, $yMax));
    }' unless defined(&RectFill);
    eval 'sub BltPattern {
        local($rp, $mask, $xMin, $yMin, $xMax, $yMax, $maskBPR) = @_;
	    eval q( ($IGraphics->{BltPattern})($rp, $mask, $xMin, $yMin, $xMax, $yMax, $maskBPR));
    }' unless defined(&BltPattern);
    eval 'sub ReadPixel {
        local($rp, $x, $y) = @_;
	    eval q( ($IGraphics->{ReadPixel})($rp, $x, $y));
    }' unless defined(&ReadPixel);
    eval 'sub WritePixel {
        local($rp, $x, $y) = @_;
	    eval q( ($IGraphics->{WritePixel})($rp, $x, $y));
    }' unless defined(&WritePixel);
    eval 'sub Flood {
        local($rp, $mode, $x, $y) = @_;
	    eval q( ($IGraphics->{Flood})($rp, $mode, $x, $y));
    }' unless defined(&Flood);
    eval 'sub PolyDraw {
        local($rp, $count, $polyTable) = @_;
	    eval q( ($IGraphics->{PolyDraw})($rp, $count, $polyTable));
    }' unless defined(&PolyDraw);
    eval 'sub SetAPen {
        local($rp, $pen) = @_;
	    eval q( ($IGraphics->{SetAPen})($rp, $pen));
    }' unless defined(&SetAPen);
    eval 'sub SetBPen {
        local($rp, $pen) = @_;
	    eval q( ($IGraphics->{SetBPen})($rp, $pen));
    }' unless defined(&SetBPen);
    eval 'sub SetDrMd {
        local($rp, $drawMode) = @_;
	    eval q( ($IGraphics->{SetDrMd})($rp, $drawMode));
    }' unless defined(&SetDrMd);
    eval 'sub InitView {
        local($view) = @_;
	    eval q( ($IGraphics->{InitView})($view));
    }' unless defined(&InitView);
    eval 'sub CBump {
        local($copList) = @_;
	    eval q( ($IGraphics->{CBump})($copList));
    }' unless defined(&CBump);
    eval 'sub CMove {
        local($copList, $destoffset, $data) = @_;
	    eval q( ($IGraphics->{CMove})($copList, $destoffset, $data));
    }' unless defined(&CMove);
    eval 'sub CWait {
        local($copList, $v, $h) = @_;
	    eval q( ($IGraphics->{CWait})($copList, $v, $h));
    }' unless defined(&CWait);
    eval 'sub VBeamPos () {
        eval q( ($IGraphics->{VBeamPos})());
    }' unless defined(&VBeamPos);
    eval 'sub InitBitMap {
        local($bitMap, $depth, $width, $height) = @_;
	    eval q( ($IGraphics->{InitBitMap})($bitMap, $depth, $width, $height));
    }' unless defined(&InitBitMap);
    eval 'sub ScrollRaster {
        local($rp, $dx, $dy, $xMin, $yMin, $xMax, $yMax) = @_;
	    eval q( ($IGraphics->{ScrollRaster})($rp, $dx, $dy, $xMin, $yMin, $xMax, $yMax));
    }' unless defined(&ScrollRaster);
    eval 'sub WaitBOVP {
        local($vp) = @_;
	    eval q( ($IGraphics->{WaitBOVP})($vp));
    }' unless defined(&WaitBOVP);
    eval 'sub GetSprite {
        local($sprite, $num) = @_;
	    eval q( ($IGraphics->{GetSprite})($sprite, $num));
    }' unless defined(&GetSprite);
    eval 'sub FreeSprite {
        local($num) = @_;
	    eval q( ($IGraphics->{FreeSprite})($num));
    }' unless defined(&FreeSprite);
    eval 'sub ChangeSprite {
        local($vp, $sprite, $newData) = @_;
	    eval q( ($IGraphics->{ChangeSprite})($vp, $sprite, $newData));
    }' unless defined(&ChangeSprite);
    eval 'sub MoveSprite {
        local($vp, $sprite, $x, $y) = @_;
	    eval q( ($IGraphics->{MoveSprite})($vp, $sprite, $x, $y));
    }' unless defined(&MoveSprite);
    eval 'sub LockLayerRom {
        local($layer) = @_;
	    eval q( ($IGraphics->{LockLayerRom})($layer));
    }' unless defined(&LockLayerRom);
    eval 'sub UnlockLayerRom {
        local($layer) = @_;
	    eval q( ($IGraphics->{UnlockLayerRom})($layer));
    }' unless defined(&UnlockLayerRom);
    eval 'sub SyncSBitMap {
        local($layer) = @_;
	    eval q( ($IGraphics->{SyncSBitMap})($layer));
    }' unless defined(&SyncSBitMap);
    eval 'sub CopySBitMap {
        local($layer) = @_;
	    eval q( ($IGraphics->{CopySBitMap})($layer));
    }' unless defined(&CopySBitMap);
    eval 'sub OwnBlitter () {
        eval q( ($IGraphics->{OwnBlitter})());
    }' unless defined(&OwnBlitter);
    eval 'sub DisownBlitter () {
        eval q( ($IGraphics->{DisownBlitter})());
    }' unless defined(&DisownBlitter);
    eval 'sub InitTmpRas {
        local($tmpRas, $buffer, $size) = @_;
	    eval q( ($IGraphics->{InitTmpRas})($tmpRas, $buffer, $size));
    }' unless defined(&InitTmpRas);
    eval 'sub AskFont {
        local($rp, $textAttr) = @_;
	    eval q( ($IGraphics->{AskFont})($rp, $textAttr));
    }' unless defined(&AskFont);
    eval 'sub AddFont {
        local($textFont) = @_;
	    eval q( ($IGraphics->{AddFont})($textFont));
    }' unless defined(&AddFont);
    eval 'sub RemFont {
        local($textFont) = @_;
	    eval q( ($IGraphics->{RemFont})($textFont));
    }' unless defined(&RemFont);
    eval 'sub AllocRaster {
        local($width, $height) = @_;
	    eval q( ($IGraphics->{AllocRaster})($width, $height));
    }' unless defined(&AllocRaster);
    eval 'sub FreeRaster {
        local($p, $width, $height) = @_;
	    eval q( ($IGraphics->{FreeRaster})($p, $width, $height));
    }' unless defined(&FreeRaster);
    eval 'sub AndRectRegion {
        local($region, $rectangle) = @_;
	    eval q( ($IGraphics->{AndRectRegion})($region, $rectangle));
    }' unless defined(&AndRectRegion);
    eval 'sub OrRectRegion {
        local($region, $rectangle) = @_;
	    eval q( ($IGraphics->{OrRectRegion})($region, $rectangle));
    }' unless defined(&OrRectRegion);
    eval 'sub NewRegion () {
        eval q( ($IGraphics->{NewRegion})());
    }' unless defined(&NewRegion);
    eval 'sub ClearRectRegion {
        local($region, $rectangle) = @_;
	    eval q( ($IGraphics->{ClearRectRegion})($region, $rectangle));
    }' unless defined(&ClearRectRegion);
    eval 'sub ClearRegion {
        local($region) = @_;
	    eval q( ($IGraphics->{ClearRegion})($region));
    }' unless defined(&ClearRegion);
    eval 'sub DisposeRegion {
        local($region) = @_;
	    eval q( ($IGraphics->{DisposeRegion})($region));
    }' unless defined(&DisposeRegion);
    eval 'sub FreeVPortCopLists {
        local($vp) = @_;
	    eval q( ($IGraphics->{FreeVPortCopLists})($vp));
    }' unless defined(&FreeVPortCopLists);
    eval 'sub FreeCopList {
        local($copList) = @_;
	    eval q( ($IGraphics->{FreeCopList})($copList));
    }' unless defined(&FreeCopList);
    eval 'sub ClipBlit {
        local($srcRP, $xSrc, $ySrc, $destRP, $xDest, $yDest, $xSize, $ySize, $minterm) = @_;
	    eval q( ($IGraphics->{ClipBlit})($srcRP, $xSrc, $ySrc, $destRP, $xDest, $yDest, $xSize, $ySize, $minterm));
    }' unless defined(&ClipBlit);
    eval 'sub XorRectRegion {
        local($region, $rectangle) = @_;
	    eval q( ($IGraphics->{XorRectRegion})($region, $rectangle));
    }' unless defined(&XorRectRegion);
    eval 'sub FreeCprList {
        local($cprList) = @_;
	    eval q( ($IGraphics->{FreeCprList})($cprList));
    }' unless defined(&FreeCprList);
    eval 'sub GetColorMap {
        local($entries) = @_;
	    eval q( ($IGraphics->{GetColorMap})($entries));
    }' unless defined(&GetColorMap);
    eval 'sub FreeColorMap {
        local($colorMap) = @_;
	    eval q( ($IGraphics->{FreeColorMap})($colorMap));
    }' unless defined(&FreeColorMap);
    eval 'sub GetRGB4 {
        local($colorMap, $entry) = @_;
	    eval q( ($IGraphics->{GetRGB4})($colorMap, $entry));
    }' unless defined(&GetRGB4);
    eval 'sub ScrollVPort {
        local($vp) = @_;
	    eval q( ($IGraphics->{ScrollVPort})($vp));
    }' unless defined(&ScrollVPort);
    eval 'sub UCopperListInit {
        local($uCopList, $n) = @_;
	    eval q( ($IGraphics->{UCopperListInit})($uCopList, $n));
    }' unless defined(&UCopperListInit);
    eval 'sub FreeGBuffers {
        local($anOb, $rp, $flag) = @_;
	    eval q( ($IGraphics->{FreeGBuffers})($anOb, $rp, $flag));
    }' unless defined(&FreeGBuffers);
    eval 'sub BltBitMapRastPort {
        local($srcBitMap, $xSrc, $ySrc, $destRP, $xDest, $yDest, $xSize, $ySize, $minterm) = @_;
	    eval q( ($IGraphics->{BltBitMapRastPort})($srcBitMap, $xSrc, $ySrc, $destRP, $xDest, $yDest, $xSize, $ySize, $minterm));
    }' unless defined(&BltBitMapRastPort);
    eval 'sub OrRegionRegion {
        local($srcRegion, $destRegion) = @_;
	    eval q( ($IGraphics->{OrRegionRegion})($srcRegion, $destRegion));
    }' unless defined(&OrRegionRegion);
    eval 'sub XorRegionRegion {
        local($srcRegion, $destRegion) = @_;
	    eval q( ($IGraphics->{XorRegionRegion})($srcRegion, $destRegion));
    }' unless defined(&XorRegionRegion);
    eval 'sub AndRegionRegion {
        local($srcRegion, $destRegion) = @_;
	    eval q( ($IGraphics->{AndRegionRegion})($srcRegion, $destRegion));
    }' unless defined(&AndRegionRegion);
    eval 'sub SetRGB4CM {
        local($colorMap, $colindex, $red, $green, $blue) = @_;
	    eval q( ($IGraphics->{SetRGB4CM})($colorMap, $colindex, $red, $green, $blue));
    }' unless defined(&SetRGB4CM);
    eval 'sub BltMaskBitMapRastPort {
        local($srcBitMap, $xSrc, $ySrc, $destRP, $xDest, $yDest, $xSize, $ySize, $minterm, $bltMask) = @_;
	    eval q( ($IGraphics->{BltMaskBitMapRastPort})($srcBitMap, $xSrc, $ySrc, $destRP, $xDest, $yDest, $xSize, $ySize, $minterm, $bltMask));
    }' unless defined(&BltMaskBitMapRastPort);
    eval 'sub AttemptLockLayerRom {
        local($layer) = @_;
	    eval q( ($IGraphics->{AttemptLockLayerRom})($layer));
    }' unless defined(&AttemptLockLayerRom);
    eval 'sub GfxNew {
        local($gfxNodeType) = @_;
	    eval q( ($IGraphics->{GfxNew})($gfxNodeType));
    }' unless defined(&GfxNew);
    eval 'sub GfxFree {
        local($gfxNodePtr) = @_;
	    eval q( ($IGraphics->{GfxFree})($gfxNodePtr));
    }' unless defined(&GfxFree);
    eval 'sub GfxAssociate {
        local($associateNode, $gfxNodePtr) = @_;
	    eval q( ($IGraphics->{GfxAssociate})($associateNode, $gfxNodePtr));
    }' unless defined(&GfxAssociate);
    eval 'sub BitMapScale {
        local($bitScaleArgs) = @_;
	    eval q( ($IGraphics->{BitMapScale})($bitScaleArgs));
    }' unless defined(&BitMapScale);
    eval 'sub ScalerDiv {
        local($factor, $numerator, $denominator) = @_;
	    eval q( ($IGraphics->{ScalerDiv})($factor, $numerator, $denominator));
    }' unless defined(&ScalerDiv);
    eval 'sub TextExtent {
        local($rp, $string, $count, $textExtent) = @_;
	    eval q( ($IGraphics->{TextExtent})($rp, $string, $count, $textExtent));
    }' unless defined(&TextExtent);
    eval 'sub TextFit {
        local($rp, $string, $strLen, $textExtent, $constrainingExtent, $strDirection, $constrainingBitWidth, $constrainingBitHeight) = @_;
	    eval q( ($IGraphics->{TextFit})($rp, $string, $strLen, $textExtent, $constrainingExtent, $strDirection, $constrainingBitWidth, $constrainingBitHeight));
    }' unless defined(&TextFit);
    eval 'sub GfxLookUp {
        local($associateNode) = @_;
	    eval q( ($IGraphics->{GfxLookUp})($associateNode));
    }' unless defined(&GfxLookUp);
    eval 'sub VideoControl {
        local($colorMap, $tagarray) = @_;
	    eval q( ($IGraphics->{VideoControl})($colorMap, $tagarray));
    }' unless defined(&VideoControl);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub VideoControlTags () {(...)  ($IGraphics->{VideoControlTags})( &__VA_ARGS__);}' unless defined(&VideoControlTags);
    }
    eval 'sub OpenMonitor {
        local($monitorName, $displayID) = @_;
	    eval q( ($IGraphics->{OpenMonitor})($monitorName, $displayID));
    }' unless defined(&OpenMonitor);
    eval 'sub CloseMonitor {
        local($monitorSpec) = @_;
	    eval q( ($IGraphics->{CloseMonitor})($monitorSpec));
    }' unless defined(&CloseMonitor);
    eval 'sub FindDisplayInfo {
        local($displayID) = @_;
	    eval q( ($IGraphics->{FindDisplayInfo})($displayID));
    }' unless defined(&FindDisplayInfo);
    eval 'sub NextDisplayInfo {
        local($displayID) = @_;
	    eval q( ($IGraphics->{NextDisplayInfo})($displayID));
    }' unless defined(&NextDisplayInfo);
    eval 'sub GetDisplayInfoData {
        local($handle, $buf, $size, $tagID, $displayID) = @_;
	    eval q( ($IGraphics->{GetDisplayInfoData})($handle, $buf, $size, $tagID, $displayID));
    }' unless defined(&GetDisplayInfoData);
    eval 'sub FontExtent {
        local($font, $fontExtent) = @_;
	    eval q( ($IGraphics->{FontExtent})($font, $fontExtent));
    }' unless defined(&FontExtent);
    eval 'sub ReadPixelLine8 {
        local($rp, $xstart, $ystart, $width, $array, $tempRP) = @_;
	    eval q( ($IGraphics->{ReadPixelLine8})($rp, $xstart, $ystart, $width, $array, $tempRP));
    }' unless defined(&ReadPixelLine8);
    eval 'sub WritePixelLine8 {
        local($rp, $xstart, $ystart, $width, $array, $tempRP) = @_;
	    eval q( ($IGraphics->{WritePixelLine8})($rp, $xstart, $ystart, $width, $array, $tempRP));
    }' unless defined(&WritePixelLine8);
    eval 'sub ReadPixelArray8 {
        local($rp, $xstart, $ystart, $xstop, $ystop, $array, $temprp) = @_;
	    eval q( ($IGraphics->{ReadPixelArray8})($rp, $xstart, $ystart, $xstop, $ystop, $array, $temprp));
    }' unless defined(&ReadPixelArray8);
    eval 'sub WritePixelArray8 {
        local($rp, $xstart, $ystart, $xstop, $ystop, $array, $temprp) = @_;
	    eval q( ($IGraphics->{WritePixelArray8})($rp, $xstart, $ystart, $xstop, $ystop, $array, $temprp));
    }' unless defined(&WritePixelArray8);
    eval 'sub GetVPModeID {
        local($vp) = @_;
	    eval q( ($IGraphics->{GetVPModeID})($vp));
    }' unless defined(&GetVPModeID);
    eval 'sub ModeNotAvailable {
        local($modeID) = @_;
	    eval q( ($IGraphics->{ModeNotAvailable})($modeID));
    }' unless defined(&ModeNotAvailable);
    eval 'sub EraseRect {
        local($rp, $xMin, $yMin, $xMax, $yMax) = @_;
	    eval q( ($IGraphics->{EraseRect})($rp, $xMin, $yMin, $xMax, $yMax));
    }' unless defined(&EraseRect);
    eval 'sub ExtendFont {
        local($font, $fontTags) = @_;
	    eval q( ($IGraphics->{ExtendFont})($font, $fontTags));
    }' unless defined(&ExtendFont);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub ExtendFontTags () {(...)  ($IGraphics->{ExtendFontTags})( &__VA_ARGS__);}' unless defined(&ExtendFontTags);
    }
    eval 'sub StripFont {
        local($font) = @_;
	    eval q( ($IGraphics->{StripFont})($font));
    }' unless defined(&StripFont);
    eval 'sub CalcIVG {
        local($v, $vp) = @_;
	    eval q( ($IGraphics->{CalcIVG})($v, $vp));
    }' unless defined(&CalcIVG);
    eval 'sub AttachPalExtra {
        local($cm, $vp) = @_;
	    eval q( ($IGraphics->{AttachPalExtra})($cm, $vp));
    }' unless defined(&AttachPalExtra);
    eval 'sub ObtainBestPenA {
        local($cm, $r, $g, $b, $tags) = @_;
	    eval q( ($IGraphics->{O$btainBestPenA})($cm, $r, $g, $b, $tags));
    }' unless defined(&ObtainBestPenA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub ObtainBestPen () {( &cm,  &r,  &g, ...)  ($IGraphics->{ObtainBestPen})( &cm,  &r,  &g,  &__VA_ARGS__);}' unless defined(&ObtainBestPen);
    }
    eval 'sub SetRGB32 {
        local($vp, $n, $r, $g, $b) = @_;
	    eval q( ($IGraphics->{SetRGB32})($vp, $n, $r, $g, $b));
    }' unless defined(&SetRGB32);
    eval 'sub GetAPen {
        local($rp) = @_;
	    eval q( ($IGraphics->{GetAPen})($rp));
    }' unless defined(&GetAPen);
    eval 'sub GetBPen {
        local($rp) = @_;
	    eval q( ($IGraphics->{GetBPen})($rp));
    }' unless defined(&GetBPen);
    eval 'sub GetDrMd {
        local($rp) = @_;
	    eval q( ($IGraphics->{GetDrMd})($rp));
    }' unless defined(&GetDrMd);
    eval 'sub GetOutlinePen {
        local($rp) = @_;
	    eval q( ($IGraphics->{GetOutlinePen})($rp));
    }' unless defined(&GetOutlinePen);
    eval 'sub LoadRGB32 {
        local($vp, $table) = @_;
	    eval q( ($IGraphics->{LoadRGB32})($vp, $table));
    }' unless defined(&LoadRGB32);
    eval 'sub SetChipRev {
        local($want) = @_;
	    eval q( ($IGraphics->{SetChipRev})($want));
    }' unless defined(&SetChipRev);
    eval 'sub SetABPenDrMd {
        local($rp, $apen, $bpen, $drawmode) = @_;
	    eval q( ($IGraphics->{SetABPenDrMd})($rp, $apen, $bpen, $drawmode));
    }' unless defined(&SetABPenDrMd);
    eval 'sub GetRGB32 {
        local($cm, $firstcolor, $ncolors, $table) = @_;
	    eval q( ($IGraphics->{GetRGB32})($cm, $firstcolor, $ncolors, $table));
    }' unless defined(&GetRGB32);
    eval 'sub AllocBitMap {
        local($sizex, $sizey, $depth, $flags, $friend_bitmap) = @_;
	    eval q( ($IGraphics->{AllocBitMap})($sizex, $sizey, $depth, $flags, $friend_bitmap));
    }' unless defined(&AllocBitMap);
    eval 'sub FreeBitMap {
        local($bm) = @_;
	    eval q( ($IGraphics->{FreeBitMap})($bm));
    }' unless defined(&FreeBitMap);
    eval 'sub GetExtSpriteA {
        local($ss, $tags) = @_;
	    eval q( ($IGraphics->{GetExtSpriteA})($ss, $tags));
    }' unless defined(&GetExtSpriteA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub GetExtSprite () {(...)  ($IGraphics->{GetExtSprite})( &__VA_ARGS__);}' unless defined(&GetExtSprite);
    }
    eval 'sub CoerceMode {
        local($vp, $monitorid, $flags) = @_;
	    eval q( ($IGraphics->{CoerceMode})($vp, $monitorid, $flags));
    }' unless defined(&CoerceMode);
    eval 'sub ChangeVPBitMap {
        local($vp, $bm, $db) = @_;
	    eval q( ($IGraphics->{ChangeVPBitMap})($vp, $bm, $db));
    }' unless defined(&ChangeVPBitMap);
    eval 'sub ReleasePen {
        local($cm, $n) = @_;
	    eval q( ($IGraphics->{ReleasePen})($cm, $n));
    }' unless defined(&ReleasePen);
    eval 'sub ObtainPen {
        local($cm, $n, $r, $g, $b, $f) = @_;
	    eval q( ($IGraphics->{O$btainPen})($cm, $n, $r, $g, $b, $f));
    }' unless defined(&ObtainPen);
    eval 'sub GetBitMapAttr {
        local($bm, $attrnum) = @_;
	    eval q( ($IGraphics->{GetBitMapAttr})($bm, $attrnum));
    }' unless defined(&GetBitMapAttr);
    eval 'sub AllocDBufInfo {
        local($vp) = @_;
	    eval q( ($IGraphics->{AllocDBufInfo})($vp));
    }' unless defined(&AllocDBufInfo);
    eval 'sub FreeDBufInfo {
        local($dbi) = @_;
	    eval q( ($IGraphics->{FreeDBufInfo})($dbi));
    }' unless defined(&FreeDBufInfo);
    eval 'sub SetOutlinePen {
        local($rp, $pen) = @_;
	    eval q( ($IGraphics->{SetOutlinePen})($rp, $pen));
    }' unless defined(&SetOutlinePen);
    eval 'sub SetWriteMask {
        local($rp, $msk) = @_;
	    eval q( ($IGraphics->{SetWriteMask})($rp, $msk));
    }' unless defined(&SetWriteMask);
    eval 'sub SetMaxPen {
        local($rp, $maxpen) = @_;
	    eval q( ($IGraphics->{SetMaxPen})($rp, $maxpen));
    }' unless defined(&SetMaxPen);
    eval 'sub SetRGB32CM {
        local($cm, $n, $r, $g, $b) = @_;
	    eval q( ($IGraphics->{SetRGB32CM})($cm, $n, $r, $g, $b));
    }' unless defined(&SetRGB32CM);
    eval 'sub ScrollRasterBF {
        local($rp, $dx, $dy, $xMin, $yMin, $xMax, $yMax) = @_;
	    eval q( ($IGraphics->{ScrollRasterBF})($rp, $dx, $dy, $xMin, $yMin, $xMax, $yMax));
    }' unless defined(&ScrollRasterBF);
    eval 'sub FindColor {
        local($cm, $r, $g, $b, $maxcolor) = @_;
	    eval q( ($IGraphics->{FindColor})($cm, $r, $g, $b, $maxcolor));
    }' unless defined(&FindColor);
    eval 'sub AllocSpriteDataA {
        local($bm, $tags) = @_;
	    eval q( ($IGraphics->{AllocSpriteDataA})($bm, $tags));
    }' unless defined(&AllocSpriteDataA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub AllocSpriteData () {(...)  ($IGraphics->{AllocSpriteData})( &__VA_ARGS__);}' unless defined(&AllocSpriteData);
    }
    eval 'sub ChangeExtSpriteA {
        local($vp, $oldsprite, $newsprite, $tags) = @_;
	    eval q( ($IGraphics->{ChangeExtSpriteA})($vp, $oldsprite, $newsprite, $tags));
    }' unless defined(&ChangeExtSpriteA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub ChangeExtSprite () {( &vp,  &oldsprite, ...)  ($IGraphics->{ChangeExtSprite})( &vp,  &oldsprite,  &__VA_ARGS__);}' unless defined(&ChangeExtSprite);
    }
    eval 'sub FreeSpriteData {
        local($sp) = @_;
	    eval q( ($IGraphics->{FreeSpriteData})($sp));
    }' unless defined(&FreeSpriteData);
    eval 'sub SetRPAttrsA {
        local($rp, $tags) = @_;
	    eval q( ($IGraphics->{SetRPAttrsA})($rp, $tags));
    }' unless defined(&SetRPAttrsA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub SetRPAttrs () {(...)  ($IGraphics->{SetRPAttrs})( &__VA_ARGS__);}' unless defined(&SetRPAttrs);
    }
    eval 'sub GetRPAttrsA {
        local($rp, $tags) = @_;
	    eval q( ($IGraphics->{GetRPAttrsA})($rp, $tags));
    }' unless defined(&GetRPAttrsA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub GetRPAttrs () {(...)  ($IGraphics->{GetRPAttrs})( &__VA_ARGS__);}' unless defined(&GetRPAttrs);
    }
    eval 'sub BestModeIDA {
        local($tags) = @_;
	    eval q( ($IGraphics->{BestModeIDA})($tags));
    }' unless defined(&BestModeIDA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub BestModeID () {(...)  ($IGraphics->{BestModeID})( &__VA_ARGS__);}' unless defined(&BestModeID);
    }
    eval 'sub WriteChunkyPixels {
        local($rp, $xstart, $ystart, $xstop, $ystop, $array, $bytesperrow) = @_;
	    eval q( ($IGraphics->{WriteChunkyPixels})($rp, $xstart, $ystart, $xstop, $ystop, $array, $bytesperrow));
    }' unless defined(&WriteChunkyPixels);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub SetupPixieField () {( &pixief, ...)  ($IPixie->{SetupPixieField})( &pixief,  &__VA_ARGS__);}' unless defined(&SetupPixieField);
    }
    eval 'sub CleanupPixieField {
        local($pixief) = @_;
	    eval q( ($IPixie->{CleanupPixieField})($pixief));
    }' unless defined(&CleanupPixieField);
    eval 'sub DrawPixieFieldA {
        local($pixief, $x, $y, $tags) = @_;
	    eval q( ($IPixie->{DrawPixieFieldA})($pixief, $x, $y, $tags));
    }' unless defined(&DrawPixieFieldA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub DrawPixieField () {( &pixief,  &x, ...)  ($IPixie->{DrawPixieField})( &pixief,  &x,  &__VA_ARGS__);}' unless defined(&DrawPixieField);
    }
    eval 'sub UndrawPixieField {
        local($pixief) = @_;
	    eval q( ($IPixie->{UndrawPixieField})($pixief));
    }' unless defined(&UndrawPixieField);
    eval 'sub NewPixieA {
        local($tags) = @_;
	    eval q( ($IPixie->{NewPixieA})($tags));
    }' unless defined(&NewPixieA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub NewPixie () {(...)  ($IPixie->{NewPixie})( &__VA_ARGS__);}' unless defined(&NewPixie);
    }
    eval 'sub DisposePixie {
        local($pixie) = @_;
	    eval q( ($IPixie->{DisposePixie})($pixie));
    }' unless defined(&DisposePixie);
    eval 'sub AttachPixie {
        local($pixie, $pixief) = @_;
	    eval q( ($IPixie->{AttachPixie})($pixie, $pixief));
    }' unless defined(&AttachPixie);
    eval 'sub DetachPixie {
        local($pixie) = @_;
	    eval q( ($IPixie->{DetachPixie})($pixie));
    }' unless defined(&DetachPixie);
    eval 'sub SetPixieAttrsA {
        local($pixie, $tags) = @_;
	    eval q( ($IPixie->{SetPixieAttrsA})($pixie, $tags));
    }' unless defined(&SetPixieAttrsA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub SetPixieAttrs () {(...)  ($IPixie->{SetPixieAttrs})( &__VA_ARGS__);}' unless defined(&SetPixieAttrs);
    }
    eval 'sub GetPixieAttrsA {
        local($pixie, $tags) = @_;
	    eval q( ($IPixie->{GetPixieAttrsA})($pixie, $tags));
    }' unless defined(&GetPixieAttrsA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub GetPixieAttrs () {(...)  ($IPixie->{GetPixieAttrs})( &__VA_ARGS__);}' unless defined(&GetPixieAttrs);
    }
}
1;
