require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&INLINE4_BSDSOCKET_H)) {
    eval 'sub INLINE4_BSDSOCKET_H () {1;}' unless defined(&INLINE4_BSDSOCKET_H);
    unless(defined(&EXEC_TYPES_H)) {
	require 'exec/types.ph';
    }
    unless(defined(&EXEC_EXEC_H)) {
	require 'exec/exec.ph';
    }
    unless(defined(&EXEC_INTERFACES_H)) {
	require 'exec/interfaces.ph';
    }
    unless(defined(&EXEC_LISTS_H)) {
	require 'exec/lists.ph';
    }
    unless(defined(&DEVICES_TIMER_H)) {
	require 'devices/timer.ph';
    }
    unless(defined(&UTILITY_TAGITEM_H)) {
	require 'utility/tagitem.ph';
    }
    unless(defined(&UTILITY_HOOKS_H)) {
	require 'utility/hooks.ph';
    }
    unless(defined(&NETINET_IN_H)) {
	require 'netinet/in.ph';
    }
    unless(defined(&SYS_SOCKET_H)) {
	require 'sys/socket.ph';
    }
    unless(defined(&SYS_MBUF_H)) {
	require 'sys/mbuf.ph';
    }
    unless(defined(&NET_ROUTE_H)) {
	require 'net/route.ph';
    }
    unless(defined(&NETDB_H)) {
	require 'netdb.ph';
    }
    unless(defined(&LIBRARIES_BSDSOCKET_H)) {
	require 'libraries/bsdsocket.ph';
    }
    unless(defined(&DOS_DOSEXTENS_H)) {
	require 'dos/dosextens.ph';
    }
    eval 'sub socket {
        local($domain, $type, $protocol) = @_;
	    eval q( ($ISocket->{socket})($domain, $type, $protocol));
    }' unless defined(&socket);
    eval 'sub bind {
        local($sock, $name, $namelen) = @_;
	    eval q( ($ISocket->{bind})($sock, $name, $namelen));
    }' unless defined(&bind);
    eval 'sub listen {
        local($sock, $backlog) = @_;
	    eval q( ($ISocket->{listen})($sock, $backlog));
    }' unless defined(&listen);
    eval 'sub accept {
        local($sock, $addr, $addrlen) = @_;
	    eval q( ($ISocket->{accept})($sock, $addr, $addrlen));
    }' unless defined(&accept);
    eval 'sub connect {
        local($sock, $name, $namelen) = @_;
	    eval q( ($ISocket->{connect})($sock, $name, $namelen));
    }' unless defined(&connect);
    eval 'sub sendto {
        local($sock, $buf, $len, $flags, $to, $tolen) = @_;
	    eval q( ($ISocket->{sendto})($sock, $buf, $len, $flags, $to, $tolen));
    }' unless defined(&sendto);
    eval 'sub send {
        local($sock, $buf, $len, $flags) = @_;
	    eval q( ($ISocket->{send})($sock, $buf, $len, $flags));
    }' unless defined(&send);
    eval 'sub recvfrom {
        local($sock, $buf, $len, $flags, $addr, $addrlen) = @_;
	    eval q( ($ISocket->{recvfrom})($sock, $buf, $len, $flags, $addr, $addrlen));
    }' unless defined(&recvfrom);
    eval 'sub recv {
        local($sock, $buf, $len, $flags) = @_;
	    eval q( ($ISocket->{recv})($sock, $buf, $len, $flags));
    }' unless defined(&recv);
    eval 'sub shutdown {
        local($sock, $how) = @_;
	    eval q( ($ISocket->{shutdown})($sock, $how));
    }' unless defined(&shutdown);
    eval 'sub setsockopt {
        local($sock, $level, $optname, $optval, $optlen) = @_;
	    eval q( ($ISocket->{setsockopt})($sock, $level, $optname, $optval, $optlen));
    }' unless defined(&setsockopt);
    eval 'sub getsockopt {
        local($sock, $level, $optname, $optval, $optlen) = @_;
	    eval q( ($ISocket->{getsockopt})($sock, $level, $optname, $optval, $optlen));
    }' unless defined(&getsockopt);
    eval 'sub getsockname {
        local($sock, $name, $namelen) = @_;
	    eval q( ($ISocket->{getsockname})($sock, $name, $namelen));
    }' unless defined(&getsockname);
    eval 'sub getpeername {
        local($sock, $name, $namelen) = @_;
	    eval q( ($ISocket->{getpeername})($sock, $name, $namelen));
    }' unless defined(&getpeername);
    eval 'sub IoctlSocket {
        local($sock, $req, $argp) = @_;
	    eval q( ($ISocket->{IoctlSocket})($sock, $req, $argp));
    }' unless defined(&IoctlSocket);
    eval 'sub CloseSocket {
        local($sock) = @_;
	    eval q( ($ISocket->{CloseSocket})($sock));
    }' unless defined(&CloseSocket);
    eval 'sub WaitSelect {
        local($nfds, $read_fds, $write_fds, $except_fds, $timeout, $signals) = @_;
	    eval q( ($ISocket->{WaitSelect})($nfds, $read_fds, $write_fds, $except_fds, $timeout, $signals));
    }' unless defined(&WaitSelect);
    eval 'sub SetSocketSignals {
        local($int_mask, $io_mask, $urgent_mask) = @_;
	    eval q( ($ISocket->{SetSocketSignals})($int_mask, $io_mask, $urgent_mask));
    }' unless defined(&SetSocketSignals);
    eval 'sub getdtablesize () {
        eval q( ($ISocket->{getdtablesize})());
    }' unless defined(&getdtablesize);
    eval 'sub ObtainSocket {
        local($id, $domain, $type, $protocol) = @_;
	    eval q( ($ISocket->{ObtainSocket})($id, $domain, $type, $protocol));
    }' unless defined(&ObtainSocket);
    eval 'sub ReleaseSocket {
        local($sock, $id) = @_;
	    eval q( ($ISocket->{ReleaseSocket})($sock, $id));
    }' unless defined(&ReleaseSocket);
    eval 'sub ReleaseCopyOfSocket {
        local($sock, $id) = @_;
	    eval q( ($ISocket->{ReleaseCopyOfSocket})($sock, $id));
    }' unless defined(&ReleaseCopyOfSocket);
    eval 'sub Errno () {
        eval q( ($ISocket->{Errno})());
    }' unless defined(&Errno);
    eval 'sub SetErrnoPtr {
        local($errno_ptr, $size) = @_;
	    eval q( ($ISocket->{SetErrnoPtr})($errno_ptr, $size));
    }' unless defined(&SetErrnoPtr);
    eval 'sub Inet_NtoA {
        local($ip) = @_;
	    eval q( ($ISocket->{Inet_NtoA})($ip));
    }' unless defined(&Inet_NtoA);
    eval 'sub inet_addr {
        local($cp) = @_;
	    eval q( ($ISocket->{inet_addr})($cp));
    }' unless defined(&inet_addr);
    eval 'sub Inet_LnaOf {
        local($in) = @_;
	    eval q( ($ISocket->{Inet_LnaOf})($in));
    }' unless defined(&Inet_LnaOf);
    eval 'sub Inet_NetOf {
        local($in) = @_;
	    eval q( ($ISocket->{Inet_NetOf})($in));
    }' unless defined(&Inet_NetOf);
    eval 'sub Inet_MakeAddr {
        local($net, $host) = @_;
	    eval q( ($ISocket->{I$net_MakeAddr})($net, $host));
    }' unless defined(&Inet_MakeAddr);
    eval 'sub inet_network {
        local($cp) = @_;
	    eval q( ($ISocket->{inet_network})($cp));
    }' unless defined(&inet_network);
    eval 'sub gethostbyname {
        local($name) = @_;
	    eval q( ($ISocket->{gethostbyname})($name));
    }' unless defined(&gethostbyname);
    eval 'sub gethostbyaddr {
        local($addr, $len, $type) = @_;
	    eval q( ($ISocket->{gethostbyaddr})($addr, $len, $type));
    }' unless defined(&gethostbyaddr);
    eval 'sub getnetbyname {
        local($name) = @_;
	    eval q( ($ISocket->{getnetbyname})($name));
    }' unless defined(&getnetbyname);
    eval 'sub getnetbyaddr {
        local($net, $type) = @_;
	    eval q( ($ISocket->{getnetbyaddr})($net, $type));
    }' unless defined(&getnetbyaddr);
    eval 'sub getservbyname {
        local($name, $proto) = @_;
	    eval q( ($ISocket->{getservbyname})($name, $proto));
    }' unless defined(&getservbyname);
    eval 'sub getservbyport {
        local($port, $proto) = @_;
	    eval q( ($ISocket->{getservbyport})($port, $proto));
    }' unless defined(&getservbyport);
    eval 'sub getprotobyname {
        local($name) = @_;
	    eval q( ($ISocket->{getprotobyname})($name));
    }' unless defined(&getprotobyname);
    eval 'sub getprotobynumber {
        local($proto) = @_;
	    eval q( ($ISocket->{getprotobynumber})($proto));
    }' unless defined(&getprotobynumber);
    eval 'sub vsyslog {
        local($pri, $msg, $args) = @_;
	    eval q( ($ISocket->{vsyslog})($pri, $msg, $args));
    }' unless defined(&vsyslog);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub syslog () {( &pri, ...)  ($ISocket->{syslog})( &pri,  &__VA_ARGS__);}' unless defined(&syslog);
    }
    eval 'sub Dup2Socket {
        local($old_socket, $new_socket) = @_;
	    eval q( ($ISocket->{Dup2Socket})($old_socket, $new_socket));
    }' unless defined(&Dup2Socket);
    eval 'sub sendmsg {
        local($sock, $msg, $flags) = @_;
	    eval q( ($ISocket->{sendmsg})($sock, $msg, $flags));
    }' unless defined(&sendmsg);
    eval 'sub recvmsg {
        local($sock, $msg, $flags) = @_;
	    eval q( ($ISocket->{recvmsg})($sock, $msg, $flags));
    }' unless defined(&recvmsg);
    eval 'sub gethostname {
        local($name, $namelen) = @_;
	    eval q( ($ISocket->{gethostname})($name, $namelen));
    }' unless defined(&gethostname);
    eval 'sub gethostid () {
        eval q( ($ISocket->{gethostid})());
    }' unless defined(&gethostid);
    eval 'sub SocketBaseTagList {
        local($tags) = @_;
	    eval q( ($ISocket->{SocketBaseTagList})($tags));
    }' unless defined(&SocketBaseTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub SocketBaseTags () {(...)  ($ISocket->{SocketBaseTags})( &__VA_ARGS__);}' unless defined(&SocketBaseTags);
    }
    eval 'sub GetSocketEvents {
        local($event_ptr) = @_;
	    eval q( ($ISocket->{GetSocketEvents})($event_ptr));
    }' unless defined(&GetSocketEvents);
    eval 'sub bpf_open {
        local($channel) = @_;
	    eval q( ($ISocket->{bpf_open})($channel));
    }' unless defined(&bpf_open);
    eval 'sub bpf_close {
        local($channel) = @_;
	    eval q( ($ISocket->{bpf_close})($channel));
    }' unless defined(&bpf_close);
    eval 'sub bpf_read {
        local($channel, $buffer, $len) = @_;
	    eval q( ($ISocket->{bpf_read})($channel, $buffer, $len));
    }' unless defined(&bpf_read);
    eval 'sub bpf_write {
        local($channel, $buffer, $len) = @_;
	    eval q( ($ISocket->{bpf_write})($channel, $buffer, $len));
    }' unless defined(&bpf_write);
    eval 'sub bpf_set_notify_mask {
        local($channel, $signal_mask) = @_;
	    eval q( ($ISocket->{bpf_set_notify_mask})($channel, $signal_mask));
    }' unless defined(&bpf_set_notify_mask);
    eval 'sub bpf_set_interrupt_mask {
        local($channel, $signal_mask) = @_;
	    eval q( ($ISocket->{bpf_set_interrupt_mask})($channel, $signal_mask));
    }' unless defined(&bpf_set_interrupt_mask);
    eval 'sub bpf_ioctl {
        local($channel, $command, $buffer) = @_;
	    eval q( ($ISocket->{bpf_ioctl})($channel, $command, $buffer));
    }' unless defined(&bpf_ioctl);
    eval 'sub bpf_data_waiting {
        local($channel) = @_;
	    eval q( ($ISocket->{bpf_data_waiting})($channel));
    }' unless defined(&bpf_data_waiting);
    eval 'sub AddRouteTagList {
        local($tags) = @_;
	    eval q( ($ISocket->{AddRouteTagList})($tags));
    }' unless defined(&AddRouteTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub AddRouteTags () {(...)  ($ISocket->{AddRouteTags})( &__VA_ARGS__);}' unless defined(&AddRouteTags);
    }
    eval 'sub DeleteRouteTagList {
        local($tags) = @_;
	    eval q( ($ISocket->{DeleteRouteTagList})($tags));
    }' unless defined(&DeleteRouteTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub DeleteRouteTags () {(...)  ($ISocket->{DeleteRouteTags})( &__VA_ARGS__);}' unless defined(&DeleteRouteTags);
    }
    eval 'sub ChangeRouteTagList {
        local($tags) = @_;
	    eval q( ($ISocket->{ChangeRouteTagList})($tags));
    }' unless defined(&ChangeRouteTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub ChangeRouteTags () {(...)  ($ISocket->{ChangeRouteTags})( &__VA_ARGS__);}' unless defined(&ChangeRouteTags);
    }
    eval 'sub FreeRouteInfo {
        local($buf) = @_;
	    eval q( ($ISocket->{FreeRouteInfo})($buf));
    }' unless defined(&FreeRouteInfo);
    eval 'sub GetRouteInfo {
        local($address_family, $flags) = @_;
	    eval q( ($ISocket->{GetRouteInfo})($address_family, $flags));
    }' unless defined(&GetRouteInfo);
    eval 'sub AddInterfaceTagList {
        local($interface_name, $device_name, $unit, $tags) = @_;
	    eval q( ($ISocket->{AddInterfaceTagList})($interface_name, $device_name, $unit, $tags));
    }' unless defined(&AddInterfaceTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub AddInterfaceTags () {( &interface_name,  &device_name, ...)  ($ISocket->{AddInterfaceTags})( &interface_name,  &device_name,  &__VA_ARGS__);}' unless defined(&AddInterfaceTags);
    }
    eval 'sub ConfigureInterfaceTagList {
        local($interface_name, $tags) = @_;
	    eval q( ($ISocket->{ConfigureInterfaceTagList})($interface_name, $tags));
    }' unless defined(&ConfigureInterfaceTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub ConfigureInterfaceTags () {(...)  ($ISocket->{ConfigureInterfaceTags})( &__VA_ARGS__);}' unless defined(&ConfigureInterfaceTags);
    }
    eval 'sub ReleaseInterfaceList {
        local($list) = @_;
	    eval q( ($ISocket->{ReleaseInterfaceList})($list));
    }' unless defined(&ReleaseInterfaceList);
    eval 'sub ObtainInterfaceList () {
        eval q( ($ISocket->{ObtainInterfaceList})());
    }' unless defined(&ObtainInterfaceList);
    eval 'sub QueryInterfaceTagList {
        local($interface_name, $tags) = @_;
	    eval q( ($ISocket->{QueryInterfaceTagList})($interface_name, $tags));
    }' unless defined(&QueryInterfaceTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub QueryInterfaceTags () {(...)  ($ISocket->{QueryInterfaceTags})( &__VA_ARGS__);}' unless defined(&QueryInterfaceTags);
    }
    eval 'sub CreateAddrAllocMessageA {
        local($version, $protocol, $interface_name, $result_ptr, $tags) = @_;
	    eval q( ($ISocket->{CreateAddrAllocMessageA})($version, $protocol, $interface_name, $result_ptr, $tags));
    }' unless defined(&CreateAddrAllocMessageA);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub CreateAddrAllocMessage () {( &version,  &protocol,  &interface_name, ...)  ($ISocket->{CreateAddrAllocMessage})( &version,  &protocol,  &interface_name,  &__VA_ARGS__);}' unless defined(&CreateAddrAllocMessage);
    }
    eval 'sub DeleteAddrAllocMessage {
        local($aam) = @_;
	    eval q( ($ISocket->{DeleteAddrAllocMessage})($aam));
    }' unless defined(&DeleteAddrAllocMessage);
    eval 'sub BeginInterfaceConfig {
        local($message) = @_;
	    eval q( ($ISocket->{BeginInterfaceConfig})($message));
    }' unless defined(&BeginInterfaceConfig);
    eval 'sub AbortInterfaceConfig {
        local($message) = @_;
	    eval q( ($ISocket->{AbortInterfaceConfig})($message));
    }' unless defined(&AbortInterfaceConfig);
    eval 'sub AddNetMonitorHookTagList {
        local($type, $hook, $tags) = @_;
	    eval q( ($ISocket->{AddNetMonitorHookTagList})($type, $hook, $tags));
    }' unless defined(&AddNetMonitorHookTagList);
    if(!defined( &__cplusplus)  && ((defined(&__GNUC__) ? &__GNUC__ : 0) >= 3|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 2 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) || ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : 0) >= 199901))) {
	eval 'sub AddNetMonitorHookTags () {( &type, ...)  ($ISocket->{AddNetMonitorHookTags})( &type,  &__VA_ARGS__);}' unless defined(&AddNetMonitorHookTags);
    }
    eval 'sub RemoveNetMonitorHook {
        local($hook) = @_;
	    eval q( ($ISocket->{RemoveNetMonitorHook})($hook));
    }' unless defined(&RemoveNetMonitorHook);
    eval 'sub GetNetworkStatistics {
        local($type, $version, $destination, $size) = @_;
	    eval q( ($ISocket->{GetNetworkStatistics})($type, $version, $destination, $size));
    }' unless defined(&GetNetworkStatistics);
    eval 'sub AddDomainNameServer {
        local($address) = @_;
	    eval q( ($ISocket->{AddDomainNameServer})($address));
    }' unless defined(&AddDomainNameServer);
    eval 'sub RemoveDomainNameServer {
        local($address) = @_;
	    eval q( ($ISocket->{RemoveDomainNameServer})($address));
    }' unless defined(&RemoveDomainNameServer);
    eval 'sub ReleaseDomainNameServerList {
        local($list) = @_;
	    eval q( ($ISocket->{ReleaseDomainNameServerList})($list));
    }' unless defined(&ReleaseDomainNameServerList);
    eval 'sub ObtainDomainNameServerList () {
        eval q( ($ISocket->{ObtainDomainNameServerList})());
    }' unless defined(&ObtainDomainNameServerList);
    eval 'sub setnetent {
        local($stay_open) = @_;
	    eval q( ($ISocket->{setnetent})($stay_open));
    }' unless defined(&setnetent);
    eval 'sub endnetent () {
        eval q( ($ISocket->{endnetent})());
    }' unless defined(&endnetent);
    eval 'sub getnetent () {
        eval q( ($ISocket->{getnetent})());
    }' unless defined(&getnetent);
    eval 'sub setprotoent {
        local($stay_open) = @_;
	    eval q( ($ISocket->{setprotoent})($stay_open));
    }' unless defined(&setprotoent);
    eval 'sub endprotoent () {
        eval q( ($ISocket->{endprotoent})());
    }' unless defined(&endprotoent);
    eval 'sub getprotoent () {
        eval q( ($ISocket->{getprotoent})());
    }' unless defined(&getprotoent);
    eval 'sub setservent {
        local($stay_open) = @_;
	    eval q( ($ISocket->{setservent})($stay_open));
    }' unless defined(&setservent);
    eval 'sub endservent () {
        eval q( ($ISocket->{endservent})());
    }' unless defined(&endservent);
    eval 'sub getservent () {
        eval q( ($ISocket->{getservent})());
    }' unless defined(&getservent);
    eval 'sub inet_aton {
        local($cp, $addr) = @_;
	    eval q( ($ISocket->{inet_aton})($cp, $addr));
    }' unless defined(&inet_aton);
    eval 'sub inet_ntop {
        local($af, $src, $dst, $size) = @_;
	    eval q( ($ISocket->{inet_ntop})($af, $src, $dst, $size));
    }' unless defined(&inet_ntop);
    eval 'sub inet_pton {
        local($af, $src, $dst) = @_;
	    eval q( ($ISocket->{inet_pton})($af, $src, $dst));
    }' unless defined(&inet_pton);
    eval 'sub In_LocalAddr {
        local($address) = @_;
	    eval q( ($ISocket->{In_LocalAddr})($address));
    }' unless defined(&In_LocalAddr);
    eval 'sub In_CanForward {
        local($address) = @_;
	    eval q( ($ISocket->{In_CanForward})($address));
    }' unless defined(&In_CanForward);
    eval 'sub mbuf_copym {
        local($m, $off, $len) = @_;
	    eval q( ($ISocket->{mbuf_copym})($m, $off, $len));
    }' unless defined(&mbuf_copym);
    eval 'sub mbuf_copyback {
        local($m, $off, $len, $cp) = @_;
	    eval q( ($ISocket->{mbuf_copyback})($m, $off, $len, $cp));
    }' unless defined(&mbuf_copyback);
    eval 'sub mbuf_copydata {
        local($m, $off, $len, $cp) = @_;
	    eval q( ($ISocket->{mbuf_copydata})($m, $off, $len, $cp));
    }' unless defined(&mbuf_copydata);
    eval 'sub mbuf_free {
        local($m) = @_;
	    eval q( ($ISocket->{mbuf_free})($m));
    }' unless defined(&mbuf_free);
    eval 'sub mbuf_freem {
        local($m) = @_;
	    eval q( ($ISocket->{mbuf_freem})($m));
    }' unless defined(&mbuf_freem);
    eval 'sub mbuf_get () {
        eval q( ($ISocket->{mbuf_get})());
    }' unless defined(&mbuf_get);
    eval 'sub mbuf_gethdr () {
        eval q( ($ISocket->{mbuf_gethdr})());
    }' unless defined(&mbuf_gethdr);
    eval 'sub mbuf_prepend {
        local($m, $len) = @_;
	    eval q( ($ISocket->{mbuf_prepend})($m, $len));
    }' unless defined(&mbuf_prepend);
    eval 'sub mbuf_cat {
        local($m, $n) = @_;
	    eval q( ($ISocket->{mbuf_cat})($m, $n));
    }' unless defined(&mbuf_cat);
    eval 'sub mbuf_adj {
        local($mp, $req_len) = @_;
	    eval q( ($ISocket->{mbuf_adj})($mp, $req_len));
    }' unless defined(&mbuf_adj);
    eval 'sub mbuf_pullup {
        local($m, $len) = @_;
	    eval q( ($ISocket->{mbuf_pullup})($m, $len));
    }' unless defined(&mbuf_pullup);
    eval 'sub ProcessIsServer {
        local($pr) = @_;
	    eval q( ($ISocket->{ProcessIsServer})($pr));
    }' unless defined(&ProcessIsServer);
    eval 'sub ObtainServerSocket () {
        eval q( ($ISocket->{ObtainServerSocket})());
    }' unless defined(&ObtainServerSocket);
    eval 'sub ipf_open {
        local($channel) = @_;
	    eval q( ($ISocket->{ipf_open})($channel));
    }' unless defined(&ipf_open);
    eval 'sub ipf_close {
        local($channel) = @_;
	    eval q( ($ISocket->{ipf_close})($channel));
    }' unless defined(&ipf_close);
    eval 'sub ipf_ioctl {
        local($channel, $command, $buffer) = @_;
	    eval q( ($ISocket->{ipf_ioctl})($channel, $command, $buffer));
    }' unless defined(&ipf_ioctl);
    eval 'sub ipf_log_read {
        local($channel, $buffer, $len) = @_;
	    eval q( ($ISocket->{ipf_log_read})($channel, $buffer, $len));
    }' unless defined(&ipf_log_read);
    eval 'sub ipf_log_data_waiting {
        local($channel) = @_;
	    eval q( ($ISocket->{ipf_log_data_waiting})($channel));
    }' unless defined(&ipf_log_data_waiting);
    eval 'sub ipf_set_notify_mask {
        local($channel, $mask) = @_;
	    eval q( ($ISocket->{ipf_set_notify_mask})($channel, $mask));
    }' unless defined(&ipf_set_notify_mask);
    eval 'sub ipf_set_interrupt_mask {
        local($channel, $mask) = @_;
	    eval q( ($ISocket->{ipf_set_interrupt_mask})($channel, $mask));
    }' unless defined(&ipf_set_interrupt_mask);
}
1;
