package Reaction::Menu;

use 5.008005;
use strict;
use warnings;
use Carp;

require Exporter;
use AutoLoader;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration       use Reaction::Menu ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
CreateMenus
FreeMenus
LayoutMenus
LayoutMenuItems
GetVisualInfo
FreeVisualInfo
MakeNewMenuArray
FreeNewMenuArray
GetMenuItemUserData

) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
);

our $VERSION = '0.02';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "&Reaction::Menu::constant not defined" if $constname eq 'constant';
    my ($error, $val) = constant($constname);
    if ($error) { croak $error; }
    {
        no strict 'refs';
        # Fixed between 5.005_53 and 5.005_61
#XXX    if ($] >= 5.00561) {
#XXX        *$AUTOLOAD = sub () { $val };
#XXX    }
#XXX    else {
            *$AUTOLOAD = sub { $val };
#XXX    }
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load('Reaction::Menu', $VERSION);

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

Reaction::Menu - Perl extension for Reaction Menus

=head1 SYNOPSIS

  use Reaction::Menu;

=head1 DESCRIPTION


=head2 EXPORT

None by default.

=head2 Exportable Functions

CreateMenus
FreeMenus
LayoutMenus
LayoutMenuItems
GetVisualInfo
FreeVisualInfo

$array = MakeNewMenuArray($num, @elements);

Allocate and fill in an array of struct NewMenu for use with
CreateMenus. Values for each entry in the array are passed via the list
@elements in groups of 6. No elements may be omitted and the function
will fail if $#elements != 6 * num;

($type, $label , $key, $flags, $mutualexclude, $userdata);

When using in conjunction with Reaction::Window::RA_Handleinput() $userdata should be
a unique numerical id.

$label and $key will be interpreted as string data. In the underlying NewMenu structure
To have no Command Key you pass NULL in nm_ComKey, for this perl interface however pass
"" (empty string) and the XS code will translate this into a NULL pointer.



FreeNewMenuArray($newmenus)

Free the array alloacated above.

You must ensure that strings passed for labels survive for the life of the menu.



=head1 SEE ALSO

gadtools autodocs and libraries/gadtools.h


=head1 AUTHOR

Andy Broad E<lt>andy@broad.ology.org.ukE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Andy Broad.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.5 or,
at your option, any later version of Perl 5 you may have available.


=cut
