#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <exec/lists.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/graphics.h>
#include <proto/intuition.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}


typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}

BOOL myIsEmptyList(struct List *l)
{
    return ( ((l)->lh_TailPred) == (struct Node *)(l) );

}

MODULE = Reaction               PACKAGE = Reaction

ULONG
IDoMethod(obj,  msg, ...)
    APTR obj;
    intArray * msg;
    CODE:
        RETVAL = IIntuition->IDoMethodA(obj, ( Msg )msg);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(msg);

ULONG
DoGadgetMethod(gad, win, req, msg, ...)
    APTR gad;
    APTR win;
    APTR req;
    intArray *msg;
    CODE:
        RETVAL = IIntuition->DoGadgetMethod(gad,win, req, (Msg)msg);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(msg);



ULONG
GetAttr(AttrID, obj, tagtype, StoragePtr)
    ULONG AttrID;
    APTR obj;
    ULONG  tagtype;
    TAGRET &StoragePtr;
    CODE:
        RETVAL = IIntuition->GetAttr(AttrID, obj, &StoragePtr);
    OUTPUT:
        RETVAL
        StoragePtr

intArray *
GetAttrs(node, tags, ...)
    APTR node;
    intArray *tags;
    PREINIT:
        U32 size_RETVAL;
    CODE:
        IIntuition->GetAttrsA(node, (struct TagItem *)tags);
        size_RETVAL = ix_tags;
        RETVAL = tags;
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);
        XSRETURN(size_RETVAL);



ULONG
SetAttrs(obj, tags, ...)
    APTR obj;
    TagList *tags;
    CODE:
        RETVAL = IIntuition->SetAttrsA(obj, tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);




ULONG
SetGadgetAttrs(gad, win, req, tags, ...)
    APTR gad;
    APTR win;
    APTR req;
    TagList *tags;
    CODE:
        RETVAL = IIntuition->SetGadgetAttrsA(gad, win, req, (struct TagItem *)tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);



void
RefreshSetGadgetAttrs(gad, win, req, tags, ...)
    APTR gad;
    APTR win;
    APTR req;
    TagList *tags;
    CODE:
        IIntuition->RefreshSetGadgetAttrsA(gad, win, req, (struct TagItem *)tags);
    CLEANUP:
        Safefree(tags);


UWORD
AddGadget(win, gad, pos)
    APTR win;
    APTR gad;
    UWORD pos;
    CODE:
        RETVAL = IIntuition->AddGadget(win, gad, pos);
    OUTPUT:
        RETVAL

UWORD
RemoveGadget(win, gad)
    APTR win;
    APTR gad;
    CODE:
        RETVAL = IIntuition->RemoveGadget(win, gad);
    OUTPUT:
        RETVAL



UWORD
AddGList(win, gad, pos, num, req)
    APTR win;
    APTR gad;
    UWORD pos;
    WORD num;
    APTR req;
    CODE:
        RETVAL = IIntuition->AddGList(win, gad, pos, num, req);
    OUTPUT:
        RETVAL

UWORD
RemoveGList(win, gad , num)
    APTR win;
    APTR gad;
    WORD num;
    CODE:
        RETVAL = IIntuition->RemoveGList(win, gad, num);
    OUTPUT:
        RETVAL


void
RefreshGList(gad, win ,req , numgad)
    APTR gad;
    APTR win;
    APTR req;
    ULONG numgad;
    CODE:
        IIntuition->RefreshGList(gad, win, req, numgad);




void
DisposeObject(obj)
    APTR obj;
    CODE:
        IIntuition->DisposeObject(obj);


APTR
LockPubScreen(name)
    char *name;
    CODE:
        RETVAL = IIntuition->LockPubScreen(name);
    OUTPUT:
        RETVAL


void
UnlockPubScreen(pubscreen)
    APTR pubscreen;
    CODE:
        IIntuition->UnlockPubScreen(NULL,pubscreen);


APTR
GetScreenDrawInfo(screen)
    APTR screen;
    CODE:
        RETVAL = IIntuition->GetScreenDrawInfo(screen);
    OUTPUT:
        RETVAL



void
FreeScreenDrawInfo(screen, dri)
    APTR screen;
    APTR dri;
    CODE:
        IIntuition->FreeScreenDrawInfo(screen, dri);


UWORD
GetDrawInfoVersion(dri)
    APTR dri;
    CODE:
        RETVAL = ((struct DrawInfo *)dri)->dri_Version;
    OUTPUT:
        RETVAL


UWORD
GetDrawInfoPen(dri, pen)
    APTR dri;
    ULONG pen;
    CODE:
        RETVAL = ((struct DrawInfo *)dri)->dri_Pens[pen];
    OUTPUT:
        RETVAL



LONG
ObtainBestScreenPen(screen, R, G, B, tags, ...)
    APTR screen;
    ULONG R;
    ULONG G;
    ULONG B;
    TagList *tags;
    CODE:
        RETVAL = IGraphics->ObtainBestPenA(((struct Screen *)screen)->ViewPort.ColorMap,R,G,B,(struct TagItem *)tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


ULONG
Wait(signals, ...)
    intArray *signals;
    CODE:
        {
            int i;
            ULONG csigs =0;
            for(i = 0; i < ix_signals;i++)
            {
                csigs |= signals[i];
            }

            RETVAL = IExec->Wait(csigs);
        }
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(signals);


APTR
AllocList()
    CODE:
        RETVAL = IExec->AllocSysObjectTags(ASOT_LIST,ASOLIST_Type,NT_UNKNOWN,TAG_DONE);
    OUTPUT:
        RETVAL


void
FreeList(list)
    APTR list;
    CODE:
        IExec->FreeSysObject(ASOT_LIST,list);



void NewList(list)
    APTR list;
    CODE:
        IExec->NewList((struct List *)list);


BOOL
IsEmptyList(list)
    APTR list;
    CODE:
        RETVAL = myIsEmptyList((struct List *)list);
    OUTPUT:
        RETVAL


void
AddHead(list,node)
    APTR list;
    APTR node;
    CODE:
        IExec->AddHead((struct List *)list, (struct Node *)node);

void
AddTail(list,node)
    APTR list;
    APTR node;
    CODE:
        IExec->AddTail((struct List *)list, (struct Node *)node);



APTR
RemHead(list)
    APTR list;
    CODE:
        RETVAL = IExec->RemHead(list);
    OUTPUT:
        RETVAL

APTR
RemTail(list)
    APTR list;
    CODE:
        RETVAL = IExec->RemTail(list);
    OUTPUT:
        RETVAL


void
Remove(node)
    APTR node;
    CODE:
        IExec->Remove((struct Node *)node);


void
Insert(list,node,listNode)
    APTR list;
    APTR node;
    APTR listNode;
    CODE:
        IExec->Insert(list, node, listNode);


APTR
GetHead(list)
    APTR list;
    CODE:
        RETVAL = IExec->GetHead((struct List *)list);
    OUTPUT:
        RETVAL


APTR
GetTail(list)
    APTR list;
    CODE:
        RETVAL = IExec->GetTail((struct List *)list);
    OUTPUT:
        RETVAL


APTR
GetPred(node)
    APTR node;
    CODE:
        RETVAL = IExec->GetPred((struct Node *)node);
    OUTPUT:
        RETVAL

APTR
GetSucc(node)
    APTR node;
    CODE:
        RETVAL = IExec->GetSucc((struct Node *)node);
    OUTPUT:
        RETVAL



APTR
CreateMsgPort()
    CODE:
        RETVAL = IExec->CreateMsgPort();
    OUTPUT:
        RETVAL



void
DeleteMsgPort(port)
    APTR port;
    CODE:
        IExec->DeleteMsgPort((struct MsgPort *)port);


SV *
ptrtostr(str)
    APTR str;
    CODE:
        RETVAL = newSVpv((char *)str,0);
    OUTPUT:
        RETVAL


APTR
AllocBuffer(size)
    ULONG size;
    CODE:
        RETVAL = IExec->AllocVec(size,MEMF_ANY|MEMF_CLEAR);
    OUTPUT:
        RETVAL


void
FreeBuffer(buffer)
    APTR buffer;
    CODE:
        IExec->FreeVec(buffer);


APTR
strtobuffer(str)
    char *str;
    CODE:
        {
            char *buf = IExec->AllocVec(strlen(str) +1,MEMF_ANY|MEMF_CLEAR);
            if (buf)
            {
                strcpy(buf,str);
            }
            RETVAL = buf;
        }
    OUTPUT:
        RETVAL


APTR
strntobuffer(str,n)
    char *str;
    int n;
    CODE:
        {
            char *buf = IExec->AllocVec(n + 1, MEMF_ANY|MEMF_CLEAR);
            if(buf)
            {
                memcpy(buf,str,n);
            }
            RETVAL = buf;
        }
    OUTPUT:
        RETVAL



