#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/drawlist.h>
#include <images/drawlist.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Images::DrawList              PACKAGE = Reaction::Images::Drawlist

PROTOTYPES: DISABLE

APTR
DrawListObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IDrawList->DRAWLIST_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);
