#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/virtual.h>
#include <gadgets/virtual.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Gadgets::Virtual              PACKAGE = Reaction::Gadgets::Virtual

PROTOTYPES: DISABLE

APTR
VirtualObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IVirtual->VIRTUAL_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


void
RefreshVirtualGadget(gad, virtual, win, req)
    APTR gad;
    APTR virtual;
    APTR win;
    APTR req;
    CODE:
        IVirtual->RefreshVirtualGadget(gad, virtual, win, req);


BOOL
RethinkVirtualSize(virtual, rootlayout, font, screen)
    APTR virtual
    APTR rootlayout;
    APTR font;
    APTR screen;
    PREINIT:
       int minw;
       int minh;
       int maxw;
       int maxh;
    PPCODE:
        {
            struct LayoutLimits l;
            IVirtual->RethinkVirtualSize(virtual,rootlayout,font,screen, &l);
            minw = (int)l.MinWidth;
            minh = (int)l.MinHeight;
            maxw = (int)l.MaxWidth;
            maxh = (int)l.MaxHeight;
            EXTEND(SP,4);
            PUSHs(sv_2mortal(newSViv(minw)));
            PUSHs(sv_2mortal(newSViv(minh)));
            PUSHs(sv_2mortal(newSViv(maxw)));
            PUSHs(sv_2mortal(newSViv(maxh)));

        }


