#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/radiobutton.h>
#include <gadgets/radiobutton.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Gadgets::RadioButton              PACKAGE = Reaction::Gadgets::RadioButton

PROTOTYPES: DISABLE

APTR
RadioButtonObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IRadioButton->RADIOBUTTON_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
AllocRadioButtonNode(pri, tags, ...)
    UWORD pri;
    TagList *tags;
    CODE:
        RETVAL = IRadioButton->AllocRadioButtonNodeA(pri, tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);

void
FreeRadioButtonNode(node)
    APTR node;
    CODE:
        IRadioButton->FreeRadioButtonNode((struct Node *)node);


intArray *
GetRadioButtonNodeAttrs(node, tags, ...)
    APTR node;
    intArray *tags;
    PREINIT:
        U32 size_RETVAL;
    CODE:
        IRadioButton->GetRadioButtonNodeAttrsA(node, tags);
        size_RETVAL = ix_tags;
        RETVAL = tags;
    CLEANUP:
        Safefree(tags);
        XSRETURN(size_RETVAL);

void
GetRadioButtonNodeAttr(tag, node, tagtype, dest)
    ULONG tag;
    APTR node;
    ULONG tagtype;
    TAGRET &dest;
    CODE:
        IRadioButton->GetRadioButtonNodeAttrs(node, tag, &dest, TAG_DONE);
    OUTPUT:
        dest


void
SetRadioButtonNodeAttrs(node, tags, ...)
    APTR node;
    TagList *tags;
    CODE:
        IRadioButton->SetRadioButtonNodeAttrsA(node, tags);
    CLEANUP:
        Safefree(tags);



