#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "../../tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/listbrowser.h>
#include <gadgets/listbrowser.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


STRPTR dupstr(STRPTR src)
{
    STRPTR dest = NULL;
    ULONG len;
    if(src)
    {
        len = strlen(src);
        dest = IExec->AllocVec(len + 1, MEMF_ANY);
        strcpy(dest,src);
    }
    return dest;
}

MODULE = Reaction::Gadgets::ListBrowser              PACKAGE = Reaction::Gadgets::ListBrowser

PROTOTYPES: DISABLE

APTR
ListBrowserObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IListBrowser->LISTBROWSER_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
AllocListBrowserNode(columns,tags,...)
    ULONG columns;
    TagList * tags;
    CODE:
        RETVAL = IListBrowser->AllocListBrowserNodeA(columns,(struct TagItem *)tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


void
FreeListBrowserNode(node)
    APTR node;
    CODE:
        IListBrowser->FreeListBrowserNode(node);


void
FreeListBrowserList(list)
    APTR list;
    CODE:
        IListBrowser->FreeListBrowserList(list);



void
SetListBrowserNodeAttrs(node, tags, ...)
    APTR node;
    TagList *tags;
    CODE:
        IListBrowser->SetListBrowserNodeAttrsA(node, (struct TagItem *)tags);
    CLEANUP:
        Safefree(tags);



intArray *
GetListBrowserNodeAttrs(node, tags, ...)
    APTR node;
    intArray *tags;
    PREINIT:
        U32 size_RETVAL;
    CODE:
        IListBrowser->GetListBrowserNodeAttrsA(node, (struct TagItem *)tags);
        size_RETVAL = ix_tags;
        RETVAL = tags;
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);
        XSRETURN(size_RETVAL);


void
GetListBrowserNodeAttr(tag,node,tagtype, dest)
    ULONG tag;
    APTR node;
    ULONG tagtype;
    TAGRET &dest;
    CODE:
        IListBrowser->GetListBrowserNodeAttrs(node,tag,&dest,TAG_DONE);
    OUTPUT:
        dest




void
ListBrowserSelectAll(list)
    APTR list;
    CODE:
        IListBrowser->ListBrowserSelectAll(list);


void
HideAllListBrowserChildren(list)
    APTR list;
    CODE:
        IListBrowser->HideAllListBrowserChildren(list);


void
HideAllListBrowserNodeChildren(node)
    APTR node;
    CODE:
        IListBrowser->HideListBrowserNodeChildren(node);




void
ShowAllListBrowserChildren(list)
    APTR list;
    CODE:
        IListBrowser->ShowAllListBrowserChildren(list);


void
ShowListBrowserNodeChildren(node, depth)
    APTR node;
    ULONG depth;
    CODE:
        IListBrowser->ShowListBrowserNodeChildren(node, depth);


void
ListBrowserClearAll(list)
    APTR list;
    CODE:
        IListBrowser->ListBrowserClearAll(list);

APTR
MakeColumnInfoArray(num, ...)
    LONG num;
    CODE:
        {
            struct ColumnInfo *ci = NULL;
            int i;
            void * vec = NULL;;
            if(num == (items -1) / 3)
            {
                if((vec = IExec->AllocVec((num * sizeof(struct ColumnInfo)) + sizeof(ULONG),MEMF_CLEAR|MEMF_ANY)))
                {
                    ci = vec + sizeof(ULONG);
                    *((ULONG *)vec) = num;
                    for(i = 0; i < num; i++)
                    {
                        ci[i].ci_Width    = (WORD)SvIV(ST((i * 3)+1));
                        ci[i].ci_Title   = dupstr((STRPTR)SvPV_nolen(ST((i*3)+2)));
                        ci[i].ci_Flags   = (ULONG)SvUV(ST((i * 3) +3));
                    }
                }
            }
            else
            {
                Perl_croak(aTHX_ "MakeColumnInfoArray called with wrong number of arguments");
            }
            RETVAL = ci;
        }
    OUTPUT:
        RETVAL


void FreeColumnInfoArray(ci)
    APTR ci;
    CODE:
        {
            void *vec;
            ULONG num;
            int i;
            struct ColumnInfo *_ci = ci;
            vec = ci - sizeof(ULONG);
            num = *((ULONG *)vec);
            for(i = 0; i < num; i++)
            {
                if( _ci[i].ci_Title)
                {
                    IExec->FreeVec(_ci[i].ci_Title);
                }
            }
            IExec->FreeVec(vec);
        }


APTR
LBMAddNode(lbr,win,req,after,tags,...)
    APTR lbr;
    APTR win;
    APTR req;
    APTR after;
    TagList *tags;
    CODE:
        RETVAL = IIntuition->DoGadgetMethod(lbr,win,req,LBM_ADDNODE,0,after,tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);



ULONG
LBMRemNode(lbr,win,req,node)
    APTR lbr;
    APTR win;
    APTR req;
    APTR node;
    CODE:
        RETVAL = IIntuition->DoGadgetMethod(lbr,win,req,LBM_REMNODE,0,node);
    OUTPUT:
        RETVAL


ULONG
LBMEditNode(lbr,win,req,node,tags,...)
    APTR lbr;
    APTR win;
    APTR req;
    APTR node;
    TagList *tags;
    CODE:
        RETVAL =IIntuition->DoGadgetMethod(lbr,win,req,LBM_EDITNODE,0,node,tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);






