#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/clicktab.h>
#include <gadgets/clicktab.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}

MODULE = Reaction::Gadgets::ClickTab              PACKAGE = Reaction::Gadgets::ClickTab

PROTOTYPES: DISABLE

APTR
ClickTabObject(taglist, ...)
    intArray * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IClickTab->CLICKTAB_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
AllocClickTabNode(tags,...)
    intArray * tags;
    CODE:
        RETVAL = IClickTab->AllocClickTabNodeA(tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


void
FreeClickTabNode(node)
    APTR node;
    CODE:
        IClickTab->FreeClickTabNode(node);


void
SetClickTabNodeAttrs(node, tags, ...)
    APTR node;
    intArray *tags;
    CODE:
        IClickTab->SetClickTabNodeAttrsA(node, tags);


intArray *
GetClickTabNodeAttrs(node, tags, ...)
    APTR node;
    intArray *tags;
    PREINIT:
        U32 size_RETVAL;
    CODE:
        IClickTab->GetClickTabNodeAttrsA(node, tags);
        size_RETVAL = ix_tags;
        RETVAL = tags;
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);
        XSRETURN(size_RETVAL);

void
GetClickTabNodeAttr(tag, node, tagtype, dest)
    ULONG tag;
    APTR node;
    ULONG tagtype;
    TAGRET &dest;
    CODE:
        IClickTab->GetClickTabNodeAttrs(node, tag, &dest, TAG_DONE);
    OUTPUT:
        dest



