#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/window.h>
#include <classes/window.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Classes::Window              PACKAGE = Reaction::Classes::Window

PROTOTYPES: DISABLE

APTR
WindowObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IWindow->WINDOW_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
RA_OpenWindow(win)
    APTR win
    CODE:
        RETVAL = IIntuition->IDoMethod(win, WM_OPEN, NULL);
    OUTPUT:
        RETVAL

void
RA_CloseWindow(win)
    APTR win
    CODE:
         IIntuition->IDoMethod(win, WM_CLOSE, NULL);

ULONG
RA_HandleInput(win)
    APTR win
    PREINIT:
        int result;
        WORD code;
    PPCODE:
        result = IIntuition->IDoMethod(win, WM_HANDLEINPUT, &code);
        EXTEND(SP,2);
        PUSHs(sv_2mortal(newSViv(result)));
        PUSHs(sv_2mortal(newSViv(code)));


BOOL
RA_Iconify(win)
    APTR win
    CODE:
        RETVAL = IIntuition->IDoMethod(win, WM_ICONIFY, NULL);
    OUTPUT:
        RETVAL

