#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/popupmenu.h>
#include <classes/popupmenu.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}

MODULE = Reaction::Classes::PopupMenu              PACKAGE = Reaction::Classes::PopupMenu

PROTOTYPES: DISABLE

APTR
PopupMenuObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IPopupMenu->POPUPMENU_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
PopupItemObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IPopupMenu->POPUPMENU_GetItemClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
POPUPMENU_MakeIDList(tags, ...)
    TagList *tags;
    CODE:
        RETVAL = IPopupMenu->POPUPMENU_MakeIDListA((struct TagItem *)tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


void
POPUPMENU_FreeIDList(list)
    APTR list;
    CODE:
        IPopupMenu->POPUPMENU_FreeIDList(list);


APTR
POPUPMENU_MakeMXList(id, ...)
    TagList *id;
    CODE:
        RETVAL = IPopupMenu->POPUPMENU_MakeIDListA((ULONG *)id);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(id);



