#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/arexx.h>
#include <classes/arexx.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Classes::ARexx              PACKAGE = Reaction::Classes::ARexx

PROTOTYPES: DISABLE

APTR
ARexxObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IARexx->AREXX_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


void
RA_HandleRexx(rexx)
    APTR rexx;
    CODE:
        IIntuition->IDoMethod(rexx, AM_HANDLEEVENT);


void
RA_FlushRexx(rexx)
    APTR rexx;
    CODE:
        IIntuition->IDoMethod(rexx, AM_FLUSH);


