#ifndef _AMIGAOSEXPORT_H
#define _AMIGAOSEXPORT_H
#include "EXTERN.h"
#include "perl.h"
#include <pthread.h>

struct aPerlAPI
{
PerlInterpreter* (*  perl_alloc)( );
void (*  perl_construct )(PerlInterpreter* interp );
int (*  perl_destruct )(PerlInterpreter* interp );
void (*  perl_free )(PerlInterpreter* interp );
int (*  perl_run )(PerlInterpreter* interp );
int (*  perl_parse )(PerlInterpreter* interp, XSINIT_t xsinit , int argc, char** argv, char** env );
bool (*  Perl_doing_taint )(int argc, char** argv, char** env );
PerlInterpreter* (* perl_clone)(PerlInterpreter* interp, UV flags );
Malloc_t (* Perl_malloc )(MEM_SIZE nbytes );
Malloc_t (* Perl_calloc )(MEM_SIZE elements, MEM_SIZE size );
Malloc_t (* Perl_realloc )(Malloc_t where, MEM_SIZE nbytes );
Free_t (*  Perl_mfree )(Malloc_t where );
void* (*  Perl_get_context)( );
void (*  Perl_set_context )(void *thx );
OP* (* Perl_ck_anoncode)(pTHX_ OP* o);
OP* (* Perl_ck_bitop)(pTHX_ OP* o);
OP* (* Perl_ck_concat)(pTHX_ OP* o);
OP* (* Perl_ck_defined)(pTHX_ OP* o);
OP* (* Perl_ck_delete)(pTHX_ OP* o);
OP* (* Perl_ck_die)(pTHX_ OP* o);
OP* (* Perl_ck_eof)(pTHX_ OP* o);
OP* (* Perl_ck_eval)(pTHX_ OP* o);
OP* (* Perl_ck_exec)(pTHX_ OP* o);
OP* (* Perl_ck_exists)(pTHX_ OP* o);
OP* (* Perl_ck_exit)(pTHX_ OP* o);
OP* (* Perl_ck_ftst)(pTHX_ OP* o);
OP* (* Perl_ck_fun)(pTHX_ OP* o);
OP* (* Perl_ck_glob)(pTHX_ OP* o);
OP* (* Perl_ck_grep)(pTHX_ OP* o);
OP* (* Perl_ck_index)(pTHX_ OP* o);
OP* (* Perl_ck_join)(pTHX_ OP* o);
OP* (* Perl_ck_lengthconst)(pTHX_ OP* o);
OP* (* Perl_ck_lfun)(pTHX_ OP* o);
OP* (* Perl_ck_listiob)(pTHX_ OP* o);
OP* (* Perl_ck_match)(pTHX_ OP* o);
OP* (* Perl_ck_method)(pTHX_ OP* o);
OP* (* Perl_ck_null)(pTHX_ OP* o);
OP* (* Perl_ck_open)(pTHX_ OP* o);
OP* (* Perl_ck_repeat)(pTHX_ OP* o);
OP* (* Perl_ck_require)(pTHX_ OP* o);
OP* (* Perl_ck_return)(pTHX_ OP* o);
OP* (* Perl_ck_rfun)(pTHX_ OP* o);
OP* (* Perl_ck_rvconst)(pTHX_ OP* o);
OP* (* Perl_ck_sassign)(pTHX_ OP* o);
OP* (* Perl_ck_select)(pTHX_ OP* o);
OP* (* Perl_ck_shift)(pTHX_ OP* o);
OP* (* Perl_ck_sort)(pTHX_ OP* o);
OP* (* Perl_ck_spair)(pTHX_ OP* o);
OP* (* Perl_ck_split)(pTHX_ OP* o);
OP* (* Perl_ck_subr)(pTHX_ OP* o);
OP* (* Perl_ck_substr)(pTHX_ OP* o);
OP* (* Perl_ck_svconst)(pTHX_ OP* o);
OP* (* Perl_ck_trunc)(pTHX_ OP* o);
OP* (* Perl_pp_null)(pTHX);
OP* (* Perl_pp_stub)(pTHX);
OP* (* Perl_pp_scalar)(pTHX);
OP* (* Perl_pp_pushmark)(pTHX);
OP* (* Perl_pp_wantarray)(pTHX);
OP* (* Perl_pp_const)(pTHX);
OP* (* Perl_pp_gvsv)(pTHX);
OP* (* Perl_pp_gv)(pTHX);
OP* (* Perl_pp_gelem)(pTHX);
OP* (* Perl_pp_padsv)(pTHX);
OP* (* Perl_pp_padav)(pTHX);
OP* (* Perl_pp_padhv)(pTHX);
OP* (* Perl_pp_padany)(pTHX);
OP* (* Perl_pp_pushre)(pTHX);
OP* (* Perl_pp_rv2gv)(pTHX);
OP* (* Perl_pp_rv2sv)(pTHX);
OP* (* Perl_pp_av2arylen)(pTHX);
OP* (* Perl_pp_rv2cv)(pTHX);
OP* (* Perl_pp_anoncode)(pTHX);
OP* (* Perl_pp_prototype)(pTHX);
OP* (* Perl_pp_refgen)(pTHX);
OP* (* Perl_pp_srefgen)(pTHX);
OP* (* Perl_pp_ref)(pTHX);
OP* (* Perl_pp_bless)(pTHX);
OP* (* Perl_pp_backtick)(pTHX);
OP* (* Perl_pp_glob)(pTHX);
OP* (* Perl_pp_readline)(pTHX);
OP* (* Perl_pp_rcatline)(pTHX);
OP* (* Perl_pp_regcmaybe)(pTHX);
OP* (* Perl_pp_regcreset)(pTHX);
OP* (* Perl_pp_regcomp)(pTHX);
OP* (* Perl_pp_match)(pTHX);
OP* (* Perl_pp_qr)(pTHX);
OP* (* Perl_pp_subst)(pTHX);
OP* (* Perl_pp_substcont)(pTHX);
OP* (* Perl_pp_trans)(pTHX);
OP* (* Perl_pp_sassign)(pTHX);
OP* (* Perl_pp_aassign)(pTHX);
OP* (* Perl_pp_chop)(pTHX);
OP* (* Perl_pp_schop)(pTHX);
OP* (* Perl_pp_chomp)(pTHX);
OP* (* Perl_pp_schomp)(pTHX);
OP* (* Perl_pp_defined)(pTHX);
OP* (* Perl_pp_undef)(pTHX);
OP* (* Perl_pp_study)(pTHX);
OP* (* Perl_pp_pos)(pTHX);
OP* (* Perl_pp_preinc)(pTHX);
OP* (* Perl_pp_predec)(pTHX);
OP* (* Perl_pp_postinc)(pTHX);
OP* (* Perl_pp_postdec)(pTHX);
OP* (* Perl_pp_pow)(pTHX);
OP* (* Perl_pp_multiply)(pTHX);
OP* (* Perl_pp_i_multiply)(pTHX);
OP* (* Perl_pp_divide)(pTHX);
OP* (* Perl_pp_i_divide)(pTHX);
OP* (* Perl_pp_modulo)(pTHX);
OP* (* Perl_pp_i_modulo)(pTHX);
OP* (* Perl_pp_repeat)(pTHX);
OP* (* Perl_pp_add)(pTHX);
OP* (* Perl_pp_i_add)(pTHX);
OP* (* Perl_pp_subtract)(pTHX);
OP* (* Perl_pp_i_subtract)(pTHX);
OP* (* Perl_pp_concat)(pTHX);
OP* (* Perl_pp_stringify)(pTHX);
OP* (* Perl_pp_left_shift)(pTHX);
OP* (* Perl_pp_right_shift)(pTHX);
OP* (* Perl_pp_lt)(pTHX);
OP* (* Perl_pp_i_lt)(pTHX);
OP* (* Perl_pp_gt)(pTHX);
OP* (* Perl_pp_i_gt)(pTHX);
OP* (* Perl_pp_le)(pTHX);
OP* (* Perl_pp_i_le)(pTHX);
OP* (* Perl_pp_ge)(pTHX);
OP* (* Perl_pp_i_ge)(pTHX);
OP* (* Perl_pp_eq)(pTHX);
OP* (* Perl_pp_i_eq)(pTHX);
OP* (* Perl_pp_ne)(pTHX);
OP* (* Perl_pp_i_ne)(pTHX);
OP* (* Perl_pp_ncmp)(pTHX);
OP* (* Perl_pp_i_ncmp)(pTHX);
OP* (* Perl_pp_slt)(pTHX);
OP* (* Perl_pp_sgt)(pTHX);
OP* (* Perl_pp_sle)(pTHX);
OP* (* Perl_pp_sge)(pTHX);
OP* (* Perl_pp_seq)(pTHX);
OP* (* Perl_pp_sne)(pTHX);
OP* (* Perl_pp_scmp)(pTHX);
OP* (* Perl_pp_bit_and)(pTHX);
OP* (* Perl_pp_bit_xor)(pTHX);
OP* (* Perl_pp_bit_or)(pTHX);
OP* (* Perl_pp_negate)(pTHX);
OP* (* Perl_pp_i_negate)(pTHX);
OP* (* Perl_pp_not)(pTHX);
OP* (* Perl_pp_complement)(pTHX);
OP* (* Perl_pp_atan2)(pTHX);
OP* (* Perl_pp_sin)(pTHX);
OP* (* Perl_pp_cos)(pTHX);
OP* (* Perl_pp_rand)(pTHX);
OP* (* Perl_pp_srand)(pTHX);
OP* (* Perl_pp_exp)(pTHX);
OP* (* Perl_pp_log)(pTHX);
OP* (* Perl_pp_sqrt)(pTHX);
OP* (* Perl_pp_int)(pTHX);
OP* (* Perl_pp_hex)(pTHX);
OP* (* Perl_pp_oct)(pTHX);
OP* (* Perl_pp_abs)(pTHX);
OP* (* Perl_pp_length)(pTHX);
OP* (* Perl_pp_substr)(pTHX);
OP* (* Perl_pp_vec)(pTHX);
OP* (* Perl_pp_index)(pTHX);
OP* (* Perl_pp_rindex)(pTHX);
OP* (* Perl_pp_sprintf)(pTHX);
OP* (* Perl_pp_formline)(pTHX);
OP* (* Perl_pp_ord)(pTHX);
OP* (* Perl_pp_chr)(pTHX);
OP* (* Perl_pp_crypt)(pTHX);
OP* (* Perl_pp_ucfirst)(pTHX);
OP* (* Perl_pp_lcfirst)(pTHX);
OP* (* Perl_pp_uc)(pTHX);
OP* (* Perl_pp_lc)(pTHX);
OP* (* Perl_pp_quotemeta)(pTHX);
OP* (* Perl_pp_rv2av)(pTHX);
OP* (* Perl_pp_aelemfast)(pTHX);
OP* (* Perl_pp_aelem)(pTHX);
OP* (* Perl_pp_aslice)(pTHX);
OP* (* Perl_pp_each)(pTHX);
OP* (* Perl_pp_values)(pTHX);
OP* (* Perl_pp_keys)(pTHX);
OP* (* Perl_pp_delete)(pTHX);
OP* (* Perl_pp_exists)(pTHX);
OP* (* Perl_pp_rv2hv)(pTHX);
OP* (* Perl_pp_helem)(pTHX);
OP* (* Perl_pp_hslice)(pTHX);
OP* (* Perl_pp_unpack)(pTHX);
OP* (* Perl_pp_pack)(pTHX);
OP* (* Perl_pp_split)(pTHX);
OP* (* Perl_pp_join)(pTHX);
OP* (* Perl_pp_list)(pTHX);
OP* (* Perl_pp_lslice)(pTHX);
OP* (* Perl_pp_anonlist)(pTHX);
OP* (* Perl_pp_anonhash)(pTHX);
OP* (* Perl_pp_splice)(pTHX);
OP* (* Perl_pp_push)(pTHX);
OP* (* Perl_pp_pop)(pTHX);
OP* (* Perl_pp_shift)(pTHX);
OP* (* Perl_pp_unshift)(pTHX);
OP* (* Perl_pp_sort)(pTHX);
OP* (* Perl_pp_reverse)(pTHX);
OP* (* Perl_pp_grepstart)(pTHX);
OP* (* Perl_pp_grepwhile)(pTHX);
OP* (* Perl_pp_mapstart)(pTHX);
OP* (* Perl_pp_mapwhile)(pTHX);
OP* (* Perl_pp_range)(pTHX);
OP* (* Perl_pp_flip)(pTHX);
OP* (* Perl_pp_flop)(pTHX);
OP* (* Perl_pp_and)(pTHX);
OP* (* Perl_pp_or)(pTHX);
OP* (* Perl_pp_xor)(pTHX);
OP* (* Perl_pp_cond_expr)(pTHX);
OP* (* Perl_pp_andassign)(pTHX);
OP* (* Perl_pp_orassign)(pTHX);
OP* (* Perl_pp_method)(pTHX);
OP* (* Perl_pp_entersub)(pTHX);
OP* (* Perl_pp_leavesub)(pTHX);
OP* (* Perl_pp_leavesublv)(pTHX);
OP* (* Perl_pp_caller)(pTHX);
OP* (* Perl_pp_warn)(pTHX);
OP* (* Perl_pp_die)(pTHX);
OP* (* Perl_pp_reset)(pTHX);
OP* (* Perl_pp_lineseq)(pTHX);
OP* (* Perl_pp_nextstate)(pTHX);
OP* (* Perl_pp_dbstate)(pTHX);
OP* (* Perl_pp_unstack)(pTHX);
OP* (* Perl_pp_enter)(pTHX);
OP* (* Perl_pp_leave)(pTHX);
OP* (* Perl_pp_scope)(pTHX);
OP* (* Perl_pp_enteriter)(pTHX);
OP* (* Perl_pp_iter)(pTHX);
OP* (* Perl_pp_enterloop)(pTHX);
OP* (* Perl_pp_leaveloop)(pTHX);
OP* (* Perl_pp_return)(pTHX);
OP* (* Perl_pp_last)(pTHX);
OP* (* Perl_pp_next)(pTHX);
OP* (* Perl_pp_redo)(pTHX);
OP* (* Perl_pp_dump)(pTHX);
OP* (* Perl_pp_goto)(pTHX);
OP* (* Perl_pp_exit)(pTHX);
OP* (* Perl_pp_open)(pTHX);
OP* (* Perl_pp_close)(pTHX);
OP* (* Perl_pp_pipe_op)(pTHX);
OP* (* Perl_pp_fileno)(pTHX);
OP* (* Perl_pp_umask)(pTHX);
OP* (* Perl_pp_binmode)(pTHX);
OP* (* Perl_pp_tie)(pTHX);
OP* (* Perl_pp_untie)(pTHX);
OP* (* Perl_pp_tied)(pTHX);
OP* (* Perl_pp_dbmopen)(pTHX);
OP* (* Perl_pp_dbmclose)(pTHX);
OP* (* Perl_pp_sselect)(pTHX);
OP* (* Perl_pp_select)(pTHX);
OP* (* Perl_pp_getc)(pTHX);
OP* (* Perl_pp_read)(pTHX);
OP* (* Perl_pp_enterwrite)(pTHX);
OP* (* Perl_pp_leavewrite)(pTHX);
OP* (* Perl_pp_prtf)(pTHX);
OP* (* Perl_pp_print)(pTHX);
OP* (* Perl_pp_sysopen)(pTHX);
OP* (* Perl_pp_sysseek)(pTHX);
OP* (* Perl_pp_sysread)(pTHX);
OP* (* Perl_pp_syswrite)(pTHX);
OP* (* Perl_pp_send)(pTHX);
OP* (* Perl_pp_recv)(pTHX);
OP* (* Perl_pp_eof)(pTHX);
OP* (* Perl_pp_tell)(pTHX);
OP* (* Perl_pp_seek)(pTHX);
OP* (* Perl_pp_truncate)(pTHX);
OP* (* Perl_pp_fcntl)(pTHX);
OP* (* Perl_pp_ioctl)(pTHX);
OP* (* Perl_pp_flock)(pTHX);
OP* (* Perl_pp_socket)(pTHX);
OP* (* Perl_pp_sockpair)(pTHX);
OP* (* Perl_pp_bind)(pTHX);
OP* (* Perl_pp_connect)(pTHX);
OP* (* Perl_pp_listen)(pTHX);
OP* (* Perl_pp_accept)(pTHX);
OP* (* Perl_pp_shutdown)(pTHX);
OP* (* Perl_pp_gsockopt)(pTHX);
OP* (* Perl_pp_ssockopt)(pTHX);
OP* (* Perl_pp_getsockname)(pTHX);
OP* (* Perl_pp_getpeername)(pTHX);
OP* (* Perl_pp_lstat)(pTHX);
OP* (* Perl_pp_stat)(pTHX);
OP* (* Perl_pp_ftrread)(pTHX);
OP* (* Perl_pp_ftrwrite)(pTHX);
OP* (* Perl_pp_ftrexec)(pTHX);
OP* (* Perl_pp_fteread)(pTHX);
OP* (* Perl_pp_ftewrite)(pTHX);
OP* (* Perl_pp_fteexec)(pTHX);
OP* (* Perl_pp_ftis)(pTHX);
OP* (* Perl_pp_fteowned)(pTHX);
OP* (* Perl_pp_ftrowned)(pTHX);
OP* (* Perl_pp_ftzero)(pTHX);
OP* (* Perl_pp_ftsize)(pTHX);
OP* (* Perl_pp_ftmtime)(pTHX);
OP* (* Perl_pp_ftatime)(pTHX);
OP* (* Perl_pp_ftctime)(pTHX);
OP* (* Perl_pp_ftsock)(pTHX);
OP* (* Perl_pp_ftchr)(pTHX);
OP* (* Perl_pp_ftblk)(pTHX);
OP* (* Perl_pp_ftfile)(pTHX);
OP* (* Perl_pp_ftdir)(pTHX);
OP* (* Perl_pp_ftpipe)(pTHX);
OP* (* Perl_pp_ftlink)(pTHX);
OP* (* Perl_pp_ftsuid)(pTHX);
OP* (* Perl_pp_ftsgid)(pTHX);
OP* (* Perl_pp_ftsvtx)(pTHX);
OP* (* Perl_pp_fttty)(pTHX);
OP* (* Perl_pp_fttext)(pTHX);
OP* (* Perl_pp_ftbinary)(pTHX);
OP* (* Perl_pp_chdir)(pTHX);
OP* (* Perl_pp_chown)(pTHX);
OP* (* Perl_pp_chroot)(pTHX);
OP* (* Perl_pp_unlink)(pTHX);
OP* (* Perl_pp_chmod)(pTHX);
OP* (* Perl_pp_utime)(pTHX);
OP* (* Perl_pp_rename)(pTHX);
OP* (* Perl_pp_link)(pTHX);
OP* (* Perl_pp_symlink)(pTHX);
OP* (* Perl_pp_readlink)(pTHX);
OP* (* Perl_pp_mkdir)(pTHX);
OP* (* Perl_pp_rmdir)(pTHX);
OP* (* Perl_pp_open_dir)(pTHX);
OP* (* Perl_pp_readdir)(pTHX);
OP* (* Perl_pp_telldir)(pTHX);
OP* (* Perl_pp_seekdir)(pTHX);
OP* (* Perl_pp_rewinddir)(pTHX);
OP* (* Perl_pp_closedir)(pTHX);
OP* (* Perl_pp_fork)(pTHX);
OP* (* Perl_pp_wait)(pTHX);
OP* (* Perl_pp_waitpid)(pTHX);
OP* (* Perl_pp_system)(pTHX);
OP* (* Perl_pp_exec)(pTHX);
OP* (* Perl_pp_kill)(pTHX);
OP* (* Perl_pp_getppid)(pTHX);
OP* (* Perl_pp_getpgrp)(pTHX);
OP* (* Perl_pp_setpgrp)(pTHX);
OP* (* Perl_pp_getpriority)(pTHX);
OP* (* Perl_pp_setpriority)(pTHX);
OP* (* Perl_pp_time)(pTHX);
OP* (* Perl_pp_tms)(pTHX);
OP* (* Perl_pp_localtime)(pTHX);
OP* (* Perl_pp_gmtime)(pTHX);
OP* (* Perl_pp_alarm)(pTHX);
OP* (* Perl_pp_sleep)(pTHX);
OP* (* Perl_pp_shmget)(pTHX);
OP* (* Perl_pp_shmctl)(pTHX);
OP* (* Perl_pp_shmread)(pTHX);
OP* (* Perl_pp_shmwrite)(pTHX);
OP* (* Perl_pp_msgget)(pTHX);
OP* (* Perl_pp_msgctl)(pTHX);
OP* (* Perl_pp_msgsnd)(pTHX);
OP* (* Perl_pp_msgrcv)(pTHX);
OP* (* Perl_pp_semget)(pTHX);
OP* (* Perl_pp_semctl)(pTHX);
OP* (* Perl_pp_semop)(pTHX);
OP* (* Perl_pp_require)(pTHX);
OP* (* Perl_pp_dofile)(pTHX);
OP* (* Perl_pp_entereval)(pTHX);
OP* (* Perl_pp_leaveeval)(pTHX);
OP* (* Perl_pp_entertry)(pTHX);
OP* (* Perl_pp_leavetry)(pTHX);
OP* (* Perl_pp_ghbyname)(pTHX);
OP* (* Perl_pp_ghbyaddr)(pTHX);
OP* (* Perl_pp_ghostent)(pTHX);
OP* (* Perl_pp_gnbyname)(pTHX);
OP* (* Perl_pp_gnbyaddr)(pTHX);
OP* (* Perl_pp_gnetent)(pTHX);
OP* (* Perl_pp_gpbyname)(pTHX);
OP* (* Perl_pp_gpbynumber)(pTHX);
OP* (* Perl_pp_gprotoent)(pTHX);
OP* (* Perl_pp_gsbyname)(pTHX);
OP* (* Perl_pp_gsbyport)(pTHX);
OP* (* Perl_pp_gservent)(pTHX);
OP* (* Perl_pp_shostent)(pTHX);
OP* (* Perl_pp_snetent)(pTHX);
OP* (* Perl_pp_sprotoent)(pTHX);
OP* (* Perl_pp_sservent)(pTHX);
OP* (* Perl_pp_ehostent)(pTHX);
OP* (* Perl_pp_enetent)(pTHX);
OP* (* Perl_pp_eprotoent)(pTHX);
OP* (* Perl_pp_eservent)(pTHX);
OP* (* Perl_pp_gpwnam)(pTHX);
OP* (* Perl_pp_gpwuid)(pTHX);
OP* (* Perl_pp_gpwent)(pTHX);
OP* (* Perl_pp_spwent)(pTHX);
OP* (* Perl_pp_epwent)(pTHX);
OP* (* Perl_pp_ggrnam)(pTHX);
OP* (* Perl_pp_ggrgid)(pTHX);
OP* (* Perl_pp_ggrent)(pTHX);
OP* (* Perl_pp_sgrent)(pTHX);
OP* (* Perl_pp_egrent)(pTHX);
OP* (* Perl_pp_getlogin)(pTHX);
OP* (* Perl_pp_syscall)(pTHX);
OP* (* Perl_pp_lock)(pTHX);
OP* (* Perl_pp_threadsv)(pTHX);
OP* (* Perl_pp_setstate)(pTHX);
OP* (* Perl_pp_method_named)(pTHX);
SV* (*  Perl_amagic_call )( pTHX_ SV* left, SV* right, int method, int dir );
bool (*  Perl_Gv_AMupdate )( pTHX_ HV* stash );
CV* (*  Perl_gv_handler )( pTHX_ HV* stash, I32 id );
void (*  Perl_apply_attrs_string)( pTHX_ char *stashpv, CV *cv, char *attrstr, STRLEN len );
SV* (*  Perl_avhv_delete_ent)( pTHX_ AV *ar, SV* keysv, I32 flags, U32 hash );
bool (*  Perl_avhv_exists_ent)( pTHX_ AV *ar, SV* keysv, U32 hash );
SV** (*  Perl_avhv_fetch_ent )( pTHX_ AV *ar, SV* keysv, I32 lval, U32 hash );
SV** (*  Perl_avhv_store_ent )( pTHX_ AV *ar, SV* keysv, SV* val, U32 hash );
HE* (*  Perl_avhv_iternext )( pTHX_ AV *ar );
SV* (*  Perl_avhv_iterval )( pTHX_ AV *ar, HE* entry );
HV* (*  Perl_avhv_keys )( pTHX_ AV *ar );
void (*  Perl_av_clear )( pTHX_ AV* ar );
SV* (*  Perl_av_delete )( pTHX_ AV* ar, I32 key, I32 flags );
bool (*  Perl_av_exists )( pTHX_ AV* ar, I32 key );
void (*  Perl_av_extend )( pTHX_ AV* ar, I32 key );
SV** (*  Perl_av_fetch )( pTHX_ AV* ar, I32 key, I32 lval );
void (*  Perl_av_fill )( pTHX_ AV* ar, I32 fill );
I32 (*  Perl_av_len )( pTHX_ AV* ar );
AV* (*  Perl_av_make )( pTHX_ I32 size, SV** svp );
SV* (*  Perl_av_pop )( pTHX_ AV* ar );
void (*  Perl_av_push )( pTHX_ AV* ar, SV* val );
SV* (*  Perl_av_shift )( pTHX_ AV* ar );
SV** (*  Perl_av_store )( pTHX_ AV* ar, I32 key, SV* val );
void (*  Perl_av_undef )( pTHX_ AV* ar );
void (*  Perl_av_unshift )( pTHX_ AV* ar, I32 num );
I32 (*  Perl_block_gimme)( pTHX );
void (*  Perl_call_list )( pTHX_ I32 oldscope, AV* av_list );
U32 (*  Perl_cast_ulong )( pTHX_ NV f );
I32 (*  Perl_cast_i32 )( pTHX_ NV f );
IV (*  Perl_cast_iv )( pTHX_ NV f );
UV (*  Perl_cast_uv )( pTHX_ NV f );
void (*  Perl_croak )( pTHX_ const char* pat, ... );
void (*  Perl_vcroak )( pTHX_ const char* pat, va_list* args );
void (*  Perl_croak_nocontext)(const char* pat, ... );
OP* (*  Perl_die_nocontext )(const char* pat, ... );
void (*  Perl_deb_nocontext )(const char* pat, ... );
char* (*  Perl_form_nocontext )(const char* pat, ... );
void (*  Perl_load_module_nocontext)(U32 flags, SV* name, SV* ver, ... );
SV* (*  Perl_mess_nocontext )(const char* pat, ... );
void (*  Perl_warn_nocontext )(const char* pat, ... );
void (*  Perl_warner_nocontext)(U32 err, const char* pat, ... );
SV* (*  Perl_newSVpvf_nocontext)(const char* pat, ... );
void (*  Perl_sv_catpvf_nocontext)(SV* sv, const char* pat, ... );
void (*  Perl_sv_setpvf_nocontext)(SV* sv, const char* pat, ... );
void (*  Perl_sv_catpvf_mg_nocontext)(SV* sv, const char* pat, ... );
void (*  Perl_sv_setpvf_mg_nocontext)(SV* sv, const char* pat, ... );
int (*  Perl_fprintf_nocontext)(PerlIO* stream, const char* fmt, ... );
int (*  Perl_printf_nocontext)(const char* fmt, ... );
SV* (*  Perl_cv_const_sv )( pTHX_ CV* cv );
void (*  Perl_cv_undef )( pTHX_ CV* cv );
void (*  Perl_cx_dump )( pTHX_ PERL_CONTEXT* cs );
SV* (*  Perl_filter_add )( pTHX_ filter_t funcp, SV* datasv );
void (*  Perl_filter_del )( pTHX_ filter_t funcp );
I32 (*  Perl_filter_read )( pTHX_ int idx, SV* buffer, int maxlen );
char** (*  Perl_get_op_descs)( pTHX);
char** (*  Perl_get_op_names)( pTHX);
PPADDR_t* (* Perl_get_ppaddr)( pTHX);
void (*  Perl_deb )( pTHX_ const char* pat, ... );
void (*  Perl_vdeb )( pTHX_ const char* pat, va_list* args );
void (*  Perl_debprofdump)( pTHX);
I32 (*  Perl_debop )( pTHX_ OP* o );
I32 (*  Perl_debstack)( pTHX);
I32 (*  Perl_debstackptrs)( pTHX);
char* (*  Perl_delimcpy )( pTHX_ char* to, char* toend, char* from , char* fromend, int delim, I32* retlen );
OP* (*  Perl_die )( pTHX_ const char* pat, ... );
void (*  Perl_dounwind )( pTHX_ I32 cxix );
int (*  Perl_do_binmode )( pTHX_ PerlIO *fp, int iotype, int mode );
bool (*  Perl_do_close )( pTHX_ GV* gv, bool not_implicit );
void (*  Perl_do_join )( pTHX_ SV* sv, SV* del, SV** mark, SV** sp );
bool (*  Perl_do_open )( pTHX_ GV* gv, char* name, I32 len, int as_raw , int rawmode, int rawperm, PerlIO* supplied_fp );
bool (*  Perl_do_open9 )( pTHX_ GV *gv, char *name, I32 len, int as_raw , int rawmode, int rawperm, PerlIO *supplied_fp , SV *svs, I32 num );
bool (*  Perl_do_openn )( pTHX_ GV *gv, char *name, I32 len, int as_raw , int rawmode, int rawperm, PerlIO *supplied_fp , SV **svp, I32 num );
void (*  Perl_do_sprintf )( pTHX_ SV* sv, I32 len, SV** sarg );
I32 (*  Perl_dowantarray)( pTHX);
void (*  Perl_dump_all)( pTHX);
void (*  Perl_dump_eval)( pTHX);
void (*  Perl_dump_form )( pTHX_ GV* gv );
void (*  Perl_gv_dump )( pTHX_ GV* gv );
void (*  Perl_op_dump )( pTHX_ OP* arg );
void (*  Perl_pmop_dump )( pTHX_ PMOP* pm );
void (*  Perl_dump_packsubs )( pTHX_ HV* stash );
void (*  Perl_dump_sub )( pTHX_ GV* gv );
void (*  Perl_fbm_compile )( pTHX_ SV* sv, U32 flags );
char* (*  Perl_fbm_instr )( pTHX_ unsigned char* big, unsigned char* bigend , SV* littlesv, U32 flags );
char* (*  Perl_form )( pTHX_ const char* pat, ... );
char* (*  Perl_vform )( pTHX_ const char* pat, va_list* args );
void (*  Perl_free_tmps)( pTHX);
void (*  Perl_gp_free )( pTHX_ GV* gv );
GP* (*  Perl_gp_ref )( pTHX_ GP* gp );
GV* (*  Perl_gv_AVadd )( pTHX_ GV* gv );
GV* (*  Perl_gv_HVadd )( pTHX_ GV* gv );
GV* (*  Perl_gv_IOadd )( pTHX_ GV* gv );
GV* (*  Perl_gv_autoload4 )( pTHX_ HV* stash, const char* name, STRLEN len , I32 method );
void (*  Perl_gv_check )( pTHX_ HV* stash );
void (*  Perl_gv_efullname )( pTHX_ SV* sv, GV* gv );
void (*  Perl_gv_efullname3 )( pTHX_ SV* sv, GV* gv, const char* prefix );
void (*  Perl_gv_efullname4 )( pTHX_ SV* sv, GV* gv, const char* prefix, bool keepmain );
GV* (*  Perl_gv_fetchfile )( pTHX_ const char* name );
GV* (*  Perl_gv_fetchmeth )( pTHX_ HV* stash, const char* name, STRLEN len , I32 level );
GV* (*  Perl_gv_fetchmeth_autoload )( pTHX_ HV* stash, const char* name, STRLEN len , I32 level );
GV* (*  Perl_gv_fetchmethod )( pTHX_ HV* stash, const char* name );
GV* (*  Perl_gv_fetchmethod_autoload)( pTHX_ HV* stash, const char* name , I32 autoload );
GV* (*  Perl_gv_fetchpv )( pTHX_ const char* name, I32 add, I32 sv_type );
void (*  Perl_gv_fullname )( pTHX_ SV* sv, GV* gv );
void (*  Perl_gv_fullname3 )( pTHX_ SV* sv, GV* gv, const char* prefix );
void (*  Perl_gv_fullname4 )( pTHX_ SV* sv, GV* gv, const char* prefix, bool keepmain );
void (*  Perl_gv_init )( pTHX_ GV* gv, HV* stash, const char* name , STRLEN len, int multi );
HV* (*  Perl_gv_stashpv )( pTHX_ const char* name, I32 create );
HV* (*  Perl_gv_stashpvn )( pTHX_ const char* name, U32 namelen, I32 create );
HV* (*  Perl_gv_stashsv )( pTHX_ SV* sv, I32 create );
void (*  Perl_hv_clear )( pTHX_ HV* tb );
void (*  Perl_hv_delayfree_ent)( pTHX_ HV* hv, HE* entry );
SV* (*  Perl_hv_delete )( pTHX_ HV* tb, const char* key, I32 klen, I32 flags );
SV* (*  Perl_hv_delete_ent )( pTHX_ HV* tb, SV* key, I32 flags, U32 hash );
bool (*  Perl_hv_exists )( pTHX_ HV* tb, const char* key, I32 klen );
bool (*  Perl_hv_exists_ent )( pTHX_ HV* tb, SV* key, U32 hash );
SV** (*  Perl_hv_fetch )( pTHX_ HV* tb, const char* key, I32 klen, I32 lval );
HE* (*  Perl_hv_fetch_ent )( pTHX_ HV* tb, SV* key, I32 lval, U32 hash );
void (*  Perl_hv_free_ent )( pTHX_ HV* hv, HE* entry );
I32 (*  Perl_hv_iterinit )( pTHX_ HV* tb );
char* (*  Perl_hv_iterkey )( pTHX_ HE* entry, I32* retlen );
SV* (*  Perl_hv_iterkeysv )( pTHX_ HE* entry );
HE* (*  Perl_hv_iternext )( pTHX_ HV* tb );
SV* (*  Perl_hv_iternextsv )( pTHX_ HV* hv, char** key, I32* retlen );
HE* (*  Perl_hv_iternext_flags)( pTHX_ HV* tb, I32 flags );
SV* (*  Perl_hv_iterval )( pTHX_ HV* tb, HE* entry );
void (*  Perl_hv_ksplit )( pTHX_ HV* hv, IV newmax );
void (*  Perl_hv_magic )( pTHX_ HV* hv, GV* gv, int how );
SV** (*  Perl_hv_store )( pTHX_ HV* tb, const char* key, I32 klen, SV* val , U32 hash );
HE* (*  Perl_hv_store_ent )( pTHX_ HV* tb, SV* key, SV* val, U32 hash );
SV** (*  Perl_hv_store_flags )( pTHX_ HV* tb, const char* key, I32 klen, SV* val , U32 hash, int flags );
void (*  Perl_hv_undef )( pTHX_ HV* tb );
I32 (*  Perl_ibcmp )( pTHX_ const char* a, const char* b, I32 len );
I32 (*  Perl_ibcmp_locale )( pTHX_ const char* a, const char* b, I32 len );
I32 (*  Perl_ibcmp_utf8 )( pTHX_ const char* a, char **pe1, UV l1, bool u1, const char* b, char **pe2, UV l2, bool u2 );
void (*  Perl_init_stacks)( pTHX);
void (*  Perl_init_tm )( pTHX_ struct tm *ptm );
char* (*  Perl_instr )( pTHX_ const char* big, const char* little );
I32 (*  Perl_is_lvalue_sub)( pTHX);
U32 (*  Perl_to_uni_upper_lc)( pTHX_ U32 c );
U32 (*  Perl_to_uni_title_lc)( pTHX_ U32 c );
U32 (*  Perl_to_uni_lower_lc)( pTHX_ U32 c );
bool (*  Perl_is_uni_alnum )( pTHX_ UV c );
bool (*  Perl_is_uni_alnumc )( pTHX_ UV c );
bool (*  Perl_is_uni_idfirst )( pTHX_ UV c );
bool (*  Perl_is_uni_alpha )( pTHX_ UV c );
bool (*  Perl_is_uni_ascii )( pTHX_ UV c );
bool (*  Perl_is_uni_space )( pTHX_ UV c );
bool (*  Perl_is_uni_cntrl )( pTHX_ UV c );
bool (*  Perl_is_uni_graph )( pTHX_ UV c );
bool (*  Perl_is_uni_digit )( pTHX_ UV c );
bool (*  Perl_is_uni_upper )( pTHX_ UV c );
bool (*  Perl_is_uni_lower )( pTHX_ UV c );
bool (*  Perl_is_uni_print )( pTHX_ UV c );
bool (*  Perl_is_uni_punct )( pTHX_ UV c );
bool (*  Perl_is_uni_xdigit )( pTHX_ UV c );
UV (*  Perl_to_uni_upper )( pTHX_ UV c, U8 *p, STRLEN *lenp );
UV (*  Perl_to_uni_title )( pTHX_ UV c, U8 *p, STRLEN *lenp );
UV (*  Perl_to_uni_lower )( pTHX_ UV c, U8 *p, STRLEN *lenp );
UV (*  Perl_to_uni_fold )( pTHX_ UV c, U8 *p, STRLEN *lenp );
bool (*  Perl_is_uni_alnum_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_alnumc_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_idfirst_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_alpha_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_ascii_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_space_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_cntrl_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_graph_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_digit_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_upper_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_lower_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_print_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_punct_lc)( pTHX_ UV c );
bool (*  Perl_is_uni_xdigit_lc)( pTHX_ UV c );
STRLEN (*  Perl_is_utf8_char )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_string )( pTHX_ U8 *s, STRLEN len );
bool (*  Perl_is_utf8_string_loc)( pTHX_ U8 *s, STRLEN len, U8 **p );
bool (*  Perl_is_utf8_alnum )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_alnumc )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_idfirst)( pTHX_ U8 *p );
bool (*  Perl_is_utf8_idcont )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_alpha )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_ascii )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_space )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_cntrl )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_digit )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_graph )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_upper )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_lower )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_print )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_punct )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_xdigit )( pTHX_ U8 *p );
bool (*  Perl_is_utf8_mark )( pTHX_ U8 *p );
void (*  Perl_leave_scope )( pTHX_ I32 base );
void (*  Perl_op_null )( pTHX_ OP* o );
void (*  Perl_load_module)( pTHX_ U32 flags, SV* name, SV* ver, ... );
void (*  Perl_vload_module)( pTHX_ U32 flags, SV* name, SV* ver, va_list* args );
I32 (*  Perl_looks_like_number)( pTHX_ SV* sv );
UV (*  Perl_grok_bin )( pTHX_ char* start, STRLEN* len, I32* flags, NV *result );
UV (*  Perl_grok_hex )( pTHX_ char* start, STRLEN* len, I32* flags, NV *result );
int (*  Perl_grok_number )( pTHX_ const char *pv, STRLEN len, UV *valuep );
bool (*  Perl_grok_numeric_radix)( pTHX_ const char **sp, const char *send );
UV (*  Perl_grok_oct )( pTHX_ char* start, STRLEN* len, I32* flags, NV *result );
void (*  Perl_markstack_grow)( pTHX);
SV* (*  Perl_mess )( pTHX_ const char* pat, ... );
SV* (*  Perl_vmess )( pTHX_ const char* pat, va_list* args );
void (*  Perl_sortsv )( pTHX_ SV ** array, size_t num_elts, SVCOMPARE_t cmp );
int (*  Perl_mg_clear )( pTHX_ SV* sv );
int (*  Perl_mg_copy )( pTHX_ SV* sv, SV* nsv, const char* key, I32 klen );
MAGIC* (*  Perl_mg_find )( pTHX_ SV* sv, int type );
int (*  Perl_mg_free )( pTHX_ SV* sv );
int (*  Perl_mg_get )( pTHX_ SV* sv );
U32 (*  Perl_mg_length )( pTHX_ SV* sv );
void (*  Perl_mg_magical )( pTHX_ SV* sv );
int (*  Perl_mg_set )( pTHX_ SV* sv );
I32 (*  Perl_mg_size )( pTHX_ SV* sv );
void (*  Perl_mini_mktime )( pTHX_ struct tm *pm );
char* (*  Perl_moreswitches )( pTHX_ char* s );
NV (*  Perl_my_atof )( pTHX_ const char *s );
//char* (*  Perl_my_bcopy )(const char* from, char* to, I32 len );
//char* (*  Perl_my_bzero )(char* loc, I32 len );
void (*  Perl_my_exit )( pTHX_ U32 status );
void (*  Perl_my_failure_exit)( pTHX);
I32 (*  Perl_my_fflush_all)( pTHX);
Pid_t (*  Perl_my_fork)( );
void (*  Perl_atfork_lock)( );
void (*  Perl_atfork_unlock)( );
I32 (*  Perl_my_lstat)( pTHX);
//I32 (*  Perl_my_memcmp )(const char* s1, const char* s2, I32 len );
//void* (*  Perl_my_memset )(char* loc, I32 ch, I32 len );
I32 (*  Perl_my_pclose )( pTHX_ PerlIO* ptr );
PerlIO* (* Perl_my_popen )( pTHX_ char* cmd, char* mode );
PerlIO* (* Perl_my_popen_list )( pTHX_ char* mode, int n, SV ** args );
void (*  Perl_my_setenv )( pTHX_ char* nam, char* val );
I32 (*  Perl_my_stat)( pTHX);
char* (*  Perl_my_strftime )( pTHX_ char *fmt, int sec, int min, int hour, int mday, int mon, int year, int wday, int yday, int isdst );
OP* (*  Perl_newANONLIST )( pTHX_ OP* o );
OP* (*  Perl_newANONHASH )( pTHX_ OP* o );
OP* (*  Perl_newANONSUB )( pTHX_ I32 floor, OP* proto, OP* block );
OP* (*  Perl_newASSIGNOP )( pTHX_ I32 flags, OP* left, I32 optype, OP* right );
OP* (*  Perl_newCONDOP )( pTHX_ I32 flags, OP* expr, OP* trueop, OP* falseop );
CV* (*  Perl_newCONSTSUB )( pTHX_ HV* stash, char* name, SV* sv );
void (*  Perl_newFORM )( pTHX_ I32 floor, OP* o, OP* block );
OP* (*  Perl_newFOROP )( pTHX_ I32 flags, char* label, line_t forline , OP* sclr, OP* expr, OP*block, OP*cont );
OP* (*  Perl_newLOGOP )( pTHX_ I32 optype, I32 flags, OP* left, OP* right );
OP* (*  Perl_newLOOPEX )( pTHX_ I32 type, OP* label );
OP* (*  Perl_newLOOPOP )( pTHX_ I32 flags, I32 debuggable, OP* expr, OP* block );
OP* (*  Perl_newNULLLIST)( pTHX);
OP* (*  Perl_newOP )( pTHX_ I32 optype, I32 flags );
void (*  Perl_newPROG )( pTHX_ OP* o );
OP* (*  Perl_newRANGE )( pTHX_ I32 flags, OP* left, OP* right );
OP* (*  Perl_newSLICEOP )( pTHX_ I32 flags, OP* subscript, OP* listop );
OP* (*  Perl_newSTATEOP )( pTHX_ I32 flags, char* label, OP* o );
CV* (*  Perl_newSUB )( pTHX_ I32 floor, OP* o, OP* proto, OP* block );
CV* (*  Perl_newXS )( pTHX_ char* name, XSUBADDR_t f, char* filename );
AV* (*  Perl_newAV)( pTHX);
OP* (*  Perl_newAVREF )( pTHX_ OP* o );
OP* (*  Perl_newBINOP )( pTHX_ I32 type, I32 flags, OP* first, OP* last );
OP* (*  Perl_newCVREF )( pTHX_ I32 flags, OP* o );
OP* (*  Perl_newGVOP )( pTHX_ I32 type, I32 flags, GV* gv );
GV* (*  Perl_newGVgen )( pTHX_ char* pack );
OP* (*  Perl_newGVREF )( pTHX_ I32 type, OP* o );
OP* (*  Perl_newHVREF )( pTHX_ OP* o );
HV* (*  Perl_newHV)( pTHX);
HV* (*  Perl_newHVhv )( pTHX_ HV* hv );
IO* (*  Perl_newIO)( pTHX);
OP* (*  Perl_newLISTOP )( pTHX_ I32 type, I32 flags, OP* first, OP* last );
OP* (*  Perl_newPADOP )( pTHX_ I32 type, I32 flags, SV* sv );
OP* (*  Perl_newPMOP )( pTHX_ I32 type, I32 flags );
OP* (*  Perl_newPVOP )( pTHX_ I32 type, I32 flags, char* pv );
SV* (*  Perl_newRV )( pTHX_ SV* pref );
SV* (*  Perl_newRV_noinc )( pTHX_ SV *sv );
SV* (*  Perl_newSV )( pTHX_ STRLEN len );
OP* (*  Perl_newSVREF )( pTHX_ OP* o );
OP* (*  Perl_newSVOP )( pTHX_ I32 type, I32 flags, SV* sv );
SV* (*  Perl_newSViv )( pTHX_ IV i );
SV* (*  Perl_newSVuv )( pTHX_ UV u );
SV* (*  Perl_newSVnv )( pTHX_ NV n );
SV* (*  Perl_newSVpv )( pTHX_ const char* s, STRLEN len );
SV* (*  Perl_newSVpvn )( pTHX_ const char* s, STRLEN len );
SV* (*  Perl_newSVpvn_share )( pTHX_ const char* s, I32 len, U32 hash );
SV* (*  Perl_newSVpvf )( pTHX_ const char* pat, ... );
SV* (*  Perl_vnewSVpvf )( pTHX_ const char* pat, va_list* args );
SV* (*  Perl_newSVrv )( pTHX_ SV* rv, const char* classname );
SV* (*  Perl_newSVsv )( pTHX_ SV* old );
OP* (*  Perl_newUNOP )( pTHX_ I32 type, I32 flags, OP* first );
OP* (*  Perl_newWHILEOP )( pTHX_ I32 flags, I32 debuggable, LOOP* loop , I32 whileline, OP* expr, OP* block, OP* cont );
PERL_SI* (* Perl_new_stackinfo)( pTHX_ I32 stitems, I32 cxitems );
char* (*  Perl_scan_vstring )( pTHX_ char *vstr, SV *sv );
char* (*  Perl_ninstr )( pTHX_ const char* big, const char* bigend , const char* little, const char* lend );
void (*  Perl_op_free )( pTHX_ OP* arg );
SV* (*  Perl_pad_sv )( pTHX_ PADOFFSET po );
void (*  Perl_call_atexit )( pTHX_ ATEXIT_t fn, void *ptr );
I32 (*  Perl_call_argv )( pTHX_ const char* sub_name, I32 flags, char** argv );
I32 (*  Perl_call_method )( pTHX_ const char* methname, I32 flags );
I32 (*  Perl_call_pv )( pTHX_ const char* sub_name, I32 flags );
I32 (*  Perl_call_sv )( pTHX_ SV* sv, I32 flags );
void (*  Perl_despatch_signals)( pTHX);
SV* (*  Perl_eval_pv )( pTHX_ const char* p, I32 croak_on_error );
I32 (*  Perl_eval_sv )( pTHX_ SV* sv, I32 flags );
SV* (*  Perl_get_sv )( pTHX_ const char* name, I32 create );
AV* (*  Perl_get_av )( pTHX_ const char* name, I32 create );
HV* (*  Perl_get_hv )( pTHX_ const char* name, I32 create );
CV* (*  Perl_get_cv )( pTHX_ const char* name, I32 create );
int (*  Perl_init_i18nl10n )( pTHX_ int printwarn );
int (*  Perl_init_i18nl14n )( pTHX_ int printwarn );
void (*  Perl_new_collate )( pTHX_ char* newcoll );
void (*  Perl_new_ctype )( pTHX_ char* newctype );
void (*  Perl_new_numeric )( pTHX_ char* newcoll );
void (*  Perl_set_numeric_local)( pTHX);
void (*  Perl_set_numeric_radix)( pTHX);
void (*  Perl_set_numeric_standard)( pTHX);
void (*  Perl_require_pv )( pTHX_ const char* pv );
void (*  Perl_pack_cat )( pTHX_ SV *cat, char *pat, char *patend, SV **beglist, SV **endlist, SV ***next_in_list, U32 flags );
void (*  Perl_packlist )( pTHX_ SV *cat, char *pat, char *patend, SV **beglist, SV **endlist );
void (*  Perl_pmflag )( pTHX_ U32* pmfl, int ch );
void (*  Perl_pop_scope)( pTHX);
void (*  Perl_push_scope)( pTHX);
void (*  Perl_regdump )( pTHX_ regexp* r );
SV* (*  Perl_regclass_swash )( pTHX_ struct regnode *n, bool doinit, SV **listsvp, SV **altsvp );
I32 (*  Perl_pregexec )( pTHX_ regexp* prog, char* stringarg , char* strend, char* strbeg, I32 minend , SV* screamer, U32 nosave );
void (*  Perl_pregfree )( pTHX_ struct regexp* r );
regexp* (* Perl_pregcomp )( pTHX_ char* exp, char* xend, PMOP* pm );
char* (*  Perl_re_intuit_start)( pTHX_ regexp* prog, SV* sv, char* strpos , char* strend, U32 flags , struct re_scream_pos_data_s *data );
SV* (*  Perl_re_intuit_string)( pTHX_ regexp* prog );
I32 (*  Perl_regexec_flags )( pTHX_ regexp* prog, char* stringarg , char* strend, char* strbeg, I32 minend , SV* screamer, void* data, U32 flags );
regnode* (* Perl_regnext )( pTHX_ regnode* p );
void (*  Perl_repeatcpy )( pTHX_ char* to, const char* from, I32 len, I32 count );
char* (*  Perl_rninstr )( pTHX_ const char* big, const char* bigend , const char* little, const char* lend );
Sighandler_t (* Perl_rsignal )( pTHX_ int i, Sighandler_t t );
Sighandler_t (* Perl_rsignal_state)( pTHX_ int i );
char* (*  Perl_savepv )( pTHX_ const char* pv );
char* (*  Perl_savesharedpv )( pTHX_ const char* pv );
char* (*  Perl_savepvn )( pTHX_ const char* pv, I32 len );
void (*  Perl_savestack_grow)( pTHX);
void (*  Perl_savestack_grow_cnt )( pTHX_ I32 need );
void (*  Perl_save_aelem )( pTHX_ AV* av, I32 idx, SV **sptr );
I32 (*  Perl_save_alloc )( pTHX_ I32 size, I32 pad );
void (*  Perl_save_aptr )( pTHX_ AV** aptr );
AV* (*  Perl_save_ary )( pTHX_ GV* gv );
void (*  Perl_save_bool )( pTHX_ bool* boolp );
void (*  Perl_save_clearsv )( pTHX_ SV** svp );
void (*  Perl_save_delete )( pTHX_ HV* hv, char* key, I32 klen );
void (*  Perl_save_destructor)( pTHX_ DESTRUCTORFUNC_NOCONTEXT_t f, void* p );
void (*  Perl_save_destructor_x)( pTHX_ DESTRUCTORFUNC_t f, void* p );
void (*  Perl_save_freesv )( pTHX_ SV* sv );
void (*  Perl_save_freepv )( pTHX_ char* pv );
void (*  Perl_save_generic_svref)( pTHX_ SV** sptr );
void (*  Perl_save_generic_pvref)( pTHX_ char** str );
void (*  Perl_save_shared_pvref)( pTHX_ char** str );
void (*  Perl_save_gp )( pTHX_ GV* gv, I32 empty );
HV* (*  Perl_save_hash )( pTHX_ GV* gv );
void (*  Perl_save_helem )( pTHX_ HV* hv, SV *key, SV **sptr );
void (*  Perl_save_hints)( pTHX);
void (*  Perl_save_hptr )( pTHX_ HV** hptr );
void (*  Perl_save_I16 )( pTHX_ I16* intp );
void (*  Perl_save_I32 )( pTHX_ I32* intp );
void (*  Perl_save_I8 )( pTHX_ I8* bytep );
void (*  Perl_save_int )( pTHX_ int* intp );
void (*  Perl_save_item )( pTHX_ SV* item );
void (*  Perl_save_iv )( pTHX_ IV* iv );
void (*  Perl_save_list )( pTHX_ SV** sarg, I32 maxsarg );
void (*  Perl_save_long )( pTHX_ long* longp );
void (*  Perl_save_mortalizesv)( pTHX_ SV* sv );
void (*  Perl_save_nogv )( pTHX_ GV* gv );
SV* (*  Perl_save_scalar )( pTHX_ GV* gv );
void (*  Perl_save_pptr )( pTHX_ char** pptr );
void (*  Perl_save_vptr )( pTHX_ void* pptr );
void (*  Perl_save_re_context)( pTHX);
void (*  Perl_save_padsv )( pTHX_ PADOFFSET off );
void (*  Perl_save_sptr )( pTHX_ SV** sptr );
SV* (*  Perl_save_svref )( pTHX_ SV** sptr );
SV** (*  Perl_save_threadsv )( pTHX_ PADOFFSET i );
NV (*  Perl_scan_bin )( pTHX_ char* start, STRLEN len, STRLEN* retlen );
NV (*  Perl_scan_hex )( pTHX_ char* start, STRLEN len, STRLEN* retlen );
char* (*  Perl_scan_num )( pTHX_ char* s, YYSTYPE *lvalp );
NV (*  Perl_scan_oct )( pTHX_ char* start, STRLEN len, STRLEN* retlen );
char* (*  Perl_screaminstr )( pTHX_ SV* bigsv, SV* littlesv, I32 start_shift , I32 end_shift, I32 *state, I32 last );
Signal_t (*  Perl_csighandler )(int sig );
SV** (*  Perl_stack_grow )( pTHX_ SV** sp, SV**p, int n );
I32 (*  Perl_start_subparse )( pTHX_ I32 is_format, U32 flags );
bool (*  Perl_sv_2bool )( pTHX_ SV* sv );
CV* (*  Perl_sv_2cv )( pTHX_ SV* sv, HV** st, GV** gvp, I32 lref );
IO* (*  Perl_sv_2io )( pTHX_ SV* sv );
IV (*  Perl_sv_2iv )( pTHX_ SV* sv );
SV* (*  Perl_sv_2mortal )( pTHX_ SV* sv );
NV (*  Perl_sv_2nv )( pTHX_ SV* sv );
char* (*  Perl_sv_2pvutf8 )( pTHX_ SV* sv, STRLEN* lp );
char* (*  Perl_sv_2pvbyte )( pTHX_ SV* sv, STRLEN* lp );
char* (*  Perl_sv_pvn_nomg )( pTHX_ SV* sv, STRLEN* lp );
UV (*  Perl_sv_2uv )( pTHX_ SV* sv );
IV (*  Perl_sv_iv )( pTHX_ SV* sv );
UV (*  Perl_sv_uv )( pTHX_ SV* sv );
NV (*  Perl_sv_nv )( pTHX_ SV* sv );
char* (*  Perl_sv_pvn )( pTHX_ SV *sv, STRLEN *len );
char* (*  Perl_sv_pvutf8n )( pTHX_ SV *sv, STRLEN *len );
char* (*  Perl_sv_pvbyten )( pTHX_ SV *sv, STRLEN *len );
I32 (*  Perl_sv_true )( pTHX_ SV *sv );
int (*  Perl_sv_backoff )( pTHX_ SV* sv );
SV* (*  Perl_sv_bless )( pTHX_ SV* sv, HV* stash );
void (*  Perl_sv_catpvf )( pTHX_ SV* sv, const char* pat, ... );
void (*  Perl_sv_vcatpvf )( pTHX_ SV* sv, const char* pat, va_list* args );
void (*  Perl_sv_catpv )( pTHX_ SV* sv, const char* ptr );
void (*  Perl_sv_chop )( pTHX_ SV* sv, char* ptr );
void (*  Perl_sv_clear )( pTHX_ SV* sv );
I32 (*  Perl_sv_cmp )( pTHX_ SV* sv1, SV* sv2 );
I32 (*  Perl_sv_cmp_locale )( pTHX_ SV* sv1, SV* sv2 );
OP* (*  Perl_sv_compile_2op )( pTHX_ SV* sv, OP** startp, char* code, PAD** padp );
int (*  Perl_getcwd_sv )( pTHX_ SV* sv );
void (*  Perl_sv_dec )( pTHX_ SV* sv );
void (*  Perl_sv_dump )( pTHX_ SV* sv );
bool (*  Perl_sv_derived_from)( pTHX_ SV* sv, const char* name );
I32 (*  Perl_sv_eq )( pTHX_ SV* sv1, SV* sv2 );
void (*  Perl_sv_free )( pTHX_ SV* sv );
char* (*  Perl_sv_gets )( pTHX_ SV* sv, PerlIO* fp, I32 append );
char* (*  Perl_sv_grow )( pTHX_ SV* sv, STRLEN newlen );
void (*  Perl_sv_inc )( pTHX_ SV* sv );
void (*  Perl_sv_insert )( pTHX_ SV* bigsv, STRLEN offset, STRLEN len , char* little, STRLEN littlelen );
int (*  Perl_sv_isa )( pTHX_ SV* sv, const char* name );
int (*  Perl_sv_isobject )( pTHX_ SV* sv );
STRLEN (*  Perl_sv_len )( pTHX_ SV* sv );
STRLEN (*  Perl_sv_len_utf8 )( pTHX_ SV* sv );
void (*  Perl_sv_magic )( pTHX_ SV* sv, SV* obj, int how, const char* name , I32 namlen );
MAGIC* (* Perl_sv_magicext )( pTHX_ SV* sv, SV* obj, int how, MGVTBL *vtbl ,  const char* name, I32 namlen );
SV* (*  Perl_sv_mortalcopy )( pTHX_ SV* oldsv );
SV* (*  Perl_sv_newmortal)( pTHX);
SV* (*  Perl_sv_newref )( pTHX_ SV* sv );
char* (*  Perl_sv_peek )( pTHX_ SV* sv );
void (*  Perl_sv_pos_u2b )( pTHX_ SV* sv, I32* offsetp, I32* lenp );
void (*  Perl_sv_pos_b2u )( pTHX_ SV* sv, I32* offsetp );
char* (*  Perl_sv_pvutf8n_force)( pTHX_ SV* sv, STRLEN* lp );
char* (*  Perl_sv_pvbyten_force)( pTHX_ SV* sv, STRLEN* lp );
char* (*  Perl_sv_recode_to_utf8 )( pTHX_ SV* sv, SV *encoding );
bool (*  Perl_sv_cat_decode )( pTHX_ SV* dsv, SV *encoding, SV *ssv, int *offset , char* tstr, int tlen );
char* (*  Perl_sv_reftype )( pTHX_ SV* sv, int ob );
void (*  Perl_sv_replace )( pTHX_ SV* sv, SV* nsv );
void (*  Perl_sv_report_used)( pTHX);
void (*  Perl_sv_reset )( pTHX_ char* s, HV* stash );
void (*  Perl_sv_setpvf )( pTHX_ SV* sv, const char* pat, ... );
void (*  Perl_sv_vsetpvf )( pTHX_ SV* sv, const char* pat, va_list* args );
void (*  Perl_sv_setiv )( pTHX_ SV* sv, IV num );
void (*  Perl_sv_setpviv )( pTHX_ SV* sv, IV num );
void (*  Perl_sv_setuv )( pTHX_ SV* sv, UV num );
void (*  Perl_sv_setnv )( pTHX_ SV* sv, NV num );
SV* (*  Perl_sv_setref_iv )( pTHX_ SV* rv, const char* classname, IV iv );
SV* (*  Perl_sv_setref_uv )( pTHX_ SV* rv, const char* classname, UV uv );
SV* (*  Perl_sv_setref_nv )( pTHX_ SV* rv, const char* classname, NV nv );
SV* (*  Perl_sv_setref_pv )( pTHX_ SV* rv, const char* classname, void* pv );
SV* (*  Perl_sv_setref_pvn )( pTHX_ SV* rv, const char* classname, char* pv , STRLEN n );
void (*  Perl_sv_setpv )( pTHX_ SV* sv, const char* ptr );
void (*  Perl_sv_setpvn )( pTHX_ SV* sv, const char* ptr, STRLEN len );
void (*  Perl_sv_taint )( pTHX_ SV* sv );
bool (*  Perl_sv_tainted )( pTHX_ SV* sv );
int (*  Perl_sv_unmagic )( pTHX_ SV* sv, int type );
void (*  Perl_sv_unref )( pTHX_ SV* sv );
void (*  Perl_sv_unref_flags )( pTHX_ SV* sv, U32 flags );
void (*  Perl_sv_untaint )( pTHX_ SV* sv );
bool (*  Perl_sv_upgrade )( pTHX_ SV* sv, U32 mt );
void (*  Perl_sv_usepvn )( pTHX_ SV* sv, char* ptr, STRLEN len );
void (*  Perl_sv_vcatpvfn )( pTHX_ SV* sv, const char* pat, STRLEN patlen , va_list* args, SV** svargs, I32 svmax , bool *maybe_tainted );
void (*  Perl_sv_vsetpvfn )( pTHX_ SV* sv, const char* pat, STRLEN patlen , va_list* args, SV** svargs, I32 svmax , bool *maybe_tainted );
NV (*  Perl_str_to_version )( pTHX_ SV *sv );
SV* (*  Perl_swash_init )( pTHX_ char* pkg, char* name, SV* listsv , I32 minbits, I32 none );
UV (*  Perl_swash_fetch )( pTHX_ SV *sv, U8 *ptr, bool do_utf8 );
void (*  Perl_taint_env)( pTHX);
void (*  Perl_taint_proper )( pTHX_ const char* f, const char* s );
UV (*  Perl_to_utf8_case )( pTHX_ U8 *p, U8* ustrp, STRLEN *lenp , SV **swash, char *normal, char *special );
UV (*  Perl_to_utf8_lower )( pTHX_ U8 *p, U8* ustrp, STRLEN *lenp );
UV (*  Perl_to_utf8_upper )( pTHX_ U8 *p, U8* ustrp, STRLEN *lenp );
UV (*  Perl_to_utf8_title )( pTHX_ U8 *p, U8* ustrp, STRLEN *lenp );
UV (*  Perl_to_utf8_fold )( pTHX_ U8 *p, U8* ustrp, STRLEN *lenp );
I32 (*  Perl_unpack_str )( pTHX_ char *pat, char *patend, char *s, char *strbeg, char *strend, char **new_s, I32 ocnt, U32 flags );
I32 (*  Perl_unpackstring )( pTHX_ char *pat, char *patend, char *s, char *strend, U32 flags );
void (*  Perl_unsharepvn )( pTHX_ const char* sv, I32 len, U32 hash );
U8* (*  Perl_utf16_to_utf8 )( pTHX_ U8* p, U8 *d, I32 bytelen, I32 *newlen );
U8* (*  Perl_utf16_to_utf8_reversed)( pTHX_ U8* p, U8 *d, I32 bytelen, I32 *newlen );
STRLEN (*  Perl_utf8_length )( pTHX_ U8* s, U8 *e );
IV (*  Perl_utf8_distance )( pTHX_ U8 *a, U8 *b );
U8* (*  Perl_utf8_hop )( pTHX_ U8 *s, I32 off );
U8* (*  Perl_utf8_to_bytes )( pTHX_ U8 *s, STRLEN *len );
U8* (*  Perl_bytes_from_utf8)( pTHX_ U8 *s, STRLEN *len, bool *is_utf8 );
U8* (*  Perl_bytes_to_utf8 )( pTHX_ U8 *s, STRLEN *len );
UV (*  Perl_utf8_to_uvchr )( pTHX_ U8 *s, STRLEN* retlen );
UV (*  Perl_utf8_to_uvuni )( pTHX_ U8 *s, STRLEN* retlen );
//UV (*  Perl_utf8n_to_uvchr )( pTHX_ U8 *s, STRLEN curlen, STRLEN* retlen, U32 flags );
UV (*  Perl_utf8n_to_uvuni )( pTHX_ U8 *s, STRLEN curlen, STRLEN* retlen, U32 flags );
//U8* (*  Perl_uvchr_to_utf8 )( pTHX_ U8 *d, UV uv );
U8* (*  Perl_uvuni_to_utf8 )( pTHX_ U8 *d, UV uv );
U8* (*  Perl_uvchr_to_utf8_flags )( pTHX_ U8 *d, UV uv, UV flags );
U8* (*  Perl_uvuni_to_utf8_flags )( pTHX_ U8 *d, UV uv, UV flags );
char* (*  Perl_pv_uni_display )( pTHX_ SV *dsv, U8 *spv, STRLEN len , STRLEN pvlim, UV flags );
char* (*  Perl_sv_uni_display )( pTHX_ SV *dsv, SV *ssv, STRLEN pvlim, UV flags );
void (*  Perl_warn )( pTHX_ const char* pat, ... );
void (*  Perl_vwarn )( pTHX_ const char* pat, va_list* args );
void (*  Perl_warner )( pTHX_ U32 err, const char* pat, ... );
void (*  Perl_vwarner )( pTHX_ U32 err, const char* pat, va_list* args );
I32 (*  Perl_whichsig )( pTHX_ char* sig );
Malloc_t (* Perl_safesysmalloc )(MEM_SIZE nbytes );
Malloc_t (* Perl_safesyscalloc )(MEM_SIZE elements, MEM_SIZE size );
Malloc_t (* Perl_safesysrealloc)(Malloc_t where, MEM_SIZE nbytes );
Free_t (*  Perl_safesysfree )(Malloc_t where );
int (*  Perl_runops_standard)( pTHX);
int (*  Perl_runops_debug)( pTHX);
void (*  Perl_sv_catpvf_mg )( pTHX_ SV *sv, const char* pat, ... );
void (*  Perl_sv_vcatpvf_mg )( pTHX_ SV* sv, const char* pat, va_list* args );
void (*  Perl_sv_catpv_mg )( pTHX_ SV *sv, const char *ptr );
void (*  Perl_sv_catpvn_mg )( pTHX_ SV *sv, const char *ptr, STRLEN len );
void (*  Perl_sv_catsv_mg )( pTHX_ SV *dstr, SV *sstr );
void (*  Perl_sv_setpvf_mg )( pTHX_ SV *sv, const char* pat, ... );
void (*  Perl_sv_vsetpvf_mg )( pTHX_ SV* sv, const char* pat, va_list* args );
void (*  Perl_sv_setiv_mg )( pTHX_ SV *sv, IV i );
void (*  Perl_sv_setpviv_mg )( pTHX_ SV *sv, IV iv );
void (*  Perl_sv_setuv_mg )( pTHX_ SV *sv, UV u );
void (*  Perl_sv_setnv_mg )( pTHX_ SV *sv, NV num );
void (*  Perl_sv_setpv_mg )( pTHX_ SV *sv, const char *ptr );
void (*  Perl_sv_setpvn_mg )( pTHX_ SV *sv, const char *ptr, STRLEN len );
void (*  Perl_sv_setsv_mg )( pTHX_ SV *dstr, SV *sstr );
void (*  Perl_sv_usepvn_mg )( pTHX_ SV *sv, char *ptr, STRLEN len );
MGVTBL* (* Perl_get_vtbl )( pTHX_ int vtbl_id );
char* (*  Perl_pv_display )( pTHX_ SV *dsv, char *pv, STRLEN cur, STRLEN len , STRLEN pvlim );
void (*  Perl_dump_indent )( pTHX_ I32 level, PerlIO *file, const char* pat, ... );
void (*  Perl_dump_vindent )( pTHX_ I32 level, PerlIO *file, const char* pat , va_list *args );
void (*  Perl_do_gv_dump )( pTHX_ I32 level, PerlIO *file, char *name, GV *sv );
void (*  Perl_do_gvgv_dump )( pTHX_ I32 level, PerlIO *file, char *name, GV *sv );
void (*  Perl_do_hv_dump )( pTHX_ I32 level, PerlIO *file, char *name, HV *sv );
void (*  Perl_do_magic_dump )( pTHX_ I32 level, PerlIO *file, MAGIC *mg, I32 nest , I32 maxnest, bool dumpops, STRLEN pvlim );
void (*  Perl_do_op_dump )( pTHX_ I32 level, PerlIO *file, OP *o );
void (*  Perl_do_pmop_dump )( pTHX_ I32 level, PerlIO *file, PMOP *pm );
void (*  Perl_do_sv_dump )( pTHX_ I32 level, PerlIO *file, SV *sv, I32 nest , I32 maxnest, bool dumpops, STRLEN pvlim );
void (*  Perl_magic_dump )( pTHX_ MAGIC *mg );
void (*  Perl_reginitcolors)( pTHX);
char* (*  Perl_sv_2pv_nolen )( pTHX_ SV* sv );
char* (*  Perl_sv_2pvutf8_nolen)( pTHX_ SV* sv );
char* (*  Perl_sv_2pvbyte_nolen)( pTHX_ SV* sv );
bool (*  Perl_sv_utf8_downgrade)( pTHX_ SV *sv, bool fail_ok );
void (*  Perl_sv_utf8_encode )( pTHX_ SV *sv );
bool (*  Perl_sv_utf8_decode )( pTHX_ SV *sv );
void (*  Perl_sv_force_normal)( pTHX_ SV *sv );
void (*  Perl_sv_force_normal_flags)( pTHX_ SV *sv, U32 flags );
void (*  Perl_tmps_grow )( pTHX_ I32 n );
SV* (*  Perl_sv_rvweaken )( pTHX_ SV *sv );
OP* (*  Perl_newANONATTRSUB )( pTHX_ I32 floor, OP *proto, OP *attrs, OP *block );
CV* (*  Perl_newATTRSUB )( pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block );
void (*  Perl_newMYSUB )( pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block );
PERL_CONTEXT* (* Perl_cx_dup )( pTHX_ PERL_CONTEXT* cx, I32 ix, I32 max, CLONE_PARAMS* param );
PERL_SI* (* Perl_si_dup )( pTHX_ PERL_SI* si, CLONE_PARAMS* param );
ANY* (*  Perl_ss_dup )( pTHX_ PerlInterpreter* proto_perl, CLONE_PARAMS* param );
void* (*  Perl_any_dup )( pTHX_ void* v, PerlInterpreter* proto_perl );
HE* (*  Perl_he_dup )( pTHX_ HE* e, bool shared, CLONE_PARAMS* param );
REGEXP* (* Perl_re_dup )( pTHX_ REGEXP* r, CLONE_PARAMS* param );
PerlIO* (* Perl_fp_dup )( pTHX_ PerlIO* fp, char type, CLONE_PARAMS* param );
DIR* (*  Perl_dirp_dup )( pTHX_ DIR* dp );
GP* (*  Perl_gp_dup )( pTHX_ GP* gp, CLONE_PARAMS* param );
MAGIC* (*  Perl_mg_dup )( pTHX_ MAGIC* mg, CLONE_PARAMS* param );
SV* (*  Perl_sv_dup )( pTHX_ SV* sstr, CLONE_PARAMS* param );
PTR_TBL_t* (* Perl_ptr_table_new)( pTHX);
void* (*  Perl_ptr_table_fetch)( pTHX_ PTR_TBL_t *tbl, void *sv );
void (*  Perl_ptr_table_store)( pTHX_ PTR_TBL_t *tbl, void *oldsv, void *newsv );
void (*  Perl_ptr_table_split)( pTHX_ PTR_TBL_t *tbl );
void (*  Perl_ptr_table_clear)( pTHX_ PTR_TBL_t *tbl );
void (*  Perl_ptr_table_free)( pTHX_ PTR_TBL_t *tbl );
char* (*  Perl_custom_op_name )( pTHX_ OP* op );
char* (*  Perl_custom_op_desc )( pTHX_ OP* op );
void (*  Perl_sv_nosharing )( pTHX_ SV * );
void (*  Perl_sv_nolocking )( pTHX_ SV * );
void (*  Perl_sv_nounlocking )( pTHX_ SV * );
int (*  Perl_nothreadhook)( pTHX);
void (*  Perl_sv_setsv_flags )( pTHX_ SV* dsv, SV* ssv, I32 flags );
void (*  Perl_sv_catpvn_flags)( pTHX_ SV* sv, const char* ptr, STRLEN len, I32 flags );
void (*  Perl_sv_catsv_flags )( pTHX_ SV* dsv, SV* ssv, I32 flags );
STRLEN (*  Perl_sv_utf8_upgrade_flags)( pTHX_ SV *sv, I32 flags );
char* (*  Perl_sv_pvn_force_flags)( pTHX_ SV* sv, STRLEN* lp, I32 flags );
char* (*  Perl_sv_2pv_flags )( pTHX_ SV* sv, STRLEN* lp, I32 flags );
void (*  Perl_sv_copypv )( pTHX_ SV* dsv, SV* ssv );
char* (*  Perl_my_atof2 )( pTHX_ const char *s, NV* value );
int (*  Perl_my_socketpair )(int family, int type, int protocol, int fd[2] );
void (*  Perl_hv_clear_placeholders)( pTHX_ HV* hb );
SV* (*  Perl_hv_scalar )( pTHX_ HV* hv  );
int       (* Perl_PerlIO_close)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_fill)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_fileno)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_eof)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_error)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_flush)(pTHX_ PerlIO *);
void      (* Perl_PerlIO_clearerr)(pTHX_ PerlIO *);
void      (* Perl_PerlIO_set_cnt)(pTHX_ PerlIO *, int);
void      (* Perl_PerlIO_set_ptrcnt)(pTHX_ PerlIO *, STDCHAR *, int);
void      (* Perl_PerlIO_setlinebuf)(pTHX_ PerlIO *);
SSize_t   (* Perl_PerlIO_read)(pTHX_ PerlIO *, void *, Size_t);
SSize_t   (* Perl_PerlIO_write)(pTHX_ PerlIO *, const void *, Size_t);
SSize_t   (* Perl_PerlIO_unread)(pTHX_ PerlIO *, const void *, Size_t);
Off_t     (* Perl_PerlIO_tell)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_seek)(pTHX_ PerlIO *, Off_t, int);
STDCHAR * (* Perl_PerlIO_get_base)(pTHX_ PerlIO *);
STDCHAR * (* Perl_PerlIO_get_ptr)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_get_bufsiz)(pTHX_ PerlIO *);
int       (* Perl_PerlIO_get_cnt)(pTHX_ PerlIO *);
PerlIO *  (* Perl_PerlIO_stdin)(pTHX);
PerlIO *  (* Perl_PerlIO_stdout)(pTHX);
PerlIO *  (* Perl_PerlIO_stderr)(pTHX);
int       (* PerlIO_getpos)(PerlIO *, SV*);
int       (* PerlIO_setpos)(PerlIO *, SV*);
int       (* PerlIO_getc)(PerlIO *);
int       (* PerlIO_putc)(PerlIO *, int);
int       (* PerlIO_ungetc)(PerlIO *, int);
PerlIO *  (* PerlIO_tmpfile)(void);
PerlIO *  (* PerlIO_fdopen)(int fd, const char *mode);
PerlIO *  (* PerlIO_open)(const char *path, const char *mode);
PerlIO *  (* PerlIO_reopen)(const char *path, const char *mode, PerlIO *f);
void      (* PerlIO_puts)(PerlIO *f, const char *s);
void      (* PerlIO_rewind)(PerlIO *f);
int       (* PerlIO_vprintf)(PerlIO *f, const char *fmt, va_list ap);
int       (* PerlIO_printf)(PerlIO *f, const char *fmt, ...);
int       (* PerlIO_stdoutf)(const char *fmt,...);
/* global pointer fetch functions */  /*from perlvar.h */
PerlInterpreter **(*Perl_Gcurinterp_ptr)(pTHX);
perl_key * (*Perl_Gthr_key_ptr)(pTHX);
char ** (*Perl_GYes_ptr)(pTHX);
char ** (*Perl_GNo_ptr)(pTHX);
char ** (*Perl_Ghexdigit_ptr)(pTHX);
char ** (*Perl_Gpatleave_ptr)(pTHX);
bool  * (*Perl_Gdo_undump_ptr)(pTHX);
perl_mutex* (*Perl_Gop_mutex_ptr)(pTHX);
perl_mutex* (*Perl_Gdollarzero_mutex_ptr)(pTHX);
char ** (*Perl_Gsh_path_ptr)(pTHX);
Sighandler_t * (*Perl_Gsigfpe_saved_ptr)(pTHX);
SV * (*Perl_Gsv_placeholder_ptr)(pTHX);
Sighandler_t *(*Perl_Gcsighandlerp_ptr)(pTHX);
void * (*pthread_getspecific)(pthread_key_t);
int             (*pthread_create)(pthread_t*, const pthread_attr_t *, 
 void *(*)(void *), void *);
void            (*pthread_exit)(void *);
pthread_t       (*pthread_self)(void);
int             (*pthread_equal)(pthread_t, pthread_t);
int             (*pthread_join)(pthread_t, void **);
int                     (*pthread_detach)(pthread_t);
int                     (*pthread_attr_destroy)(pthread_attr_t *);
int                     (*pthread_attr_getdetachstate)(const pthread_attr_t *, int *);
int                     (*pthread_attr_getguardsize)(const pthread_attr_t *, size_t *);
int                     (*pthread_attr_getinheritsched)(const pthread_attr_t *, int *);
int                     (*pthread_attr_getschedparam)(const pthread_attr_t *, struct sched_param *);
int                     (*pthread_attr_getschedpolicy)(const pthread_attr_t *, int *);
int                     (*pthread_attr_getscope)(const pthread_attr_t *, int *);
int                     (*pthread_attr_getstackaddr)(const pthread_attr_t *, void **);
int                     (*pthread_attr_getstacksize)(const pthread_attr_t *, size_t *);
int                     (*pthread_attr_init)(pthread_attr_t *);
int                     (*pthread_attr_setdetachstate)(pthread_attr_t *, int);
int                     (*pthread_attr_setguardsize)(pthread_attr_t *, size_t);
int                     (*pthread_attr_setinheritsched)(pthread_attr_t *, int);
int                     (*pthread_attr_setschedparam)(pthread_attr_t *, const struct sched_param *);
int                     (*pthread_attr_setschedpolicy)(pthread_attr_t *, int);
int                     (*pthread_attr_setscope)(pthread_attr_t *, int);
int                     (*pthread_attr_setstackaddr)(pthread_attr_t *, void *);
int                     (*pthread_attr_setstacksize)(pthread_attr_t *, size_t);
int                     (*pthread_cancel)(pthread_t);
void            (*pthread_cleanup_push)(void(*)(void *), void *);
void            (*pthread_cleanup_pop)(int);
int                     (*pthread_setcancelstate)(int, int *);
int                     (*pthread_setcanceltype)(int, int *);
void            (*pthread_testcancel)(void);
int                     (*pthread_once)(pthread_once_t *, void (*)(void));
int                     (*pthread_setconcurrency)(int);
int                     (*pthread_setschedparam)(pthread_t, int , const struct sched_param *);
int                     (*pthread_getconcurrency)(void);
int                     (*pthread_getschedparam)(pthread_t, int *, struct sched_param *);
int                     (*pthread_key_create)(pthread_key_t *, void (*)(void *));
int                     (*pthread_key_delete)(pthread_key_t);
int                     (*pthread_setspecific)(pthread_key_t, const void *);
int                     (*pthread_mutex_destroy)(pthread_mutex_t *);
int                     (*pthread_mutex_getprioceiling)(const pthread_mutex_t *, int *);
int                     (*pthread_mutex_init)(pthread_mutex_t *, const pthread_mutexattr_t *);
int                     (*pthread_mutex_lock)(pthread_mutex_t *);
int                     (*pthread_mutex_setprioceiling)(pthread_mutex_t *, int, int *);
int                     (*pthread_mutex_trylock)(pthread_mutex_t *);
int                     (*pthread_mutex_unlock)(pthread_mutex_t *);
int                     (*pthread_mutexattr_destroy)(pthread_mutexattr_t *);
int                     (*pthread_mutexattr_getprioceiling)(const pthread_mutexattr_t *, int *);
int                     (*pthread_mutexattr_getprotocol)(const pthread_mutexattr_t *, int *);
int                     (*pthread_mutexattr_getpshared)(const pthread_mutexattr_t *, int *);
int                     (*pthread_mutexattr_gettype)(const pthread_mutexattr_t *, int *);
int                     (*pthread_mutexattr_init)(pthread_mutexattr_t *);
int                     (*pthread_mutexattr_setprioceiling)(pthread_mutexattr_t *, int);
int                     (*pthread_mutexattr_setprotocol)(pthread_mutexattr_t *, int);
int                     (*pthread_mutexattr_setpshared)(pthread_mutexattr_t *, int);
int                     (*pthread_mutexattr_settype)(pthread_mutexattr_t *, int);
int                     (*pthread_cond_broadcast)(pthread_cond_t *);
int                     (*pthread_cond_destroy)(pthread_cond_t *);
int                     (*pthread_cond_init)(pthread_cond_t *, const pthread_condattr_t *);
int                     (*pthread_cond_signal)(pthread_cond_t *);
int                     (*pthread_cond_timedwait)(pthread_cond_t *, pthread_mutex_t *, const struct timespec *);
int                     (*pthread_cond_wait)(pthread_cond_t *, pthread_mutex_t *);
int                     (*pthread_condattr_destroy)(pthread_condattr_t *);
int                     (*pthread_condattr_getpshared)(const pthread_condattr_t *, int *);
int                     (*pthread_condattr_init)(pthread_condattr_t *);
int                     (*pthread_condattr_setpshared)(pthread_condattr_t *, int);
};

#endif

