#if defined(__amigaos4__)
#undef __USE_INLINE__

#include <exec/semaphores.h>
#include <proto/exec.h>
#include <proto/dos.h>

#include <stdarg.h>

int VARARGS68K adebug(UBYTE *fmt, ...);

int VARARGS68K araddebug(UBYTE *fmt, ...);

static struct SignalSemaphore debugsema;
static BOOL debugsemainit = FALSE;

int adebug(UBYTE *fmt, ...)
{
    va_list ap;
    LONG *argv;
    LONG result;


    struct ExecIFace *myExec = (struct ExecIFace*)(*(struct ExecBase **)4)->MainInterface;

    struct DOSBase *myDOSBase = (struct DOSBase *)myExec->OpenLibrary("dos.library",0);
    struct DOSIFace *myIDOS = (struct DOSIFace *)myExec->GetInterface((struct Library *)myDOSBase,"main",1,0);

    if(!debugsemainit)
    {
        myExec->InitSemaphore(&debugsema);
        debugsemainit= TRUE;
    }
    myExec->ObtainSemaphore(&debugsema);

    if(myDOSBase && myIDOS)
    {


        BPTR debug = myIDOS->Open("ram:debug",MODE_OLDFILE);
    va_startlinear(ap,fmt);
    argv = (LONG *)va_getlinearva(ap,LONG *);

        if(debug)
        {
            myIDOS->Seek(debug,0,OFFSET_END);
            result = myIDOS->VFPrintf(debug,fmt,argv);
            myIDOS->Close(debug);
        }
        else
        {
        debug = myIDOS->Open("ram:debug",MODE_NEWFILE);
        if(debug)
        {
            myIDOS->Seek(debug,0,OFFSET_END);
            result = myIDOS->VFPrintf(debug,fmt,argv);
            myIDOS->Close(debug);
        }

        }

    va_end(argv);


    }
    myExec->ReleaseSemaphore(&debugsema);
    if(myIDOS)    myExec->DropInterface((struct Interface *)myIDOS);
    if(myDOSBase) myExec->CloseLibrary((struct Library *)myDOSBase);

}

#if defined(__amigaos4__)
#define RADDEBUG "sys:debug"
#else
#define RADDEBUG "rad:debug"
#endif

int araddebug(UBYTE *fmt, ...)
{
    va_list ap;
    LONG *argv;
    LONG result;


    struct ExecIFace *myExec = (struct ExecIFace*)(*(struct ExecBase **)4)->MainInterface;

    struct DOSBase *myDOSBase = (struct DOSBase *)myExec->OpenLibrary("dos.library",0);
    struct DOSIFace *myIDOS = (struct DOSIFace *)myExec->GetInterface((struct Library *)myDOSBase,"main",1,0);
    if(myDOSBase && myIDOS)
    {


        BPTR debug = myIDOS->Open(RADDEBUG,MODE_OLDFILE);
    va_startlinear(ap,fmt);
    argv = (LONG *)va_getlinearva(ap,LONG *);

        if(debug)
        {
            myIDOS->Seek(debug,0,OFFSET_END);
            result = myIDOS->VFPrintf(debug,fmt,argv);
            myIDOS->Close(debug);
        }
        else
        {
        debug = myIDOS->Open(RADDEBUG,MODE_NEWFILE);
        if(debug)
        {
            myIDOS->Seek(debug,0,OFFSET_END);
            result = myIDOS->VFPrintf(debug,fmt,argv);
            myIDOS->Close(debug);
        }

        }

    va_end(argv);


    }
    if(myIDOS)    myExec->DropInterface((struct Interface *)myIDOS);
    if(myDOSBase) myExec->CloseLibrary((struct Library *)myDOSBase);

}


#endif
