#include <string.h>

#include <sys/stat.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <fcntl.h>
#include <ctype.h>


#include <dos/dos.h>
#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/utility.h>

void ___makeenviron() __attribute__((constructor));
void ___freeenviron() __attribute__((destructor));


int VARARGS68K araddebug(UBYTE *fmt, ...);
int VARARGS68K adebug(UBYTE *fmt, ...);


#define __USE_RUNCOMMAND__

char **environ = NULL;

int execve(const char *path, char *const argv[], char *const envp[]);
void createvars(char **envp);

struct args
{
    BPTR seglist;
    int stack;
    char *command;
    int length;
    int result;
    char **envp;
};

int __myrc( char *arg)
{
    struct Task *thisTask = FindTask(0);
    struct args *myargs = (struct args*)thisTask->tc_UserData;
            if(myargs->envp)
                 createvars(myargs->envp);

    myargs->result = RunCommand(
             myargs->seglist,
             myargs->stack,
             myargs->command,
             myargs->length
    );
    return 0;
}

myruncommand(BPTR seglist,int stack, char *command, int length, char **envp)
{
    struct args myargs;
    struct Task *thisTask = FindTask(0);
    struct Process *proc;

    myargs.seglist = seglist;
    myargs.stack = stack;
    myargs.command = command;
    myargs.length = length;
    myargs.result = -1;
    myargs.envp = envp;

   if((  proc = CreateNewProcTags(
            NP_Entry,               __myrc,
            NP_Child,               TRUE,
            NP_Input,         Input(),
            NP_Output,        Output(),
            NP_Error,         ErrorOutput(),
            NP_CloseInput,          FALSE,
            NP_CloseOutput,         FALSE,
            NP_CloseError,    FALSE,
            NP_CopyVars, FALSE,

 //           NP_StackSize,           ((struct Process *)myargs.parent)->pr_StackSize,
            NP_Cli,                 TRUE,
            NP_UserData,            (int)&myargs,
            NP_NotifyOnDeathSigTask,   thisTask,
            TAG_DONE)))

    {
        Wait(SIGF_CHILD);
    }
    return myargs.result;
}

static char *
mystrdup(const char *s)
{
        char * result = NULL;
        size_t size;

        size = strlen(s)+1;

        if((result = AllocVec(size, MEMF_ANY)))
        {
            memmove(result,s,size);
        }
        return result;
}


static int pipenum = 0;

int pipe(int filedes[2])
{
        char pipe_name[1024];

#ifdef USE_TEMPFILES
        sprintf(pipe_name, "/T/%x.%08x", pipenum++,GetUniqueID());
#else
        sprintf(pipe_name, "/PIPE/%x%08x/4096/0", pipenum++,GetUniqueID());
#endif

/*      printf("pipe: %s \n", pipe_name);*/

        filedes[1] = open(pipe_name, O_WRONLY|O_CREAT);
        filedes[0] = open(pipe_name, O_RDONLY);
        if (filedes[0] == -1 || filedes[1] == -1)
        {
                if (filedes[0] != -1)
                    close(filedes[0]);
                if (filedes[1] != -1)
                    close(filedes[1]);
                return -1;
        }
/*      printf("filedes %d %d\n", filedes[0], filedes[1]);fflush(stdout);*/

        return 0;
}


int fork(void)
{
        fprintf(stderr,"Can not bloody fork\n");
        errno = ENOMEM;
        return -1;
}

int wait(int *status)
{
        fprintf(stderr,"No wait\n");
        errno = ECHILD;
        return -1;
}

char *convert_path_a2u(const char *filename)
{
    struct name_translation_info nti;

    if(!filename)
    {
        return 0;
    }

    __translate_amiga_to_unix_path_name(&filename,&nti);

    return mystrdup(filename);

}
char *convert_path_u2a(const char *filename)
{
        struct name_translation_info nti;

        if (!filename)
        {
            return 0;
        }

        if (strcmp(filename, "/dev/tty") == 0)
        {
            return  mystrdup( "CONSOLE:");;

        }




        __translate_unix_to_amiga_path_name(&filename,&nti);

        return mystrdup(filename);
}

static void createvars(char **envp)
{
    /* Set a local var to indicate to any subsequent sh that it is not */
    /* The top level shell and so should only inherit local amigaos vars */

    SetVar("ABCSH_IMPORT_LOCAL","TRUE",5,GVF_LOCAL_ONLY);

    while(*envp != NULL)
    {
        int len;
        char *var;
        char *val;


        if((len = strlen(*envp))){
            if((var = (char *)AllocVec(len+1,MEMF_ANY|MEMF_CLEAR)))
            {
                strcpy(var,*envp);

                val = strchr(var,'=');
                if(val)
                {
                    *val++='\0';
                    if (*val)
                    {
                        SetVar(var,val,strlen(val)+1,GVF_LOCAL_ONLY);
                    }
                }
                FreeVec(var);
            }
        }
        envp++;
    }
}

static BOOL contains_whitespace(char *string)
{

    if(string)
    {

    if(strchr(string,' ')) return TRUE;
    if(strchr(string,'\t')) return TRUE;
    if(strchr(string,'\n')) return TRUE;
    if(strchr(string,0xA0)) return TRUE;
    if(strchr(string,'"')) return TRUE;
    }
    return FALSE;
}

static int no_of_escapes(char *string)
{
    int cnt = 0;
    char *p;
    for(p=string;p<string + strlen(string);p++)
    {
        if(*p=='"') cnt++;
        if(*p=='*') cnt++;
        if(*p=='\n') cnt++;
        if(*p=='\t') cnt++;
    }
    return cnt;
}

struct command_data
{
    STRPTR args;
    BPTR seglist;
    struct Task *parent;
};

int execvp(const char *filename, char *argv[])
{
    /* if there's a slash or a colon consider filename a path and skip search */
        int res;

    if((strchr(filename,'/') == NULL) && (strchr(filename,':') == NULL))
    {
        char *path;
        char *name;
        char *pathpart;
        char *p;
        size_t len;
        struct stat st;

        if(!(path = getenv("PATH")))
        {
            path = ".:/bin:/usr/bin:/c";
        }

        len = strlen(filename) +1;
        name = alloca(strlen(path) + len);
        pathpart = alloca(strlen(path) + 1);
        p=path;
        do
        {
            path=p;

            if(!(p=strchr(path, ':')))
            {
                p=strchr(path,'\0');
            }

            memcpy(pathpart,path,p-path);
            pathpart[p-path] = '\0';
            if(!(strlen(pathpart) == 0))
            {
                sprintf(name,"%s/%s",pathpart,filename);
            }else
                sprintf(name,"%s",filename);

            if( (stat(name,&st) == 0) && (S_ISREG(st.st_mode)))
            {
                /* we stated it and it's a regular file */
                /* let's boogie! */
                filename = name;
                break;
            }


        }
        while (*p++ != '\0');
    }

    res = execve(filename, argv, environ);
    return res;
}

int execv(const char *path, char *argv[])
{
    return execve(path,argv,environ);
}

int execl(const char *path, ...)
{
    va_list va;
    char *argv[1024];   /* 1024 enough? let's hope so! */
    int i=0;

    va_start(va, path);
    i = 1;

    do
    {
        argv[i] = va_arg (va, char *);
    }
    while (argv[i++] != NULL);

    va_end(va);
    return execve(path,argv,environ);

}


int execve(const char *filename, char *const argv[], char *const envp[])
{
        FILE *fh;
        char buffer[1000];
        int size = 0;
        char **cur;
        char *interpreter = 0;
        char * interpreter_args = 0;
        char *full = 0;
        char *filename_conv = 0;
        char *interpreter_conv = 0;
        char *tmp = 0;
        char *fname;
        int tmpint;
        struct Task *thisTask = FindTask(0);
        int result = -1;

        /* Calculate the size of filename and all args, including spaces and quotes */
        size = 0;//strlen(filename) + 1;
        for (cur = (char **)argv+1; *cur; cur++)
        {
            size += strlen(*cur) + 1 + (contains_whitespace(*cur)?(2 + no_of_escapes(*cur)):0);
        }
        /* Check if it's a script file */

        fh = fopen(filename, "r");
        if (fh)
        {
                if (fgetc(fh) == '#' && fgetc(fh) == '!')
                {
                        char *p;
                        char *q;
                        fgets(buffer, 999, fh);
                        p = buffer;
                        while (*p == ' ' || *p == '\t') p++;
                        if(buffer[strlen(buffer) -1] == '\n') buffer[strlen(buffer) -1] = '\0';
                        if((q = strchr(p,' ')))
                        {
                            *q++ = '\0';
                            if(*q != '\0')
                            {
                            interpreter_args = mystrdup(q);
                            }
                        }
                        else interpreter_args=mystrdup("");

                        interpreter = mystrdup(p);
                        size += strlen(interpreter) + 1;
                        size += strlen(interpreter_args) +1;
                }

                fclose(fh);
        }
        else
        {
            /* We couldn't open this why not? */
            if(errno == ENOENT)
            {
                /* file didn't exist! */
                return -1;
            }
        }


        /* Allocate the command line */
        filename_conv = convert_path_u2a(filename);


        if(filename_conv)
            size += strlen(filename_conv);
        size += 1;
        full = AllocVec(size+10,MEMF_ANY|MEMF_CLEAR);
        if (full)
        {
            if (interpreter)
            {
                interpreter_conv = convert_path_u2a(interpreter);
#if !defined(__USE_RUNCOMMAND__)
#warning (using system!)
                sprintf(full, "%s %s %s ", interpreter_conv, interpreter_args,filename_conv);
#else
                sprintf(full, "%s %s ",interpreter_args, filename_conv);
#endif
                FreeVec(interpreter);
                FreeVec(interpreter_args);

                if(filename_conv)
                    FreeVec(filename_conv);
               fname = mystrdup(interpreter_conv);

                if(interpreter_conv)
                    FreeVec(interpreter_conv);
            }
            else
            {
#ifndef __USE_RUNCOMMAND__
                sprintf(full, "%s ", filename_conv);
#else
                sprintf(full,"");
#endif
                fname = mystrdup(filename_conv);
                if(filename_conv)
                    FreeVec(filename_conv);
            }

            for (cur = (char**)(argv+1); *cur != 0; cur++)
            {
                if(contains_whitespace(*cur))
                {
                    int esc = no_of_escapes(*cur);

                    if(esc > 0)
                    {
                        char *buff=AllocVec(strlen(*cur) + 4 + esc,MEMF_ANY|MEMF_CLEAR);
                        char *p = *cur;
                        char *q = buff;

                        *q++ = '"';
                        while(*p != '\0')
                        {

                            if(*p == '\n'){ *q++ = '*'; *q++ = 'N';p++;continue;}
                            else if(*p == '"'){ *q++ = '*'; *q++ = '"';p++;continue;}
                            else if(*p == '*' ){ *q++ = '*';}
                            *q++ = *p++;
                        }
                        *q++ = '"';
                        *q++ = ' ';
                        *q='\0';
                        strcat(full,buff);
                        FreeVec(buff);
                    }
                    else
                    {
                        strcat(full,"\"");
                        strcat(full,*cur);
                        strcat(full,"\" ");
                    }
                }
                else
                {
                    strcat(full, *cur);
                    strcat(full, " ");
                }

            }
            strcat(full,"\n");

//            if(envp)
//                 createvars(envp);

#ifndef __USE_RUNCOMMAND__
            result = SystemTags(full,
                SYS_UserShell,TRUE,
                NP_StackSize,  ((struct Process *)thisTask)->pr_StackSize,
                SYS_Input,((struct Process *)thisTask)->pr_CIS,
                SYS_Output,((struct Process *)thisTask)->pr_COS,
                SYS_Error,((struct Process *)thisTask)->pr_CES,
              TAG_DONE);
#else

            if (fname){
                BPTR seglist = LoadSeg(fname);
                if(seglist)
                {
                    /* check if we have an executable! */
                    struct PseudoSegList *ps = NULL;
                    if(!GetSegListInfoTags( seglist, GSLI_Native, &ps, TAG_DONE))
                    {
                        GetSegListInfoTags( seglist, GSLI_68KPS, &ps, TAG_DONE);
                    }
                    if( ps != NULL )
                    {
                        SetProgramName(fname);
//                        result=RunCommand(seglist,8*1024,full,strlen(full));
                        result=myruncommand(seglist,8*1024,full,strlen(full),envp);

                        errno=0;
                    }
                    else
                    {
                        errno=ENOEXEC;
                    }
                    UnLoadSeg(seglist);

                }
                else
                {
                    errno=ENOEXEC;
                }
               FreeVec(fname);
            }

#endif /* USE_RUNCOMMAND */

            FreeVec(full);
            if(errno == ENOEXEC) return -1;
            return result;
        }

        if(interpreter)
            FreeVec(interpreter);
        if(filename_conv)
            FreeVec(filename_conv);

        errno = ENOMEM;

        return -1;
}


int pause(void)
{
        fprintf(stderr,"Pause not implemented\n");

        errno = EINTR;
        return -1;
}







uint32
size_env(struct Hook *hook, APTR userdata, struct ScanVarsMsg *message)
{
        if(strlen(message->sv_GDir) <= 4)
        {
                hook->h_Data = (APTR)(((uint32)hook->h_Data) + 1);
        }
        return 0;
}

uint32
copy_env(struct Hook *hook, APTR userdata, struct ScanVarsMsg *message)
{
        if(strlen(message->sv_GDir) <= 4)
        {
                char **env = (char **)hook->h_Data;
                uint32 size = strlen(message->sv_Name) + 1 + message->sv_VarLen + 1 + 1;
                char *buffer=(char *)AllocVec((uint32)size,MEMF_ANY|MEMF_CLEAR);

                snprintf(buffer,size-1,"%s=%s", message->sv_Name, message->sv_Var);

                *env  = buffer;
                env++;
                hook->h_Data = env;
        }
        return 0;
}

void
___makeenviron()
{
        struct Hook hook;

        char varbuf[8];
        uint32 flags=0;

        if(GetVar("ABCSH_IMPORT_LOCAL",varbuf,8,GVF_LOCAL_ONLY) > 0)
        {
            flags = GVF_LOCAL_ONLY;
        }
        else
        {
            flags = GVF_GLOBAL_ONLY;
        }


        hook.h_Entry = size_env;
        hook.h_Data = 0;

        ScanVars(&hook, flags, 0);
        hook.h_Data = (APTR)(((uint32)hook.h_Data) + 1);

        environ = (char **)AllocVec((uint32)hook.h_Data*sizeof(char **), MEMF_ANY|MEMF_CLEAR );

        if (!environ)
        {
                return;
        }
        hook.h_Entry = copy_env;
        hook.h_Data = environ;

        ScanVars(&hook, flags, 0);


}

void
___freeenviron()
{
        char **i;
        for(i=environ;*i!=NULL;i++)
        {
            FreeVec(*i);
        }

        FreeVec(environ);
}


/* reimplementaion of popen, clib2's doesn't do all we want */

static BOOL
is_final_quote_character(const char * str)
{
        BOOL result;

        result = (BOOL)(str[0] == '\"' && (str[1] == '\0' || isspace(str[1])));

        return(result);
}

static BOOL
is_final_squote_character(const char * str)
{
        BOOL result;

        result = (BOOL)(str[0] == '\'' && (str[1] == '\0' || isspace(str[1])));

        return(result);
}



int popen_child()
{
    struct Task* thisTask = FindTask(0);

    char *command = thisTask->tc_UserData;
    size_t len;
    char *str;
    int argc;
    int number_of_arguments;
    char *argv[4];

    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command ? command : NULL;
    argv[3] = NULL;


    /* We need to give this to sh via execvp, execvp expects filename, argv[]
     */



        execvp(argv[0],argv);
        if(command)FreeVec(command);


        Forbid();
        return 0;

}

FILE* amigaos_popen(char *cmd, char *mode)
{
    FILE * result = NULL;
    char pipe_name[20];
    char unix_pipe[25];
    char ami_pipe[25];
    char *cmd_copy;
    BPTR input = 0;
    BPTR output = 0;
    struct Process *proc;
    struct Task *thisTask= FindTask(0);

    /* First we need to check the mode
     * We can only have unidirectional pipes
     */
    switch(mode[0])
    {
        case 'r':
        case 'w':
            break;

        default:

           errno = EINVAL;
           return result;
    }


    /* Make a unique pipe name
     * we need a unix one and an amigaos version (of the same pipe!)
     * as were linking with libunix.
     */

     sprintf(pipe_name, "%x%08x/4096/0", pipenum++,GetUniqueID());
     sprintf(unix_pipe, "/PIPE/%s",pipe_name);
     sprintf(ami_pipe,  "PIPE:%s", pipe_name);

     /* Now we open the AmigaOs Filehandles That we wil pass to our
      * Sub process
      */

    if(mode[0] == 'r')
    {
        /* A read mode pipe: Ouput from pipe input from NIL:*/
        input = Open("NIL:",MODE_NEWFILE);
        if(input != 0)
        {
            output = Open(ami_pipe,MODE_NEWFILE);

        }
    }
    else
    {

        input = Open(ami_pipe,MODE_NEWFILE);
        if(input !=0)
        {
            output = Open("NIL:",MODE_NEWFILE);
        }

    }
    if((input == 0) || (output == 0))
    {
        /* Ouch stream opening failed */
        /* Close and bail */
        if(input) Close(input);
        if(output) Close(output);
        return result;
    }

    /* We have our streams now start our new process
     * We're using a new process so that execve can modify the enironment
     * with messing things up for the shell that launched perl
     * Copy cmd before we launch the subprocess as perl seems to waste
     * no time in overwriting it! The subprocess will free the copy.
     */

     if((cmd_copy=mystrdup(cmd)))
     {

     proc = CreateNewProcTags(
            NP_Entry,               popen_child,
            NP_Child,               TRUE,
            NP_StackSize,           ((struct Process *)thisTask)->pr_StackSize,
            NP_Input,               input,
            NP_Output,              output,
            NP_Error,               ErrorOutput(),
            NP_CloseError,          FALSE,
            NP_Cli,                 TRUE,
            NP_Name,                "Perl: popen process",
            NP_UserData,            (int)cmd_copy,
            TAG_DONE);
     }
     if(!proc)
     {
        /* New Process Failed to start
         * Close and bail out
         */
         if(input) Close(input);
         if(output) Close(output);
         if(cmd_copy)FreeVec(cmd_copy);
     }

    /* Our new process is running and will close it streams etc
     * once its done. All we need to is open the pipe via stdio
     */

    return fopen(unix_pipe,mode);


}


/* Work arround for clib2 fstat */
#ifndef  S_IFCHR
#define S_IFCHR 0x0020000
#endif

#define SET_FLAG(u,v) ((void)((u) |= (v)))

int afstat(int fd, struct stat *statb)
{
    int result;
    BPTR fh;
    int mode;
    BOOL input;
    /* In the first instance pass it to fstat */

    if((result = fstat(fd,statb) >= 0)) return result;

    /* Now we've got a file descriptor but we failed to stat it */
    /* Could be a nil: or could be a std#? */

    /* if get_default_file fails we had a dud fd so return failure */

    if(__get_default_file(fd,&fh)) return -1;

    /* if nil: return failure*/
    if(fh == 0) return -1;

    /* Now compare with our process Input() Output() etc */
    /* if these were regulars files sockets or pipes we had allready succeded */
    /* so we can guess they a character special console.... I hope */

    mode = S_IFCHR;

    if (fh == Input())
    {
        input = TRUE;
        SET_FLAG(mode,S_IRUSR);
        SET_FLAG(mode,S_IRGRP);
        SET_FLAG(mode,S_IROTH);


    }
    else
    if(fh == Output() || fh==ErrorOutput())
    {
        input = FALSE;
        SET_FLAG(mode,S_IWUSR);
        SET_FLAG(mode,S_IWGRP);
        SET_FLAG(mode,S_IWOTH);

    }
    else return -1;

    memset(statb,0,sizeof(statb));

   statb->st_mode = mode;
   return 0;

}


