/* script to make symbols lists etc from embed.fnc and others */


cpp_command = "cpp -DUSE_ITHREADS -DPERL_IMPLICIT_CONTEXT sdk:Projects/perl-5.8.5/myembed.fnc >ram:perlf"


address command cpp_command

if open('IN',"ram:perlf",'R') then do

    if(open('OUT',"ram:perlfprotos",'W')) then do

        line = readln('IN')
        outline = "";
        do while ~eof('IN')

            if (pos('|',line) > 0) then do
                parse var line key "|" rettype "|" symbol "|" args;
                /* only output lines with A */
                if (pos('A',key) >0) & (pos('m',key) = 0) then do
                    outline = rettype || " "
                    if(pos('p',key) >0) then outline = outline || "Perl_"
                    outline = outline  || symbol || "("
                    if (pos('n',key) = 0) then outline = outline || " pTHX_ "

                    if(pos('|',args) >0) then do until pos('|',args) =0
                        parse var args narg '|' args
                        outline = outline || narg || ", "
                    end
                        outline = outline || args || " );"
                    call writeln('OUT',outline)
                end
            end
            else
            if~((pos(':',line) = 1) | (pos('#',line) = 1) | (pos('EXTERN_C',line) > 0)) then writeln('OUT',line)
            line = readln('IN')
            outline ="";
        end
        call close('OUT');
    end
    call close('IN')
end

/* take the protos file and make a line of ptrs to function and a file of symbols */

if (open('PROTOS',"ram:perlfprotos",'R')) then do
    if(open('SYMBOLS',"ram:perlfsysmbols",'W')) then do
        if(open('FUNCPTRS',"ram:funcptrs",'W')) then do
            if(open('DEFINES',"ram:defines",'W')) then do

                line = readln('PROTOS')
                do while ~eof('PROTOS')
                    if(pos(';',line) > 0) then do
                        parse var line type " " symbol "(" rest
                        symbol = strip(symbol);
                        call writeln('SYMBOLS',symbol || ",")
                        call writeln('FUNCPTRS',type || " (* " || symbol || ")(" || rest)
                        call writeln('DEFINES', "#define " || symbol || " aTHX->" || symbol);
                    end
                    line = readln('PROTOS')
                end
                call close('FUNCPTRS')
            end
            call close('FUNCPTRS')
        end
        call close('SYMBOLS')
    end
    call close('PROTOS')
end
