#!/SDK/C/sh
#
# If these # comments don't work, trim them. Don't worry about any other
# shell scripts, Configure will trim # comments from them for you.
#
# (If you are trying to port this package to a machine without sh,
# I would suggest you have a look at the prototypical config_h.SH file
# and edit it to reflect your system. Some packages may include samples
# of config.h for certain machines, so you might look for one of those.)
#
# Yes, you may rip this off to use in other distribution packages. This
# script belongs to the public domain and cannot be copyrighted.
#
# (Note: this Configure script was generated automatically. Rather than
# working with this copy of Configure, you may wish to get metaconfig.
# The dist-3.0 package (which contains metaconfig) was posted in
# comp.sources.misc and is available on CPAN under authors/id/RAM so
# you may fetch it yourself from your nearest archive site.)
#

# $Id: Head.U,v 3.0.1.9 1997/02/28 15:02:09 ram Exp $
#
# Generated on Wed May 12 13:00:30 METDST 2004 [metaconfig 3.0 PL70]
# (with additional metaconfig patches by perlbug@perl.org)

cat >c1$$ <<EOF
ARGGGHHHH!!!!!

SCO csh still thinks true is false.  Write to SCO today and tell them that next
year Configure ought to "rm /bin/csh" unless they fix their blasted shell. :-)

(Actually, Configure ought to just patch csh in place.  Hmm.  Hmmmmm.  All
we'd have to do is go in and swap the && and || tokens, wherever they are.)

[End of diatribe. We now return you to your regularly scheduled programming...]
EOF
cat >c2$$ <<EOF

OOPS!  You naughty creature!  You didn't run Configure with sh!
I will attempt to remedy the situation by running sh for you...
EOF

true || cat c1$$ c2$$
true || exec sh $0 $argv:q

#(exit $?0) || cat c2$$
#(exit $?0) || exec sh $0 $argv:q
delete quiet c1$$ c2$$

if test -f /dev/cputype -a -f /dev/drivers -a -f /dev/osversion; then
        cat >&4 <<EOF
***
*** I'm sorry but this system looks like Plan 9 and Plan 9 doesn't do
*** Configure that well.  (Plan 9 is close to UNIX but not close enough.)
*** Please read the README.plan9 for further instructions.
*** Cannot continue, aborting.
***
EOF
        exit 1
fi

: compute my invocation name
me=$0
case "$0" in
*/*)
        me=`echo $0 | sed -e 's!.*/\(.*\)!\1!' 2>/dev/null`
        test "$me" || me=$0
        ;;
esac

: Proper separator for the PATH environment variable
p_=";"
: On OS/2 this directory should exist if this is not floppy only system :-]
if test -d c:/. || ( uname -a | grep -i 'os\(/\|\)2' ) 2>&1 >/dev/null ; then
    if test -n "$OS2_SHELL"; then
                p_=\;
                PATH=`cmd /c "echo %PATH%" | tr '\\\\' / `
                OS2_SHELL=`cmd /c "echo %OS2_SHELL%" | tr '\\\\' / | tr '[A-Z]' '[a-z]'`
                is_os2=yes
        elif test -n "$DJGPP"; then
                case "X${MACHTYPE:-nonesuchmach}" in
                *cygwin) ;;
                *) p_=\; ;;
                esac
        fi
fi

: Proper PATH setting
#paths='/bin /usr/bin /usr/local/bin /usr/ucb /usr/local /usr/lbin'
#paths="$paths /opt/bin /opt/local/bin /opt/local /opt/lbin"
#paths="$paths /usr/5bin /etc /usr/gnu/bin /usr/new /usr/new/bin /usr/nbin"
#paths="$paths /opt/gnu/bin /opt/new /opt/new/bin /opt/nbin"
#paths="$paths /sys5.3/bin /sys5.3/usr/bin /bsd4.3/bin /bsd4.3/usr/ucb"
#paths="$paths /bsd4.3/usr/bin /usr/bsd /bsd43/bin /usr/ccs/bin"
#paths="$paths /etc /usr/lib /usr/ucblib /lib /usr/ccs/lib"
#paths="$paths /sbin /usr/sbin /usr/libexec"
#paths="$paths /system/gnu_library/bin"

paths='/SDK/Local/bin/'

for p in $paths
do
        case "$p_$PATH$p_" in
        *$p_$p$p_*) ;;
        *) test -d $p && PATH=$PATH$p_$p ;;
        esac
done

PATH=.$p_$PATH
export PATH

echo $PATH;

: shall we be using ksh?
inksh=''
needksh=''
avoidksh=''
newsh=/bin/ksh
changesh=''
if (PATH=.; alias -x) >/dev/null 2>&1; then
                inksh=true
fi
if test -f /hp-ux -a -f /bin/ksh; then
        needksh='to avoid sh bug in "here document" expansion'
fi
if test -d /usr/lpp -a -f /usr/bin/bsh -a -f /usr/bin/uname; then
        if test X`/usr/bin/uname -v` = X4; then
                avoidksh="to avoid AIX 4's /bin/sh"
                newsh=/usr/bin/bsh
        fi
fi
if test -f /osf_boot -a -f /usr/sbin/setld; then
        if test X`/usr/bin/uname -s` = XOSF1; then
                avoidksh="to avoid Digital UNIX' ksh"
                newsh=/bin/sh
                unset BIN_SH # if this is 'xpg4' sh will start up ksh
        fi
fi
case "$inksh/$needksh" in
/[a-z]*)
                ENV=''
                changesh=true
                reason="$needksh"
        ;;
esac
case "$inksh/$avoidksh" in
true/[a-z]*)
        changesh=true
        reason="$avoidksh"
        ;;
esac
case "$inksh/$needksh-$avoidksh-" in
true/--)
                echo $PATH;
                cat <<EOM
(I see you are using the Korn shell.  Some ksh's blow up on $me,
mainly on older exotic systems.  If yours does, try the Bourne shell instead.)
EOM
        ;;
esac
case "$changesh" in
true)
        export newsh
        echo "(Feeding myself to $newsh $reason.)"
        case "$0" in
        Configure|*/Configure) exec $newsh $0 "$@";;
        *) exec $newsh Configure "$@";;
        esac
        ;;
esac

: if needed set CDPATH to a harmless value that is not chatty
: avoid bash 2.02 problems with empty CDPATH.
case "$CDPATH" in
'')     ;;
*)      case "$SHELL" in
        *bash*) CDPATH='.' ;;
        *)              CDPATH='' ;;
        esac
        ;;
esac
: Configure runs within the UU subdirectory
test -d UU || mkdir UU
cd UU && rm -f ./*

ccname=''
ccversion=''
ccsymbols=''
cppccsymbols=''
cppsymbols=''
from=''
run=''
targetarch=''
to=''
usecrosscompile=''
mistrustnm=''
perllibs=''
dynamic_ext=''
extensions=''
known_extensions=''
nonxs_ext=''
static_ext=''
useopcode=''
useposix=''
extras=''
d_bsd=''
d_eunice=''
d_xenix=''
eunicefix=''
Mcc=''
ar=''
awk=''
bash=''
bison=''
byacc=''
cat=''
chgrp=''
chmod=''
chown=''
comm=''
compress=''
cp=''
cpio=''
cpp=''
csh=''
date=''
echo=''
egrep=''
emacs=''
expr=''
find=''
flex=''
gmake=''
grep=''
gzip=''
inews=''
ksh=''
less=''
line=''
lint=''
ln=''
lp=''
lpr=''
ls=''
mail=''
mailx=''
make=''
mkdir=''
more=''
mv=''
nm=''
nroff=''
perl=''
pg=''
pmake=''
pr=''
rm=''
rmail=''
sed=''
sendmail=''
shar=''
sleep=''
smail=''
sort=''
submit=''
tail=''
tar=''
tbl=''
tee=''
test=''
touch=''
tr=''
troff=''
uname=''
uniq=''
uuname=''
vi=''
zcat=''
zip=''
full_ar=''
full_sed=''
libswanted=''
hint=''
myuname=''
osname=''
osvers=''
Author=''
Date=''
Header=''
Id=''
Locker=''
Log=''
RCSfile=''
Revision=''
Source=''
State=''
_a=''
_exe=''
_o=''
archobjs=''
exe_ext=''
firstmakefile=''
lib_ext=''
obj_ext=''
path_sep=''
afs=''
afsroot=''
alignbytes=''
ansi2knr=''
archlib=''
archlibexp=''
d_archlib=''
installarchlib=''
archname=''
myarchname=''
d_atolf=''
d_atoll=''
baserev=''
bin=''
binexp=''
installbin=''
byteorder=''
cc=''
ccflags=''
cppflags=''
ldflags=''
lkflags=''
locincpth=''
optimize=''
cf_email=''
cf_by=''
cf_time=''
charsize=''
contains=''
cpp_stuff=''
cpplast=''
cppminus=''
cpprun=''
cppstdin=''
d__fwalk=''
d_access=''
d_accessx=''
d_aintl=''
d_alarm=''
asctime_r_proto=''
d_asctime_r=''
d_attribut=''
d_bcmp=''
d_bcopy=''
d_bzero=''
d_casti32=''
castflags=''
d_castneg=''
d_chown=''
d_chroot=''
d_chsize=''
d_class=''
d_closedir=''
d_void_closedir=''
d_cmsghdr_s=''
d_const=''
d_copysignl=''
cryptlib=''
d_crypt=''
crypt_r_proto=''
d_crypt_r=''
d_csh=''
full_csh=''
ctermid_r_proto=''
d_ctermid_r=''
ctime_r_proto=''
d_ctime_r=''
d_cuserid=''
d_dbl_dig=''
d_dbminitproto=''
d_difftime=''
d_dirfd=''
d_dlerror=''
d_dlopen=''
d_dlsymun=''
d_dosuid=''
d_suidsafe=''
d_drand48_r=''
drand48_r_proto=''
d_drand48proto=''
d_dup2=''
d_eaccess=''
d_endgrent=''
d_endgrent_r=''
endgrent_r_proto=''
d_endhent=''
d_endhostent_r=''
endhostent_r_proto=''
d_endnent=''
d_endnetent_r=''
endnetent_r_proto=''
d_endpent=''
d_endprotoent_r=''
endprotoent_r_proto=''
d_endpwent=''
d_endpwent_r=''
endpwent_r_proto=''
d_endsent=''
d_endservent_r=''
endservent_r_proto=''
d_faststdio=''
d_fchdir=''
d_fchmod=''
d_fchown=''
d_fcntl=''
d_fcntl_can_lock=''
d_fd_macros=''
d_fd_set=''
d_fds_bits=''
d_fgetpos=''
d_finite=''
d_finitel=''
d_flexfnam=''
d_flock=''
d_flockproto=''
d_fork=''
d_fp_class=''
d_fpclass=''
d_fpclassify=''
d_fpclassl=''
d_fpos64_t=''
d_frexpl=''
d_fs_data_s=''
d_fseeko=''
d_fsetpos=''
d_fstatfs=''
d_fsync=''
d_ftello=''
d_ftime=''
d_gettimeod=''
d_Gconvert=''
d_getcwd=''
d_getespwnam=''
d_getfsstat=''
d_getgrent=''
d_getgrent_r=''
getgrent_r_proto=''
d_getgrgid_r=''
getgrgid_r_proto=''
d_getgrnam_r=''
getgrnam_r_proto=''
d_getgrps=''
d_gethbyaddr=''
d_gethbyname=''
d_gethent=''
aphostname=''
d_gethname=''
d_phostname=''
d_uname=''
d_gethostbyaddr_r=''
gethostbyaddr_r_proto=''
d_gethostbyname_r=''
gethostbyname_r_proto=''
d_gethostent_r=''
gethostent_r_proto=''
d_gethostprotos=''
d_getitimer=''
d_getlogin=''
d_getlogin_r=''
getlogin_r_proto=''
d_getmnt=''
d_getmntent=''
d_getnbyaddr=''
d_getnbyname=''
d_getnent=''
d_getnetbyaddr_r=''
getnetbyaddr_r_proto=''
d_getnetbyname_r=''
getnetbyname_r_proto=''
d_getnetent_r=''
getnetent_r_proto=''
d_getnetprotos=''
d_getpagsz=''
d_getpent=''
d_getpgid=''
d_getpgrp2=''
d_bsdgetpgrp=''
d_getpgrp=''
d_getppid=''
d_getprior=''
d_getpbyname=''
d_getpbynumber=''
d_getprotobyname_r=''
getprotobyname_r_proto=''
d_getprotobynumber_r=''
getprotobynumber_r_proto=''
d_getprotoent_r=''
getprotoent_r_proto=''
d_getprotoprotos=''
d_getprpwnam=''
d_getpwent=''
d_getpwent_r=''
getpwent_r_proto=''
d_getpwnam_r=''
getpwnam_r_proto=''
d_getpwuid_r=''
getpwuid_r_proto=''
d_getsent=''
d_getservbyname_r=''
getservbyname_r_proto=''
d_getservbyport_r=''
getservbyport_r_proto=''
d_getservent_r=''
getservent_r_proto=''
d_getservprotos=''
d_getspnam=''
d_getspnam_r=''
getspnam_r_proto=''
d_getsbyname=''
d_getsbyport=''
d_gmtime_r=''
gmtime_r_proto=''
d_gnulibc=''
gnulibc_version=''
d_hasmntopt=''
d_htonl=''
d_ilogbl=''
d_inetaton=''
d_int64_t=''
d_isascii=''
d_isfinite=''
d_isinf=''
d_isnan=''
d_isnanl=''
d_killpg=''
d_lchown=''
d_ldbl_dig=''
d_link=''
d_localtime_r=''
localtime_r_proto=''
d_locconv=''
d_lockf=''
d_longdbl=''
longdblsize=''
d_longlong=''
longlongsize=''
d_lseekproto=''
d_lstat=''
d_madvise=''
d_mblen=''
d_mbstowcs=''
d_mbtowc=''
d_memchr=''
d_memcmp=''
d_memcpy=''
d_memmove=''
d_memset=''
d_mkdir=''
d_mkdtemp=''
d_mkfifo=''
d_mkstemp=''
d_mkstemps=''
d_mktime=''
d_mmap=''
mmaptype=''
d_modfl=''
d_modfl_pow32_bug=''
d_modflproto=''
d_mprotect=''
d_msg=''
d_msgctl=''
d_msgget=''
d_msghdr_s=''
d_msgrcv=''
d_msgsnd=''
d_msync=''
d_munmap=''
d_nice=''
d_nl_langinfo=''
d_off64_t=''
d_open3=''
d_fpathconf=''
d_pathconf=''
d_pause=''
d_pipe=''
d_poll=''
d_portable=''
d_procselfexe=''
procselfexe=''
d_old_pthread_create_joinable=''
old_pthread_create_joinable=''
d_pthread_atfork=''
d_pthread_attr_setscope=''
d_pthread_yield=''
d_sched_yield=''
sched_yield=''
d_qgcvt=''
d_random_r=''
random_r_proto=''
d_readdir64_r=''
readdir64_r_proto=''
d_readdir=''
d_rewinddir=''
d_seekdir=''
d_telldir=''
d_readdir_r=''
readdir_r_proto=''
d_readlink=''
d_readv=''
d_recvmsg=''
d_rename=''
d_rmdir=''
d_safebcpy=''
d_safemcpy=''
d_sanemcmp=''
d_sbrkproto=''
d_scalbnl=''
d_select=''
d_sem=''
d_semctl=''
d_semget=''
d_semop=''
d_sendmsg=''
d_setegid=''
d_seteuid=''
d_setgrent=''
d_setgrent_r=''
setgrent_r_proto=''
d_setgrps=''
d_sethent=''
d_sethostent_r=''
sethostent_r_proto=''
d_setitimer=''
d_setlinebuf=''
d_setlocale=''
d_setlocale_r=''
setlocale_r_proto=''
d_setnent=''
d_setnetent_r=''
setnetent_r_proto=''
d_setpent=''
d_setpgid=''
d_setpgrp2=''
d_bsdsetpgrp=''
d_setpgrp=''
d_setprior=''
d_setproctitle=''
d_setprotoent_r=''
setprotoent_r_proto=''
d_setpwent=''
d_setpwent_r=''
setpwent_r_proto=''
d_setregid=''
d_setresgid=''
d_setresuid=''
d_setreuid=''
d_setrgid=''
d_setruid=''
d_setsent=''
d_setservent_r=''
setservent_r_proto=''
d_setsid=''
d_setvbuf=''
d_sfio=''
usesfio=''
d_shm=''
d_shmat=''
d_shmatprototype=''
shmattype=''
d_shmctl=''
d_shmdt=''
d_shmget=''
d_sigaction=''
d_sigprocmask=''
d_sigsetjmp=''
d_sockatmark=''
d_sockatmarkproto=''
d_msg_ctrunc=''
d_msg_dontroute=''
d_msg_oob=''
d_msg_peek=''
d_msg_proxy=''
d_oldsock=''
d_scm_rights=''
d_socket=''
d_sockpair=''
sockethdr=''
socketlib=''
d_socklen_t=''
d_socks5_init=''
d_sqrtl=''
d_srand48_r=''
srand48_r_proto=''
d_srandom_r=''
srandom_r_proto=''
d_sresgproto=''
d_sresuproto=''
d_statblks=''
d_statfs_f_flags=''
d_statfs_s=''
d_fstatvfs=''
d_statvfs=''
d_stdio_cnt_lval=''
d_stdio_ptr_lval=''
d_stdio_ptr_lval_nochange_cnt=''
d_stdio_ptr_lval_sets_cnt=''
d_stdiobase=''
d_stdstdio=''
stdio_base=''
stdio_bufsiz=''
stdio_cnt=''
stdio_filbuf=''
stdio_ptr=''
d_index=''
d_strchr=''
d_strcoll=''
d_strctcpy=''
d_strerrm=''
d_strerror=''
d_sysernlst=''
d_syserrlst=''
d_strerror_r=''
strerror_r_proto=''
d_strftime=''
d_strtod=''
d_strtol=''
d_strtold=''
d_strtoll=''
d_strtoq=''
d_strtoul=''
d_strtoull=''
d_strtouq=''
d_strxfrm=''
d_symlink=''
d_syscall=''
d_syscallproto=''
d_sysconf=''
d_system=''
d_tcgetpgrp=''
d_tcsetpgrp=''
d_telldirproto=''
d_time=''
timetype=''
clocktype=''
d_times=''
d_tmpnam_r=''
tmpnam_r_proto=''
d_truncate=''
d_ttyname_r=''
ttyname_r_proto=''
d_tzname=''
d_u32align=''
d_ualarm=''
d_umask=''
d_semctl_semid_ds=''
d_semctl_semun=''
d_union_semun=''
d_unordered=''
d_usleep=''
d_usleepproto=''
d_ustat=''
d_vfork=''
usevfork=''
d_voidsig=''
signal_t=''
d_volatile=''
d_charvspr=''
d_vprintf=''
d_wait4=''
d_waitpid=''
d_wcstombs=''
d_wctomb=''
d_writev=''
dlext=''
cccdlflags=''
ccdlflags=''
dlsrc=''
ld=''
lddlflags=''
usedl=''
doublesize=''
ebcdic=''
fflushNULL=''
fflushall=''
fpossize=''
fpostype=''
gccansipedantic=''
gccosandvers=''
gccversion=''
gidformat=''
gidsign=''
gidsize=''
gidtype=''
groupstype=''
h_fcntl=''
h_sysfile=''
html1dir=''
html1direxp=''
installhtml1dir=''
html3dir=''
html3direxp=''
installhtml3dir=''
i_arpainet=''
i_crypt=''
db_hashtype=''
db_prefixtype=''
db_version_major=''
db_version_minor=''
db_version_patch=''
i_db=''
i_dbm=''
i_rpcsvcdbm=''
d_dirnamlen=''
direntrytype=''
i_dirent=''
i_dld=''
i_dlfcn=''
i_fcntl=''
i_float=''
i_fp=''
i_fp_class=''
i_gdbm=''
d_grpasswd=''
i_grp=''
i_ieeefp=''
i_inttypes=''
i_langinfo=''
i_libutil=''
i_limits=''
i_locale=''
i_machcthr=''
i_malloc=''
i_math=''
i_memory=''
i_mntent=''
i_ndbm=''
i_netdb=''
i_neterrno=''
i_netinettcp=''
i_niin=''
i_sysin=''
i_poll=''
i_prot=''
i_pthread=''
d_pwage=''
d_pwchange=''
d_pwclass=''
d_pwcomment=''
d_pwexpire=''
d_pwgecos=''
d_pwpasswd=''
d_pwquota=''
i_pwd=''
i_sfio=''
i_shadow=''
i_socks=''
i_stddef=''
i_stdlib=''
i_string=''
strings=''
i_sunmath=''
i_sysaccess=''
i_sysdir=''
i_sysfile=''
d_voidtty=''
i_bsdioctl=''
i_sysfilio=''
i_sysioctl=''
i_syssockio=''
i_syslog=''
i_sysmman=''
i_sysmode=''
i_sysmount=''
i_sysndir=''
i_sysparam=''
i_sysresrc=''
i_syssecrt=''
i_sysselct=''
i_sysstat=''
i_sysstatfs=''
i_sysstatvfs=''
i_systimes=''
i_systypes=''
i_sysuio=''
i_sysun=''
i_sysutsname=''
i_sysvfs=''
i_syswait=''
i_sgtty=''
i_termio=''
i_termios=''
d_tm_tm_gmtoff=''
d_tm_tm_zone=''
i_systime=''
i_systimek=''
i_time=''
timeincl=''
i_unistd=''
i_ustat=''
i_utime=''
i_values=''
i_stdarg=''
i_varargs=''
i_varhdr=''
i_vfork=''
inc_version_list=''
inc_version_list_init=''
installprefix=''
installprefixexp=''
installstyle=''
installusrbinperl=''
intsize=''
longsize=''
shortsize=''
issymlink=''
libc=''
ldlibpthname=''
libperl=''
shrpenv=''
useshrplib=''
glibpth=''
libpth=''
loclibpth=''
plibpth=''
xlibpth=''
ignore_versioned_solibs=''
libs=''
libsdirs=''
libsfiles=''
libsfound=''
libspath=''
lns=''
d_PRIEUldbl=''
d_PRIFUldbl=''
d_PRIGUldbl=''
d_PRIeldbl=''
d_PRIfldbl=''
d_PRIgldbl=''
d_SCNfldbl=''
sPRIEUldbl=''
sPRIFUldbl=''
sPRIGUldbl=''
sPRIeldbl=''
sPRIfldbl=''
sPRIgldbl=''
sSCNfldbl=''
lseeksize=''
lseektype=''
make_set_make=''
d_mymalloc=''
freetype=''
mallocobj=''
mallocsrc=''
malloctype=''
usemallocwrap=''
usemymalloc=''
installman1dir=''
man1dir=''
man1direxp=''
man1ext=''
installman3dir=''
man3dir=''
man3direxp=''
man3ext=''
modetype=''
multiarch=''
mydomain=''
myhostname=''
phostname=''
c=''
n=''
d_eofnblk=''
eagain=''
o_nonblock=''
rd_nodata=''
need_va_copy=''
netdb_hlen_type=''
netdb_host_type=''
netdb_name_type=''
netdb_net_type=''
groupcat=''
hostcat=''
passcat=''
orderlib=''
ranlib=''
d_perl_otherlibdirs=''
otherlibdirs=''
package=''
spackage=''
pager=''
api_revision=''
api_subversion=''
api_version=''
api_versionstring=''
patchlevel=''
perl_patchlevel=''
revision=''
subversion=''
version=''
version_patchlevel_string=''
perl5=''
perladmin=''
perlpath=''
d_nv_preserves_uv=''
i16size=''
i16type=''
i32size=''
i32type=''
i64size=''
i64type=''
i8size=''
i8type=''
ivsize=''
ivtype=''
nv_preserves_uv_bits=''
nvsize=''
nvtype=''
u16size=''
u16type=''
u32size=''
u32type=''
u64size=''
u64type=''
u8size=''
u8type=''
uvsize=''
uvtype=''
ivdformat=''
nvEUformat=''
nvFUformat=''
nvGUformat=''
nveformat=''
nvfformat=''
nvgformat=''
uvXUformat=''
uvoformat=''
uvuformat=''
uvxformat=''
pidtype=''
prefix=''
prefixexp=''
installprivlib=''
privlib=''
privlibexp=''
prototype=''
ptrsize=''
d_PRIXU64=''
d_PRId64=''
d_PRIi64=''
d_PRIo64=''
d_PRIu64=''
d_PRIx64=''
sPRIXU64=''
sPRId64=''
sPRIi64=''
sPRIo64=''
sPRIu64=''
sPRIx64=''
d_quad=''
quadkind=''
quadtype=''
uquadtype=''
drand01=''
randbits=''
randfunc=''
randseedtype=''
seedfunc=''
installscript=''
scriptdir=''
scriptdirexp=''
selectminbits=''
selecttype=''
sh=''
sig_count=''
sig_name=''
sig_name_init=''
sig_num=''
sig_num_init=''
sig_size=''
installsitearch=''
sitearch=''
sitearchexp=''
installsitebin=''
sitebin=''
sitebinexp=''
installsitehtml1dir=''
sitehtml1dir=''
sitehtml1direxp=''
installsitehtml3dir=''
sitehtml3dir=''
sitehtml3direxp=''
installsitelib=''
sitelib=''
sitelib_stem=''
sitelibexp=''
installsiteman1dir=''
siteman1dir=''
siteman1direxp=''
installsiteman3dir=''
siteman3dir=''
siteman3direxp=''
siteprefix=''
siteprefixexp=''
installsitescript=''
sitescript=''
sitescriptexp=''
sizesize=''
sizetype=''
so=''
socksizetype=''
sharpbang=''
shsharp=''
spitshell=''
src=''
ssizetype=''
startperl=''
startsh=''
stdchar=''
d_stdio_stream_array=''
stdio_stream_array=''
sysman=''
trnl=''
uidformat=''
uidsign=''
uidsize=''
uidtype=''
archname64=''
use64bitall=''
use64bitint=''
usefaststdio=''
ccflags_uselargefiles=''
ldflags_uselargefiles=''
libswanted_uselargefiles=''
uselargefiles=''
uselongdouble=''
usemorebits=''
usemultiplicity=''
nm_opt=''
nm_so_opt=''
runnm=''
usenm=''
useperlio=''
usesocks=''
d_oldpthreads=''
use5005threads=''
useithreads=''
usereentrant=''
usethreads=''
incpath=''
mips_type=''
usrinc=''
d_vendorarch=''
installvendorarch=''
vendorarch=''
vendorarchexp=''
d_vendorbin=''
installvendorbin=''
vendorbin=''
vendorbinexp=''
installvendorhtml1dir=''
vendorhtml1dir=''
vendorhtml1direxp=''
installvendorhtml3dir=''
vendorhtml3dir=''
vendorhtml3direxp=''
d_vendorlib=''
installvendorlib=''
vendorlib=''
vendorlib_stem=''
vendorlibexp=''
installvendorman1dir=''
vendorman1dir=''
vendorman1direxp=''
installvendorman3dir=''
vendorman3dir=''
vendorman3direxp=''
usevendorprefix=''
vendorprefix=''
vendorprefixexp=''
d_vendorscript=''
installvendorscript=''
vendorscript=''
vendorscriptexp=''
versiononly=''
defvoidused=''
voidflags=''
yacc=''
yaccflags=''
CONFIG=''

define='define'
undef='undef'
smallmach='pdp11 i8086 z8000 i80286 iAPX286'
rmlist=''

: We must find out about Eunice early
eunicefix=':'
if test -f /etc/unixtovms; then
        eunicefix=/etc/unixtovms
fi
if test -f /etc/unixtovms.exe; then
        eunicefix=/etc/unixtovms.exe
fi

: Set executable suffix now -- needed before hints available
if test -f "/libs/version.library"; then
: Amiga OS
    _exe=""
elif test -f "/system/gnu_library/bin/ar.pm"; then
: Stratus VOS
    _exe=".pm"
elif test -n "$DJGPP"; then
: DOS DJGPP
    _exe=".exe"
elif test -d c:/. -o -n "$is_os2" ; then
: OS/2 or cygwin
    _exe=".exe"
fi

i_whoami=''
ccname=''
ccversion=''
perllibs=''
: set useposix=false in your hint file to disable the POSIX extension.
useposix=true
: set useopcode=false in your hint file to disable the Opcode extension.
useopcode=true
: Trailing extension.  Override this in a hint file, if needed.
: Extra object files, if any, needed on this platform.
archobjs=''
archname=''
: Possible local include directories to search.
: Set locincpth to "" in a hint file to defeat local include searches.
locincpth="/usr/local/include /opt/local/include /usr/gnu/include"
locincpth="$locincpth /opt/gnu/include /usr/GNU/include /opt/GNU/include"
:
: no include file wanted by default
inclwanted=''

groupstype=''
libnames=''
: change the next line if compiling for Xenix/286 on Xenix/386
xlibpth='/usr/lib/386 /lib/386'
: Possible local library directories to search.
loclibpth="/usr/local/lib /opt/local/lib /usr/gnu/lib"
loclibpth="$loclibpth /opt/gnu/lib /usr/GNU/lib /opt/GNU/lib"

: general looking path for locating libraries
glibpth="/lib /usr/lib $xlibpth"
glibpth="$glibpth /usr/ccs/lib /usr/ucblib /usr/local/lib"
test -f /usr/shlib/libc.so && glibpth="/usr/shlib $glibpth"
test -f /shlib/libc.so     && glibpth="/shlib $glibpth"

: Private path used by Configure to find libraries.  Its value
: is prepended to libpth. This variable takes care of special
: machines, like the mips.  Usually, it should be empty.
plibpth=''

: default library list
libswanted=''
: some systems want to use only the non-versioned libso:s
ignore_versioned_solibs=''
siteman1dir=''
siteman3dir=''
sitescript=''
archname64=''
ccflags_uselargefiles=''
ldflags_uselargefiles=''
libswanted_uselargefiles=''
: set usemultiplicity on the Configure command line to enable multiplicity.
: set usesocks on the Configure command line to enable socks.
: set usethreads on the Configure command line to enable threads.
usereentrant='undef'
: full support for void wanted by default
defvoidused=15

: List of libraries we want.
: If anyone needs extra -lxxx, put those in a hint file.
libswanted="sfio socket bind inet nsl nm ndbm gdbm dbm db malloc dl dld ld sun"
libswanted="$libswanted m crypt sec util c cposix posix ucb bsd BSD"
: We probably want to search /usr/shlib before most other libraries.
: This is only used by the lib/ExtUtils/MakeMaker.pm routine extliblist.
glibpth=`echo " $glibpth " | sed -e 's! /usr/shlib ! !'`
glibpth="/usr/shlib $glibpth"
: Do not use vfork unless overridden by a hint file.
usevfork=false

: Find the basic shell for Bourne shell scripts
case "$sh" in
'')
        case "$SYSTYPE" in
        *bsd*|sys5*) xxx="/$SYSTYPE/bin/sh";;
        *) xxx='/bin/sh';;
        esac
        if test -f "$xxx"; then
                sh="$xxx"
        else
                : Build up a list and do a single loop so we can 'break' out.
                pth=`echo $PATH | sed -e "s/$p_/ /g"`
                for xxx in sh bash ksh pdksh ash; do
                        for p in $pth; do
                                try="$try ${p}/${xxx}"
                        done
                done
                for xxx in $try; do
                        if test -f "$xxx"; then
                                sh="$xxx";
                                break
                        elif test "X$_exe" != X -a -f "$xxx$_exe"; then
                                sh="$xxx";
                                break
                        elif test -f "$xxx.exe"; then
                                sh="$xxx";
                                break
                        fi
                done
        fi
        ;;
esac

case "$sh" in
'')     cat >&2 <<EOM
$me:  Fatal Error:  I can't find a Bourne Shell anywhere.

Usually it's in /bin/sh.  How did you even get this far?
Please contact me (Perl Maintainers) at perlbug@perl.org and
we'll try to straighten this all out.
EOM
        exit 1
        ;;
esac

: see if sh knows # comments
if `$sh -c '#' >/dev/null 2>&1`; then
        shsharp=true
        spitshell=cat
        xcat=/bin/cat
        test -f $xcat$_exe || xcat=/usr/bin/cat
        if test ! -f $xcat$_exe; then
                for p in `echo $PATH | sed -e "s/$p_/ /g"` $paths; do
                        if test -f $p/cat$_exe; then
                                xcat=$p/cat
                                break
                        fi
                done
                if test ! -f $xcat$_exe; then
                        echo "Can't find cat anywhere!"
                        exit 1
                fi
        fi
        echo "#!$xcat" >sharp
        $eunicefix sharp
        chmod +x sharp
        ./sharp > today
        if test -s today; then
                sharpbang='#!'
        else
                echo "#! $xcat" > sharp
                $eunicefix sharp
                chmod +x sharp
                ./sharp > today
                if test -s today; then
                        sharpbang='#! '
                else
                        sharpbang=': use '
                fi
        fi
else
        echo " "
        echo "Your $sh doesn't grok # comments--I will strip them later on."
        shsharp=false
        cd ..
        echo "exec grep -v '^[  ]*#'" >spitshell
        chmod +x spitshell
        $eunicefix spitshell
        spitshell=`pwd`/spitshell
        cd UU
        echo "I presume that if # doesn't work, #! won't work either!"
        sharpbang=': use '
fi
rm -f sharp today

: figure out how to guarantee sh startup
case "$startsh" in
'') startsh=${sharpbang}${sh} ;;
*)
esac
cat >sharp <<EOSS
$startsh
set abc
test "$?abc" != 1
EOSS

chmod +x sharp
$eunicefix sharp
if ./sharp; then
        : echo "Yup, it does."
else
        echo "Hmm... '$startsh' does not guarantee sh startup..."
        echo "You may have to fix up the shell scripts to make sure $sh runs them."
fi
rm -f sharp


: Save command line options in file UU/cmdline.opt for later use in
: generating config.sh.
cat > cmdline.opt <<EOSH
# Configure command line arguments.
config_arg0='$0'
config_args='$*'
config_argc=$#
EOSH
argn=1
args_exp=''
args_sep=''
for arg in "$@"; do
        cat >>cmdline.opt <<EOSH
config_arg$argn='$arg'
EOSH
        # Extreme backslashitis: replace each ' by '"'"'
        cat <<EOC | sed -e "s/'/'"'"'"'"'"'"'/g" > cmdl.opt
$arg
EOC
        arg_exp=`cat cmdl.opt`
        args_exp="$args_exp$args_sep'$arg_exp'"
        argn=`expr $argn + 1`
        args_sep=' '
done
# args_exp is good for restarting self: eval "set X $args_exp"; shift; $0 "$@"
# used by ./hints/os2.sh
rm -f cmdl.opt

: produce awk script to parse command line options
cat >options.awk <<'EOF'
BEGIN {
        optstr = "A:dD:eEf:hKOrsSU:V";  # getopt-style specification

        len = length(optstr);
        for (i = 1; i <= len; i++) {
                c = substr(optstr, i, 1);
                if (i < len) a = substr(optstr, i + 1, 1); else a = "";
                if (a == ":") {
                        arg[c] = 1;
                        i++;
                }
                opt[c] = 1;
        }
}
{
        expect = 0;
        str = $0;
        if (substr(str, 1, 1) != "-") {
                printf("'%s'\n", str);
                next;
        }
        len = length($0);
        for (i = 2; i <= len; i++) {
                c = substr(str, i, 1);
                if (!opt[c]) {
                        printf("-%s\n", substr(str, i));
                        next;
                }
                printf("-%s\n", c);
                if (arg[c]) {
                        if (i < len)
                                printf("'%s'\n", substr(str, i + 1));
                        else
                                expect = 1;
                        next;
                }
        }
}
END {
        if (expect)
                print "?";
}
EOF

: process the command line options
set X `for arg in "$@"; do echo "X$arg"; done |
        sed -e s/X// | awk -f options.awk`
eval "set $*"
shift
rm -f options.awk

: set up default values
fastread=''
reuseval=false
config_sh=''
alldone=''
error=''
silent=''
extractsh=''
override=''
knowitall=''
rm -f optdef.sh posthint.sh
cat >optdef.sh <<EOS
$startsh
EOS


: option parsing
while test $# -gt 0; do
        case "$1" in
        -d) shift; fastread=yes;;
        -e) shift; alldone=cont;;
        -f)
                shift
                cd ..
                if test -r "$1"; then
                        config_sh="$1"
                else
                        echo "$me: cannot read config file $1." >&2
                        error=true
                fi
                cd UU
                shift;;
        -h) shift; error=true;;
        -r) shift; reuseval=true;;
        -s) shift; silent=true; realsilent=true;;
        -E) shift; alldone=exit;;
        -K) shift; knowitall=true;;
        -O) shift; override=true;;
        -S) shift; silent=true; extractsh=true;;
        -D)
                shift
                case "$1" in
                *=)
                        echo "$me: use '-U symbol=', not '-D symbol='." >&2
                        echo "$me: ignoring -D $1" >&2
                        ;;
                *=*) echo "$1" | \
                                sed -e "s/'/'\"'\"'/g" -e "s/=\(.*\)/='\1'/" >> optdef.sh;;
                *) echo "$1='define'" >> optdef.sh;;
                esac
                shift
                ;;
        -U)
                shift
                case "$1" in
                *=) echo "$1" >> optdef.sh;;
                *=*)
                        echo "$me: use '-D symbol=val', not '-U symbol=val'." >&2
                        echo "$me: ignoring -U $1" >&2
                        ;;
                *) echo "$1='undef'" >> optdef.sh;;
                esac
                shift
                ;;
        -A)
            shift
            xxx=''
            yyy="$1"
            zzz=''
            uuu=undef
            case "$yyy" in
            *=*) zzz=`echo "$yyy"|sed 's!=.*!!'`
                 case "$zzz" in
                 *:*) zzz='' ;;
                 *)   xxx=append
                      zzz=" "`echo "$yyy"|sed 's!^[^=]*=!!'`
                      yyy=`echo "$yyy"|sed 's!=.*!!'` ;;
                 esac
                 ;;
            esac
            case "$xxx" in
            '')  case "$yyy" in
                 *:*) xxx=`echo "$yyy"|sed 's!:.*!!'`
                      yyy=`echo "$yyy"|sed 's!^[^:]*:!!'`
                      zzz=`echo "$yyy"|sed 's!^[^=]*=!!'`
                      yyy=`echo "$yyy"|sed 's!=.*!!'` ;;
                 *)   xxx=`echo "$yyy"|sed 's!:.*!!'`
                      yyy=`echo "$yyy"|sed 's!^[^:]*:!!'` ;;
                 esac
                 ;;
            esac
            case "$xxx" in
            append)
                echo "$yyy=\"\${$yyy}$zzz\""    >> posthint.sh ;;
            clear)
                echo "$yyy=''"                  >> posthint.sh ;;
            define)
                case "$zzz" in
                '') zzz=define ;;
                esac
                echo "$yyy='$zzz'"              >> posthint.sh ;;
            eval)
                echo "eval \"$yyy=$zzz\""       >> posthint.sh ;;
            prepend)
                echo "$yyy=\"$zzz\${$yyy}\""    >> posthint.sh ;;
            undef)
                case "$zzz" in
                '') zzz="$uuu" ;;
                esac
                echo "$yyy=$zzz"                >> posthint.sh ;;
            *)  echo "$me: unknown -A command '$xxx', ignoring -A $1" >&2 ;;
            esac
            shift
            ;;
        -V) echo "$me generated by metaconfig 3.0 PL70." >&2
            exit 0;;
        --) break;;
        -*) echo "$me: unknown option $1" >&2; shift; error=true;;
        *) break;;
        esac
done

case "$error" in
true)
        cat >&2 <<EOM
Usage: $me [-dehrsEKOSV] [-f config.sh] [-D symbol] [-D symbol=value]
                 [-U symbol] [-U symbol=] [-A command:symbol...]
  -d : use defaults for all answers.
  -e : go on without questioning past the production of config.sh.
  -f : specify an alternate default configuration file.
  -h : print this help message and exit (with an error status).
  -r : reuse C symbols value if possible (skips costly nm extraction).
  -s : silent mode, only echoes questions and essential information.
  -D : define symbol to have some value:
         -D symbol         symbol gets the value 'define'
         -D symbol=value   symbol gets the value 'value'
  -E : stop at the end of questions, after having produced config.sh.
  -K : do not use unless you know what you are doing.
  -O : let -D and -U override definitions from loaded configuration file.
  -S : perform variable substitutions on all .SH files (can mix with -f)
  -U : undefine symbol:
         -U symbol    symbol gets the value 'undef'
         -U symbol=   symbol gets completely empty
  -A : manipulate symbol after the platform specific hints have been applied:
         -A symbol=value                append " "value to symbol
         -A append:symbol=value         append value to symbol
         -A define:symbol=value         define symbol to have value
         -A clear:symbol                define symbol to be ''
         -A define:symbol               define symbol to be 'define'
         -A eval:symbol=value           define symbol to be eval of value
         -A prepend:symbol=value        prepend value to symbol
         -A undef:symbol                define symbol to be 'undef'
         -A undef:symbol=               define symbol to be ''
  -V : print version number and exit (with a zero status).
EOM
        exit 1
        ;;
esac

: Sanity checks
case "$fastread$alldone" in
yescont|yesexit) ;;
*)
        case "$extractsh" in
        true) ;;
        *)
                if test ! -t 0; then
                        echo "Say 'sh Configure', not 'sh <Configure'"
                        exit 1
                fi
                ;;
        esac
        ;;
esac

exec 4>&1
case "$silent" in
true) exec 1>/dev/null;;
esac

: run the defines and the undefines, if any, but leave the file out there...
touch optdef.sh
. ./optdef.sh
: create the posthint manipulation script and leave the file out there...
touch posthint.sh

: set package name
package=perl5
first=`echo $package | sed -e 's/^\(.\).*/\1/'`
last=`echo $package | sed -e 's/^.\(.*\)/\1/'`
case "`echo AbyZ | tr '[:lower:]' '[:upper:]' 2>/dev/null`" in
ABYZ) spackage=`echo $first | tr '[:lower:]' '[:upper:]'`$last;;
*) spackage=`echo $first | tr '[a-z]' '[A-Z]'`$last;;
esac

: Some greps do not return status, grrr.
echo "grimblepritz" >grimble
if grep blurfldyick grimble >/dev/null 2>&1 ; then
        contains=contains
elif grep grimblepritz grimble >/dev/null 2>&1 ; then
        contains=grep
else
        contains=contains
fi
rm -f grimble
: the following should work in any shell
case "$contains" in
contains*)
        echo " "
        echo "AGH!  Grep doesn't return a status.  Attempting remedial action."
        cat >contains <<'EOSS'
grep "$1" "$2" >.greptmp && cat .greptmp && test -s .greptmp
EOSS
chmod +x contains
esac

: Find the path to the source tree
case "$src" in
'') case "$0" in
    */*) src=`echo $0 | sed -e 's%/[^/][^/]*$%%'`
         case "$src" in
         /*)    ;;
         .)     ;;
         *)     src=`cd ../$src && pwd` ;;
         esac
         ;;
    *)   src='.';;
    esac;;
esac
case "$src" in
'')     src=/
        rsrc=/
        ;;
/*) rsrc="$src";;
*) rsrc="../$src";;
esac
if test -f $rsrc/Configure && \
        $contains "^package=$package$" $rsrc/Configure >/dev/null 2>&1
then
   : found it, so we are ok.
else
        rsrc=''
        for src in . .. ../.. ../../.. ../../../..; do
                if test -f ../$src/Configure && \
                        $contains "^package=$package$" ../$src/Configure >/dev/null 2>&1
                then
                        rsrc=../$src
                        break
                fi
        done
fi
case "$rsrc" in
'')
        cat <<EOM >&4

Sorry, I can't seem to locate the source dir for $package.  Please start
Configure with an explicit path -- i.e. /some/path/Configure.

EOM
        exit 1
        ;;
../.)   rsrc='..';;
*)
        echo " "
        echo "Sources for $package found in \"$src\"." >&4
        ;;
esac

: script used to extract .SH files with variable substitutions
cat >extract <<'EOS'
PERL_CONFIG_SH=true
echo "Doing variable substitutions on .SH files..."
if test -f MANIFEST; then
        set x `awk '{print $1}' < MANIFEST | grep '\.SH$'`
else
        echo "(Looking for .SH files under the source directory.)"
        set x `(cd "$src"; find . -name "*.SH" -print)`
fi
shift
case $# in
0) set x `(cd "$src"; echo *.SH)`; shift;;
esac
if test ! -f "$src/$1"; then
        shift
fi
mkdir_p='
name=$1;
create="";
while test $name; do
        if test ! -d "$name"; then
                create="$name $create";
                name=`echo $name | sed -e "s|^[^/]*$||"`;
                name=`echo $name | sed -e "s|\(.*\)/.*|\1|"`;
        else
                name="";
        fi;
done;
for file in $create; do
        mkdir $file;
done
'
for file in $*; do
        case "$src" in
        ".")
                case "$file" in
                */*)
                        dir=`expr X$file : 'X\(.*\)/'`
                        file=`expr X$file : 'X.*/\(.*\)'`
                        (cd "$dir" && . ./$file)
                        ;;
                *)
                        . ./$file
                        ;;
                esac
                ;;
        *)
                case "$file" in
                */*)
                        dir=`expr X$file : 'X\(.*\)/'`
                        file=`expr X$file : 'X.*/\(.*\)'`
                        (set x $dir; shift; eval $mkdir_p)
                        sh <"$src/$dir/$file"
                        ;;
                *)
                        sh <"$src/$file"
                        ;;
                esac
                ;;
        esac
done
if test -f "$src/config_h.SH"; then
        if test ! -f config.h; then
        : oops, they left it out of MANIFEST, probably, so do it anyway.
        . "$src/config_h.SH"
        fi
fi
EOS

: extract files and exit if asked to do so
case "$extractsh" in
true)
        case "$realsilent" in
        true) ;;
        *) exec 1>&4;;
        esac
        case "$config_sh" in
        '') config_sh='config.sh';;
        esac
        echo " "
        echo "Fetching answers from $config_sh..."
        cd ..
        . $config_sh
        test "$override" && . ./optdef.sh
        echo " "
        . UU/extract
        rm -rf UU
        echo "Extraction done."
        exit 0
        ;;
esac

: Eunice requires " " instead of "", can you believe it
echo " "
: Here we go...
echo "Beginning of configuration questions for $package."

trap 'echo " "; test -d ../UU && rm -rf X $rmlist; exit 1' 1 2 3 15

: first determine how to suppress newline on echo command
echo " "
echo "Checking echo to see how to suppress newlines..."
(echo "hi there\c" ; echo " ") >.echotmp
if $contains c .echotmp >/dev/null 2>&1 ; then
        echo "...using -n."
        n='-n'
        c=''
else
        cat <<'EOM'
...using \c
EOM
        n=''
        c='\c'
fi
echo $n "The star should be here-->$c"
echo '*'
rm -f .echotmp

: Now test for existence of everything in MANIFEST
echo " "
if test -f "$rsrc/MANIFEST"; then
        echo "First let's make sure your kit is complete.  Checking..." >&4
        awk '$1 !~ /PACK[A-Z]+/ {print $1}' "$rsrc/MANIFEST" | (split -l 50 2>/dev/null || split -50)
        rm -f missing
        tmppwd=`pwd`
        for filelist in x??; do
                (cd "$rsrc"; ls `cat "$tmppwd/$filelist"` >/dev/null 2>>"$tmppwd/missing")
        done
        if test -s missing; then
                cat missing >&4
                cat >&4 <<'EOM'

THIS PACKAGE SEEMS TO BE INCOMPLETE.

You have the option of continuing the configuration process, despite the
distinct possibility that your kit is damaged, by typing 'y'es.  If you
do, don't blame me if something goes wrong.  I advise you to type 'n'o
and contact the author (perlbug@perl.org).

EOM
                echo $n "Continue? [n] $c" >&4
                read ans
                case "$ans" in
                y*)
                        echo "Continuing..." >&4
                        rm -f missing
                        ;;
                *)
                        echo "ABORTING..." >&4
                        kill $$
                        ;;
                esac
        else
                echo "Looks good..."
        fi
else
        echo "There is no MANIFEST file.  I hope your kit is complete !"
fi
rm -f missing x??

echo " "
: Find the appropriate value for a newline for tr
if test -n "$DJGPP"; then
       trnl='\012'
fi
if test X"$trnl" = X; then
        case "`echo foo|tr '\n' x 2>/dev/null`" in
        foox) trnl='\n' ;;
        esac
fi
if test X"$trnl" = X; then
        case "`echo foo|tr '\012' x 2>/dev/null`" in
        foox) trnl='\012' ;;
        esac
fi
if test X"$trnl" = X; then
       case "`echo foo|tr '\r\n' xy 2>/dev/null`" in
       fooxy) trnl='\n\r' ;;
       esac
fi
if test X"$trnl" = X; then
        cat <<EOM >&2

$me: Fatal Error: cannot figure out how to translate newlines with 'tr'.

EOM
        exit 1
fi

: compute the number of columns on the terminal for proper question formatting
case "$COLUMNS" in
'') COLUMNS='80';;
esac

: set up the echo used in my read
myecho="case \"\$xxxm\" in
'') echo $n \"\$rp $c\" >&4;;
*) case \"\$rp\" in
        '') echo $n \"[\$xxxm] $c\";;
        *)
                if test \`echo \"\$rp [\$xxxm]  \" | wc -c\` -ge $COLUMNS; then
                        echo \"\$rp\" >&4
                        echo $n \"[\$xxxm] $c\" >&4
                else
                        echo $n \"\$rp [\$xxxm] $c\" >&4
                fi
                ;;
        esac;;
esac"

: now set up to do reads with possible shell escape and default assignment
cat <<EOSC >myread
$startsh
xxxm=\$dflt
$myecho
ans='!'
case "\$fastread" in
yes) case "\$dflt" in
        '') ;;
        *) ans='';
                case "\$silent-\$rp" in
                true-) ;;
                *) echo " " >&4;;
                esac;;
        esac;;
*) case "\$silent" in
        true) case "\$rp" in
                '') ans='';;
                esac;;
        esac;;
esac
while expr "X\$ans" : "X!" >/dev/null; do
        read answ
        set x \$xxxm
        shift
        aok=''; eval "ans=\\"\$answ\\"" && aok=y
        case  "\$answ" in
        "!")
                sh 1>&4
                echo " "
                $myecho
                ;;
        !*)
                set x \`expr "X\$ans" : "X!\(.*\)\$"\`
                shift
                sh 1>&4 -c "\$*"
                echo " "
                $myecho
                ;;
        "\$ans")
                case "\$ans" in
                \\&*)
                        set x \`expr "X\$ans" : "X&\(.*\)\$"\`
                        shift
                        case "\$1" in
                        -d)
                                fastread=yes
                                echo "(OK, I'll run with -d after this question.)" >&4
                                ;;
                        -*)
                                echo "*** Sorry, \$1 not supported yet." >&4
                                ;;
                        esac
                        $myecho
                        ans=!
                        ;;
                esac;;
        *)
                case "\$aok" in
                y)
                        echo "*** Substitution done -- please confirm."
                        xxxm="\$ans"
                        ans=\`echo $n "\$ans$c" | tr '$trnl' ' '\`
                        xxxm="\$ans"
                        ans=!
                        ;;
                *)
                        echo "*** Error -- try again."
                        ans=!
                        ;;
                esac
                $myecho
                ;;
        esac
        case "\$ans\$xxxm\$nostick" in
        '')
                ans=!
                $myecho
                ;;
        esac
done
case "\$ans" in
'') ans="\$xxxm";;
esac
EOSC

: create .config dir to save info across Configure sessions
test -d ../.config || mkdir ../.config
cat >../.config/README <<EOF
This directory created by Configure to save information that should
persist across sessions for $package.

You may safely delete it if you wish.
EOF

xversion=`awk '/define[         ]+PERL_VERSION/ {print $3}' $rsrc/patchlevel.h`
case "$usedevel" in
$define|true|[yY]*) ;;
*) case "$xversion" in
   *[13579])
        cat >&4 <<EOH
*** WHOA THERE!!! ***

    This is an UNSTABLE DEVELOPMENT release.
    The version of this $package distribution is $xversion, that is, odd,
    (as opposed to even) and that signifies a development release.
    If you want a maintenance release, you want an even-numbered version.

    Do ***NOT*** install this into production use.
    Data corruption and crashes are possible.

    It is most seriously suggested that you do not continue any further
    unless you want to help in developing and debugging Perl.

    If you *still* want to build perl, you can answer 'y' now,
    or pass -Dusedevel to Configure.

EOH
        rp='Do you really want to continue?'
        dflt='n'
        . ./myread
        case "$ans" in
        [yY]) echo >&4 "Okay, continuing."
              usedevel="$define" ;;
        *) echo >&4 "Okay, bye."
           exit 1
           ;;
        esac
        ;;
    esac
    ;;
esac
case "$usedevel" in
$define|true|[yY]*)
        case "$versiononly" in
        '') versiononly="$define" ;;
        esac
        case "$installusrbinperl" in
        '') installusrbinperl="$undef" ;;
        esac
        ;;
esac

: general instructions
needman=true
firsttime=true
user=`(logname) 2>/dev/null`
case "$user" in
'') user=`whoami 2>&1`;;
esac
if $contains "^$user\$" ../.config/instruct >/dev/null 2>&1; then
        firsttime=false
        echo " "
        rp='Would you like to see the instructions?'
        dflt=n
        . ./myread
        case "$ans" in
        [yY]*) ;;
        *) needman=false;;
        esac
fi
if $needman; then
        cat <<EOH

This installation shell script will examine your system and ask you questions
to determine how the perl5 package should be installed. If you get
stuck on a question, you may use a ! shell escape to start a subshell or
execute a command.  Many of the questions will have default answers in square
brackets; typing carriage return will give you the default.

On some of the questions which ask for file or directory names you are allowed
to use the ~name construct to specify the login directory belonging to "name",
even if you don't have a shell which knows about that.  Questions where this is
allowed will be marked "(~name ok)".

EOH
        rp=''
        dflt='Type carriage return to continue'
        . ./myread
        cat <<'EOH'

The prompter used in this script allows you to use shell variables and
backticks in your answers.  You may use $1, $2, etc...  to refer to the words
in the default answer, as if the default line was a set of arguments given to a
script shell.  This means you may also use $* to repeat the whole default line,
so you do not have to re-type everything to add something to the default.

Everytime there is a substitution, you will have to confirm.  If there is an
error (e.g. an unmatched backtick), the default answer will remain unchanged
and you will be prompted again.

If you are in a hurry, you may run 'Configure -d'.  This will bypass nearly all
the questions and use the computed defaults (or the previous answers if there
was already a config.sh file). Type 'Configure -h' for a list of options.
You may also start interactively and then answer '& -d' at any prompt to turn
on the non-interactive behaviour for the remainder of the execution.

EOH
        . ./myread
        cat <<EOH

Much effort has been expended to ensure that this shell script will run on any
Unix system.  If despite that it blows up on yours, your best bet is to edit
Configure and run it again.  If you can't run Configure for some reason,
you'll have to generate a config.sh file by hand.  Whatever problems you
have, let me (perlbug@perl.org) know how I blew it.

This installation script affects things in two ways:

1) it may do direct variable substitutions on some of the files included
   in this kit.
2) it builds a config.h file for inclusion in C programs.  You may edit
   any of these files as the need arises after running this script.

If you make a mistake on a question, there is no easy way to back up to it
currently.  The easiest thing to do is to edit config.sh and rerun all the SH
files.  Configure will offer to let you do this before it runs the SH files.

EOH
        dflt='Type carriage return to continue'
        . ./myread
        case "$firsttime" in
        true) echo $user >>../.config/instruct;;
        esac
fi

: find out where common programs are
echo " "
echo "Locating common programs..." >&4
cat <<EOSC >loc
$startsh
case \$# in
0) exit 1;;
esac
thing=\$1
shift
dflt=\$1
shift
for dir in \$*; do
        case "\$thing" in
        .)
        if test -d \$dir/\$thing; then
                echo \$dir
                exit 0
        fi
        ;;
        *)
        for thisthing in \$dir/\$thing; do
                : just loop through to pick last item
        done
        if test -f \$thisthing; then
                echo \$thisthing
                exit 0
        elif test "X$_exe" != X -a -f \$thisthing$_exe; then
                echo \$thisthing
                exit 0
        elif test -f \$dir/\$thing.exe; then
                if test -n "$DJGPP"; then
                        echo \$dir/\$thing.exe
                elif test "$eunicefix" != ":"; then
                        : on Eunice apparently
                        echo \$dir/\$thing
                        exit 0
                fi
                exit 0
        fi
        ;;
        esac
done
echo \$dflt
exit 1
EOSC
chmod +x loc
$eunicefix loc
loclist="
awk
cat
chmod
comm
cp
echo
expr
grep
ls
mkdir
rm
sed
sort
touch
tr
uniq
"
trylist="
Mcc
ar
bison
byacc
cpp
csh
date
egrep
gmake
gzip
less
ln
make
more
nm
nroff
pg
test
uname
zip
"
pth=`echo $PATH | sed -e "s/$p_/ /g"`
pth="$pth /lib /usr/lib"
for file in $loclist; do
        eval xxx=\$$file
        case "$xxx" in
        /*|?:[\\/]*)
                if test -f "$xxx"; then
                        : ok
                else
                        echo "WARNING: no $xxx -- ignoring your setting for $file." >&4
                        xxx=`./loc $file $file $pth`
                fi
                ;;
        '') xxx=`./loc $file $file $pth`;;
        *) xxx=`./loc $xxx $xxx $pth`;;
        esac
        eval $file=$xxx$_exe
        eval _$file=$xxx
        case "$xxx" in
        /*)
                echo $file is in $xxx.
                ;;
        ?:[\\/]*)
                echo $file is in $xxx.
                ;;
        *)
                echo "I don't know where '$file' is, and my life depends on it." >&4
                echo "Go find a public domain implementation or fix your PATH setting!" >&4
                exit 1
                ;;
        esac
done
echo " "
echo "Don't worry if any of the following aren't found..."
say=offhand
for file in $trylist; do
        eval xxx=\$$file
        case "$xxx" in
        /*|?:[\\/]*)
                if test -f "$xxx"; then
                        : ok
                else
                        echo "WARNING: no $xxx -- ignoring your setting for $file." >&4
                        xxx=`./loc $file $file $pth`
                fi
                ;;
        '') xxx=`./loc $file $file $pth`;;
        *) xxx=`./loc $xxx $xxx $pth`;;
        esac
        eval $file=$xxx$_exe
        eval _$file=$xxx
        case "$xxx" in
        /*)
                echo $file is in $xxx.
                ;;
        ?:[\\/]*)
                echo $file is in $xxx.
                ;;
        *)
                echo "I don't see $file out there, $say."
                say=either
                ;;
        esac
done
case "$egrep" in
egrep)
        echo "Substituting grep for egrep."
        egrep=$grep
        _egrep=$grep
        ;;
esac
case "$ln" in
ln)
        echo "Substituting cp for ln."
        ln=$cp
        _ln=$cp
        ;;
esac
case "$make" in
make)
        case "$gmake" in
        gmake)
        echo "I can't find make or gmake, and my life depends on it." >&4
        echo "Go find a public domain implementation or fix your PATH setting!" >&4
        exit 1
        ;;
        esac
        ;;
esac
case "$gmake" in
gmake)  ;;
*)      # We can't have osname yet.
        if test -f "/system/gnu_library/bin/ar.pm"; then # Stratus VOS
                # Assume that gmake, if found, is definitely GNU make
                # and prefer it over the system make.
                echo "Substituting gmake for make."
                make=$gmake
                _make=$gmake
        fi
        ;;
esac
case "$test" in
test)
        echo "Hopefully test is built into your sh."
        ;;
*)
        if `sh -c "PATH= test true" >/dev/null 2>&1`; then
                echo "Using the test built into your sh."
                test=test
                _test=test
        fi
        ;;
esac
case "$echo" in
echo)
        echo "Hopefully echo is built into your sh."
        ;;
'') ;;
*)
        echo " "
echo "Checking compatibility between $echo and builtin echo (if any)..." >&4
        $echo $n "hi there$c" >foo1
        echo $n "hi there$c" >foo2
        if cmp foo1 foo2 >/dev/null 2>&1; then
                echo "They are compatible.  In fact, they may be identical."
        else
                case "$n" in
                '-n') n='' c='\c';;
                *) n='-n' c='';;
                esac
                cat <<FOO
They are not compatible!  You are probably running ksh on a non-USG system.
I'll have to use $echo instead of the builtin, since Bourne shell doesn't
have echo built in and we may have to run some Bourne shell scripts.  That
means I'll have to use '$n$c' to suppress newlines now.  Life is ridiculous.

FOO
                $echo $n "The star should be here-->$c"
                $echo "*"
        fi
        $rm -f foo1 foo2
        ;;
esac

cat <<EOS >trygcc
$startsh
EOS
cat <<'EOSC' >>trygcc
case "$cc" in
'') ;;
*)  $rm -f try try.*
    $cat >try.c <<EOM
int main(int argc, char *argv[]) {
  return 0;
}
EOM
    if $cc -o try $ccflags $ldflags try.c; then
       :
    else
        echo "Uh-oh, the C compiler '$cc' doesn't seem to be working." >&4
        despair=yes
        trygcc=yes
        case "$cc" in
        *gcc*) trygcc=no ;;
        esac
        case "`$cc -v -c try.c 2>&1`" in
        *gcc*) trygcc=no ;;
        esac
        if $test X"$trygcc" = Xyes; then
            if gcc -o try -c try.c; then
                echo " "
                echo "You seem to have a working gcc, though." >&4
                rp="Would you like to use it?"
                dflt=y
                if $test -f myread; then
                    . ./myread
                else
                    if $test -f UU/myread; then
                        . ./UU/myread
                    else
                        echo "Cannot find myread, sorry.  Aborting." >&2
                        exit 1
                    fi
                fi
                case "$ans" in
                [yY]*) cc=gcc; ccname=gcc; ccflags=''; despair=no;
                       if $test -f usethreads.cbu; then
                           $cat >&4 <<EOM

*** However, any setting of the C compiler flags (e.g. for thread support)
*** has been lost.  It may be necessary to pass -Dcc=gcc to Configure
*** (together with e.g. -Dusethreads).

EOM
                       fi;;
                esac
            fi
        fi
    fi
    $rm -f try try.*
    ;;
esac
EOSC

cat <<EOS >checkcc
$startsh
EOS
cat <<'EOSC' >>checkcc
case "$cc" in
'') ;;
*)  $rm -f try try.*
    $cat >try.c <<EOM
int main(int argc, char *argv[]) {
  return 0;
}
EOM
    if $cc -o try $ccflags $ldflags try.c; then
       :
    else
        if $test X"$despair" = Xyes; then
           echo "Uh-oh, the C compiler '$cc' doesn't seem to be working." >&4
        fi
        $cat >&4 <<EOM
You need to find a working C compiler.
Either (purchase and) install the C compiler supplied by your OS vendor,
or for a free C compiler try http://gcc.gnu.org/
I cannot continue any further, aborting.
EOM
        exit 1
    fi
    $rm -f try try.*
    ;;
esac
EOSC

: determine whether symbolic links are supported
echo " "
$touch blurfl
if $ln -s blurfl sym > /dev/null 2>&1 ; then
        echo "Symbolic links are supported." >&4
        lns="$ln -s"
else
        echo "Symbolic links are NOT supported." >&4
        lns="$ln"
fi
$rm -f blurfl sym

: determine whether symbolic links are supported
echo " "
case "$lns" in
*"ln"*" -s")
        echo "Checking how to test for symbolic links..." >&4
        $lns blurfl sym
        if $test "X$issymlink" = X; then
                case "$newsh" in
                '') sh     -c "PATH= test -h sym" >/dev/null 2>&1 ;;
                *)  $newsh -c "PATH= test -h sym" >/dev/null 2>&1 ;;
                esac
                if test $? = 0; then
                        issymlink="test -h"
                else
                        echo "Your builtin 'test -h' may be broken." >&4
                        case "$test" in
                        /*)     ;;
                        *)      pth=`echo $PATH | sed -e "s/$p_/ /g"`
                                for p in $pth
                                do
                                        if test -f "$p/$test"; then
                                                test="$p/$test"
                                                break
                                        fi
                                done
                                ;;
                        esac
                        case "$test" in
                        /*)
                                echo "Trying external '$test -h'." >&4
                                issymlink="$test -h"
                                if $test ! -h sym >/dev/null 2>&1; then
                                        echo "External '$test -h' is broken, too." >&4
                                        issymlink=''
                                fi
                                ;;
                        *)      issymlink='' ;;
                        esac
                fi
        fi
        if $test "X$issymlink" = X; then
                if $test -L sym 2>/dev/null; then
                        issymlink="$test -L"
                        echo "The builtin '$test -L' worked." >&4
                fi
        fi
        if $test "X$issymlink" != X; then
                echo "You can test for symbolic links with '$issymlink'." >&4
        else
                echo "I do not know how you can test for symbolic links." >&4
        fi
        $rm -f blurfl sym
        ;;
*)      echo "No symbolic links, so not testing for their testing..." >&4
        ;;
esac
echo " "


case "$mksymlinks" in
$define|true|[yY]*)
        case "$src" in
        ''|'.') echo "Cannot create symlinks in the original directory." >&4
                exit 1
                ;;
        *)      case "$lns:$issymlink" in
                *"ln"*" -s:"*"test -"?)
                        echo "Creating the symbolic links..." >&4
                        echo "(First creating the subdirectories...)" >&4
                        cd ..
                        awk '{print $1}' $src/MANIFEST | grep / | sed 's:/[^/]*$::' | sort -u | while true; do
                                read directory
                                test -z "$directory" && break
                                mkdir -p $directory
                        done
                        # Sanity check 1.
                        if test ! -d t/base; then
                                echo "Failed to create the subdirectories.  Aborting." >&4
                                exit 1
                        fi
                        echo "(Then creating the symlinks...)" >&4
                        awk '{print $1}' $src/MANIFEST | while true; do
                                read filename
                                test -z "$filename" && break
                                if test -f $filename; then
                                        if $issymlink $filename; then
                                                rm -f $filename
                                        fi
                                fi
                                if test -f $filename; then
                                        echo "$filename already exists, not symlinking."
                                else
                                        ln -s $src/$filename $filename
                                fi
                        done
                        # Sanity check 2.
                        if test ! -f t/base/lex.t; then
                                echo "Failed to create the symlinks (t/base/lex.t missing).  Aborting." >&4
                                exit 1
                        fi
                        cd UU
                        ;;
                *)      echo "(I cannot figure out how to do symbolic links, ignoring mksymlinks)." >&4
                        ;;
                esac
                ;;
        esac
        ;;
esac


case "$usecrosscompile" in
$define|true|[yY]*)
        $echo "Cross-compiling..."
        croak=''
        case "$cc" in
        *-*-gcc) # A cross-compiling gcc, probably.
            targetarch=`$echo $cc|$sed 's/-gcc$//'`
            ar=$targetarch-ar
            # leave out ld, choosing it is more complex
            nm=$targetarch-nm
            ranlib=$targetarch-ranlib
            $echo 'extern int foo;' > try.c
            set X `$cc -v -E try.c 2>&1 | $awk '/^#include </,/^End of search /'|$grep '/include'`
            shift
            if $test $# -gt 0; then
                incpth="$incpth $*"
                incpth="`$echo $incpth|$sed 's/^ //'`"
                echo "Guessing incpth '$incpth'." >&4
                for i in $*; do
                    j="`$echo $i|$sed 's,/include$,/lib,'`"
                    if $test -d $j; then
                        libpth="$libpth $j"
                    fi
                done
                libpth="`$echo $libpth|$sed 's/^ //'`"
                echo "Guessing libpth '$libpth'." >&4
            fi
            $rm -f try.c
            ;;
        esac
        case "$targetarch" in
        '') echo "Targetarch not defined." >&4; croak=y ;;
        *)  echo "Using targetarch $targetarch." >&4 ;;
        esac
        case "$incpth" in
        '') echo "Incpth not defined." >&4; croak=y ;;
        *)  echo "Using incpth '$incpth'." >&4 ;;
        esac
        case "$libpth" in
        '') echo "Libpth not defined." >&4; croak=y ;;
        *)  echo "Using libpth '$libpth'." >&4 ;;
        esac
        case "$usrinc" in
        '') for i in $incpth; do
                if $test -f $i/errno.h -a -f $i/stdio.h -a -f $i/time.h; then
                    usrinc=$i
                    echo "Guessing usrinc $usrinc." >&4
                    break
                fi
            done
            case "$usrinc" in
            '') echo "Usrinc not defined." >&4; croak=y ;;
            esac
            ;;
        *)  echo "Using usrinc $usrinc." >&4 ;;
        esac
        case "$targethost" in
        '') echo "Targethost not defined." >&4; croak=y ;;
        *)  echo "Using targethost $targethost." >&4
        esac
        locincpth=' '
        loclibpth=' '
        case "$croak" in
        y) echo "Cannot continue, aborting." >&4; exit 1 ;;
        esac
        case "$src" in
        /*) run=$src/Cross/run
            targetmkdir=$src/Cross/mkdir
            to=$src/Cross/to
            from=$src/Cross/from
            ;;
        *)  pwd=`$test -f ../Configure & cd ..; pwd`
            run=$pwd/Cross/run
            targetmkdir=$pwd/Cross/mkdir
            to=$pwd/Cross/to
            from=$pwd/Cross/from
            ;;
        esac
        case "$targetrun" in
        '') targetrun=ssh ;;
        esac
        case "$targetto" in
        '') targetto=scp ;;
        esac
        case "$targetfrom" in
        '') targetfrom=scp ;;
        esac
        run=$run-$targetrun
        to=$to-$targetto
        from=$from-$targetfrom
        case "$targetdir" in
        '')  targetdir=/tmp
             echo "Guessing targetdir $targetdir." >&4
             ;;
        esac
        case "$targetuser" in
        '')  targetuser=root
             echo "Guessing targetuser $targetuser." >&4
             ;;
        esac
        case "$targetfrom" in
        scp)    q=-q ;;
        *)      q='' ;;
        esac
        case "$targetrun" in
        ssh|rsh)
            cat >$run <<EOF
#!/bin/sh
case "\$1" in
-cwd)
  shift
  cwd=\$1
  shift
  ;;
esac
case "\$cwd" in
'') cwd=$targetdir ;;
esac
exe=\$1
shift
if $test ! -f \$exe.xok; then
  $to \$exe
  $touch \$exe.xok
fi
$targetrun -l $targetuser $targethost "cd \$cwd && ./\$exe \$@"
EOF
            ;;
        *)  echo "Unknown targetrun '$targetrun'" >&4
            exit 1
            ;;
        esac
        case "$targetmkdir" in
        */Cross/mkdir)
            cat >$targetmkdir <<EOF
#!/bin/sh
$targetrun -l $targetuser $targethost "mkdir -p \$@"
EOF
            $chmod a+rx $targetmkdir
            ;;
        *)  echo "Unknown targetmkdir '$targetmkdir'" >&4
            exit 1
            ;;
        esac
        case "$targetto" in
        scp|rcp)
            cat >$to <<EOF
#!/bin/sh
for f in \$@
do
  case "\$f" in
  /*)
    $targetmkdir \`dirname \$f\`
    $targetto $q \$f $targetuser@$targethost:\$f            || exit 1
    ;;
  *)
    $targetmkdir $targetdir/\`dirname \$f\`
    $targetto $q \$f $targetuser@$targethost:$targetdir/\$f || exit 1
    ;;
  esac
done
exit 0
EOF
            ;;
        cp) cat >$to <<EOF
#!/bin/sh
for f in \$@
do
  case "\$f" in
  /*)
    $mkdir -p $targetdir/\`dirname \$f\`
    $cp \$f $targetdir/\$f || exit 1
    ;;
  *)
    $targetmkdir $targetdir/\`dirname \$f\`
    $cp \$f $targetdir/\$f || exit 1
    ;;
  esac
done
exit 0
EOF
            ;;
        *)  echo "Unknown targetto '$targetto'" >&4
            exit 1
            ;;
        esac
        case "$targetfrom" in
        scp|rcp)
          cat >$from <<EOF
#!/bin/sh
for f in \$@
do
  $rm -f \$f
  $targetfrom $q $targetuser@$targethost:$targetdir/\$f . || exit 1
done
exit 0
EOF
            ;;
        cp) cat >$from <<EOF
#!/bin/sh
for f in \$@
do
  $rm -f \$f
  cp $targetdir/\$f . || exit 1
done
exit 0
EOF
            ;;
        *)  echo "Unknown targetfrom '$targetfrom'" >&4
            exit 1
            ;;
        esac
        if $test ! -f $run; then
            echo "Target 'run' script '$run' not found." >&4
        else
            $chmod a+rx $run
        fi
        if $test ! -f $to; then
            echo "Target 'to' script '$to' not found." >&4
        else
            $chmod a+rx $to
        fi
        if $test ! -f $from; then
            echo "Target 'from' script '$from' not found." >&4
        else
            $chmod a+rx $from
        fi
        if $test ! -f $run -o ! -f $to -o ! -f $from; then
            exit 1
        fi
        cat >&4 <<EOF
Using '$run' for remote execution,
and '$from' and '$to'
for remote file transfer.
EOF
        ;;
*)      run=''
        to=:
        from=:
        usecrosscompile='undef'
        targetarch=''
        ;;
esac

: see whether [:lower:] and [:upper:] are supported character classes
echo " "
case "`echo AbyZ | $tr '[:lower:]' '[:upper:]' 2>/dev/null`" in
ABYZ)
        echo "Good, your tr supports [:lower:] and [:upper:] to convert case." >&4
        up='[:upper:]'
        low='[:lower:]'
        ;;
*)      # There is a discontinuity in EBCDIC between 'R' and 'S'
        # (0xd9 and 0xe2), therefore that is a nice testing point.
        if test "X$up" = X -o "X$low" = X; then
            case "`echo RS | $tr '[R-S]' '[r-s]' 2>/dev/null`" in
            rs) up='[A-Z]'
                low='[a-z]'
                ;;
            esac
        fi
        if test "X$up" = X -o "X$low" = X; then
            case "`echo RS | $tr R-S r-s 2>/dev/null`" in
            rs) up='A-Z'
                low='a-z'
                ;;
            esac
        fi
        if test "X$up" = X -o "X$low" = X; then
            case "`echo RS | od -x 2>/dev/null`" in
            *D9E2*|*d9e2*)
                echo "Hey, this might be EBCDIC." >&4
                if test "X$up" = X -o "X$low" = X; then
                    case "`echo RS | $tr '[A-IJ-RS-Z]' '[a-ij-rs-z]' 2>/dev/null`" in
                    rs) up='[A-IJ-RS-Z]'
                        low='[a-ij-rs-z]'
                        ;;
                    esac
                fi
                if test "X$up" = X -o "X$low" = X; then
                    case "`echo RS | $tr A-IJ-RS-Z a-ij-rs-z 2>/dev/null`" in
                    rs) up='A-IJ-RS-Z'
                        low='a-ij-rs-z'
                        ;;
                    esac
                fi
                ;;
            esac
        fi
esac
case "`echo RS | $tr \"$up\" \"$low\" 2>/dev/null`" in
rs)
    echo "Using $up and $low to convert case." >&4
    ;;
*)
    echo "I don't know how to translate letters from upper to lower case." >&4
    echo "Your tr is not acting any way I know of." >&4
    exit 1
    ;;
esac
: set up the translation script tr, must be called with ./tr of course
cat >tr <<EOSC
$startsh
case "\$1\$2" in
'[A-Z][a-z]') exec $tr '$up' '$low';;
'[a-z][A-Z]') exec $tr '$low' '$up';;
esac
exec $tr "\$@"
EOSC
chmod +x tr
$eunicefix tr

: Try to determine whether config.sh was made on this system
case "$config_sh" in
'')
myuname=`$uname -a 2>/dev/null`
$test -z "$myuname" && myuname=`hostname 2>/dev/null`
# tr '[A-Z]' '[a-z]' would not work in EBCDIC
# because the A-Z/a-z are not consecutive.
myuname=`echo $myuname | $sed -e 's/^[^=]*=//' -e 's/\///g' | \
        ./tr '[A-Z]' '[a-z]' | $tr $trnl ' '`
newmyuname="$myuname"
dflt=n
case "$knowitall" in
'')
        if test -f ../config.sh; then
                if $contains myuname= ../config.sh >/dev/null 2>&1; then
                        eval "`grep myuname= ../config.sh`"
                fi
                if test "X$myuname" = "X$newmyuname"; then
                        dflt=y
                fi
        fi
        ;;
*) dflt=y;;
esac

: Get old answers from old config file if Configure was run on the
: same system, otherwise use the hints.
hint=default
cd ..
if test -f config.sh; then
        echo " "
        rp="I see a config.sh file.  Shall I use it to set the defaults?"
        . UU/myread
        case "$ans" in
        n*|N*) echo "OK, I'll ignore it."
                mv config.sh config.sh.old
                myuname="$newmyuname"
                ;;
        *)  echo "Fetching default answers from your old config.sh file..." >&4
                tmp_n="$n"
                tmp_c="$c"
                tmp_sh="$sh"
                . ./config.sh
                cp config.sh UU
                n="$tmp_n"
                c="$tmp_c"
                : Older versions did not always set $sh.  Catch re-use of such
                : an old config.sh.
                case "$sh" in
                '') sh="$tmp_sh" ;;
                esac
                hint=previous
                ;;
        esac
fi
. ./UU/checkcc
if test ! -f config.sh; then
        $cat <<EOM

First time through, eh?  I have some defaults handy for some systems
that need some extra help getting the Configure answers right:

EOM
        (cd $src/hints; ls -C *.sh) | $sed 's/\.sh/   /g' >&4
        dflt=''
        : Half the following guesses are probably wrong... If you have better
        : tests or hints, please send them to perlbug@perl.org
        : The metaconfig authors would also appreciate a copy...
        $test -f /irix && osname=irix
        $test -f /xenix && osname=sco_xenix
        $test -f /dynix && osname=dynix
        $test -f /dnix && osname=dnix
        $test -f /lynx.os && osname=lynxos
        $test -f /unicos && osname=unicos && osvers=`$uname -r`
        $test -f /unicosmk && osname=unicosmk && osvers=`$uname -r`
        $test -f /unicosmk.ar && osname=unicosmk && osvers=`$uname -r`
        $test -f /bin/mips && /bin/mips && osname=mips
        $test -d /NextApps && set X `hostinfo | grep 'NeXT Mach.*:' | \
                $sed -e 's/://' -e 's/\./_/'` && osname=next && osvers=$4
        $test -d /usr/apollo/bin && osname=apollo
        $test -f /etc/saf/_sactab && osname=svr4
        $test -d /usr/include/minix && osname=minix
        $test -f /system/gnu_library/bin/ar.pm && osname=vos
        if $test -d /MachTen -o -d /MachTen_Folder; then
                osname=machten
                if $test -x /sbin/version; then
                        osvers=`/sbin/version | $awk '{print $2}' |
                        $sed -e 's/[A-Za-z]$//'`
                elif $test -x /usr/etc/version; then
                        osvers=`/usr/etc/version | $awk '{print $2}' |
                        $sed -e 's/[A-Za-z]$//'`
                else
                        osvers="$2.$3"
                fi
        fi

        $test -f /sys/posix.dll &&
                $test -f /usr/bin/what &&
                set X `/usr/bin/what /sys/posix.dll` &&
                $test "$3" = UWIN &&
                osname=uwin &&
                osvers="$5"

        if $test -f $uname; then
                set X $myuname
                shift

                case "$5" in
                fps*) osname=fps ;;
                mips*)
                        case "$4" in
                        umips) osname=umips ;;
                        *) osname=mips ;;
                        esac;;
                [23]100) osname=mips ;;
                next*) osname=next ;;
                i386*)
                        tmp=`/bin/uname -X 2>/dev/null|awk '/3\.2v[45]/{ print $(NF) }'`
                        if $test "$tmp" != "" -a "$3" = "3.2" -a -f '/etc/systemid'; then
                                osname='sco'
                                osvers=$tmp
                        elif $test -f /etc/kconfig; then
                                osname=isc
                                if test "$lns" = "$ln -s"; then
                                        osvers=4
                                elif $contains _SYSV3 /usr/include/stdio.h > /dev/null 2>&1 ; then
                                        osvers=3
                                elif $contains _POSIX_SOURCE /usr/include/stdio.h > /dev/null 2>&1 ; then
                                        osvers=2
                                fi
                        fi
                        tmp=''
                        ;;
                pc*)
                        if test -n "$DJGPP"; then
                                osname=dos
                                osvers=djgpp
                        fi
                        ;;
                esac

                case "$1" in
                aix) osname=aix
                        tmp=`( (oslevel) 2>/dev/null || echo "not found") 2>&1`
                        case "$tmp" in
                        'not found') osvers="$4"."$3" ;;
                        '<3240'|'<>3240') osvers=3.2.0 ;;
                        '=3240'|'>3240'|'<3250'|'<>3250') osvers=3.2.4 ;;
                        '=3250'|'>3250') osvers=3.2.5 ;;
                        *) osvers=$tmp;;
                        esac
                        ;;
                bsd386) osname=bsd386
                        osvers=`$uname -r`
                        ;;
                cygwin*) osname=cygwin
                        osvers="$3"
                        ;;
                *dc.osx) osname=dcosx
                        osvers="$3"
                        ;;
                dnix) osname=dnix
                        osvers="$3"
                        ;;
                domainos) osname=apollo
                        osvers="$3"
                        ;;
                dgux)   osname=dgux
                        osvers="$3"
                        ;;
                dynixptx*) osname=dynixptx
                        osvers=`echo "$4"|sed 's/^v//'`
                        ;;
                freebsd) osname=freebsd
                        osvers="$3" ;;
                genix)  osname=genix ;;
                gnu)    osname=gnu
                        osvers="$3" ;;
                hp*)    osname=hpux
                        osvers=`echo "$3" | $sed 's,.*\.\([0-9]*\.[0-9]*\),\1,'`
                        ;;
                irix*)  osname=irix
                        case "$3" in
                        4*) osvers=4 ;;
                        5*) osvers=5 ;;
                        *)      osvers="$3" ;;
                        esac
                        ;;
                linux)  osname=linux
                        case "$3" in
                        *)      osvers="$3" ;;
                        esac
                        ;;
                MiNT)   osname=mint
                        ;;
                netbsd*) osname=netbsd
                        osvers="$3"
                        ;;
                news-os) osvers="$3"
                        case "$3" in
                        4*) osname=newsos4 ;;
                        *) osname=newsos ;;
                        esac
                        ;;
                next*) osname=next ;;
                nonstop-ux) osname=nonstopux ;;
                openbsd) osname=openbsd
                        osvers="$3"
                        ;;
                os2)    osname=os2
                        osvers="$4"
                        ;;
                POSIX-BC | posix-bc ) osname=posix-bc
                        osvers="$3"
                        ;;
                powerux | power_ux | powermax_os | powermaxos | \
                powerunix | power_unix) osname=powerux
                        osvers="$3"
                        ;;
                qnx) osname=qnx
                        osvers="$4"
                        ;;
                solaris) osname=solaris
                        case "$3" in
                        5*) osvers=`echo $3 | $sed 's/^5/2/g'` ;;
                        *)      osvers="$3" ;;
                        esac
                        ;;
                sunos) osname=sunos
                        case "$3" in
                        5*) osname=solaris
                                osvers=`echo $3 | $sed 's/^5/2/g'` ;;
                        *)      osvers="$3" ;;
                        esac
                        ;;
                titanos) osname=titanos
                        case "$3" in
                        1*) osvers=1 ;;
                        2*) osvers=2 ;;
                        3*) osvers=3 ;;
                        4*) osvers=4 ;;
                        *)      osvers="$3" ;;
                        esac
                        ;;
                ultrix) osname=ultrix
                        osvers="$3"
                        ;;
                osf1|mls+)      case "$5" in
                                alpha)
                                        osname=dec_osf
                                        osvers=`sizer -v | awk -FUNIX '{print $2}' | awk '{print $1}' |  tr '[A-Z]' '[a-z]' | sed 's/^[xvt]//'`
                                        case "$osvers" in
                                        [1-9].[0-9]*) ;;
                                        *) osvers=`echo "$3" | sed 's/^[xvt]//'` ;;
                                        esac
                                        ;;
                        hp*)    osname=hp_osf1  ;;
                        mips)   osname=mips_osf1 ;;
                        esac
                        ;;
                # UnixWare 7.1.2 is known as Open UNIX 8
                openunix|unixware) osname=svr5
                        osvers="$4"
                        ;;
                uts)    osname=uts
                        osvers="$3"
                        ;;
                vos) osvers="$3"
                        ;;
                $2) case "$osname" in
                        *isc*) ;;
                        *freebsd*) ;;
                        svr*)
                                : svr4.x or possibly later
                                case "svr$3" in
                                ${osname}*)
                                        osname=svr$3
                                        osvers=$4
                                        ;;
                                esac
                                case "$osname" in
                                svr4.0)
                                        : Check for ESIX
                                        if test -f /stand/boot ; then
                                                eval `grep '^INITPROG=[a-z/0-9]*$' /stand/boot`
                                                if test -n "$INITPROG" -a -f "$INITPROG"; then
                        isesix=`strings -a $INITPROG|grep 'ESIX SYSTEM V/386 Release 4.0'`
                                                        if test -n "$isesix"; then
                                                                osname=esix4
                                                        fi
                                                fi
                                        fi
                                        ;;
                                esac
                                ;;
                        *)      if test -f /etc/systemid; then
                                        osname=sco
                                        set `echo $3 | $sed 's/\./ /g'` $4
                                        if $test -f $src/hints/sco_$1_$2_$3.sh; then
                                                osvers=$1.$2.$3
                                        elif $test -f $src/hints/sco_$1_$2.sh; then
                                                osvers=$1.$2
                                        elif $test -f $src/hints/sco_$1.sh; then
                                                osvers=$1
                                        fi
                                else
                                        case "$osname" in
                                        '') : Still unknown.  Probably a generic Sys V.
                                                osname="sysv"
                                                osvers="$3"
                                                ;;
                                        esac
                                fi
                                ;;
                        esac
                        ;;
                *)      case "$osname" in
                        '') : Still unknown.  Probably a generic BSD.
                                osname="$1"
                                osvers="$3"
                                ;;
                        esac
                        ;;
                esac
        else
                if test -f /vmunix -a -f $src/hints/news_os.sh; then
                        (what /vmunix | UU/tr '[A-Z]' '[a-z]') > UU/kernel.what 2>&1
                        if $contains news-os UU/kernel.what >/dev/null 2>&1; then
                                osname=news_os
                        fi
                        $rm -f UU/kernel.what
                elif test -d c:/. -o -n "$is_os2" ; then
                        set X $myuname
                        osname=os2
                        osvers="$5"
                fi
        fi

        case "$targetarch" in
        '') ;;
        *)  hostarch=$osname
            osname=`echo $targetarch|sed 's,^[^-]*-,,'`
            osvers=''
            ;;
        esac

        : Now look for a hint file osname_osvers, unless one has been
        : specified already.
        case "$hintfile" in
        ''|' ')
                file=`echo "${osname}_${osvers}" | $sed -e 's%\.%_%g' -e 's%_$%%'`
                : Also try without trailing minor version numbers.
                xfile=`echo $file | $sed -e 's%_[^_]*$%%'`
                xxfile=`echo $xfile | $sed -e 's%_[^_]*$%%'`
                xxxfile=`echo $xxfile | $sed -e 's%_[^_]*$%%'`
                xxxxfile=`echo $xxxfile | $sed -e 's%_[^_]*$%%'`
                case "$file" in
                '') dflt=none ;;
                *)  case "$osvers" in
                        '') dflt=$file
                                ;;
                        *)  if $test -f $src/hints/$file.sh ; then
                                        dflt=$file
                                elif $test -f $src/hints/$xfile.sh ; then
                                        dflt=$xfile
                                elif $test -f $src/hints/$xxfile.sh ; then
                                        dflt=$xxfile
                                elif $test -f $src/hints/$xxxfile.sh ; then
                                        dflt=$xxxfile
                                elif $test -f $src/hints/$xxxxfile.sh ; then
                                        dflt=$xxxxfile
                                elif $test -f "$src/hints/${osname}.sh" ; then
                                        dflt="${osname}"
                                else
                                        dflt=none
                                fi
                                ;;
                        esac
                        ;;
                esac
                if $test -f Policy.sh ; then
                        case "$dflt" in
                        *Policy*) ;;
                        none) dflt="Policy" ;;
                        *) dflt="Policy $dflt" ;;
                        esac
                fi
                ;;
        *)
                dflt=`echo $hintfile | $sed 's/\.sh$//'`
                ;;
        esac

        if $test -f Policy.sh ; then
                $cat <<EOM

There's also a Policy hint file available, which should make the
site-specific (policy) questions easier to answer.
EOM

        fi

        $cat <<EOM

You may give one or more space-separated answers, or "none" if appropriate.
A well-behaved OS will have no hints, so answering "none" or just "Policy"
is a good thing.  DO NOT give a wrong version or a wrong OS.

EOM

        rp="Which of these apply, if any?"
        . UU/myread
        tans=$ans
        for file in $tans; do
                if $test X$file = XPolicy -a -f Policy.sh; then
                        . Policy.sh
                        $cat Policy.sh >> UU/config.sh
                elif $test -f $src/hints/$file.sh; then
                        . $src/hints/$file.sh
                        $cat $src/hints/$file.sh >> UU/config.sh
                elif $test X"$tans" = X -o X"$tans" = Xnone ; then
                        : nothing
                else
                        : Give one chance to correct a possible typo.
                        echo "$file.sh does not exist"
                        dflt=$file
                        rp="hint to use instead?"
                        . UU/myread
                        for file in $ans; do
                                if $test -f "$src/hints/$file.sh"; then
                                        . $src/hints/$file.sh
                                        $cat $src/hints/$file.sh >> UU/config.sh
                                elif $test X$ans = X -o X$ans = Xnone ; then
                                        : nothing
                                else
                                        echo "$file.sh does not exist -- ignored."
                                fi
                        done
                fi
        done

        hint=recommended
        : Remember our hint file for later.
        if $test -f "$src/hints/$file.sh" ; then
                hintfile="$file"
        else
                hintfile=''
        fi
fi
cd UU
;;
*)
        echo " "
        echo "Fetching default answers from $config_sh..." >&4
        tmp_n="$n"
        tmp_c="$c"
        cd ..
        cp $config_sh config.sh 2>/dev/null
        chmod +w config.sh
        . ./config.sh
        cd UU
        cp ../config.sh .
        n="$tmp_n"
        c="$tmp_c"
        hint=previous
        ;;
esac
test "$override" && . ./optdef.sh

: Restore computed paths
for file in $loclist $trylist; do
        eval $file="\$_$file"
done

cat << EOM

Configure uses the operating system name and version to set some defaults.
The default value is probably right if the name rings a bell. Otherwise,
since spelling matters for me, either accept the default or answer "none"
to leave it blank.

EOM
case "$osname" in
        ''|' ')
                case "$hintfile" in
                ''|' '|none) dflt=none ;;
                *)  dflt=`echo $hintfile | $sed -e 's/\.sh$//' -e 's/_.*$//'` ;;
                esac
                ;;
        *) dflt="$osname" ;;
esac
rp="Operating system name?"
. ./myread
case "$ans" in
none)  osname='' ;;
*) osname=`echo "$ans" | $sed -e 's/[   ][      ]*/_/g' | ./tr '[A-Z]' '[a-z]'`;;
esac
echo " "
case "$osvers" in
        ''|' ')
                case "$hintfile" in
                ''|' '|none) dflt=none ;;
                *)      dflt=`echo $hintfile | $sed -e 's/\.sh$//' -e 's/^[^_]*//'`
                        dflt=`echo $dflt | $sed -e 's/^_//' -e 's/_/./g'`
                        case "$dflt" in
                        ''|' ') dflt=none ;;
                        esac
                        ;;
                esac
                ;;
        *) dflt="$osvers" ;;
esac
rp="Operating system version?"
. ./myread
case "$ans" in
none)  osvers='' ;;
*) osvers="$ans" ;;
esac


. ./posthint.sh

: who configured the system
cf_time=`LC_ALL=C; LANGUAGE=C; export LC_ALL; export LANGUAGE; $date 2>&1`
case "$cf_by" in
"")
        cf_by=`(logname) 2>/dev/null`
        case "$cf_by" in
        "")
                cf_by=`(whoami) 2>/dev/null`
                case "$cf_by" in
                "") cf_by=unknown ;;
                esac ;;
        esac ;;
esac

: set up the script used to warn in case of inconsistency
cat <<EOS >whoa
$startsh
EOS
cat <<'EOSC' >>whoa
dflt=y
echo " "
echo "*** WHOA THERE!!! ***" >&4
echo "    The $hint value for \$$var on this machine was \"$was\"!" >&4
rp="    Keep the $hint value?"
. ./myread
case "$ans" in
y) td=$was; tu=$was;;
esac
EOSC

: function used to set $1 to $val
setvar='var=$1; eval "was=\$$1"; td=$define; tu=$undef;
case "$val$was" in
$define$undef) . ./whoa; eval "$var=\$td";;
$undef$define) . ./whoa; eval "$var=\$tu";;
*) eval "$var=$val";;
esac'

case "$usesocks" in
$define|true|[yY]*)     dflt='y';;
*) dflt='n';;
esac
cat <<EOM

Perl can be built to use the SOCKS proxy protocol library.  To do so,
Configure must be run with -Dusesocks.  If you use SOCKS you also need
to use the PerlIO abstraction layer, this will be implicitly selected.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
rp='Build Perl for SOCKS?'
. ./myread
case "$ans" in
y|Y)    val="$define" ;;
*)      val="$undef" ;;
esac
set usesocks
eval $setvar

case "$usesocks" in
$define|true|[yY]*) useperlio="$define";;
esac

case "$useperlio" in
$define|true|[yY]*|'')  dflt='y';;
*) dflt='n';;
esac
cat <<EOM

Previous version of $package used the standard IO mechanisms as
defined in <stdio.h>.  Versions 5.003_02 and later of $package allow
alternate IO mechanisms via the PerlIO abstraction layer, but the
stdio mechanism is still available if needed.  The abstraction layer
can use AT&T's sfio (if you already have sfio installed) or regular stdio.
Using PerlIO with sfio may cause problems with some extension modules.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
rp='Use the PerlIO abstraction layer?'
. ./myread
case "$ans" in
y|Y)
        val="$define"
        ;;
*)
        echo "Ok, doing things the stdio way."
        val="$undef"
        ;;
esac
set useperlio
eval $setvar

case "$usesocks" in
$define|true|[yY]*)
        case "$useperlio" in
        $define|true|[yY]*) ;;
        *)      cat >&4 <<EOM

You are using the SOCKS proxy protocol library which means that you
should also use the PerlIO layer.  You may be headed for trouble.

EOM
                ;;
        esac
        ;;
esac


case "$usethreads" in
$define|true|[yY]*)     dflt='y';;
*)     # Catch case where user specified ithreads or 5005threads but
       # forgot -Dusethreads (A.D. 4/2002)
       case "$useithreads$use5005threads" in
       *$define*)
                case "$useperlio" in
                "$define")      dflt='y' ;;
                *)              dflt='n' ;;
                esac
                ;;
       *)       dflt='n';;
       esac
       ;;
esac
cat <<EOM

Perl can be built to take advantage of threads on some systems.
To do so, Configure can be run with -Dusethreads.

Note that Perl built with threading support runs slightly slower
and uses more memory than plain Perl. The current implementation
is believed to be stable, but it is fairly new, and so should be
treated with caution.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
rp='Build a threading Perl?'
. ./myread
case "$ans" in
y|Y)    val="$define" ;;
*)      val="$undef" ;;
esac
set usethreads
eval $setvar

case "$usethreads" in
$define)
        $cat <<EOM

Since release 5.6, Perl has had two different threading implementations,
the newer interpreter-based version (ithreads) with one interpreter per
thread, and the older 5.005 version (5005threads).
The 5005threads version is effectively unmaintained and will probably be
removed in Perl 5.10, so there should be no need to build a Perl using it
unless needed for backwards compatibility with some existing 5.005threads
code.

EOM
        : Default to ithreads unless overridden on command line or with
        : old config.sh
        dflt='y'
        case "$use5005threads" in
                $define|true|[yY]*) dflt='n';;
        esac
        case "$useithreads" in
                $undef|false|[nN]*) dflt='n';;
        esac
        rp='Use the newer interpreter-based ithreads?'
        . ./myread
        case "$ans" in
        y|Y)    val="$define" ;;
        *)      val="$undef" ;;
        esac
        set useithreads
        eval $setvar
        : Now set use5005threads to the opposite value.
        case "$useithreads" in
        $define) val="$undef" ;;
        *) val="$define" ;;
        esac
        set use5005threads
        eval $setvar
        ;;
*)
        useithreads="$undef"
        use5005threads="$undef"
        ;;
esac

case "$useithreads$use5005threads" in
"$define$define")
        $cat >&4 <<EOM

You cannot have both the ithreads and the 5.005 threads enabled
at the same time.  Disabling the 5.005 threads since they are
much less stable than the ithreads.

EOM
        use5005threads="$undef"
        ;;
esac

if test X"$usethreads" = "X$define" -a "X$useperlio" = "Xundef"; then
        cat >&4 <<EOF
***
*** To build with ithreads you must also use the PerlIO layer.
*** Cannot continue, aborting.
***
EOF
        exit 1
fi

case "$d_oldpthreads" in
'')     : Configure tests would be welcome here.  For now, assume undef.
        val="$undef" ;;
*)      val="$d_oldpthreads" ;;
esac
set d_oldpthreads
eval $setvar


: Look for a hint-file generated 'call-back-unit'.  If the
: user has specified that a threading perl is to be built,
: we may need to set or change some other defaults.
if $test -f usethreads.cbu; then
    echo "Your platform has some specific hints regarding threaded builds, using them..."
    . ./usethreads.cbu
else
    case "$usethreads" in
        "$define"|true|[yY]*)
                $cat <<EOM
(Your platform does not have any specific hints for threaded builds.
 Assuming POSIX threads, then.)
EOM
        ;;
    esac
fi

cat <<EOM

Perl can be built so that multiple Perl interpreters can coexist
within the same Perl executable.
EOM

case "$useithreads" in
$define)
        cat <<EOM
This multiple interpreter support is required for interpreter-based threads.
EOM
        val="$define"
        ;;
*)      case "$usemultiplicity" in
        $define|true|[yY]*)     dflt='y';;
        *) dflt='n';;
        esac
        echo " "
        echo "If this doesn't make any sense to you, just accept the default '$dflt'."
        rp='Build Perl for multiplicity?'
        . ./myread
        case "$ans" in
        y|Y)    val="$define" ;;
        *)      val="$undef" ;;
        esac
        ;;
esac
set usemultiplicity
eval $setvar


case "$usemorebits" in
"$define"|true|[yY]*)
        use64bitint="$define"
        uselongdouble="$define"
        usemorebits="$define"
        ;;
*)      usemorebits="$undef"
        ;;
esac

: make some quick guesses about what we are up against
echo " "
$echo $n "Hmm...  $c"
echo exit 1 >bsd
echo exit 1 >usg
echo exit 1 >v7
echo exit 1 >osf1
echo exit 1 >eunice
echo exit 1 >xenix
echo exit 1 >venix
echo exit 1 >os2
d_bsd="$undef"
$cat /usr/include/signal.h /usr/include/sys/signal.h >foo 2>/dev/null
if test -f /osf_boot || $contains 'OSF/1' /usr/include/ctype.h >/dev/null 2>&1
then
        echo "Looks kind of like an OSF/1 system, but we'll see..."
        echo exit 0 >osf1
elif test `echo abc | $tr a-z A-Z` = Abc ; then
        xxx=`./loc addbib blurfl $pth`
        if $test -f $xxx; then
        echo "Looks kind of like a USG system with BSD features, but we'll see..."
                echo exit 0 >bsd
                echo exit 0 >usg
        else
                if $contains SIGTSTP foo >/dev/null 2>&1 ; then
                        echo "Looks kind of like an extended USG system, but we'll see..."
                else
                        echo "Looks kind of like a USG system, but we'll see..."
                fi
                echo exit 0 >usg
        fi
elif $contains SIGTSTP foo >/dev/null 2>&1 ; then
        echo "Looks kind of like a BSD system, but we'll see..."
        d_bsd="$define"
        echo exit 0 >bsd
else
        echo "Looks kind of like a Version 7 system, but we'll see..."
        echo exit 0 >v7
fi
case "$eunicefix" in
*unixtovms*)
        $cat <<'EOI'
There is, however, a strange, musty smell in the air that reminds me of
something...hmm...yes...I've got it...there's a VMS nearby, or I'm a Blit.
EOI
        echo exit 0 >eunice
        d_eunice="$define"
: it so happens the Eunice I know will not run shell scripts in Unix format
        ;;
*)
        echo " "
        echo "Congratulations.  You aren't running Eunice."
        d_eunice="$undef"
        ;;
esac
: Detect OS2.  The p_ variable is set above in the Head.U unit.
: Note that this also -- wrongly -- detects e.g. dos-djgpp, which also uses
: semicolon as a patch separator
case "$p_" in
:) ;;
*)
        $cat <<'EOI'
I have the feeling something is not exactly right, however...don't tell me...
lemme think...does HAL ring a bell?...no, of course, you're only running OS/2!
(Or you may be running DOS with DJGPP.)
EOI
        echo exit 0 >os2
        ;;
esac
if test -f /xenix; then
        echo "Actually, this looks more like a XENIX system..."
        echo exit 0 >xenix
        d_xenix="$define"
else
        echo " "
        echo "It's not Xenix..."
        d_xenix="$undef"
fi
chmod +x xenix
$eunicefix xenix
if test -f /venix; then
        echo "Actually, this looks more like a VENIX system..."
        echo exit 0 >venix
else
        echo " "
        if ./xenix; then
                : null
        else
                echo "Nor is it Venix..."
        fi
fi
chmod +x bsd usg v7 osf1 eunice xenix venix os2
$eunicefix bsd usg v7 osf1 eunice xenix venix os2
$rm -f foo

case "$cc" in
'') dflt=cc;;
*) dflt="$cc";;
esac
rp="Use which C compiler?"
. ./myread
cc="$ans"

: See if they have not cc but they do have gcc
. ./trygcc
: Look for a hint-file generated 'call-back-unit'.  Now that the
: user has specified the compiler, we may need to set or change some
: other defaults.
if $test -f cc.cbu; then
    . ./cc.cbu
fi
. ./checkcc

echo " "
echo "Checking for GNU cc in disguise and/or its version number..." >&4
$cat >try.c <<EOM
#include <stdio.h>
int main() {
#ifdef __GNUC__
#ifdef __VERSION__
        printf("%s\n", __VERSION__);
#else
        printf("%s\n", "1");
#endif
#endif
        return(0);
}
EOM
if $cc -o try $ccflags $ldflags try.c; then
        gccversion=`$run ./try`
        case "$gccversion" in
        '') echo "You are not using GNU cc." ;;
        *)  echo "You are using GNU cc $gccversion."
            ccname=gcc
            ;;
        esac
else
        echo " "
        echo "*** WHOA THERE!!! ***" >&4
        echo "    Your C compiler \"$cc\" doesn't seem to be working!" >&4
        case "$knowitall" in
        '')
        echo "    You'd better start hunting for one and let me know about it." >&4
                exit 1
                ;;
        esac
fi
$rm -f try try.*
case "$gccversion" in
1*) cpp=`./loc gcc-cpp $cpp $pth` ;;
esac
case "$gccversion" in
'') gccosandvers='' ;;
*) gccshortvers=`echo "$gccversion"|sed 's/ .*//'`
   gccosandvers=`$cc -v 2>&1|grep '/specs$'|sed "s!.*/[^-/]*-[^-/]*-\([^-/]*\)/$gccshortvers/specs!\1!"`
   gccshortvers=''
   case "$gccosandvers" in
   $osname) gccosandvers='' ;; # linux gccs seem to have no linux osvers, grr
   $osname$osvers) ;; # looking good
   $osname*) cat <<EOM >&4

*** WHOA THERE!!! ***

    Your gcc has not been compiled for the exact release of
    your operating system ($gccosandvers versus $osname$osvers).

    In general it is a good idea to keep gcc synchronized with
    the operating system because otherwise serious problems
    may ensue when trying to compile software, like Perl.

    I'm trying to be optimistic here, though, and will continue.
    If later during the configuration and build icky compilation
    problems appear (headerfile conflicts being the most common
    manifestation), I suggest reinstalling the gcc to match
    your operating system release.

EOM
      ;;
   *) gccosandvers='' ;; # failed to parse, better be silent
   esac
   ;;
esac
case "$ccname" in
'') ccname="$cc" ;;
esac

# gcc 3.* complain about adding -Idirectories that they already know about,
# so we will take those off from locincpth.
case "$gccversion" in
3*)
    echo "main(){}">try.c
    for incdir in $locincpth; do
       warn=`$cc $ccflags -I$incdir -c try.c 2>&1 | \
             grep '^c[cp]p*[01]: warning: changing search order '`
       if test "X$warn" != X; then
           locincpth=`echo " $locincpth " | sed "s! $incdir ! !"`
       fi
    done
    $rm -f try try.*
esac

: decide how portable to be.  Allow command line overrides.
case "$d_portable" in
"$undef") ;;
*)      d_portable="$define" ;;
esac

: set up shell script to do ~ expansion
cat >filexp <<EOSS
$startsh
: expand filename
case "\$1" in
 ~/*|~)
        echo \$1 | $sed "s|~|\${HOME-\$LOGDIR}|"
        ;;
 ~*)
        if $test -f /bin/csh; then
                /bin/csh -f -c "glob \$1"
                failed=\$?
                echo ""
                exit \$failed
        else
                name=\`$expr x\$1 : '..\([^/]*\)'\`
                dir=\`$sed -n -e "/^\${name}:/{s/^[^:]*:[^:]*:[^:]*:[^:]*:[^:]*:\([^:]*\).*"'\$'"/\1/" -e p -e q -e '}' </etc/passwd\`
                if $test ! -d "\$dir"; then
                        me=\`basename \$0\`
                        echo "\$me: can't locate home directory for: \$name" >&2
                        exit 1
                fi
                case "\$1" in
                */*)
                        echo \$dir/\`$expr x\$1 : '..[^/]*/\(.*\)'\`
                        ;;
                *)
                        echo \$dir
                        ;;
                esac
        fi
        ;;
*)
        echo \$1
        ;;
esac
EOSS
chmod +x filexp
$eunicefix filexp

: now set up to get a file name
cat <<EOS >getfile
$startsh
EOS
cat <<'EOSC' >>getfile
tilde=''
fullpath=''
already=''
skip=''
none_ok=''
exp_file=''
nopath_ok=''
orig_rp="$rp"
orig_dflt="$dflt"
case "$gfpth" in
'') gfpth='.' ;;
esac

case "$fn" in
*\(*)
        : getfile will accept an answer from the comma-separated list
        : enclosed in parentheses even if it does not meet other criteria.
        expr "$fn" : '.*(\(.*\)).*' | $tr ',' $trnl >getfile.ok
        fn=`echo $fn | sed 's/(.*)//'`
        ;;
esac

case "$fn" in
*:*)
        loc_file=`expr $fn : '.*:\(.*\)'`
        fn=`expr $fn : '\(.*\):.*'`
        ;;
esac

case "$fn" in
*~*) tilde=true;;
esac
case "$fn" in
*/*) fullpath=true;;
esac
case "$fn" in
*+*) skip=true;;
esac
case "$fn" in
*n*) none_ok=true;;
esac
case "$fn" in
*e*) exp_file=true;;
esac
case "$fn" in
*p*) nopath_ok=true;;
esac

case "$fn" in
*f*) type='File';;
*d*) type='Directory';;
*l*) type='Locate';;
esac

what="$type"
case "$what" in
Locate) what='File';;
esac

case "$exp_file" in
'')
        case "$d_portable" in
        "$define") ;;
        *) exp_file=true;;
        esac
        ;;
esac

cd ..
while test "$type"; do
        redo=''
        rp="$orig_rp"
        dflt="$orig_dflt"
        case "$tilde" in
        true) rp="$rp (~name ok)";;
        esac
        . UU/myread
        if test -f UU/getfile.ok && \
                $contains "^$ans\$" UU/getfile.ok >/dev/null 2>&1
        then
                value="$ans"
                ansexp="$ans"
                break
        fi
        case "$ans" in
        none)
                value=''
                ansexp=''
                case "$none_ok" in
                true) type='';;
                esac
                ;;
        *)
                case "$tilde" in
                '') value="$ans"
                        ansexp="$ans";;
                *)
                        value=`UU/filexp $ans`
                        case $? in
                        0)
                                if test "$ans" != "$value"; then
                                        echo "(That expands to $value on this system.)"
                                fi
                                ;;
                        *) value="$ans";;
                        esac
                        ansexp="$value"
                        case "$exp_file" in
                        '') value="$ans";;
                        esac
                        ;;
                esac
                case "$fullpath" in
                true)
                        case "$ansexp" in
                        /*) value="$ansexp" ;;
                        [a-zA-Z]:/*) value="$ansexp" ;;
                        *)
                                redo=true
                                case "$already" in
                                true)
                                echo "I shall only accept a full path name, as in /bin/ls." >&4
                                echo "Use a ! shell escape if you wish to check pathnames." >&4
                                        ;;
                                *)
                                echo "Please give a full path name, starting with slash." >&4
                                        case "$tilde" in
                                        true)
                                echo "Note that using ~name is ok provided it expands well." >&4
                                                already=true
                                                ;;
                                        esac
                                esac
                                ;;
                        esac
                        ;;
                esac
                case "$redo" in
                '')
                        case "$type" in
                        File)
                                for fp in $gfpth; do
                                        if test "X$fp" = X.; then
                                            pf="$ansexp"
                                        else
                                            pf="$fp/$ansexp"
                                        fi
                                        if test -f "$pf"; then
                                                type=''
                                        elif test -r "$pf" || (test -h "$pf") >/dev/null 2>&1
                                        then
                                                echo "($value is not a plain file, but that's ok.)"
                                                type=''
                                        fi
                                        if test X"$type" = X; then
                                            value="$pf"
                                            break
                                        fi
                                done
                                ;;
                        Directory)
                                for fp in $gfpth; do
                                        if test "X$fp" = X.; then
                                            dir="$ans"
                                            direxp="$ansexp"
                                        else
                                            dir="$fp/$ansexp"
                                            direxp="$fp/$ansexp"
                                        fi
                                        if test -d "$direxp"; then
                                                type=''
                                                value="$dir"
                                                break
                                        fi
                                done
                                ;;
                        Locate)
                                if test -d "$ansexp"; then
                                        echo "(Looking for $loc_file in directory $value.)"
                                        value="$value/$loc_file"
                                        ansexp="$ansexp/$loc_file"
                                fi
                                if test -f "$ansexp"; then
                                        type=''
                                fi
                                case "$nopath_ok" in
                                true)   case "$value" in
                                        */*) ;;
                                        *)      echo "Assuming $value will be in people's path."
                                                type=''
                                                ;;
                                        esac
                                        ;;
                                esac
                                ;;
                        esac

                        case "$skip" in
                        true) type='';
                        esac

                        case "$type" in
                        '') ;;
                        *)
                                if test "$fastread" = yes; then
                                        dflt=y
                                else
                                        dflt=n
                                fi
                                rp="$what $value doesn't exist.  Use that name anyway?"
                                . UU/myread
                                dflt=''
                                case "$ans" in
                                y*) type='';;
                                *) echo " ";;
                                esac
                                ;;
                        esac
                        ;;
                esac
                ;;
        esac
done
cd UU
ans="$value"
rp="$orig_rp"
dflt="$orig_dflt"
rm -f getfile.ok
test "X$gfpthkeep" != Xy && gfpth=""
EOSC

: What should the include directory be ?
echo " "
$echo $n "Hmm...  $c"
dflt='/usr/include'
incpath=''
mips_type=''
if $test -f /bin/mips && /bin/mips; then
        echo "Looks like a MIPS system..."
        $cat >usr.c <<'EOCP'
#ifdef SYSTYPE_BSD43
/bsd43
#endif
EOCP
        if cc -E usr.c > usr.out && $contains / usr.out >/dev/null 2>&1; then
                dflt='/bsd43/usr/include'
                incpath='/bsd43'
                mips_type='BSD 4.3'
        else
                mips_type='System V'
        fi
        $rm -f usr.c usr.out
        echo "and you're compiling with the $mips_type compiler and libraries."
        xxx_prompt=y
        echo "exit 0" >mips
else
        echo "Doesn't look like a MIPS system."
        xxx_prompt=n
        echo "exit 1" >mips
fi
chmod +x mips
$eunicefix mips
case "$usrinc" in
'') ;;
*) dflt="$usrinc";;
esac
case "$xxx_prompt" in
y)      fn=d/
        echo " "
        rp='Where are the include files you want to use?'
        . ./getfile
        usrinc="$ans"
        ;;
*)      usrinc="$dflt"
        ;;
esac

: see how we invoke the C preprocessor
echo " "
echo "Now, how can we feed standard input to your C preprocessor..." >&4
cat <<'EOT' >testcpp.c
#define ABC abc
#define XYZ xyz
ABC.XYZ
EOT
cd ..
if test ! -f cppstdin; then
        if test "X$osname" = "Xaix" -a "X$gccversion" = X; then
                # AIX cc -E doesn't show the absolute headerfile
                # locations but we'll cheat by using the -M flag.
                echo 'cat >.$$.c; rm -f .$$.u; '"$cc"' ${1+"$@"} -M -c .$$.c 2>/dev/null; test -s .$$.u && awk '"'"'$2 ~ /\.h$/ { print "# 0 \""$2"\"" }'"'"' .$$.u; rm -f .$$.o .$$.u; '"$cc"' -E ${1+"$@"} .$$.c; rm .$$.c' > cppstdin
        else
                echo 'cat >.$$.c; '"$cc"' -E ${1+"$@"} .$$.c; rm .$$.c' >cppstdin
        fi
else
        echo "Keeping your $hint cppstdin wrapper."
fi
chmod 755 cppstdin
wrapper=`pwd`/cppstdin
ok='false'
cd UU

if $test "X$cppstdin" != "X" && \
        $cppstdin $cppminus <testcpp.c >testcpp.out 2>&1 && \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1
then
        echo "You used to use $cppstdin $cppminus so we'll use that again."
        case "$cpprun" in
        '') echo "But let's see if we can live without a wrapper..." ;;
        *)
                if $cpprun $cpplast <testcpp.c >testcpp.out 2>&1 && \
                        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1
                then
                        echo "(And we'll use $cpprun $cpplast to preprocess directly.)"
                        ok='true'
                else
                        echo "(However, $cpprun $cpplast does not work, let's see...)"
                fi
                ;;
        esac
else
        case "$cppstdin" in
        '') ;;
        *)
                echo "Good old $cppstdin $cppminus does not seem to be of any help..."
                ;;
        esac
fi

if $ok; then
        : nothing
elif echo 'Maybe "'"$cc"' -E" will work...'; \
        $cc -E <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        echo "Yup, it does."
        x_cpp="$cc -E"
        x_minus='';
elif echo 'Nope...maybe "'"$cc"' -E -" will work...'; \
        $cc -E - <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        echo "Yup, it does."
        x_cpp="$cc -E"
        x_minus='-';
elif echo 'Nope...maybe "'"$cc"' -P" will work...'; \
        $cc -P <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        echo "Yipee, that works!"
        x_cpp="$cc -P"
        x_minus='';
elif echo 'Nope...maybe "'"$cc"' -P -" will work...'; \
        $cc -P - <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        echo "At long last!"
        x_cpp="$cc -P"
        x_minus='-';
elif echo 'No such luck, maybe "'$cpp'" will work...'; \
        $cpp <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        echo "It works!"
        x_cpp="$cpp"
        x_minus='';
elif echo 'Nixed again...maybe "'$cpp' -" will work...'; \
        $cpp - <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        echo "Hooray, it works!  I was beginning to wonder."
        x_cpp="$cpp"
        x_minus='-';
elif echo 'Uh-uh.  Time to get fancy.  Trying a wrapper...'; \
        $wrapper <testcpp.c >testcpp.out 2>&1; \
        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
        x_cpp="$wrapper"
        x_minus=''
        echo "Eureka!"
else
        dflt=''
        rp="No dice.  I can't find a C preprocessor.  Name one:"
        . ./myread
        x_cpp="$ans"
        x_minus=''
        $x_cpp <testcpp.c >testcpp.out 2>&1
        if $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1 ; then
                echo "OK, that will do." >&4
        else
echo "Sorry, I can't get that to work.  Go find one and rerun Configure." >&4
                exit 1
        fi
fi

case "$ok" in
false)
        cppstdin="$x_cpp"
        cppminus="$x_minus"
        cpprun="$x_cpp"
        cpplast="$x_minus"
        set X $x_cpp
        shift
        case "$1" in
        "$cpp")
                echo "Perhaps can we force $cc -E using a wrapper..."
                if $wrapper <testcpp.c >testcpp.out 2>&1; \
                        $contains 'abc.*xyz' testcpp.out >/dev/null 2>&1
                then
                        echo "Yup, we can."
                        cppstdin="$wrapper"
                        cppminus='';
                else
                        echo "Nope, we'll have to live without it..."
                fi
                ;;
        esac
        case "$cpprun" in
        "$wrapper")
                cpprun=''
                cpplast=''
                ;;
        esac
        ;;
esac

case "$cppstdin" in
"$wrapper"|'cppstdin') ;;
*) $rm -f $wrapper;;
esac
$rm -f testcpp.c testcpp.out

: Set private lib path
case "$plibpth" in
'') if ./mips; then
                plibpth="$incpath/usr/lib /usr/local/lib /usr/ccs/lib"
        fi;;
esac
case "$libpth" in
' ') dlist='';;
'') dlist="$loclibpth $plibpth $glibpth";;
*) dlist="$libpth";;
esac

: Now check and see which directories actually exist, avoiding duplicates
libpth=''
for xxx in $dlist
do
    if $test -d $xxx; then
                case " $libpth " in
                *" $xxx "*) ;;
                *) libpth="$libpth $xxx";;
                esac
    fi
done
$cat <<'EOM'

Some systems have incompatible or broken versions of libraries.  Among
the directories listed in the question below, please remove any you
know not to be holding relevant libraries, and add any that are needed.
Say "none" for none.

EOM
case "$libpth" in
'') dflt='none';;
*)
        set X $libpth
        shift
        dflt=${1+"$@"}
        ;;
esac
rp="Directories to use for library searches?"
. ./myread
case "$ans" in
none) libpth=' ';;
*) libpth="$ans";;
esac

: compute shared library extension
case "$so" in
'')
        if xxx=`./loc libc.sl X $libpth`; $test -f "$xxx"; then
                dflt='sl'
        else
                dflt='so'
        fi
        ;;
*) dflt="$so";;
esac
$cat <<EOM

On some systems, shared libraries may be available.  Answer 'none' if
you want to suppress searching of shared libraries for the remainder
of this configuration.

EOM
rp='What is the file extension used for shared libraries?'
. ./myread
so="$ans"

: Define several unixisms.
: Hints files or command line option can be used to override them.
: The convoluted testing is in case hints files set either the old
: or the new name.
case "$_exe" in
'')     case "$exe_ext" in
        '')     ;;
        *)      _exe="$exe_ext" ;;
        esac
        ;;
esac
case "$_a" in
'')     case "$lib_ext" in
    '') _a='.a';;
        *)      _a="$lib_ext" ;;
        esac
        ;;
esac
case "$_o" in
'') case "$obj_ext" in
        '')     _o='.o';;
        *)      _o="$obj_ext";;
        esac
        ;;
esac
case "$p_" in
'') case "$path_sep" in
        '')     p_=':';;
        *)      p_="$path_sep";;
        esac
        ;;
esac
exe_ext=$_exe
lib_ext=$_a
obj_ext=$_o
path_sep=$p_

: Which makefile gets called first.  This is used by make depend.
case "$firstmakefile" in
'') firstmakefile='makefile';;
esac

case "$ccflags" in
*-DUSE_LONG_DOUBLE*|*-DUSE_MORE_BITS*) uselongdouble="$define" ;;
esac

case "$uselongdouble" in
$define|true|[yY]*)     dflt='y';;
*) dflt='n';;
esac
cat <<EOM

Perl can be built to take advantage of long doubles which
(if available) may give more accuracy and range for floating point numbers.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
rp='Try to use long doubles if available?'
. ./myread
case "$ans" in
y|Y)    val="$define"   ;;
*)      val="$undef"    ;;
esac
set uselongdouble
eval $setvar

case "$uselongdouble" in
true|[yY]*) uselongdouble="$define" ;;
esac

: Look for a hint-file generated 'call-back-unit'.  If the
: user has specified that long doubles should be used,
: we may need to set or change some other defaults.
if $test -f uselongdouble.cbu; then
    echo "Your platform has some specific hints regarding long doubles, using them..."
    . ./uselongdouble.cbu
else
    case "$uselongdouble" in
        $define)
                $cat <<EOM
(Your platform does not have any specific hints for long doubles.)
EOM
        ;;
    esac
fi

: Looking for optional libraries
echo " "
echo "Checking for optional libraries..." >&4
case "$libs" in
' '|'') dflt='';;
*) dflt="$libs";;
esac
case "$libswanted" in
'') libswanted='c_s';;
esac
case "$usesocks" in
"$define") libswanted="$libswanted socks5 socks5_sh" ;;
esac
libsfound=''
libsfiles=''
libsdirs=''
libspath=''
for thisdir in $libpth $xlibpth; do
  test -d $thisdir && libspath="$libspath $thisdir"
done
for thislib in $libswanted; do
        for thisdir in $libspath; do
            xxx=''
            if $test ! -f "$xxx" -a "X$ignore_versioned_solibs" = "X"; then
                xxx=`ls $thisdir/lib$thislib.$so.[0-9] 2>/dev/null|sed -n '$p'`
                $test -f "$xxx" && eval $libscheck
                $test -f "$xxx" && libstyle=shared
            fi
            if test ! -f "$xxx"; then
                xxx=$thisdir/lib$thislib.$so
                $test -f "$xxx" && eval $libscheck
                $test -f "$xxx" && libstyle=shared
            fi
            if test ! -f "$xxx"; then
                xxx=$thisdir/lib$thislib$_a
                $test -f "$xxx" && eval $libscheck
                $test -f "$xxx" && libstyle=static
            fi
            if test ! -f "$xxx"; then
                xxx=$thisdir/$thislib$_a
                $test -f "$xxx" && eval $libscheck
                $test -f "$xxx" && libstyle=static
            fi
            if test ! -f "$xxx"; then
                xxx=$thisdir/lib${thislib}_s$_a
                $test -f "$xxx" && eval $libscheck
                $test -f "$xxx" && libstyle=static
                $test -f "$xxx" && thislib=${thislib}_s
            fi
            if test ! -f "$xxx"; then
                xxx=$thisdir/Slib$thislib$_a
                $test -f "$xxx" && eval $libscheck
                $test -f "$xxx" && libstyle=static
            fi
            if $test -f "$xxx"; then
                case "$libstyle" in
                shared) echo "Found -l$thislib (shared)." ;;
                static) echo "Found -l$thislib." ;;
                *)      echo "Found -l$thislib ($libstyle)." ;;
                esac
                case " $dflt " in
                *"-l$thislib "*);;
                *) dflt="$dflt -l$thislib"
                   libsfound="$libsfound $xxx"
                   yyy=`basename $xxx`
                   libsfiles="$libsfiles $yyy"
                   yyy=`echo $xxx|$sed -e "s%/$yyy\\$%%"`
                   case " $libsdirs " in
                   *" $yyy "*) ;;
                   *) libsdirs="$libsdirs $yyy" ;;
                   esac
                   ;;
                esac
                break
            fi
        done
        if $test ! -f "$xxx"; then
            echo "No -l$thislib."
        fi
done
set X $dflt
shift
dflt="$*"
case "$libs" in
'') dflt="$dflt";;
*) dflt="$libs";;
esac
case "$dflt" in
' '|'') dflt='none';;
esac

$cat <<EOM

In order to compile $package on your machine, a number of libraries
are usually needed.  Include any other special libraries here as well.
Say "none" for none.  The default list is almost always right.
EOM

echo " "
rp="What libraries to use?"
. ./myread
case "$ans" in
none) libs=' ';;
*) libs="$ans";;
esac

: determine optimization, if desired, or use for debug flag also
case "$optimize" in
' '|$undef) dflt='none';;
'') dflt='-O';;
*) dflt="$optimize";;
esac
$cat <<EOH

By default, $package compiles with the -O flag to use the optimizer.
Alternately, you might want to use the symbolic debugger, which uses
the -g flag (on traditional Unix systems).  Either flag can be
specified here.  To use neither flag, specify the word "none".

EOH
rp="What optimizer/debugger flag should be used?"
. ./myread
optimize="$ans"
case "$optimize" in
'none') optimize=" ";;
esac

dflt=''
: We will not override a previous value, but we might want to
: augment a hint file
case "$hint" in
default|recommended)
        case "$gccversion" in
        1*) dflt='-fpcc-struct-return' ;;
        esac
        case "$optimize" in
        *-g*) dflt="$dflt -DDEBUGGING";;
        esac
        case "$gccversion" in
        2*) if test -d /etc/conf/kconfig.d &&
                        $contains _POSIX_VERSION $usrinc/sys/unistd.h >/dev/null 2>&1
                then
                        # Interactive Systems (ISC) POSIX mode.
                        dflt="$dflt -posix"
                fi
                ;;
        esac
        case "$gccversion" in
        1*) ;;
        2.[0-8]*) ;;
        ?*)     echo " "
                echo "Checking if your compiler accepts -fno-strict-aliasing" 2>&1
                echo 'int main(void) { return 0; }' > gcctest.c
                if $cc -O2 -fno-strict-aliasing -o gcctest gcctest.c; then
                        echo "Yes, it does." 2>&1
                        case "$ccflags" in
                        *strict-aliasing*)
                                echo "Leaving current flags $ccflags alone." 2>&1
                                ;;
                        *) dflt="$dflt -fno-strict-aliasing" ;;
                        esac
                else
                        echo "Nope, it doesn't, but that's ok." 2>&1
                fi
                ;;
        esac
        # For gcc, adding -pipe speeds up compilations for some, but apparently
        # some assemblers can't read from stdin.  (It also slows down compilations
        # in other cases, but those are apparently rarer these days.)  AD 5/2004.
        case "$gccversion" in
        ?*)     echo " "
                echo "Checking if your compiler accepts -pipe" 2>&1
                echo 'int main(void) { return 0; }' > gcctest.c
                if $cc -O2 -pipe -o gcctest gcctest.c; then
                        echo "Yes, it does." 2>&1
                        case "$ccflags" in
                        *-pipe*)
                                echo "Leaving current flags $ccflags alone." 2>&1
                                ;;
                        *) dflt="$dflt -pipe" ;;
                        esac
                else
                        echo "Nope, it doesn't, but that's ok." 2>&1
                fi
                ;;
        esac
        ;;
esac

case "$mips_type" in
*BSD*|'') inclwanted="$locincpth $usrinc";;
*) inclwanted="$locincpth $inclwanted $usrinc/bsd";;
esac
for thisincl in $inclwanted; do
        if $test -d $thisincl; then
                if $test x$thisincl != x$usrinc; then
                        case "$dflt" in
                        *" -I$thisincl "*);;
                        *) dflt="$dflt -I$thisincl ";;
                        esac
                fi
        fi
done

inctest='if $contains $2 $usrinc/$1 >/dev/null 2>&1; then
        xxx=true;
elif $contains $2 $usrinc/sys/$1 >/dev/null 2>&1; then
        xxx=true;
else
        xxx=false;
fi;
if $xxx; then
        case "$dflt" in
        *$2*);;
        *) dflt="$dflt -D$2";;
        esac;
fi'

set signal.h LANGUAGE_C; eval $inctest

case "$usesocks" in
$define)
        ccflags="$ccflags -DSOCKS"
        ;;
esac

case "$hint" in
default|recommended) dflt="$ccflags $dflt" ;;
*) dflt="$ccflags";;
esac

case "$dflt" in
''|' ') dflt=none;;
esac

$cat <<EOH

Your C compiler may want other flags.  For this question you should include
-I/whatever and -DWHATEVER flags and any other flags used by the C compiler,
but you should NOT include libraries or ld flags like -lwhatever.  If you
want $package to honor its debug switch, you should include -DDEBUGGING here.
Your C compiler might also need additional flags, such as -D_POSIX_SOURCE.

To use no flags, specify the word "none".

EOH
set X $dflt
shift
dflt=${1+"$@"}
rp="Any additional cc flags?"
. ./myread
case "$ans" in
none) ccflags='';;
*) ccflags="$ans";;
esac

: the following weeds options from ccflags that are of no interest to cpp
case "$cppflags" in
'') cppflags="$ccflags" ;;
*)  cppflags="$cppflags $ccflags" ;;
esac
case "$gccversion" in
1*) cppflags="$cppflags -D__GNUC__"
esac
case "$mips_type" in
'');;
*BSD*) cppflags="$cppflags -DSYSTYPE_BSD43";;
esac
case "$cppflags" in
'');;
*)
        echo " "
        echo "Let me guess what the preprocessor flags are..." >&4
        set X $cppflags
        shift
        cppflags=''
        $cat >cpp.c <<'EOM'
#define BLURFL foo

BLURFL xx LFRULB
EOM
        previous=''
        for flag in $*
        do
                case "$flag" in
                -*) ftry="$flag";;
                *) ftry="$previous $flag";;
                esac
                if $cppstdin -DLFRULB=bar $cppflags $ftry $cppminus <cpp.c \
                        >cpp1.out 2>/dev/null && \
                        $cpprun -DLFRULB=bar $cppflags $ftry $cpplast <cpp.c \
                        >cpp2.out 2>/dev/null && \
                        $contains 'foo.*xx.*bar' cpp1.out >/dev/null 2>&1 && \
                        $contains 'foo.*xx.*bar' cpp2.out >/dev/null 2>&1
                then
                        cppflags="$cppflags $ftry"
                        previous=''
                else
                        previous="$flag"
                fi
        done
        set X $cppflags
        shift
        cppflags=${1+"$@"}
        case "$cppflags" in
        *-*)  echo "They appear to be: $cppflags";;
        esac
        $rm -f cpp.c cpp?.out
        ;;
esac

: flags used in final linking phase
case "$ldflags" in
'') if ./venix; then
                dflt='-i -z'
        else
                dflt=''
        fi
        case "$ccflags" in
        *-posix*) dflt="$dflt -posix" ;;
        esac
        ;;
*) dflt="$ldflags";;
esac

: Try to guess additional flags to pick up local libraries.
for thislibdir in $libpth; do
        case " $loclibpth " in
        *" $thislibdir "*)
                case "$dflt " in
                *"-L$thislibdir "*) ;;
                *)  dflt="$dflt -L$thislibdir" ;;
                esac
                ;;
        esac
done

case "$dflt" in
'') dflt='none' ;;
esac

$cat <<EOH

Your C linker may need flags.  For this question you should
include -L/whatever and any other flags used by the C linker, but you
should NOT include libraries like -lwhatever.

Make sure you include the appropriate -L/path flags if your C linker
does not normally search all of the directories you specified above,
namely
        $libpth
To use no flags, specify the word "none".

EOH

rp="Any additional ld flags (NOT including libraries)?"
. ./myread
case "$ans" in
none) ldflags='';;
*) ldflags="$ans";;
esac
rmlist="$rmlist pdp11"

: coherency check
echo " "
echo "Checking your choice of C compiler and flags for coherency..." >&4
$cat > try.c <<'EOF'
#include <stdio.h>
int main() { printf("Ok\n"); return(0); }
EOF
set X $cc -o try $optimize $ccflags $ldflags try.c $libs
shift
$cat >try.msg <<'EOM'
I've tried to compile and run the following simple program:

EOM
$cat try.c >> try.msg

$cat >> try.msg <<EOM

I used the command:

        $*
        $run ./try

and I got the following output:

EOM
dflt=y
if $sh -c "$cc -o try $optimize $ccflags $ldflags try.c $libs" >>try.msg 2>&1; then
        if $sh -c "$run ./try" >>try.msg 2>&1; then
                xxx=`$run ./try`
                case "$xxx" in
                "Ok") dflt=n ;;
                *)      echo 'The program compiled OK, but produced no output.' >> try.msg
                        case " $libs " in
                        *" -lsfio "*)
                                cat >> try.msg <<'EOQS'
If $libs contains -lsfio, and sfio is mis-configured, then it
sometimes (apparently) runs and exits with a 0 status, but with no
output!  It may have to do with sfio's use of _exit vs. exit.

EOQS
                                rp="You have a big problem.  Shall I abort Configure"
                                dflt=y
                                ;;
                        esac
                        ;;
                esac
        else
                echo "The program compiled OK, but exited with status $?." >>try.msg
                rp="You have a problem.  Shall I abort Configure"
                dflt=y
        fi
else
        echo "I can't compile the test program." >>try.msg
        rp="You have a BIG problem.  Shall I abort Configure"
        dflt=y
fi
case "$dflt" in
y)
        $cat try.msg >&4
        case "$knowitall" in
        '')
                echo "(The supplied flags or libraries might be incorrect.)"
                ;;
        *) dflt=n;;
        esac
        echo " "
        . ./myread
        case "$ans" in
        n*|N*) ;;
        *)      echo "Ok.  Stopping Configure." >&4
                exit 1
                ;;
        esac
        ;;
n) echo "OK, that should do.";;
esac
$rm -f try try.* core

: define a shorthand compile call
compile='
mc_file=$1;
shift;
$cc -o ${mc_file} $optimize $ccflags $ldflags $* ${mc_file}.c $libs > /dev/null 2>&1;'
: define a shorthand compile call for compilations that should be ok.
compile_ok='
mc_file=$1;
shift;
$cc -o ${mc_file} $optimize $ccflags $ldflags $* ${mc_file}.c $libs;'

: determine filename position in cpp output
echo " "
echo "Computing filename position in cpp output for #include directives..." >&4
case "$osname" in
vos) testaccess=-e ;;
*)   testaccess=-r ;;
esac
echo '#include <stdio.h>' > foo.c
$cat >fieldn <<EOF
$startsh
$cppstdin $cppflags $cppminus <foo.c 2>/dev/null | \
$grep '^[       ]*#.*stdio\.h' | \
while read cline; do
        pos=1
        set \$cline
        while $test \$# -gt 0; do
                if $test $testaccess \`echo \$1 | $tr -d '"'\`; then
                        echo "\$pos"
                        exit 0
                fi
                shift
                pos=\`expr \$pos + 1\`
        done
done
EOF
chmod +x fieldn
fieldn=`./fieldn`
$rm -f foo.c fieldn
case $fieldn in
'') pos='???';;
1) pos=first;;
2) pos=second;;
3) pos=third;;
*) pos="${fieldn}th";;
esac
echo "Your cpp writes the filename in the $pos field of the line."

case "$osname" in
vos) cppfilter="tr '\\\\>' '/' |" ;; # path component separator is >
os2) cppfilter="sed -e 's|\\\\\\\\|/|g' |" ;; # path component separator is \
*)   cppfilter='' ;;
esac
: locate header file
$cat >findhdr <<EOF
$startsh
wanted=\$1
name=''
for usrincdir in $usrinc
do
        if test -f \$usrincdir/\$wanted; then
                echo "\$usrincdir/\$wanted"
                exit 0
        fi
done
awkprg='{ print \$$fieldn }'
echo "#include <\$wanted>" > foo\$\$.c
$cppstdin $cppminus $cppflags < foo\$\$.c 2>/dev/null | \
$cppfilter $grep "^[    ]*#.*\$wanted" | \
while read cline; do
        name=\`echo \$cline | $awk "\$awkprg" | $tr -d '"'\`
        case "\$name" in
        *[/\\\\]\$wanted) echo "\$name"; exit 1;;
        *[\\\\/]\$wanted) echo "\$name"; exit 1;;
        *) exit 2;;
        esac;
done;
#
# status = 0: grep returned 0 lines, case statement not executed
# status = 1: headerfile found
# status = 2: while loop executed, no headerfile found
#
status=\$?
$rm -f foo\$\$.c;
if test \$status -eq 1; then
        exit 0;
fi
exit 1
EOF
chmod +x findhdr

: define an alternate in-header-list? function
inhdr='echo " "; td=$define; tu=$undef; yyy=$@;
cont=true; xxf="echo \"<\$1> found.\" >&4";
case $# in 2) xxnf="echo \"<\$1> NOT found.\" >&4";;
*) xxnf="echo \"<\$1> NOT found, ...\" >&4";;
esac;
case $# in 4) instead=instead;; *) instead="at last";; esac;
while $test "$cont"; do
        xxx=`./findhdr $1`
        var=$2; eval "was=\$$2";
        if $test "$xxx" && $test -r "$xxx";
        then eval $xxf;
        eval "case \"\$$var\" in $undef) . ./whoa; esac"; eval "$var=\$td";
                cont="";
        else eval $xxnf;
        eval "case \"\$$var\" in $define) . ./whoa; esac"; eval "$var=\$tu"; fi;
        set $yyy; shift; shift; yyy=$@;
        case $# in 0) cont="";;
        2) xxf="echo \"but I found <\$1> $instead.\" >&4";
                xxnf="echo \"and I did not find <\$1> either.\" >&4";;
        *) xxf="echo \"but I found <\$1\> instead.\" >&4";
                xxnf="echo \"there is no <\$1>, ...\" >&4";;
        esac;
done;
while $test "$yyy";
do set $yyy; var=$2; eval "was=\$$2";
        eval "case \"\$$var\" in $define) . ./whoa; esac"; eval "$var=\$tu";
        set $yyy; shift; shift; yyy=$@;
done'

: see if stdlib is available
set stdlib.h i_stdlib
eval $inhdr

: check for lengths of integral types
echo " "
case "$intsize" in
'')
        echo "Checking to see how big your integers are..." >&4
        $cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
        printf("intsize=%d;\n", (int)sizeof(int));
        printf("longsize=%d;\n", (int)sizeof(long));
        printf("shortsize=%d;\n", (int)sizeof(short));
        exit(0);
}
EOCP
        set try
        if eval $compile_ok && $run ./try > /dev/null; then
                eval `$run ./try`
                echo "Your integers are $intsize bytes long."
                echo "Your long integers are $longsize bytes long."
                echo "Your short integers are $shortsize bytes long."
        else
                $cat >&4 <<EOM
!
Help! I can't compile and run the intsize test program: please enlighten me!
(This is probably a misconfiguration in your system or libraries, and
you really ought to fix it.  Still, I'll try anyway.)
!
EOM
                dflt=4
                rp="What is the size of an integer (in bytes)?"
                . ./myread
                intsize="$ans"
                dflt=$intsize
                rp="What is the size of a long integer (in bytes)?"
                . ./myread
                longsize="$ans"
                dflt=2
                rp="What is the size of a short integer (in bytes)?"
                . ./myread
                shortsize="$ans"
        fi
        ;;
esac
$rm -f try try.*

: check for long long
echo " "
echo "Checking to see if you have long long..." >&4
echo 'int main() { long long x = 7; return 0; }' > try.c
set try
if eval $compile; then
        val="$define"
        echo "You have long long."
else
        val="$undef"
        echo "You do not have long long."
fi
$rm try.*
set d_longlong
eval $setvar

: check for length of long long
case "${d_longlong}${longlongsize}" in
$define)
        echo " "
        echo "Checking to see how big your long longs are..." >&4
        $cat >try.c <<'EOCP'
#include <stdio.h>
int main()
{
    printf("%d\n", (int)sizeof(long long));
    return(0);
}
EOCP
        set try
        if eval $compile_ok; then
                longlongsize=`$run ./try`
                echo "Your long longs are $longlongsize bytes long."
        else
                dflt='8'
                echo " "
                echo "(I can't seem to compile the test program.  Guessing...)"
                rp="What is the size of a long long (in bytes)?"
                . ./myread
                longlongsize="$ans"
        fi
        if $test "X$longsize" = "X$longlongsize"; then
                echo "(That isn't any different from an ordinary long.)"
        fi
        ;;
esac
$rm -f try.* try

: see if inttypes.h is available
: we want a real compile instead of Inhdr because some systems
: have an inttypes.h which includes non-existent headers
echo " "
$cat >try.c <<EOCP
#include <inttypes.h>
int main() {
        static int32_t foo32 = 0x12345678;
}
EOCP
set try
if eval $compile; then
        echo "<inttypes.h> found." >&4
        val="$define"
else
        echo "<inttypes.h> NOT found." >&4
        val="$undef"
fi
$rm -f try.c try
set i_inttypes
eval $setvar

: check for int64_t
echo " "
echo "Checking to see if you have int64_t..." >&4
$cat >try.c <<EOCP
#include <sys/types.h>
#$i_inttypes I_INTTYPES
#ifdef I_INTTYPES
#include <inttypes.h>
#endif
int main() { int64_t x = 7; }
EOCP
set try
if eval $compile; then
        val="$define"
        echo "You have int64_t."
else
        val="$undef"
        echo "You do not have int64_t."
fi
$rm -f try try.*
set d_int64_t
eval $setvar


echo " "
echo "Checking which 64-bit integer type we could use..." >&4

case "$intsize" in
8) val=int
   set quadtype
   eval $setvar
   val='"unsigned int"'
   set uquadtype
   eval $setvar
   quadkind=1
   ;;
*) case "$longsize" in
   8) val=long
      set quadtype
      eval $setvar
      val='"unsigned long"'
      set uquadtype
      eval $setvar
      quadkind=2
      ;;
   *) case "$d_longlong:$longlongsize" in
      define:8)
        val='"long long"'
        set quadtype
        eval $setvar
        val='"unsigned long long"'
        set uquadtype
        eval $setvar
        quadkind=3
        ;;
      *) case "$d_int64_t" in
         define)
           val=int64_t
           set quadtype
           eval $setvar
           val=uint64_t
           set uquadtype
           eval $setvar
           quadkind=4
           ;;
         esac
         ;;
      esac
      ;;
   esac
   ;;
esac

case "$quadtype" in
'')     echo "Alas, no 64-bit integer types in sight." >&4
        d_quad="$undef"
        ;;
*)      echo "We could use '$quadtype' for 64-bit integers." >&4
        d_quad="$define"
        ;;
esac


case "$uselonglong" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** Configure -Duselonglong is deprecated, using -Duse64bitint instead.
EOM
        use64bitint="$define"
        ;;
esac
case "$use64bits" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** Configure -Duse64bits is deprecated, using -Duse64bitint instead.
EOM
        use64bitint="$define"
        ;;
esac
case "$use64bitints" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** There is no Configure -Duse64bitints, using -Duse64bitint instead.
EOM
        use64bitint="$define"
        ;;
esac
case "$use64bitsint" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** There is no Configure -Duse64bitsint, using -Duse64bitint instead.
EOM
        use64bitint="$define"
        ;;
esac
case "$uselonglongs" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** There is no Configure -Duselonglongs, using -Duse64bitint instead.
EOM
        use64bitint="$define"
        ;;
esac
case "$use64bitsall" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** There is no Configure -Duse64bitsall, using -Duse64bitall instead.
EOM
        use64bitall="$define"
        ;;
esac

case "$ccflags" in
*-DUSE_LONG_LONG*|*-DUSE_64_BIT_INT*|*-DUSE_64_BIT_ALL*) use64bitint="$define";;
esac
case "$use64bitall" in
"$define"|true|[yY]*) use64bitint="$define" ;;
esac

case "$longsize" in
8) cat <<EOM

You have natively 64-bit long integers.
EOM
   val="$define"
   ;;
*) case "$use64bitint" in
   "$define"|true|[yY]*) dflt='y';;
   *) dflt='n';;
   esac
   case "$d_quad" in
   "$define") ;;
   *) dflt='n' ;;
   esac
   cat <<EOM

Perl can be built to take advantage of 64-bit integer types
on some systems.  To do so, Configure can be run with -Duse64bitint.
Choosing this option will most probably introduce binary incompatibilities.

If this doesn't make any sense to you, just accept the default '$dflt'.
(The default has been chosen based on your configuration.)
EOM
   rp='Try to use 64-bit integers, if available?'
   . ./myread
   case "$ans" in
   [yY]*) val="$define" ;;
   *)     val="$undef"  ;;
   esac
   ;;
esac
set use64bitint
eval $setvar

case "$use64bitall" in
"$define"|true|[yY]*) dflt='y' ;;
*) case "$longsize" in
   8) dflt='y' ;;
   *) dflt='n' ;;
   esac
   ;;
esac
cat <<EOM

You may also choose to try maximal 64-bitness.  It means using as much
64-bitness as possible on the platform.  This in turn means even more
binary incompatibilities.  On the other hand, your platform may not
have any more 64-bitness available than what you already have chosen.

If this doesn't make any sense to you, just accept the default '$dflt'.
(The default has been chosen based on your configuration.)
EOM
rp='Try to use maximal 64-bit support, if available?'
. ./myread
case "$ans" in
[yY]*) val="$define" ;;
*)     val="$undef"  ;;
esac
set use64bitall
eval $setvar
case "$use64bitall" in
"$define")
        case "$use64bitint" in
        "$undef")
                cat <<EOM

Since you have chosen a maximally 64-bit build, I'm also turning on
the use of 64-bit integers.
EOM
                use64bitint="$define" ;;
        esac
        ;;
esac

: Look for a hint-file generated 'call-back-unit'.  If the
: user has specified that a 64-bit perl is to be built,
: we may need to set or change some other defaults.
if $test -f use64bitint.cbu; then
        echo "Your platform has some specific hints regarding 64-bit integers, using them..."
        . ./use64bitint.cbu
fi
case "$use64bitint" in
"$define"|true|[yY]*)
        case "$longsize" in
        4) case "$archname64" in
           '') archname64=64int ;;
           esac
           ;;
        esac
        ;;
esac

: Look for a hint-file generated 'call-back-unit'.  If the
: user has specified that a maximally 64-bit perl is to be built,
: we may need to set or change some other defaults.
if $test -f use64bitall.cbu; then
        echo "Your platform has some specific hints regarding 64-bit builds, using them..."
        . ./use64bitall.cbu
fi
case "$use64bitall" in
"$define"|true|[yY]*)
        case "$longsize" in
        4) case "$archname64" in
           ''|64int) archname64=64all ;;
           esac
           ;;
        esac
        ;;
esac

case "$d_quad:$use64bitint" in
$undef:$define)
        cat >&4 <<EOF

*** You have chosen to use 64-bit integers,
*** but none can be found.
*** Please rerun Configure without -Duse64bitint and/or -Dusemorebits.
*** Cannot continue, aborting.

EOF
        exit 1
        ;;
esac

: check for length of double
echo " "
case "$doublesize" in
'')
        echo "Checking to see how big your double precision numbers are..." >&4
        $cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
    printf("%d\n", (int)sizeof(double));
    exit(0);
}
EOCP
        set try
        if eval $compile_ok; then
                doublesize=`$run ./try`
                echo "Your double is $doublesize bytes long."
        else
                dflt='8'
                echo "(I can't seem to compile the test program.  Guessing...)"
                rp="What is the size of a double precision number (in bytes)?"
                . ./myread
                doublesize="$ans"
        fi
        ;;
esac
$rm -f try.c try

: check for long doubles
echo " "
echo "Checking to see if you have long double..." >&4
echo 'int main() { long double x = 7.0; }' > try.c
set try
if eval $compile; then
        val="$define"
        echo "You have long double."
else
        val="$undef"
        echo "You do not have long double."
fi
$rm try.*
set d_longdbl
eval $setvar

: check for length of long double
case "${d_longdbl}${longdblsize}" in
$define)
        echo " "
        echo "Checking to see how big your long doubles are..." >&4
        $cat >try.c <<'EOCP'
#include <stdio.h>
int main()
{
        printf("%d\n", sizeof(long double));
}
EOCP
        set try
        set try
        if eval $compile; then
                longdblsize=`$run ./try`
                echo "Your long doubles are $longdblsize bytes long."
        else
                dflt='8'
                echo " "
                echo "(I can't seem to compile the test program.  Guessing...)" >&4
                rp="What is the size of a long double (in bytes)?"
                . ./myread
                longdblsize="$ans"
        fi
        if $test "X$doublesize" = "X$longdblsize"; then
                echo "That isn't any different from an ordinary double."
                echo "I'll keep your setting anyway, but you may see some"
                echo "harmless compilation warnings."
        fi
        ;;
esac
$rm -f try.* try

: determine the architecture name
echo " "
if xxx=`./loc arch blurfl $pth`; $test -f "$xxx"; then
        tarch=`arch`"-$osname"
elif xxx=`./loc uname blurfl $pth`; $test -f "$xxx" ; then
        if uname -m > tmparch 2>&1 ; then
                tarch=`$sed -e 's/ *$//' -e 's/ /_/g' \
                        -e 's/$/'"-$osname/" tmparch`
        else
                tarch="$osname"
        fi
        $rm -f tmparch
else
        tarch="$osname"
fi
case "$myarchname" in
''|"$tarch") ;;
*)
        echo "(Your architecture name used to be $myarchname.)"
        archname=''
        ;;
esac
case "$targetarch" in
'') ;;
*)  archname=`echo $targetarch|sed 's,^[^-]*-,,'` ;;
esac
myarchname="$tarch"
case "$archname" in
'') dflt="$tarch";;
*) dflt="$archname";;
esac
rp='What is your architecture name'
. ./myread
archname="$ans"
case "$usethreads" in
$define)
        echo "Threads selected." >&4
        case "$archname" in
        *-thread*) echo "...and architecture name already has -thread." >&4
                ;;
        *)      archname="$archname-thread"
                echo "...setting architecture name to $archname." >&4
                ;;
        esac
        ;;
esac
case "$usemultiplicity" in
$define)
        echo "Multiplicity selected." >&4
        case "$archname" in
        *-multi*) echo "...and architecture name already has -multi." >&4
                ;;
        *)      archname="$archname-multi"
                echo "...setting architecture name to $archname." >&4
                ;;
        esac
        ;;
esac
case "$use64bitint$use64bitall" in
*"$define"*)
        case "$archname64" in
        '')
                echo "This architecture is naturally 64-bit, not changing architecture name." >&4
                ;;
        *)
                case "$use64bitint" in
                "$define") echo "64 bit integers selected." >&4 ;;
                esac
                case "$use64bitall" in
                "$define") echo "Maximal 64 bitness selected." >&4 ;;
                esac
                case "$archname" in
                *-$archname64*) echo "...and architecture name already has $archname64." >&4
                        ;;
                *)      archname="$archname-$archname64"
                        echo "...setting architecture name to $archname." >&4
                        ;;
                esac
                ;;
        esac
esac
case "$uselongdouble" in
$define)
        echo "Long doubles selected." >&4
        case "$longdblsize" in
        $doublesize)
                echo "...but long doubles are equal to doubles, not changing architecture name." >&4
                ;;
        *)
                case "$archname" in
                *-ld*) echo "...and architecture name already has -ld." >&4
                        ;;
                *)      archname="$archname-ld"
                        echo "...setting architecture name to $archname." >&4
                        ;;
                esac
                ;;
        esac
        ;;
esac
case "$useperlio" in
$define)
        echo "Perlio selected." >&4
        ;;
*)
        echo "Perlio not selected, using stdio." >&4
        case "$archname" in
        *-stdio*) echo "...and architecture name already has -stdio." >&4
                ;;
        *)      archname="$archname-stdio"
                echo "...setting architecture name to $archname." >&4
                ;;
        esac
        ;;
esac
if $test -f archname.cbu; then
        echo "Your platform has some specific hints for architecture name, using them..."
        . ./archname.cbu
fi

: determine root of directory hierarchy where package will be installed.
case "$prefix" in
'')
        dflt=`./loc . /usr/local /usr/local /local /opt /usr`
        ;;
*?/)
        dflt=`echo "$prefix" | sed 's/.$//'`
        ;;
*)
        dflt="$prefix"
        ;;
esac
$cat <<EOM

By default, $package will be installed in $dflt/bin, manual pages
under $dflt/man, etc..., i.e. with $dflt as prefix for all
installation directories. Typically this is something like /usr/local.
If you wish to have binaries under /usr/bin but other parts of the
installation under /usr/local, that's ok: you will be prompted
separately for each of the installation directories, the prefix being
only used to set the defaults.

EOM
fn=d~
rp='Installation prefix to use?'
. ./getfile
oldprefix=''
case "$prefix" in
'') ;;
*)
        case "$ans" in
        "$prefix") ;;
        *) oldprefix="$prefix";;
        esac
        ;;
esac
prefix="$ans"
prefixexp="$ansexp"

case "$afsroot" in
'')     afsroot=/afs ;;
*)      afsroot=$afsroot ;;
esac

: is AFS running?
echo " "
case "$afs" in
$define|true)   afs=true ;;
$undef|false)   afs=false ;;
*)      if test -d $afsroot; then
                afs=true
        else
                afs=false
        fi
        ;;
esac
if $afs; then
        echo "AFS may be running... I'll be extra cautious then..." >&4
else
        echo "AFS does not seem to be running..." >&4
fi

: determine installation prefix for where package is to be installed.
if $afs; then
$cat <<EOM

Since you are running AFS, I need to distinguish the directory in which
files will reside from the directory in which they are installed (and from
which they are presumably copied to the former directory by occult means).

EOM
        case "$installprefix" in
        '') dflt=`echo $prefix | sed 's#^/afs/#/afs/.#'`;;
        *) dflt="$installprefix";;
        esac
else
$cat <<EOM

In some special cases, particularly when building $package for distribution,
it is convenient to distinguish the directory in which files should be
installed from the directory ($prefix) in which they will
eventually reside.  For most users, these two directories are the same.

EOM
        case "$installprefix" in
        '') dflt=$prefix ;;
        *) dflt=$installprefix;;
        esac
fi
fn=d~
rp='What installation prefix should I use for installing files?'
. ./getfile
installprefix="$ans"
installprefixexp="$ansexp"

: set the prefixit variable, to compute a suitable default value
prefixit='case "$3" in
""|none)
        case "$oldprefix" in
        "") eval "$1=\"\$$2\"";;
        *)
                case "$3" in
                "") eval "$1=";;
                none)
                        eval "tp=\"\$$2\"";
                        case "$tp" in
                        ""|" ") eval "$1=\"\$$2\"";;
                        *) eval "$1=";;
                        esac;;
                esac;;
        esac;;
*)
        eval "tp=\"$oldprefix-\$$2-\""; eval "tp=\"$tp\"";
        case "$tp" in
        --|/*--|\~*--) eval "$1=\"$prefix/$3\"";;
        /*-$oldprefix/*|\~*-$oldprefix/*)
                eval "$1=\`echo \$$2 | sed \"s,^$oldprefix,$prefix,\"\`";;
        *) eval "$1=\"\$$2\"";;
        esac;;
esac'

: get the patchlevel
echo " "
echo "Getting the current patchlevel..." >&4
if $test -r $rsrc/patchlevel.h;then
        revision=`awk '/define[         ]+PERL_REVISION/ {print $3}' $rsrc/patchlevel.h`
        patchlevel=`awk '/define[       ]+PERL_VERSION/ {print $3}' $rsrc/patchlevel.h`
        subversion=`awk '/define[       ]+PERL_SUBVERSION/ {print $3}' $rsrc/patchlevel.h`
        api_revision=`awk '/define[     ]+PERL_API_REVISION/ {print $3}' $rsrc/patchlevel.h`
        api_version=`awk '/define[      ]+PERL_API_VERSION/ {print $3}' $rsrc/patchlevel.h`
        api_subversion=`awk '/define[   ]+PERL_API_SUBVERSION/ {print $3}' $rsrc/patchlevel.h`
       perl_patchlevel=`grep ',"DEVEL[0-9][0-9]*"' $rsrc/patchlevel.h|sed 's/[^0-9]//g'`
else
        revision=0
        patchlevel=0
        subversion=0
        api_revision=0
        api_version=0
        api_subversion=0
        perl_patchlevel=0
        $echo "(You do not have patchlevel.h.  Eek.)"
fi
if $test -r $rsrc/.patch ; then
        if $test "`cat $rsrc/.patch`" -gt "$perl_patchlevel" ; then
                perl_patchlevel=`cat $rsrc/.patch`
        fi
fi
: Define a handy string here to avoid duplication in myconfig.SH and configpm.
version_patchlevel_string="version $patchlevel subversion $subversion"
case "$perl_patchlevel" in
0|'') ;;
*) version_patchlevel_string="$version_patchlevel_string patch $perl_patchlevel" ;;
esac

$echo "(You have $package $version_patchlevel_string.)"

case "$osname" in
dos|vms)
        : XXX Should be a Configure test for double-dots in filenames.
        version=`echo $revision $patchlevel $subversion | \
                 $awk '{ printf "%d_%d_%d\n", $1, $2, $3 }'`
        api_versionstring=`echo $api_revision $api_version $api_subversion | \
                 $awk '{ printf "%d_%d_%d\n", $1, $2, $3 }'`
        ;;
*)
        version=`echo $revision $patchlevel $subversion | \
                 $awk '{ printf "%d.%d.%d\n", $1, $2, $3 }'`
        api_versionstring=`echo $api_revision $api_version $api_subversion | \
                 $awk '{ printf "%d.%d.%d\n", $1, $2, $3 }'`
        ;;
esac
: Special case the 5.005_xx maintenance series, which used 5.005
: without any subversion label as a subdirectory in $sitelib
if test "${api_revision}${api_version}${api_subversion}" = "550"; then
        api_versionstring='5.005'
fi

: determine installation style
: For now, try to deduce it from prefix unless it is already set.
: Reproduce behavior of 5.005 and earlier, maybe drop that in 5.7.
case "$installstyle" in
'')     case "$prefix" in
                *perl*) dflt='lib';;
                *) dflt='lib/perl5' ;;
        esac
        ;;
*)      dflt="$installstyle" ;;
esac
: Probably not worth prompting for this since we prompt for all
: the directories individually, and the prompt would be too long and
: confusing anyway.
installstyle=$dflt

: determine where private library files go
: Usual default is /usr/local/lib/perl5/$version.
: Also allow things like /opt/perl/lib/$version, since
: /opt/perl/lib/perl5... would be redundant.
: The default "style" setting is made in installstyle.U
case "$installstyle" in
*lib/perl5*) set dflt privlib lib/$package/$version ;;
*)       set dflt privlib lib/$version ;;
esac
eval $prefixit
$cat <<EOM

There are some auxiliary files for $package that need to be put into a
private library directory that is accessible by everyone.

EOM
fn=d~+
rp='Pathname where the private library files will reside?'
. ./getfile
privlib="$ans"
privlibexp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installprivlib=`echo $privlibexp | sed "s#^$prefix#$installprefix#"`
else
        installprivlib="$privlibexp"
fi

: set the prefixup variable, to restore leading tilda escape
prefixup='case "$prefixexp" in
"$prefix") ;;
*) eval "$1=\`echo \$$1 | sed \"s,^$prefixexp,$prefix,\"\`";;
esac'

: determine where public architecture dependent libraries go
set archlib archlib
eval $prefixit
: privlib default is /usr/local/lib/$package/$version
: archlib default is /usr/local/lib/$package/$version/$archname
: privlib may have an optional trailing /share.
tdflt=`echo $privlib | $sed 's,/share$,,'`
tdflt=$tdflt/$archname
case "$archlib" in
'')     dflt=$tdflt
        ;;
*)      dflt="$archlib"
    ;;
esac
$cat <<EOM

$spackage contains architecture-dependent library files.  If you are
sharing libraries in a heterogeneous environment, you might store
these files in a separate location.  Otherwise, you can just include
them with the rest of the public library files.

EOM
fn=d+~
rp='Where do you want to put the public architecture-dependent libraries?'
. ./getfile
archlib="$ans"
archlibexp="$ansexp"
if $test X"$archlib" = X"$privlib"; then
        d_archlib="$undef"
else
        d_archlib="$define"
fi
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installarchlib=`echo $archlibexp | sed "s#^$prefix#$installprefix#"`
else
        installarchlib="$archlibexp"
fi

: see if setuid scripts can be secure
$cat <<EOM

Some kernels have a bug that prevents setuid #! scripts from being
secure.  Some sites have disabled setuid #! scripts because of this.

First let's decide if your kernel supports secure setuid #! scripts.
(If setuid #! scripts would be secure but have been disabled anyway,
don't say that they are secure if asked.)

EOM

val="$undef"
if $test -d /dev/fd; then
        echo "#!$ls" >reflect
        chmod +x,u+s reflect
        ./reflect >flect 2>&1
        if $contains "/dev/fd" flect >/dev/null; then
                echo "Congratulations, your kernel has secure setuid scripts!" >&4
                val="$define"
        else
                $cat <<EOM
If you are not sure if they are secure, I can check but I'll need a
username and password different from the one you are using right now.
If you don't have such a username or don't want me to test, simply
enter 'none'.

EOM
                rp='Other username to test security of setuid scripts with?'
                dflt='none'
                . ./myread
                case "$ans" in
                n|none)
                        case "$d_suidsafe" in
                        '')     echo "I'll assume setuid scripts are *not* secure." >&4
                                dflt=n;;
                        "$undef")
                                echo "Well, the $hint value is *not* secure." >&4
                                dflt=n;;
                        *)      echo "Well, the $hint value *is* secure." >&4
                                dflt=y;;
                        esac
                        ;;
                *)
                        $rm -f reflect flect
                        echo "#!$ls" >reflect
                        chmod +x,u+s reflect
                        echo >flect
                        chmod a+w flect
                        echo '"su" will (probably) prompt you for '"$ans's password."
                        su $ans -c './reflect >flect'
                        if $contains "/dev/fd" flect >/dev/null; then
                                echo "Okay, it looks like setuid scripts are secure." >&4
                                dflt=y
                        else
                                echo "I don't think setuid scripts are secure." >&4
                                dflt=n
                        fi
                        ;;
                esac
                rp='Does your kernel have *secure* setuid scripts?'
                . ./myread
                case "$ans" in
                [yY]*)  val="$define";;
                *)      val="$undef";;
                esac
        fi
else
        echo "I don't think setuid scripts are secure (no /dev/fd directory)." >&4
        echo "(That's for file descriptors, not floppy disks.)"
        val="$undef"
fi
set d_suidsafe
eval $setvar

$rm -f reflect flect

: now see if they want to do setuid emulation
echo " "
val="$undef"
case "$d_suidsafe" in
"$define")
        val="$undef"
        echo "No need to emulate SUID scripts since they are secure here." >&4
        ;;
*)
        $cat <<EOM
Some systems have disabled setuid scripts, especially systems where
setuid scripts cannot be secure.  On systems where setuid scripts have
been disabled, the setuid/setgid bits on scripts are currently
useless.  It is possible for $package to detect those bits and emulate
setuid/setgid in a secure fashion.  This emulation will only work if
setuid scripts have been disabled in your kernel.

EOM
        case "$d_dosuid" in
        "$define") dflt=y ;;
        *) dflt=n ;;
        esac
        rp="Do you want to do setuid/setgid emulation?"
        . ./myread
        case "$ans" in
        [yY]*)  val="$define";;
        *)      val="$undef";;
        esac
        ;;
esac
set d_dosuid
eval $setvar

: see if this is a malloc.h system
: we want a real compile instead of Inhdr because some systems have a
: malloc.h that just gives a compile error saying to use stdlib.h instead
echo " "
$cat >try.c <<EOCP
#include <stdlib.h>
#include <malloc.h>
int main () { return 0; }
EOCP
set try
if eval $compile; then
    echo "<malloc.h> found." >&4
    val="$define"
else
    echo "<malloc.h> NOT found." >&4
    val="$undef"
fi
$rm -f try.c try
set i_malloc
eval $setvar

: check for void type
echo " "
echo "Checking to see how well your C compiler groks the void type..." >&4
case "$voidflags" in
'')
        $cat >try.c <<EOCP
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#if TRY & 1
void sub() {
#else
sub() {
#endif
        extern void moo();      /* function returning void */
        void (*goo)();          /* ptr to func returning void */
#if TRY & 8
        void *hue;              /* generic ptr */
#endif
#if TRY & 2
        void (*foo[10])();
#endif

#if TRY & 4
        if(goo == moo) {
                exit(0);
        }
#endif
        exit(0);
}
int main() { sub(); }
EOCP
        if $cc $ccflags -c -DTRY=$defvoidused try.c >.out 2>&1 ; then
                voidflags=$defvoidused
        echo "Good.  It appears to support void to the level $package wants.">&4
                if $contains warning .out >/dev/null 2>&1; then
                        echo "However, you might get some warnings that look like this:"
                        $cat .out
                fi
        else
echo "Hmm, your compiler has some difficulty with void. Checking further..." >&4
                if $cc $ccflags -c -DTRY=1 try.c >/dev/null 2>&1; then
                        echo "It supports 1..."
                        if $cc $ccflags -c -DTRY=3 try.c >/dev/null 2>&1; then
                                echo "It also supports 2..."
                                if $cc $ccflags -c -DTRY=7 try.c >/dev/null 2>&1; then
                                        voidflags=7
                                        echo "And it supports 4 but not 8 definitely."
                                else
                                        echo "It doesn't support 4..."
                                        if $cc $ccflags -c -DTRY=11 try.c >/dev/null 2>&1; then
                                                voidflags=11
                                                echo "But it supports 8."
                                        else
                                                voidflags=3
                                                echo "Neither does it support 8."
                                        fi
                                fi
                        else
                                echo "It does not support 2..."
                                if $cc $ccflags -c -DTRY=13 try.c >/dev/null 2>&1; then
                                        voidflags=13
                                        echo "But it supports 4 and 8."
                                else
                                        if $cc $ccflags -c -DTRY=5 try.c >/dev/null 2>&1; then
                                                voidflags=5
                                                echo "And it supports 4 but has not heard about 8."
                                        else
                                                echo "However it supports 8 but not 4."
                                        fi
                                fi
                        fi
                else
                        echo "There is no support at all for void."
                        voidflags=0
                fi
        fi
esac
case "$voidflags" in
"$defvoidused") ;;
*)      $cat >&4 <<'EOM'
  Support flag bits are:
    1: basic void declarations.
    2: arrays of pointers to functions returning void.
    4: operations between pointers to and addresses of void functions.
    8: generic void pointers.
EOM
        dflt="$voidflags";
        rp="Your void support flags add up to what?"
        . ./myread
        voidflags="$ans"
        ;;
esac
$rm -f try.* .out

: check for length of pointer
echo " "
case "$ptrsize" in
'')
        echo "Checking to see how big your pointers are..." >&4
        if test "$voidflags" -gt 7; then
                echo '#define VOID_PTR char *' > try.c
        else
                echo '#define VOID_PTR void *' > try.c
        fi
        $cat >>try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
    printf("%d\n", (int)sizeof(VOID_PTR));
    exit(0);
}
EOCP
        set try
        if eval $compile_ok; then
                ptrsize=`$run ./try`
                echo "Your pointers are $ptrsize bytes long."
        else
                dflt='4'
                echo "(I can't seem to compile the test program.  Guessing...)" >&4
                rp="What is the size of a pointer (in bytes)?"
                . ./myread
                ptrsize="$ans"
        fi
        ;;
esac
$rm -f try.c try
case "$use64bitall" in
"$define"|true|[yY]*)
        case "$ptrsize" in
        4)      cat <<EOM >&4

*** You have chosen a maximally 64-bit build,
*** but your pointers are only 4 bytes wide.
*** Please rerun Configure without -Duse64bitall.
EOM
                case "$d_quad" in
                define)
                        cat <<EOM >&4
*** Since you have quads, you could possibly try with -Duse64bitint.
EOM
                        ;;
                esac
                cat <<EOM >&4
*** Cannot continue, aborting.

EOM

                exit 1
                ;;
        esac
        ;;
esac


: determine whether to use malloc wrapping
echo " "
case "$usemallocwrap" in
[yY]*|true|$define)     dflt='y' ;;
[nN]*|false|$undef)     dflt='n' ;;
*)      case "$usedevel" in
        [yY]*|true|$define)     dflt='y' ;;
        *) dflt='n' ;;
        esac
        ;;
esac
rp="Do you wish to wrap malloc calls to protect against potential overflows?"
. ./myread
usemallocwrap="$ans"
case "$ans" in
y*|true)
        usemallocwrap="$define" ;;
*)
        usemallocwrap="$undef" ;;
esac

: determine which malloc to compile in
echo " "
case "$usemymalloc" in
[yY]*|true|$define)     dflt='y' ;;
[nN]*|false|$undef)     dflt='n' ;;
*)      case "$ptrsize" in
        4) dflt='y' ;;
        *) dflt='n' ;;
        esac
        ;;
esac
rp="Do you wish to attempt to use the malloc that comes with $package?"
. ./myread
usemymalloc="$ans"
case "$ans" in
y*|true)
        usemymalloc='y'
        mallocsrc='malloc.c'
        mallocobj="malloc$_o"
        d_mymalloc="$define"
        case "$libs" in
        *-lmalloc*)
                : Remove malloc from list of libraries to use
                echo "Removing unneeded -lmalloc from library list" >&4
                set `echo X $libs | $sed -e 's/-lmalloc / /' -e 's/-lmalloc$//'`
                shift
                libs="$*"
                echo "libs = $libs" >&4
                ;;
        esac
        ;;
*)
        usemymalloc='n'
        mallocsrc=''
        mallocobj=''
        d_mymalloc="$undef"
        ;;
esac

: compute the return types of malloc and free
echo " "
$cat >malloc.c <<END
#$i_malloc I_MALLOC
#$i_stdlib I_STDLIB
#include <stdio.h>
#include <sys/types.h>
#ifdef I_MALLOC
#include <malloc.h>
#endif
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#ifdef TRY_MALLOC
void *malloc();
#endif
#ifdef TRY_FREE
void free();
#endif
END
case "$malloctype" in
'')
        if $cc $ccflags -c -DTRY_MALLOC malloc.c >/dev/null 2>&1; then
                malloctype='void *'
        else
                malloctype='char *'
        fi
        ;;
esac
echo "Your system wants malloc to return '$malloctype', it would seem." >&4

case "$freetype" in
'')
        if $cc $ccflags -c -DTRY_FREE malloc.c >/dev/null 2>&1; then
                freetype='void'
        else
                freetype='int'
        fi
        ;;
esac
echo "Your system uses $freetype free(), it would seem." >&4
$rm -f malloc.[co]
$cat <<EOM

After $package is installed, you may wish to install various
add-on modules and utilities.  Typically, these add-ons will
be installed under $prefix with the rest
of this package.  However, you may wish to install such add-ons
elsewhere under a different prefix.

If you do not wish to put everything under a single prefix, that's
ok.  You will be prompted for the individual locations; this siteprefix
is only used to suggest the defaults.

The default should be fine for most people.

EOM
fn=d~+
rp='Installation prefix to use for add-on modules and utilities?'
: XXX Here might be another good place for an installstyle setting.
case "$siteprefix" in
'') dflt=$prefix ;;
*)  dflt=$siteprefix ;;
esac
. ./getfile
: XXX Prefixit unit does not yet support siteprefix and vendorprefix
oldsiteprefix=''
case "$siteprefix" in
'') ;;
*)      case "$ans" in
        "$prefix") ;;
        *) oldsiteprefix="$prefix";;
        esac
        ;;
esac
siteprefix="$ans"
siteprefixexp="$ansexp"

: determine where site specific libraries go.
: Usual default is /usr/local/lib/perl5/site_perl/$version
: The default "style" setting is made in installstyle.U
: XXX No longer works with Prefixit stuff.
prog=`echo $package | $sed 's/-*[0-9.]*$//'`
case "$sitelib" in
'') case "$installstyle" in
        *lib/perl5*) dflt=$siteprefix/lib/$package/site_$prog/$version ;;
        *)       dflt=$siteprefix/lib/site_$prog/$version ;;
        esac
        ;;
*)      dflt="$sitelib"
        ;;
esac
$cat <<EOM

The installation process will create a directory for
site-specific extensions and modules.  Most users find it convenient
to place all site-specific files in this directory rather than in the
main distribution directory.

EOM
fn=d~+
rp='Pathname for the site-specific library files?'
. ./getfile
sitelib="$ans"
sitelibexp="$ansexp"
sitelib_stem=`echo "$sitelibexp" | sed "s,/$version$,,"`
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsitelib=`echo $sitelibexp | $sed "s#^$prefix#$installprefix#"`
else
        installsitelib="$sitelibexp"
fi

: determine where site specific architecture-dependent libraries go.
: sitelib  default is /usr/local/lib/perl5/site_perl/$version
: sitearch default is /usr/local/lib/perl5/site_perl/$version/$archname
: sitelib may have an optional trailing /share.
case "$sitearch" in
'')     dflt=`echo $sitelib | $sed 's,/share$,,'`
        dflt="$dflt/$archname"
        ;;
*)      dflt="$sitearch"
        ;;
esac
set sitearch sitearch none
eval $prefixit
$cat <<EOM

The installation process will also create a directory for
architecture-dependent site-specific extensions and modules.

EOM
fn=d~+
rp='Pathname for the site-specific architecture-dependent library files?'
. ./getfile
sitearch="$ans"
sitearchexp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsitearch=`echo $sitearchexp | sed "s#^$prefix#$installprefix#"`
else
        installsitearch="$sitearchexp"
fi

$cat <<EOM

The installation process will also create a directory for
vendor-supplied add-ons.  Vendors who supply perl with their system
may find it convenient to place all vendor-supplied files in this
directory rather than in the main distribution directory.  This will
ease upgrades between binary-compatible maintenance versions of perl.

Of course you may also use these directories in whatever way you see
fit.  For example, you might use them to access modules shared over a
company-wide network.

The default answer should be fine for most people.
This causes further questions about vendor add-ons to be skipped
and no vendor-specific directories will be configured for perl.

EOM
rp='Do you want to configure vendor-specific add-on directories?'
case "$usevendorprefix" in
define|true|[yY]*) dflt=y ;;
*)      : User may have set vendorprefix directly on Configure command line.
        case "$vendorprefix" in
        ''|' ') dflt=n ;;
        *)      dflt=y ;;
        esac
        ;;
esac
. ./myread
case "$ans" in
[yY]*)  fn=d~+
        rp='Installation prefix to use for vendor-supplied add-ons?'
        case "$vendorprefix" in
        '') dflt='' ;;
        *)  dflt=$vendorprefix ;;
        esac
        . ./getfile
        : XXX Prefixit unit does not yet support siteprefix and vendorprefix
        oldvendorprefix=''
        case "$vendorprefix" in
        '') ;;
        *)      case "$ans" in
                "$prefix") ;;
                *) oldvendorprefix="$prefix";;
                esac
                ;;
        esac
        usevendorprefix="$define"
        vendorprefix="$ans"
        vendorprefixexp="$ansexp"
        ;;
*)      usevendorprefix="$undef"
        vendorprefix=''
        vendorprefixexp=''
        ;;
esac

case "$vendorprefix" in
'')     d_vendorlib="$undef"
        vendorlib=''
        vendorlibexp=''
        ;;
*)      d_vendorlib="$define"
        : determine where vendor-supplied modules go.
        : Usual default is /usr/local/lib/perl5/vendor_perl/$version
        case "$vendorlib" in
        '')
                prog=`echo $package | $sed 's/-*[0-9.]*$//'`
                case "$installstyle" in
                *lib/perl5*) dflt=$vendorprefix/lib/$package/vendor_$prog/$version ;;
                *)           dflt=$vendorprefix/lib/vendor_$prog/$version ;;
                esac
                ;;
        *)      dflt="$vendorlib"
                ;;
        esac
        fn=d~+
        rp='Pathname for the vendor-supplied library files?'
        . ./getfile
        vendorlib="$ans"
        vendorlibexp="$ansexp"
        ;;
esac
vendorlib_stem=`echo "$vendorlibexp" | sed "s,/$version$,,"`
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorlib=`echo $vendorlibexp | $sed "s#^$prefix#$installprefix#"`
else
        installvendorlib="$vendorlibexp"
fi

case "$vendorprefix" in
'')     d_vendorarch="$undef"
        vendorarch=''
        vendorarchexp=''
        ;;
*)      d_vendorarch="$define"
        : determine where vendor-supplied architecture-dependent libraries go.
        : vendorlib  default is /usr/local/lib/perl5/vendor_perl/$version
        : vendorarch default is /usr/local/lib/perl5/vendor_perl/$version/$archname
        : vendorlib may have an optional trailing /share.
        case "$vendorarch" in
        '')     dflt=`echo $vendorlib | $sed 's,/share$,,'`
                dflt="$dflt/$archname"
                ;;
        *)      dflt="$vendorarch" ;;
        esac
        fn=d~+
        rp='Pathname for vendor-supplied architecture-dependent files?'
        . ./getfile
        vendorarch="$ans"
        vendorarchexp="$ansexp"
        ;;
esac
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorarch=`echo $vendorarchexp | sed "s#^$prefix#$installprefix#"`
else
        installvendorarch="$vendorarchexp"
fi

: Final catch-all directories to search
$cat <<EOM

Lastly, you can have perl look in other directories for extensions and
modules in addition to those already specified.
These directories will be searched after
        $sitearch
        $sitelib
EOM
test X"$vendorlib" != "X" && echo '     ' $vendorlib
test X"$vendorarch" != "X" && echo '    ' $vendorarch
echo ' '
case "$otherlibdirs" in
''|' ') dflt='none' ;;
*)      dflt="$otherlibdirs" ;;
esac
$cat <<EOM
Enter a colon-separated set of extra paths to include in perl's @INC
search path, or enter 'none' for no extra paths.

EOM

rp='Colon-separated list of additional directories for perl to search?'
. ./myread
case "$ans" in
' '|''|none)    otherlibdirs=' ' ;;
*)      otherlibdirs="$ans" ;;
esac
case "$otherlibdirs" in
' ') val=$undef ;;
*)      val=$define ;;
esac
set d_perl_otherlibdirs
eval $setvar

: Cruising for prototypes
echo " "
echo "Checking out function prototypes..." >&4
$cat >prototype.c <<EOCP
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main(int argc, char *argv[]) {
        exit(0);}
EOCP
if $cc $ccflags -c prototype.c >prototype.out 2>&1 ; then
        echo "Your C compiler appears to support function prototypes."
        val="$define"
else
        echo "Your C compiler doesn't seem to understand function prototypes."
        val="$undef"
fi
set prototype
eval $setvar
$rm -f prototype*

case "$prototype" in
"$define") ;;
*)      ansi2knr='ansi2knr'
        echo " "
        cat <<EOM >&4

$me:  FATAL ERROR:
This version of $package can only be compiled by a compiler that
understands function prototypes.  Unfortunately, your C compiler
        $cc $ccflags
doesn't seem to understand them.  Sorry about that.

If GNU cc is available for your system, perhaps you could try that instead.

Eventually, we hope to support building Perl with pre-ANSI compilers.
If you would like to help in that effort, please contact <perlbug@perl.org>.

Aborting Configure now.
EOM
        exit 2
        ;;
esac

: determine where public executables go
echo " "
set dflt bin bin
eval $prefixit
fn=d~
rp='Pathname where the public executables will reside?'
. ./getfile
if $test "X$ansexp" != "X$binexp"; then
        installbin=''
fi
bin="$ans"
binexp="$ansexp"
: Change installation prefix, if necessary.
: XXX Bug? -- ignores Configure -Dinstallprefix setting.
if $test X"$prefix" != X"$installprefix"; then
        installbin=`echo $binexp | sed "s#^$prefix#$installprefix#"`
else
        installbin="$binexp"
fi

echo " "
case "$extras" in
'') dflt='n';;
*) dflt='y';;
esac
cat <<EOM
Perl can be built with extra modules or bundles of modules which
will be fetched from the CPAN and installed alongside Perl.

Notice that you will need access to the CPAN; either via the Internet,
or a local copy, for example a CD-ROM or a local CPAN mirror.  (You will
be asked later to configure the CPAN.pm module which will in turn do
the installation of the rest of the extra modules or bundles.)

Notice also that if the modules require any external software such as
libraries and headers (the libz library and the zlib.h header for the
Compress::Zlib module, for example) you MUST have any such software
already installed, this configuration process will NOT install such
things for you.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
rp='Install any extra modules (y or n)?'
. ./myread
case "$ans" in
y|Y)
        cat <<EOM

Please list any extra modules or bundles to be installed from CPAN,
with spaces between the names.  The names can be in any format the
'install' command of CPAN.pm will understand.  (Answer 'none',
without the quotes, to install no extra modules or bundles.)
EOM
        rp='Extras?'
        dflt="$extras"
        . ./myread
        extras="$ans"
esac
case "$extras" in
''|'none')
        val=''
        $rm -f ../extras.lst
        ;;
*)      echo "(Saving the list of extras for later...)"
        echo "$extras" > ../extras.lst
        val="'$extras'"
        ;;
esac
set extras
eval $setvar
echo " "

: determine where html pages for programs go
set html1dir html1dir none
eval $prefixit
$cat <<EOM

If you wish to install html files for programs in $spackage, indicate
the appropriate directory here.  To skip installing html files,
answer "none".
EOM
case "$html1dir" in
''|none|$undef|' ') dflt=none ;;
*) dflt=$html1dir ;;
esac
fn=dn+~
rp="Directory for the main $spackage html pages?"
. ./getfile
html1dir="$ans"
html1direxp="$ansexp"
: Use ' ' for none so value is preserved next time through Configure
$test X"$html1dir" = "X" && html1dir=' '
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installhtml1dir=`echo $html1direxp | sed "s#^$prefix#$installprefix#"`
else
        installhtml1dir="$html1direxp"
fi

: determine where html pages for libraries and modules go
set html3dir html3dir none
eval $prefixit
$cat <<EOM

If you wish to install html files for modules associated with $spackage,
indicate the appropriate directory here.  To skip installing html files,
answer "none".
EOM
: There is no obvious default.  If they have specified html1dir, then
: try to key off that, possibly changing .../html1 into .../html3.
case "$html3dir" in
'') html3dir=`echo "$html1dir" | $sed 's/1$/3$/'` ;;
*) dflt=$html3dir ;;
esac
fn=dn+~
rp="Directory for the $spackage module html pages?"
. ./getfile
html3dir="$ans"
html3direxp="$ansexp"
: Use ' ' for none so value is preserved next time through Configure
$test X"$html3dir" = "X" && html3dir=' '
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installhtml3dir=`echo $html3direxp | sed "s#^$prefix#$installprefix#"`
else
        installhtml3dir="$html3direxp"
fi

: Find perl5.005 or later.
echo "Looking for a previously installed perl5.005 or later... "
case "$perl5" in
'')     for tdir in `echo "$binexp$path_sep$PATH" | $sed "s/$path_sep/ /g"`; do
                : Check if this perl is recent and can load a simple module
                if $test -x $tdir/perl$exe_ext && $tdir/perl -Mless -e 'use 5.005;' >/dev/null 2>&1; then
                        perl5=$tdir/perl
                        break;
                elif $test -x $tdir/perl5$exe_ext && $tdir/perl5 -Mless -e 'use 5.005;' >/dev/null 2>&1; then
                        perl5=$tdir/perl5
                        break;
                fi
        done
        ;;
*)      perl5="$perl5"
        ;;
esac
case "$perl5" in
'')     echo "None found.  That's ok.";;
*)      echo "Using $perl5." ;;
esac

: Determine list of previous versions to include in @INC
$cat > getverlist <<EOPL
#!$perl5 -w
use File::Basename;
\$api_versionstring = "$api_versionstring";
\$version = "$version";
\$stem = "$sitelib_stem";
\$archname = "$archname";
EOPL
        $cat >> getverlist <<'EOPL'
# Can't have leading @ because metaconfig interprets it as a command!
;@inc_version_list=();
# XXX Redo to do opendir/readdir?
if (-d $stem) {
    chdir($stem);
    ;@candidates = glob("5.*");
}
else {
    ;@candidates = ();
}

# XXX ToDo:  These comparisons must be reworked when two-digit
# subversions come along, so that 5.7.10 compares as greater than
# 5.7.3!  By that time, hope that 5.6.x is sufficiently
# widespread that we can use the built-in version vectors rather
# than reinventing them here.  For 5.6.0, however, we must
# assume this script will likely be run by 5.005_0x.  --AD 1/2000.
foreach $d (@candidates) {
    if ($d lt $version) {
        if ($d ge $api_versionstring) {
            unshift(@inc_version_list, grep { -d } "$d/$archname", $d);
        }
        elsif ($d ge "5.005") {
            unshift(@inc_version_list, grep { -d } $d);
        }
    }
    else {
        # Skip newer version.  I.e. don't look in
        # 5.7.0 if we're installing 5.6.1.
    }
}

if (@inc_version_list) {
    print join(' ', @inc_version_list);
}
else {
    # Blank space to preserve value for next Configure run.
    print " ";
}
EOPL
chmod +x getverlist
case "$inc_version_list" in
'')     if test -x "$perl5$exe_ext"; then
                dflt=`$perl5 getverlist`
        else
                dflt='none'
        fi
        ;;
$undef) dflt='none' ;;
*)  eval dflt=\"$inc_version_list\" ;;
esac
case "$dflt" in
''|' ') dflt=none ;;
esac
case "$dflt" in
5.005) dflt=none ;;
esac
$cat <<EOM

In order to ease the process of upgrading, this version of perl
can be configured to use modules built and installed with earlier
versions of perl that were installed under $prefix.  Specify here
the list of earlier versions that this version of perl should check.
If Configure detected no earlier versions of perl installed under
$prefix, then the list will be empty.  Answer 'none' to tell perl
to not search earlier versions.

The default should almost always be sensible, so if you're not sure,
just accept the default.
EOM

rp='List of earlier versions to include in @INC?'
. ./myread
case "$ans" in
[Nn]one|''|' '|$undef) inc_version_list=' ' ;;
*) inc_version_list="$ans" ;;
esac
case "$inc_version_list" in
''|' ')
        inc_version_list_init='0';;
*)      inc_version_list_init=`echo $inc_version_list |
                $sed -e 's/^/"/' -e 's/ /","/g' -e 's/$/",0/'`
        ;;
esac
$rm -f getverlist

: determine whether to install perl also as /usr/bin/perl

echo " "
if $test -d /usr/bin -a "X$installbin" != X/usr/bin; then
        $cat <<EOM
Many scripts expect perl to be installed as /usr/bin/perl.

If you want to, I can install the perl you are about to compile
as /usr/bin/perl (in addition to $bin/perl).
EOM
        if test -f /usr/bin/perl; then
            $cat <<EOM

However, please note that because you already have a /usr/bin/perl,
overwriting that with a new Perl would very probably cause problems.
Therefore I'm assuming you don't want to do that (unless you insist).

EOM
            case "$installusrbinperl" in
            "$define"|[yY]*)    dflt='y';;
            *)                  dflt='n';;
            esac
        else
            $cat <<EOM

Since you don't have a /usr/bin/perl I'm assuming creating one is okay.

EOM
            case "$installusrbinperl" in
            "$undef"|[nN]*)     dflt='n';;
            *)                  dflt='y';;
            esac
        fi
        rp="Do you want to install perl as /usr/bin/perl?"
        . ./myread
        case "$ans" in
        [yY]*)  val="$define";;
        *)      val="$undef" ;;
        esac
else
        val="$undef"
fi
set installusrbinperl
eval $setvar

echo " "
echo "Checking for GNU C Library..." >&4
cat >try.c <<'EOCP'
/* Find out version of GNU C library.  __GLIBC__ and __GLIBC_MINOR__
   alone are insufficient to distinguish different versions, such as
   2.0.6 and 2.0.7.  The function gnu_get_libc_version() appeared in
   libc version 2.1.0.      A. Dougherty,  June 3, 2002.
*/
#include <stdio.h>
int main(void)
{
#ifdef __GLIBC__
#   ifdef __GLIBC_MINOR__
#       if __GLIBC__ >= 2 && __GLIBC_MINOR__ >= 1
#           include <gnu/libc-version.h>
            printf("%s\n",  gnu_get_libc_version());
#       else
            printf("%d.%d\n",  __GLIBC__, __GLIBC_MINOR__);
#       endif
#   else
        printf("%d\n",  __GLIBC__);
#   endif
    return 0;
#else
    return 1;
#endif
}
EOCP
set try
if eval $compile_ok && $run ./try > glibc.ver; then
        val="$define"
        gnulibc_version=`$cat glibc.ver`
        echo "You are using the GNU C Library version $gnulibc_version"
else
        val="$undef"
        gnulibc_version=''
        echo "You are not using the GNU C Library"
fi
$rm -f try try.* glibc.ver
set d_gnulibc
eval $setvar

: see if nm is to be used to determine whether a symbol is defined or not
case "$usenm" in
'')
        dflt=''
        case "$d_gnulibc" in
        "$define")
                echo " "
                echo "nm probably won't work on the GNU C Library." >&4
                dflt=n
                ;;
        esac
        case "$dflt" in
        '')
                if $test "$osname" = aix -a "X$PASE" != "Xdefine" -a ! -f /lib/syscalls.exp; then
                        echo " "
                        echo "Whoops!  This is an AIX system without /lib/syscalls.exp!" >&4
                        echo "'nm' won't be sufficient on this sytem." >&4
                        dflt=n
                fi
                ;;
        esac
        case "$dflt" in
        '') dflt=`$egrep 'inlibc|csym' $rsrc/Configure | wc -l 2>/dev/null`
                if $test $dflt -gt 20; then
                        dflt=y
                else
                        dflt=n
                fi
                ;;
        esac
        ;;
*)
        case "$usenm" in
        true|$define) dflt=y;;
        *) dflt=n;;
        esac
        ;;
esac
$cat <<EOM

I can use $nm to extract the symbols from your C libraries. This
is a time consuming task which may generate huge output on the disk (up
to 3 megabytes) but that should make the symbols extraction faster. The
alternative is to skip the 'nm' extraction part and to compile a small
test program instead to determine whether each symbol is present. If
you have a fast C compiler and/or if your 'nm' output cannot be parsed,
this may be the best solution.

You probably shouldn't let me use 'nm' if you are using the GNU C Library.

EOM
rp="Shall I use $nm to extract C symbols from the libraries?"
. ./myread
case "$ans" in
[Nn]*) usenm=false;;
*) usenm=true;;
esac

runnm=$usenm
case "$reuseval" in
true) runnm=false;;
esac

: nm options which may be necessary
case "$nm_opt" in
'') if $test -f /mach_boot; then
                nm_opt=''       # Mach
        elif $test -d /usr/ccs/lib; then
                nm_opt='-p'     # Solaris (and SunOS?)
        elif $test -f /dgux; then
                nm_opt='-p'     # DG-UX
        elif $test -f /lib64/rld; then
                nm_opt='-p'     # 64-bit Irix
        else
                nm_opt=''
        fi;;
esac

: nm options which may be necessary for shared libraries but illegal
: for archive libraries.  Thank you, Linux.
case "$nm_so_opt" in
'')     case "$myuname" in
        *linux*)
                if $nm --help | $grep 'dynamic' > /dev/null 2>&1; then
                        nm_so_opt='--dynamic'
                fi
                ;;
        esac
        ;;
esac

case "$runnm" in
true)
: get list of predefined functions in a handy place
echo " "
case "$libc" in
'') libc=unknown
        case "$libs" in
        *-lc_s*) libc=`./loc libc_s$_a $libc $libpth`
        esac
        ;;
esac
case "$libs" in
'') ;;
*)  for thislib in $libs; do
        case "$thislib" in
        -lc|-lc_s)
                : Handle C library specially below.
                ;;
        -l*)
                thislib=`echo $thislib | $sed -e 's/^-l//'`
                if try=`./loc lib$thislib.$so.'*' X $libpth`; $test -f "$try"; then
                        :
                elif try=`./loc lib$thislib.$so X $libpth`; $test -f "$try"; then
                        :
                elif try=`./loc lib$thislib$_a X $libpth`; $test -f "$try"; then
                        :
                elif try=`./loc $thislib$_a X $libpth`; $test -f "$try"; then
                        :
                elif try=`./loc lib$thislib X $libpth`; $test -f "$try"; then
                        :
                elif try=`./loc $thislib X $libpth`; $test -f "$try"; then
                        :
                elif try=`./loc Slib$thislib$_a X $xlibpth`; $test -f "$try"; then
                        :
                else
                        try=''
                fi
                libnames="$libnames $try"
                ;;
        *) libnames="$libnames $thislib" ;;
        esac
        done
        ;;
esac
xxx=normal
case "$libc" in
unknown)
        set /lib/libc.$so
        for xxx in $libpth; do
                $test -r $1 || set $xxx/libc.$so
                : The messy sed command sorts on library version numbers.
                $test -r $1 || \
                        set `echo blurfl; echo $xxx/libc.$so.[0-9]* | \
                        tr ' ' $trnl | egrep -v '\.[A-Za-z]*$' | $sed -e '
                                h
                                s/[0-9][0-9]*/0000&/g
                                s/0*\([0-9][0-9][0-9][0-9][0-9]\)/\1/g
                                G
                                s/\n/ /' | \
                         $sort | $sed -e 's/^.* //'`
                eval set \$$#
        done
        $test -r $1 || set /usr/ccs/lib/libc.$so
        $test -r $1 || set /lib/libsys_s$_a
        ;;
*)
        set blurfl
        ;;
esac
if $test -r "$1"; then
        echo "Your (shared) C library seems to be in $1."
        libc="$1"
elif $test -r /lib/libc && $test -r /lib/clib; then
        echo "Your C library seems to be in both /lib/clib and /lib/libc."
        xxx=apollo
        libc='/lib/clib /lib/libc'
        if $test -r /lib/syslib; then
                echo "(Your math library is in /lib/syslib.)"
                libc="$libc /lib/syslib"
        fi
elif $test -r "$libc" || (test -h "$libc") >/dev/null 2>&1; then
        echo "Your C library seems to be in $libc, as you said before."
elif $test -r $incpath/usr/lib/libc$_a; then
        libc=$incpath/usr/lib/libc$_a;
        echo "Your C library seems to be in $libc.  That's fine."
elif $test -r /lib/libc$_a; then
        libc=/lib/libc$_a;
        echo "Your C library seems to be in $libc.  You're normal."
else
        if tans=`./loc libc$_a blurfl/dyick $libpth`; $test -r "$tans"; then
                :
        elif tans=`./loc libc blurfl/dyick $libpth`; $test -r "$tans"; then
                libnames="$libnames "`./loc clib blurfl/dyick $libpth`
        elif tans=`./loc clib blurfl/dyick $libpth`; $test -r "$tans"; then
                :
        elif tans=`./loc Slibc$_a blurfl/dyick $xlibpth`; $test -r "$tans"; then
                :
        elif tans=`./loc Mlibc$_a blurfl/dyick $xlibpth`; $test -r "$tans"; then
                :
        else
                tans=`./loc Llibc$_a blurfl/dyick $xlibpth`
        fi
        if $test -r "$tans"; then
                echo "Your C library seems to be in $tans, of all places."
                libc=$tans
        else
                libc='blurfl'
        fi
fi
if $test $xxx = apollo -o -r "$libc" || (test -h "$libc") >/dev/null 2>&1; then
        dflt="$libc"
        cat <<EOM

If the guess above is wrong (which it might be if you're using a strange
compiler, or your machine supports multiple models), you can override it here.

EOM
else
        dflt=''
        echo $libpth | $tr ' ' $trnl | $sort | $uniq > libpath
        cat >&4 <<EOM
I can't seem to find your C library.  I've looked in the following places:

EOM
        $sed 's/^/      /' libpath
        cat <<EOM

None of these seems to contain your C library. I need to get its name...

EOM
fi
fn=f
rp='Where is your C library?'
. ./getfile
libc="$ans"

echo " "
echo $libc $libnames | $tr ' ' $trnl | $sort | $uniq > libnames
set X `cat libnames`
shift
xxx=files
case $# in 1) xxx=file; esac
echo "Extracting names from the following $xxx for later perusal:" >&4
echo " "
$sed 's/^/      /' libnames >&4
echo " "
$echo $n "This may take a while...$c" >&4

for file in $*; do
        case $file in
        *$so*) $nm $nm_so_opt $nm_opt $file 2>/dev/null;;
        *) $nm $nm_opt $file 2>/dev/null;;
        esac
done >libc.tmp

$echo $n ".$c"
$grep fprintf libc.tmp > libc.ptf
xscan='eval "<libc.ptf $com >libc.list"; $echo $n ".$c" >&4'
xrun='eval "<libc.tmp $com >libc.list"; echo "done." >&4'
xxx='[ADTSIW]'
if com="$sed -n -e 's/__IO//' -e 's/^.* $xxx  *//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^__*//' -e 's/^\([a-zA-Z_0-9$]*\).*xtern.*/\1/p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e '/|UNDEF/d' -e '/FUNC..GL/s/^.*|__*//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^.* D __*//p' -e 's/^.* D //p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^_//' -e 's/^\([a-zA-Z_0-9]*\).*xtern.*text.*/\1/p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^.*|FUNC |GLOB .*|//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$grep '|' | $sed -n -e '/|COMMON/d' -e '/|DATA/d' \
                                -e '/ file/d' -e 's/^\([^       ]*\).*/\1/p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^.*|FUNC |GLOB .*|//p' -e 's/^.*|FUNC |WEAK .*|//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^__//' -e '/|Undef/d' -e '/|Proc/s/ .*//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^.*|Proc .*|Text *| *//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e '/Def. Text/s/.* \([^ ]*\)\$/\1/p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/^[-0-9a-f ]*_\(.*\)=.*/\1/p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="$sed -n -e 's/.*\.text n\ \ \ \.//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
elif com="sed -n -e 's/^__.*//' -e 's/[       ]*D[    ]*[0-9]*.*//p'";\
        eval $xscan;\
        $contains '^fprintf$' libc.list >/dev/null 2>&1; then
                eval $xrun
else
        $nm -p $* 2>/dev/null >libc.tmp
        $grep fprintf libc.tmp > libc.ptf
        if com="$sed -n -e 's/^.* [ADTSIW]  *_[_.]*//p' -e 's/^.* [ADTSIW] //p'";\
                eval $xscan; $contains '^fprintf$' libc.list >/dev/null 2>&1
        then
                nm_opt='-p'
                eval $xrun
        else
                echo " "
                echo "$nm didn't seem to work right. Trying $ar instead..." >&4
                com=''
                if $ar t $libc > libc.tmp && $contains '^fprintf$' libc.tmp >/dev/null 2>&1; then
                        for thisname in $libnames $libc; do
                                $ar t $thisname >>libc.tmp
                        done
                        $sed -e "s/\\$_o\$//" < libc.tmp > libc.list
                        echo "Ok." >&4
                elif test "X$osname" = "Xos2" && $ar tv $libc > libc.tmp; then
                        # Repeat libc to extract forwarders to DLL entries too
                        for thisname in $libnames $libc; do
                                $ar tv $thisname >>libc.tmp
                                # Revision 50 of EMX has bug in $ar.
                                # it will not extract forwarders to DLL entries
                                # Use emximp which will extract exactly them.
                                emximp -o tmp.imp $thisname \
                                    2>/dev/null && \
                                    $sed -e 's/^\([_a-zA-Z0-9]*\) .*$/\1/p' \
                                    < tmp.imp >>libc.tmp
                                $rm tmp.imp
                        done
                        $sed -e "s/\\$_o\$//" -e 's/^ \+//' < libc.tmp > libc.list
                        echo "Ok." >&4
                else
                        echo "$ar didn't seem to work right." >&4
                        echo "Maybe this is a Cray...trying bld instead..." >&4
                        if bld t $libc | $sed -e 's/.*\///' -e "s/\\$_o:.*\$//" > libc.list
                        then
                                for thisname in $libnames; do
                                        bld t $libnames | \
                                        $sed -e 's/.*\///' -e "s/\\$_o:.*\$//" >>libc.list
                                        $ar t $thisname >>libc.tmp
                                done
                                echo "Ok." >&4
                        else
                                echo "That didn't work either.  Giving up." >&4
                                exit 1
                        fi
                fi
        fi
fi
nm_extract="$com"
case "$PASE" in
define)
    echo " "
    echo "Since you are compiling for PASE, extracting more symbols from libc.a ...">&4
    dump -Tv /lib/libc.a | awk '$7 == "/unix" {print $5 " " $8}' | grep "^SV" | awk '{print $2}' >> libc.list
    ;;
*)  if $test -f /lib/syscalls.exp; then
        echo " "
        echo "Also extracting names from /lib/syscalls.exp for good ole AIX..." >&4
        $sed -n 's/^\([^        ]*\)[   ]*syscall[0-9]*[        ]*$/\1/p' /lib/syscalls.exp >>libc.list
    fi
    ;;
esac
;;
esac
$rm -f libnames libpath

: see if dld is available
set dld.h i_dld
eval $inhdr

: is a C symbol defined?
csym='tlook=$1;
case "$3" in
-v) tf=libc.tmp; tdc="";;
-a) tf=libc.tmp; tdc="[]";;
*) tlook="^$1\$"; tf=libc.list; tdc="()";;
esac;
tx=yes;
case "$reuseval-$4" in
true-) ;;
true-*) tx=no; eval "tval=\$$4"; case "$tval" in "") tx=yes;; esac;;
esac;
case "$tx" in
yes)
        tval=false;
        if $test "$runnm" = true; then
                if $contains $tlook $tf >/dev/null 2>&1; then
                        tval=true;
                elif $test "$mistrustnm" = compile -o "$mistrustnm" = run; then
                        echo "void *(*(p()))$tdc { extern void *$1$tdc; return &$1; } int main() { if(p()) return(0); else return(1); }"> try.c;
                        $cc -o try $optimize $ccflags $ldflags try.c >/dev/null 2>&1 $libs && tval=true;
                        $test "$mistrustnm" = run -a -x try && { $run ./try$_exe >/dev/null 2>&1 || tval=false; };
                        $rm -f try$_exe try.c core core.* try.core;
                fi;
        else
                echo "void *(*(p()))$tdc { extern void *$1$tdc; return &$1; } int main() { if(p()) return(0); else return(1); }"> try.c;
                $cc -o try $optimize $ccflags $ldflags try.c $libs >/dev/null 2>&1 && tval=true;
                $rm -f try$_exe try.c;
        fi;
        ;;
*)
        case "$tval" in
        $define) tval=true;;
        *) tval=false;;
        esac;
        ;;
esac;
eval "$2=$tval"'

: define an is-in-libc? function
inlibc='echo " "; td=$define; tu=$undef;
sym=$1; var=$2; eval "was=\$$2";
tx=yes;
case "$reuseval$was" in
true) ;;
true*) tx=no;;
esac;
case "$tx" in
yes)
        set $sym tres -f;
        eval $csym;
        case "$tres" in
        true)
                echo "$sym() found." >&4;
                case "$was" in $undef) . ./whoa; esac; eval "$var=\$td";;
        *)
                echo "$sym() NOT found." >&4;
                case "$was" in $define) . ./whoa; esac; eval "$var=\$tu";;
        esac;;
*)
        case "$was" in
        $define) echo "$sym() found." >&4;;
        *) echo "$sym() NOT found." >&4;;
        esac;;
esac'

: see if dlopen exists
xxx_runnm="$runnm"
runnm=false
set dlopen d_dlopen
eval $inlibc
runnm="$xxx_runnm"

: determine which dynamic loading, if any, to compile in
echo " "
dldir="ext/DynaLoader"
case "$usedl" in
$define|y|true)
        dflt='y'
        usedl="$define"
        ;;
$undef|n|false)
        dflt='n'
        usedl="$undef"
        ;;
*)
        dflt='n'
        case "$d_dlopen" in
            $define) dflt='y' ;;
        esac
        case "$i_dld" in
            $define) dflt='y' ;;
        esac
        : Does a dl_xxx.xs file exist for this operating system
        $test -f $rsrc/$dldir/dl_${osname}.xs && dflt='y'
        ;;
esac
rp="Do you wish to use dynamic loading?"
. ./myread
usedl="$ans"
case "$ans" in
y*) usedl="$define"
        case "$dlsrc" in
        '')
                if $test -f $rsrc/$dldir/dl_${osname}.xs ; then
                        dflt="$dldir/dl_${osname}.xs"
                elif $test "$d_dlopen" = "$define" ; then
                        dflt="$dldir/dl_dlopen.xs"
                elif $test "$i_dld" = "$define" ; then
                        dflt="$dldir/dl_dld.xs"
                else
                        dflt=''
                fi
                ;;
        *)      dflt="$dldir/$dlsrc"
                ;;
        esac
    echo "The following dynamic loading files are available:"
        : Can not go over to $dldir because getfile has path hard-coded in.
        tdir=`pwd`; cd "$rsrc"; $ls -C $dldir/dl*.xs; cd "$tdir"
        rp="Source file to use for dynamic loading"
        fn="fne"
        gfpth="$src"
        . ./getfile
        usedl="$define"
        : emulate basename
        dlsrc=`echo $ans | $sed -e 's%.*/\([^/]*\)$%\1%'`

        $cat << EOM

Some systems may require passing special flags to $cc -c to
compile modules that will be used to create a shared library.
To use no flags, say "none".

EOM
    case "$cccdlflags" in
    '') case "$gccversion" in
                '') case "$osname" in
                        hpux)   dflt='+z' ;;
                        next)   dflt='none' ;;
                        irix*)  dflt='-KPIC' ;;
                        svr4*|esix*|solaris|nonstopux) dflt='-KPIC' ;;
                        sunos)  dflt='-pic' ;;
                        *)      dflt='none' ;;
                    esac
                        ;;
                *)  case "$osname" in
                        darwin) dflt='none' ;;
                        svr4*|esix*|solaris|nonstopux) dflt='-fPIC' ;;
                        *)      dflt='-fpic' ;;
                    esac ;;
            esac ;;
        ' ') dflt='none' ;;
    *)  dflt="$cccdlflags" ;;
    esac
    rp="Any special flags to pass to $cc -c to compile shared library modules?"
    . ./myread
    case "$ans" in
    none) cccdlflags=' ' ;;
    *) cccdlflags="$ans" ;;
    esac

    cat << EOM

Some systems use ld to create libraries that can be dynamically loaded,
while other systems (such as those using ELF) use $cc.

EOM
        case "$ld" in
        '')     $cat >try.c <<EOM
/* Test for whether ELF binaries are produced */
#include <fcntl.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
        char b[4];
        int i = open("a.out",O_RDONLY);
        if(i == -1)
                exit(1); /* fail */
        if(read(i,b,4)==4 && b[0]==127 && b[1]=='E' && b[2]=='L' && b[3]=='F')
                exit(0); /* succeed (yes, it's ELF) */
        else
                exit(1); /* fail */
}
EOM
                if $cc $ccflags $ldflags try.c >/dev/null 2>&1 && $run ./a.out; then
                        cat <<EOM
You appear to have ELF support.  I'll use $cc to build dynamic libraries.
EOM
                        dflt="$cc"
                else
                        echo "I'll use ld to build dynamic libraries."
                        dflt='ld'
                fi
                rm -f try.c a.out
                ;;
        *)      dflt="$ld"
                ;;
        esac

    rp="What command should be used to create dynamic libraries?"
    . ./myread
        ld="$ans"

    cat << EOM

Some systems may require passing special flags to $ld to create a
library that can be dynamically loaded.  If your ld flags include
-L/other/path options to locate libraries outside your loader's normal
search path, you may need to specify those -L options here as well.  To
use no flags, say "none".

EOM
    case "$lddlflags" in
    '') case "$osname" in
                        beos) dflt='-nostart' ;;
                        hpux) dflt='-b';
                              case "$gccversion" in
                              '') dflt="$dflt +vnocompatwarnings" ;;
                              esac
                              ;;
                        linux|irix*)    dflt='-shared' ;;
                        next)  dflt='none' ;;
                        solaris) dflt='-G' ;;
                        sunos) dflt='-assert nodefinitions' ;;
                        svr4*|esix*|nonstopux) dflt="-G $ldflags" ;;
                *)     dflt='none' ;;
                        esac
                        ;;
    *) dflt="$lddlflags" ;;
    esac

        : Try to guess additional flags to pick up local libraries.
        : Be careful not to append to a plain 'none'
        case "$dflt" in
        none) dflt='' ;;
        esac
        for thisflag in $ldflags; do
                case "$thisflag" in
                -L*|-R*|-Wl,-R*)
                        case " $dflt " in
                        *" $thisflag "*) ;;
                        *) dflt="$dflt $thisflag" ;;
                        esac
                        ;;
                esac
        done

        case "$dflt" in
        ''|' ') dflt='none' ;;
        esac

    rp="Any special flags to pass to $ld to create a dynamically loaded library?"
    . ./myread
    case "$ans" in
    none) lddlflags=' ' ;;
    *) lddlflags="$ans" ;;
    esac

        cat <<EOM

Some systems may require passing special flags to $cc to indicate that
the resulting executable will use dynamic linking.  To use no flags,
say "none".

EOM
    case "$ccdlflags" in
    '') case "$osname" in
            linux|hpux) dflt='-Wl,-E' ;;
            next|sunos) dflt='none' ;;
            *)          dflt='none' ;;
            esac ;;
    ' ')  dflt='none' ;;
    *)  dflt="$ccdlflags" ;;
    esac
    rp="Any special flags to pass to $cc to use dynamic linking?"
    . ./myread
    case "$ans" in
    none) ccdlflags=' ' ;;
    *) ccdlflags="$ans" ;;
    esac
    ;;
*)  usedl="$undef"
        ld='ld'
    dlsrc='dl_none.xs'
    lddlflags=''
    ccdlflags=''
    ;;
esac

also=''
case "$usedl" in
$undef)
        # No dynamic loading being used, so don't bother even to prompt.
        useshrplib='false'
        ;;
*)      case "$useshrplib" in
        '')     case "$osname" in
                svr4*|nonstopux|dgux|dynixptx|esix|powerux|beos|cygwin*)
                        dflt=y
                        also='Building a shared libperl is required for dynamic loading to work on your system.'
                        ;;
                next*)
                        case "$osvers" in
                        4*)     dflt=y
                                also='Building a shared libperl is needed for MAB support.'
                                ;;
                        *)      dflt=n
                                ;;
                        esac
                        ;;
                *)      dflt=n
                        ;;
                esac
                ;;
        $define|true|[Yy]*)
                dflt=y
                ;;
        *)      dflt=n
                ;;
        esac
        $cat << EOM

The perl executable is normally obtained by linking perlmain.c with
libperl${_a}, any static extensions (usually just DynaLoader), and
any other libraries needed on this system (such as -lm, etc.).  Since
your system supports dynamic loading, it is probably possible to build
a shared libperl.$so.  If you will have more than one executable linked
to libperl.$so, this will significantly reduce the size of each
executable, but it may have a noticeable affect on performance.  The
default is probably sensible for your system.
$also

EOM
        rp="Build a shared libperl.$so (y/n)"
        . ./myread
        case "$ans" in
        true|$define|[Yy]*)
                useshrplib='true'  ;;
        *)      useshrplib='false' ;;
        esac
        ;;
esac

case "$useshrplib" in
true)
        case "$libperl" in
        '')
                # Figure out a good name for libperl.so.  Since it gets stored in
                # a version-specific architecture-dependent library, the version
                # number isn't really that important, except for making cc/ld happy.
                #
                # A name such as libperl.so.3.1
                majmin="libperl.$so.$patchlevel.$subversion"
                # A name such as libperl.so.301
                majonly=`echo $patchlevel $subversion |
                        $awk '{printf "%d%02d", $1, $2}'`
                majonly=libperl.$so.$majonly
                # I'd prefer to keep the os-specific stuff here to a minimum, and
                # rely on figuring it out from the naming of libc.
                case "${osname}${osvers}" in
                next4*)
                        dflt=libperl.5.$so
                        # XXX How handle the --version stuff for MAB?
                        ;;
                linux*)  # ld won't link with a bare -lperl otherwise.
                        dflt=libperl.$so
                        ;;
                cygwin*) # ld links against an importlib
                        dflt=libperl$lib_ext
                        ;;
                *)      # Try to guess based on whether libc has major.minor.
                        case "$libc" in
                        *libc.$so.[0-9]*.[0-9]*) dflt=$majmin ;;
                        *libc.$so.[0-9]*) dflt=$majonly ;;
                        *)      dflt=libperl.$so ;;
                        esac
                        ;;
                esac
                ;;
        *)      dflt=$libperl
                ;;
        esac
        cat << EOM

I need to select a good name for the shared libperl.  If your system uses
library names with major and minor numbers, then you might want something
like $majmin.  Alternatively, if your system uses a single version
number for shared libraries, then you might want to use $majonly.
Or, your system might be quite happy with a simple libperl.$so.

Since the shared libperl will get installed into a version-specific
architecture-dependent directory, the version number of the shared perl
library probably isn't important, so the default should be o.k.

EOM
        rp='What name do you want to give to the shared libperl?'
        . ./myread
        libperl=$ans
        echo "Ok, I'll use $libperl"
        ;;
*)
        libperl="libperl${_a}"
        ;;
esac

# Detect old use of shrpdir via undocumented Configure -Dshrpdir
case "$shrpdir" in
'') ;;
*)      $cat >&4 <<EOM
WARNING:  Use of the shrpdir variable for the installation location of
the shared $libperl is not supported.  It was never documented and
will not work in this version.  Let me (perlbug@perl.org)
know of any problems this may cause.

EOM
        case "$shrpdir" in
        "$archlibexp/CORE")
                $cat >&4 <<EOM
But your current setting of $shrpdir is
the default anyway, so it's harmless.
EOM
                ;;
        *)
                $cat >&4 <<EOM
Further, your current attempted setting of $shrpdir
conflicts with the value of $archlibexp/CORE
that installperl will use.
EOM
                ;;
        esac
        ;;
esac

# How will the perl executable find the installed shared $libperl?
# Add $xxx to ccdlflags.
# If we can't figure out a command-line option, use $shrpenv to
# set env LD_RUN_PATH.  The main perl makefile uses this.
shrpdir=$archlibexp/CORE
xxx=''
tmp_shrpenv=''
if "$useshrplib"; then
    case "$osname" in
        aix)
                # We'll set it in Makefile.SH...
                ;;
        solaris)
                xxx="-R $shrpdir"
                ;;
        freebsd|netbsd|openbsd)
                xxx="-Wl,-R$shrpdir"
                ;;
        bsdos|linux|irix*|dec_osf)
                xxx="-Wl,-rpath,$shrpdir"
                ;;
        next)
                # next doesn't like the default...
                ;;
        beos)
                # beos doesn't like the default, either.
                ;;
        hpux*)
                # hpux doesn't like the default, either.
                tmp_shrpenv="env LDOPTS=\"+s +b${shrpdir}\""
                ;;
        *)
                tmp_shrpenv="env LD_RUN_PATH=$shrpdir"
                ;;
        esac
        case "$xxx" in
        '') ;;
        *)
                # Only add $xxx if it isn't already in ccdlflags.
                case " $ccdlflags " in
                *" $xxx "*)     ;;
                *)      ccdlflags="$ccdlflags $xxx"
                        cat <<EOM >&4

Adding $xxx to the flags
passed to $ld so that the perl executable will find the
installed shared $libperl.

EOM
                        ;;
                esac
                ;;
        esac
fi
# Fix ccdlflags in AIX for building external extensions.
# (For building Perl itself bare -bE:perl.exp is needed,
#  Makefile.SH takes care of this.)
case "$osname" in
aix) ccdlflags="$ccdlflags -bE:$installarchlib/CORE/perl.exp" ;;
esac
# Respect a hint or command-line value.
case "$shrpenv" in
'') shrpenv="$tmp_shrpenv" ;;
esac
case "$ldlibpthname" in
'')     ldlibpthname=LD_LIBRARY_PATH ;;
none)   ldlibpthname='' ;;
esac

: determine where manual pages are on this system
echo " "
case "$sysman" in
'')
        syspath='/usr/share/man/man1 /usr/man/man1'
        syspath="$syspath /usr/man/mann /usr/man/manl /usr/man/local/man1"
        syspath="$syspath /usr/man/u_man/man1"
        syspath="$syspath /usr/catman/u_man/man1 /usr/man/l_man/man1"
        syspath="$syspath /usr/local/man/u_man/man1 /usr/local/man/l_man/man1"
        syspath="$syspath /usr/man/man.L /local/man/man1 /usr/local/man/man1"
        sysman=`./loc . /usr/man/man1 $syspath`
        ;;
esac
if $test -d "$sysman"; then
        echo "System manual is in $sysman." >&4
else
        echo "Could not find manual pages in source form." >&4
fi

: determine where manual pages go
set man1dir man1dir none
eval $prefixit
$cat <<EOM

$spackage has manual pages available in source form.
EOM
case "$nroff" in
nroff)
        echo "However, you don't have nroff, so they're probably useless to you."
        case "$man1dir" in
        '') man1dir="none";;
        esac;;
esac
echo "If you don't want the manual sources installed, answer 'none'."
case "$man1dir" in
' ') dflt=none
        ;;
'')
        lookpath="$prefixexp/share/man/man1"
        lookpath="$lookpath $prefixexp/man/man1 $prefixexp/man/l_man/man1"
        lookpath="$lookpath $prefixexp/man/p_man/man1"
        lookpath="$lookpath $prefixexp/man/u_man/man1"
        lookpath="$lookpath $prefixexp/man/man.1"
        case "$sysman" in
        */?_man*)       dflt=`./loc . $prefixexp/l_man/man1 $lookpath` ;;
        *)      dflt=`./loc . $prefixexp/man/man1 $lookpath` ;;
        esac
        set dflt
        eval $prefixup
        ;;
*)  dflt="$man1dir"
        ;;
esac
echo " "
fn=dn+~
rp="Where do the main $spackage manual pages (source) go?"
. ./getfile
if $test "X$man1direxp" != "X$ansexp"; then
        installman1dir=''
fi
man1dir="$ans"
man1direxp="$ansexp"
case "$man1dir" in
'')     man1dir=' '
        installman1dir='';;
esac

: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installman1dir=`echo $man1direxp | $sed "s#^$prefix#$installprefix#"`
else
        installman1dir="$man1direxp"
fi

: What suffix to use on installed man pages

case "$man1dir" in
' ')
        man1ext='0'
        ;;
*)
        rp="What suffix should be used for the main $spackage man pages?"
        case "$man1ext" in
        '')     case "$man1dir" in
                *1)  dflt=1 ;;
                *1p) dflt=1p ;;
                *1pm) dflt=1pm ;;
                *l) dflt=l;;
                *n) dflt=n;;
                *o) dflt=o;;
                *p) dflt=p;;
                *C) dflt=C;;
                *L) dflt=L;;
                *L1) dflt=L1;;
                *) dflt=1;;
                esac
                ;;
        *)      dflt="$man1ext";;
        esac
        . ./myread
        man1ext="$ans"
        ;;
esac

: see if we can have long filenames
echo " "
first=123456789abcdef
$rm -f $first
if (echo hi >$first) 2>/dev/null; then
        if $test -f 123456789abcde; then
                echo 'You cannot have filenames longer than 14 characters.  Sigh.' >&4
                val="$undef"
        else
                echo 'You can have filenames longer than 14 characters.'>&4
                val="$define"
        fi
else
        $cat <<'EOM'
You can't have filenames longer than 14 chars.
You can't even think about them!
EOM
        val="$undef"
fi
set d_flexfnam
eval $setvar
$rm -rf 123456789abcde*

: determine where library module manual pages go
set man3dir man3dir none
eval $prefixit
$cat <<EOM

$spackage has manual pages for many of the library modules.
EOM

case "$nroff" in
nroff)
        $cat <<'EOM'
However, you don't have nroff, so they're probably useless to you.
EOM
        case "$man3dir" in
        '') man3dir="none";;
        esac;;
esac

case "$d_flexfnam" in
undef)
        $cat <<'EOM'
However, your system can't handle the long file names like File::Basename.3.
EOM
        case "$man3dir" in
        '') man3dir="none";;
        esac;;
esac

echo "If you don't want the manual sources installed, answer 'none'."
prog=`echo $package | $sed 's/-*[0-9.]*$//'`
case "$man3dir" in
'')     dflt=`echo "$man1dir" | $sed -e 's/man1/man3/g' -e 's/man\.1/man\.3/g'`
        if $test -d "$privlib/man/man3"; then
                cat <<EOM >&4

WARNING:  Previous versions of perl installed man3 pages into
$privlib/man/man3.  This version will suggest a
new default of $dflt.
EOM
                tdflt=$dflt
                dflt='n'
                rp='Do you wish to preserve the old behavior?(y/n)'
                . ./myread
                case "$ans" in
                y*) dflt="$privlib/man/man3" ;;
                *)  dflt=$tdflt ;;
                esac
    fi
        ;;
*)      dflt="$man3dir" ;;
esac
case "$dflt" in
' ') dflt=none ;;
esac
echo " "
fn=dn+~
rp="Where do the $package library man pages (source) go?"
. ./getfile
man3dir="$ans"
man3direxp="$ansexp"
case "$man3dir" in
'')     man3dir=' '
        installman3dir='';;
esac

: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installman3dir=`echo $man3direxp | $sed "s#^$prefix#$installprefix#"`
else
        installman3dir="$man3direxp"
fi

: What suffix to use on installed man pages
case "$man3dir" in
' ')
        man3ext='0'
        ;;
*)
        rp="What suffix should be used for the $package library man pages?"
        case "$man3ext" in
        '')     case "$man3dir" in
                *3)  dflt=3 ;;
                *3p) dflt=3p ;;
                *3pm) dflt=3pm ;;
                *l) dflt=l;;
                *n) dflt=n;;
                *o) dflt=o;;
                *p) dflt=p;;
                *C) dflt=C;;
                *L) dflt=L;;
                *L3) dflt=L3;;
                *) dflt=3;;
                esac
                ;;
        *)      dflt="$man3ext";;
        esac
        . ./myread
        man3ext="$ans"
        ;;
esac

: see if we have to deal with yellow pages, now NIS.
if $test -d /usr/etc/yp || $test -d /etc/yp || $test -d /usr/lib/yp; then
        if $test -f /usr/etc/nibindd; then
                echo " "
                echo "I'm fairly confident you're on a NeXT."
                echo " "
                rp='Do you get the hosts file via NetInfo?'
                dflt=y
                case "$hostcat" in
                nidump*) ;;
                '') ;;
                *) dflt=n;;
                esac
                . ./myread
                case "$ans" in
                y*) hostcat='nidump hosts .';;
                *)      case "$hostcat" in
                        nidump*) hostcat='';;
                        esac
                        ;;
                esac
        fi
        case "$hostcat" in
        nidump*) ;;
        *)
                case "$hostcat" in
                *ypcat*) dflt=y;;
                '') if $contains '^\+' /etc/passwd >/dev/null 2>&1; then
                                dflt=y
                        else
                                dflt=n
                        fi;;
                *) dflt=n;;
                esac
                echo " "
                rp='Are you getting the hosts file via yellow pages?'
                . ./myread
                case "$ans" in
                y*) hostcat='ypcat hosts';;
                *) hostcat='cat /etc/hosts';;
                esac
                ;;
        esac
fi
case "$hostcat" in
'') test -f /etc/hosts && hostcat='cat /etc/hosts';;
esac
case "$groupcat" in
'') test -f /etc/group && groupcat='cat /etc/group';;
esac
case "$passcat" in
'') test -f /etc/passwd && passcat='cat /etc/passwd';;
esac

: now get the host name
echo " "
echo "Figuring out host name..." >&4
case "$myhostname" in
'') cont=true
        echo 'Maybe "hostname" will work...'
        if tans=`sh -c hostname 2>&1` ; then
                myhostname=$tans
                phostname=hostname
                cont=''
        fi
        ;;
*) cont='';;
esac
if $test "$cont"; then
        if ./xenix; then
                echo 'Oh, dear.  Maybe "/etc/systemid" is the key...'
                if tans=`cat /etc/systemid 2>&1` ; then
                        myhostname=$tans
                        phostname='cat /etc/systemid'
                        echo "Whadyaknow.  Xenix always was a bit strange..."
                        cont=''
                fi
        elif $test -r /etc/systemid; then
                echo "(What is a non-Xenix system doing with /etc/systemid?)"
        fi
fi
if $test "$cont"; then
        echo 'No, maybe "uuname -l" will work...'
        if tans=`sh -c 'uuname -l' 2>&1` ; then
                myhostname=$tans
                phostname='uuname -l'
        else
                echo 'Strange.  Maybe "uname -n" will work...'
                if tans=`sh -c 'uname -n' 2>&1` ; then
                        myhostname=$tans
                        phostname='uname -n'
                else
                        echo 'Oh well, maybe I can mine it out of whoami.h...'
                        if tans=`sh -c $contains' sysname $usrinc/whoami.h' 2>&1` ; then
                                myhostname=`echo "$tans" | $sed 's/^.*"\(.*\)"/\1/'`
                                phostname="sed -n -e '"'/sysname/s/^.*\"\\(.*\\)\"/\1/{'"' -e p -e q -e '}' <$usrinc/whoami.h"
                        else
                                case "$myhostname" in
                                '') echo "Does this machine have an identity crisis or something?"
                                        phostname='';;
                                *)
                                        echo "Well, you said $myhostname before..."
                                        phostname='echo $myhostname';;
                                esac
                        fi
                fi
        fi
fi
case "$myhostname" in
'') myhostname=noname ;;
esac
: you do not want to know about this
set $myhostname
myhostname=$1

: verify guess
if $test "$myhostname" ; then
        dflt=y
        rp='Your host name appears to be "'$myhostname'".'" Right?"
        . ./myread
        case "$ans" in
        y*) ;;
        *) myhostname='';;
        esac
fi

: bad guess or no guess
while $test "X$myhostname" = X ; do
        dflt=''
        rp="Please type the (one word) name of your host:"
        . ./myread
        myhostname="$ans"
done

: translate upper to lower if necessary
case "$myhostname" in
*[A-Z]*)
        echo "(Normalizing case in your host name)"
        myhostname=`echo $myhostname | ./tr '[A-Z]' '[a-z]'`
        ;;
esac

case "$myhostname" in
*.*)
        dflt=`expr "X$myhostname" : "X[^.]*\(\..*\)"`
        myhostname=`expr "X$myhostname" : "X\([^.]*\)\."`
        echo "(Trimming domain name from host name--host name is now $myhostname)"
        ;;
*) case "$mydomain" in
        '')
                {
                        test "X$hostcat" = "Xypcat hosts" &&
                        ypmatch "$myhostname" hosts 2>/dev/null |\
                                $sed -e 's/[     ]*#.*//; s/$/ /' > hosts && \
                        $test -s hosts
                } || {
                        test "X$hostcat" != "X" &&
                        $hostcat | $sed -n -e "s/[       ]*#.*//; s/\$/ /
                                        /[       ]$myhostname[  . ]/p" > hosts
                }
                tmp_re="[       . ]"
                if $test -f hosts; then
                        $test x`$awk "/[0-9].*[  ]$myhostname$tmp_re/ { sum++ }
                             END { print sum }" hosts` = x1 || tmp_re="[         ]"
                        dflt=.`$awk "/[0-9].*[   ]$myhostname$tmp_re/ {for(i=2; i<=NF;i++) print \\\$i}" \
                                hosts | $sort | $uniq | \
                                $sed -n -e "s/$myhostname\.\([-a-zA-Z0-9_.]\)/\1/p"`
                        case `$echo X$dflt` in
                        X*\ *)  echo "(Several hosts in the database matched hostname)"
                                dflt=.
                                ;;
                        X.) echo "(You do not have fully-qualified names in the hosts database)"
                                ;;
                        esac
                else
                        echo "(I cannot locate a hosts database anywhere)"
                        dflt=.
                fi
                case "$dflt" in
                .)
                        tans=`./loc resolv.conf X /etc /usr/etc`
                        if $test -f "$tans"; then
                                echo "(Attempting domain name extraction from $tans)"
                                dflt=.`$sed -n -e 's/   / /g' \
                                  -e 's/^search  *\([^ ]*\).*/\1/p' $tans \
                                  | ./tr '[A-Z]' '[a-z]' 2>/dev/null`
                                case "$dflt" in
                                .) dflt=.`$sed -n -e 's/        / /g' \
                                     -e 's/^domain  *\([^ ]*\).*/\1/p' $tans \
                                     | ./tr '[A-Z]' '[a-z]' 2>/dev/null`
                                        ;;
                                esac
                        fi
                        ;;
                esac
                case "$dflt" in
                .) echo "(No help from resolv.conf either -- attempting clever guess)"
                        dflt=.`sh -c domainname 2>/dev/null`
                        case "$dflt" in
                        '') dflt='.';;
                        .nis.*|.yp.*|.main.*) dflt=`echo $dflt | $sed -e 's/^\.[^.]*//'`;;
                        esac
                        ;;
                esac
                case "$dflt$osname" in
                .os390) echo "(Attempting domain name extraction from //'SYS1.TCPPARMS(TCPDATA)')"
                        dflt=.`awk '/^DOMAINORIGIN/ {print $2}' "//'SYS1.TCPPARMS(TCPDATA)'" 2>/dev/null`
                        ;;
                esac
                case "$dflt" in
                .) echo "(Lost all hope -- silly guess then)"
                        dflt='.nonet'
                        ;;
                esac
                $rm -f hosts
                ;;
        *) dflt="$mydomain";;
        esac;;
esac
echo " "
rp="What is your domain name?"
. ./myread
tans="$ans"
case "$ans" in
'') ;;
.*) ;;
*) tans=".$tans";;
esac
mydomain="$tans"

: translate upper to lower if necessary
case "$mydomain" in
*[A-Z]*)
        echo "(Normalizing case in your domain name)"
        mydomain=`echo $mydomain | ./tr '[A-Z]' '[a-z]'`
        ;;
esac

: a little sanity check here
case "$phostname" in
'') ;;
*)
        case `$phostname | ./tr '[A-Z]' '[a-z]'` in
        $myhostname$mydomain|$myhostname) ;;
        *)
                case "$phostname" in
                sed*)
                        echo "(That doesn't agree with your whoami.h file, by the way.)"
                        ;;
                *)
                        echo "(That doesn't agree with your $phostname command, by the way.)"
                        ;;
                esac
        ;;
        esac
        ;;
esac

$cat <<EOM

I need to get your e-mail address in Internet format if possible, i.e.
something like user@host.domain. Please answer accurately since I have
no easy means to double check it. The default value provided below
is most probably close to reality but may not be valid from outside
your organization...

EOM
cont=x
while test "$cont"; do
        case "$cf_email" in
        '') dflt="$cf_by@$myhostname$mydomain";;
        *) dflt="$cf_email";;
        esac
        rp='What is your e-mail address?'
        . ./myread
        cf_email="$ans"
        case "$cf_email" in
        *@*.*) cont='' ;;
        *)
                rp='Address does not look like an Internet one.  Use it anyway?'
                case "$fastread" in
                yes) dflt=y ;;
                *) dflt=n ;;
                esac
                . ./myread
                case "$ans" in
                y*) cont='' ;;
                *) echo " " ;;
                esac
                ;;
        esac
done

$cat <<EOM

If you or somebody else will be maintaining perl at your site, please
fill in the correct e-mail address here so that they may be contacted
if necessary. Currently, the "perlbug" program included with perl
will send mail to this address in addition to perlbug@perl.org. You may
enter "none" for no administrator.

EOM
case "$perladmin" in
'') dflt="$cf_email";;
*) dflt="$perladmin";;
esac
rp='Perl administrator e-mail address'
. ./myread
perladmin="$ans"

: determine whether to only install version-specific parts.
echo " "
$cat <<EOM
Do you want to install only the version-specific parts of the perl
distribution?  Usually you do *not* want to do this.
EOM
case "$versiononly" in
"$define"|[Yy]*|true) dflt='y' ;;
*) dflt='n';
esac
rp="Do you want to install only the version-specific parts of perl?"
. ./myread
case "$ans" in
[yY]*)  val="$define";;
*)      val="$undef" ;;
esac
set versiononly
eval $setvar

case "$versiononly" in
"$define") inc_version_list=''
           inc_version_list_init=0
           ;;
esac

: figure out how to guarantee perl startup
case "$startperl" in
'')
        case "$sharpbang" in
        *!)
                $cat <<EOH

I can use the #! construct to start perl on your system. This will
make startup of perl scripts faster, but may cause problems if you
want to share those scripts and perl is not in a standard place
($binexp/perl) on all your platforms. The alternative is to force
a shell by starting the script with a single ':' character.

EOH
                case "$versiononly" in
                "$define")      dflt="$binexp/perl$version";;
                *)              dflt="$binexp/perl";;
                esac
                rp='What shall I put after the #! to start up perl ("none" to not use #!)?'
                . ./myread
                case "$ans" in
                none)   startperl=": # use perl";;
                *)      startperl="#!$ans"
                        if $test 30 -lt `echo "$ans" | wc -c`; then
                                $cat >&4 <<EOM

WARNING:  Some systems limit the #! command to 32 characters.
If you experience difficulty running Perl scripts with #!, try
installing Perl in a directory with a shorter pathname.

EOM
                        fi ;;
                esac
                ;;
        *) startperl=": # use perl"
                ;;
        esac
        ;;
esac
echo "I'll use $startperl to start perl scripts."

: figure best path for perl in scripts
case "$perlpath" in
'')
        case "$versiononly" in
        "$define")      perlpath="$binexp/perl$version";;
        *)              perlpath="$binexp/perl";;
        esac
        case "$startperl" in
        *!*) ;;
        *)
                $cat <<EOH

I will use the "eval 'exec'" idiom to start Perl on your system.
I can use the full path of your Perl binary for this purpose, but
doing so may cause problems if you want to share those scripts and
Perl is not always in a standard place ($binexp/perl).

EOH
                dflt="$binexp/perl"
                rp="What path shall I use in \"eval 'exec'\"?"
                . ./myread
                perlpath="$ans"
                ;;
        esac
        ;;
esac
case "$startperl" in
*!*)    ;;
*)      echo "I'll use $perlpath in \"eval 'exec'\"" ;;
esac

: determine where public executable scripts go
set scriptdir scriptdir
eval $prefixit
case "$scriptdir" in
'')
        dflt="$bin"
        : guess some guesses
        $test -d /usr/share/scripts && dflt=/usr/share/scripts
        $test -d /usr/share/bin     && dflt=/usr/share/bin
        $test -d /usr/local/script  && dflt=/usr/local/script
        $test -d /usr/local/scripts && dflt=/usr/local/scripts
        $test -d $prefixexp/script  && dflt=$prefixexp/script
        set dflt
        eval $prefixup
        ;;
*)  dflt="$scriptdir"
        ;;
esac
$cat <<EOM

Some installations have a separate directory just for executable scripts so
that they can mount it across multiple architectures but keep the scripts in
one spot.  You might, for example, have a subdirectory of /usr/share for this.
Or you might just lump your scripts in with all your other executables.

EOM
fn=d~
rp='Where do you keep publicly executable scripts?'
. ./getfile
if $test "X$ansexp" != "X$scriptdirexp"; then
        installscript=''
fi
scriptdir="$ans"
scriptdirexp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installscript=`echo $scriptdirexp | sed "s#^$prefix#$installprefix#"`
else
        installscript="$scriptdirexp"
fi

: determine where add-on public executables go
case "$sitebin" in
'')     dflt=$siteprefix/bin ;;
*)      dflt=$sitebin ;;
esac
fn=d~
rp='Pathname where the add-on public executables should be installed?'
. ./getfile
sitebin="$ans"
sitebinexp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsitebin=`echo $sitebinexp | sed "s#^$prefix#$installprefix#"`
else
        installsitebin="$sitebinexp"
fi

: determine where add-on html pages go
: There is no standard location, so try to copy the previously-selected
: directory structure for the core html pages.
case "$sitehtml1dir" in
'')    dflt=`echo "$html1dir" | $sed "s#^$prefix#$siteprefix#"` ;;
*)     dflt=$sitehtml1dir ;;
esac
case "$dflt" in
''|' ') dflt=none ;;
esac
fn=dn+~
rp='Pathname where the site-specific html pages should be installed?'
. ./getfile
sitehtml1dir="$ans"
sitehtml1direxp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsitehtml1dir=`echo $sitehtml1direxp | $sed "s#^$prefix#$installprefix#"`
else
        installsitehtml1dir="$sitehtml1direxp"
fi

: determine where add-on library html pages go
: There is no standard location, so try to copy the previously-selected
: directory structure for the core html pages.
case "$sitehtml3dir" in
'')    dflt=`echo "$html3dir" | $sed "s#^$prefix#$siteprefix#"` ;;
*)     dflt=$sitehtml3dir ;;
esac
case "$dflt" in
''|' ') dflt=none ;;
esac
fn=dn+~
rp='Pathname where the site-specific library html pages should be installed?'
. ./getfile
sitehtml3dir="$ans"
sitehtml3direxp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsitehtml3dir=`echo $sitehtml3direxp | $sed "s#^$prefix#$installprefix#"`
else
        installsitehtml3dir="$sitehtml3direxp"
fi

: determine where add-on manual pages go
case "$siteman1dir" in
'')     dflt=`echo $man1dir | $sed "s#^$prefix#$siteprefix#"` ;;
*)      dflt=$siteman1dir ;;
esac
case "$dflt" in
''|' ') dflt=none ;;
esac
fn=dn+~
rp='Pathname where the site-specific manual pages should be installed?'
. ./getfile
siteman1dir="$ans"
siteman1direxp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsiteman1dir=`echo $siteman1direxp | $sed "s#^$prefix#$installprefix#"`
else
        installsiteman1dir="$siteman1direxp"
fi

: determine where add-on library man pages go
case "$siteman3dir" in
'')     dflt=`echo $man3dir | $sed "s#^$prefix#$siteprefix#"` ;;
*)      dflt=$siteman3dir ;;
esac
case "$dflt" in
''|' ') dflt=none ;;
esac
fn=dn+~
rp='Pathname where the site-specific library manual pages should be installed?'
. ./getfile
siteman3dir="$ans"
siteman3direxp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsiteman3dir=`echo $siteman3direxp | $sed "s#^$prefix#$installprefix#"`
else
        installsiteman3dir="$siteman3direxp"
fi

: determine where add-on public executable scripts go
case "$sitescript" in
'')     dflt=$siteprefix/script
        $test -d $dflt || dflt=$sitebin ;;
*)  dflt="$sitescript" ;;
esac
fn=d~+
rp='Pathname where add-on public executable scripts should be installed?'
. ./getfile
sitescript="$ans"
sitescriptexp="$ansexp"
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installsitescript=`echo $sitescriptexp | sed "s#^$prefix#$installprefix#"`
else
        installsitescript="$sitescriptexp"
fi

case "$usefaststdio" in
$define|true|[yY]*|'')
        xversion=`awk '/define[         ]+PERL_VERSION/ {print $3}' $rsrc/patchlevel.h`
        case "$xversion" in
        [68])   dflt='y' ;;
        *)      dflt='n' ;;
        esac
        ;;
*) dflt='n';;
esac
cat <<EOM

Perl can be built to use 'fast stdio', which means using the stdio
library but also directly manipulating the stdio buffers to enable
faster I/O.  Using stdio is better for backward compatibility (especially
for Perl extensions), but on the other hand since Perl 5.8 the 'perlio'
interface has been preferred instead of stdio.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
rp='Use the "fast stdio" if available?'
. ./myread
case "$ans" in
y|Y)    val="$define" ;;
*)      val="$undef" ;;
esac
set usefaststdio
eval $setvar


: define an is-a-typedef? function
typedef='type=$1; var=$2; def=$3; shift; shift; shift; inclist=$@;
case "$inclist" in
"") inclist="sys/types.h";;
esac;
eval "varval=\$$var";
case "$varval" in
"")
        $rm -f temp.c;
        for inc in $inclist; do
                echo "#include <$inc>" >>temp.c;
        done;
        echo "#ifdef $type" >> temp.c;
        echo "printf(\"We have $type\");" >> temp.c;
        echo "#endif" >> temp.c;
        $cppstdin $cppflags $cppminus < temp.c >temp.E 2>/dev/null;
        if $contains $type temp.E >/dev/null 2>&1; then
                eval "$var=\$type";
        else
                eval "$var=\$def";
        fi;
        $rm -f temp.?;;
*) eval "$var=\$varval";;
esac'

: define an is-a-typedef? function that prompts if the type is not available.
typedef_ask='type=$1; var=$2; def=$3; shift; shift; shift; inclist=$@;
case "$inclist" in
"") inclist="sys/types.h";;
esac;
eval "varval=\$$var";
case "$varval" in
"")
        $rm -f temp.c;
        for inc in $inclist; do
                echo "#include <$inc>" >>temp.c;
        done;
        echo "#ifdef $type" >> temp.c;
        echo "printf(\"We have $type\");" >> temp.c;
        echo "#endif" >> temp.c;
        $cppstdin $cppflags $cppminus < temp.c >temp.E 2>/dev/null;
        echo " " ;
        echo "$rp" | $sed -e "s/What is/Looking for/" -e "s/?/./";
        if $contains $type temp.E >/dev/null 2>&1; then
                echo "$type found." >&4;
                eval "$var=\$type";
        else
                echo "$type NOT found." >&4;
                dflt="$def";
                . ./myread ;
                eval "$var=\$ans";
        fi;
        $rm -f temp.?;;
*) eval "$var=\$varval";;
esac'

: see what type lseek is declared as in the kernel
rp="What is the type used for lseek's offset on this system?"
set off_t lseektype long stdio.h sys/types.h
eval $typedef_ask

echo " "
echo "Checking to see how big your file offsets are..." >&4
$cat >try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
int main()
{
    printf("%d\n", (int)sizeof($lseektype));
    return(0);
}
EOCP
set try
if eval $compile_ok; then
        lseeksize=`$run ./try`
        echo "Your file offsets are $lseeksize bytes long."
else
        dflt=$longsize
        echo " "
        echo "(I can't seem to compile the test program.  Guessing...)"
        rp="What is the size of your file offsets (in bytes)?"
        . ./myread
        lseeksize="$ans"
fi
$rm -f try.c try

: see what type file positions are declared as in the library
rp="What is the type for file position used by fsetpos()?"
set fpos_t fpostype long stdio.h sys/types.h
eval $typedef_ask

echo " "
case "$fpostype" in
*_t) zzz="$fpostype"    ;;
*)   zzz="fpos_t"       ;;
esac
echo "Checking the size of $zzz..." >&4
cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
    printf("%d\n", (int)sizeof($fpostype));
    exit(0);
}
EOCP
set try
if eval $compile_ok; then
        yyy=`$run ./try`
        case "$yyy" in
        '')     fpossize=4
                echo "(I can't execute the test program--guessing $fpossize.)" >&4
                ;;
        *)      fpossize=$yyy
                echo "Your $zzz is $fpossize bytes long."
                ;;
        esac
else
        dflt="$longsize"
        echo " " >&4
        echo "(I can't compile the test program.  Guessing...)" >&4
        rp="What is the size of your file positions (in bytes)?"
        . ./myread
        fpossize="$ans"
fi

# Backward compatibility (uselfs is deprecated).
case "$uselfs" in
"$define"|true|[yY]*)
        cat <<EOM >&4

*** Configure -Duselfs is deprecated, using -Duselargefiles instead.
EOM
        uselargefiles="$define"
        ;;
esac

case "$lseeksize:$fpossize" in
8:8) cat <<EOM

You can have files larger than 2 gigabytes.
EOM
   val="$define" ;;
*)    case "$uselargefiles" in
   "$undef"|false|[nN]*) dflt='n' ;;
   *)   dflt='y' ;;
   esac
   cat <<EOM

Perl can be built to understand large files (files larger than 2 gigabytes)
on some systems.  To do so, Configure can be run with -Duselargefiles.

If this doesn't make any sense to you, just accept the default '$dflt'.
EOM
   rp='Try to understand large files, if available?'
   . ./myread
   case "$ans" in
   y|Y)         val="$define" ;;
   *)           val="$undef"  ;;
   esac
   ;;
esac
set uselargefiles
eval $setvar
: Look for a hint-file generated 'call-back-unit'.  If the
: user has specified that a large files perl is to be built,
: we may need to set or change some other defaults.
if $test -f uselargefiles.cbu; then
        echo "Your platform has some specific hints regarding large file builds, using them..."
        . ./uselargefiles.cbu
fi
case "$uselargefiles" in
"$define")
        if $test -f uselargefiles.cbu; then
                echo " "
                echo "Rechecking to see how big your file offsets are..." >&4
                $cat >try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
int main()
{
    printf("%d\n", (int)sizeof($lseektype));
    return(0);
}
EOCP
                set try
                if eval $compile_ok; then
                        lseeksize=`$run ./try`
                        $echo "Your file offsets are now $lseeksize bytes long."
                else
                        dflt="$lseeksize"
                        echo " "
                        echo "(I can't seem to compile the test program.  Guessing...)"
                        rp="What is the size of your file offsets (in bytes)?"
                        . ./myread
                        lseeksize="$ans"
                fi
                case "$fpostype" in
                *_t) zzz="$fpostype"    ;;
                *)   zzz="fpos_t"       ;;
                esac
                $echo $n "Rechecking the size of $zzz...$c" >&4
                $cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
    printf("%d\n", (int)sizeof($fpostype));
    return(0);
}
EOCP
                set try
                if eval $compile_ok; then
                        yyy=`$run ./try`
                        dflt="$lseeksize"
                        case "$yyy" in
                        '')     echo " "
                                echo "(I can't execute the test program--guessing $fpossize.)" >&4
                                ;;
                        *)      fpossize=$yyy
                                echo " $fpossize bytes." >&4
                                ;;
                        esac
                else
                        dflt="$fpossize"
                        echo " "
                        echo "(I can't compile the test program.  Guessing...)" >&4
                        rp="What is the size of your file positions (in bytes)?"
                        . ./myread
                        fpossize="$ans"
                fi
                $rm -f try.c try
        fi
        ;;
esac

case "$vendorprefix" in
'')     d_vendorbin="$undef"
        vendorbin=''
        vendorbinexp=''
        ;;
*)      d_vendorbin="$define"
        : determine where vendor-supplied executables go.
        case "$vendorbin" in
        '') dflt=$vendorprefix/bin ;;
        *)      dflt="$vendorbin" ;;
        esac
        fn=d~+
        rp='Pathname for the vendor-supplied executables directory?'
        . ./getfile
        vendorbin="$ans"
        vendorbinexp="$ansexp"
        ;;
esac
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorbin=`echo $vendorbinexp | $sed "s#^$prefix#$installprefix#"`
else
        installvendorbin="$vendorbinexp"
fi

case "$vendorprefix" in
'')     vendorhtml1dir=''
        vendorhtml1direxp=''
        ;;
*)      : determine where vendor-supplied html pages go.
        : There is no standard location, so try to copy the previously-selected
        : directory structure for the core html pages.
        : XXX Better default suggestions would be welcome.
        case "$vendorhtml1dir" in
        '')     dflt=`echo "$html1dir" | $sed "s#^$prefix#$vendorprefix#"` ;;
        *)      dflt=$vendorhtml1dir ;;
        esac
        case "$dflt" in
        ''|' ') dflt=none ;;
        esac
        fn=dn+~
        rp='Pathname for the vendor-supplied html pages?'
        . ./getfile
        vendorhtml1dir="$ans"
        vendorhtml1direxp="$ansexp"
        ;;
esac
: Use ' ' for none so value is preserved next time through Configure
$test X"$vendorhtml1dir" = "X" && vendorhtml1dir=' '
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorhtml1dir=`echo $vendorhtml1direxp | $sed "s#^$prefix#$installprefix#"`
else
        installvendorhtml1dir="$vendorhtml1direxp"
fi

case "$vendorprefix" in
'')     vendorhtml3dir=''
        vendorhtml3direxp=''
        ;;
*)      : determine where vendor-supplied module html pages go.
        : There is no standard location, so try to copy the previously-selected
        : directory structure for the core html pages.
        : XXX Better default suggestions would be welcome.
        case "$vendorhtml3dir" in
        '')     dflt=`echo "$html3dir" | $sed "s#^$prefix#$vendorprefix#"` ;;
        *)      dflt=$vendorhtml3dir ;;
        esac
        case "$dflt" in
        ''|' ') dflt=none ;;
        esac
        fn=dn+~
        rp='Pathname for the vendor-supplied html pages?'
        . ./getfile
        vendorhtml3dir="$ans"
        vendorhtml3direxp="$ansexp"
        ;;
esac
: Use ' ' for none so value is preserved next time through Configure
$test X"$vendorhtml3dir" = "X" && vendorhtml3dir=' '
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorhtml3dir=`echo $vendorhtml3direxp | $sed "s#^$prefix#$installprefix#"`
else
        installvendorhtml3dir="$vendorhtml3direxp"
fi

case "$vendorprefix" in
'')     vendorman1dir=''
        vendorman1direxp=''
        ;;
*)      : determine where vendor-supplied manual pages go.
        case "$vendorman1dir" in
        '') dflt=`echo "$man1dir" | $sed "s#^$prefix#$vendorprefix#"` ;;
        *)      dflt=$vendorman1dir ;;
        esac
        case "$dflt" in
        ''|' ') dflt=none ;;
        esac
        fn=nd~+
        rp='Pathname for the vendor-supplied manual section 1 pages?'
        . ./getfile
        vendorman1dir="$ans"
        vendorman1direxp="$ansexp"
        ;;
esac
: Use ' ' for none so value is preserved next time through Configure
$test X"$vendorman1dir" = "X" && vendorman1dir=' '
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorman1dir=`echo "$vendorman1direxp" | $sed "s#^$prefix#$installprefix#"`
else
        installvendorman1dir="$vendorman1direxp"
fi

case "$vendorprefix" in
'')     vendorman3dir=''
        vendorman3direxp=''
        ;;
*)      : determine where vendor-supplied module manual pages go.
        case "$vendorman3dir" in
        '') dflt=`echo "$man3dir" | $sed "s#^$prefix#$vendorprefix#"` ;;
        *)      dflt=$vendorman3dir ;;
        esac
        case "$dflt" in
        ''|' ') dflt=none ;;
        esac
        fn=nd~+
        rp='Pathname for the vendor-supplied manual section 3 pages?'
        . ./getfile
        vendorman3dir="$ans"
        vendorman3direxp="$ansexp"
        ;;
esac
: Use ' ' for none so value is preserved next time through Configure
$test X"$vendorman3dir" = "X" && vendorman3dir=' '
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorman3dir=`echo "$vendorman3direxp" | $sed "s#^$prefix#$installprefix#"`
else
        installvendorman3dir="$vendorman3direxp"
fi

case "$vendorprefix" in
'')     d_vendorscript="$undef"
        vendorscript=''
        vendorscriptexp=''
        ;;
*)      d_vendorscript="$define"
        : determine where vendor-supplied scripts go.
        case "$vendorscript" in
        '')     dflt=$vendorprefix/script
                $test -d $dflt || dflt=$vendorbin ;;
        *)  dflt="$vendorscript" ;;
        esac
        $cat <<EOM

The installation process will create a directory for
vendor-supplied scripts.

EOM
        fn=d~+
        rp='Pathname for the vendor-supplied scripts directory?'
        . ./getfile
        vendorscript="$ans"
        vendorscriptexp="$ansexp"
        ;;
esac
: Change installation prefix, if necessary.
if $test X"$prefix" != X"$installprefix"; then
        installvendorscript=`echo $vendorscriptexp | $sed "s#^$prefix#$installprefix#"`
else
        installvendorscript="$vendorscriptexp"
fi

: see if qgcvt exists
set qgcvt d_qgcvt
eval $inlibc

echo " "

if $test X"$d_longdbl" = X"$define"; then

echo "Checking how to print long doubles..." >&4

if $test X"$sPRIfldbl" = X -a X"$doublesize" = X"$longdblsize"; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  double d = 123.456;
  printf("%.3f\n", d);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                123.456)
                        sPRIfldbl='"f"'; sPRIgldbl='"g"'; sPRIeldbl='"e"';
                        sPRIFUldbl='"F"'; sPRIGUldbl='"G"'; sPRIEUldbl='"E"';
                        echo "We will use %f."
                        ;;
                esac
        fi
fi

if $test X"$sPRIfldbl" = X; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  long double d = 123.456;
  printf("%.3Lf\n", d);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                123.456)
                        sPRIfldbl='"Lf"'; sPRIgldbl='"Lg"'; sPRIeldbl='"Le"';
                        sPRIFUldbl='"LF"'; sPRIGUldbl='"LG"'; sPRIEUldbl='"LE"';
                        echo "We will use %Lf."
                        ;;
                esac
        fi
fi

if $test X"$sPRIfldbl" = X; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  long double d = 123.456;
  printf("%.3llf\n", d);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                123.456)
                        sPRIfldbl='"llf"'; sPRIgldbl='"llg"'; sPRIeldbl='"lle"';
                        sPRIFUldbl='"llF"'; sPRIGUldbl='"llG"'; sPRIEUldbl='"llE"';
                        echo "We will use %llf."
                        ;;
                esac
        fi
fi

if $test X"$sPRIfldbl" = X; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  long double d = 123.456;
  printf("%.3lf\n", d);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                123.456)
                        sPRIfldbl='"lf"'; sPRIgldbl='"lg"'; sPRIeldbl='"le"';
                        sPRIFUldbl='"lF"'; sPRIGUldbl='"lG"'; sPRIEUldbl='"lE"';
                        echo "We will use %lf."
                        ;;
                esac
        fi
fi

if $test X"$sPRIfldbl" = X; then
        echo "Cannot figure out how to print long doubles." >&4
else
        sSCNfldbl=$sPRIfldbl    # expect consistency
fi

$rm -f try try.*

fi # d_longdbl

case "$sPRIfldbl" in
'')     d_PRIfldbl="$undef"; d_PRIgldbl="$undef"; d_PRIeldbl="$undef";
        d_PRIFUldbl="$undef"; d_PRIGUldbl="$undef"; d_PRIEUldbl="$undef";
        d_SCNfldbl="$undef";
        ;;
*)      d_PRIfldbl="$define"; d_PRIgldbl="$define"; d_PRIeldbl="$define";
        d_PRIFUldbl="$define"; d_PRIGUldbl="$define"; d_PRIEUldbl="$define";
        d_SCNfldbl="$define";
        ;;
esac

: Check how to convert floats to strings.

if test "X$d_Gconvert" = X; then

echo " "
echo "Checking for an efficient way to convert floats to strings."
echo " " > try.c
case "$uselongdouble" in
"$define") echo "#define USE_LONG_DOUBLE" >>try.c ;;
esac
case "$d_longdbl" in
"$define") echo "#define HAS_LONG_DOUBLE" >>try.c ;;
esac
case "$d_PRIgldbl" in
"$define") echo "#define HAS_PRIgldbl"    >>try.c ;;
esac
$cat >>try.c <<EOP
#ifdef TRY_gconvert
#define Gconvert(x,n,t,b) gconvert((x),(n),(t),(b))
char *myname = "gconvert";
#endif
#ifdef TRY_gcvt
#define Gconvert(x,n,t,b) gcvt((x),(n),(b))
char *myname = "gcvt";
#endif
#ifdef TRY_qgcvt
#define Gconvert(x,n,t,b) qgcvt((x),(n),(b))
char *myname = "qgcvt";
#define DOUBLETYPE long double
#endif
#ifdef TRY_sprintf
#if defined(USE_LONG_DOUBLE) && defined(HAS_LONG_DOUBLE)
#ifdef HAS_PRIgldbl
#define Gconvert(x,n,t,b) sprintf((b),"%.*"$sPRIgldbl,(n),(x))
#else
#define Gconvert(x,n,t,b) sprintf((b),"%.*g",(n),(double)(x))
#endif
#else
#define Gconvert(x,n,t,b) sprintf((b),"%.*g",(n),(x))
#endif
char *myname = "sprintf";
#endif

#ifndef DOUBLETYPE
#if defined(USE_LONG_DOUBLE) && defined(HAS_LONG_DOUBLE)
#define DOUBLETYPE long double
#else
#define DOUBLETYPE double
#endif
#endif

#include <stdio.h>

#define I_STDLIB $i_stdlib
#ifdef I_STDLIB
#include <stdlib.h>
#endif

int
checkit(expect, got)
char *expect;
char *got;
{
    if (strcmp(expect, got)) {
                printf("%s oddity:  Expected %s, got %s\n",
                        myname, expect, got);
                exit(1);
        }
}

int main()
{
        char buf[64];
        buf[63] = '\0';

        /* This must be 1st test on (which?) platform */
        /* Alan Burlison <AlanBurlsin@unn.unisys.com> */
        Gconvert((DOUBLETYPE)0.1, 8, 0, buf);
        checkit("0.1", buf);

        Gconvert((DOUBLETYPE)0.01, 8, 0, buf);
        checkit("0.01", buf);

        Gconvert((DOUBLETYPE)0.001, 8, 0, buf);
        checkit("0.001", buf);

        Gconvert((DOUBLETYPE)0.0001, 8, 0, buf);
        checkit("0.0001", buf);

        Gconvert((DOUBLETYPE)0.00009, 8, 0, buf);
        if (strlen(buf) > 5)
            checkit("9e-005", buf); /* for Microsoft ?? */
        else
            checkit("9e-05", buf);

        Gconvert((DOUBLETYPE)1.0, 8, 0, buf);
        checkit("1", buf);

        Gconvert((DOUBLETYPE)1.1, 8, 0, buf);
        checkit("1.1", buf);

        Gconvert((DOUBLETYPE)1.01, 8, 0, buf);
        checkit("1.01", buf);

        Gconvert((DOUBLETYPE)1.001, 8, 0, buf);
        checkit("1.001", buf);

        Gconvert((DOUBLETYPE)1.0001, 8, 0, buf);
        checkit("1.0001", buf);

        Gconvert((DOUBLETYPE)1.00001, 8, 0, buf);
        checkit("1.00001", buf);

        Gconvert((DOUBLETYPE)1.000001, 8, 0, buf);
        checkit("1.000001", buf);

        Gconvert((DOUBLETYPE)0.0, 8, 0, buf);
        checkit("0", buf);

        Gconvert((DOUBLETYPE)-1.0, 8, 0, buf);
        checkit("-1", buf);

        /* Some Linux gcvt's give 1.e+5 here. */
        Gconvert((DOUBLETYPE)100000.0, 8, 0, buf);
        checkit("100000", buf);

        /* Some Linux gcvt's give -1.e+5 here. */
        Gconvert((DOUBLETYPE)-100000.0, 8, 0, buf);
        checkit("-100000", buf);

        Gconvert((DOUBLETYPE)123.456, 8, 0, buf);
        checkit("123.456", buf);

        /* Testing of 1e+129 in bigintpm.t must not get extra '.' here. */
        Gconvert((DOUBLETYPE)1e34, 8, 0, buf);
        /* 34 should be enough to scare even long double
         * places into using the e notation. */
        if (strlen(buf) > 5)
            checkit("1e+034", buf); /* for Microsoft */
        else
            checkit("1e+34", buf);

        /* For Perl, if you add additional tests here, also add them to
         * t/base/num.t for benefit of platforms not using Configure or
         * overriding d_Gconvert */

        exit(0);
}
EOP
: first add preferred functions to our list
xxx_list=""
for xxx_convert in $gconvert_preference; do
    case $xxx_convert in
    gcvt|gconvert|sprintf) xxx_list="$xxx_list $xxx_convert" ;;
    *) echo "Discarding unrecognized gconvert_preference $xxx_convert" >&4 ;;
    esac
done
: then add any others
for xxx_convert in gconvert gcvt sprintf; do
    case "$xxx_list" in
    *$xxx_convert*) ;;
    *) xxx_list="$xxx_list $xxx_convert" ;;
    esac
done

case "$d_longdbl$uselongdouble" in
"$define$define")
    : again, add prefered functions to our list first
    xxx_ld_list=""
    for xxx_convert in $gconvert_ld_preference; do
        case $xxx_convert in
        qgcvt|gcvt|gconvert|sprintf) xxx_ld_list="$xxx_ld_list $xxx_convert" ;;
        *) echo "Discarding unrecognized gconvert_ld_preference $xxx_convert" ;;
        esac
    done
    : then add qgcvt, sprintf--then, in xxx_list order, gconvert and gcvt
    for xxx_convert in qgcvt sprintf $xxx_list; do
        case "$xxx_ld_list" in
        $xxx_convert*|*" $xxx_convert"*) ;;
        *) xxx_ld_list="$xxx_ld_list $xxx_convert" ;;
        esac
    done
    : if sprintf cannot do long doubles, move it to the end
    if test "$d_PRIgldbl" != "$define"; then
        xxx_ld_list="`echo $xxx_ld_list|sed s/sprintf//` sprintf"
    fi
    : if no qgcvt, remove it
    if test "$d_qgcvt" != "$define"; then
        xxx_ld_list="`echo $xxx_ld_list|sed s/qgcvt//`"
    fi
    : use the ld_list
    xxx_list="$xxx_ld_list"
    ;;
esac

for xxx_convert in $xxx_list; do
        echo "Trying $xxx_convert..."
        $rm -f try try$_o
        set try -DTRY_$xxx_convert
        if eval $compile; then
                echo "$xxx_convert() found." >&4
                if $run ./try; then
                        echo "I'll use $xxx_convert to convert floats into a string." >&4
                        break;
                else
                        echo "...But $xxx_convert didn't work as I expected."
                        xxx_convert=''
                fi
        else
                echo "$xxx_convert NOT found." >&4
        fi
done

if test X$xxx_convert = X; then
    echo "*** WHOA THERE!!! ***" >&4
    echo "None of ($xxx_list)  seemed to work properly.  I'll use sprintf." >&4
    xxx_convert=sprintf
fi

case "$xxx_convert" in
gconvert) d_Gconvert='gconvert((x),(n),(t),(b))' ;;
gcvt) d_Gconvert='gcvt((x),(n),(b))' ;;
qgcvt) d_Gconvert='qgcvt((x),(n),(b))' ;;
*) case "$uselongdouble$d_longdbl$d_PRIgldbl" in
   "$define$define$define")
      d_Gconvert="sprintf((b),\"%.*\"$sPRIgldbl,(n),(x))" ;;
   "$define$define$undef")
      d_Gconvert='sprintf((b),"%.*g",(n),(double)(x))' ;;
   *) d_Gconvert='sprintf((b),"%.*g",(n),(x))' ;;
   esac
   ;;
esac

fi

: see if _fwalk exists
set fwalk d__fwalk
eval $inlibc

: Initialize h_fcntl
h_fcntl=false

: Initialize h_sysfile
h_sysfile=false

: access call always available on UNIX
set access d_access
eval $inlibc

: locate the flags for 'access()'
case "$d_access" in
"$define")
        echo " "
        $cat >access.c <<EOCP
#include <sys/types.h>
#ifdef I_FCNTL
#include <fcntl.h>
#endif
#ifdef I_SYS_FILE
#include <sys/file.h>
#endif
#ifdef I_UNISTD
#include <unistd.h>
#endif
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
        exit(R_OK);
}
EOCP
        : check sys/file.h first, no particular reason here
        if $test `./findhdr sys/file.h` && \
                $cc -o access $cppflags -DI_SYS_FILE access.c >/dev/null 2>&1 ; then
                h_sysfile=true;
                echo "<sys/file.h> defines the *_OK access constants." >&4
        elif $test `./findhdr fcntl.h` && \
                $cc -o access $cppflags -DI_FCNTL access.c >/dev/null 2>&1 ; then
                h_fcntl=true;
                echo "<fcntl.h> defines the *_OK access constants." >&4
        elif $test `./findhdr unistd.h` && \
                $cc -o access $cppflags -DI_UNISTD access.c >/dev/null 2>&1 ; then
                echo "<unistd.h> defines the *_OK access constants." >&4
        else
                echo "I can't find the four *_OK access constants--I'll use mine." >&4
        fi
        ;;
esac
$rm -f access*

: see if accessx exists
set accessx d_accessx
eval $inlibc

: see if aintl exists
set aintl d_aintl
eval $inlibc

: see if alarm exists
set alarm d_alarm
eval $inlibc

: see if POSIX threads are available
set pthread.h i_pthread
eval $inhdr

: define a fucntion to check prototypes
$cat > protochk <<EOSH
$startsh
cc="$cc"
optimize="$optimize"
ccflags="$ccflags"
prototype="$prototype"
define="$define"
rm=$rm
usethreads=$usethreads
i_pthread=$i_pthread
pthread_h_first=$pthread_h_first
EOSH

$cat >> protochk <<'EOSH'

$rm -f try.c
foo="$1"
shift
while test $# -ge 2; do
        case "$1" in
                $define) echo "#include <$2>" >> try.c ;;
                literal) echo "$2" >> try.c ;;
        esac
    # Extra magic for the benefit of systems that need pthread.h
    # to be included early to correctly detect threadsafe functions.
    # Such functions must guarantee themselves, though, that the usethreads
    # and i_pthread have been defined, before calling protochk.
    if test "$usethreads" = "$define" -a "$i_pthread" = "$define" -a "$pthread_h_first" = "$define" -a "$pthread_h_done" = ""; then
        echo "#include <pthread.h>" >> try.c
        pthread_h_done=yes
    fi
    shift 2
done
test "$prototype" = "$define"  && echo '#define CAN_PROTOTYPE' >> try.c
cat >> try.c <<'EOCP'
#ifdef CAN_PROTOTYPE
#define _(args) args
#else
#define _(args) ()
#endif
EOCP
echo "$foo" >> try.c
echo 'int no_real_function_has_this_name _((void)) { return 0; }' >> try.c
$cc $optimize $ccflags -c try.c > /dev/null 2>&1
status=$?
$rm -f try.[co]
exit $status
EOSH
chmod +x protochk
$eunicefix protochk

hasproto='varname=$1; func=$2; shift; shift;
while $test $# -ge 2; do
        case "$1" in
        $define) echo "#include <$2>";;
        esac ;
    shift 2;
done > try.c;
$cppstdin $cppflags $cppminus < try.c > tryout.c 2>/dev/null;
if $contains "$func.*(" tryout.c >/dev/null 2>&1; then
        echo "$func() prototype found.";
        val="$define";
else
        echo "$func() prototype NOT found.";
        val="$undef";
fi;
set $varname;
eval $setvar;
$rm -f try.c tryout.c'

: see if sys/types.h has to be included
set sys/types.h i_systypes
eval $inhdr

: see if sys/select.h has to be included
set sys/select.h i_sysselct
eval $inhdr

hasfield='varname=$1; struct=$2; field=$3; shift; shift; shift;
while $test $# -ge 2; do
        case "$1" in
        $define) echo "#include <$2>";;
        esac ;
    shift 2;
done > try.c;
echo "int main () { struct $struct foo; char* bar; bar = (char*)foo.$field; }" >> try.c;
set try;
if eval $compile; then
        val="$define";
else
        val="$undef";
fi;
set $varname;
eval $setvar;
$rm -f try.c try.o'

: see if we should include time.h, sys/time.h, or both
echo " "
if test "X$timeincl" = X; then
        echo "Testing to see if we should include <time.h>, <sys/time.h> or both." >&4
        $echo $n "I'm now running the test program...$c"
        $cat >try.c <<EOCP
#include <sys/types.h>
#ifdef I_TIME
#include <time.h>
#endif
#ifdef I_SYSTIME
#ifdef SYSTIMEKERNEL
#define KERNEL
#endif
#include <sys/time.h>
#endif
#ifdef I_SYSSELECT
#include <sys/select.h>
#endif
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
        struct tm foo;
#ifdef S_TIMEVAL
        struct timeval bar;
#endif
#ifdef S_TIMEZONE
        struct timezone tzp;
#endif
        if (foo.tm_sec == foo.tm_sec)
                exit(0);
#ifdef S_TIMEVAL
        if (bar.tv_sec == bar.tv_sec)
                exit(0);
#endif
        exit(1);
}
EOCP
        flags=''
        for s_timezone in '-DS_TIMEZONE' ''; do
        sysselect=''
        for s_timeval in '-DS_TIMEVAL' ''; do
        for i_systimek in '' '-DSYSTIMEKERNEL'; do
        for i_time in '' '-DI_TIME'; do
        for i_systime in '-DI_SYSTIME' ''; do
                case "$flags" in
                '') $echo $n ".$c"
                        set try $i_time $i_systime $i_systimek $sysselect $s_timeval $s_timezone
                        if eval $compile; then
                                set X $i_time $i_systime $i_systimek $sysselect $s_timeval
                                shift
                                flags="$*"
                                echo " "
                                $echo $n "Succeeded with $flags$c"
                        fi
                        ;;
                esac
        done
        done
        done
        done
        done
        timeincl=''
        echo " "
        case "$flags" in
        *SYSTIMEKERNEL*) i_systimek="$define"
                timeincl=`./findhdr sys/time.h`
                echo "We'll include <sys/time.h> with KERNEL defined." >&4;;
        *) i_systimek="$undef";;
        esac
        case "$flags" in
        *I_TIME*) i_time="$define"
                timeincl=`./findhdr time.h`" $timeincl"
                echo "We'll include <time.h>." >&4;;
        *) i_time="$undef";;
        esac
        case "$flags" in
        *I_SYSTIME*) i_systime="$define"
                timeincl=`./findhdr sys/time.h`" $timeincl"
                echo "We'll include <sys/time.h>." >&4;;
        *) i_systime="$undef";;
        esac
        $rm -f try.c try
fi
: see if struct tm knows about tm_zone
case "$i_systime$i_time" in
*$define*)
        echo " "
        echo "Checking to see if your struct tm has tm_zone field..." >&4
        set d_tm_tm_zone tm tm_zone $i_systime sys/time.h $i_time time.h
        eval $hasfield
        ;;
*)      val="$undef"
        set d_tm_tm_zone
        eval $setvar
        ;;
esac
case "$d_tm_tm_zone" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac
: see if struct tm knows about tm_gmtoff
case "$i_systime$i_time" in
*$define*)
        echo " "
        echo "Checking to see if your struct tm has tm_gmtoff field..." >&4
        set d_tm_tm_gmtoff tm tm_gmtoff $i_systime sys/time.h $i_time time.h
        eval $hasfield
        ;;
*)      val="$undef"
        set d_tm_tm_gmtoff
        eval $setvar
        ;;
esac
case "$d_tm_tm_gmtoff" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac

: see if asctime_r exists
set asctime_r d_asctime_r
eval $inlibc
case "$d_asctime_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_time time.h $i_systime sys/time.h"
        case "$d_asctime_r_proto:$usethreads" in
        ":define")      d_asctime_r_proto=define
                set d_asctime_r_proto asctime_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_asctime_r_proto" in
        define)
        case "$asctime_r_proto" in
        ''|0) try='char* asctime_r(const struct tm*, char*);'
        ./protochk "extern $try" $hdrs && asctime_r_proto=B_SB ;;
        esac
        case "$asctime_r_proto" in
        ''|0) try='char* asctime_r(const struct tm*, char*, int);'
        ./protochk "extern $try" $hdrs && asctime_r_proto=B_SBI ;;
        esac
        case "$asctime_r_proto" in
        ''|0) try='int asctime_r(const struct tm*, char*);'
        ./protochk "extern $try" $hdrs && asctime_r_proto=I_SB ;;
        esac
        case "$asctime_r_proto" in
        ''|0) try='int asctime_r(const struct tm*, char*, int);'
        ./protochk "extern $try" $hdrs && asctime_r_proto=I_SBI ;;
        esac
        case "$asctime_r_proto" in
        ''|0)   d_asctime_r=undef
                asctime_r_proto=0
                echo "Disabling asctime_r, cannot determine prototype." >&4 ;;
        * )     case "$asctime_r_proto" in
                REENTRANT_PROTO*) ;;
                *) asctime_r_proto="REENTRANT_PROTO_$asctime_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "asctime_r has no prototype, not using it." >&4 ;;
                esac
                d_asctime_r=undef
                asctime_r_proto=0
                ;;
        esac
        ;;
*)      asctime_r_proto=0
        ;;
esac

: see if atolf exists
set atolf d_atolf
eval $inlibc

: see if atoll exists
set atoll d_atoll
eval $inlibc

: Look for GNU-cc style attribute checking
echo " "
echo "Checking whether your compiler can handle __attribute__ ..." >&4
$cat >attrib.c <<'EOCP'
#include <stdio.h>
void croak (char* pat,...) __attribute__((__format__(__printf__,1,2),noreturn));
EOCP
if $cc $ccflags -c attrib.c >attrib.out 2>&1 ; then
        if $contains 'warning' attrib.out >/dev/null 2>&1; then
                echo "Your C compiler doesn't fully support __attribute__."
                val="$undef"
        else
                echo "Your C compiler supports __attribute__."
                val="$define"
        fi
else
        echo "Your C compiler doesn't seem to understand __attribute__ at all."
        val="$undef"
fi
set d_attribut
eval $setvar
$rm -f attrib*

: see if bcmp exists
set bcmp d_bcmp
eval $inlibc

: see if bcopy exists
set bcopy d_bcopy
eval $inlibc

: see if this is a unistd.h system
set unistd.h i_unistd
eval $inhdr

: see if getpgrp exists
set getpgrp d_getpgrp
eval $inlibc

case "$d_getpgrp" in
"$define")
        echo " "
        echo "Checking to see which flavor of getpgrp is in use..."
        $cat >try.c <<EOP
#$i_unistd I_UNISTD
#include <sys/types.h>
#ifdef I_UNISTD
#  include <unistd.h>
#endif
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
        if (getuid() == 0) {
                printf("(I see you are running Configure as super-user...)\n");
                setuid(1);
        }
#ifdef TRY_BSD_PGRP
        if (getpgrp(1) == 0)
                exit(0);
#else
        if (getpgrp() > 0)
                exit(0);
#endif
        exit(1);
}
EOP
        if $cc -o try -DTRY_BSD_PGRP $ccflags $ldflags try.c $libs >/dev/null 2>&1 && $run ./try; then
                echo "You have to use getpgrp(pid) instead of getpgrp()." >&4
                val="$define"
        elif $cc -o try $ccflags $ldflags try.c $libs >/dev/null 2>&1 && $run ./try; then
                echo "You have to use getpgrp() instead of getpgrp(pid)." >&4
                val="$undef"
        else
                echo "I can't seem to compile and run the test program."
                if ./usg; then
                        xxx="a USG one, i.e. you use getpgrp()."
                else
                        # SVR4 systems can appear rather BSD-ish.
                        case "$i_unistd" in
                        $undef)
                                xxx="a BSD one, i.e. you use getpgrp(pid)."
                                val="$define"
                                ;;
                        $define)
                                xxx="probably a USG one, i.e. you use getpgrp()."
                                val="$undef"
                                ;;
                        esac
                fi
                echo "Assuming your getpgrp is $xxx" >&4
        fi
        ;;
*) val="$undef";;
esac
set d_bsdgetpgrp
eval $setvar
$rm -f try try.*

: see if setpgrp exists
set setpgrp d_setpgrp
eval $inlibc

case "$d_setpgrp" in
"$define")
        echo " "
        echo "Checking to see which flavor of setpgrp is in use..."
        $cat >try.c <<EOP
#$i_unistd I_UNISTD
#include <sys/types.h>
#ifdef I_UNISTD
#  include <unistd.h>
#endif
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
        if (getuid() == 0) {
                printf("(I see you are running Configure as super-user...)\n");
                setuid(1);
        }
#ifdef TRY_BSD_PGRP
        if (-1 == setpgrp(1, 1))
                exit(0);
#else
        if (setpgrp() != -1)
                exit(0);
#endif
        exit(1);
}
EOP
        if $cc -o try -DTRY_BSD_PGRP $ccflags $ldflags try.c $libs >/dev/null 2>&1 && $run ./try; then
                echo 'You have to use setpgrp(pid,pgrp) instead of setpgrp().' >&4
                val="$define"
        elif $cc -o try $ccflags $ldflags try.c $libs >/dev/null 2>&1 && $run ./try; then
                echo 'You have to use setpgrp() instead of setpgrp(pid,pgrp).' >&4
                val="$undef"
        else
                echo "(I can't seem to compile and run the test program.)"
                if ./usg; then
                        xxx="a USG one, i.e. you use setpgrp()."
                else
                        # SVR4 systems can appear rather BSD-ish.
                        case "$i_unistd" in
                        $undef)
                                xxx="a BSD one, i.e. you use setpgrp(pid,pgrp)."
                                val="$define"
                                ;;
                        $define)
                                xxx="probably a USG one, i.e. you use setpgrp()."
                                val="$undef"
                                ;;
                        esac
                fi
                echo "Assuming your setpgrp is $xxx" >&4
        fi
        ;;
*) val="$undef";;
esac
set d_bsdsetpgrp
eval $setvar
$rm -f try try.*
: see if bzero exists
set bzero d_bzero
eval $inlibc

: see if signal is declared as pointer to function returning int or void
echo " "
xxx=`./findhdr signal.h`
$test "$xxx" && $cppstdin $cppminus $cppflags < $xxx >$$.tmp 2>/dev/null
if $contains 'int.*\*[  ]*signal' $$.tmp >/dev/null 2>&1 ; then
        echo "You have int (*signal())() instead of void." >&4
        val="$undef"
elif $contains 'void.*\*[       ]*signal' $$.tmp >/dev/null 2>&1 ; then
        echo "You have void (*signal())()." >&4
        val="$define"
elif $contains 'extern[         ]*[(\*]*signal' $$.tmp >/dev/null 2>&1 ; then
        echo "You have int (*signal())() instead of void." >&4
        val="$undef"
elif $contains 'void.*\*.*sig' $$.tmp >/dev/null 2>&1 ; then
        echo "You have void (*signal())()." >&4
        val="$define"
else
        case "$d_voidsig" in
        '')
        echo "I can't determine whether signal handler returns void or int..." >&4
                dflt=void
                rp="What type does your signal handler return?"
                . ./myread
                case "$ans" in
                v*) val="$define";;
                *) val="$undef";;
                esac;;
        "$define")
                echo "As you already told me, signal handler returns void." >&4
                val="$define"
                ;;
        *)      echo "As you already told me, signal handler returns int." >&4
                val="$undef"
                ;;
        esac
fi
set d_voidsig
eval $setvar
case "$d_voidsig" in
"$define") signal_t="void";;
*) signal_t="int";;
esac
$rm -f $$.tmp

: check for ability to cast large floats to 32-bit ints.
echo " "
echo 'Checking whether your C compiler can cast large floats to int32.' >&4
if $test "$intsize" -ge 4; then
        xxx=int
else
        xxx=long
fi
$cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <sys/types.h>
#include <signal.h>
$signal_t blech(s) int s; { exit(3); }
int main()
{
        $xxx i32;
        double f, g;
        int result = 0;
        char str[16];
        signal(SIGFPE, blech);

        /* Don't let compiler optimize the test away.  Store the number
           in a writable string for gcc to pass to sscanf under HP/UX.
        */
        sprintf(str, "2147483647");
        sscanf(str, "%lf", &f); /* f = (double) 0x7fffffff; */
        g = 10 * f;
        i32  = ($xxx) g;

        /* x86 processors will probably give 0x8000 0000, which is a
           sign change.  We don't want that.  We want to mimic SPARC
           behavior here, which is to preserve the sign and give
           back 0x7fff ffff.
        */
        if (i32 != ($xxx) f)
                result |= 1;
        exit(result);
}
EOCP
set try
if eval $compile_ok; then
        $run ./try
        yyy=$?
else
        echo "(I can't seem to compile the test program--assuming it can't)"
        yyy=1
fi
case "$yyy" in
0)      val="$define"
        echo "Yup, it can."
        ;;
*)      val="$undef"
        echo "Nope, it can't."
        ;;
esac
set d_casti32
eval $setvar
$rm -f try try.*

: check for ability to cast negative floats to unsigned
echo " "
echo 'Checking whether your C compiler can cast negative float to unsigned.' >&4
$cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <sys/types.h>
#include <signal.h>
$signal_t blech(s) int s; { exit(7); }
$signal_t blech_in_list(s) int s; { exit(4); }
unsigned long dummy_long(p) unsigned long p; { return p; }
unsigned int dummy_int(p) unsigned int p; { return p; }
unsigned short dummy_short(p) unsigned short p; { return p; }
int main()
{
        double f;
        unsigned long along;
        unsigned int aint;
        unsigned short ashort;
        int result = 0;
        char str[16];

        /* Frustrate gcc-2.7.2's optimizer which failed this test with
           a direct f = -123. assignment.  gcc-2.8.0 reportedly
           optimized the whole file away
        */
        /* Store the number in a writable string for gcc to pass to
           sscanf under HP/UX.
        */
        sprintf(str, "-123");
        sscanf(str, "%lf", &f);  /* f = -123.; */

        signal(SIGFPE, blech);
        along = (unsigned long)f;
        aint = (unsigned int)f;
        ashort = (unsigned short)f;
        if (along != (unsigned long)-123)
                result |= 1;
        if (aint != (unsigned int)-123)
                result |= 1;
        if (ashort != (unsigned short)-123)
                result |= 1;
        sprintf(str, "1073741824.");
        sscanf(str, "%lf", &f); /* f = (double)0x40000000; */
        f = f + f;
        along = 0;
        along = (unsigned long)f;
        if (along != 0x80000000)
                result |= 2;
        f -= 1.;
        along = 0;
        along = (unsigned long)f;
        if (along != 0x7fffffff)
                result |= 1;
        f += 2.;
        along = 0;
        along = (unsigned long)f;
        if (along != 0x80000001)
                result |= 2;
        if (result)
                exit(result);
        signal(SIGFPE, blech_in_list);
        sprintf(str, "123.");
        sscanf(str, "%lf", &f);  /* f = 123.; */
        along = dummy_long((unsigned long)f);
        aint = dummy_int((unsigned int)f);
        ashort = dummy_short((unsigned short)f);
        if (along != (unsigned long)123)
                result |= 4;
        if (aint != (unsigned int)123)
                result |= 4;
        if (ashort != (unsigned short)123)
                result |= 4;
        exit(result);

}
EOCP
set try
if eval $compile_ok; then
        $run ./try
        castflags=$?
else
        echo "(I can't seem to compile the test program--assuming it can't)"
        castflags=7
fi
case "$castflags" in
0)      val="$define"
        echo "Yup, it can."
        ;;
*)      val="$undef"
        echo "Nope, it can't."
        ;;
esac
set d_castneg
eval $setvar
$rm -f try.*

: see if vprintf exists
echo " "
if set vprintf val -f d_vprintf; eval $csym; $val; then
        echo 'vprintf() found.' >&4
        val="$define"
        $cat >try.c <<EOF
#include <varargs.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif

int main() { xxx("foo"); }

xxx(va_alist)
va_dcl
{
        va_list args;
        char buf[10];

        va_start(args);
        exit((unsigned long)vsprintf(buf,"%s",args) > 10L);
}
EOF
        set try
        if eval $compile && $run ./try; then
                echo "Your vsprintf() returns (int)." >&4
                val2="$undef"
        else
                echo "Your vsprintf() returns (char*)." >&4
                val2="$define"
        fi
else
        echo 'vprintf() NOT found.' >&4
                val="$undef"
                val2="$undef"
fi
$rm -f try try.*
set d_vprintf
eval $setvar
val=$val2
set d_charvspr
eval $setvar

: see if chown exists
set chown d_chown
eval $inlibc

: see if chroot exists
set chroot d_chroot
eval $inlibc

: see if chsize exists
set chsize d_chsize
eval $inlibc

: see if class exists
set class d_class
eval $inlibc

hasstruct='varname=$1; struct=$2; shift; shift;
while $test $# -ge 2; do
        case "$1" in
        $define) echo "#include <$2>";;
        esac ;
    shift 2;
done > try.c;
echo "int main () { struct $struct foo; }" >> try.c;
set try;
if eval $compile; then
        val="$define";
else
        val="$undef";
fi;
set $varname;
eval $setvar;
$rm -f try.c try.o'

socketlib=''
sockethdr=''
: see whether socket exists
echo " "
$echo $n "Hmm... $c" >&4
if set socket val -f d_socket; eval $csym; $val; then
        echo "Looks like you have Berkeley networking support." >&4
        d_socket="$define"
        if set setsockopt val -f; eval $csym; $val; then
                d_oldsock="$undef"
        else
                echo "...but it uses the old BSD 4.1c interface, rather than 4.2." >&4
                d_oldsock="$define"
        fi
else
        if $contains socklib libc.list >/dev/null 2>&1; then
                echo "Looks like you have Berkeley networking support." >&4
                d_socket="$define"
                : we will have to assume that it supports the 4.2 BSD interface
                d_oldsock="$undef"
        else
                echo "You don't have Berkeley networking in libc$_a..." >&4
                if test "X$d_socket" = "X$define"; then
                   echo "...but you seem to believe that you have sockets." >&4
                else
                        for net in net socket
                        do
                                if test -f /usr/lib/lib$net$_a; then
                                        ( ($nm $nm_opt /usr/lib/lib$net$_a | eval $nm_extract) ||  \
                                        $ar t /usr/lib/lib$net$_a) 2>/dev/null >> libc.list
                                        if $contains socket libc.list >/dev/null 2>&1; then
                                                d_socket="$define"
                                                socketlib="-l$net"
                                                case "$net" in
                                                net)
                                                        echo "...but the Wollongong group seems to have hacked it in." >&4
                                                        sockethdr="-I/usr/netinclude"
                                                        ;;
                                                esac
                                                echo "Found Berkeley sockets interface in lib$net." >&4
                                                if $contains setsockopt libc.list >/dev/null 2>&1; then
                                                        d_oldsock="$undef"
                                                else
                                                        echo "...using the old BSD 4.1c interface, rather than 4.2." >&4
                                                        d_oldsock="$define"
                                                fi
                                                break
                                        fi
                                fi
                        done
                        if test "X$d_socket" != "X$define"; then
                           echo "or anywhere else I see." >&4
                           d_socket="$undef"
                           d_oldsock="$undef"
                        fi
                fi
        fi
fi

: see if socketpair exists
set socketpair d_sockpair
eval $inlibc


echo " "
echo "Checking the availability of certain socket constants..." >&4
for ENUM in MSG_CTRUNC MSG_DONTROUTE MSG_OOB MSG_PEEK MSG_PROXY SCM_RIGHTS; do
        enum=`$echo $ENUM|./tr '[A-Z]' '[a-z]'`
        $cat >try.c <<EOF
#include <sys/types.h>
#include <sys/socket.h>
int main() {
    int i = $ENUM;
}
EOF
        val="$undef"
        set try; if eval $compile; then
                val="$define"
        fi
        set d_${enum}; eval $setvar
        $rm -f try.c try
done

: see if this is a sys/uio.h system
set sys/uio.h i_sysuio
eval $inhdr


echo " "
echo "Checking to see if your system supports struct cmsghdr..." >&4
set d_cmsghdr_s cmsghdr $i_systypes sys/types.h $d_socket sys/socket.h $i_sysuio sys/uio.h
eval $hasstruct
case "$d_cmsghdr_s" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac


: check for const keyword
echo " "
echo 'Checking to see if your C compiler knows about "const"...' >&4
$cat >const.c <<'EOCP'
typedef struct spug { int drokk; } spug;
int main()
{
        const char *foo;
        const spug y;
}
EOCP
if $cc -c $ccflags const.c >/dev/null 2>&1 ; then
        val="$define"
        echo "Yup, it does."
else
        val="$undef"
        echo "Nope, it doesn't."
fi
set d_const
eval $setvar

: see if copysignl exists
set copysignl d_copysignl
eval $inlibc

: see if crypt exists
echo " "
set crypt d_crypt
eval $inlibc
case "$d_crypt" in
$define) cryptlib='' ;;
*)      if set crypt val -f d_crypt; eval $csym; $val; then
                echo 'crypt() found.' >&4
                val="$define"
                cryptlib=''
        else
                cryptlib=`./loc Slibcrypt$_a "" $xlibpth`
                if $test -z "$cryptlib"; then
                        cryptlib=`./loc Mlibcrypt$_a "" $xlibpth`
                else
                        cryptlib=-lcrypt
                fi
                if $test -z "$cryptlib"; then
                        cryptlib=`./loc Llibcrypt$_a "" $xlibpth`
                else
                        cryptlib=-lcrypt
                fi
                if $test -z "$cryptlib"; then
                        cryptlib=`./loc libcrypt$_a "" $libpth`
                else
                        cryptlib=-lcrypt
                fi
                if $test -z "$cryptlib"; then
                        echo 'crypt() NOT found.' >&4
                        val="$undef"
                else
                        val="$define"
                fi
        fi
        set d_crypt
        eval $setvar
        ;;
esac

: see if this is a crypt.h system
set crypt.h i_crypt
eval $inhdr

: see if crypt_r exists
set crypt_r d_crypt_r
eval $inlibc
case "$d_crypt_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_crypt crypt.h"
        case "$d_crypt_r_proto:$usethreads" in
        ":define")      d_crypt_r_proto=define
                set d_crypt_r_proto crypt_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_crypt_r_proto" in
        define)
        case "$crypt_r_proto" in
        ''|0) try='char* crypt_r(const char*, const char*, struct crypt_data*);'
        ./protochk "extern $try" $hdrs && crypt_r_proto=B_CCS ;;
        esac
        case "$crypt_r_proto" in
        ''|0) try='char* crypt_r(const char*, const char*, CRYPTD*);'
        ./protochk "extern $try" $hdrs && crypt_r_proto=B_CCD ;;
        esac
        case "$crypt_r_proto" in
        ''|0)   d_crypt_r=undef
                crypt_r_proto=0
                echo "Disabling crypt_r, cannot determine prototype." >&4 ;;
        * )     case "$crypt_r_proto" in
                REENTRANT_PROTO*) ;;
                *) crypt_r_proto="REENTRANT_PROTO_$crypt_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "crypt_r has no prototype, not using it." >&4 ;;
                esac
                d_crypt_r=undef
                crypt_r_proto=0
                ;;
        esac
        ;;
*)      crypt_r_proto=0
        ;;
esac

: get csh whereabouts
case "$csh" in
'csh') val="$undef" ;;
*) val="$define" ;;
esac
set d_csh
eval $setvar
: Respect a hint or command line value for full_csh.
case "$full_csh" in
'') full_csh=$csh ;;
esac

: see if ctermid_r exists
set ctermid_r d_ctermid_r
eval $inlibc
case "$d_ctermid_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h "
        case "$d_ctermid_r_proto:$usethreads" in
        ":define")      d_ctermid_r_proto=define
                set d_ctermid_r_proto ctermid_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_ctermid_r_proto" in
        define)
        case "$ctermid_r_proto" in
        ''|0) try='char* ctermid_r(char*);'
        ./protochk "extern $try" $hdrs && ctermid_r_proto=B_B ;;
        esac
        case "$ctermid_r_proto" in
        ''|0)   d_ctermid_r=undef
                ctermid_r_proto=0
                echo "Disabling ctermid_r, cannot determine prototype." >&4 ;;
        * )     case "$ctermid_r_proto" in
                REENTRANT_PROTO*) ;;
                *) ctermid_r_proto="REENTRANT_PROTO_$ctermid_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "ctermid_r has no prototype, not using it." >&4 ;;
                esac
                d_ctermid_r=undef
                ctermid_r_proto=0
                ;;
        esac
        ;;
*)      ctermid_r_proto=0
        ;;
esac

: see if ctime_r exists
set ctime_r d_ctime_r
eval $inlibc
case "$d_ctime_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_time time.h $i_systime sys/time.h"
        case "$d_ctime_r_proto:$usethreads" in
        ":define")      d_ctime_r_proto=define
                set d_ctime_r_proto ctime_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_ctime_r_proto" in
        define)
        case "$ctime_r_proto" in
        ''|0) try='char* ctime_r(const time_t*, char*);'
        ./protochk "extern $try" $hdrs && ctime_r_proto=B_SB ;;
        esac
        case "$ctime_r_proto" in
        ''|0) try='char* ctime_r(const time_t*, char*, int);'
        ./protochk "extern $try" $hdrs && ctime_r_proto=B_SBI ;;
        esac
        case "$ctime_r_proto" in
        ''|0) try='int ctime_r(const time_t*, char*);'
        ./protochk "extern $try" $hdrs && ctime_r_proto=I_SB ;;
        esac
        case "$ctime_r_proto" in
        ''|0) try='int ctime_r(const time_t*, char*, int);'
        ./protochk "extern $try" $hdrs && ctime_r_proto=I_SBI ;;
        esac
        case "$ctime_r_proto" in
        ''|0)   d_ctime_r=undef
                ctime_r_proto=0
                echo "Disabling ctime_r, cannot determine prototype." >&4 ;;
        * )     case "$ctime_r_proto" in
                REENTRANT_PROTO*) ;;
                *) ctime_r_proto="REENTRANT_PROTO_$ctime_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "ctime_r has no prototype, not using it." >&4 ;;
                esac
                d_ctime_r=undef
                ctime_r_proto=0
                ;;
        esac
        ;;
*)      ctime_r_proto=0
        ;;
esac

: see if cuserid exists
set cuserid d_cuserid
eval $inlibc

: see if this is a limits.h system
set limits.h i_limits
eval $inhdr

: see if this is a float.h system
set float.h i_float
eval $inhdr

: See if number of significant digits in a double precision number is known
echo " "
$cat >dbl_dig.c <<EOM
#$i_limits I_LIMITS
#$i_float I_FLOAT
#ifdef I_LIMITS
#include <limits.h>
#endif
#ifdef I_FLOAT
#include <float.h>
#endif
#ifdef DBL_DIG
printf("Contains DBL_DIG");
#endif
EOM
$cppstdin $cppflags $cppminus < dbl_dig.c >dbl_dig.E 2>/dev/null
if $contains 'DBL_DIG' dbl_dig.E >/dev/null 2>&1; then
        echo "DBL_DIG found." >&4
        val="$define"
else
        echo "DBL_DIG NOT found." >&4
        val="$undef"
fi
$rm -f dbl_dig.?
set d_dbl_dig
eval $setvar

: see if dbm.h is available
: see if dbmclose exists
set dbmclose d_dbmclose
eval $inlibc

case "$d_dbmclose" in
$define)
        set dbm.h i_dbm
        eval $inhdr
        case "$i_dbm" in
        $define)
                val="$undef"
                set i_rpcsvcdbm
                eval $setvar
                ;;
        *)      set rpcsvc/dbm.h i_rpcsvcdbm
                eval $inhdr
                ;;
        esac
        ;;
*)      echo "We won't be including <dbm.h>"
        val="$undef"
        set i_dbm
        eval $setvar
        val="$undef"
        set i_rpcsvcdbm
        eval $setvar
        ;;
esac

: see if prototype for dbminit is available
echo " "
set d_dbminitproto dbminit $i_dbm dbm.h
eval $hasproto

: see if difftime exists
set difftime d_difftime
eval $inlibc

: see if this is a dirent system
echo " "
if xinc=`./findhdr dirent.h`; $test "$xinc"; then
        val="$define"
        echo "<dirent.h> found." >&4
else
        val="$undef"
        if xinc=`./findhdr sys/dir.h`; $test "$xinc"; then
                echo "<sys/dir.h> found." >&4
                echo " "
        else
                xinc=`./findhdr sys/ndir.h`
        fi
        echo "<dirent.h> NOT found." >&4
fi
set i_dirent
eval $setvar

: Look for type of directory structure.
echo " "
$cppstdin $cppflags $cppminus < "$xinc" > try.c

case "$direntrytype" in
''|' ')
        case "$i_dirent" in
        $define) guess1='struct dirent' ;;
        *) guess1='struct direct'  ;;
        esac
        ;;
*)      guess1="$direntrytype"
        ;;
esac

case "$guess1" in
'struct dirent') guess2='struct direct' ;;
*) guess2='struct dirent' ;;
esac

if $contains "$guess1" try.c >/dev/null 2>&1; then
        direntrytype="$guess1"
        echo "Your directory entries are $direntrytype." >&4
elif $contains "$guess2" try.c >/dev/null 2>&1; then
        direntrytype="$guess2"
        echo "Your directory entries seem to be $direntrytype." >&4
else
        echo "I don't recognize your system's directory entries." >&4
        rp="What type is used for directory entries on this system?"
        dflt="$guess1"
        . ./myread
        direntrytype="$ans"
fi
$rm -f try.c


: see if the directory entry stores field length
echo " "
$cppstdin $cppflags $cppminus < "$xinc" > try.c
if $contains 'd_namlen' try.c >/dev/null 2>&1; then
        echo "Good, your directory entry keeps length information in d_namlen." >&4
        val="$define"
else
        echo "Your directory entry does not know about the d_namlen field." >&4
        val="$undef"
fi
set d_dirnamlen
eval $setvar
$rm -f try.c

: see if this is an sysdir system
set sys/dir.h i_sysdir
eval $inhdr

: see if this is an sysndir system
set sys/ndir.h i_sysndir
eval $inhdr

: Look for dirfd
echo " "
$cat >dirfd.c <<EOM
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#$i_dirent I_DIRENT             /**/
#$i_sysdir I_SYS_DIR            /**/
#$i_sysndir I_SYS_NDIR          /**/
#$i_systypes I_SYS_TYPES        /**/
#if defined(I_SYS_TYPES)
#include <sys/types.h>
#endif
#if defined(I_DIRENT)
#include <dirent.h>
#if defined(NeXT) && defined(I_SYS_DIR) /* NeXT needs dirent + sys/dir.h */
#include <sys/dir.h>
#endif
#else
#ifdef I_SYS_NDIR
#include <sys/ndir.h>
#else
#ifdef I_SYS_DIR
#ifdef hp9000s500
#include <ndir.h>       /* may be wrong in the future */
#else
#include <sys/dir.h>
#endif
#endif
#endif
#endif
int main() {
        DIR *dirp = opendir(".");
        if (dirfd(dirp) >= 0)
                exit(0);
        else
                exit(1);
}
EOM
set dirfd
if eval $compile; then
        val="$define"
fi
case "$val" in
$define)        echo "dirfd() found." >&4       ;;
*)              echo "dirfd() NOT found." >&4   ;;
esac
set d_dirfd
eval $setvar
$rm -f dirfd*

: see if dlerror exists
xxx_runnm="$runnm"
runnm=false
set dlerror d_dlerror
eval $inlibc
runnm="$xxx_runnm"

: see if dlfcn is available
set dlfcn.h i_dlfcn
eval $inhdr

case "$usedl" in
$define|y|true)
        $cat << EOM

On a few systems, the dynamically loaded modules that perl generates and uses
will need a different extension than shared libs. The default will probably
be appropriate.

EOM
        case "$dlext" in
        '')     dflt="$so" ;;
        *)      dflt="$dlext" ;;
        esac
        rp='What is the extension of dynamically loaded modules'
        . ./myread
        dlext="$ans"
        ;;
*)
        dlext="none"
        ;;
esac

: Check if dlsym need a leading underscore
echo " "
val="$undef"

case "$dlsrc" in
dl_dlopen.xs)
        echo "Checking whether your dlsym() needs a leading underscore ..." >&4
        $cat >dyna.c <<'EOM'
fred () { }
EOM

$cat >fred.c<<EOM

#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#$i_dlfcn I_DLFCN
#ifdef I_DLFCN
#include <dlfcn.h>      /* the dynamic linker include file for SunOS/Solaris */
#else
#include <sys/types.h>
#include <nlist.h>
#include <link.h>
#endif

extern int fred() ;

int main()
{
    void * handle ;
    void * symbol ;
#ifndef RTLD_LAZY
    int mode = 1 ;
#else
    int mode = RTLD_LAZY ;
#endif
    handle = dlopen("./dyna.$dlext", mode) ;
    if (handle == NULL) {
        printf ("1\n") ;
        fflush (stdout) ;
        exit(0);
    }
    symbol = dlsym(handle, "fred") ;
    if (symbol == NULL) {
        /* try putting a leading underscore */
        symbol = dlsym(handle, "_fred") ;
        if (symbol == NULL) {
            printf ("2\n") ;
            fflush (stdout) ;
            exit(0);
        }
        printf ("3\n") ;
    }
    else
        printf ("4\n") ;
    fflush (stdout) ;
    exit(0);
}
EOM
        : Call the object file tmp-dyna.o in case dlext=o.
        if $cc $ccflags $cccdlflags -c dyna.c > /dev/null 2>&1 &&
                mv dyna${_o} tmp-dyna${_o} > /dev/null 2>&1 &&
                $ld -o dyna.$dlext $ldflags $lddlflags tmp-dyna${_o} > /dev/null 2>&1 &&
                $cc -o fred $ccflags $ldflags $cccdlflags $ccdlflags fred.c $libs > /dev/null 2>&1 && $to dyna.$dlext; then
                xxx=`$run ./fred`
                case $xxx in
                1)      echo "Test program failed using dlopen." >&4
                        echo "Perhaps you should not use dynamic loading." >&4;;
                2)      echo "Test program failed using dlsym." >&4
                        echo "Perhaps you should not use dynamic loading." >&4;;
                3)      echo "dlsym needs a leading underscore" >&4
                        val="$define" ;;
                4)      echo "dlsym doesn't need a leading underscore." >&4;;
                esac
        else
                echo "I can't compile and run the test program." >&4
                echo "I'm guessing that dlsym doesn't need a leading underscore." >&4
        fi
        ;;
esac

$rm -f fred fred.* dyna.$dlext dyna.* tmp-dyna.*

set d_dlsymun
eval $setvar

: see if drand48_r exists
set drand48_r d_drand48_r
eval $inlibc
case "$d_drand48_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_stdlib stdlib.h"
        case "$d_drand48_r_proto:$usethreads" in
        ":define")      d_drand48_r_proto=define
                set d_drand48_r_proto drand48_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_drand48_r_proto" in
        define)
        case "$drand48_r_proto" in
        ''|0) try='int drand48_r(struct drand48_data*, double*);'
        ./protochk "extern $try" $hdrs && drand48_r_proto=I_ST ;;
        esac
        case "$drand48_r_proto" in
        ''|0)   d_drand48_r=undef
                drand48_r_proto=0
                echo "Disabling drand48_r, cannot determine prototype." >&4 ;;
        * )     case "$drand48_r_proto" in
                REENTRANT_PROTO*) ;;
                *) drand48_r_proto="REENTRANT_PROTO_$drand48_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "drand48_r has no prototype, not using it." >&4 ;;
                esac
                d_drand48_r=undef
                drand48_r_proto=0
                ;;
        esac
        ;;
*)      drand48_r_proto=0
        ;;
esac

: see if prototype for drand48 is available
echo " "
set d_drand48proto drand48 $i_stdlib stdlib.h $i_unistd unistd.h
eval $hasproto

: see if dup2 exists
set dup2 d_dup2
eval $inlibc

: see if eaccess exists
set eaccess d_eaccess
eval $inlibc

: see if endgrent exists
set endgrent d_endgrent
eval $inlibc

: see if this is an grp system
set grp.h i_grp
eval $inhdr

case "$i_grp" in
$define)
        xxx=`./findhdr grp.h`
        $cppstdin $cppflags $cppminus < $xxx >$$.h

        if $contains 'gr_passwd' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_grpasswd
        eval $setvar

        $rm -f $$.h
        ;;
*)
        val="$undef";
        set d_grpasswd; eval $setvar
        ;;
esac

: see if endgrent_r exists
set endgrent_r d_endgrent_r
eval $inlibc
case "$d_endgrent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_grp grp.h"
        case "$d_endgrent_r_proto:$usethreads" in
        ":define")      d_endgrent_r_proto=define
                set d_endgrent_r_proto endgrent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_endgrent_r_proto" in
        define)
        case "$endgrent_r_proto" in
        ''|0) try='int endgrent_r(FILE**);'
        ./protochk "extern $try" $hdrs && endgrent_r_proto=I_H ;;
        esac
        case "$endgrent_r_proto" in
        ''|0) try='void endgrent_r(FILE**);'
        ./protochk "extern $try" $hdrs && endgrent_r_proto=V_H ;;
        esac
        case "$endgrent_r_proto" in
        ''|0)   d_endgrent_r=undef
                endgrent_r_proto=0
                echo "Disabling endgrent_r, cannot determine prototype." >&4 ;;
        * )     case "$endgrent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) endgrent_r_proto="REENTRANT_PROTO_$endgrent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "endgrent_r has no prototype, not using it." >&4 ;;
                esac
                d_endgrent_r=undef
                endgrent_r_proto=0
                ;;
        esac
        ;;
*)      endgrent_r_proto=0
        ;;
esac

: see if endhostent exists
set endhostent d_endhent
eval $inlibc

: see if this is a netdb.h system
set netdb.h i_netdb
eval $inhdr

: see if endhostent_r exists
set endhostent_r d_endhostent_r
eval $inlibc
case "$d_endhostent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_endhostent_r_proto:$usethreads" in
        ":define")      d_endhostent_r_proto=define
                set d_endhostent_r_proto endhostent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_endhostent_r_proto" in
        define)
        case "$endhostent_r_proto" in
        ''|0) try='int endhostent_r(struct hostent_data*);'
        ./protochk "extern $try" $hdrs && endhostent_r_proto=I_D ;;
        esac
        case "$endhostent_r_proto" in
        ''|0) try='void endhostent_r(struct hostent_data*);'
        ./protochk "extern $try" $hdrs && endhostent_r_proto=V_D ;;
        esac
        case "$endhostent_r_proto" in
        ''|0)   d_endhostent_r=undef
                endhostent_r_proto=0
                echo "Disabling endhostent_r, cannot determine prototype." >&4 ;;
        * )     case "$endhostent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) endhostent_r_proto="REENTRANT_PROTO_$endhostent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "endhostent_r has no prototype, not using it." >&4 ;;
                esac
                d_endhostent_r=undef
                endhostent_r_proto=0
                ;;
        esac
        ;;
*)      endhostent_r_proto=0
        ;;
esac

: see if endnetent exists
set endnetent d_endnent
eval $inlibc

: see if endnetent_r exists
set endnetent_r d_endnetent_r
eval $inlibc
case "$d_endnetent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_endnetent_r_proto:$usethreads" in
        ":define")      d_endnetent_r_proto=define
                set d_endnetent_r_proto endnetent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_endnetent_r_proto" in
        define)
        case "$endnetent_r_proto" in
        ''|0) try='int endnetent_r(struct netent_data*);'
        ./protochk "extern $try" $hdrs && endnetent_r_proto=I_D ;;
        esac
        case "$endnetent_r_proto" in
        ''|0) try='void endnetent_r(struct netent_data*);'
        ./protochk "extern $try" $hdrs && endnetent_r_proto=V_D ;;
        esac
        case "$endnetent_r_proto" in
        ''|0)   d_endnetent_r=undef
                endnetent_r_proto=0
                echo "Disabling endnetent_r, cannot determine prototype." >&4 ;;
        * )     case "$endnetent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) endnetent_r_proto="REENTRANT_PROTO_$endnetent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "endnetent_r has no prototype, not using it." >&4 ;;
                esac
                d_endnetent_r=undef
                endnetent_r_proto=0
                ;;
        esac
        ;;
*)      endnetent_r_proto=0
        ;;
esac

: see if endprotoent exists
set endprotoent d_endpent
eval $inlibc

: see if endprotoent_r exists
set endprotoent_r d_endprotoent_r
eval $inlibc
case "$d_endprotoent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_endprotoent_r_proto:$usethreads" in
        ":define")      d_endprotoent_r_proto=define
                set d_endprotoent_r_proto endprotoent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_endprotoent_r_proto" in
        define)
        case "$endprotoent_r_proto" in
        ''|0) try='int endprotoent_r(struct protoent_data*);'
        ./protochk "extern $try" $hdrs && endprotoent_r_proto=I_D ;;
        esac
        case "$endprotoent_r_proto" in
        ''|0) try='void endprotoent_r(struct protoent_data*);'
        ./protochk "extern $try" $hdrs && endprotoent_r_proto=V_D ;;
        esac
        case "$endprotoent_r_proto" in
        ''|0)   d_endprotoent_r=undef
                endprotoent_r_proto=0
                echo "Disabling endprotoent_r, cannot determine prototype." >&4 ;;
        * )     case "$endprotoent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) endprotoent_r_proto="REENTRANT_PROTO_$endprotoent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "endprotoent_r has no prototype, not using it." >&4 ;;
                esac
                d_endprotoent_r=undef
                endprotoent_r_proto=0
                ;;
        esac
        ;;
*)      endprotoent_r_proto=0
        ;;
esac

: see if endpwent exists
set endpwent d_endpwent
eval $inlibc

: see if this is a pwd.h system
set pwd.h i_pwd
eval $inhdr

case "$i_pwd" in
$define)
        xxx=`./findhdr pwd.h`
        $cppstdin $cppflags $cppminus < $xxx >$$.h

        if $contains 'pw_quota' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwquota
        eval $setvar

        if $contains 'pw_age' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwage
        eval $setvar

        if $contains 'pw_change' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwchange
        eval $setvar

        if $contains 'pw_class' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwclass
        eval $setvar

        if $contains 'pw_expire' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwexpire
        eval $setvar

        if $contains 'pw_comment' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwcomment
        eval $setvar

        if $contains 'pw_gecos' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwgecos
        eval $setvar

        if $contains 'pw_passwd' $$.h >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        set d_pwpasswd
        eval $setvar

        $rm -f $$.h
        ;;
*)
        val="$undef";
        set d_pwquota; eval $setvar
        set d_pwage; eval $setvar
        set d_pwchange; eval $setvar
        set d_pwclass; eval $setvar
        set d_pwexpire; eval $setvar
        set d_pwcomment; eval $setvar
        set d_pwgecos; eval $setvar
        set d_pwpasswd; eval $setvar
        ;;
esac

: see if endpwent_r exists
set endpwent_r d_endpwent_r
eval $inlibc
case "$d_endpwent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_pwd pwd.h"
        case "$d_endpwent_r_proto:$usethreads" in
        ":define")      d_endpwent_r_proto=define
                set d_endpwent_r_proto endpwent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_endpwent_r_proto" in
        define)
        case "$endpwent_r_proto" in
        ''|0) try='int endpwent_r(FILE**);'
        ./protochk "extern $try" $hdrs && endpwent_r_proto=I_H ;;
        esac
        case "$endpwent_r_proto" in
        ''|0) try='void endpwent_r(FILE**);'
        ./protochk "extern $try" $hdrs && endpwent_r_proto=V_H ;;
        esac
        case "$endpwent_r_proto" in
        ''|0)   d_endpwent_r=undef
                endpwent_r_proto=0
                echo "Disabling endpwent_r, cannot determine prototype." >&4 ;;
        * )     case "$endpwent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) endpwent_r_proto="REENTRANT_PROTO_$endpwent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "endpwent_r has no prototype, not using it." >&4 ;;
                esac
                d_endpwent_r=undef
                endpwent_r_proto=0
                ;;
        esac
        ;;
*)      endpwent_r_proto=0
        ;;
esac

: see if endservent exists
set endservent d_endsent
eval $inlibc

: see if endservent_r exists
set endservent_r d_endservent_r
eval $inlibc
case "$d_endservent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_endservent_r_proto:$usethreads" in
        ":define")      d_endservent_r_proto=define
                set d_endservent_r_proto endservent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_endservent_r_proto" in
        define)
        case "$endservent_r_proto" in
        ''|0) try='int endservent_r(struct servent_data*);'
        ./protochk "extern $try" $hdrs && endservent_r_proto=I_D ;;
        esac
        case "$endservent_r_proto" in
        ''|0) try='void endservent_r(struct servent_data*);'
        ./protochk "extern $try" $hdrs && endservent_r_proto=V_D ;;
        esac
        case "$endservent_r_proto" in
        ''|0)   d_endservent_r=undef
                endservent_r_proto=0
                echo "Disabling endservent_r, cannot determine prototype." >&4 ;;
        * )     case "$endservent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) endservent_r_proto="REENTRANT_PROTO_$endservent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "endservent_r has no prototype, not using it." >&4 ;;
                esac
                d_endservent_r=undef
                endservent_r_proto=0
                ;;
        esac
        ;;
*)      endservent_r_proto=0
        ;;
esac

: Locate the flags for 'open()'
echo " "
$cat >try.c <<EOCP
#include <sys/types.h>
#ifdef I_FCNTL
#include <fcntl.h>
#endif
#ifdef I_SYS_FILE
#include <sys/file.h>
#endif
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
        if(O_RDONLY);
#ifdef O_TRUNC
        exit(0);
#else
        exit(1);
#endif
}
EOCP
: check sys/file.h first to get FREAD on Sun
if $test `./findhdr sys/file.h` && \
                set try -DI_SYS_FILE && eval $compile; then
        h_sysfile=true;
        echo "<sys/file.h> defines the O_* constants..." >&4
        if $run ./try; then
                echo "and you have the 3 argument form of open()." >&4
                val="$define"
        else
                echo "but not the 3 argument form of open().  Oh, well." >&4
                val="$undef"
        fi
elif $test `./findhdr fcntl.h` && \
                set try -DI_FCNTL && eval $compile; then
        h_fcntl=true;
        echo "<fcntl.h> defines the O_* constants..." >&4
        if $run ./try; then
                echo "and you have the 3 argument form of open()." >&4
                val="$define"
        else
                echo "but not the 3 argument form of open().  Oh, well." >&4
                val="$undef"
        fi
else
        val="$undef"
        echo "I can't find the O_* constant definitions!  You got problems." >&4
fi
set d_open3
eval $setvar
$rm -f try try.*

: see which of string.h or strings.h is needed
echo " "
strings=`./findhdr string.h`
if $test "$strings" && $test -r "$strings"; then
        echo "Using <string.h> instead of <strings.h>." >&4
        val="$define"
else
        val="$undef"
        strings=`./findhdr strings.h`
        if $test "$strings" && $test -r "$strings"; then
                echo "Using <strings.h> instead of <string.h>." >&4
        else
                echo "No string header found -- You'll surely have problems." >&4
        fi
fi
set i_string
eval $setvar
case "$i_string" in
"$undef") strings=`./findhdr strings.h`;;
*)        strings=`./findhdr string.h`;;
esac

: see if this is a sys/file.h system
val=''
set sys/file.h val
eval $inhdr

: do we need to include sys/file.h ?
case "$val" in
"$define")
        echo " "
        if $h_sysfile; then
                val="$define"
                echo "We'll be including <sys/file.h>." >&4
        else
                val="$undef"
                echo "We won't be including <sys/file.h>." >&4
        fi
        ;;
*)
        h_sysfile=false
        ;;
esac
set i_sysfile
eval $setvar

: see if fcntl.h is there
val=''
set fcntl.h val
eval $inhdr

: see if we can include fcntl.h
case "$val" in
"$define")
        echo " "
        if $h_fcntl; then
                val="$define"
                echo "We'll be including <fcntl.h>." >&4
        else
                val="$undef"
                if $h_sysfile; then
        echo "We don't need to include <fcntl.h> if we include <sys/file.h>." >&4
                else
                        echo "We won't be including <fcntl.h>." >&4
                fi
        fi
        ;;
*)
        h_fcntl=false
        val="$undef"
        ;;
esac
set i_fcntl
eval $setvar

: check for non-blocking I/O stuff
case "$h_sysfile" in
true) echo "#include <sys/file.h>" > head.c;;
*)
       case "$h_fcntl" in
       true) echo "#include <fcntl.h>" > head.c;;
       *) echo "#include <sys/fcntl.h>" > head.c;;
       esac
       ;;
esac
echo " "
echo "Figuring out the flag used by open() for non-blocking I/O..." >&4
case "$o_nonblock" in
'')
        $cat head.c > try.c
        $cat >>try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#$i_fcntl I_FCNTL
#ifdef I_FCNTL
#include <fcntl.h>
#endif
int main() {
#ifdef O_NONBLOCK
        printf("O_NONBLOCK\n");
        exit(0);
#endif
#ifdef O_NDELAY
        printf("O_NDELAY\n");
        exit(0);
#endif
#ifdef FNDELAY
        printf("FNDELAY\n");
        exit(0);
#endif
        exit(0);
}
EOCP
        set try
        if eval $compile_ok; then
                o_nonblock=`$run ./try`
                case "$o_nonblock" in
                '') echo "I can't figure it out, assuming O_NONBLOCK will do.";;
                *) echo "Seems like we can use $o_nonblock.";;
                esac
        else
                echo "(I can't compile the test program; pray O_NONBLOCK is right!)"
        fi
        ;;
*) echo "Using $hint value $o_nonblock.";;
esac
$rm -f try try.* .out core

echo " "
echo "Let's see what value errno gets from read() on a $o_nonblock file..." >&4
case "$eagain" in
'')
        $cat head.c > try.c
        $cat >>try.c <<EOCP
#include <errno.h>
#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#$i_fcntl I_FCNTL
#ifdef I_FCNTL
#include <fcntl.h>
#endif
#define MY_O_NONBLOCK $o_nonblock
#ifndef errno  /* XXX need better Configure test */
extern int errno;
#endif
#$i_unistd I_UNISTD
#ifdef I_UNISTD
#include <unistd.h>
#endif
#$i_string I_STRING
#ifdef I_STRING
#include <string.h>
#else
#include <strings.h>
#endif
$signal_t blech(x) int x; { exit(3); }
EOCP
        $cat >> try.c <<'EOCP'
int main()
{
        int pd[2];
        int pu[2];
        char buf[1];
        char string[100];

        pipe(pd);       /* Down: child -> parent */
        pipe(pu);       /* Up: parent -> child */
        if (0 != fork()) {
                int ret;
                close(pd[1]);   /* Parent reads from pd[0] */
                close(pu[0]);   /* Parent writes (blocking) to pu[1] */
#ifdef F_SETFL
                if (-1 == fcntl(pd[0], F_SETFL, MY_O_NONBLOCK))
                        exit(1);
#else
                exit(4);
#endif
                signal(SIGALRM, blech);
                alarm(5);
                if ((ret = read(pd[0], buf, 1)) > 0)    /* Nothing to read! */
                        exit(2);
                sprintf(string, "%d\n", ret);
                write(2, string, strlen(string));
                alarm(0);
#ifdef EAGAIN
                if (errno == EAGAIN) {
                        printf("EAGAIN\n");
                        goto ok;
                }
#endif
#ifdef EWOULDBLOCK
                if (errno == EWOULDBLOCK)
                        printf("EWOULDBLOCK\n");
#endif
        ok:
                write(pu[1], buf, 1);   /* Unblocks child, tell it to close our pipe */
                sleep(2);                               /* Give it time to close our pipe */
                alarm(5);
                ret = read(pd[0], buf, 1);      /* Should read EOF */
                alarm(0);
                sprintf(string, "%d\n", ret);
                write(4, string, strlen(string));
                exit(0);
        }

        close(pd[0]);                   /* We write to pd[1] */
        close(pu[1]);                   /* We read from pu[0] */
        read(pu[0], buf, 1);    /* Wait for parent to signal us we may continue */
        close(pd[1]);                   /* Pipe pd is now fully closed! */
        exit(0);                                /* Bye bye, thank you for playing! */
}
EOCP
        set try
        if eval $compile_ok; then
                echo "$startsh" >mtry
                echo "$run ./try >try.out 2>try.ret 4>try.err || exit 4" >>mtry
                chmod +x mtry
                ./mtry >/dev/null 2>&1
                case $? in
                0) eagain=`$cat try.out`;;
                1) echo "Could not perform non-blocking setting!";;
                2) echo "I did a successful read() for something that was not there!";;
                3) echo "Hmm... non-blocking I/O does not seem to be working!";;
                4) echo "Could not find F_SETFL!";;
                *) echo "Something terribly wrong happened during testing.";;
                esac
                rd_nodata=`$cat try.ret`
                echo "A read() system call with no data present returns $rd_nodata."
                case "$rd_nodata" in
                0|-1) ;;
                *)
                        echo "(That's peculiar, fixing that to be -1.)"
                        rd_nodata=-1
                        ;;
                esac
                case "$eagain" in
                '')
                        echo "Forcing errno EAGAIN on read() with no data available."
                        eagain=EAGAIN
                        ;;
                *)
                        echo "Your read() sets errno to $eagain when no data is available."
                        ;;
                esac
                status=`$cat try.err`
                case "$status" in
                0) echo "And it correctly returns 0 to signal EOF.";;
                -1) echo "But it also returns -1 to signal EOF, so be careful!";;
                *) echo "However, your read() returns '$status' on EOF??";;
                esac
                val="$define"
                if test "$status" = "$rd_nodata"; then
                        echo "WARNING: you can't distinguish between EOF and no data!"
                        val="$undef"
                fi
        else
                echo "I can't compile the test program--assuming errno EAGAIN will do."
                eagain=EAGAIN
        fi
        set d_eofnblk
        eval $setvar
        ;;
*)
        echo "Using $hint value $eagain."
        echo "Your read() returns $rd_nodata when no data is present."
        case "$d_eofnblk" in
        "$define") echo "And you can see EOF because read() returns 0.";;
        "$undef") echo "But you can't see EOF status from read() returned value.";;
        *)
                echo "(Assuming you can't see EOF status from read anyway.)"
                d_eofnblk=$undef
                ;;
        esac
        ;;
esac
$rm -f try try.* .out core head.c mtry

: see if _ptr and _cnt from stdio act std
echo " "

if $contains '_lbfsize' `./findhdr stdio.h` >/dev/null 2>&1 ; then
        echo "(Looks like you have stdio.h from BSD.)"
        case "$stdio_ptr" in
        '') stdio_ptr='((fp)->_p)'
                ptr_lval=$define
                ;;
        *)      ptr_lval=$d_stdio_ptr_lval;;
        esac
        case "$stdio_cnt" in
        '') stdio_cnt='((fp)->_r)'
                cnt_lval=$define
                ;;
        *)      cnt_lval=$d_stdio_cnt_lval;;
        esac
        case "$stdio_base" in
        '') stdio_base='((fp)->_ub._base ? (fp)->_ub._base : (fp)->_bf._base)';;
        esac
        case "$stdio_bufsiz" in
        '') stdio_bufsiz='((fp)->_ub._base ? (fp)->_ub._size : (fp)->_bf._size)';;
        esac
elif $contains '_IO_fpos_t' `./findhdr stdio.h` `./findhdr libio.h` >/dev/null 2>&1 ; then
        echo "(Looks like you have stdio.h from Linux.)"
        case "$stdio_ptr" in
        '') stdio_ptr='((fp)->_IO_read_ptr)'
                ptr_lval=$define
                ;;
        *)      ptr_lval=$d_stdio_ptr_lval;;
        esac
        case "$stdio_cnt" in
        '') stdio_cnt='((fp)->_IO_read_end - (fp)->_IO_read_ptr)'
                cnt_lval=$undef
                ;;
        *)      cnt_lval=$d_stdio_cnt_lval;;
        esac
        case "$stdio_base" in
        '') stdio_base='((fp)->_IO_read_base)';;
        esac
        case "$stdio_bufsiz" in
        '') stdio_bufsiz='((fp)->_IO_read_end - (fp)->_IO_read_base)';;
        esac
else
        case "$stdio_ptr" in
        '') stdio_ptr='((fp)->_ptr)'
                ptr_lval=$define
                ;;
        *)      ptr_lval=$d_stdio_ptr_lval;;
        esac
        case "$stdio_cnt" in
        '') stdio_cnt='((fp)->_cnt)'
                cnt_lval=$define
                ;;
        *)      cnt_lval=$d_stdio_cnt_lval;;
        esac
        case "$stdio_base" in
        '') stdio_base='((fp)->_base)';;
        esac
        case "$stdio_bufsiz" in
        '') stdio_bufsiz='((fp)->_cnt + (fp)->_ptr - (fp)->_base)';;
        esac
fi

: test whether _ptr and _cnt really work
echo "Checking how std your stdio is..." >&4
$cat >try.c <<EOP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#define FILE_ptr(fp)    $stdio_ptr
#define FILE_cnt(fp)    $stdio_cnt
int main() {
        FILE *fp = fopen("try.c", "r");
        char c = getc(fp);
        if (
                18 <= FILE_cnt(fp) &&
                strncmp(FILE_ptr(fp), "include <stdio.h>\n", 18) == 0
        )
                exit(0);
        exit(1);
}
EOP
val="$undef"
set try
if eval $compile && $to try.c; then
        if $run ./try; then
                echo "Your stdio acts pretty std."
                val="$define"
        else
                echo "Your stdio isn't very std."
        fi
else
        echo "Your stdio doesn't appear very std."
fi
$rm -f try.c try

# glibc 2.2.90 and above apparently change stdio streams so Perl's
# direct buffer manipulation no longer works.  The Configure tests
# should be changed to correctly detect this, but until then,
# the following check should at least let perl compile and run.
# (This quick fix should be updated before 5.8.1.)
# To be defensive, reject all unknown versions, and all versions  > 2.2.9.
# A. Dougherty, June 3, 2002.
case "$d_gnulibc" in
$define)
        case "$gnulibc_version" in
        2.[01]*)  ;;
        2.2) ;;
        2.2.[0-9]) ;;
        *)  echo "But I will not snoop inside glibc $gnulibc_version stdio buffers."
                val="$undef"
                ;;
        esac
        ;;
esac
set d_stdstdio
eval $setvar

: Can _ptr be used as an lvalue?
case "$d_stdstdio$ptr_lval" in
$define$define) val=$define ;;
*) val=$undef ;;
esac
set d_stdio_ptr_lval
eval $setvar

: Can _cnt be used as an lvalue?
case "$d_stdstdio$cnt_lval" in
$define$define) val=$define ;;
*) val=$undef ;;
esac
set d_stdio_cnt_lval
eval $setvar


: test whether setting _ptr sets _cnt as a side effect
d_stdio_ptr_lval_sets_cnt="$undef"
d_stdio_ptr_lval_nochange_cnt="$undef"
case "$d_stdio_ptr_lval$d_stdstdio" in
$define$define)
        echo "Checking to see what happens if we set the stdio ptr..." >&4
$cat >try.c <<EOP
#include <stdio.h>
/* Can we scream? */
/* Eat dust sed :-) */
/* In the buffer space, no one can hear you scream. */
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#define FILE_ptr(fp)    $stdio_ptr
#define FILE_cnt(fp)    $stdio_cnt
#include <sys/types.h>
int main() {
        FILE *fp = fopen("try.c", "r");
        int c;
        char *ptr;
        size_t cnt;
        if (!fp) {
            puts("Fail even to read");
            exit(1);
        }
        c = getc(fp); /* Read away the first # */
        if (c == EOF) {
            puts("Fail even to read");
            exit(1);
        }
        if (!(
                18 <= FILE_cnt(fp) &&
                strncmp(FILE_ptr(fp), "include <stdio.h>\n", 18) == 0
        )) {
                puts("Fail even to read");
                exit (1);
        }
        ptr = (char*) FILE_ptr(fp);
        cnt = (size_t)FILE_cnt(fp);

        FILE_ptr(fp) += 42;

        if ((char*)FILE_ptr(fp) != (ptr + 42)) {
                printf("Fail ptr check %p != %p", FILE_ptr(fp), (ptr + 42));
                exit (1);
        }
        if (FILE_cnt(fp) <= 20) {
                printf ("Fail (<20 chars to test)");
                exit (1);
        }
        if (strncmp(FILE_ptr(fp), "Eat dust sed :-) */\n", 20) != 0) {
                puts("Fail compare");
                exit (1);
        }
        if (cnt == FILE_cnt(fp)) {
                puts("Pass_unchanged");
                exit (0);
        }
        if (FILE_cnt(fp) == (cnt - 42)) {
                puts("Pass_changed");
                exit (0);
        }
        printf("Fail count was %d now %d\n", cnt, FILE_cnt(fp));
        return 1;

}
EOP
        set try
        if eval $compile && $to try.c; then
                case `$run ./try` in
                Pass_changed)
                        echo "Increasing ptr in your stdio decreases cnt by the same amount.  Good." >&4
                        d_stdio_ptr_lval_sets_cnt="$define" ;;
                Pass_unchanged)
                        echo "Increasing ptr in your stdio leaves cnt unchanged.  Good." >&4
                        d_stdio_ptr_lval_nochange_cnt="$define" ;;
                Fail*)
                        echo "Increasing ptr in your stdio didn't do exactly what I expected.  We'll not be doing that then." >&4 ;;
                *)
                        echo "It appears attempting to set ptr in your stdio is a bad plan." >&4 ;;
        esac
        else
                echo "It seems we can't set ptr in your stdio.  Nevermind." >&4
        fi
        $rm -f try.c try
        ;;
esac

: see if _base is also standard
val="$undef"
case "$d_stdstdio" in
$define)
        $cat >try.c <<EOP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#define FILE_base(fp)   $stdio_base
#define FILE_bufsiz(fp) $stdio_bufsiz
int main() {
        FILE *fp = fopen("try.c", "r");
        char c = getc(fp);
        if (
                19 <= FILE_bufsiz(fp) &&
                strncmp(FILE_base(fp), "#include <stdio.h>\n", 19) == 0
        )
                exit(0);
        exit(1);
}
EOP
        set try
        if eval $compile && $to try.c; then
                if $run ./try; then
                        echo "And its _base field acts std."
                        val="$define"
                else
                        echo "But its _base field isn't std."
                fi
        else
                echo "However, it seems to be lacking the _base field."
        fi
        $rm -f try.c try
        ;;
esac
set d_stdiobase
eval $setvar

: see if fast_stdio exists
val="$undef"
case "$d_stdstdio:$d_stdio_ptr_lval" in
"$define:$define")
        case "$d_stdio_cnt_lval$d_stdio_ptr_lval_sets_cnt" in
        *$define*)
                echo "You seem to have 'fast stdio' to directly manipulate the stdio buffers." >& 4
                val="$define"
                ;;
        esac
        ;;
esac
set d_faststdio
eval $setvar



: see if fchdir exists
set fchdir d_fchdir
eval $inlibc

: see if fchmod exists
set fchmod d_fchmod
eval $inlibc

: see if fchown exists
set fchown d_fchown
eval $inlibc

: see if this is an fcntl system
set fcntl d_fcntl
eval $inlibc

echo " "
: See if fcntl-based locking works.
$cat >try.c <<EOCP
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
$signal_t blech(x) int x; { exit(3); }
int main() {
#if defined(F_SETLK) && defined(F_SETLKW)
     struct flock flock;
     int retval, fd;
     fd = open("try.c", O_RDONLY);
     flock.l_type = F_RDLCK;
     flock.l_whence = SEEK_SET;
     flock.l_start = flock.l_len = 0;
     signal(SIGALRM, blech);
     alarm(10);
     retval = fcntl(fd, F_SETLK, &flock);
     close(fd);
     (retval < 0 ? exit(2) : exit(0));
#else
     exit(2);
#endif
}
EOCP
echo "Checking if fcntl-based file locking works... "
case "$d_fcntl" in
"$define")
        set try
        if eval $compile_ok; then
                if $run ./try; then
                        echo "Yes, it seems to work."
                        val="$define"
                else
                        echo "Nope, it didn't work."
                        val="$undef"
                        case "$?" in
                        3) $cat >&4 <<EOM
***
*** I had to forcibly timeout from fcntl(..., F_SETLK, ...).
*** This is (almost) impossible.
*** If your NFS lock daemons are not feeling well, something like
*** this may happen, please investigate.  Cannot continue, aborting.
***
EOM
                                exit 1
                                ;;
                        esac
                fi
        else
                echo "I'm unable to compile the test program, so I'll assume not."
                val="$undef"
        fi
        ;;
*) val="$undef";
        echo "Nope, since you don't even have fcntl()."
        ;;
esac
set d_fcntl_can_lock
eval $setvar
$rm -f try*


: check for fd_set items
$cat <<EOM

Checking to see how well your C compiler handles fd_set and friends ...
EOM
$cat >try.c <<EOCP
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#$i_systime I_SYS_TIME
#$i_sysselct I_SYS_SELECT
#$d_socket HAS_SOCKET
#include <sys/types.h>
#ifdef HAS_SOCKET
#include <sys/socket.h> /* Might include <sys/bsdtypes.h> */
#endif
#ifdef I_SYS_TIME
#include <sys/time.h>
#endif
#ifdef I_SYS_SELECT
#include <sys/select.h>
#endif
int main() {
        fd_set fds;

#ifdef TRYBITS
        if(fds.fds_bits);
#endif

#if defined(FD_SET) && defined(FD_CLR) && defined(FD_ISSET) && defined(FD_ZERO)
        exit(0);
#else
        exit(1);
#endif
}
EOCP
set try -DTRYBITS
if eval $compile; then
        d_fds_bits="$define"
        d_fd_set="$define"
        echo "Well, your system knows about the normal fd_set typedef..." >&4
        if $run ./try; then
                echo "and you have the normal fd_set macros (just as I'd expect)." >&4
                d_fd_macros="$define"
        else
                $cat >&4 <<'EOM'
but not the normal fd_set macros!  Gaaack!  I'll have to cover for you.
EOM
                d_fd_macros="$undef"
        fi
else
        $cat <<'EOM'
Hmm, your compiler has some difficulty with fd_set.  Checking further...
EOM
        set try
        if eval $compile; then
                d_fds_bits="$undef"
                d_fd_set="$define"
                echo "Well, your system has some sort of fd_set available..." >&4
                if $run ./try; then
                        echo "and you have the normal fd_set macros." >&4
                        d_fd_macros="$define"
                else
                        $cat <<'EOM'
but not the normal fd_set macros!  Gross!  More work for me...
EOM
                        d_fd_macros="$undef"
                fi
        else
        echo "Well, you got zip.  That's OK, I can roll my own fd_set stuff." >&4
                d_fd_set="$undef"
                d_fds_bits="$undef"
                d_fd_macros="$undef"
        fi
fi
$rm -f try try.*

: see if fgetpos exists
set fgetpos d_fgetpos
eval $inlibc

: see if finite exists
set finite d_finite
eval $inlibc

: see if finitel exists
set finitel d_finitel
eval $inlibc

: see if flock exists
set flock d_flock
eval $inlibc

: see if prototype for flock is available
echo " "
set d_flockproto flock $i_sysfile sys/file.h
eval $hasproto

: see if fork exists
set fork d_fork
eval $inlibc

: see if fp_class exists
set fp_class d_fp_class
eval $inlibc

: see if pathconf exists
set pathconf d_pathconf
eval $inlibc

: see if fpathconf exists
set fpathconf d_fpathconf
eval $inlibc

: see if fpclass exists
set fpclass d_fpclass
eval $inlibc

: see if fpclassify exists
set fpclassify d_fpclassify
eval $inlibc

: see if fpclassl exists
set fpclassl d_fpclassl
eval $inlibc


: check for fpos64_t
echo " "
echo "Checking to see if you have fpos64_t..." >&4
$cat >try.c <<EOCP
#include <stdio.h>
int main() { fpos64_t x = 7; }
EOCP
set try
if eval $compile; then
        val="$define"
        echo "You have fpos64_t."
else
        val="$undef"
        echo "You do not have fpos64_t."
        case "$fpossize" in
        8) echo "(Your fpos_t is 64 bits, so you could use that.)" ;;
        esac
fi
$rm -f try.* try
set d_fpos64_t
eval $setvar

: see if frexpl exists
set frexpl d_frexpl
eval $inlibc

: see if this is a sys/param system
set sys/param.h i_sysparam
eval $inhdr

: see if this is a sys/mount.h system
set sys/mount.h i_sysmount
eval $inhdr


echo " "
echo "Checking to see if your system supports struct fs_data..." >&4
set d_fs_data_s fs_data $i_systypes sys/types.h $i_sysparam sys/param.h $i_sysmount sys/mount.h
eval $hasstruct
case "$d_fs_data_s" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac

: see if fseeko exists
set fseeko d_fseeko
eval $inlibc
case "$longsize" in
8) echo "(Your long is 64 bits, so you could use fseek.)" ;;
esac

: see if fsetpos exists
set fsetpos d_fsetpos
eval $inlibc


: see if fstatfs exists
set fstatfs d_fstatfs
eval $inlibc


: see if statvfs exists
set statvfs d_statvfs
eval $inlibc

: see if fstatvfs exists
set fstatvfs d_fstatvfs
eval $inlibc


: see if fsync exists
set fsync d_fsync
eval $inlibc

: see if ftello exists
set ftello d_ftello
eval $inlibc
case "$longsize" in
8) echo "(Your long is 64 bits, so you could use ftell.)" ;;
esac

: see if getcwd exists
set getcwd d_getcwd
eval $inlibc

: see if getespwnam exists
set getespwnam d_getespwnam
eval $inlibc


: see if getfsstat exists
set getfsstat d_getfsstat
eval $inlibc

: see if getgrent exists
set getgrent d_getgrent
eval $inlibc

: see if getgrent_r exists
set getgrent_r d_getgrent_r
eval $inlibc
case "$d_getgrent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_grp grp.h"
        case "$d_getgrent_r_proto:$usethreads" in
        ":define")      d_getgrent_r_proto=define
                set d_getgrent_r_proto getgrent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getgrent_r_proto" in
        define)
        case "$getgrent_r_proto" in
        ''|0) try='int getgrent_r(struct group*, char*, size_t, struct group**);'
        ./protochk "extern $try" $hdrs && getgrent_r_proto=I_SBWR ;;
        esac
        case "$getgrent_r_proto" in
        ''|0) try='int getgrent_r(struct group*, char*, int, struct group**);'
        ./protochk "extern $try" $hdrs && getgrent_r_proto=I_SBIR ;;
        esac
        case "$getgrent_r_proto" in
        ''|0) try='struct group* getgrent_r(struct group*, char*, size_t);'
        ./protochk "extern $try" $hdrs && getgrent_r_proto=S_SBW ;;
        esac
        case "$getgrent_r_proto" in
        ''|0) try='struct group* getgrent_r(struct group*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrent_r_proto=S_SBI ;;
        esac
        case "$getgrent_r_proto" in
        ''|0) try='int getgrent_r(struct group*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrent_r_proto=I_SBI ;;
        esac
        case "$getgrent_r_proto" in
        ''|0) try='int getgrent_r(struct group*, char*, int, FILE**);'
        ./protochk "extern $try" $hdrs && getgrent_r_proto=I_SBIH ;;
        esac
        case "$getgrent_r_proto" in
        ''|0)   d_getgrent_r=undef
                getgrent_r_proto=0
                echo "Disabling getgrent_r, cannot determine prototype." >&4 ;;
        * )     case "$getgrent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getgrent_r_proto="REENTRANT_PROTO_$getgrent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getgrent_r has no prototype, not using it." >&4 ;;
                esac
                d_getgrent_r=undef
                getgrent_r_proto=0
                ;;
        esac
        ;;
*)      getgrent_r_proto=0
        ;;
esac

: see if getgrgid_r exists
set getgrgid_r d_getgrgid_r
eval $inlibc
case "$d_getgrgid_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_grp grp.h"
        case "$d_getgrgid_r_proto:$usethreads" in
        ":define")      d_getgrgid_r_proto=define
                set d_getgrgid_r_proto getgrgid_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getgrgid_r_proto" in
        define)
        case "$getgrgid_r_proto" in
        ''|0) try='int getgrgid_r(gid_t, struct group*, char*, size_t, struct group**);'
        ./protochk "extern $try" $hdrs && getgrgid_r_proto=I_TSBWR ;;
        esac
        case "$getgrgid_r_proto" in
        ''|0) try='int getgrgid_r(gid_t, struct group*, char*, int, struct group**);'
        ./protochk "extern $try" $hdrs && getgrgid_r_proto=I_TSBIR ;;
        esac
        case "$getgrgid_r_proto" in
        ''|0) try='int getgrgid_r(gid_t, struct group*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrgid_r_proto=I_TSBI ;;
        esac
        case "$getgrgid_r_proto" in
        ''|0) try='struct group* getgrgid_r(gid_t, struct group*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrgid_r_proto=S_TSBI ;;
        esac
        case "$getgrgid_r_proto" in
        ''|0)   d_getgrgid_r=undef
                getgrgid_r_proto=0
                echo "Disabling getgrgid_r, cannot determine prototype." >&4 ;;
        * )     case "$getgrgid_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getgrgid_r_proto="REENTRANT_PROTO_$getgrgid_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getgrgid_r has no prototype, not using it." >&4 ;;
                esac
                d_getgrgid_r=undef
                getgrgid_r_proto=0
                ;;
        esac
        ;;
*)      getgrgid_r_proto=0
        ;;
esac

: see if getgrnam_r exists
set getgrnam_r d_getgrnam_r
eval $inlibc
case "$d_getgrnam_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_grp grp.h"
        case "$d_getgrnam_r_proto:$usethreads" in
        ":define")      d_getgrnam_r_proto=define
                set d_getgrnam_r_proto getgrnam_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getgrnam_r_proto" in
        define)
        case "$getgrnam_r_proto" in
        ''|0) try='int getgrnam_r(const char*, struct group*, char*, size_t, struct group**);'
        ./protochk "extern $try" $hdrs && getgrnam_r_proto=I_CSBWR ;;
        esac
        case "$getgrnam_r_proto" in
        ''|0) try='int getgrnam_r(const char*, struct group*, char*, int, struct group**);'
        ./protochk "extern $try" $hdrs && getgrnam_r_proto=I_CSBIR ;;
        esac
        case "$getgrnam_r_proto" in
        ''|0) try='struct group* getgrnam_r(const char*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrnam_r_proto=S_CBI ;;
        esac
        case "$getgrnam_r_proto" in
        ''|0) try='int getgrnam_r(const char*, struct group*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrnam_r_proto=I_CSBI ;;
        esac
        case "$getgrnam_r_proto" in
        ''|0) try='struct group* getgrnam_r(const char*, struct group*, char*, int);'
        ./protochk "extern $try" $hdrs && getgrnam_r_proto=S_CSBI ;;
        esac
        case "$getgrnam_r_proto" in
        ''|0)   d_getgrnam_r=undef
                getgrnam_r_proto=0
                echo "Disabling getgrnam_r, cannot determine prototype." >&4 ;;
        * )     case "$getgrnam_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getgrnam_r_proto="REENTRANT_PROTO_$getgrnam_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getgrnam_r has no prototype, not using it." >&4 ;;
                esac
                d_getgrnam_r=undef
                getgrnam_r_proto=0
                ;;
        esac
        ;;
*)      getgrnam_r_proto=0
        ;;
esac

: see if gethostbyaddr exists
set gethostbyaddr d_gethbyaddr
eval $inlibc

: see if gethostbyname exists
set gethostbyname d_gethbyname
eval $inlibc

: see if gethostent exists
set gethostent d_gethent
eval $inlibc

: see how we will look up host name
echo " "
call=''
if set gethostname val -f d_gethname; eval $csym; $val; then
        echo 'gethostname() found.' >&4
        d_gethname="$define"
        call=gethostname
fi
if set uname val -f d_uname; eval $csym; $val; then
        if ./xenix; then
                $cat <<'EOM'
uname() was found, but you're running xenix, and older versions of xenix
have a broken uname(). If you don't really know whether your xenix is old
enough to have a broken system call, use the default answer.

EOM
                dflt=y
                case "$d_uname" in
                "$define") dflt=n;;
                esac
                rp='Is your uname() broken?'
                . ./myread
                case "$ans" in
                n*) d_uname="$define"; call=uname;;
                esac
        else
                echo 'uname() found.' >&4
                d_uname="$define"
                case "$call" in
                '') call=uname ;;
                esac
        fi
fi
case "$d_gethname" in
'') d_gethname="$undef";;
esac
case "$d_uname" in
'') d_uname="$undef";;
esac
case "$d_uname$d_gethname" in
*define*)
        dflt=n
        cat <<EOM

Every now and then someone has a $call() that lies about the hostname
but can't be fixed for political or economic reasons.  If you wish, I can
pretend $call() isn't there and maybe compute hostname at run-time
thanks to the '$phostname' command.

EOM
        rp="Shall I ignore $call() from now on?"
        . ./myread
        case "$ans" in
        y*) d_uname="$undef" d_gethname="$undef"; $echo $n "Okay...$c";;
        esac;;
esac
case "$phostname" in
'') aphostname='';;
*) case "$aphostname" in
        /*) ;;
        *) set X $phostname
                shift
                file=$1
                shift
                file=`./loc $file $file $pth`
                aphostname=`echo $file $*`
                ;;
        esac
        ;;
esac
case "$d_uname$d_gethname" in
*define*) ;;
*)
        case "$phostname" in
        '')
                echo "There will be no way for $package to get your hostname." >&4;;
        *)
        echo "I'll use 'popen("'"'$aphostname'", "r")'"' to get your hostname." >&4
                ;;
        esac;;
esac
case "$d_phostname" in
'') d_phostname="$undef";;
esac

: see if gethostbyaddr_r exists
set gethostbyaddr_r d_gethostbyaddr_r
eval $inlibc
case "$d_gethostbyaddr_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_gethostbyaddr_r_proto:$usethreads" in
        ":define")      d_gethostbyaddr_r_proto=define
                set d_gethostbyaddr_r_proto gethostbyaddr_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_gethostbyaddr_r_proto" in
        define)
        case "$gethostbyaddr_r_proto" in
        ''|0) try='int gethostbyaddr_r(const char*, size_t, int, struct hostent*, char*, size_t, struct hostent**, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=I_CWISBWRE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='struct hostent* gethostbyaddr_r(const char*, size_t, int, struct hostent*, char*, size_t, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=S_CWISBWIE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='struct hostent* gethostbyaddr_r(const char*, size_t, int, struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=S_CWISBIE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='struct hostent* gethostbyaddr_r(const void*, size_t, int, struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=S_TWISBIE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='struct hostent* gethostbyaddr_r(const char*, int, int, struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=S_CIISBIE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='struct hostent* gethostbyaddr_r(const char*, struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=S_CSBIE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='struct hostent* gethostbyaddr_r(const void*, struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=S_TSBIE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='int gethostbyaddr_r(const char*, size_t, int, struct hostent*, struct hostent_data*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=I_CWISD ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='int gethostbyaddr_r(const char*, int, int, struct hostent*, struct hostent_data*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=I_CIISD ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='int gethostbyaddr_r(const char*, int, int);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=I_CII ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0) try='int gethostbyaddr_r(const void*, socklen_t, int, struct hostent*, char*, size_t, struct hostent**, int*);'
        ./protochk "extern $try" $hdrs && gethostbyaddr_r_proto=I_TsISBWRE ;;
        esac
        case "$gethostbyaddr_r_proto" in
        ''|0)   d_gethostbyaddr_r=undef
                gethostbyaddr_r_proto=0
                echo "Disabling gethostbyaddr_r, cannot determine prototype." >&4 ;;
        * )     case "$gethostbyaddr_r_proto" in
                REENTRANT_PROTO*) ;;
                *) gethostbyaddr_r_proto="REENTRANT_PROTO_$gethostbyaddr_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "gethostbyaddr_r has no prototype, not using it." >&4 ;;
                esac
                d_gethostbyaddr_r=undef
                gethostbyaddr_r_proto=0
                ;;
        esac
        ;;
*)      gethostbyaddr_r_proto=0
        ;;
esac

: see if gethostbyname_r exists
set gethostbyname_r d_gethostbyname_r
eval $inlibc
case "$d_gethostbyname_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_gethostbyname_r_proto:$usethreads" in
        ":define")      d_gethostbyname_r_proto=define
                set d_gethostbyname_r_proto gethostbyname_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_gethostbyname_r_proto" in
        define)
        case "$gethostbyname_r_proto" in
        ''|0) try='int gethostbyname_r(const char*, struct hostent*, char*, size_t, struct hostent**, int*);'
        ./protochk "extern $try" $hdrs && gethostbyname_r_proto=I_CSBWRE ;;
        esac
        case "$gethostbyname_r_proto" in
        ''|0) try='struct hostent* gethostbyname_r(const char*, struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostbyname_r_proto=S_CSBIE ;;
        esac
        case "$gethostbyname_r_proto" in
        ''|0) try='int gethostbyname_r(const char*, struct hostent*, struct hostent_data*);'
        ./protochk "extern $try" $hdrs && gethostbyname_r_proto=I_CSD ;;
        esac
        case "$gethostbyname_r_proto" in
        ''|0)   d_gethostbyname_r=undef
                gethostbyname_r_proto=0
                echo "Disabling gethostbyname_r, cannot determine prototype." >&4 ;;
        * )     case "$gethostbyname_r_proto" in
                REENTRANT_PROTO*) ;;
                *) gethostbyname_r_proto="REENTRANT_PROTO_$gethostbyname_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "gethostbyname_r has no prototype, not using it." >&4 ;;
                esac
                d_gethostbyname_r=undef
                gethostbyname_r_proto=0
                ;;
        esac
        ;;
*)      gethostbyname_r_proto=0
        ;;
esac

: see if gethostent_r exists
set gethostent_r d_gethostent_r
eval $inlibc
case "$d_gethostent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_gethostent_r_proto:$usethreads" in
        ":define")      d_gethostent_r_proto=define
                set d_gethostent_r_proto gethostent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_gethostent_r_proto" in
        define)
        case "$gethostent_r_proto" in
        ''|0) try='int gethostent_r(struct hostent*, char*, size_t, struct hostent**, int*);'
        ./protochk "extern $try" $hdrs && gethostent_r_proto=I_SBWRE ;;
        esac
        case "$gethostent_r_proto" in
        ''|0) try='int gethostent_r(struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostent_r_proto=I_SBIE ;;
        esac
        case "$gethostent_r_proto" in
        ''|0) try='struct hostent* gethostent_r(struct hostent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && gethostent_r_proto=S_SBIE ;;
        esac
        case "$gethostent_r_proto" in
        ''|0) try='struct hostent* gethostent_r(struct hostent*, char*, int);'
        ./protochk "extern $try" $hdrs && gethostent_r_proto=S_SBI ;;
        esac
        case "$gethostent_r_proto" in
        ''|0) try='int gethostent_r(struct hostent*, char*, int);'
        ./protochk "extern $try" $hdrs && gethostent_r_proto=I_SBI ;;
        esac
        case "$gethostent_r_proto" in
        ''|0) try='int gethostent_r(struct hostent*, struct hostent_data*);'
        ./protochk "extern $try" $hdrs && gethostent_r_proto=I_SD ;;
        esac
        case "$gethostent_r_proto" in
        ''|0)   d_gethostent_r=undef
                gethostent_r_proto=0
                echo "Disabling gethostent_r, cannot determine prototype." >&4 ;;
        * )     case "$gethostent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) gethostent_r_proto="REENTRANT_PROTO_$gethostent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "gethostent_r has no prototype, not using it." >&4 ;;
                esac
                d_gethostent_r=undef
                gethostent_r_proto=0
                ;;
        esac
        ;;
*)      gethostent_r_proto=0
        ;;
esac

: see if prototypes for various gethostxxx netdb.h functions are available
echo " "
set d_gethostprotos gethostent $i_netdb netdb.h
eval $hasproto

: see if getitimer exists
set getitimer d_getitimer
eval $inlibc

: see if getlogin exists
set getlogin d_getlogin
eval $inlibc

: see if getlogin_r exists
set getlogin_r d_getlogin_r
eval $inlibc
case "$d_getlogin_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_unistd unistd.h"
        case "$d_getlogin_r_proto:$usethreads" in
        ":define")      d_getlogin_r_proto=define
                set d_getlogin_r_proto getlogin_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getlogin_r_proto" in
        define)
        case "$getlogin_r_proto" in
        ''|0) try='int getlogin_r(char*, size_t);'
        ./protochk "extern $try" $hdrs && getlogin_r_proto=I_BW ;;
        esac
        case "$getlogin_r_proto" in
        ''|0) try='int getlogin_r(char*, int);'
        ./protochk "extern $try" $hdrs && getlogin_r_proto=I_BI ;;
        esac
        case "$getlogin_r_proto" in
        ''|0) try='char* getlogin_r(char*, size_t);'
        ./protochk "extern $try" $hdrs && getlogin_r_proto=B_BW ;;
        esac
        case "$getlogin_r_proto" in
        ''|0) try='char* getlogin_r(char*, int);'
        ./protochk "extern $try" $hdrs && getlogin_r_proto=B_BI ;;
        esac
        case "$getlogin_r_proto" in
        ''|0)   d_getlogin_r=undef
                getlogin_r_proto=0
                echo "Disabling getlogin_r, cannot determine prototype." >&4 ;;
        * )     case "$getlogin_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getlogin_r_proto="REENTRANT_PROTO_$getlogin_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getlogin_r has no prototype, not using it." >&4 ;;
                esac
                d_getlogin_r=undef
                getlogin_r_proto=0
                ;;
        esac
        ;;
*)      getlogin_r_proto=0
        ;;
esac

: see if getmnt exists
set getmnt d_getmnt
eval $inlibc

: see if getmntent exists
set getmntent d_getmntent
eval $inlibc

: see if getnetbyaddr exists
set getnetbyaddr d_getnbyaddr
eval $inlibc

: see if getnetbyname exists
set getnetbyname d_getnbyname
eval $inlibc

: see if getnetent exists
set getnetent d_getnent
eval $inlibc

: see if getnetbyaddr_r exists
set getnetbyaddr_r d_getnetbyaddr_r
eval $inlibc
case "$d_getnetbyaddr_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getnetbyaddr_r_proto:$usethreads" in
        ":define")      d_getnetbyaddr_r_proto=define
                set d_getnetbyaddr_r_proto getnetbyaddr_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getnetbyaddr_r_proto" in
        define)
        case "$getnetbyaddr_r_proto" in
        ''|0) try='int getnetbyaddr_r(unsigned long, int, struct netent*, char*, size_t, struct netent**, int*);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=I_UISBWRE ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='int getnetbyaddr_r(long, int, struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=I_LISBI ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='struct netent* getnetbyaddr_r(in_addr_t, int, struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=S_TISBI ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='struct netent* getnetbyaddr_r(long, int, struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=S_LISBI ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='int getnetbyaddr_r(in_addr_t, int, struct netent*, struct netent_data*);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=I_TISD ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='int getnetbyaddr_r(long, int, struct netent*, struct netent_data*);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=I_LISD ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='int getnetbyaddr_r(int, int, struct netent*, struct netent_data*);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=I_IISD ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0) try='int getnetbyaddr_r(uint32_t, int, struct netent*, char*, size_t, struct netent**, int*);'
        ./protochk "extern $try" $hdrs && getnetbyaddr_r_proto=I_uISBWRE ;;
        esac
        case "$getnetbyaddr_r_proto" in
        ''|0)   d_getnetbyaddr_r=undef
                getnetbyaddr_r_proto=0
                echo "Disabling getnetbyaddr_r, cannot determine prototype." >&4 ;;
        * )     case "$getnetbyaddr_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getnetbyaddr_r_proto="REENTRANT_PROTO_$getnetbyaddr_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getnetbyaddr_r has no prototype, not using it." >&4 ;;
                esac
                d_getnetbyaddr_r=undef
                getnetbyaddr_r_proto=0
                ;;
        esac
        ;;
*)      getnetbyaddr_r_proto=0
        ;;
esac

: see if getnetbyname_r exists
set getnetbyname_r d_getnetbyname_r
eval $inlibc
case "$d_getnetbyname_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getnetbyname_r_proto:$usethreads" in
        ":define")      d_getnetbyname_r_proto=define
                set d_getnetbyname_r_proto getnetbyname_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getnetbyname_r_proto" in
        define)
        case "$getnetbyname_r_proto" in
        ''|0) try='int getnetbyname_r(const char*, struct netent*, char*, size_t, struct netent**, int*);'
        ./protochk "extern $try" $hdrs && getnetbyname_r_proto=I_CSBWRE ;;
        esac
        case "$getnetbyname_r_proto" in
        ''|0) try='int getnetbyname_r(const char*, struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetbyname_r_proto=I_CSBI ;;
        esac
        case "$getnetbyname_r_proto" in
        ''|0) try='struct netent* getnetbyname_r(const char*, struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetbyname_r_proto=S_CSBI ;;
        esac
        case "$getnetbyname_r_proto" in
        ''|0) try='int getnetbyname_r(const char*, struct netent*, struct netent_data*);'
        ./protochk "extern $try" $hdrs && getnetbyname_r_proto=I_CSD ;;
        esac
        case "$getnetbyname_r_proto" in
        ''|0)   d_getnetbyname_r=undef
                getnetbyname_r_proto=0
                echo "Disabling getnetbyname_r, cannot determine prototype." >&4 ;;
        * )     case "$getnetbyname_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getnetbyname_r_proto="REENTRANT_PROTO_$getnetbyname_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getnetbyname_r has no prototype, not using it." >&4 ;;
                esac
                d_getnetbyname_r=undef
                getnetbyname_r_proto=0
                ;;
        esac
        ;;
*)      getnetbyname_r_proto=0
        ;;
esac

: see if getnetent_r exists
set getnetent_r d_getnetent_r
eval $inlibc
case "$d_getnetent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getnetent_r_proto:$usethreads" in
        ":define")      d_getnetent_r_proto=define
                set d_getnetent_r_proto getnetent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getnetent_r_proto" in
        define)
        case "$getnetent_r_proto" in
        ''|0) try='int getnetent_r(struct netent*, char*, size_t, struct netent**, int*);'
        ./protochk "extern $try" $hdrs && getnetent_r_proto=I_SBWRE ;;
        esac
        case "$getnetent_r_proto" in
        ''|0) try='int getnetent_r(struct netent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && getnetent_r_proto=I_SBIE ;;
        esac
        case "$getnetent_r_proto" in
        ''|0) try='struct netent* getnetent_r(struct netent*, char*, int, int*);'
        ./protochk "extern $try" $hdrs && getnetent_r_proto=S_SBIE ;;
        esac
        case "$getnetent_r_proto" in
        ''|0) try='struct netent* getnetent_r(struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetent_r_proto=S_SBI ;;
        esac
        case "$getnetent_r_proto" in
        ''|0) try='int getnetent_r(struct netent*, char*, int);'
        ./protochk "extern $try" $hdrs && getnetent_r_proto=I_SBI ;;
        esac
        case "$getnetent_r_proto" in
        ''|0) try='int getnetent_r(struct netent*, struct netent_data*);'
        ./protochk "extern $try" $hdrs && getnetent_r_proto=I_SD ;;
        esac
        case "$getnetent_r_proto" in
        ''|0)   d_getnetent_r=undef
                getnetent_r_proto=0
                echo "Disabling getnetent_r, cannot determine prototype." >&4 ;;
        * )     case "$getnetent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getnetent_r_proto="REENTRANT_PROTO_$getnetent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getnetent_r has no prototype, not using it." >&4 ;;
                esac
                d_getnetent_r=undef
                getnetent_r_proto=0
                ;;
        esac
        ;;
*)      getnetent_r_proto=0
        ;;
esac

: see if prototypes for various getnetxxx netdb.h functions are available
echo " "
set d_getnetprotos getnetent $i_netdb netdb.h
eval $hasproto

: see if getpagesize exists
set getpagesize d_getpagsz
eval $inlibc


: see if getprotobyname exists
set getprotobyname d_getpbyname
eval $inlibc

: see if getprotobynumber exists
set getprotobynumber d_getpbynumber
eval $inlibc

: see if getprotoent exists
set getprotoent d_getpent
eval $inlibc

: see if getpgid exists
set getpgid d_getpgid
eval $inlibc

: see if getpgrp2 exists
set getpgrp2 d_getpgrp2
eval $inlibc

: see if getppid exists
set getppid d_getppid
eval $inlibc

: see if getpriority exists
set getpriority d_getprior
eval $inlibc

: see if getprotobyname_r exists
set getprotobyname_r d_getprotobyname_r
eval $inlibc
case "$d_getprotobyname_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getprotobyname_r_proto:$usethreads" in
        ":define")      d_getprotobyname_r_proto=define
                set d_getprotobyname_r_proto getprotobyname_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getprotobyname_r_proto" in
        define)
        case "$getprotobyname_r_proto" in
        ''|0) try='int getprotobyname_r(const char*, struct protoent*, char*, size_t, struct protoent**);'
        ./protochk "extern $try" $hdrs && getprotobyname_r_proto=I_CSBWR ;;
        esac
        case "$getprotobyname_r_proto" in
        ''|0) try='struct protoent* getprotobyname_r(const char*, struct protoent*, char*, int);'
        ./protochk "extern $try" $hdrs && getprotobyname_r_proto=S_CSBI ;;
        esac
        case "$getprotobyname_r_proto" in
        ''|0) try='int getprotobyname_r(const char*, struct protoent*, struct protoent_data*);'
        ./protochk "extern $try" $hdrs && getprotobyname_r_proto=I_CSD ;;
        esac
        case "$getprotobyname_r_proto" in
        ''|0)   d_getprotobyname_r=undef
                getprotobyname_r_proto=0
                echo "Disabling getprotobyname_r, cannot determine prototype." >&4 ;;
        * )     case "$getprotobyname_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getprotobyname_r_proto="REENTRANT_PROTO_$getprotobyname_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getprotobyname_r has no prototype, not using it." >&4 ;;
                esac
                d_getprotobyname_r=undef
                getprotobyname_r_proto=0
                ;;
        esac
        ;;
*)      getprotobyname_r_proto=0
        ;;
esac

: see if getprotobynumber_r exists
set getprotobynumber_r d_getprotobynumber_r
eval $inlibc
case "$d_getprotobynumber_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getprotobynumber_r_proto:$usethreads" in
        ":define")      d_getprotobynumber_r_proto=define
                set d_getprotobynumber_r_proto getprotobynumber_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getprotobynumber_r_proto" in
        define)
        case "$getprotobynumber_r_proto" in
        ''|0) try='int getprotobynumber_r(int, struct protoent*, char*, size_t, struct protoent**);'
        ./protochk "extern $try" $hdrs && getprotobynumber_r_proto=I_ISBWR ;;
        esac
        case "$getprotobynumber_r_proto" in
        ''|0) try='struct protoent* getprotobynumber_r(int, struct protoent*, char*, int);'
        ./protochk "extern $try" $hdrs && getprotobynumber_r_proto=S_ISBI ;;
        esac
        case "$getprotobynumber_r_proto" in
        ''|0) try='int getprotobynumber_r(int, struct protoent*, struct protoent_data*);'
        ./protochk "extern $try" $hdrs && getprotobynumber_r_proto=I_ISD ;;
        esac
        case "$getprotobynumber_r_proto" in
        ''|0)   d_getprotobynumber_r=undef
                getprotobynumber_r_proto=0
                echo "Disabling getprotobynumber_r, cannot determine prototype." >&4 ;;
        * )     case "$getprotobynumber_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getprotobynumber_r_proto="REENTRANT_PROTO_$getprotobynumber_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getprotobynumber_r has no prototype, not using it." >&4 ;;
                esac
                d_getprotobynumber_r=undef
                getprotobynumber_r_proto=0
                ;;
        esac
        ;;
*)      getprotobynumber_r_proto=0
        ;;
esac

: see if getprotoent_r exists
set getprotoent_r d_getprotoent_r
eval $inlibc
case "$d_getprotoent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getprotoent_r_proto:$usethreads" in
        ":define")      d_getprotoent_r_proto=define
                set d_getprotoent_r_proto getprotoent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getprotoent_r_proto" in
        define)
        case "$getprotoent_r_proto" in
        ''|0) try='int getprotoent_r(struct protoent*, char*, size_t, struct protoent**);'
        ./protochk "extern $try" $hdrs && getprotoent_r_proto=I_SBWR ;;
        esac
        case "$getprotoent_r_proto" in
        ''|0) try='int getprotoent_r(struct protoent*, char*, int);'
        ./protochk "extern $try" $hdrs && getprotoent_r_proto=I_SBI ;;
        esac
        case "$getprotoent_r_proto" in
        ''|0) try='struct protoent* getprotoent_r(struct protoent*, char*, int);'
        ./protochk "extern $try" $hdrs && getprotoent_r_proto=S_SBI ;;
        esac
        case "$getprotoent_r_proto" in
        ''|0) try='int getprotoent_r(struct protoent*, struct protoent_data*);'
        ./protochk "extern $try" $hdrs && getprotoent_r_proto=I_SD ;;
        esac
        case "$getprotoent_r_proto" in
        ''|0)   d_getprotoent_r=undef
                getprotoent_r_proto=0
                echo "Disabling getprotoent_r, cannot determine prototype." >&4 ;;
        * )     case "$getprotoent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getprotoent_r_proto="REENTRANT_PROTO_$getprotoent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getprotoent_r has no prototype, not using it." >&4 ;;
                esac
                d_getprotoent_r=undef
                getprotoent_r_proto=0
                ;;
        esac
        ;;
*)      getprotoent_r_proto=0
        ;;
esac

: see if prototypes for various getprotoxxx netdb.h functions are available
echo " "
set d_getprotoprotos getprotoent $i_netdb netdb.h
eval $hasproto

: see if getprpwnam exists
set getprpwnam d_getprpwnam
eval $inlibc

: see if getpwent exists
set getpwent d_getpwent
eval $inlibc

: see if getpwent_r exists
set getpwent_r d_getpwent_r
eval $inlibc
case "$d_getpwent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_pwd pwd.h"
        case "$d_getpwent_r_proto:$usethreads" in
        ":define")      d_getpwent_r_proto=define
                set d_getpwent_r_proto getpwent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getpwent_r_proto" in
        define)
        case "$getpwent_r_proto" in
        ''|0) try='int getpwent_r(struct passwd*, char*, size_t, struct passwd**);'
        ./protochk "extern $try" $hdrs && getpwent_r_proto=I_SBWR ;;
        esac
        case "$getpwent_r_proto" in
        ''|0) try='int getpwent_r(struct passwd*, char*, int, struct passwd**);'
        ./protochk "extern $try" $hdrs && getpwent_r_proto=I_SBIR ;;
        esac
        case "$getpwent_r_proto" in
        ''|0) try='struct passwd* getpwent_r(struct passwd*, char*, size_t);'
        ./protochk "extern $try" $hdrs && getpwent_r_proto=S_SBW ;;
        esac
        case "$getpwent_r_proto" in
        ''|0) try='struct passwd* getpwent_r(struct passwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getpwent_r_proto=S_SBI ;;
        esac
        case "$getpwent_r_proto" in
        ''|0) try='int getpwent_r(struct passwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getpwent_r_proto=I_SBI ;;
        esac
        case "$getpwent_r_proto" in
        ''|0) try='int getpwent_r(struct passwd*, char*, int, FILE**);'
        ./protochk "extern $try" $hdrs && getpwent_r_proto=I_SBIH ;;
        esac
        case "$getpwent_r_proto" in
        ''|0)   d_getpwent_r=undef
                getpwent_r_proto=0
                echo "Disabling getpwent_r, cannot determine prototype." >&4 ;;
        * )     case "$getpwent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getpwent_r_proto="REENTRANT_PROTO_$getpwent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getpwent_r has no prototype, not using it." >&4 ;;
                esac
                d_getpwent_r=undef
                getpwent_r_proto=0
                ;;
        esac
        ;;
*)      getpwent_r_proto=0
        ;;
esac

: see if getpwnam_r exists
set getpwnam_r d_getpwnam_r
eval $inlibc
case "$d_getpwnam_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_pwd pwd.h"
        case "$d_getpwnam_r_proto:$usethreads" in
        ":define")      d_getpwnam_r_proto=define
                set d_getpwnam_r_proto getpwnam_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getpwnam_r_proto" in
        define)
        case "$getpwnam_r_proto" in
        ''|0) try='int getpwnam_r(const char*, struct passwd*, char*, size_t, struct passwd**);'
        ./protochk "extern $try" $hdrs && getpwnam_r_proto=I_CSBWR ;;
        esac
        case "$getpwnam_r_proto" in
        ''|0) try='int getpwnam_r(const char*, struct passwd*, char*, int, struct passwd**);'
        ./protochk "extern $try" $hdrs && getpwnam_r_proto=I_CSBIR ;;
        esac
        case "$getpwnam_r_proto" in
        ''|0) try='struct passwd* getpwnam_r(const char*, struct passwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getpwnam_r_proto=S_CSBI ;;
        esac
        case "$getpwnam_r_proto" in
        ''|0) try='int getpwnam_r(const char*, struct passwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getpwnam_r_proto=I_CSBI ;;
        esac
        case "$getpwnam_r_proto" in
        ''|0)   d_getpwnam_r=undef
                getpwnam_r_proto=0
                echo "Disabling getpwnam_r, cannot determine prototype." >&4 ;;
        * )     case "$getpwnam_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getpwnam_r_proto="REENTRANT_PROTO_$getpwnam_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getpwnam_r has no prototype, not using it." >&4 ;;
                esac
                d_getpwnam_r=undef
                getpwnam_r_proto=0
                ;;
        esac
        ;;
*)      getpwnam_r_proto=0
        ;;
esac

: see if getpwuid_r exists
set getpwuid_r d_getpwuid_r
eval $inlibc
case "$d_getpwuid_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_pwd pwd.h"
        case "$d_getpwuid_r_proto:$usethreads" in
        ":define")      d_getpwuid_r_proto=define
                set d_getpwuid_r_proto getpwuid_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getpwuid_r_proto" in
        define)
        case "$getpwuid_r_proto" in
        ''|0) try='int getpwuid_r(uid_t, struct passwd*, char*, size_t, struct passwd**);'
        ./protochk "extern $try" $hdrs && getpwuid_r_proto=I_TSBWR ;;
        esac
        case "$getpwuid_r_proto" in
        ''|0) try='int getpwuid_r(uid_t, struct passwd*, char*, int, struct passwd**);'
        ./protochk "extern $try" $hdrs && getpwuid_r_proto=I_TSBIR ;;
        esac
        case "$getpwuid_r_proto" in
        ''|0) try='int getpwuid_r(uid_t, struct passwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getpwuid_r_proto=I_TSBI ;;
        esac
        case "$getpwuid_r_proto" in
        ''|0) try='struct passwd* getpwuid_r(uid_t, struct passwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getpwuid_r_proto=S_TSBI ;;
        esac
        case "$getpwuid_r_proto" in
        ''|0)   d_getpwuid_r=undef
                getpwuid_r_proto=0
                echo "Disabling getpwuid_r, cannot determine prototype." >&4 ;;
        * )     case "$getpwuid_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getpwuid_r_proto="REENTRANT_PROTO_$getpwuid_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getpwuid_r has no prototype, not using it." >&4 ;;
                esac
                d_getpwuid_r=undef
                getpwuid_r_proto=0
                ;;
        esac
        ;;
*)      getpwuid_r_proto=0
        ;;
esac


: see if getservbyname exists
set getservbyname d_getsbyname
eval $inlibc

: see if getservbyport exists
set getservbyport d_getsbyport
eval $inlibc

: see if getservent exists
set getservent d_getsent
eval $inlibc

: see if getservbyname_r exists
set getservbyname_r d_getservbyname_r
eval $inlibc
case "$d_getservbyname_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getservbyname_r_proto:$usethreads" in
        ":define")      d_getservbyname_r_proto=define
                set d_getservbyname_r_proto getservbyname_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getservbyname_r_proto" in
        define)
        case "$getservbyname_r_proto" in
        ''|0) try='int getservbyname_r(const char*, const char*, struct servent*, char*, size_t, struct servent**);'
        ./protochk "extern $try" $hdrs && getservbyname_r_proto=I_CCSBWR ;;
        esac
        case "$getservbyname_r_proto" in
        ''|0) try='struct servent* getservbyname_r(const char*, const char*, struct servent*, char*, int);'
        ./protochk "extern $try" $hdrs && getservbyname_r_proto=S_CCSBI ;;
        esac
        case "$getservbyname_r_proto" in
        ''|0) try='int getservbyname_r(const char*, const char*, struct servent*, struct servent_data*);'
        ./protochk "extern $try" $hdrs && getservbyname_r_proto=I_CCSD ;;
        esac
        case "$getservbyname_r_proto" in
        ''|0)   d_getservbyname_r=undef
                getservbyname_r_proto=0
                echo "Disabling getservbyname_r, cannot determine prototype." >&4 ;;
        * )     case "$getservbyname_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getservbyname_r_proto="REENTRANT_PROTO_$getservbyname_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getservbyname_r has no prototype, not using it." >&4 ;;
                esac
                d_getservbyname_r=undef
                getservbyname_r_proto=0
                ;;
        esac
        ;;
*)      getservbyname_r_proto=0
        ;;
esac

: see if getservbyport_r exists
set getservbyport_r d_getservbyport_r
eval $inlibc
case "$d_getservbyport_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getservbyport_r_proto:$usethreads" in
        ":define")      d_getservbyport_r_proto=define
                set d_getservbyport_r_proto getservbyport_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getservbyport_r_proto" in
        define)
        case "$getservbyport_r_proto" in
        ''|0) try='int getservbyport_r(int, const char*, struct servent*, char*, size_t, struct servent**);'
        ./protochk "extern $try" $hdrs && getservbyport_r_proto=I_ICSBWR ;;
        esac
        case "$getservbyport_r_proto" in
        ''|0) try='struct servent* getservbyport_r(int, const char*, struct servent*, char*, int);'
        ./protochk "extern $try" $hdrs && getservbyport_r_proto=S_ICSBI ;;
        esac
        case "$getservbyport_r_proto" in
        ''|0) try='int getservbyport_r(int, const char*, struct servent*, struct servent_data*);'
        ./protochk "extern $try" $hdrs && getservbyport_r_proto=I_ICSD ;;
        esac
        case "$getservbyport_r_proto" in
        ''|0)   d_getservbyport_r=undef
                getservbyport_r_proto=0
                echo "Disabling getservbyport_r, cannot determine prototype." >&4 ;;
        * )     case "$getservbyport_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getservbyport_r_proto="REENTRANT_PROTO_$getservbyport_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getservbyport_r has no prototype, not using it." >&4 ;;
                esac
                d_getservbyport_r=undef
                getservbyport_r_proto=0
                ;;
        esac
        ;;
*)      getservbyport_r_proto=0
        ;;
esac

: see if getservent_r exists
set getservent_r d_getservent_r
eval $inlibc
case "$d_getservent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_getservent_r_proto:$usethreads" in
        ":define")      d_getservent_r_proto=define
                set d_getservent_r_proto getservent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getservent_r_proto" in
        define)
        case "$getservent_r_proto" in
        ''|0) try='int getservent_r(struct servent*, char*, size_t, struct servent**);'
        ./protochk "extern $try" $hdrs && getservent_r_proto=I_SBWR ;;
        esac
        case "$getservent_r_proto" in
        ''|0) try='int getservent_r(struct servent*, char*, int);'
        ./protochk "extern $try" $hdrs && getservent_r_proto=I_SBI ;;
        esac
        case "$getservent_r_proto" in
        ''|0) try='struct servent* getservent_r(struct servent*, char*, int);'
        ./protochk "extern $try" $hdrs && getservent_r_proto=S_SBI ;;
        esac
        case "$getservent_r_proto" in
        ''|0) try='int getservent_r(struct servent*, struct servent_data*);'
        ./protochk "extern $try" $hdrs && getservent_r_proto=I_SD ;;
        esac
        case "$getservent_r_proto" in
        ''|0)   d_getservent_r=undef
                getservent_r_proto=0
                echo "Disabling getservent_r, cannot determine prototype." >&4 ;;
        * )     case "$getservent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getservent_r_proto="REENTRANT_PROTO_$getservent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getservent_r has no prototype, not using it." >&4 ;;
                esac
                d_getservent_r=undef
                getservent_r_proto=0
                ;;
        esac
        ;;
*)      getservent_r_proto=0
        ;;
esac

: see if prototypes for various getservxxx netdb.h functions are available
echo " "
set d_getservprotos getservent $i_netdb netdb.h
eval $hasproto

: see if getspnam exists
set getspnam d_getspnam
eval $inlibc

: see if this is a shadow.h system
set shadow.h i_shadow
eval $inhdr

: see if getspnam_r exists
set getspnam_r d_getspnam_r
eval $inlibc
case "$d_getspnam_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_shadow shadow.h"
        case "$d_getspnam_r_proto:$usethreads" in
        ":define")      d_getspnam_r_proto=define
                set d_getspnam_r_proto getspnam_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_getspnam_r_proto" in
        define)
        case "$getspnam_r_proto" in
        ''|0) try='int getspnam_r(const char*, struct spwd*, char*, size_t, struct spwd**);'
        ./protochk "extern $try" $hdrs && getspnam_r_proto=I_CSBWR ;;
        esac
        case "$getspnam_r_proto" in
        ''|0) try='struct spwd* getspnam_r(const char*, struct spwd*, char*, int);'
        ./protochk "extern $try" $hdrs && getspnam_r_proto=S_CSBI ;;
        esac
        case "$getspnam_r_proto" in
        ''|0)   d_getspnam_r=undef
                getspnam_r_proto=0
                echo "Disabling getspnam_r, cannot determine prototype." >&4 ;;
        * )     case "$getspnam_r_proto" in
                REENTRANT_PROTO*) ;;
                *) getspnam_r_proto="REENTRANT_PROTO_$getspnam_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "getspnam_r has no prototype, not using it." >&4 ;;
                esac
                d_getspnam_r=undef
                getspnam_r_proto=0
                ;;
        esac
        ;;
*)      getspnam_r_proto=0
        ;;
esac

: see if gettimeofday or ftime exists
set gettimeofday d_gettimeod
eval $inlibc
case "$d_gettimeod" in
"$undef")
        set ftime d_ftime
        eval $inlibc
        ;;
*)
        val="$undef"; set d_ftime; eval $setvar
        ;;
esac
case "$d_gettimeod$d_ftime" in
"$undef$undef")
        echo " "
        echo 'No ftime() nor gettimeofday() -- timing may be less accurate.' >&4
        ;;
esac

: see if gmtime_r exists
set gmtime_r d_gmtime_r
eval $inlibc
case "$d_gmtime_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_time time.h $i_systime sys/time.h"
        case "$d_gmtime_r_proto:$usethreads" in
        ":define")      d_gmtime_r_proto=define
                set d_gmtime_r_proto gmtime_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_gmtime_r_proto" in
        define)
        case "$gmtime_r_proto" in
        ''|0) try='struct tm* gmtime_r(const time_t*, struct tm*);'
        ./protochk "extern $try" $hdrs && gmtime_r_proto=S_TS ;;
        esac
        case "$gmtime_r_proto" in
        ''|0) try='int gmtime_r(const time_t*, struct tm*);'
        ./protochk "extern $try" $hdrs && gmtime_r_proto=I_TS ;;
        esac
        case "$gmtime_r_proto" in
        ''|0)   d_gmtime_r=undef
                gmtime_r_proto=0
                echo "Disabling gmtime_r, cannot determine prototype." >&4 ;;
        * )     case "$gmtime_r_proto" in
                REENTRANT_PROTO*) ;;
                *) gmtime_r_proto="REENTRANT_PROTO_$gmtime_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "gmtime_r has no prototype, not using it." >&4 ;;
                esac
                d_gmtime_r=undef
                gmtime_r_proto=0
                ;;
        esac
        ;;
*)      gmtime_r_proto=0
        ;;
esac

: see if hasmntopt exists
set hasmntopt d_hasmntopt
eval $inlibc

: see if this is a netinet/in.h or sys/in.h system
set netinet/in.h i_niin sys/in.h i_sysin
eval $inhdr

: see if arpa/inet.h has to be included
set arpa/inet.h i_arpainet
eval $inhdr

: see if htonl --and friends-- exists
val=''
set htonl val
eval $inlibc

: Maybe they are macros.
case "$val" in
$undef)
        $cat >htonl.c <<EOM
#include <stdio.h>
#include <sys/types.h>
#$i_niin I_NETINET_IN
#$i_sysin I_SYS_IN
#$i_arpainet I_ARPA_INET
#ifdef I_NETINET_IN
#include <netinet/in.h>
#endif
#ifdef I_SYS_IN
#include <sys/in.h>
#endif
#ifdef I_ARPA_INET
#include <arpa/inet.h>
#endif
#ifdef htonl
printf("Defined as a macro.");
#endif
EOM
        $cppstdin $cppflags $cppminus < htonl.c >htonl.E 2>/dev/null
        if $contains 'Defined as a macro' htonl.E >/dev/null 2>&1; then
                val="$define"
                echo "But it seems to be defined as a macro." >&4
        fi
        $rm -f htonl.?
        ;;
esac
set d_htonl
eval $setvar

: see if ilogbl exists
set ilogbl d_ilogbl
eval $inlibc

: index or strchr
echo " "
if set index val -f; eval $csym; $val; then
        if set strchr val -f d_strchr; eval $csym; $val; then
                if $contains strchr "$strings" >/dev/null 2>&1 ; then
                        val="$define"
                        vali="$undef"
                        echo "strchr() found." >&4
                else
                        val="$undef"
                        vali="$define"
                        echo "index() found." >&4
                fi
        else
                val="$undef"
                vali="$define"
                echo "index() found." >&4
        fi
else
        if set strchr val -f d_strchr; eval $csym; $val; then
                val="$define"
                vali="$undef"
                echo "strchr() found." >&4
        else
                echo "No index() or strchr() found!" >&4
                val="$undef"
                vali="$undef"
        fi
fi
set d_strchr; eval $setvar
val="$vali"
set d_index; eval $setvar

: check whether inet_aton exists
set inet_aton d_inetaton
eval $inlibc

: Look for isascii
echo " "
$cat >isascii.c <<EOCP
#include <stdio.h>
#include <ctype.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
        int c = 'A';
        if (isascii(c))
                exit(0);
        else
                exit(1);
}
EOCP
set isascii
if eval $compile; then
        echo "isascii() found." >&4
        val="$define"
else
        echo "isascii() NOT found." >&4
        val="$undef"
fi
set d_isascii
eval $setvar
$rm -f isascii*

: see if isfinite exists
set isfinite d_isfinite
eval $inlibc

: see if isinf exists
set isinf d_isinf
eval $inlibc

: see if isnan exists
set isnan d_isnan
eval $inlibc

: see if isnanl exists
set isnanl d_isnanl
eval $inlibc

: see if killpg exists
set killpg d_killpg
eval $inlibc

: see if lchown exists
echo " "
$cat > try.c <<'EOCP'
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char lchown(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
   builtin and then its argument prototype would still apply.  */
char lchown();
int main() {
    /*  The GNU C library defines this for functions which it implements
        to always fail with ENOSYS.  Some functions are actually named
        something starting with __ and the normal name is an alias.  */
#if defined (__stub_lchown) || defined (__stub___lchown)
choke me
#else
lchown();
#endif
; return 0; }
EOCP
set try
if eval $compile; then
    $echo "lchown() found." >&4
    val="$define"
else
    $echo "lchown() NOT found." >&4
    val="$undef"
fi
set d_lchown
eval $setvar

: See if number of significant digits in a double precision number is known
echo " "
$cat >ldbl_dig.c <<EOM
#$i_limits I_LIMITS
#$i_float I_FLOAT
#ifdef I_LIMITS
#include <limits.h>
#endif
#ifdef I_FLOAT
#include <float.h>
#endif
#ifdef LDBL_DIG
printf("Contains LDBL_DIG");
#endif
EOM
$cppstdin $cppflags $cppminus < ldbl_dig.c >ldbl_dig.E 2>/dev/null
if $contains 'LDBL_DIG' ldbl_dig.E >/dev/null 2>&1; then
        echo "LDBL_DIG found." >&4
        val="$define"
else
        echo "LDBL_DIG NOT found." >&4
        val="$undef"
fi
$rm -f ldbl_dig.?
set d_ldbl_dig
eval $setvar

: see if link exists
set link d_link
eval $inlibc

: see if localtime_r exists
set localtime_r d_localtime_r
eval $inlibc
case "$d_localtime_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_time time.h $i_systime sys/time.h"
        case "$d_localtime_r_proto:$usethreads" in
        ":define")      d_localtime_r_proto=define
                set d_localtime_r_proto localtime_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_localtime_r_proto" in
        define)
        case "$localtime_r_proto" in
        ''|0) try='struct tm* localtime_r(const time_t*, struct tm*);'
        ./protochk "extern $try" $hdrs && localtime_r_proto=S_TS ;;
        esac
        case "$localtime_r_proto" in
        ''|0) try='int localtime_r(const time_t*, struct tm*);'
        ./protochk "extern $try" $hdrs && localtime_r_proto=I_TS ;;
        esac
        case "$localtime_r_proto" in
        ''|0)   d_localtime_r=undef
                localtime_r_proto=0
                echo "Disabling localtime_r, cannot determine prototype." >&4 ;;
        * )     case "$localtime_r_proto" in
                REENTRANT_PROTO*) ;;
                *) localtime_r_proto="REENTRANT_PROTO_$localtime_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "localtime_r has no prototype, not using it." >&4 ;;
                esac
                d_localtime_r=undef
                localtime_r_proto=0
                ;;
        esac
        ;;
*)      localtime_r_proto=0
        ;;
esac

: see if localeconv exists
set localeconv d_locconv
eval $inlibc

: see if lockf exists
set lockf d_lockf
eval $inlibc

: see if prototype for lseek is available
echo " "
set d_lseekproto lseek $i_systypes sys/types.h $i_unistd unistd.h
eval $hasproto

: see if lstat exists
set lstat d_lstat
eval $inlibc

: see if madvise exists
set madvise d_madvise
eval $inlibc

: see if mblen exists
set mblen d_mblen
eval $inlibc

: see if mbstowcs exists
set mbstowcs d_mbstowcs
eval $inlibc

: see if mbtowc exists
set mbtowc d_mbtowc
eval $inlibc

: see if memchr exists
set memchr d_memchr
eval $inlibc

: see if memcmp exists
set memcmp d_memcmp
eval $inlibc

: see if memcpy exists
set memcpy d_memcpy
eval $inlibc

: see if memmove exists
set memmove d_memmove
eval $inlibc

: see if memset exists
set memset d_memset
eval $inlibc

: see if mkdir exists
set mkdir d_mkdir
eval $inlibc

: see if mkdtemp exists
set mkdtemp d_mkdtemp
eval $inlibc

: see if mkfifo exists
set mkfifo d_mkfifo
eval $inlibc

: see if mkstemp exists
set mkstemp d_mkstemp
eval $inlibc

: see if mkstemps exists
set mkstemps d_mkstemps
eval $inlibc

: see if mktime exists
set mktime d_mktime
eval $inlibc

: see if this is a sys/mman.h system
set sys/mman.h i_sysmman
eval $inhdr

: see if mmap exists
set mmap d_mmap
eval $inlibc
: see what shmat returns
: default to something harmless
mmaptype='void *'
case "$i_sysmman$d_mmap" in
"$define$define")
        $cat >mmap.c <<'END'
#include <sys/mman.h>
void *mmap();
END
        if $cc $ccflags -c mmap.c >/dev/null 2>&1; then
                mmaptype='void *'
        else
                mmaptype='caddr_t'
        fi
        echo "and it returns ($mmaptype)." >&4
        ;;
esac



: see if sqrtl exists
set sqrtl d_sqrtl
eval $inlibc

: see if scalbnl exists
set scalbnl d_scalbnl
eval $inlibc

: see if modfl exists
set modfl d_modfl
eval $inlibc

: see if prototype for modfl is available
echo " "
set d_modflproto modfl math.h
eval $hasproto

d_modfl_pow32_bug="$undef"

case "$d_longdbl$d_modfl" in
$define$define)
        $cat <<EOM
Checking to see whether your modfl() is okay for large values...
EOM
$cat >try.c <<EOCP
#include <math.h>
#include <stdio.h>
EOCP
if $test "X$d_modflproto" != "X$define"; then
        $cat >>try.c <<EOCP
/* Sigh. many current glibcs provide the function, but do not prototype it.  */
long double modfl (long double, long double *);
EOCP
fi
$cat >>try.c <<EOCP
int main() {
    long double nv = 4294967303.15;
    long double v, w;
    v = modfl(nv, &w);
#ifdef __GLIBC__
    printf("glibc");
#endif
    printf(" %"$sPRIfldbl" %"$sPRIfldbl" %"$sPRIfldbl"\n", nv, v, w);
    return 0;
}
EOCP
        case "$osname:$gccversion" in
        aix:)   saveccflags="$ccflags"
                ccflags="$ccflags -qlongdouble" ;; # to avoid core dump
        esac
        set try
        if eval $compile; then
                foo=`$run ./try`
                case "$foo" in
                *" 4294967303.150000 1.150000 4294967302.000000")
                        echo >&4 "Your modfl() is broken for large values."
                        d_modfl_pow32_bug="$define"
                        case "$foo" in
                        glibc)  echo >&4 "You should upgrade your glibc to at least 2.2.2 to get a fixed modfl()."
                        ;;
                        esac
                        ;;
                *" 4294967303.150000 0.150000 4294967303.000000")
                        echo >&4 "Your modfl() seems okay for large values."
                        ;;
                *)      echo >&4 "I don't understand your modfl() at all."
                        d_modfl="$undef"
                        ;;
                esac
                $rm -f try.* try core core.try.*
        else
                echo "I cannot figure out whether your modfl() is okay, assuming it isn't."
                d_modfl="$undef"
        fi
        case "$osname:$gccversion" in
        aix:)   ccflags="$saveccflags" ;; # restore
        esac
        ;;
esac

if $test "$uselongdouble" = "$define"; then
    message=""
    if $test "$d_sqrtl" != "$define"; then
        message="$message sqrtl"
    fi
    if $test "$d_modfl" != "$define"; then
        if $test "$d_aintl:$d_copysignl" = "$define:$define"; then
            echo "You have both aintl and copysignl, so I can emulate modfl."
        else
            message="$message modfl"
        fi
    fi
    if $test "$d_frexpl" != "$define"; then
        if $test "$d_ilogbl:$d_scalbnl" = "$define:$define"; then
            echo "You have both ilogbl and scalbnl, so I can emulate frexpl."
        else
            message="$message frexpl"
        fi
    fi

    if $test "$message" != ""; then
        $cat <<EOM >&4

*** You requested the use of long doubles but you do not seem to have
*** the following mathematical functions needed for long double support:
***    $message
*** Please rerun Configure without -Duselongdouble and/or -Dusemorebits.
*** Cannot continue, aborting.

EOM

        exit 1
    fi
fi

: see if mprotect exists
set mprotect d_mprotect
eval $inlibc

: see if msgctl exists
set msgctl d_msgctl
eval $inlibc

: see if msgget exists
set msgget d_msgget
eval $inlibc

: see if msgsnd exists
set msgsnd d_msgsnd
eval $inlibc

: see if msgrcv exists
set msgrcv d_msgrcv
eval $inlibc

: see how much of the 'msg*(2)' library is present.
h_msg=true
echo " "
case "$d_msgctl$d_msgget$d_msgsnd$d_msgrcv" in
*"$undef"*) h_msg=false;;
esac
case "$osname" in
freebsd)
    case "`ipcs 2>&1`" in
    "SVID messages"*"not configured"*)
        echo "Your $osname does not have the msg*(2) configured." >&4
        h_msg=false
        val="$undef"
        set msgctl d_msgctl
        eval $setvar
        set msgget d_msgget
        eval $setvar
        set msgsnd d_msgsnd
        eval $setvar
        set msgrcv d_msgrcv
        eval $setvar
        ;;
    esac
    ;;
esac
: we could also check for sys/ipc.h ...
if $h_msg && $test `./findhdr sys/msg.h`; then
        echo "You have the full msg*(2) library." >&4
        val="$define"
else
        echo "You don't have the full msg*(2) library." >&4
        val="$undef"
fi
set d_msg
eval $setvar


echo " "
echo "Checking to see if your system supports struct msghdr..." >&4
set d_msghdr_s msghdr $i_systypes sys/types.h $d_socket sys/socket.h $i_sysuio sys/uio.h
eval $hasstruct
case "$d_msghdr_s" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac


: see if msync exists
set msync d_msync
eval $inlibc

: see if munmap exists
set munmap d_munmap
eval $inlibc

: see if nice exists
set nice d_nice
eval $inlibc

: see if this is a langinfo.h system
set langinfo.h i_langinfo
eval $inhdr

: see if nl_langinfo exists
set nl_langinfo d_nl_langinfo
eval $inlibc

: check for length of character
echo " "
case "$charsize" in
'')
        echo "Checking to see how big your characters are (hey, you never know)..." >&4
        $cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
    printf("%d\n", (int)sizeof(char));
    exit(0);
}
EOCP
        set try
        if eval $compile_ok; then
                dflt=`$run ./try`
        else
                dflt='1'
                echo "(I can't seem to compile the test program.  Guessing...)"
        fi
        ;;
*)
        dflt="$charsize"
        ;;
esac
rp="What is the size of a character (in bytes)?"
. ./myread
charsize="$ans"
$rm -f try.c try

: check for volatile keyword
echo " "
echo 'Checking to see if your C compiler knows about "volatile"...' >&4
$cat >try.c <<'EOCP'
int main()
{
        typedef struct _goo_struct goo_struct;
        goo_struct * volatile goo = ((goo_struct *)0);
        struct _goo_struct {
                long long_int;
                int reg_int;
                char char_var;
        };
        typedef unsigned short foo_t;
        char *volatile foo;
        volatile int bar;
        volatile foo_t blech;
        foo = foo;
}
EOCP
if $cc -c $ccflags try.c >/dev/null 2>&1 ; then
        val="$define"
        echo "Yup, it does."
else
        val="$undef"
        echo "Nope, it doesn't."
fi
set d_volatile
eval $setvar
$rm -f try.*


echo " "
$echo "Choosing the C types to be used for Perl's internal types..." >&4

case "$use64bitint:$d_quad:$quadtype" in
define:define:?*)
        ivtype="$quadtype"
        uvtype="$uquadtype"
        ivsize=8
        uvsize=8
        ;;
*)      ivtype="long"
        uvtype="unsigned long"
        ivsize=$longsize
        uvsize=$longsize
        ;;
esac

case "$uselongdouble:$d_longdbl" in
define:define)
        nvtype="long double"
        nvsize=$longdblsize
        ;;
*)      nvtype=double
        nvsize=$doublesize
        ;;
esac

$echo "(IV will be "$ivtype", $ivsize bytes)"
$echo "(UV will be "$uvtype", $uvsize bytes)"
$echo "(NV will be "$nvtype", $nvsize bytes)"

$cat >try.c <<EOCP
#$i_inttypes I_INTTYPES
#ifdef I_INTTYPES
#include <inttypes.h>
#endif
#include <stdio.h>
int main() {
#ifdef INT8
   int8_t i =  INT8_MAX;
  uint8_t u = UINT8_MAX;
  printf("int8_t\n");
#endif
#ifdef INT16
   int16_t i =  INT16_MAX;
  uint16_t i = UINT16_MAX;
  printf("int16_t\n");
#endif
#ifdef INT32
   int32_t i =  INT32_MAX;
  uint32_t u = UINT32_MAX;
  printf("int32_t\n");
#endif
}
EOCP

case "$i8type" in
'')     case "$charsize" in
        1)      i8type=char
                u8type="unsigned char"
                i8size=$charsize
                u8size=$charsize
                ;;
        esac
        ;;
esac
case "$i8type" in
'')     set try -DINT8
        if eval $compile; then
                case "`$run ./try`" in
                int8_t) i8type=int8_t
                        u8type=uint8_t
                        i8size=1
                        u8size=1
                        ;;
                esac
        fi
        ;;
esac
case "$i8type" in
'')     if $test $charsize -ge 1; then
                i8type=char
                u8type="unsigned char"
                i8size=$charsize
                u8size=$charsize
        fi
        ;;
esac

case "$i16type" in
'')     case "$shortsize" in
        2)      i16type=short
                u16type="unsigned short"
                i16size=$shortsize
                u16size=$shortsize
                ;;
        esac
        ;;
esac
case "$i16type" in
'')     set try -DINT16
        if eval $compile; then
                case "`$run ./try`" in
                int16_t)
                        i16type=int16_t
                        u16type=uint16_t
                        i16size=2
                        u16size=2
                        ;;
                esac
        fi
        ;;
esac
case "$i16type" in
'')     if $test $shortsize -ge 2; then
                i16type=short
                u16type="unsigned short"
                i16size=$shortsize
                u16size=$shortsize
        fi
        ;;
esac

case "$i32type" in
'')     case "$longsize" in
        4)      i32type=long
                u32type="unsigned long"
                i32size=$longsize
                u32size=$longsize
                ;;
        *)      case "$intsize" in
                4)      i32type=int
                        u32type="unsigned int"
                        i32size=$intsize
                        u32size=$intsize
                        ;;
                esac
                ;;
        esac
        ;;
esac
case "$i32type" in
'')     set try -DINT32
        if eval $compile; then
                case "`$run ./try`" in
                int32_t)
                        i32type=int32_t
                        u32type=uint32_t
                        i32size=4
                        u32size=4
                        ;;
                esac
        fi
        ;;
esac
case "$i32type" in
'')     if $test $intsize -ge 4; then
                i32type=int
                u32type="unsigned int"
                i32size=$intsize
                u32size=$intsize
        fi
        ;;
esac

case "$i64type" in
'')     case "$d_quad:$quadtype" in
        define:?*)
                i64type="$quadtype"
                u64type="$uquadtype"
                i64size=8
                u64size=8
                ;;
        esac
        ;;
esac

$echo "Checking how many bits of your UVs your NVs can preserve..." >&4
: volatile so that the compiler has to store it out to memory.
if test X"$d_volatile" = X"$define"; then
        volatile=volatile
fi
$cat <<EOP >try.c
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <sys/types.h>
#include <signal.h>
#ifdef SIGFPE
$volatile int bletched = 0;
$signal_t blech(s) int s; { bletched = 1; }
#endif
int main() {
    $uvtype u = 0;
    $nvtype d;
    int     n = 8 * $uvsize;
    int     i;
#ifdef SIGFPE
    signal(SIGFPE, blech);
#endif

    for (i = 0; i < n; i++) {
      u = u << 1 | ($uvtype)1;
      d = ($nvtype)u;
      if (($uvtype)d != u)
        break;
      if (d <= 0)
        break;
      d = ($nvtype)(u - 1);
      if (($uvtype)d != (u - 1))
        break;
#ifdef SIGFPE
      if (bletched) {
        break;
#endif
      }
    }
    printf("%d\n", ((i == n) ? -n : i));
    exit(0);
}
EOP
set try

d_nv_preserves_uv="$undef"
if eval $compile; then
        nv_preserves_uv_bits="`$run ./try`"
fi
case "$nv_preserves_uv_bits" in
\-[1-9]*)
        nv_preserves_uv_bits=`expr 0 - $nv_preserves_uv_bits`
        $echo "Your NVs can preserve all $nv_preserves_uv_bits bits of your UVs."  2>&1
        d_nv_preserves_uv="$define"
        ;;
[1-9]*) $echo "Your NVs can preserve only $nv_preserves_uv_bits bits of your UVs."  2>&1
        d_nv_preserves_uv="$undef" ;;
*)      $echo "Can't figure out how many bits your NVs preserve." 2>&1
        nv_preserves_uv_bits="$undef" ;;
esac

$rm -f try.* try


: check for off64_t
echo " "
echo "Checking to see if you have off64_t..." >&4
$cat >try.c <<EOCP
#include <sys/types.h>
#include <unistd.h>
int main() { off64_t x = 7; }
EOCP
set try
if eval $compile; then
        val="$define"
        echo "You have off64_t."
else
        val="$undef"
        echo "You do not have off64_t."
        case "$lseeksize" in
        8) echo "(Your off_t is 64 bits, so you could use that.)" ;;
        esac
fi
$rm -f try.* try
set d_off64_t
eval $setvar

: how to create joinable pthreads
if test "X$usethreads" = "X$define" -a "X$i_pthread" = "X$define"; then
        echo " "
        echo "Checking what constant to use for creating joinable pthreads..." >&4
        $cat >try.c <<'EOCP'
#include <pthread.h>
int main() {
    int detachstate = JOINABLE;
}
EOCP
        set try -DJOINABLE=PTHREAD_CREATE_JOINABLE
        if eval $compile; then
                echo "You seem to use PTHREAD_CREATE_JOINABLE." >&4
                val="$undef" # Yes, undef.
                set d_old_pthread_create_joinable
                eval $setvar
                val=""
                set old_pthread_create_joinable
                eval $setvar
        else
                set try -DJOINABLE=PTHREAD_CREATE_UNDETACHED
                if eval $compile; then
                        echo "You seem to use PTHREAD_CREATE_UNDETACHED." >&4
                        val="$define"
                        set d_old_pthread_create_joinable
                        eval $setvar
                        val=PTHREAD_CREATE_UNDETACHED
                        set old_pthread_create_joinable
                        eval $setvar
                else
                        set try -DJOINABLE=__UNDETACHED
                        if eval $compile; then
                                echo "You seem to use __UNDETACHED." >&4
                                val="$define"
                                set d_old_pthread_create_joinable
                                eval $setvar
                                val=__UNDETACHED
                                set old_pthread_create_joinable
                                eval $setvar
                        else
                                echo "Egads, nothing obvious found.  Guessing that you use 0." >&4
                                val="$define"
                                set d_old_pthread_create_joinable
                                eval $setvar
                                val=0
                                set old_pthread_create_joinable
                                eval $setvar
                        fi
                fi
        fi
        $rm -f try try.*
else
    d_old_pthread_create_joinable="$undef"
    old_pthread_create_joinable=""
fi

: see if pause exists
set pause d_pause
eval $inlibc

: see if pipe exists
set pipe d_pipe
eval $inlibc

: see if poll exists
set poll d_poll
eval $inlibc

: see if readlink exists
set readlink d_readlink
eval $inlibc

echo " "
procselfexe=''
val="$undef"
case "$d_readlink" in
"$define")
        if $issymlink /proc/self/exe ; then
                $ls -l /proc/self/exe > reflect
                if $contains /`basename $ls` reflect >/dev/null 2>&1; then
                        echo "You have Linux-like /proc/self/exe."
                        procselfexe='"/proc/self/exe"'
                        val="$define"
                fi
        fi
        if $issymlink /proc/curproc/file ; then
                $ls -l /proc/curproc/file > reflect
                if $contains /`basename $ls` reflect >/dev/null 2>&1; then
                        echo "You have BSD-like /proc/curproc/file."
                        procselfexe='"/proc/curproc/file"'
                        val="$define"
                fi
        fi
        ;;
esac
$rm -f reflect
set d_procselfexe
eval $setvar

: see whether the pthread_atfork exists
$cat >try.c <<EOP
#include <pthread.h>
#include <stdio.h>
int main() {
#ifdef  PTHREAD_ATFORK
        pthread_atfork(NULL,NULL,NULL);
#endif
}
EOP

: see if pthread_atfork exists
set try -DPTHREAD_ATFORK
if eval $compile; then
    val="$define"
else
    val="$undef"
fi
case "$usethreads" in
$define)
        case "$val" in
        $define) echo 'pthread_atfork found.' >&4        ;;
        *)       echo 'pthread_atfork NOT found.' >&4    ;;
        esac
esac
set d_pthread_atfork
eval $setvar

: see if pthread_attr_setscope exists
set pthread_attr_setscope d_pthread_attr_setscope
eval $inlibc


: see whether the various POSIXish _yields exist
$cat >try.c <<EOP
#include <pthread.h>
#include <stdio.h>
int main() {
#ifdef SCHED_YIELD
        sched_yield();
#else
#ifdef PTHREAD_YIELD
        pthread_yield();
#else
#ifdef PTHREAD_YIELD_NULL
        pthread_yield(NULL);
#endif
#endif
#endif
}
EOP
: see if sched_yield exists
set try -DSCHED_YIELD
if eval $compile; then
    val="$define"
    sched_yield='sched_yield()'
else
    val="$undef"
fi
case "$usethreads" in
$define)
        case "$val" in
        $define) echo 'sched_yield() found.' >&4        ;;
        *)       echo 'sched_yield() NOT found.' >&4    ;;
        esac
esac
set d_sched_yield
eval $setvar

: see if pthread_yield exists
set try -DPTHREAD_YIELD
if eval $compile; then
    val="$define"
    case "$sched_yield" in
    '') sched_yield='pthread_yield()' ;;
    esac
else
    set try -DPTHREAD_YIELD_NULL
    if eval $compile; then
        val="$define"
        case "$sched_yield" in
        '') sched_yield='pthread_yield(NULL)' ;;
        esac
    else
        val="$undef"
    fi
fi
case "$usethreads" in
$define)
        case "$val" in
        $define) echo 'pthread_yield() found.' >&4      ;;
        *)       echo 'pthread_yield() NOT found.' >&4  ;;
        esac
        ;;
esac
set d_pthread_yield
eval $setvar

case "$sched_yield" in
'') sched_yield=undef ;;
esac

$rm -f try try.*

: see if random_r exists
set random_r d_random_r
eval $inlibc
case "$d_random_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_stdlib stdlib.h"
        case "$d_random_r_proto:$usethreads" in
        ":define")      d_random_r_proto=define
                set d_random_r_proto random_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_random_r_proto" in
        define)
        case "$random_r_proto" in
        ''|0) try='int random_r(int*, struct random_data*);'
        ./protochk "extern $try" $hdrs && random_r_proto=I_iS ;;
        esac
        case "$random_r_proto" in
        ''|0) try='int random_r(long*, struct random_data*);'
        ./protochk "extern $try" $hdrs && random_r_proto=I_lS ;;
        esac
        case "$random_r_proto" in
        ''|0) try='int random_r(struct random_data*, int32_t*);'
        ./protochk "extern $try" $hdrs && random_r_proto=I_St ;;
        esac
        case "$random_r_proto" in
        ''|0)   d_random_r=undef
                random_r_proto=0
                echo "Disabling random_r, cannot determine prototype." >&4 ;;
        * )     case "$random_r_proto" in
                REENTRANT_PROTO*) ;;
                *) random_r_proto="REENTRANT_PROTO_$random_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "random_r has no prototype, not using it." >&4 ;;
                esac
                d_random_r=undef
                random_r_proto=0
                ;;
        esac
        ;;
*)      random_r_proto=0
        ;;
esac

: see if readdir and friends exist
set readdir d_readdir
eval $inlibc
set seekdir d_seekdir
eval $inlibc
set telldir d_telldir
eval $inlibc
set rewinddir d_rewinddir
eval $inlibc

: see if readdir64_r exists
set readdir64_r d_readdir64_r
eval $inlibc
case "$d_readdir64_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_dirent dirent.h"
        case "$d_readdir64_r_proto:$usethreads" in
        ":define")      d_readdir64_r_proto=define
                set d_readdir64_r_proto readdir64_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_readdir64_r_proto" in
        define)
        case "$readdir64_r_proto" in
        ''|0) try='int readdir64_r(DIR*, struct dirent64*, struct dirent64**);'
        ./protochk "extern $try" $hdrs && readdir64_r_proto=I_TSR ;;
        esac
        case "$readdir64_r_proto" in
        ''|0) try='int readdir64_r(DIR*, struct dirent64*);'
        ./protochk "extern $try" $hdrs && readdir64_r_proto=I_TS ;;
        esac
        case "$readdir64_r_proto" in
        ''|0)   d_readdir64_r=undef
                readdir64_r_proto=0
                echo "Disabling readdir64_r, cannot determine prototype." >&4 ;;
        * )     case "$readdir64_r_proto" in
                REENTRANT_PROTO*) ;;
                *) readdir64_r_proto="REENTRANT_PROTO_$readdir64_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "readdir64_r has no prototype, not using it." >&4 ;;
                esac
                d_readdir64_r=undef
                readdir64_r_proto=0
                ;;
        esac
        ;;
*)      readdir64_r_proto=0
        ;;
esac

: see if readdir_r exists
set readdir_r d_readdir_r
eval $inlibc
case "$d_readdir_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_dirent dirent.h"
        case "$d_readdir_r_proto:$usethreads" in
        ":define")      d_readdir_r_proto=define
                set d_readdir_r_proto readdir_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_readdir_r_proto" in
        define)
        case "$readdir_r_proto" in
        ''|0) try='int readdir_r(DIR*, struct dirent*, struct dirent**);'
        ./protochk "extern $try" $hdrs && readdir_r_proto=I_TSR ;;
        esac
        case "$readdir_r_proto" in
        ''|0) try='int readdir_r(DIR*, struct dirent*);'
        ./protochk "extern $try" $hdrs && readdir_r_proto=I_TS ;;
        esac
        case "$readdir_r_proto" in
        ''|0)   d_readdir_r=undef
                readdir_r_proto=0
                echo "Disabling readdir_r, cannot determine prototype." >&4 ;;
        * )     case "$readdir_r_proto" in
                REENTRANT_PROTO*) ;;
                *) readdir_r_proto="REENTRANT_PROTO_$readdir_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "readdir_r has no prototype, not using it." >&4 ;;
                esac
                d_readdir_r=undef
                readdir_r_proto=0
                ;;
        esac
        ;;
*)      readdir_r_proto=0
        ;;
esac

: see if readv exists
set readv d_readv
eval $inlibc

: see if recvmsg exists
set recvmsg d_recvmsg
eval $inlibc

: see if rename exists
set rename d_rename
eval $inlibc

: see if rmdir exists
set rmdir d_rmdir
eval $inlibc

: see if memory.h is available.
val=''
set memory.h val
eval $inhdr

: See if it conflicts with string.h
case "$val" in
$define)
        case "$strings" in
        '') ;;
        *)
                $cppstdin $cppflags $cppminus < $strings > mem.h
                if $contains 'memcpy' mem.h >/dev/null 2>&1; then
                        echo " "
                        echo "We won't be including <memory.h>."
                        val="$undef"
                fi
                $rm -f mem.h
                ;;
        esac
esac
set i_memory
eval $setvar

: can bcopy handle overlapping blocks?
echo " "
val="$undef"
case "$d_memmove" in
"$define") echo "I'll use memmove() instead of bcopy() for overlapping copies." ;;
*)      case "$d_bcopy" in
        "$define")
                echo "Checking to see if bcopy() can do overlapping copies..." >&4
                $cat >try.c <<EOCP
#$i_memory I_MEMORY
#$i_stdlib I_STDLIB
#$i_string I_STRING
#$i_unistd I_UNISTD
EOCP
        $cat >>try.c <<'EOCP'
#include <stdio.h>
#ifdef I_MEMORY
#  include <memory.h>
#endif
#ifdef I_STDLIB
#  include <stdlib.h>
#endif
#ifdef I_STRING
#  include <string.h>
#else
#  include <strings.h>
#endif
#ifdef I_UNISTD
#  include <unistd.h>  /* Needed for NetBSD */
#endif
int main()
{
char buf[128], abc[128];
char *b;
int len;
int off;
int align;

/* Copy "abcde..." string to char abc[] so that gcc doesn't
   try to store the string in read-only memory. */
bcopy("abcdefghijklmnopqrstuvwxyz0123456789", abc, 36);

for (align = 7; align >= 0; align--) {
        for (len = 36; len; len--) {
                b = buf+align;
                bcopy(abc, b, len);
                for (off = 1; off <= len; off++) {
                        bcopy(b, b+off, len);
                        bcopy(b+off, b, len);
                        if (bcmp(b, abc, len))
                                exit(1);
                }
        }
}
exit(0);
}
EOCP
                set try
                if eval $compile_ok; then
                        if ./try 2>/dev/null; then
                                echo "Yes, it can."
                                val="$define"
                        else
                                echo "It can't, sorry."
                        fi
                else
                        echo "(I can't compile the test program, so we'll assume not...)"
                fi
                ;;
        esac
        $rm -f try.* try core
        ;;
esac
set d_safebcpy
eval $setvar

: can memcpy handle overlapping blocks?
echo " "
val="$undef"
case "$d_memmove" in
"$define") echo "I'll use memmove() instead of memcpy() for overlapping copies." ;;
*)      case "$d_memcpy" in
        "$define")
                echo "Checking to see if memcpy() can do overlapping copies..." >&4
                $cat >try.c <<EOCP
#$i_memory I_MEMORY
#$i_stdlib I_STDLIB
#$i_string I_STRING
#$i_unistd I_UNISTD
EOCP
        $cat >>try.c <<'EOCP'
#include <stdio.h>
#ifdef I_MEMORY
#  include <memory.h>
#endif
#ifdef I_STDLIB
#  include <stdlib.h>
#endif
#ifdef I_STRING
#  include <string.h>
#else
#  include <strings.h>
#endif
#ifdef I_UNISTD
#  include <unistd.h>  /* Needed for NetBSD */
#endif
int main()
{
char buf[128], abc[128];
char *b;
int len;
int off;
int align;

/* Copy "abcde..." string to char abc[] so that gcc doesn't
   try to store the string in read-only memory. */
memcpy(abc, "abcdefghijklmnopqrstuvwxyz0123456789", 36);

for (align = 7; align >= 0; align--) {
        for (len = 36; len; len--) {
                b = buf+align;
                memcpy(b, abc, len);
                for (off = 1; off <= len; off++) {
                        memcpy(b+off, b, len);
                        memcpy(b, b+off, len);
                        if (memcmp(b, abc, len))
                                exit(1);
                }
        }
}
exit(0);
}
EOCP
                set try
                if eval $compile_ok; then
                        if ./try 2>/dev/null; then
                                echo "Yes, it can."
                                val="$define"
                        else
                                echo "It can't, sorry."
                        fi
                else
                        echo "(I can't compile the test program, so we'll assume not...)"
                fi
                ;;
        esac
        $rm -f try.* try core
        ;;
esac
set d_safemcpy
eval $setvar

: can memcmp be trusted to compare relative magnitude?
val="$undef"
case "$d_memcmp" in
"$define")
        echo " "
        echo "Checking if your memcmp() can compare relative magnitude..." >&4
        $cat >try.c <<EOCP
#$i_memory I_MEMORY
#$i_stdlib I_STDLIB
#$i_string I_STRING
#$i_unistd I_UNISTD
EOCP
        $cat >>try.c <<'EOCP'
#include <stdio.h>
#ifdef I_MEMORY
#  include <memory.h>
#endif
#ifdef I_STDLIB
#  include <stdlib.h>
#endif
#ifdef I_STRING
#  include <string.h>
#else
#  include <strings.h>
#endif
#ifdef I_UNISTD
#  include <unistd.h>  /* Needed for NetBSD */
#endif
int main()
{
char a = -1;
char b = 0;
if ((a < b) && memcmp(&a, &b, 1) < 0)
        exit(1);
exit(0);
}
EOCP
        set try
        if eval $compile_ok; then
                if $run ./try 2>/dev/null; then
                        echo "Yes, it can."
                        val="$define"
                else
                        echo "No, it can't (it uses signed chars)."
                fi
        else
                echo "(I can't compile the test program, so we'll assume not...)"
        fi
        ;;
esac
$rm -f try.* try core
set d_sanemcmp
eval $setvar

: see if prototype for sbrk is available
echo " "
set d_sbrkproto sbrk $i_unistd unistd.h
eval $hasproto

: see if select exists
set select d_select
eval $inlibc

: see if semctl exists
set semctl d_semctl
eval $inlibc

: see if semget exists
set semget d_semget
eval $inlibc

: see if semop exists
set semop d_semop
eval $inlibc

: see how much of the 'sem*(2)' library is present.
h_sem=true
echo " "
case "$d_semctl$d_semget$d_semop" in
*"$undef"*) h_sem=false;;
esac
case "$osname" in
freebsd)
    case "`ipcs 2>&1`" in
    "SVID messages"*"not configured"*)
        echo "Your $osname does not have the sem*(2) configured." >&4
        h_sem=false
        val="$undef"
        set semctl d_semctl
        eval $setvar
        set semget d_semget
        eval $setvar
        set semop d_semop
        eval $setvar
        ;;
    esac
    ;;
esac
: we could also check for sys/ipc.h ...
if $h_sem && $test `./findhdr sys/sem.h`; then
        echo "You have the full sem*(2) library." >&4
        val="$define"
else
        echo "You don't have the full sem*(2) library." >&4
        val="$undef"
fi
set d_sem
eval $setvar

: see whether sys/sem.h defines union semun
echo " "
$cat > try.c <<'END'
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
int main () { union semun semun; semun.buf = 0; }
END
set try
if eval $compile; then
    echo "You have union semun in <sys/sem.h>." >&4
    val="$define"
else
    echo "You do not have union semun in <sys/sem.h>." >&4
    val="$undef"
fi
$rm -f try try.c
set d_union_semun
eval $setvar

: see how to do semctl IPC_STAT
case "$d_sem" in
$define)
    echo " "
    $cat > try.h <<END
#ifndef S_IRUSR
#   ifdef S_IREAD
#       define S_IRUSR S_IREAD
#       define S_IWUSR S_IWRITE
#       define S_IXUSR S_IEXEC
#   else
#       define S_IRUSR 0400
#       define S_IWUSR 0200
#       define S_IXUSR 0100
#   endif
#   define S_IRGRP (S_IRUSR>>3)
#   define S_IWGRP (S_IWUSR>>3)
#   define S_IXGRP (S_IXUSR>>3)
#   define S_IROTH (S_IRUSR>>6)
#   define S_IWOTH (S_IWUSR>>6)
#   define S_IXOTH (S_IXUSR>>6)
#endif
#ifndef S_IRWXU
#   define S_IRWXU (S_IRUSR|S_IWUSR|S_IXUSR)
#   define S_IRWXG (S_IRGRP|S_IWGRP|S_IXGRP)
#   define S_IRWXO (S_IROTH|S_IWOTH|S_IXOTH)
#endif
END
    : see whether semctl IPC_STAT can use union semun
    val="$undef"
    case "$d_semctl_semun" in
    '')
      $cat > try.c <<END
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include "try.h"
#ifndef errno
extern int errno;
#endif
#$d_union_semun HAS_UNION_SEMUN
int main() {
    union semun
#ifndef HAS_UNION_SEMUN
    {
        int val;
        struct semid_ds *buf;
        unsigned short *array;
    }
#endif
    arg;
    int sem, st;

#if defined(IPC_PRIVATE) && defined(S_IRWXU) && defined(S_IRWXG) && defined(S_IRWXO) && defined(IPC_CREAT)
    sem = semget(IPC_PRIVATE, 1, S_IRWXU|S_IRWXG|S_IRWXO|IPC_CREAT);
    if (sem > -1) {
        struct semid_ds argbuf;
        arg.buf = &argbuf;
#       ifdef IPC_STAT
        st = semctl(sem, 0, IPC_STAT, arg);
        if (st == 0)
            printf("semun\n");
        else
#       endif /* IPC_STAT */
            printf("semctl IPC_STAT failed: errno = %d\n", errno);
#       ifdef IPC_RMID
        if (semctl(sem, 0, IPC_RMID, arg) != 0)
#       endif /* IPC_RMID */
            printf("semctl IPC_RMID failed: errno = %d\n", errno);
    } else
#endif /* IPC_PRIVATE && ... */
        printf("semget failed: errno = %d\n", errno);
  return 0;
}
END
      set try
      if eval $compile; then
          xxx=`$run ./try`
          case "$xxx" in
          semun) val="$define" ;;
          esac
      fi
      $rm -f try try.c
      ;;
    esac
    set d_semctl_semun
    eval $setvar
    case "$d_semctl_semun" in
    $define)
        echo "You can use union semun for semctl IPC_STAT." >&4
        also='also'
        ;;
    *)  echo "You cannot use union semun for semctl IPC_STAT." >&4
        also=''
        ;;
    esac

    : see whether semctl IPC_STAT can use struct semid_ds pointer
    val="$undef"
    case "$d_semctl_semid_ds" in
    '')
      $cat > try.c <<'END'
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/stat.h>
#include "try.h"
#include <stdio.h>
#include <errno.h>
#ifndef errno
extern int errno;
#endif
int main() {
    struct semid_ds arg;
    int sem, st;

#if defined(IPC_PRIVATE) && defined(S_IRWXU) && defined(S_IRWXG) &&  defined(S_IRWXO) && defined(IPC_CREAT)
    sem = semget(IPC_PRIVATE, 1, S_IRWXU|S_IRWXG|S_IRWXO|IPC_CREAT);
    if (sem > -1) {
#       ifdef IPC_STAT
        st = semctl(sem, 0, IPC_STAT, &arg);
        if (st == 0)
            printf("semid_ds\n");
        else
#       endif /* IPC_STAT */
            printf("semctl IPC_STAT failed: errno = %d\n", errno);
#       ifdef IPC_RMID
        if (semctl(sem, 0, IPC_RMID, &arg) != 0)
#       endif /* IPC_RMID */
            printf("semctl IPC_RMID failed: errno = %d\n", errno);
    } else
#endif /* IPC_PRIVATE && ... */
        printf("semget failed: errno = %d\n", errno);

    return 0;
}
END
      set try
      if eval $compile; then
          xxx=`$run ./try`
          case "$xxx" in
          semid_ds) val="$define" ;;
          esac
      fi
      $rm -f try try.c
      ;;
    esac
    set d_semctl_semid_ds
    eval $setvar
    case "$d_semctl_semid_ds" in
    $define)
        echo "You can $also use struct semid_ds* for semctl IPC_STAT." >&4
        ;;
    *)  echo "You cannot use struct semid_ds* for semctl IPC_STAT." >&4
        ;;
    esac
    $rm -f try.h
    ;;
*)  val="$undef"

    # We do not have the full sem*(2) library, so assume we can not
    # use either.

    set d_semctl_semun
    eval $setvar

    set d_semctl_semid_ds
    eval $setvar
    ;;
esac

: see if sendmsg exists
set sendmsg d_sendmsg
eval $inlibc

: see if setegid exists
set setegid d_setegid
eval $inlibc

: see if seteuid exists
set seteuid d_seteuid
eval $inlibc

: see if setgrent exists
set setgrent d_setgrent
eval $inlibc

: see if setgrent_r exists
set setgrent_r d_setgrent_r
eval $inlibc
case "$d_setgrent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_grp grp.h"
        case "$d_setgrent_r_proto:$usethreads" in
        ":define")      d_setgrent_r_proto=define
                set d_setgrent_r_proto setgrent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_setgrent_r_proto" in
        define)
        case "$setgrent_r_proto" in
        ''|0) try='int setgrent_r(FILE**);'
        ./protochk "extern $try" $hdrs && setgrent_r_proto=I_H ;;
        esac
        case "$setgrent_r_proto" in
        ''|0) try='void setgrent_r(FILE**);'
        ./protochk "extern $try" $hdrs && setgrent_r_proto=V_H ;;
        esac
        case "$setgrent_r_proto" in
        ''|0)   d_setgrent_r=undef
                setgrent_r_proto=0
                echo "Disabling setgrent_r, cannot determine prototype." >&4 ;;
        * )     case "$setgrent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) setgrent_r_proto="REENTRANT_PROTO_$setgrent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "setgrent_r has no prototype, not using it." >&4 ;;
                esac
                d_setgrent_r=undef
                setgrent_r_proto=0
                ;;
        esac
        ;;
*)      setgrent_r_proto=0
        ;;
esac

: see if sethostent exists
set sethostent d_sethent
eval $inlibc

: see if sethostent_r exists
set sethostent_r d_sethostent_r
eval $inlibc
case "$d_sethostent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_sethostent_r_proto:$usethreads" in
        ":define")      d_sethostent_r_proto=define
                set d_sethostent_r_proto sethostent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_sethostent_r_proto" in
        define)
        case "$sethostent_r_proto" in
        ''|0) try='int sethostent_r(int, struct hostent_data*);'
        ./protochk "extern $try" $hdrs && sethostent_r_proto=I_ID ;;
        esac
        case "$sethostent_r_proto" in
        ''|0) try='void sethostent_r(int, struct hostent_data*);'
        ./protochk "extern $try" $hdrs && sethostent_r_proto=V_ID ;;
        esac
        case "$sethostent_r_proto" in
        ''|0)   d_sethostent_r=undef
                sethostent_r_proto=0
                echo "Disabling sethostent_r, cannot determine prototype." >&4 ;;
        * )     case "$sethostent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) sethostent_r_proto="REENTRANT_PROTO_$sethostent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "sethostent_r has no prototype, not using it." >&4 ;;
                esac
                d_sethostent_r=undef
                sethostent_r_proto=0
                ;;
        esac
        ;;
*)      sethostent_r_proto=0
        ;;
esac

: see if setitimer exists
set setitimer d_setitimer
eval $inlibc

: see if setlinebuf exists
set setlinebuf d_setlinebuf
eval $inlibc

: see if setlocale exists
set setlocale d_setlocale
eval $inlibc

: see if locale.h is available
set locale.h i_locale
eval $inhdr

: see if setlocale_r exists
set setlocale_r d_setlocale_r
eval $inlibc
case "$d_setlocale_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_locale locale.h"
        case "$d_setlocale_r_proto:$usethreads" in
        ":define")      d_setlocale_r_proto=define
                set d_setlocale_r_proto setlocale_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_setlocale_r_proto" in
        define)
        case "$setlocale_r_proto" in
        ''|0) try='int setlocale_r(int, const char*, char*, int);'
        ./protochk "extern $try" $hdrs && setlocale_r_proto=I_ICBI ;;
        esac
        case "$setlocale_r_proto" in
        ''|0)   d_setlocale_r=undef
                setlocale_r_proto=0
                echo "Disabling setlocale_r, cannot determine prototype." >&4 ;;
        * )     case "$setlocale_r_proto" in
                REENTRANT_PROTO*) ;;
                *) setlocale_r_proto="REENTRANT_PROTO_$setlocale_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "setlocale_r has no prototype, not using it." >&4 ;;
                esac
                d_setlocale_r=undef
                setlocale_r_proto=0
                ;;
        esac
        ;;
*)      setlocale_r_proto=0
        ;;
esac

: see if setnetent exists
set setnetent d_setnent
eval $inlibc

: see if setnetent_r exists
set setnetent_r d_setnetent_r
eval $inlibc
case "$d_setnetent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_setnetent_r_proto:$usethreads" in
        ":define")      d_setnetent_r_proto=define
                set d_setnetent_r_proto setnetent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_setnetent_r_proto" in
        define)
        case "$setnetent_r_proto" in
        ''|0) try='int setnetent_r(int, struct netent_data*);'
        ./protochk "extern $try" $hdrs && setnetent_r_proto=I_ID ;;
        esac
        case "$setnetent_r_proto" in
        ''|0) try='void setnetent_r(int, struct netent_data*);'
        ./protochk "extern $try" $hdrs && setnetent_r_proto=V_ID ;;
        esac
        case "$setnetent_r_proto" in
        ''|0)   d_setnetent_r=undef
                setnetent_r_proto=0
                echo "Disabling setnetent_r, cannot determine prototype." >&4 ;;
        * )     case "$setnetent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) setnetent_r_proto="REENTRANT_PROTO_$setnetent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "setnetent_r has no prototype, not using it." >&4 ;;
                esac
                d_setnetent_r=undef
                setnetent_r_proto=0
                ;;
        esac
        ;;
*)      setnetent_r_proto=0
        ;;
esac

: see if setprotoent exists
set setprotoent d_setpent
eval $inlibc

: see if setpgid exists
set setpgid d_setpgid
eval $inlibc

: see if setpgrp2 exists
set setpgrp2 d_setpgrp2
eval $inlibc

: see if setpriority exists
set setpriority d_setprior
eval $inlibc

: see if setproctitle exists
set setproctitle d_setproctitle
eval $inlibc

: see if setprotoent_r exists
set setprotoent_r d_setprotoent_r
eval $inlibc
case "$d_setprotoent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_setprotoent_r_proto:$usethreads" in
        ":define")      d_setprotoent_r_proto=define
                set d_setprotoent_r_proto setprotoent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_setprotoent_r_proto" in
        define)
        case "$setprotoent_r_proto" in
        ''|0) try='int setprotoent_r(int, struct protoent_data*);'
        ./protochk "extern $try" $hdrs && setprotoent_r_proto=I_ID ;;
        esac
        case "$setprotoent_r_proto" in
        ''|0) try='void setprotoent_r(int, struct protoent_data*);'
        ./protochk "extern $try" $hdrs && setprotoent_r_proto=V_ID ;;
        esac
        case "$setprotoent_r_proto" in
        ''|0)   d_setprotoent_r=undef
                setprotoent_r_proto=0
                echo "Disabling setprotoent_r, cannot determine prototype." >&4 ;;
        * )     case "$setprotoent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) setprotoent_r_proto="REENTRANT_PROTO_$setprotoent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "setprotoent_r has no prototype, not using it." >&4 ;;
                esac
                d_setprotoent_r=undef
                setprotoent_r_proto=0
                ;;
        esac
        ;;
*)      setprotoent_r_proto=0
        ;;
esac

: see if setpwent exists
set setpwent d_setpwent
eval $inlibc

: see if setpwent_r exists
set setpwent_r d_setpwent_r
eval $inlibc
case "$d_setpwent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_pwd pwd.h"
        case "$d_setpwent_r_proto:$usethreads" in
        ":define")      d_setpwent_r_proto=define
                set d_setpwent_r_proto setpwent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_setpwent_r_proto" in
        define)
        case "$setpwent_r_proto" in
        ''|0) try='int setpwent_r(FILE**);'
        ./protochk "extern $try" $hdrs && setpwent_r_proto=I_H ;;
        esac
        case "$setpwent_r_proto" in
        ''|0) try='void setpwent_r(FILE**);'
        ./protochk "extern $try" $hdrs && setpwent_r_proto=V_H ;;
        esac
        case "$setpwent_r_proto" in
        ''|0)   d_setpwent_r=undef
                setpwent_r_proto=0
                echo "Disabling setpwent_r, cannot determine prototype." >&4 ;;
        * )     case "$setpwent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) setpwent_r_proto="REENTRANT_PROTO_$setpwent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "setpwent_r has no prototype, not using it." >&4 ;;
                esac
                d_setpwent_r=undef
                setpwent_r_proto=0
                ;;
        esac
        ;;
*)      setpwent_r_proto=0
        ;;
esac

: see if setregid exists
set setregid d_setregid
eval $inlibc
set setresgid d_setresgid
eval $inlibc

: see if setreuid exists
set setreuid d_setreuid
eval $inlibc
set setresuid d_setresuid
eval $inlibc

: see if setrgid exists
set setrgid d_setrgid
eval $inlibc

: see if setruid exists
set setruid d_setruid
eval $inlibc

: see if setservent exists
set setservent d_setsent
eval $inlibc

: see if setservent_r exists
set setservent_r d_setservent_r
eval $inlibc
case "$d_setservent_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_netdb netdb.h"
        case "$d_setservent_r_proto:$usethreads" in
        ":define")      d_setservent_r_proto=define
                set d_setservent_r_proto setservent_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_setservent_r_proto" in
        define)
        case "$setservent_r_proto" in
        ''|0) try='int setservent_r(int, struct servent_data*);'
        ./protochk "extern $try" $hdrs && setservent_r_proto=I_ID ;;
        esac
        case "$setservent_r_proto" in
        ''|0) try='void setservent_r(int, struct servent_data*);'
        ./protochk "extern $try" $hdrs && setservent_r_proto=V_ID ;;
        esac
        case "$setservent_r_proto" in
        ''|0)   d_setservent_r=undef
                setservent_r_proto=0
                echo "Disabling setservent_r, cannot determine prototype." >&4 ;;
        * )     case "$setservent_r_proto" in
                REENTRANT_PROTO*) ;;
                *) setservent_r_proto="REENTRANT_PROTO_$setservent_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "setservent_r has no prototype, not using it." >&4 ;;
                esac
                d_setservent_r=undef
                setservent_r_proto=0
                ;;
        esac
        ;;
*)      setservent_r_proto=0
        ;;
esac

: see if setsid exists
set setsid d_setsid
eval $inlibc

: see if setvbuf exists
set setvbuf d_setvbuf
eval $inlibc

: see if sfio.h is available
set sfio.h i_sfio
eval $inhdr


: see if sfio library is available
case "$i_sfio" in
$define)
        val=''
        set sfreserve val
        eval $inlibc
        ;;
*)
        val="$undef"
        ;;
esac
: Ok, but do we want to use it.
case "$val" in
$define)
        case "$usesfio" in
        true|$define|[yY]*) dflt='y';;
        *) dflt='n';;
        esac
        echo "$package can use the sfio library, but it is experimental."
        case "$useperlio" in
        "$undef")
            echo "For sfio also the PerlIO abstraction layer is needed."
            echo "Earlier you said you wouldn't want that."
            ;;
        esac
        rp="You seem to have sfio available, do you want to try using it?"
        . ./myread
        case "$ans" in
        y|Y)    echo "Ok, turning on both sfio and PerlIO, then."
                useperlio="$define"
                val="$define"
                ;;
        *)      echo "Ok, avoiding sfio this time.  I'll use stdio instead."
                val="$undef"
                ;;
        esac
        ;;
*)      case "$usesfio" in
        true|$define|[yY]*)
                echo "Sorry, cannot find sfio on this machine." >&4
                echo "Ignoring your setting of usesfio=$usesfio." >&4
                val="$undef"
                ;;
        esac
        ;;
esac
set d_sfio
eval $setvar
case "$d_sfio" in
$define) usesfio='true';;
*) usesfio='false';;
esac
case "$d_sfio" in
$define) ;;
*)      : Remove sfio from list of libraries to use
        case "$libs" in
        *-lsfio*)
                echo "Removing unneeded -lsfio from library list" >&4
                set `echo X $libs | $sed -e 's/-lsfio / /' -e 's/-lsfio$//'`
                shift
                libs="$*"
                echo "libs = $libs" >&4
                ;;
        esac
;;
esac


: see if shmctl exists
set shmctl d_shmctl
eval $inlibc

: see if shmget exists
set shmget d_shmget
eval $inlibc

: see if shmat exists
set shmat d_shmat
eval $inlibc
: see what shmat returns
case "$d_shmat" in
"$define")
        $cat >shmat.c <<'END'
#include <sys/shm.h>
void *shmat();
END
        if $cc $ccflags -c shmat.c >/dev/null 2>&1; then
                shmattype='void *'
        else
                shmattype='char *'
        fi
        echo "and it returns ($shmattype)." >&4
        : see if a prototype for shmat is available
        xxx=`./findhdr sys/shm.h`
        $cppstdin $cppflags $cppminus < $xxx > shmat.c 2>/dev/null
        if $contains 'shmat.*(' shmat.c >/dev/null 2>&1; then
                val="$define"
        else
                val="$undef"
        fi
        $rm -f shmat.[co]
        ;;
*)
        val="$undef"
        ;;
esac
set d_shmatprototype
eval $setvar

: see if shmdt exists
set shmdt d_shmdt
eval $inlibc

: see how much of the 'shm*(2)' library is present.
h_shm=true
echo " "
case "$d_shmctl$d_shmget$d_shmat$d_shmdt" in
*"$undef"*) h_shm=false;;
esac
case "$osname" in
freebsd)
    case "`ipcs 2>&1`" in
    "SVID shared memory"*"not configured"*)
        echo "Your $osname does not have the shm*(2) configured." >&4
        h_shm=false
        val="$undef"
        set shmctl d_shmctl
        evat $setvar
        set shmget d_shmget
        evat $setvar
        set shmat d_shmat
        evat $setvar
        set shmdt d_shmdt
        evat $setvar
        ;;
    esac
    ;;
esac
: we could also check for sys/ipc.h ...
if $h_shm && $test `./findhdr sys/shm.h`; then
        echo "You have the full shm*(2) library." >&4
        val="$define"
else
        echo "You don't have the full shm*(2) library." >&4
        val="$undef"
fi
set d_shm
eval $setvar

echo " "
: see if we have sigaction
if set sigaction val -f d_sigaction; eval $csym; $val; then
        echo 'sigaction() found.' >&4
        $cat > try.c <<EOP
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main()
{
    struct sigaction act, oact;
    act.sa_flags = 0;
    oact.sa_handler = 0;
    /* so that act and oact are used */
    exit(act.sa_flags == 0 &&  oact.sa_handler == 0);
}
EOP
        set try
        if eval $compile_ok; then
                val="$define"
        else
                echo "But you don't seem to have a useable struct sigaction." >&4
                val="$undef"
        fi
else
        echo 'sigaction NOT found.' >&4
        val="$undef"
fi
set d_sigaction; eval $setvar
$rm -f try try$_o try.c

: see if sigprocmask exists
set sigprocmask d_sigprocmask
eval $inlibc

: see if sigsetjmp exists
echo " "
case "$d_sigsetjmp" in
'')
        $cat >try.c <<EOP
#include <setjmp.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
sigjmp_buf env;
int set = 1;
int main()
{
        if (sigsetjmp(env,1))
                exit(set);
        set = 0;
        siglongjmp(env, 1);
        exit(1);
}
EOP
        set try
        if eval $compile; then
                if $run ./try >/dev/null 2>&1; then
                        echo "POSIX sigsetjmp found." >&4
                        val="$define"
                else
                        $cat >&4 <<EOM
Uh-Oh! You have POSIX sigsetjmp and siglongjmp, but they do not work properly!!
I'll ignore them.
EOM
                        val="$undef"
                fi
        else
                echo "sigsetjmp not found." >&4
                val="$undef"
        fi
        ;;
*) val="$d_sigsetjmp"
        case "$d_sigsetjmp" in
        $define) echo "POSIX sigsetjmp found." >&4;;
        $undef) echo "sigsetjmp not found." >&4;;
        esac
        ;;
esac
set d_sigsetjmp
eval $setvar
$rm -f try.c try

: see if sockatmark exists
set sockatmark d_sockatmark
eval $inlibc

: see if prototype for sockatmark is available
echo " "
set d_sockatmarkproto sockatmark $d_socket sys/socket.h
eval $hasproto

: see if socks5_init exists
set socks5_init d_socks5_init
eval $inlibc

: see if srand48_r exists
set srand48_r d_srand48_r
eval $inlibc
case "$d_srand48_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_stdlib stdlib.h"
        case "$d_srand48_r_proto:$usethreads" in
        ":define")      d_srand48_r_proto=define
                set d_srand48_r_proto srand48_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_srand48_r_proto" in
        define)
        case "$srand48_r_proto" in
        ''|0) try='int srand48_r(long, struct drand48_data*);'
        ./protochk "extern $try" $hdrs && srand48_r_proto=I_LS ;;
        esac
        case "$srand48_r_proto" in
        ''|0)   d_srand48_r=undef
                srand48_r_proto=0
                echo "Disabling srand48_r, cannot determine prototype." >&4 ;;
        * )     case "$srand48_r_proto" in
                REENTRANT_PROTO*) ;;
                *) srand48_r_proto="REENTRANT_PROTO_$srand48_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "srand48_r has no prototype, not using it." >&4 ;;
                esac
                d_srand48_r=undef
                srand48_r_proto=0
                ;;
        esac
        ;;
*)      srand48_r_proto=0
        ;;
esac

: see if srandom_r exists
set srandom_r d_srandom_r
eval $inlibc
case "$d_srandom_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_stdlib stdlib.h"
        case "$d_srandom_r_proto:$usethreads" in
        ":define")      d_srandom_r_proto=define
                set d_srandom_r_proto srandom_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_srandom_r_proto" in
        define)
        case "$srandom_r_proto" in
        ''|0) try='int srandom_r(unsigned int, struct random_data*);'
        ./protochk "extern $try" $hdrs && srandom_r_proto=I_TS ;;
        esac
        case "$srandom_r_proto" in
        ''|0)   d_srandom_r=undef
                srandom_r_proto=0
                echo "Disabling srandom_r, cannot determine prototype." >&4 ;;
        * )     case "$srandom_r_proto" in
                REENTRANT_PROTO*) ;;
                *) srandom_r_proto="REENTRANT_PROTO_$srandom_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "srandom_r has no prototype, not using it." >&4 ;;
                esac
                d_srandom_r=undef
                srandom_r_proto=0
                ;;
        esac
        ;;
*)      srandom_r_proto=0
        ;;
esac

: see if prototype for setresgid is available
echo " "
set d_sresgproto setresgid $i_unistd unistd.h
eval $hasproto

: see if prototype for setresuid is available
echo " "
set d_sresuproto setresuid $i_unistd unistd.h
eval $hasproto

: see if sys/stat.h is available
set sys/stat.h i_sysstat
eval $inhdr


: see if stat knows about block sizes
echo " "
echo "Checking to see if your struct stat has st_blocks field..." >&4
set d_statblks stat st_blocks $i_sysstat sys/stat.h
eval $hasfield


: see if this is a sys/vfs.h system
set sys/vfs.h i_sysvfs
eval $inhdr


: see if this is a sys/statfs.h system
set sys/statfs.h i_sysstatfs
eval $inhdr


echo " "
echo "Checking to see if your system supports struct statfs..." >&4
set d_statfs_s statfs $i_systypes sys/types.h $i_sysparam sys/param.h $i_sysmount sys/mount.h $i_sysvfs sys/vfs.h $i_sysstatfs sys/statfs.h
eval $hasstruct
case "$d_statfs_s" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac



: see if struct statfs knows about f_flags
case "$d_statfs_s" in
define)
        echo " "
        echo "Checking to see if your struct statfs has f_flags field..." >&4
        set d_statfs_f_flags statfs f_flags $i_systypes sys/types.h $i_sysparam sys/param.h $i_sysmount sys/mount.h $i_sysvfs sys/vfs.h $i_sysstatfs sys/statfs.h
        eval $hasfield
        ;;
*)      val="$undef"
        set d_statfs_f_flags
        eval $setvar
        ;;
esac
case "$d_statfs_f_flags" in
"$define")      echo "Yes, it does."   ;;
*)              echo "No, it doesn't." ;;
esac

$cat >&4 <<EOM
Checking how to access stdio streams by file descriptor number...
EOM
case "$stdio_stream_array" in
'')     $cat >try.c <<EOCP
#include <stdio.h>
int main() {
  if (&STDIO_STREAM_ARRAY[fileno(stdin)] == stdin)
    printf("yes\n");
}
EOCP
        for s in _iob __iob __sF
        do
                set try -DSTDIO_STREAM_ARRAY=$s
                if eval $compile; then
                        case "`$run ./try`" in
                        yes)    stdio_stream_array=$s; break ;;
                        esac
                fi
        done
        $rm -f try.* try$exe_ext
esac
case "$stdio_stream_array" in
'')     $cat >&4 <<EOM
I can't figure out how to access stdio streams by file descriptor number.
EOM
        d_stdio_stream_array="$undef"
        ;;
*)      $cat >&4 <<EOM
You can access stdio streams by file descriptor number by the $stdio_stream_array array.
EOM
        d_stdio_stream_array="$define"
        ;;
esac

: see if strcoll exists
set strcoll d_strcoll
eval $inlibc

: check for structure copying
echo " "
echo "Checking to see if your C compiler can copy structs..." >&4
$cat >try.c <<'EOCP'
int main()
{
        struct blurfl {
                int dyick;
        } foo, bar;

        foo = bar;
}
EOCP
if $cc -c try.c >/dev/null 2>&1 ; then
        val="$define"
        echo "Yup, it can."
else
        val="$undef"
        echo "Nope, it can't."
fi
set d_strctcpy
eval $setvar
$rm -f try.*

: see if strerror and/or sys_errlist[] exist
echo " "
if test "X$d_strerror" = X -o "X$d_syserrlst" = X; then
    if set strerror val -f d_strerror; eval $csym; $val; then
                echo 'strerror() found.' >&4
                d_strerror="$define"
                d_strerrm='strerror(e)'
                if set sys_errlist val -a d_syserrlst; eval $csym; $val; then
                        echo "(You also have sys_errlist[], so we could roll our own strerror.)"
                        d_syserrlst="$define"
                else
                        echo "(Since you don't have sys_errlist[], sterror() is welcome.)"
                        d_syserrlst="$undef"
                fi
    elif xxx=`./findhdr string.h`; test "$xxx" || xxx=`./findhdr strings.h`; \
                        $contains '#[   ]*define.*strerror' "$xxx" >/dev/null 2>&1; then
                echo 'strerror() found in string header.' >&4
                d_strerror="$define"
                d_strerrm='strerror(e)'
                if set sys_errlist val -a d_syserrlst; eval $csym; $val; then
                        echo "(Most probably, strerror() uses sys_errlist[] for descriptions.)"
                                d_syserrlst="$define"
                else
                        echo "(You don't appear to have any sys_errlist[], how can this be?)"
                        d_syserrlst="$undef"
                fi
    elif set sys_errlist val -a d_syserrlst; eval $csym; $val; then
                echo "strerror() not found, but you have sys_errlist[] so we'll use that." >&4
                d_strerror="$undef"
                d_syserrlst="$define"
                d_strerrm='((e)<0||(e)>=sys_nerr?"unknown":sys_errlist[e])'
    else
                echo 'strerror() and sys_errlist[] NOT found.' >&4
                d_strerror="$undef"
                d_syserrlst="$undef"
                d_strerrm='"unknown"'
    fi
fi

: see if strerror_r exists
set strerror_r d_strerror_r
eval $inlibc
case "$d_strerror_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_string string.h"
        case "$d_strerror_r_proto:$usethreads" in
        ":define")      d_strerror_r_proto=define
                set d_strerror_r_proto strerror_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_strerror_r_proto" in
        define)
        case "$strerror_r_proto" in
        ''|0) try='int strerror_r(int, char*, size_t);'
        ./protochk "extern $try" $hdrs && strerror_r_proto=I_IBW ;;
        esac
        case "$strerror_r_proto" in
        ''|0) try='int strerror_r(int, char*, int);'
        ./protochk "extern $try" $hdrs && strerror_r_proto=I_IBI ;;
        esac
        case "$strerror_r_proto" in
        ''|0) try='char* strerror_r(int, char*, size_t);'
        ./protochk "extern $try" $hdrs && strerror_r_proto=B_IBW ;;
        esac
        case "$strerror_r_proto" in
        ''|0)   d_strerror_r=undef
                strerror_r_proto=0
                echo "Disabling strerror_r, cannot determine prototype." >&4 ;;
        * )     case "$strerror_r_proto" in
                REENTRANT_PROTO*) ;;
                *) strerror_r_proto="REENTRANT_PROTO_$strerror_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "strerror_r has no prototype, not using it." >&4 ;;
                esac
                d_strerror_r=undef
                strerror_r_proto=0
                ;;
        esac
        ;;
*)      strerror_r_proto=0
        ;;
esac

: see if strftime exists
set strftime d_strftime
eval $inlibc

: see if strtod exists
set strtod d_strtod
eval $inlibc

: see if strtol exists
set strtol d_strtol
eval $inlibc

: see if strtold exists
set strtold d_strtold
eval $inlibc

: see if strtoll exists
set strtoll d_strtoll
eval $inlibc

case "$d_longlong-$d_strtoll" in
"$define-$define")
        $cat <<EOM
Checking whether your strtoll() works okay...
EOM
        $cat >try.c <<'EOCP'
#include <errno.h>
#ifdef __hpux
#define strtoll __strtoll
#endif
#ifdef __EMX__
#define strtoll _strtoll
#endif
#include <stdio.h>
extern long long int strtoll(char *s, char **, int);
static int bad = 0;
int check(char *s, long long ell, int een) {
        long long gll;
        errno = 0;
        gll = strtoll(s, 0, 10);
        if (!((gll == ell) && (errno == een)))
                bad++;
}
int main() {
        check(" 1",                                      1LL, 0);
        check(" 0",                                      0LL, 0);
        check("-1",                                     -1LL, 0);
        check("-9223372036854775808", -9223372036854775808LL, 0);
        check("-9223372036854775808", -9223372036854775808LL, 0);
        check(" 9223372036854775807",  9223372036854775807LL, 0);
        check("-9223372036854775808", -9223372036854775808LL, 0);
        check(" 9223372036854775808",  9223372036854775807LL, ERANGE);
        check("-9223372036854775809", -9223372036854775808LL, ERANGE);
        if (!bad)
                printf("ok\n");
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                ok) echo "Your strtoll() seems to be working okay." ;;
                *) cat <<EOM >&4
Your strtoll() doesn't seem to be working okay.
EOM
                   d_strtoll="$undef"
                   ;;
                esac
        else
                echo "(I can't seem to compile the test program--assuming it doesn't)"
                d_strtoll="$undef"
        fi
        ;;
esac

: see if strtoq exists
set strtoq d_strtoq
eval $inlibc

: see if strtoul exists
set strtoul d_strtoul
eval $inlibc

case "$d_strtoul" in
"$define")
        $cat <<EOM
Checking whether your strtoul() works okay...
EOM
        $cat >try.c <<'EOCP'
#include <errno.h>
#include <stdio.h>
extern unsigned long int strtoul(char *s, char **, int);
static int bad = 0;
void check(char *s, unsigned long eul, int een) {
        unsigned long gul;
        errno = 0;
        gul = strtoul(s, 0, 10);
        if (!((gul == eul) && (errno == een)))
                bad++;
}
int main() {
        check(" 1", 1L, 0);
        check(" 0", 0L, 0);
EOCP
        case "$longsize" in
        8)
            $cat >>try.c <<'EOCP'
        check("18446744073709551615", 18446744073709551615UL, 0);
        check("18446744073709551616", 18446744073709551615UL, ERANGE);
#if 0 /* strtoul() for /^-/ strings is undefined. */
        check("-1", 18446744073709551615UL, 0);
        check("-18446744073709551614", 2, 0);
        check("-18446744073709551615", 1, 0);
        check("-18446744073709551616", 18446744073709551615UL, ERANGE);
        check("-18446744073709551617", 18446744073709551615UL, ERANGE);
#endif
EOCP
                ;;
        4)
                    $cat >>try.c <<'EOCP'
        check("4294967295", 4294967295UL, 0);
        check("4294967296", 4294967295UL, ERANGE);
#if 0 /* strtoul() for /^-/ strings is undefined. */
        check("-1", 4294967295UL, 0);
        check("-4294967294", 2, 0);
        check("-4294967295", 1, 0);
        check("-4294967296", 4294967295UL, ERANGE);
        check("-4294967297", 4294967295UL, ERANGE);
#endif
EOCP
                ;;
        *)
: Should we write these tests to be more portable by sprintf-ing
: ~0 and then manipulating that char string as input for strtol?
                ;;
        esac
        $cat >>try.c <<'EOCP'
        if (!bad)
                printf("ok\n");
        return 0;
}
EOCP
        set try
        if eval $compile; then
                case "`$run ./try`" in
                ok) echo "Your strtoul() seems to be working okay." ;;
                *) cat <<EOM >&4
Your strtoul() doesn't seem to be working okay.
EOM
                   d_strtoul="$undef"
                   ;;
                esac
        fi
        ;;
esac

: see if strtoull exists
set strtoull d_strtoull
eval $inlibc

case "$d_longlong-$d_strtoull" in
"$define-$define")
        $cat <<EOM
Checking whether your strtoull() works okay...
EOM
        $cat >try.c <<'EOCP'
#include <errno.h>
#ifdef __hpux
#define strtoull __strtoull
#endif
#include <stdio.h>
extern unsigned long long int strtoull(char *s, char **, int);
static int bad = 0;
int check(char *s, long long eull, int een) {
        long long gull;
        errno = 0;
        gull = strtoull(s, 0, 10);
        if (!((gull == eull) && (errno == een)))
                bad++;
}
int main() {
        check(" 1",                                        1LL, 0);
        check(" 0",                                        0LL, 0);
        check("18446744073709551615",  18446744073709551615ULL, 0);
        check("18446744073709551616",  18446744073709551615ULL, ERANGE);
#if 0 /* strtoull() for /^-/ strings is undefined. */
        check("-1",                    18446744073709551615ULL, 0);
        check("-18446744073709551614",                     2LL, 0);
        check("-18446744073709551615",                     1LL, 0);
        check("-18446744073709551616", 18446744073709551615ULL, ERANGE);
        check("-18446744073709551617", 18446744073709551615ULL, ERANGE);
#endif
        if (!bad)
                printf("ok\n");
}
EOCP
        set try
        if eval $compile; then
                case "`$run ./try`" in
                ok) echo "Your strtoull() seems to be working okay." ;;
                *) cat <<EOM >&4
Your strtoull() doesn't seem to be working okay.
EOM
                   d_strtoull="$undef"
                   ;;
                esac
        fi
        ;;
esac

: see if strtouq exists
set strtouq d_strtouq
eval $inlibc

case "$d_strtouq" in
"$define")
        $cat <<EOM
Checking whether your strtouq() works okay...
EOM
        $cat >try.c <<'EOCP'
#include <errno.h>
#include <stdio.h>
extern unsigned long long int strtouq(char *s, char **, int);
static int bad = 0;
void check(char *s, unsigned long long eull, int een) {
        unsigned long long gull;
        errno = 0;
        gull = strtouq(s, 0, 10);
        if (!((gull == eull) && (errno == een)))
                bad++;
}
int main() {
        check(" 1",                                        1LL, 0);
        check(" 0",                                        0LL, 0);
        check("18446744073709551615",  18446744073709551615ULL, 0);
        check("18446744073709551616",  18446744073709551615ULL, ERANGE);
#if 0 /* strtouq() for /^-/ strings is undefined. */
        check("-1",                    18446744073709551615ULL, 0);
        check("-18446744073709551614",                     2LL, 0);
        check("-18446744073709551615",                     1LL, 0);
        check("-18446744073709551616", 18446744073709551615ULL, ERANGE);
        check("-18446744073709551617", 18446744073709551615ULL, ERANGE);
#endif
        if (!bad)
                printf("ok\n");
        return 0;
}
EOCP
        set try
        if eval $compile; then
                case "`$run ./try`" in
                ok) echo "Your strtouq() seems to be working okay." ;;
                *) cat <<EOM >&4
Your strtouq() doesn't seem to be working okay.
EOM
                   d_strtouq="$undef"
                   ;;
                esac
        fi
        ;;
esac

: see if strxfrm exists
set strxfrm d_strxfrm
eval $inlibc

: see if symlink exists
set symlink d_symlink
eval $inlibc

: see if syscall exists
set syscall d_syscall
eval $inlibc

: see if prototype for syscall is available
echo " "
set d_syscallproto syscall $i_unistd unistd.h
eval $hasproto

: see if sysconf exists
set sysconf d_sysconf
eval $inlibc

: see if system exists
set system d_system
eval $inlibc

: see if tcgetpgrp exists
set tcgetpgrp d_tcgetpgrp
eval $inlibc

: see if tcsetpgrp exists
set tcsetpgrp d_tcsetpgrp
eval $inlibc

: see if prototype for telldir is available
echo " "
set d_telldirproto telldir $i_systypes sys/types.h $i_dirent dirent.h
eval $hasproto

: see if time exists
echo " "
if test "X$d_time" = X -o X"$timetype" = X; then
    if set time val -f d_time; eval $csym; $val; then
                echo 'time() found.' >&4
                val="$define"
                rp="What is the type returned by time() on this system?"
                set time_t timetype long stdio.h sys/types.h
                eval $typedef_ask
    else
                echo 'time() not found, hope that will do.' >&4
                val="$undef"
                timetype='int';
    fi
    set d_time
    eval $setvar
fi

: see if this is a sys/times.h system
set sys/times.h i_systimes
eval $inhdr

: see if times exists
echo " "
if set times val -f d_times; eval $csym; $val; then
        echo 'times() found.' >&4
        d_times="$define"
        inc=''
        case "$i_systimes" in
        "$define") inc='sys/times.h';;
        esac
        rp="What is the type returned by times() on this system?"
        set clock_t clocktype long stdio.h sys/types.h $inc
        eval $typedef_ask
else
        echo 'times() NOT found, hope that will do.' >&4
        d_times="$undef"
        clocktype='int'
fi

: see if tmpnam_r exists
set tmpnam_r d_tmpnam_r
eval $inlibc
case "$d_tmpnam_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h "
        case "$d_tmpnam_r_proto:$usethreads" in
        ":define")      d_tmpnam_r_proto=define
                set d_tmpnam_r_proto tmpnam_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_tmpnam_r_proto" in
        define)
        case "$tmpnam_r_proto" in
        ''|0) try='char* tmpnam_r(char*);'
        ./protochk "extern $try" $hdrs && tmpnam_r_proto=B_B ;;
        esac
        case "$tmpnam_r_proto" in
        ''|0)   d_tmpnam_r=undef
                tmpnam_r_proto=0
                echo "Disabling tmpnam_r, cannot determine prototype." >&4 ;;
        * )     case "$tmpnam_r_proto" in
                REENTRANT_PROTO*) ;;
                *) tmpnam_r_proto="REENTRANT_PROTO_$tmpnam_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "tmpnam_r has no prototype, not using it." >&4 ;;
                esac
                d_tmpnam_r=undef
                tmpnam_r_proto=0
                ;;
        esac
        ;;
*)      tmpnam_r_proto=0
        ;;
esac

: see if truncate exists
set truncate d_truncate
eval $inlibc

: see if ttyname_r exists
set ttyname_r d_ttyname_r
eval $inlibc
case "$d_ttyname_r" in
"$define")
        hdrs="$i_systypes sys/types.h define stdio.h $i_unistd unistd.h"
        case "$d_ttyname_r_proto:$usethreads" in
        ":define")      d_ttyname_r_proto=define
                set d_ttyname_r_proto ttyname_r $hdrs
                eval $hasproto ;;
        *)      ;;
        esac
        case "$d_ttyname_r_proto" in
        define)
        case "$ttyname_r_proto" in
        ''|0) try='int ttyname_r(int, char*, size_t);'
        ./protochk "extern $try" $hdrs && ttyname_r_proto=I_IBW ;;
        esac
        case "$ttyname_r_proto" in
        ''|0) try='int ttyname_r(int, char*, int);'
        ./protochk "extern $try" $hdrs && ttyname_r_proto=I_IBI ;;
        esac
        case "$ttyname_r_proto" in
        ''|0) try='char* ttyname_r(int, char*, int);'
        ./protochk "extern $try" $hdrs && ttyname_r_proto=B_IBI ;;
        esac
        case "$ttyname_r_proto" in
        ''|0)   d_ttyname_r=undef
                ttyname_r_proto=0
                echo "Disabling ttyname_r, cannot determine prototype." >&4 ;;
        * )     case "$ttyname_r_proto" in
                REENTRANT_PROTO*) ;;
                *) ttyname_r_proto="REENTRANT_PROTO_$ttyname_r_proto" ;;
                esac
                echo "Prototype: $try" ;;
        esac
        ;;
        *)      case "$usethreads" in
                define) echo "ttyname_r has no prototype, not using it." >&4 ;;
                esac
                d_ttyname_r=undef
                ttyname_r_proto=0
                ;;
        esac
        ;;
*)      ttyname_r_proto=0
        ;;
esac

: see if tzname[] exists
echo " "
if set tzname val -a d_tzname; eval $csym; $val; then
        val="$define"
        echo 'tzname[] found.' >&4
else
        val="$undef"
        echo 'tzname[] NOT found.' >&4
fi
set d_tzname
eval $setvar

case "$osname" in
next|rhapsody|darwin) multiarch="$define" ;;
esac
case "$multiarch" in
''|[nN]*) multiarch="$undef" ;;
esac

: check for ordering of bytes in a UV
echo " "
case "$usecrosscompile$multiarch" in
*$define*)
        $cat <<EOM
You seem to be either cross-compiling or doing a multiarchitecture build,
skipping the byteorder check.

EOM
        byteorder='ffff'
        ;;
*)
        case "$byteorder" in
        '')
                $cat <<'EOM'
In the following, larger digits indicate more significance.  A big-endian
machine like a Pyramid or a Motorola 680?0 chip will come out to 4321. A
little-endian machine like a Vax or an Intel 80?86 chip would be 1234. Other
machines may have weird orders like 3412.  A Cray will report 87654321,
an Alpha will report 12345678. If the test program works the default is
probably right.
I'm now running the test program...
EOM
                $cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <sys/types.h>
typedef $uvtype UV;
int main()
{
        int i;
        union {
                UV l;
                char c[$uvsize];
        } u;

        if ($uvsize > 4)
                u.l = (((UV)0x08070605) << 32) | (UV)0x04030201;
        else
                u.l = (UV)0x04030201;
        for (i = 0; i < $uvsize; i++)
                printf("%c", u.c[i]+'0');
        printf("\n");
        exit(0);
}
EOCP
                xxx_prompt=y
                set try
                if eval $compile && ./try > /dev/null; then
                        dflt=`$run ./try`
                        case "$dflt" in
                        [1-4][1-4][1-4][1-4]|12345678|87654321)
                                echo "(The test program ran ok.)"
                                echo "byteorder=$dflt"
                                xxx_prompt=n
                        ;;
                        ????|????????) echo "(The test program ran ok.)" ;;
                        *) echo "(The test program didn't run right for some reason.)" ;;
                        esac
                else
                        dflt='4321'
                        cat <<'EOM'
(I can't seem to compile the test program.  Guessing big-endian...)
EOM
                fi
                case "$xxx_prompt" in
                y)
                        rp="What is the order of bytes in $uvtype?"
                        . ./myread
                        byteorder="$ans"
                        ;;
                *)      byteorder=$dflt
                        ;;
                esac
                ;;
        esac
        $rm -f try.c try
        ;;
esac


$cat <<EOM

Checking to see whether you can access character data unalignedly...
EOM
case "$d_u32align" in
'')   $cat >try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#define U32 $u32type
#define BYTEORDER 0x$byteorder
#define U8 $u8type
#include <signal.h>
#ifdef SIGBUS
$signal_t bletch(s) int s; { exit(4); }
#endif
int main() {
#if BYTEORDER == 0x1234 || BYTEORDER == 0x4321
    U8 buf[8];
    U32 *up;
    int i;

    if (sizeof(U32) != 4) {
        printf("sizeof(U32) is not 4, but %d\n", sizeof(U32));
        exit(1);
    }

    fflush(stdout);

#ifdef SIGBUS
    signal(SIGBUS, bletch);
#endif

    buf[0] = 0;
    buf[1] = 0;
    buf[2] = 0;
    buf[3] = 1;
    buf[4] = 0;
    buf[5] = 0;
    buf[6] = 0;
    buf[7] = 1;

    for (i = 0; i < 4; i++) {
        up = (U32*)(buf + i);
        if (! ((*up == 1 << (8*i)) ||   /* big-endian */
               (*up == 1 << (8*(3-i)))  /* little-endian */
              )
           )
        {
            printf("read failed (%x)\n", *up);
            exit(2);
        }
    }

    /* write test */
    for (i = 0; i < 4; i++) {
        up = (U32*)(buf + i);
        *up = 0xBeef;
        if (*up != 0xBeef) {
            printf("write failed (%x)\n", *up);
            exit(3);
        }
    }

    exit(0);
#else
    printf("1\n");
    exit(1);
#endif
    return 0;
}
EOCP
set try
if eval $compile_ok; then
        echo "(Testing for character data alignment may crash the test.  That's okay.)" >&4
        $run ./try 2>&1 >/dev/null
        case "$?" in
        0)      cat >&4 <<EOM
You can access character data pretty unalignedly.
EOM
                d_u32align="$undef"
                ;;
        *)      cat >&4 <<EOM
It seems that you must access character data in an aligned manner.
EOM
                d_u32align="$define"
                ;;
        esac
else
        rp='Can you access character data at unaligned addresses?'
        dflt='n'
        . ./myread
        case "$ans" in
        [yY]*)  d_u32align="$undef"  ;;
        *)      d_u32align="$define" ;;
        esac
fi
$rm -f core core.try.* try.core
;;
esac

: see if ualarm exists
set ualarm d_ualarm
eval $inlibc

: see if umask exists
set umask d_umask
eval $inlibc

: see if unordered exists
set unordered d_unordered
eval $inlibc

: see if usleep exists
set usleep d_usleep
eval $inlibc

: see if prototype for usleep is available
echo " "
set d_usleepproto usleep $i_unistd unistd.h
eval $hasproto

: see if ustat exists
set ustat d_ustat
eval $inlibc

: backward compatibility for d_hvfork
if test X$d_hvfork != X; then
        d_vfork="$d_hvfork"
        d_hvfork=''
fi
: see if there is a vfork
val=''
set vfork val
eval $inlibc

: Ok, but do we want to use it. vfork is reportedly unreliable in
: perl on Solaris 2.x, and probably elsewhere.
case "$val" in
$define)
        echo " "
        case "$usevfork" in
        false) dflt='n';;
        *) dflt='y';;
        esac
        cat <<'EOM'

Perl can only use a vfork() that doesn't suffer from strict
restrictions on calling functions or modifying global data in
the child.  For example, glibc-2.1 contains such a vfork()
that is unsuitable.  If your system provides a proper fork()
call, chances are that you do NOT want perl to use vfork().

EOM
        rp="Do you still want to use vfork()?"
        . ./myread
        case "$ans" in
        y|Y) ;;
        *)
                echo "Ok, we won't use vfork()."
                val="$undef"
                ;;
        esac
        ;;
esac
set d_vfork
eval $setvar
case "$d_vfork" in
$define) usevfork='true';;
*) usevfork='false';;
esac

: see if closedir exists
set closedir d_closedir
eval $inlibc

case "$d_closedir" in
"$define")
        echo " "
        echo "Checking whether closedir() returns a status..." >&4
        cat > try.c <<EOM
#$i_dirent I_DIRENT             /**/
#$i_sysdir I_SYS_DIR            /**/
#$i_sysndir I_SYS_NDIR          /**/
#$i_systypes I_SYS_TYPES        /**/

#if defined(I_SYS_TYPES)
#include <sys/types.h>
#endif
#if defined(I_DIRENT)
#include <dirent.h>
#if defined(NeXT) && defined(I_SYS_DIR) /* NeXT needs dirent + sys/dir.h */
#include <sys/dir.h>
#endif
#else
#ifdef I_SYS_NDIR
#include <sys/ndir.h>
#else
#ifdef I_SYS_DIR
#ifdef hp9000s500
#include <ndir.h>       /* may be wrong in the future */
#else
#include <sys/dir.h>
#endif
#endif
#endif
#endif
int main() { return closedir(opendir(".")); }
EOM
        set try
        if eval $compile_ok; then
                if $run ./try > /dev/null 2>&1 ; then
                        echo "Yes, it does."
                        val="$undef"
                else
                        echo "No, it doesn't."
                        val="$define"
                fi
        else
                echo "(I can't seem to compile the test program--assuming it doesn't)"
                val="$define"
        fi
        ;;
*)
        val="$undef";
        ;;
esac
set d_void_closedir
eval $setvar
$rm -f try try.*
: see if there is a wait4
set wait4 d_wait4
eval $inlibc

: see if waitpid exists
set waitpid d_waitpid
eval $inlibc

: see if wcstombs exists
set wcstombs d_wcstombs
eval $inlibc

: see if wctomb exists
set wctomb d_wctomb
eval $inlibc

: see if writev exists
set writev d_writev
eval $inlibc

: preserve RCS keywords in files with variable substitution, grrr
Date='$Date'
Id='$Id'
Log='$Log'
RCSfile='$RCSfile'
Revision='$Revision'

: check for alignment requirements
echo " "
case "$usecrosscompile$multiarch" in
*$define*)
        $cat <<EOM
You seem to be either cross-compiling or doing a multiarchitecture build,
skipping the memory alignment check.

EOM
        case "$alignbytes" in
        '') alignbytes=8 ;;
        esac
        ;;
*)
        case "$alignbytes" in
        '') echo "Checking alignment constraints..." >&4
                if $test "X$uselongdouble" = Xdefine -a "X$d_longdbl" = Xdefine; then
                        $cat >try.c <<'EOCP'
typedef long double NV;
EOCP
                else
                        $cat >try.c <<'EOCP'
typedef double NV;
EOCP
                fi
                $cat >>try.c <<'EOCP'
#include <stdio.h>
struct foobar {
        char foo;
        NV bar;
} try_algn;
int main()
{
    printf("%d\n", (int)((char *)&try_algn.bar - (char *)&try_algn.foo));
    return(0);
}
EOCP
                set try
                if eval $compile_ok; then
                        dflt=`$run ./try`
                else
                        dflt='8'
                        echo "(I can't seem to compile the test program...)"
                fi
                ;;
        *) dflt="$alignbytes"
                ;;
        esac
        rp="Doubles must be aligned on a how-many-byte boundary?"
        . ./myread
        alignbytes="$ans"
        $rm -f try.c try
        ;;
esac


: set the base revision
baserev=5.0

: how do we concatenate cpp tokens here?
echo " "
echo "Checking to see how your cpp does stuff like concatenate tokens..." >&4
$cat >cpp_stuff.c <<'EOCP'
#define RCAT(a,b)a/**/b
#define ACAT(a,b)a ## b
RCAT(Rei,ser)
ACAT(Cir,cus)
EOCP
$cppstdin $cppflags $cppminus <cpp_stuff.c >cpp_stuff.out 2>&1
if $contains 'Circus' cpp_stuff.out >/dev/null 2>&1; then
        echo "Oh!  Smells like ANSI's been here." >&4
        echo "We can catify or stringify, separately or together!"
        cpp_stuff=42
elif $contains 'Reiser' cpp_stuff.out >/dev/null 2>&1; then
        echo "Ah, yes!  The good old days!" >&4
        echo "However, in the good old days we don't know how to stringify and"
        echo "catify at the same time."
        cpp_stuff=1
else
        $cat >&4 <<EOM
Hmm, I don't seem to be able to concatenate tokens with your cpp.
You're going to have to edit the values of CAT[2-5] in config.h...
EOM
        cpp_stuff="/* Help! How do we handle cpp_stuff? */*/"
fi
$rm -f cpp_stuff.*

: see if this is a db.h system
set db.h i_db
eval $inhdr

case "$i_db" in
$define)
        : Check db version.
        echo " "
        echo "Checking Berkeley DB version ..." >&4
        $cat >try.c <<EOCP
#$d_const HASCONST
#ifndef HASCONST
#define const
#endif
#include <sys/types.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <db.h>
int main(int argc, char *argv[])
{
#ifdef DB_VERSION_MAJOR /* DB version >= 2 */
    int Major, Minor, Patch ;
    unsigned long Version ;
    (void)db_version(&Major, &Minor, &Patch) ;
    if (argc == 2) {
        printf("%d %d %d %d %d %d\n",
               DB_VERSION_MAJOR, DB_VERSION_MINOR, DB_VERSION_PATCH,
               Major, Minor, Patch);
        exit(0);
    }
    printf("You have Berkeley DB Version 2 or greater.\n");

    printf("db.h is from Berkeley DB Version %d.%d.%d\n",
                DB_VERSION_MAJOR, DB_VERSION_MINOR, DB_VERSION_PATCH);
    printf("libdb is from Berkeley DB Version %d.%d.%d\n",
                Major, Minor, Patch) ;

    /* check that db.h & libdb are compatible */
    if (DB_VERSION_MAJOR != Major || DB_VERSION_MINOR != Minor || DB_VERSION_PATCH != Patch) {
        printf("db.h and libdb are incompatible.\n") ;
        exit(3);
    }

    printf("db.h and libdb are compatible.\n") ;

    Version = DB_VERSION_MAJOR * 1000000 + DB_VERSION_MINOR * 1000
                + DB_VERSION_PATCH ;

    /* needs to be >= 2.3.4 */
    if (Version < 2003004) {
    /* if (DB_VERSION_MAJOR == 2 && DB_VERSION_MINOR == 0 && DB_VERSION_PATCH < 5) { */
        printf("Perl needs Berkeley DB 2.3.4 or greater.\n") ;
        exit(2);
    }

    exit(0);
#else
#if defined(_DB_H_) && defined(BTREEMAGIC) && defined(HASHMAGIC)
    if (argc == 2) {
        printf("1 0 0\n");
        exit(0);
    }
    printf("You have Berkeley DB Version 1.\n");
    exit(0);    /* DB version < 2: the coast is clear. */
#else
    exit(1);    /* <db.h> not Berkeley DB? */
#endif
#endif
}
EOCP
        set try
        if eval $compile_ok && $run ./try; then
                echo 'Looks OK.' >&4
                set `$run ./try 1`
                db_version_major=$1
                db_version_minor=$2
                db_version_patch=$3
        else
                echo "I can't use Berkeley DB with your <db.h>.  I'll disable Berkeley DB." >&4
                i_db=$undef
                case " $libs " in
                *"-ldb "*)
                        : Remove db from list of libraries to use
                        echo "Removing unusable -ldb from library list" >&4
                        set `echo X $libs | $sed -e 's/-ldb / /' -e 's/-ldb$//'`
                        shift
                        libs="$*"
                        echo "libs = $libs" >&4
                        ;;
                esac
        fi
        $rm -f try.*
        ;;
esac

case "$i_db" in
define)
        : Check the return type needed for hash
        echo " "
        echo "Checking return type needed for hash for Berkeley DB ..." >&4
        $cat >try.c <<EOCP
#$d_const HASCONST
#ifndef HASCONST
#define const
#endif
#include <sys/types.h>
#include <db.h>

#ifndef DB_VERSION_MAJOR
u_int32_t hash_cb (ptr, size)
const void *ptr;
size_t size;
{
}
HASHINFO info;
int main()
{
        info.hash = hash_cb;
}
#endif
EOCP
        if $cc $ccflags -c try.c >try.out 2>&1 ; then
                if $contains warning try.out >>/dev/null 2>&1 ; then
                        db_hashtype='int'
                else
                        db_hashtype='u_int32_t'
                fi
        else
                : XXX Maybe we should just give up here.
                db_hashtype=u_int32_t
                $cat try.out >&4
                echo "Help:  I can't seem to compile the db test program." >&4
                echo "Something's wrong, but I'll assume you use $db_hashtype." >&4
        fi
        $rm -f try.*
        echo "Your version of Berkeley DB uses $db_hashtype for hash."
        ;;
*)      db_hashtype=u_int32_t
        ;;
esac
case "$i_db" in
define)
        : Check the return type needed for prefix
        echo " "
        echo "Checking return type needed for prefix for Berkeley DB ..." >&4
        cat >try.c <<EOCP
#$d_const HASCONST
#ifndef HASCONST
#define const
#endif
#include <sys/types.h>
#include <db.h>

#ifndef DB_VERSION_MAJOR
size_t prefix_cb (key1, key2)
const DBT *key1;
const DBT *key2;
{
}
BTREEINFO info;
int main()
{
        info.prefix = prefix_cb;
}
#endif
EOCP
        if $cc $ccflags -c try.c  >try.out 2>&1 ; then
                if $contains warning try.out >>/dev/null 2>&1 ; then
                        db_prefixtype='int'
                else
                        db_prefixtype='size_t'
                fi
        else
                db_prefixtype='size_t'
                : XXX Maybe we should just give up here.
                $cat try.out >&4
                echo "Help:  I can't seem to compile the db test program." >&4
                echo "Something's wrong, but I'll assume you use $db_prefixtype." >&4
        fi
        $rm -f try.*
        echo "Your version of Berkeley DB uses $db_prefixtype for prefix."
        ;;
*)      db_prefixtype='size_t'
        ;;
esac


: How can we generate normalized random numbers ?
echo " "
echo "Looking for a random number function..." >&4
case "$randfunc" in
'')
        if set drand48 val -f; eval $csym; $val; then
                dflt="drand48"
                echo "Good, found drand48()." >&4
        elif set random val -f; eval $csym; $val; then
                dflt="random"
                echo "OK, found random()." >&4
        else
                dflt="rand"
                echo "Yick, looks like I have to use rand()." >&4
        fi
        echo " "
        ;;
*)
        dflt="$randfunc"
        ;;
esac
cont=true

case "$ccflags" in
*-Dmy_rand=*|*-Dmy_srand=*)
        echo "Removing obsolete -Dmy_rand, -Dmy_srand, and -Drandbits from ccflags." >&4
        ccflags="`echo $ccflags | sed -e 's/-Dmy_rand=random/ /'`"
        ccflags="`echo $ccflags | sed -e 's/-Dmy_srand=srandom/ /'`"
        ccflags="`echo $ccflags | sed -e 's/-Drandbits=[0-9][0-9]*/ /'`"
        ;;
esac

while $test "$cont"; do
        rp="Use which function to generate random numbers?"
        . ./myread
        if $test "$ans" = "$dflt"; then
                : null
        else
                randbits=''
        fi
        randfunc="$ans"
        if set $ans val -f; eval $csym; $val; then
                cont=''
        else
                dflt=y
                rp="I cannot find function $ans. Use that name anyway?"
                . ./myread
                dflt=rand
                case "$ans" in
                        [yY]*) cont='';;
                esac
        fi
        case "$cont" in
        '')
                case "$randfunc" in
                drand48)
                        drand01="drand48()"
                        seedfunc="srand48"
                        randbits=48
                        randseedtype=long
                        ;;
                rand|random)
                        case "$randbits" in
                        '')
echo "Checking to see how many bits your $randfunc() function produces..." >&4
                                $cat >try.c <<EOCP
#$i_unistd I_UNISTD
#$i_stdlib I_STDLIB
#include <stdio.h>
#ifdef I_UNISTD
#  include <unistd.h>
#endif
#ifdef I_STDLIB
#  include <stdlib.h>
#endif
int main()
{
        register int i;
        register unsigned long tmp;
        register unsigned long max = 0L;

        for (i = 1000; i; i--) {
                tmp = (unsigned long) $randfunc();
                if (tmp > max) max = tmp;
        }
        for (i = 0; max; i++)
                max /= 2;
        printf("%d\n",i);
}
EOCP
                                set try
                                if eval $compile_ok; then
                                        dflt=`try`
                                else
                                        dflt='?'
                                        echo "(I can't seem to compile the test program...)"
                                fi
                                ;;
                        *)
                                dflt="$randbits"
                                ;;
                        esac
                        rp="How many bits does your $randfunc() function produce?"
                        . ./myread
                        randbits="$ans"
                        $rm -f try.c try
                        drand01="($randfunc() / (double) ((unsigned long)1 << $randbits))"
                        seedfunc="s$randfunc"
                        randseedtype=unsigned
                        ;;
                *)
                        dflt="31"
                        rp="How many bits does your $randfunc() function produce?"
                        . ./myread
                        randbits="$ans"
                        seedfunc="s$randfunc"
                        drand01="($randfunc() / (double) ((unsigned long)1 << $randbits))"
                        if set $seedfunc val -f; eval $csym; $val; then
                                echo "(Using $seedfunc() to seed random generator)"
                        else
                                echo "(Warning: no $seedfunc() to seed random generator)"
                                seedfunc=rand
                        fi
                        randseedtype=unsigned
                        ;;
                esac
                ;;
        esac
done

echo " "
echo "Determining whether or not we are on an EBCDIC system..." >&4
$cat >try.c <<'EOM'
int main()
{
  if ('M'==0xd4) return 0;
  return 1;
}
EOM

val=$undef
set try
if eval $compile_ok; then
        if $run ./try; then
                echo "You seem to speak EBCDIC." >&4
                val="$define"
        else
                echo "Nope, no EBCDIC, probably ASCII or some ISO Latin. Or UTF-8." >&4
        fi
else
        echo "I'm unable to compile the test program." >&4
        echo "I'll assume ASCII or some ISO Latin. Or UTF8." >&4
fi
$rm -f try try.*
set ebcdic
eval $setvar

echo " "
$cat >&4 <<EOM
Checking how to flush all pending stdio output...
EOM
# I only know how to find the first 32 possibly open files on SunOS.
# See also hints/sunos_4_1.sh and util.c  --AD
case "$osname" in
sunos) $echo '#define PERL_FFLUSH_ALL_FOPEN_MAX 32' > try.c ;;
esac
$cat >>try.c <<EOCP
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#$i_unistd I_UNISTD
#ifdef I_UNISTD
# include <unistd.h>
#endif
#$d_sysconf HAS_SYSCONF
#$d_stdio_stream_array HAS_STDIO_STREAM_ARRAY
#ifdef HAS_STDIO_STREAM_ARRAY
# define STDIO_STREAM_ARRAY $stdio_stream_array
#endif
int main() {
  FILE* p;
  unlink("try.out");
  p = fopen("try.out", "w");
#ifdef TRY_FPUTC
  fputc('x', p);
#else
# ifdef TRY_FPRINTF
  fprintf(p, "x");
# endif
#endif
#ifdef TRY_FFLUSH_NULL
  fflush(NULL);
#endif
#ifdef TRY_FFLUSH_ALL
  {
    long open_max = -1;
# ifdef PERL_FFLUSH_ALL_FOPEN_MAX
    open_max = PERL_FFLUSH_ALL_FOPEN_MAX;
# else
#  if defined(HAS_SYSCONF) && defined(_SC_OPEN_MAX)
    open_max = sysconf(_SC_OPEN_MAX);
#  else
#   ifdef FOPEN_MAX
    open_max = FOPEN_MAX;
#   else
#    ifdef OPEN_MAX
    open_max = OPEN_MAX;
#    else
#     ifdef _NFILE
    open_max = _NFILE;
#     endif
#    endif
#   endif
#  endif
# endif
# ifdef HAS_STDIO_STREAM_ARRAY
    if (open_max > 0) {
      long i;
      for (i = 0; i < open_max; i++)
            if (STDIO_STREAM_ARRAY[i]._file >= 0 &&
                STDIO_STREAM_ARRAY[i]._file < open_max &&
                STDIO_STREAM_ARRAY[i]._flag)
                fflush(&STDIO_STREAM_ARRAY[i]);
    }
  }
# endif
#endif
  _exit(42);
}
EOCP
: first we have to find out how _not_ to flush
$to try.c
if $test "X$fflushNULL" = X -o "X$fflushall" = X; then
    output=''
    set try -DTRY_FPUTC
    if eval $compile; then
            $run ./try 2>/dev/null
            code="$?"
            $from try.out
            if $test ! -s try.out -a "X$code" = X42; then
                output=-DTRY_FPUTC
            fi
    fi
    case "$output" in
    '')
            set try -DTRY_FPRINTF
            if eval $compile; then
                    $run ./try 2>/dev/null
                    code="$?"
                    $from try.out
                    if $test ! -s try.out -a "X$code" = X42; then
                        output=-DTRY_FPRINTF
                    fi
            fi
        ;;
    esac
fi
: check for fflush NULL behaviour
case "$fflushNULL" in
'')     set try -DTRY_FFLUSH_NULL $output
        if eval $compile; then
                $run ./try 2>/dev/null
                code="$?"
                $from try.out
                if $test -s try.out -a "X$code" = X42; then
                        fflushNULL="`$cat try.out`"
                else
                        if $test "X$code" != X42; then
                                $cat >&4 <<EOM
(If this test failed, don't worry, we'll try another method shortly.)
EOM
                        fi
                fi
        fi
        $rm -f core try.core core.try.*
        case "$fflushNULL" in
        x)      $cat >&4 <<EOM
Your fflush(NULL) works okay for output streams.
Let's see if it clobbers input pipes...
EOM
# As of mid-March 2000 all versions of Solaris appear to have a stdio
# bug that improperly flushes the input end of pipes.  So we avoid the
# autoflush on fork/system/exec support for now. :-(
$cat >tryp.c <<EOCP
#include <stdio.h>
int
main(int argc, char **argv)
{
    char buf[1024];
    int i;
    char *bp = buf;
    while (1) {
        while ((i = getc(stdin)) != -1
               && (*bp++ = i) != '\n'
               && bp < &buf[1024])
        /* DO NOTHING */ ;
        *bp = '\0';
        fprintf(stdout, "%s", buf);
        fflush(NULL);
        if (i == -1)
            return 0;
        bp = buf;
    }
}
EOCP
                fflushNULL="$define"
                set tryp
                if eval $compile; then
                    $rm -f tryp.out
                    $cat tryp.c | $run ./tryp 2>/dev/null > tryp.out
                    if cmp tryp.c tryp.out >/dev/null 2>&1; then
                       $cat >&4 <<EOM
fflush(NULL) seems to behave okay with input streams.
EOM
                        fflushNULL="$define"
                    else
                        $cat >&4 <<EOM
Ouch, fflush(NULL) clobbers input pipes!  We will not use it.
EOM
                        fflushNULL="$undef"
                    fi
                fi
                $rm -f core tryp.c tryp.core core.tryp.*
                ;;
        '')     $cat >&4 <<EOM
Your fflush(NULL) isn't working (contrary to ANSI C).
EOM
                fflushNULL="$undef"
                ;;
        *)      $cat >&4 <<EOM
Cannot figure out whether your fflush(NULL) works or not.
I'm assuming it doesn't (contrary to ANSI C).
EOM
                fflushNULL="$undef"
                ;;
        esac
        ;;
$define|true|[yY]*)
        fflushNULL="$define"
        ;;
*)
        fflushNULL="$undef"
        ;;
esac
: check explicit looping only if NULL did not work, and if the pipe
: bug does not show up on an explicit flush too
case "$fflushNULL" in
"$undef")
        $cat >tryp.c <<EOCP
#include <stdio.h>
int
main(int argc, char **argv)
{
    char buf[1024];
    int i;
    char *bp = buf;
    while (1) {
        while ((i = getc(stdin)) != -1
               && (*bp++ = i) != '\n'
               && bp < &buf[1024])
        /* DO NOTHING */ ;
        *bp = '\0';
        fprintf(stdout, "%s", buf);
        fflush(stdin);
        if (i == -1)
            return 0;
        bp = buf;
    }
}
EOCP
        set tryp
        if eval $compile; then
            $rm -f tryp.out
            $cat tryp.c | $run ./tryp 2>/dev/null > tryp.out
            if cmp tryp.c tryp.out >/dev/null 2>&1; then
               $cat >&4 <<EOM
Good, at least fflush(stdin) seems to behave okay when stdin is a pipe.
EOM
                : now check for fflushall behaviour
                case "$fflushall" in
                '')     set try -DTRY_FFLUSH_ALL $output
                        if eval $compile; then
                                $cat >&4 <<EOM
(Now testing the other method--but note that this also may fail.)
EOM
                                $run ./try 2>/dev/null
                                code=$?
                                $from try.out
                                if $test -s try.out -a "X$code" = X42; then
                                        fflushall="`$cat try.out`"
                                fi
                        fi
                        $rm -f core try.core core.try.*
                        case "$fflushall" in
                        x)      $cat >&4 <<EOM
Whew. Flushing explicitly all the stdio streams works.
EOM
                                fflushall="$define"
                                ;;
                        '')     $cat >&4 <<EOM
Sigh. Flushing explicitly all the stdio streams doesn't work.
EOM
                                fflushall="$undef"
                                ;;
                        *)      $cat >&4 <<EOM
Cannot figure out whether flushing stdio streams explicitly works or not.
I'm assuming it doesn't.
EOM
                                fflushall="$undef"
                                ;;
                        esac
                        ;;
                "$define"|true|[yY]*)
                        fflushall="$define"
                        ;;
                *)
                        fflushall="$undef"
                        ;;
                esac
            else
                $cat >&4 <<EOM
All is futile.  Even fflush(stdin) clobbers input pipes!
EOM
                fflushall="$undef"
            fi
        else
            fflushall="$undef"
        fi
        $rm -f core tryp.c tryp.core core.tryp.*
        ;;
*)      fflushall="$undef"
        ;;
esac

case "$fflushNULL$fflushall" in
undefundef)
        $cat <<EOM
OK, I give up.  I cannot figure out how to flush pending stdio output.
We won't be flushing handles at all before fork/exec/popen.
EOM
        ;;
esac
$rm -f try.* try$exe_ext

: Store the full pathname to the ar program for use in the C program
: Respect a hint or command line value for full_ar.
case "$full_ar" in
'') full_ar=$ar ;;
esac

: Store the full pathname to the sed program for use in the C program
full_sed=$sed

: see what type gids are declared as in the kernel
echo " "
echo "Looking for the type for group ids returned by getgid()."
set gid_t gidtype xxx stdio.h sys/types.h
eval $typedef
case "$gidtype" in
xxx)
        xxx=`./findhdr sys/user.h`
        set `grep 'groups\[NGROUPS\];' "$xxx" 2>/dev/null` unsigned short
        case $1 in
        unsigned) dflt="$1 $2" ;;
        *) dflt="$1" ;;
        esac
        ;;
*) dflt="$gidtype";;
esac
case "$gidtype" in
gid_t) echo "gid_t found." ;;
*)      rp="What is the type for group ids returned by getgid()?"
        . ./myread
        gidtype="$ans"
        ;;
esac

echo " "
case "$gidtype" in
*_t) zzz="$gidtype"     ;;
*)   zzz="gid"          ;;
esac
echo "Checking the size of $zzz..." >&4
cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
    printf("%d\n", (int)sizeof($gidtype));
    exit(0);
}
EOCP
set try
if eval $compile_ok; then
        yyy=`$run ./try`
        case "$yyy" in
        '')     gidsize=4
                echo "(I can't execute the test program--guessing $gidsize.)" >&4
                ;;
        *)      gidsize=$yyy
                echo "Your $zzz is $gidsize bytes long."
                ;;
        esac
else
        gidsize=4
        echo "(I can't compile the test program--guessing $gidsize.)" >&4
fi


echo " "
case "$gidtype" in
*_t) zzz="$gidtype"     ;;
*)   zzz="gid"          ;;
esac
echo "Checking the sign of $zzz..." >&4
cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
int main() {
        $gidtype foo = -1;
        if (foo < 0)
                printf("-1\n");
        else
                printf("1\n");
}
EOCP
set try
if eval $compile; then
        yyy=`$run ./try`
        case "$yyy" in
        '')     gidsign=1
                echo "(I can't execute the test program--guessing unsigned.)" >&4
                ;;
        *)      gidsign=$yyy
                case "$gidsign" in
                 1) echo "Your $zzz is unsigned." ;;
                -1) echo "Your $zzz is signed."   ;;
                esac
                ;;
        esac
else
        gidsign=1
        echo "(I can't compile the test program--guessing unsigned.)" >&4
fi


echo " "

if $test X"$quadtype" != X; then

echo "Checking how to print 64-bit integers..." >&4

if $test X"$sPRId64" = X -a X"$quadtype" = Xint; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  int q = 12345678901;
  printf("%ld\n", q);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                12345678901)
                        sPRId64='"d"'; sPRIi64='"i"'; sPRIu64='"u"';
                        sPRIo64='"o"'; sPRIx64='"x"'; sPRIXU64='"X"';
                        echo "We will use %d."
                        ;;
                esac
        fi
fi

if $test X"$sPRId64" = X -a X"$quadtype" = Xlong; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  long q = 12345678901;
  printf("%ld\n", q);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                12345678901)
                        sPRId64='"ld"'; sPRIi64='"li"'; sPRIu64='"lu"';
                        sPRIo64='"lo"'; sPRIx64='"lx"'; sPRIXU64='"lX"';
                        echo "We will use %ld."
                        ;;
                esac
        fi
fi

if $test X"$sPRId64" = X -a X"$i_inttypes" = X"$define" -a X"$quadtype" = Xint64_t; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <inttypes.h>
#include <stdio.h>
int main() {
  int64_t q = 12345678901;
  printf("%" PRId64 "\n", q);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                12345678901)
                        sPRId64=PRId64; sPRIi64=PRIi64; sPRIu64=PRIu64;
                        sPRIo64=PRIo64; sPRIx64=PRIx64; sPRIXU64=PRIXU64;
                        echo "We will use the C9X style."
                        ;;
                esac
        fi
fi

if $test X"$sPRId64" = X -a X"$quadtype" != X; then
        $cat >try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
int main() {
  $quadtype q = 12345678901;
  printf("%Ld\n", q);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                12345678901)
                        sPRId64='"Ld"'; sPRIi64='"Li"'; sPRIu64='"Lu"';
                        sPRIo64='"Lo"'; sPRIx64='"Lx"'; sPRIXU64='"LX"';
                        echo "We will use %Ld."
                        ;;
                esac
        fi
fi

if $test X"$sPRId64" = X -a X"$quadtype" = X"long long"; then
        $cat >try.c <<'EOCP'
#include <sys/types.h>
#include <stdio.h>
int main() {
  long long q = 12345678901LL; /* AIX cc requires the LL suffix. */
  printf("%lld\n", q);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                12345678901)
                        sPRId64='"lld"'; sPRIi64='"lli"'; sPRIu64='"llu"';
                        sPRIo64='"llo"'; sPRIx64='"llx"'; sPRIXU64='"llX"';
                        echo "We will use the %lld style."
                        ;;
                esac
        fi
fi

if $test X"$sPRId64" = X -a X"$quadtype" != X; then
        $cat >try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
int main() {
  $quadtype q = 12345678901;
  printf("%qd\n", q);
}
EOCP
        set try
        if eval $compile; then
                yyy=`$run ./try`
                case "$yyy" in
                12345678901)
                        sPRId64='"qd"'; sPRIi64='"qi"'; sPRIu64='"qu"';
                        sPRIo64='"qo"'; sPRIx64='"qx"'; sPRIXU64='"qX"';
                        echo "We will use %qd."
                        ;;
                esac
        fi
fi

if $test X"$sPRId64" = X; then
        echo "Cannot figure out how to print 64-bit integers." >&4
fi

$rm -f try try.*

fi

case "$sPRId64" in
'')     d_PRId64="$undef"; d_PRIi64="$undef"; d_PRIu64="$undef";
        d_PRIo64="$undef"; d_PRIx64="$undef"; d_PRIXU64="$undef";
        ;;
*)      d_PRId64="$define"; d_PRIi64="$define"; d_PRIu64="$define";
        d_PRIo64="$define"; d_PRIx64="$define"; d_PRIXU64="$define";
        ;;
esac


echo " "
$echo "Checking the format strings to be used for Perl's internal types..." >&4

if $test X"$ivsize" = X8; then
        ivdformat="$sPRId64"
        uvuformat="$sPRIu64"
        uvoformat="$sPRIo64"
        uvxformat="$sPRIx64"
        uvXUformat="$sPRIXU64"
else
        if $test X"$ivsize" = X"$longsize"; then
                ivdformat='"ld"'
                uvuformat='"lu"'
                uvoformat='"lo"'
                uvxformat='"lx"'
                uvXUformat='"lX"'
        else
                if $test X"$ivsize" = X"$intsize"; then
                        ivdformat='"d"'
                        uvuformat='"u"'
                        uvoformat='"o"'
                        uvxformat='"x"'
                        uvXUformat='"X"'
                else
                        : far out
                        if $test X"$ivsize" = X"$shortsize"; then
                                ivdformat='"hd"'
                                uvuformat='"hu"'
                                uvoformat='"ho"'
                                uvxformat='"hx"'
                                uvXUformat='"hX"'
                        fi
                fi
        fi
fi

if $test X"$uselongdouble" = X"$define" -a X"$d_longdbl" = X"$define" -a X"$d_PRIgldbl" = X"$define"; then
        nveformat="$sPRIeldbl"
        nvfformat="$sPRIfldbl"
        nvgformat="$sPRIgldbl"
        nvEUformat="$sPRIEUldbl"
        nvFUformat="$sPRIFUldbl"
        nvGUformat="$sPRIGUldbl"
else
        nveformat='"e"'
        nvfformat='"f"'
        nvgformat='"g"'
        nvEUformat='"E"'
        nvFUformat='"F"'
        nvGUformat='"G"'
fi

case "$ivdformat" in
'') echo "$0: Fatal: failed to find format strings, cannot continue." >&4
    exit 1
    ;;
esac


echo " "
$echo "Checking the format string to be used for gids..." >&4

case "$gidsign" in
-1)     if $test X"$gidsize" = X"$ivsize"; then
                gidformat="$ivdformat"
        else
                if $test X"$gidsize" = X"$longsize"; then
                        gidformat='"ld"'
                else
                        if $test X"$gidsize" = X"$intsize"; then
                                gidformat='"d"'
                        else
                                if $test X"$gidsize" = X"$shortsize"; then
                                        gidformat='"hd"'
                                fi
                        fi
                fi
        fi
        ;;
*)      if $test X"$gidsize" = X"$uvsize"; then
                gidformat="$uvuformat"
        else
                if $test X"$gidsize" = X"$longsize"; then
                        gidformat='"lu"'
                else
                        if $test X"$gidsize" = X"$intsize"; then
                                gidformat='"u"'
                        else
                                if $test X"$gidsize" = X"$shortsize"; then
                                        gidformat='"hu"'
                                fi
                        fi
                fi
        fi
        ;;
esac

: see if getgroups exists
set getgroups d_getgrps
eval $inlibc

: see if setgroups exists
set setgroups d_setgrps
eval $inlibc


: Find type of 2nd arg to 'getgroups()' and 'setgroups()'
echo " "
case "$d_getgrps$d_setgrps" in
*define*)
        case "$groupstype" in
        '') dflt="$gidtype" ;;
        *)  dflt="$groupstype" ;;
        esac
        $cat <<EOM
What type of pointer is the second argument to getgroups() and setgroups()?
Usually this is the same as group ids, $gidtype, but not always.

EOM
        rp='What type pointer is the second argument to getgroups() and setgroups()?'
        . ./myread
        groupstype="$ans"
        ;;
*)  groupstype="$gidtype";;
esac

echo " "
echo "Checking if your $make program sets \$(MAKE)..." >&4
case "$make_set_make" in
'')
        $sed 's/^X //' > testmake.mak << 'EOF'
Xall:
X       @echo 'maketemp="$(MAKE)"'
EOF
        case "`$make -f testmake.mak 2>/dev/null`" in
        *maketemp=*) make_set_make='#' ;;
        *)      make_set_make="MAKE=$make" ;;
        esac
        $rm -f testmake.mak
        ;;
esac
case "$make_set_make" in
'#') echo "Yup, it does.";;
*) echo "Nope, it doesn't.";;
esac

: see what type is used for mode_t
rp="What is the type used for file modes for system calls (e.g. fchmod())?"
set mode_t modetype int stdio.h sys/types.h
eval $typedef_ask

: see if stdarg is available
echo " "
if $test `./findhdr stdarg.h`; then
        echo "<stdarg.h> found." >&4
        valstd="$define"
else
        echo "<stdarg.h> NOT found." >&4
        valstd="$undef"
fi

: see if varags is available
echo " "
if $test `./findhdr varargs.h`; then
        echo "<varargs.h> found." >&4
else
        echo "<varargs.h> NOT found, but that's ok (I hope)." >&4
fi

: set up the varargs testing programs
$cat > varargs.c <<EOP
#ifdef I_STDARG
#include <stdarg.h>
#endif
#ifdef I_VARARGS
#include <varargs.h>
#endif

#ifdef I_STDARG
int f(char *p, ...)
#else
int f(va_alist)
va_dcl
#endif
{
        va_list ap;
#ifndef I_STDARG
        char *p;
#endif
#ifdef I_STDARG
        va_start(ap,p);
#else
        va_start(ap);
        p = va_arg(ap, char *);
#endif
        va_end(ap);
}
EOP
$cat > varargs <<EOP
$startsh
if $cc -c $ccflags -D\$1 varargs.c >/dev/null 2>&1; then
        echo "true"
else
        echo "false"
fi
$rm -f varargs$_o
EOP
chmod +x varargs

: now check which varargs header should be included
echo " "
i_varhdr=''
case "$valstd" in
"$define")
        if `./varargs I_STDARG`; then
                val='stdarg.h'
        elif `./varargs I_VARARGS`; then
                val='varargs.h'
        fi
        ;;
*)
        if `./varargs I_VARARGS`; then
                val='varargs.h'
        fi
        ;;
esac
case "$val" in
'')
echo "I could not find the definition for va_dcl... You have problems..." >&4
        val="$undef"; set i_stdarg; eval $setvar
        val="$undef"; set i_varargs; eval $setvar
        ;;
*)
        set i_varhdr
        eval $setvar
        case "$i_varhdr" in
        stdarg.h)
                val="$define"; set i_stdarg; eval $setvar
                val="$undef"; set i_varargs; eval $setvar
                ;;
        varargs.h)
                val="$undef"; set i_stdarg; eval $setvar
                val="$define"; set i_varargs; eval $setvar
                ;;
        esac
        echo "We'll include <$i_varhdr> to get va_dcl definition." >&4;;
esac
$rm -f varargs*

: see if we need va_copy
echo " "
case "$i_stdarg" in
"$define")
        $cat >try.c <<EOCP
#include <stdarg.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <signal.h>

int
ivfprintf(FILE *f, const char *fmt, va_list *valp)
{
  return vfprintf(f, fmt, *valp);
}

int
myvfprintf(FILE *f, const  char *fmt, va_list val)
{
  return ivfprintf(f, fmt, &val);
}

int
myprintf(char *fmt, ...)
{
  va_list val;
  va_start(val, fmt);
  return myvfprintf(stdout, fmt, val);
}

int
main(int ac, char **av)
{
  signal(SIGSEGV, exit);

  myprintf("%s%cs all right, then\n", "that", '\'');
  exit(0);
}
EOCP
        set try
        if eval $compile && $run ./try 2>&1 >/dev/null; then
                case "`$run ./try`" in
                "that's all right, then")
                        okay=yes
                        ;;
                esac
        fi
        case "$okay" in
        yes)    echo "It seems that you don't need va_copy()." >&4
                need_va_copy="$undef"
                ;;
        *)      echo "It seems that va_copy() or similar will be needed." >&4
                need_va_copy="$define"
                ;;
        esac
        $rm -f try.* core core.* *.core *.core.*
        ;;
*)      echo "You don't have <stdarg.h>, not checking for va_copy()." >&4
        ;;
esac

: see what type is used for size_t
rp="What is the type used for the length parameter for string functions?"
set size_t sizetype 'unsigned int' stdio.h sys/types.h
eval $typedef_ask

: check for type of arguments to gethostbyaddr.
if test "X$netdb_host_type" = X -o "X$netdb_hlen_type" = X; then
        case "$d_gethbyaddr" in
        $define)
                $cat <<EOM

Checking to see what type of arguments are accepted by gethostbyaddr().
EOM
                hdrs="$define sys/types.h
                        $d_socket sys/socket.h
                        $i_niin netinet/in.h
                        $i_netdb netdb.h
                        $i_unistd unistd.h"
                : The first arg can 'char *' or 'void *'
                : The second arg is some of integral type
                for xxx in in_addr_t 'const void *' 'const char *' 'void *' 'char *'; do
                        for yyy in size_t long int; do
                                case "$netdb_host_type" in
                                '')     try="extern struct hostent *gethostbyaddr($xxx, $yyy, int);"
                                        if ./protochk "$try" $hdrs; then
                                                echo "Your system accepts $xxx for the first arg."
                                                echo "...and $yyy for the second arg."
                                                netdb_host_type="$xxx"
                                                netdb_hlen_type="$yyy"
                                        fi
                                        ;;
                                esac
                        done
                done
                : In case none of those worked, prompt the user.
                case "$netdb_host_type" in
                '')     rp='What is the type for the 1st argument to gethostbyaddr?'
                        dflt='char *'
                        . ./myread
                        netdb_host_type=$ans
                        rp='What is the type for the 2nd argument to gethostbyaddr?'
                        dflt="$sizetype"
                        . ./myread
                        netdb_hlen_type=$ans
                        ;;
                esac
                ;;
        *)      : no gethostbyaddr, so pick harmless defaults
                netdb_host_type='char *'
                netdb_hlen_type="$sizetype"
                ;;
        esac
        # Remove the "const" if needed. -- but then we'll have a
        # prototype clash!
        # netdb_host_type=`echo "$netdb_host_type" | sed 's/^const //'`
fi

: check for type of argument to gethostbyname.
if test "X$netdb_name_type" = X ; then
        case "$d_gethbyname" in
        $define)
                $cat <<EOM

Checking to see what type of argument is accepted by gethostbyname().
EOM
                hdrs="$define sys/types.h
                        $d_socket sys/socket.h
                        $i_niin netinet/in.h
                        $i_netdb netdb.h
                        $i_unistd unistd.h"
                for xxx in "const char *" "char *"; do
                        case "$netdb_name_type" in
                        '')     try="extern struct hostent *gethostbyname($xxx);"
                                if ./protochk "$try" $hdrs; then
                                        echo "Your system accepts $xxx."
                                        netdb_name_type="$xxx"
                                fi
                                ;;
                        esac
                done
                : In case none of those worked, prompt the user.
                case "$netdb_name_type" in
                '')     rp='What is the type for the 1st argument to gethostbyname?'
                        dflt='char *'
                        . ./myread
                        netdb_name_type=$ans
                        ;;
                esac
                ;;
        *)      : no gethostbyname, so pick harmless default
                netdb_name_type='char *'
                ;;
        esac
fi

: check for type of 1st argument to getnetbyaddr.
if test "X$netdb_net_type" = X ; then
        case "$d_getnbyaddr" in
        $define)
                $cat <<EOM

Checking to see what type of 1st argument is accepted by getnetbyaddr().
EOM
                hdrs="$define sys/types.h
                        $d_socket sys/socket.h
                        $i_niin netinet/in.h
                        $i_netdb netdb.h
                        $i_unistd unistd.h"
                for xxx in in_addr_t "unsigned long" long "unsigned int" int; do
                        case "$netdb_net_type" in
                        '')     try="extern struct netent *getnetbyaddr($xxx, int);"
                                if ./protochk "$try" $hdrs; then
                                        echo "Your system accepts $xxx."
                                        netdb_net_type="$xxx"
                                fi
                                ;;
                        esac
                done
                : In case none of those worked, prompt the user.
                case "$netdb_net_type" in
                '')     rp='What is the type for the 1st argument to getnetbyaddr?'
                        dflt='long'
                        . ./myread
                        netdb_net_type=$ans
                        ;;
                esac
                ;;
        *)      : no getnetbyaddr, so pick harmless default
                netdb_net_type='long'
                ;;
        esac
fi
: locate the preferred pager for this system
fn=f/
case "$pager" in
'')
        dflt=''
        case "$pg" in
        /*) dflt=$pg;;
        [a-zA-Z]:/*) dflt=$pg;;
        esac
        case "$more" in
        /*) dflt=$more;;
        [a-zA-Z]:/*) dflt=$more;;
        esac
        case "$less" in
        /*) dflt=$less;;
        [a-zA-Z]:/*) dflt=$less;;
        esac
        case "$dflt" in
        '') dflt=/usr/ucb/more;;
        esac
        ;;
*)      dflt="$pager"
        : Instruct ./getfile to trust the hinted or previous pager value,
        : even if it does not begin with a slash.  For example, on os2,
        : pager might be cmd /c more.  See comments in UU/getfile.
        fn="f/($pager)"
        ;;
esac
echo " "
rp='What pager is used on your system?'
. ./getfile
pager="$ans"

: see what type pids are declared as in the kernel
rp="What is the type of process ids on this system?"
set pid_t pidtype int stdio.h sys/types.h
eval $typedef_ask

: see if ar generates random libraries by itself
echo " "
echo "Checking how to generate random libraries on your machine..." >&4
echo 'int bar1() { return bar2(); }' > bar1.c
echo 'int bar2() { return 2; }' > bar2.c
$cat > foo.c <<EOP
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() { printf("%d\n", bar1()); exit(0); }
EOP
$cc $ccflags -c bar1.c >/dev/null 2>&1
$cc $ccflags -c bar2.c >/dev/null 2>&1
$cc $ccflags -c foo.c >/dev/null 2>&1
$ar rc bar$_a bar2$_o bar1$_o >/dev/null 2>&1
if $cc -o foobar $ccflags $ldflags foo$_o bar$_a $libs > /dev/null 2>&1 &&
        $run ./foobar >/dev/null 2>&1; then
        echo "$ar appears to generate random libraries itself."
        orderlib=false
        ranlib=":"
elif $ar ts bar$_a >/dev/null 2>&1 &&
        $cc -o foobar $ccflags $ldflags foo$_o bar$_a $libs > /dev/null 2>&1 &&
        $run ./foobar >/dev/null 2>&1; then
                echo "a table of contents needs to be added with '$ar ts'."
                orderlib=false
                ranlib="$ar ts"
else
        case "$ranlib" in
        :) ranlib='';;
        '')
                ranlib=`./loc ranlib X /usr/bin /bin /usr/local/bin`
                $test -f $ranlib || ranlib=''
                ;;
        esac
        if $test -n "$ranlib"; then
                echo "your system has '$ranlib'; we'll use that."
                orderlib=false
        else
                echo "your system doesn't seem to support random libraries"
                echo "so we'll use lorder and tsort to order the libraries."
                orderlib=true
                ranlib=":"
        fi
fi
$rm -f foo* bar*

: check for type of arguments to select.
case "$selecttype" in
'') case "$d_select" in
        $define)
                echo " "
                $cat <<EOM
Checking to see what type of arguments are accepted by select().
EOM
                hdrs="$define sys/types.h
                        $i_systime sys/time.h
                        $i_sysselct sys/select.h
                        $d_socket sys/socket.h"
                : The first arg can be int, unsigned, or size_t
                : The last arg may or may not be 'const'
                val=''
                : void pointer has been seen but using that
                : breaks the selectminbits test
                for xxx in 'fd_set *' 'int *'; do
                        for nfd in 'int' 'size_t' 'unsigned long' 'unsigned' ; do
                                for tmo in 'struct timeval *' 'const struct timeval *'; do
                                        case "$val" in
                                        '')     try="extern select _(($nfd, $xxx, $xxx, $xxx, $tmo));"
                                                if ./protochk "$try" $hdrs; then
                                                        echo "Your system accepts $xxx."
                                                        val="$xxx"
                                                fi
                                                ;;
                                        esac
                                done
                        done
                done
                case "$val" in
                '')     rp='What is the type for the 2nd, 3rd, and 4th arguments to select?'
                        case "$d_fd_set" in
                                $define) dflt="fd_set *" ;;
                                *)              dflt="int *" ;;
                        esac
                        . ./myread
                        val=$ans
                        ;;
                esac
                selecttype="$val"
                ;;
        *)      : no select, so pick a harmless default
                selecttype='int *'
                ;;
        esac
        ;;
esac

: check for the select 'width'
case "$selectminbits" in
'') safebits=`expr $ptrsize \* 8`
    case "$d_select" in
        $define)
                $cat <<EOM

Checking to see on how many bits at a time your select() operates...
EOM
                $cat >try.c <<EOCP
#include <sys/types.h>
#$i_time I_TIME
#$i_systime I_SYS_TIME
#$i_systimek I_SYS_TIME_KERNEL
#ifdef I_TIME
#   include <time.h>
#endif
#ifdef I_SYS_TIME
#   ifdef I_SYS_TIME_KERNEL
#       define KERNEL
#   endif
#   include <sys/time.h>
#   ifdef I_SYS_TIME_KERNEL
#       undef KERNEL
#   endif
#endif
#$i_sysselct I_SYS_SELECT
#ifdef I_SYS_SELECT
#include <sys/select.h>
#endif
#$d_socket HAS_SOCKET
#ifdef HAS_SOCKET
#   include <sys/socket.h> /* Might include <sys/bsdtypes.h> */
#endif
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
$selecttype b;
#define S sizeof(*(b))
#define MINBITS 64
#define NBYTES (S * 8 > MINBITS ? S : MINBITS/8)
#define NBITS  (NBYTES * 8)
int main() {
    char *s = malloc(NBYTES);
    struct timeval t;
    int i;
    FILE* fp;
    int fd;

    if (!s)
        exit(1);
    fclose(stdin);
    fp = fopen("try.c", "r");
    if (fp == 0)
      exit(2);
    fd = fileno(fp);
    if (fd < 0)
      exit(3);
    b = ($selecttype)s;
    for (i = 0; i < NBITS; i++)
        FD_SET(i, b);
    t.tv_sec  = 0;
    t.tv_usec = 0;
    select(fd + 1, b, 0, 0, &t);
    for (i = NBITS - 1; i > fd && FD_ISSET(i, b); i--);
    free(s);
    printf("%d\n", i + 1);
    return 0;
}
EOCP
                set try
                if eval $compile_ok; then
                        selectminbits=`$run ./try`
                        case "$selectminbits" in
                        '')     cat >&4 <<EOM
Cannot figure out on how many bits at a time your select() operates.
I'll play safe and guess it is $safebits bits.
EOM
                                selectminbits=$safebits
                                bits="$safebits bits"
                                ;;
                        1)      bits="1 bit" ;;
                        *)      bits="$selectminbits bits" ;;
                        esac
                        echo "Your select() operates on $bits at a time." >&4
                else
                        rp='What is the minimum number of bits your select() operates on?'
                        case "$byteorder" in
                        12345678)       dflt=64 ;;
                        1234)           dflt=32 ;;
                        *)              dflt=1  ;;
                        esac
                        . ./myread
                        val=$ans
                        selectminbits="$val"
                fi
                $rm -f try.* try
                ;;
        *)      : no select, so pick a harmless default
                selectminbits=$safebits
                ;;
        esac
        ;;
esac

: Trace out the files included by signal.h, then look for SIGxxx names.
: Remove SIGARRAYSIZE used by HPUX.
: Remove SIGSTKSIZE used by Linux.
: Remove SIGSTKSZ used by Posix.
: Remove SIGTYP void lines used by OS2.
: Some cpps, like os390, dont give the file name anywhere
if [ "X$fieldn" = X ]; then
        : Just make some guesses.  We check them later.
        xxx='/usr/include/signal.h /usr/include/sys/signal.h'
else
        xxx=`echo '#include <signal.h>' |
        $cppstdin $cppminus $cppflags 2>/dev/null |
        $grep '^[       ]*#.*include' |
        $awk "{print \\$$fieldn}" | $sed 's!"!!g' | $sed 's!\\\\\\\\!/!g' | $sort | $uniq`
fi
: Check this list of files to be sure we have parsed the cpp output ok.
: This will also avoid potentially non-existent files, such
: as ../foo/bar.h
xxxfiles=''
for xx in $xxx /dev/null ; do
        $test -f "$xx" && xxxfiles="$xxxfiles $xx"
done
: If we have found no files, at least try signal.h
case "$xxxfiles" in
'')     xxxfiles=`./findhdr signal.h` ;;
esac
xxx=`awk '
$1 ~ /^#define$/ && $2 ~ /^SIG[A-Z0-9]*$/ && $2 !~ /SIGARRAYSIZE/ && $2 !~ /SIGSTKSIZE/ && $2 !~ /SIGSTKSZ/ && $3 !~ /void/ {
        print substr($2, 4, 20)
}
$1 == "#" && $2 ~ /^define$/ && $3 ~ /^SIG[A-Z0-9]*$/ && $3 !~ /SIGARRAYSIZE/ && $4 !~ /void/ {
        print substr($3, 4, 20)
}' $xxxfiles`
: Append some common names just in case the awk scan failed.
xxx="$xxx ABRT ALRM BUS CANCEL CHLD CLD CONT DIL EMT FPE"
xxx="$xxx FREEZE HUP ILL INT IO IOT KILL LOST LWP PHONE"
xxx="$xxx PIPE POLL PROF PWR QUIT RTMAX RTMIN SEGV STKFLT STOP"
xxx="$xxx SYS TERM THAW TRAP TSTP TTIN TTOU URG USR1 USR2"
xxx="$xxx USR3 USR4 VTALRM WAITING WINCH WIND WINDOW XCPU XFSZ"

: generate a few handy files for later
$cat > signal.c <<EOCP
#include <sys/types.h>
#include <signal.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <stdio.h>
int main() {

/* Strange style to avoid deeply-nested #if/#else/#endif */
#ifndef NSIG
#  ifdef _NSIG
#    define NSIG (_NSIG)
#  endif
#endif

#ifndef NSIG
#  ifdef SIGMAX
#    define NSIG (SIGMAX+1)
#  endif
#endif

#ifndef NSIG
#  ifdef SIG_MAX
#    define NSIG (SIG_MAX+1)
#  endif
#endif

#ifndef NSIG
#  ifdef MAXSIG
#    define NSIG (MAXSIG+1)
#  endif
#endif

#ifndef NSIG
#  ifdef MAX_SIG
#    define NSIG (MAX_SIG+1)
#  endif
#endif

#ifndef NSIG
#  ifdef SIGARRAYSIZE
#    define NSIG (SIGARRAYSIZE+1) /* Not sure of the +1 */
#  endif
#endif

#ifndef NSIG
#  ifdef _sys_nsig
#    define NSIG (_sys_nsig) /* Solaris 2.5 */
#  endif
#endif

/* Default to some arbitrary number that's big enough to get most
   of the common signals.
*/
#ifndef NSIG
#    define NSIG 50
#endif

printf("NSIG %d\n", NSIG);

#ifndef JUST_NSIG

EOCP

echo $xxx | $tr ' ' $trnl | $sort | $uniq | $awk '
{
        printf "#ifdef SIG"; printf $1; printf "\n"
        printf "printf(\""; printf $1; printf " %%d\\n\",SIG";
        printf $1; printf ");\n"
        printf "#endif\n"
}
END {
        printf "#endif /* JUST_NSIG */\n";
        printf "exit(0);\n}\n";
}
' >>signal.c
$cat >signal.awk <<'EOP'
BEGIN { ndups = 0 }
$1 ~ /^NSIG$/ { nsig = $2 }
($1 !~ /^NSIG$/) && (NF == 2) && ($2 ~ /^[0-9][0-9]*$/) {
    if ($2 > maxsig) { maxsig = $2 }
    if (sig_name[$2]) {
        dup_name[ndups] = $1
        dup_num[ndups] = $2
        ndups++
    }
    else {
        sig_name[$2] = $1
        sig_num[$2] = $2
    }
}
END {
    if (nsig == 0) {
        nsig = maxsig + 1
    }
    printf("NSIG %d\n", nsig);
    for (n = 1; n < nsig; n++) {
        if (sig_name[n]) {
            printf("%s %d\n", sig_name[n], sig_num[n])
        }
        else {
            printf("NUM%d %d\n", n, n)
        }
    }
    for (n = 0; n < ndups; n++) {
        printf("%s %d\n", dup_name[n], dup_num[n])
    }
}
EOP
$cat >signal_cmd <<EOS
$startsh
if $test -s signal.lst; then
    echo "Using your existing signal.lst file"
        exit 0
fi
xxx="$xxx"
EOS
$cat >>signal_cmd <<'EOS'

set signal
if eval $compile_ok; then
        $run ./signal$_exe | ($sort -n -k 2 2>/dev/null || $sort -n +1) | $uniq | $awk -f signal.awk >signal.lst
else
        echo "(I can't seem be able to compile the whole test program)" >&4
        echo "(I'll try it in little pieces.)" >&4
        set signal -DJUST_NSIG
        if eval $compile_ok; then
                $run ./signal$_exe > signal.nsg
                $cat signal.nsg
        else
                echo "I can't seem to figure out how many signals you have." >&4
                echo "Guessing 50." >&4
                echo 'NSIG 50' > signal.nsg
        fi
        : Now look at all the signal names, one at a time.
        for xx in `echo $xxx | $tr ' ' $trnl | $sort | $uniq`; do
                $cat > signal.c <<EOCP
#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
int main() {
printf("$xx %d\n", SIG${xx});
return 0;
}
EOCP
                set signal
                if eval $compile; then
                        echo "SIG${xx} found."
                        $run ./signal$_exe  >> signal.ls1
                else
                        echo "SIG${xx} NOT found."
                fi
        done
        if $test -s signal.ls1; then
                $cat signal.nsg signal.ls1 |
                        $sort -n | $uniq | $awk -f signal.awk >signal.lst
        fi

fi
if $test -s signal.lst; then
        :
else
        echo "(AAK! I can't compile the test programs -- Guessing)" >&4
        echo 'kill -l' >signal
        set X `csh -f <signal`
        $rm -f signal
        shift
        case $# in
        0) set HUP INT QUIT ILL TRAP ABRT EMT FPE KILL BUS SEGV SYS PIPE ALRM TERM;;
        esac
        echo $@ | $tr ' ' $trnl | \
            $awk '{ printf "%s %d\n", $1, ++s; }
                  END { printf "NSIG %d\n", ++s }' >signal.lst
fi
$rm -f signal.c signal$_exe signal$_o signal.nsg signal.ls1
EOS
chmod a+x signal_cmd
$eunicefix signal_cmd

: generate list of signal names
echo " "
case "$sig_name_init" in
'') doinit=yes ;;
*)  case "$sig_num_init" in
    ''|*,*) doinit=yes ;;
    esac ;;
esac
case "$doinit" in
yes)
        echo "Generating a list of signal names and numbers..." >&4
        . ./signal_cmd
        sig_count=`$awk '/^NSIG/ { printf "%d", $2 }' signal.lst`
        sig_name=`$awk 'BEGIN { printf "ZERO " }
                        !/^NSIG/ { printf "%s ", $1 }' signal.lst`
        sig_num=`$awk  'BEGIN { printf "0 " }
                        !/^NSIG/ { printf "%d ", $2 }' signal.lst`
        sig_name_init=`$awk 'BEGIN      { printf "\"ZERO\", " }
                             !/^NSIG/   { printf "\"%s\", ", $1 }
                             END        { printf "0\n" }' signal.lst`
        sig_num_init=`$awk  'BEGIN      { printf "0, " }
                             !/^NSIG/   { printf "%d, ", $2}
                             END        { printf "0\n"}' signal.lst`
        ;;
esac
echo "The following $sig_count signals are available:"
echo " "
echo $sig_name | $awk \
'BEGIN { linelen = 0 }
{
        for (i = 1; i <= NF; i++) {
                name = "SIG" $i " "
                linelen = linelen + length(name)
                if (linelen > 70) {
                        printf "\n"
                        linelen = length(name)
                }
                printf "%s", name
        }
        printf "\n"
}'
sig_size=`echo $sig_name | awk '{print NF}'`
$rm -f signal signal.c signal.awk signal.lst signal_cmd

echo " "
case "$sizetype" in
*_t) zzz="$sizetype"    ;;
*)   zzz="filesize"     ;;
esac
echo "Checking the size of $zzz..." >&4
cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
    printf("%d\n", (int)sizeof($sizetype));
    exit(0);
}
EOCP
set try
if eval $compile_ok; then
        yyy=`$run ./try`
        case "$yyy" in
        '')     sizesize=4
                echo "(I can't execute the test program--guessing $sizesize.)" >&4
                ;;
        *)      sizesize=$yyy
                echo "Your $zzz size is $sizesize bytes."
                ;;
        esac
else
        sizesize=4
        echo "(I can't compile the test program--guessing $sizesize.)" >&4
fi


: check for socklen_t
echo " "
echo "Checking to see if you have socklen_t..." >&4
$cat >try.c <<EOCP
#include <sys/types.h>
#$d_socket HAS_SOCKET
#ifdef HAS_SOCKET
#include <sys/socket.h>
#endif
int main() { socklen_t x = 16; }
EOCP
set try
if eval $compile; then
        val="$define"
        echo "You have socklen_t."
else
        val="$undef"
        echo "You do not have socklen_t."
        case "$sizetype" in
        size_t) echo "(You do have size_t, that might work. Some people are happy with just an int.)" ;;
        esac
fi
$rm -f try try.*
set d_socklen_t
eval $setvar

: see if this is a socks.h system
set socks.h i_socks
eval $inhdr

: check for type of the size argument to socket calls
case "$d_socket" in
"$define")
        $cat <<EOM

Checking to see what type is the last argument of accept().
EOM
        yyy=''
        case "$d_socklen_t" in
        "$define") yyy="$yyy socklen_t"
        esac
        yyy="$yyy $sizetype int long unsigned"
        for xxx in $yyy; do
                case "$socksizetype" in
                '')     try="extern int accept(int, struct sockaddr *, $xxx *);"
                        case "$usesocks" in
                        "$define")
                                if ./protochk "$try" $i_systypes sys/types.h $d_socket sys/socket.h literal '#define INCLUDE_PROTOTYPES' $i_socks socks.h.; then
                                        echo "Your system accepts '$xxx *' for the last argument of accept()."
                                        socksizetype="$xxx"
                                fi
                                ;;
                        *)      if ./protochk "$try"  $i_systypes sys/types.h $d_socket sys/socket.h; then
                                        echo "Your system accepts '$xxx *' for the last argument of accept()."
                                        socksizetype="$xxx"
                                fi
                                ;;
                        esac
                        ;;
                esac
        done
: In case none of those worked, prompt the user.
        case "$socksizetype" in
        '')     rp='What is the type for socket address structure sizes?'
                dflt='int'
                . ./myread
                socksizetype=$ans
                ;;
        esac
        ;;
*)      : no sockets, so pick relatively harmless default
        socksizetype='int'
        ;;
esac

: see what type is used for signed size_t
set ssize_t ssizetype int stdio.h sys/types.h
eval $typedef
dflt="$ssizetype"
$cat > try.c <<EOM
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#include <sys/types.h>
#define Size_t $sizetype
#define SSize_t $dflt
int main()
{
        if (sizeof(Size_t) == sizeof(SSize_t))
                printf("$dflt\n");
        else if (sizeof(Size_t) == sizeof(int))
                printf("int\n");
        else
                printf("long\n");
        exit(0);
}
EOM
echo " "
set try
if eval $compile_ok && $run ./try > /dev/null; then
        ssizetype=`$run ./try`
        echo "I'll be using $ssizetype for functions returning a byte count." >&4
else
        $cat >&4 <<EOM
Help! I can't compile and run the ssize_t test program: please enlighten me!
(This is probably a misconfiguration in your system or libraries, and
you really ought to fix it.  Still, I'll try anyway.)

I need a type that is the same size as $sizetype, but is guaranteed to
be signed.  Common values are ssize_t, int and long.

EOM
        rp="What signed type is the same size as $sizetype?"
        . ./myread
        ssizetype="$ans"
fi
$rm -f try try.*

: see what type of char stdio uses.
echo " "
echo '#include <stdio.h>' | $cppstdin $cppminus > stdioh
if $contains 'unsigned.*char.*_ptr;' stdioh >/dev/null 2>&1 ; then
        echo "Your stdio uses unsigned chars." >&4
        stdchar="unsigned char"
else
        echo "Your stdio uses signed chars." >&4
        stdchar="char"
fi
$rm -f stdioh



: see what type uids are declared as in the kernel
echo " "
echo "Looking for the type for user ids returned by getuid()."
set uid_t uidtype xxx stdio.h sys/types.h
eval $typedef
case "$uidtype" in
xxx)
        xxx=`./findhdr sys/user.h`
        set `grep '_ruid;' "$xxx" 2>/dev/null` unsigned short
        case $1 in
        unsigned) dflt="$1 $2" ;;
        *) dflt="$1" ;;
        esac
        ;;
*) dflt="$uidtype";;
esac
case "$uidtype" in
uid_t)  echo "uid_t found." ;;
*)      rp="What is the type for user ids returned by getuid()?"
        . ./myread
        uidtype="$ans"
        ;;
esac

echo " "
case "$uidtype" in
*_t) zzz="$uidtype"     ;;
*)   zzz="uid"          ;;
esac
echo "Checking the size of $zzz..." >&4
cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
#$i_stdlib I_STDLIB
#ifdef I_STDLIB
#include <stdlib.h>
#endif
int main() {
    printf("%d\n", (int)sizeof($uidtype));
    exit(0);
}
EOCP
set try
if eval $compile_ok; then
        yyy=`$run ./try`
        case "$yyy" in
        '')     uidsize=4
                echo "(I can't execute the test program--guessing $uidsize.)" >&4
                ;;
        *)      uidsize=$yyy
                echo "Your $zzz is $uidsize bytes long."
                ;;
        esac
else
        uidsize=4
        echo "(I can't compile the test program--guessing $uidsize.)" >&4
fi

echo " "
case "$uidtype" in
*_t) zzz="$uidtype"     ;;
*)   zzz="uid"          ;;
esac
echo "Checking the sign of $zzz..." >&4
cat > try.c <<EOCP
#include <sys/types.h>
#include <stdio.h>
int main() {
        $uidtype foo = -1;
        if (foo < 0)
                printf("-1\n");
        else
                printf("1\n");
}
EOCP
set try
if eval $compile; then
        yyy=`$run ./try`
        case "$yyy" in
        '')     uidsign=1
                echo "(I can't execute the test program--guessing unsigned.)" >&4
                ;;
        *)      uidsign=$yyy
                case "$uidsign" in
                 1) echo "Your $zzz is unsigned." ;;
                -1) echo "Your $zzz is signed."   ;;
                esac
                ;;
        esac
else
        uidsign=1
        echo "(I can't compile the test program--guessing unsigned.)" >&4
fi



echo " "
$echo "Checking the format string to be used for uids..." >&4

case "$uidsign" in
-1)     if $test X"$uidsize" = X"$ivsize"; then
                uidformat="$ivdformat"
        else
                if $test X"$uidsize" = X"$longsize"; then
                        uidformat='"ld"'
                else
                        if $test X"$uidsize" = X"$intsize"; then
                                uidformat='"d"'
                        else
                                if $test X"$uidsize" = X"$shortsize"; then
                                        uidformat='"hd"'
                                fi
                        fi
                fi
        fi
        ;;
*)      if $test X"$uidsize" = X"$uvsize"; then
                uidformat="$uvuformat"
        else
                if $test X"$uidsize" = X"$longsize"; then
                        uidformat='"lu"'
                else
                        if $test X"$uidsize" = X"$intsize"; then
                                uidformat='"u"'
                        else
                                if $test X"$uidsize" = X"$shortsize"; then
                                        uidformat='"hu"'
                                fi
                        fi
                fi
        fi
        ;;
esac

: determine compiler compiler
case "$yacc" in
'')
        dflt=yacc;;
*)
        dflt="$yacc";;
esac
echo " "
comp='yacc'
if $test -f "$byacc$_exe"; then
        dflt="$byacc"
        comp="byacc or $comp"
fi
if $test -f "$bison$_exe"; then
        comp="$comp or bison -y"
fi
rp="Which compiler compiler ($comp) shall I use?"
. ./myread
yacc="$ans"
case "$yacc" in
*bis*)
        case "$yacc" in
        *-y*) ;;
        *)
                yacc="$yacc -y"
                echo "(Adding -y option to bison to get yacc-compatible behaviour.)"
                ;;
        esac
        ;;
esac

: see if this is a fp.h system
set fp.h i_fp
eval $inhdr

: see if this is a fp_class.h system
set fp_class.h i_fp_class
eval $inhdr

: see if this is a ieeefp.h system
case "$i_ieeefp" in
'' ) set ieeefp.h i_ieeefp
     eval $inhdr
     ;;
esac

: see if this is a libutil.h system
set libutil.h i_libutil
eval $inhdr

: see if mach cthreads are available
if test "X$usethreads" = "X$define"; then
        set mach/cthreads.h i_machcthr
        eval $inhdr
else
        i_machcthr="$undef"
fi



: see if this is a math.h system
set math.h i_math
eval $inhdr

: see if this is a mntent.h system
set mntent.h i_mntent
eval $inhdr

: see if ndbm.h is available
set ndbm.h t_ndbm
eval $inhdr

case "$t_ndbm" in
$undef)
    # Some Linux distributions such as RedHat 7.1 put the
    # ndbm.h header in /usr/include/gdbm/ndbm.h.
    if $test -f /usr/include/gdbm/ndbm.h; then
        echo '<gdbm/ndbm.h> found.'
        ccflags="$ccflags -I/usr/include/gdbm"
        cppflags="$cppflags -I/usr/include/gdbm"
        t_ndbm=$define
    fi
    ;;
esac

case "$t_ndbm" in
$define)
        : see if dbm_open exists
        set dbm_open d_dbm_open
        eval $inlibc
        case "$d_dbm_open" in
        $undef)
                t_ndbm="$undef"
                echo "We won't be including <ndbm.h>"
                ;;
        esac
        ;;
esac
val="$t_ndbm"
set i_ndbm
eval $setvar

: see if net/errno.h is available
val=''
set net/errno.h val
eval $inhdr

: Unfortunately, it causes problems on some systems.  Arrgh.
case "$val" in
$define)
        cat > try.c <<'EOM'
#include <stdio.h>
#include <errno.h>
#include <net/errno.h>
int func()
{
        return ENOTSOCK;
}
EOM
        if $cc $ccflags -c try.c >/dev/null 2>&1; then
                echo "We'll be including <net/errno.h>." >&4
        else
                echo "We won't be including <net/errno.h>." >&4
                val="$undef"
        fi
        $rm -f try.* try
        ;;
esac
set i_neterrno
eval $setvar

: see if netinet/tcp.h is available
set netinet/tcp.h i_netinettcp
eval $inhdr

: see if this is a poll.h system
set poll.h i_poll
eval $inhdr

: see if this is a prot.h system
set prot.h i_prot
eval $inhdr

echo " "
$echo "Guessing which symbols your C compiler and preprocessor define..." >&4
$cat <<'EOSH' > Cppsym.know
a29k ABI64 aegis AES_SOURCE AIX AIX32 AIX370
AIX41 AIX42 AIX43 AIX_SOURCE aixpc ALL_SOURCE
alliant alpha am29000 AM29000 AMD64 amiga AMIGAOS AMIX
ansi ANSI_C_SOURCE apollo ardent ARM32 atarist att386 att3b
BeOS BIG_ENDIAN BIT_MSF bsd BSD bsd43 bsd4_2 bsd4_3 BSD4_3 bsd4_4
BSD_4_3 BSD_4_4 BSD_NET2 BSD_TIME BSD_TYPES BSDCOMPAT bsdi
bull c cadmus clipper CMU COFF COMPILER_VERSION
concurrent convex cpu cray CRAY CRAYMPP ctix CX_UX
CYGWIN DGUX DGUX_SOURCE DJGPP dmert DOLPHIN DPX2 DSO
Dynix DynixPTX ELF encore EPI EXTENSIONS FAVOR_BSD
FILE_OFFSET_BITS FreeBSD GCC_NEW_VARARGS gcos gcx gimpel
GLIBC GLIBC_MINOR
GNU_SOURCE GNUC GNUC_MINOR GNU_LIBRARY GO32 gould GOULD_PN
H3050R H3050RX hbullx20 hcx host_mips
hp200 hp300 hp700 HP700 hp800 hp9000
hp9000s200 hp9000s300 hp9000s400 hp9000s500
hp9000s700 hp9000s800 hp9k8 hp_osf hppa hpux HPUX_SOURCE
i186 i286 i386 i486 i586 i686 i8086 i80960 i860 I960
IA64 iAPX286 ibm ibm032 ibmesa IBMR2 ibmrt ILP32 ILP64
INLINE_INTRINSICS INTRINSICS INT64 interdata is68k ksr1
LANGUAGE_C LARGE_FILE_API LARGEFILE64_SOURCE
LARGEFILE_SOURCE LFS64_LARGEFILE LFS_LARGEFILE
Linux LITTLE_ENDIAN LONG64 LONG_DOUBLE LONG_LONG
LONGDOUBLE LONGLONG LP64 luna luna88k Lynx
M68000 m68k m88100 m88k M88KBCS_TARGET M_COFF
M_I186 M_I286 M_I386 M_I8086 M_I86 M_I86SM M_SYS3
M_SYS5 M_SYSIII M_SYSV M_UNIX M_XENIX MACH machine MachTen
MATH_HAS_NO_SIDE_EFFECTS
mc300 mc500 mc68000 mc68010 mc68020 mc68030 mc68040
mc68060 mc68k mc68k32 mc700 mc88000 mc88100 merlin
mert MiNT mips MIPS_FPSET MIPS_ISA MIPS_SIM MIPS_SZINT
MIPS_SZLONG MIPS_SZPTR MIPSEB MIPSEL MODERN_C motorola
mpeix MSDOS MTXINU MULTIMAX mvs MVS n16 ncl_el ncl_mr
NetBSD news1500 news1700 news1800 news1900 news3700
news700 news800 news900 NeXT NLS nonstopux ns16000 ns32000
ns32016 ns32332 ns32k nsc32000
OCS88 OEMVS OpenBSD os OS2 OS390 osf OSF1 OSF_SOURCE
pa_risc PA_RISC1_1 PA_RISC2_0 PARAGON parisc
pc532 pdp11 PGC PIC plexus PORTAR posix
POSIX1B_SOURCE POSIX2_SOURCE POSIX4_SOURCE
POSIX_C_SOURCE POSIX_SOURCE POWER
PROTOTYPES PWB pyr QNX R3000 REENTRANT RES Rhapsody RISC6000
riscix riscos RT S390 SA110 scs SCO sequent sgi SGI_SOURCE SH3 sinix
SIZE_INT SIZE_LONG SIZE_PTR SOCKET_SOURCE SOCKETS_SOURCE
sony sony_news sonyrisc sparc sparclite spectrum
stardent stdc STDC_EXT stratos sun sun3 sun386
Sun386i svr3 svr4 SVR4_2 SVR4_SOURCE svr5
SX system SYSTYPE_BSD SYSTYPE_BSD43 SYSTYPE_BSD44
SYSTYPE_SVR4 SYSTYPE_SVR5 SYSTYPE_SYSV SYSV SYSV3 SYSV4 SYSV5
sysV68 sysV88 Tek4132 Tek4300 titan
TM3200 TM5400 TM5600
tower tower32 tower32_200 tower32_600 tower32_700
tower32_800 tower32_850 tss
u370 u3b u3b2 u3b20 u3b200 u3b20d u3b5
ultrix UMAXV UnicomPBB UnicomPBD UNICOS UNICOSMK
unix UNIX95 UNIX99 unixpc unos
USE_BSD USE_FILE_OFFSET64 USE_GNU USE_ISOC9X USE_LARGEFILE USE_LARGEFILE64
USE_MISC USE_POSIX USE_POSIX199309 USE_POSIX199506 USE_POSIX2
USE_REENTRANT USE_SVID USE_UNIX98 USE_XOPEN USE_XOPEN_EXTENDED
USGr4 USGr4_2
Utek UTek UTS UWIN uxpm uxps vax venix VMESA vms xenix Xenix286
XOPEN_SOURCE XOPEN_SOURCE_EXTENDED XPG2 XPG2_EXTENDED
XPG3 XPG3_EXTENDED XPG4 XPG4_EXTENDED
z8000
EOSH
# Maybe put other stuff here too.
cat <<EOSH >>Cppsym.know
$osname
EOSH
./tr '[a-z]' '[A-Z]' < Cppsym.know > Cppsym.a
./tr '[A-Z]' '[a-z]' < Cppsym.know > Cppsym.b
$cat Cppsym.know > Cppsym.c
$cat Cppsym.a Cppsym.b Cppsym.c | $tr ' ' $trnl | $sort | $uniq > Cppsym.know
$rm -f Cppsym.a Cppsym.b Cppsym.c
cat <<EOSH > Cppsym
$startsh
if $test \$# -gt 0; then
    echo \$* | $tr " " "$trnl" | ./Cppsym.try > Cppsym.got
    if $test -s Cppsym.got; then
        $rm -f Cppsym.got
        exit 0
    fi
    $rm -f Cppsym.got
    exit 1
else
    $tr " " "$trnl" | ./Cppsym.try
    exit 0
fi
EOSH
chmod +x Cppsym
$eunicefix Cppsym
cat <<EOSH > Cppsym.try
$startsh
cat <<'EOCP' > try.c
#include <stdio.h>
int main() {
EOCP
$awk \\
EOSH
cat <<'EOSH' >> Cppsym.try
'length($1) > 0 {
    printf "#ifdef %s\n#if %s+0\nprintf(\"%s=%%ld\\n\", (long)%s);\n#else\nprintf(\"%s\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
    printf "#ifdef _%s\n#if _%s+0\nprintf(\"_%s=%%ld\\n\", (long)_%s);\n#else\nprintf(\"_%s\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
    printf "#ifdef __%s\n#if __%s+0\nprintf(\"__%s=%%ld\\n\", (long)__%s);\n#else\nprintf(\"__%s\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
    printf "#ifdef __%s__\n#if __%s__+0\nprintf(\"__%s__=%%ld\\n\", (long)__%s__);\n#else\nprintf(\"__%s__\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
}'       >> try.c
echo 'return 0;}' >> try.c
EOSH
cat <<EOSH >> Cppsym.try
ccflags="$ccflags"
case "$osname-$gccversion" in
irix-) ccflags="\$ccflags -woff 1178" ;;
os2-*) ccflags="\$ccflags -Zlinker /PM:VIO" ;;
esac
$cc -o try $optimize \$ccflags $ldflags try.c $libs && $run ./try
EOSH
chmod +x Cppsym.try
$eunicefix Cppsym.try
./Cppsym < Cppsym.know > Cppsym.true
: now check the C compiler for additional symbols
postprocess_cc_v=''
case "$osname" in
aix) postprocess_cc_v="|$tr , ' '" ;;
esac
$cat >ccsym <<EOS
$startsh
$cat >tmp.c <<EOF
extern int foo;
EOF
for i in \`$cc -v -c tmp.c 2>&1 $postprocess_cc_v\`
do
        case "\$i" in
        -D*) echo "\$i" | $sed 's/^-D//';;
        -A*) $test "$gccversion" && echo "\$i" | $sed 's/^-A//' | $sed 's/\(.*\)(\(.*\))/\1=\2/';;
        esac
done
$rm -f try.c
EOS
postprocess_cc_v=''
chmod +x ccsym
$eunicefix ccsym
./ccsym > ccsym1.raw
if $test -s ccsym1.raw; then
       $sort ccsym1.raw | $uniq >ccsym.raw
else
       mv ccsym1.raw ccsym.raw
fi

$awk '/\=/ { print $0; next }
        { print $0"=1" }' ccsym.raw >ccsym.list
$awk '/\=/ { print $0; next }
        { print $0"=1" }' Cppsym.true >ccsym.true
$comm -13 ccsym.true ccsym.list >ccsym.own
$comm -12 ccsym.true ccsym.list >ccsym.com
$comm -23 ccsym.true ccsym.list >ccsym.cpp
also=''
if $test -z ccsym.raw; then
        echo "Your C compiler doesn't seem to define any symbols!" >&4
        echo " "
        echo "However, your C preprocessor defines the following symbols:"
        $cat Cppsym.true
        ccsymbols=''
        cppsymbols=`$cat Cppsym.true`
        cppsymbols=`echo $cppsymbols`
        cppccsymbols="$cppsymbols"
else
        if $test -s ccsym.com; then
                echo "Your C compiler and pre-processor define these symbols:"
                $sed -e 's/\(..*\)=.*/\1/' ccsym.com
                also='also '
                symbols='ones'
                cppccsymbols=`$cat ccsym.com`
                cppccsymbols=`echo $cppccsymbols`
                $test "$silent" || sleep 1
        fi
        if $test -s ccsym.cpp; then
                $test "$also" && echo " "
                echo "Your C pre-processor ${also}defines the following symbols:"
                $sed -e 's/\(..*\)=.*/\1/' ccsym.cpp
                also='further '
                cppsymbols=`$cat ccsym.cpp`
                cppsymbols=`echo $cppsymbols`
                $test "$silent" || sleep 1
        fi
        if $test -s ccsym.own; then
                $test "$also" && echo " "
                echo "Your C compiler ${also}defines the following cpp symbols:"
                $sed -e 's/\(..*\)=1/\1/' ccsym.own
                $sed -e 's/\(..*\)=.*/\1/' ccsym.own | $uniq >>Cppsym.true
                ccsymbols=`$cat ccsym.own`
                ccsymbols=`echo $ccsymbols`
                $test "$silent" || sleep 1
        fi
fi

: see if this is a termio system
val="$undef"
val2="$undef"
val3="$undef"
if $test `./findhdr termios.h`; then
        set tcsetattr i_termios
        eval $inlibc
        val3="$i_termios"
fi
echo " "
case "$val3" in
"$define") echo "You have POSIX termios.h... good!" >&4;;
*) if ./Cppsym pyr; then
                case "`/bin/universe`" in
                ucb) if $test `./findhdr sgtty.h`; then
                                val2="$define"
                                echo "<sgtty.h> found." >&4
                        else
                                echo "System is pyramid with BSD universe."
                                echo "<sgtty.h> not found--you could have problems." >&4
                        fi;;
                *) if $test `./findhdr termio.h`; then
                                val="$define"
                                echo "<termio.h> found." >&4
                        else
                                echo "System is pyramid with USG universe."
                                echo "<termio.h> not found--you could have problems." >&4
                        fi;;
                esac
        elif ./usg; then
                if $test `./findhdr termio.h`; then
                        echo "<termio.h> found." >&4
                        val="$define"
                elif $test `./findhdr sgtty.h`; then
                        echo "<sgtty.h> found." >&4
                        val2="$define"
                else
echo "Neither <termio.h> nor <sgtty.h> found--you could have problems." >&4
                fi
        else
                if $test `./findhdr sgtty.h`; then
                        echo "<sgtty.h> found." >&4
                        val2="$define"
                elif $test `./findhdr termio.h`; then
                        echo "<termio.h> found." >&4
                        val="$define"
                else
echo "Neither <sgtty.h> nor <termio.h> found--you could have problems." >&4
                fi
        fi;;
esac
set i_termio; eval $setvar
val=$val2; set i_sgtty; eval $setvar
val=$val3; set i_termios; eval $setvar

: see if stddef is available
set stddef.h i_stddef
eval $inhdr

: see if this is a sunmath.h system
set sunmath.h i_sunmath
eval $inhdr

: see if sys/access.h is available
set sys/access.h i_sysaccess
eval $inhdr

: see if ioctl defs are in sgtty, termio, sys/filio or sys/ioctl
set sys/filio.h i_sysfilio
eval $inhdr
echo " "
if $test `./findhdr sys/ioctl.h`; then
        val="$define"
        echo '<sys/ioctl.h> found.' >&4
else
        val="$undef"
        if $test $i_sysfilio = "$define"; then
            echo '<sys/ioctl.h> NOT found.' >&4
        else
                $test $i_sgtty = "$define" && xxx="sgtty.h"
                $test $i_termio = "$define" && xxx="termio.h"
                $test $i_termios = "$define" && xxx="termios.h"
echo "No <sys/ioctl.h> found, assuming ioctl args are defined in <$xxx>." >&4
        fi
fi
set i_sysioctl
eval $setvar

: see if socket ioctl defs are in sys/sockio.h
echo " "
xxx=`./findhdr sys/sockio.h`
if $test "$xxx"; then
        if $contains SIOCATMARK $xxx >/dev/null 2>&1; then
                val="$define"
                echo "You have socket ioctls defined in <sys/sockio.h>." >&4
        else
                val="$undef"
                echo "No socket ioctls found in <sys/sockio.h>." >&4
        fi
else
        val="$undef"
        $cat <<EOM
<sys/sockio.h> not found, assuming socket ioctls are in <sys/ioctl.h>.
EOM
fi
set i_syssockio
eval $setvar


: see if this is a syslog.h system
set syslog.h i_syslog
eval $inhdr


: see if this is a sys/mode.h system
set sys/mode.h i_sysmode
eval $inhdr

: see if sys/resource.h has to be included
set sys/resource.h i_sysresrc
eval $inhdr

: see if sys/security.h is available
set sys/security.h i_syssecrt
eval $inhdr

: see if this is a sys/statvfs.h system
set sys/statvfs.h i_sysstatvfs
eval $inhdr

: see if this is a sys/un.h system
set sys/un.h i_sysun
eval $inhdr


: see if this is a sys/utsname.h system
set sys/utsname.h i_sysutsname
eval $inhdr

: see if this is a syswait system
set sys/wait.h i_syswait
eval $inhdr

: see if this is a ustat.h system
set ustat.h i_ustat
eval $inhdr

: see if this is an utime system
set utime.h i_utime
eval $inhdr

: see if this is a values.h system
set values.h i_values
eval $inhdr

: see if this is a vfork system
case "$d_vfork" in
"$define")
        set vfork.h i_vfork
        eval $inhdr
        ;;
*)
        i_vfork="$undef"
        ;;
esac

: see if gdbm.h is available
set gdbm.h t_gdbm
eval $inhdr
case "$t_gdbm" in
$define)
        : see if gdbm_open exists
        set gdbm_open d_gdbm_open
        eval $inlibc
        case "$d_gdbm_open" in
        $undef)
                t_gdbm="$undef"
                echo "We won't be including <gdbm.h>"
                ;;
        esac
        ;;
esac
val="$t_gdbm"
set i_gdbm
eval $setvar

echo " "
echo "Looking for extensions..." >&4
: If we are using the old config.sh, known_extensions may contain
: old or inaccurate or duplicate values.
known_extensions=''
nonxs_extensions=''
: We do not use find because it might not be available.
: We do not just use MANIFEST because the user may have dropped
: some additional extensions into the source tree and expect them
: to be built.

: Function to recursively find available extensions, ignoring DynaLoader
: NOTE: recursion limit of 10 to prevent runaway in case of symlink madness
find_extensions='
    for xxx in *; do
       case "$xxx" in
           DynaLoader|dynaload) ;;
           *)
           if $test -f $xxx/$xxx.xs; then
               known_extensions="$known_extensions $1$xxx";
           elif $test -f $xxx/Makefile.PL; then
               nonxs_extensions="$nonxs_extensions $1$xxx";
           else
               if $test -d $xxx -a $# -lt 10; then
                   set $1$xxx/ $*;
                   cd "$xxx";
                   eval $find_extensions;
                   cd ..;
                   shift;
               fi;
           fi
           ;;
       esac;
    done'
tdir=`pwd`
cd "$rsrc/ext"
set X
shift
eval $find_extensions
# Special case:  Add in threads/shared since it is not picked up by the
# recursive find above (and adding in general recursive finding breaks
# SDBM_File/sdbm).  A.D.  10/25/2001.
known_extensions="$known_extensions threads/shared"
set X $nonxs_extensions
shift
nonxs_extensions="$*"
set X $known_extensions
shift
known_extensions="$*"
cd "$tdir"

: Now see which are supported on this system.
avail_ext=''
for xxx in $known_extensions ; do
        case "$xxx" in
        DB_File|db_file)
                case "$i_db" in
                $define) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        GDBM_File|gdbm_fil)
                case "$i_gdbm" in
                $define) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        I18N/Langinfo|i18n_lan)
                case "$i_langinfo$d_nl_langinfo" in
                $define$define) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        NDBM_File|ndbm_fil)
                case "$i_ndbm" in
                $define)
                    case "$osname-$use64bitint" in
                    hpux-define)
                        case "$libs" in
                        *-lndbm*) avail_ext="$avail_ext $xxx" ;;
                        esac
                        ;;
                    *) avail_ext="$avail_ext $xxx" ;;
                    esac
                    ;;
                esac
                ;;
        ODBM_File|odbm_fil)
                case "${i_dbm}${i_rpcsvcdbm}" in
                *"${define}"*)
                    case "$osname-$use64bitint" in
                    hpux-define)
                        case "$libs" in
                        *-ldbm*) avail_ext="$avail_ext $xxx" ;;
                        esac
                        ;;
                    *) avail_ext="$avail_ext $xxx" ;;
                    esac
                    ;;
                esac
                ;;
        POSIX|posix)
                case "$useposix" in
                true|define|y) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        Opcode|opcode)
                case "$useopcode" in
                true|define|y) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        Socket|socket)
                case "$d_socket" in
                true|$define|y)
                    case "$osname" in
                    beos) ;; # not unless BONE
                    *) avail_ext="$avail_ext $xxx" ;;
                    esac
                    ;;
                esac
                ;;
        Sys/Syslog|sys/syslog)
                : XXX syslog requires socket
                case "$d_socket" in
                true|$define|y) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        Thread|thread)
                case "$usethreads" in
                true|$define|y)
                        case "$useithreads" in
                        $undef|false|[nN]*) avail_ext="$avail_ext $xxx" ;;
                        esac
                esac
                ;;
        XS/APItest|xs/apitest)
                # This is just for testing.  Skip it unless we have dynamic loading.

                case "$usedl" in
                $define) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        XS/Typemap|xs/typemap)
                # This is just for testing.  Skip it unless we have dynamic loading.
                case "$usedl" in
                $define) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        threads|threads/shared)
                # threads and threads::shared are special cases.
                # To stop people from asking "Perl 5.8.0 was supposed
                # to have this new fancy threads implementation but my
                # perl doesn't have it" and from people trying to
                # (re)install the threads module using CPAN.pm and
                # CPAN.pm then offering to reinstall Perl 5.8.0,
                # the threads.pm and threads/shared.pm will always be
                # there, croaking informatively ("you need to rebuild
                # all of Perl with threads, sorry") when threads haven't
                # been compiled in.
                # --jhi
                avail_ext="$avail_ext $xxx"
                ;;
        IPC/SysV|ipc/sysv)
                : XXX Do we need a useipcsysv variable here
                case "${d_msg}${d_sem}${d_shm}" in
                *"${define}"*) avail_ext="$avail_ext $xxx" ;;
                esac
                ;;
        *)      avail_ext="$avail_ext $xxx"
                ;;
        esac
done

set X $avail_ext
shift
avail_ext="$*"

case "$onlyextensions" in
'') ;;
*)  keepextensions=''
    echo "You have requested that only certains extensions be included..." >&4
    for i in $onlyextensions; do
        case " $avail_ext " in
        *" $i "*)
            echo "Keeping extension $i."
            keepextensions="$keepextensions $i"
            ;;
        *) echo "Ignoring extension $i." ;;
        esac
    done
    avail_ext="$keepextensions"
    ;;
esac

case "$noextensions" in
'') ;;
*)  keepextensions=''
    echo "You have requested that certain extensions be ignored..." >&4
    for i in $avail_ext; do
        case " $noextensions " in
        *" $i "*) echo "Ignoring extension $i." ;;
        *) echo "Keeping extension $i.";
           keepextensions="$keepextensions $i"
           ;;
        esac
    done
    avail_ext="$keepextensions"
    ;;
esac

: Now see which nonxs extensions are supported on this system.
: For now assume all are.
nonxs_ext=''
for xxx in $nonxs_extensions ; do
        case "$xxx" in
        *)      nonxs_ext="$nonxs_ext $xxx"
                ;;
        esac
done

set X $nonxs_ext
shift
nonxs_ext="$*"

case $usedl in
$define)
        $cat <<EOM
A number of extensions are supplied with $package.  You may choose to
compile these extensions for dynamic loading (the default), compile
them into the $package executable (static loading), or not include
them at all.  Answer "none" to include no extensions.
Note that DynaLoader is always built and need not be mentioned here.

EOM
        case "$dynamic_ext" in
        '')
                : Exclude those listed in static_ext
                dflt=''
                for xxx in $avail_ext; do
                        case " $static_ext " in
                        *" $xxx "*) ;;
                        *) dflt="$dflt $xxx" ;;
                        esac
                done
                set X $dflt
                shift
                dflt="$*"
                ;;
        *)      dflt="$dynamic_ext"
                # Perhaps we are reusing an old out-of-date config.sh.
                case "$hint" in
                previous)
                        if test X"$dynamic_ext" != X"$avail_ext"; then
                                $cat <<EOM
NOTICE:  Your previous config.sh list may be incorrect.
The extensions now available to you are
        ${avail_ext}
but the default list from your previous config.sh is
        ${dynamic_ext}

EOM
                        fi
                        ;;
                esac
                ;;
        esac
        case "$dflt" in
        '')     dflt=none;;
        esac
        rp="What extensions do you wish to load dynamically?"
        . ./myread
        case "$ans" in
        none) dynamic_ext=' ' ;;
        *) dynamic_ext="$ans" ;;
        esac

        case "$static_ext" in
        '')
                : Exclude those already listed in dynamic linking
                dflt=''
                for xxx in $avail_ext; do
                        case " $dynamic_ext " in
                        *" $xxx "*) ;;
                        *) dflt="$dflt $xxx" ;;
                        esac
                done
                set X $dflt
                shift
                dflt="$*"
                ;;
        *)  dflt="$static_ext"
                ;;
        esac

        case "$dflt" in
        '')     dflt=none;;
        esac
        rp="What extensions do you wish to load statically?"
        . ./myread
        case "$ans" in
        none) static_ext=' ' ;;
        *) static_ext="$ans" ;;
        esac
        ;;
*)
        $cat <<EOM
A number of extensions are supplied with $package.  Answer "none"
to include no extensions.
Note that DynaLoader is always built and need not be mentioned here.

EOM
        case "$static_ext" in
        '') dflt="$avail_ext" ;;
        *)      dflt="$static_ext"
                # Perhaps we are reusing an old out-of-date config.sh.
                case "$hint" in
                previous)
                        if test X"$static_ext" != X"$avail_ext"; then
                                $cat <<EOM
NOTICE:  Your previous config.sh list may be incorrect.
The extensions now available to you are
        ${avail_ext}
but the default list from your previous config.sh is
        ${static_ext}

EOM
                        fi
                        ;;
                esac
                ;;
        esac
        : Exclude those that are not xs extensions
        case "$dflt" in
        '')     dflt=none;;
        esac
        rp="What extensions do you wish to include?"
        . ./myread
        case "$ans" in
        none) static_ext=' ' ;;
        *) static_ext="$ans" ;;
        esac
        ;;
esac
#
# Encode is a special case.  If we are building Encode as a static
# extension, we need to explicitly list its subextensions as well.
# For other nested extensions, this is handled automatically by
# the appropriate Makefile.PL.
case " $static_ext " in
        *" Encode "*) # Add the subextensions of Encode
        cd "$rsrc/ext"
        for xxx in `ls Encode/*/Makefile.PL|awk -F/ '{print $2}'`; do
                static_ext="$static_ext Encode/$xxx"
        done
        cd "$tdir"
        ;;
esac

set X $dynamic_ext $static_ext $nonxs_ext
shift
extensions="$*"

# Sanity check:  We require an extension suitable for use with
# AnyDBM_File, as well as Fcntl and IO.  (Failure to have these
# should show up as failures in the test suite, but it's helpful to
# catch them now.) The 'extensions' list is normally sorted
# alphabetically, so we need to accept either
#    DB_File ... Fcntl ... IO  ....
# or something like
#    Fcntl ... NDBM_File ... IO  ....
case " $extensions"  in
*"_File "*" Fcntl "*" IO "*) ;; # DB_File
*" Fcntl "*"_File "*" IO "*) ;; # GDBM_File
*" Fcntl "*" IO "*"_File "*) ;; # NDBM_File
*) echo "WARNING: Extensions DB_File or *DBM_File, Fcntl, and IO not configured." >&4
   echo "WARNING: The Perl you are building will be quite crippled." >& 4
   ;;
esac

: Remove libraries needed only for extensions
: The appropriate ext/Foo/Makefile.PL will add them back in, if necessary.
: The exception is SunOS 4.x, which needs them.
case "${osname}X${osvers}" in
sunos*X4*)
    perllibs="$libs"
    ;;
*) case "$usedl" in
    $define|true|[yY]*)
            set X `echo " $libs " | sed -e 's@ -lndbm @ @' -e 's@ -lgdbm @ @' -e 's@ -ldbm @ @' -e 's@ -ldb @ @'`
            shift
            perllibs="$*"
            ;;
    *)  perllibs="$libs"
            ;;
    esac
    ;;
esac

: Remove build directory name from cppstdin so it can be used from
: either the present location or the final installed location.
echo " "
: Get out of the UU directory to get correct path name.
cd ..
case "$cppstdin" in
`pwd`/cppstdin)
        echo "Stripping down cppstdin path name"
        cppstdin=cppstdin
        ;;
esac
cd UU

: end of configuration questions
echo " "
echo "End of configuration questions."
echo " "

: back to where it started
if test -d ../UU; then
        cd ..
fi

: configuration may be patched via a 'config.arch' file
if $test -f config.arch; then
        echo "I see a config.arch file, loading it."
        . ./config.arch
fi

: configuration may be patched via a 'config.over' file
if $test -f config.over; then
        echo " "
        dflt=y
        rp='I see a config.over file.  Do you wish to load it?'
        . UU/myread
        case "$ans" in
        n*) echo "OK, I'll ignore it.";;
        *)      . ./config.over
                echo "Configuration override changes have been loaded."
                ;;
        esac
fi

: in case they want portability, strip down executable paths
case "$d_portable" in
"$define")
        echo " "
        echo "Stripping down executable paths..." >&4
        for file in $loclist $trylist; do
                eval temp=\$$file
                eval $file=`basename $temp`
        done
        ;;
esac

: create config.sh file
echo " "
echo "Creating config.sh..." >&4
$spitshell <<EOT >config.sh
$startsh
#
# This file was produced by running the Configure script. It holds all the
# definitions figured out by Configure. Should you modify one of these values,
# do not forget to propagate your changes by running "Configure -der". You may
# instead choose to run each of the .SH files by yourself, or "Configure -S".
#

# Package name      : $package
# Source directory  : $src
# Configuration time: $cf_time
# Configured by     : $cf_by
# Target system     : $myuname

Author='$Author'
Date='$Date'
Header='$Header'
Id='$Id'
Locker='$Locker'
Log='$Log'
Mcc='$Mcc'
RCSfile='$RCSfile'
Revision='$Revision'
Source='$Source'
State='$State'
_a='$_a'
_exe='$_exe'
_o='$_o'
afs='$afs'
afsroot='$afsroot'
alignbytes='$alignbytes'
ansi2knr='$ansi2knr'
aphostname='$aphostname'
api_revision='$api_revision'
api_subversion='$api_subversion'
api_version='$api_version'
api_versionstring='$api_versionstring'
ar='$ar'
archlib='$archlib'
archlibexp='$archlibexp'
archname64='$archname64'
archname='$archname'
archobjs='$archobjs'
asctime_r_proto='$asctime_r_proto'
awk='$awk'
baserev='$baserev'
bash='$bash'
bin='$bin'
binexp='$binexp'
bison='$bison'
byacc='$byacc'
byteorder='$byteorder'
c='$c'
castflags='$castflags'
cat='$cat'
cc='$cc'
cccdlflags='$cccdlflags'
ccdlflags='$ccdlflags'
ccflags='$ccflags'
ccflags_uselargefiles='$ccflags_uselargefiles'
ccname='$ccname'
ccsymbols='$ccsymbols'
ccversion='$ccversion'
cf_by='$cf_by'
cf_email='$cf_email'
cf_time='$cf_time'
charsize='$charsize'
chgrp='$chgrp'
chmod='$chmod'
chown='$chown'
clocktype='$clocktype'
comm='$comm'
compress='$compress'
contains='$contains'
cp='$cp'
cpio='$cpio'
cpp='$cpp'
cpp_stuff='$cpp_stuff'
cppccsymbols='$cppccsymbols'
cppflags='$cppflags'
cpplast='$cpplast'
cppminus='$cppminus'
cpprun='$cpprun'
cppstdin='$cppstdin'
cppsymbols='$cppsymbols'
crypt_r_proto='$crypt_r_proto'
cryptlib='$cryptlib'
csh='$csh'
ctermid_r_proto='$ctermid_r_proto'
ctime_r_proto='$ctime_r_proto'
d_Gconvert='$d_Gconvert'
d_PRIEUldbl='$d_PRIEUldbl'
d_PRIFUldbl='$d_PRIFUldbl'
d_PRIGUldbl='$d_PRIGUldbl'
d_PRIXU64='$d_PRIXU64'
d_PRId64='$d_PRId64'
d_PRIeldbl='$d_PRIeldbl'
d_PRIfldbl='$d_PRIfldbl'
d_PRIgldbl='$d_PRIgldbl'
d_PRIi64='$d_PRIi64'
d_PRIo64='$d_PRIo64'
d_PRIu64='$d_PRIu64'
d_PRIx64='$d_PRIx64'
d_SCNfldbl='$d_SCNfldbl'
d__fwalk='$d__fwalk'
d_access='$d_access'
d_accessx='$d_accessx'
d_aintl='$d_aintl'
d_alarm='$d_alarm'
d_archlib='$d_archlib'
d_asctime_r='$d_asctime_r'
d_atolf='$d_atolf'
d_atoll='$d_atoll'
d_attribut='$d_attribut'
d_bcmp='$d_bcmp'
d_bcopy='$d_bcopy'
d_bsd='$d_bsd'
d_bsdgetpgrp='$d_bsdgetpgrp'
d_bsdsetpgrp='$d_bsdsetpgrp'
d_bzero='$d_bzero'
d_casti32='$d_casti32'
d_castneg='$d_castneg'
d_charvspr='$d_charvspr'
d_chown='$d_chown'
d_chroot='$d_chroot'
d_chsize='$d_chsize'
d_class='$d_class'
d_closedir='$d_closedir'
d_cmsghdr_s='$d_cmsghdr_s'
d_const='$d_const'
d_copysignl='$d_copysignl'
d_crypt='$d_crypt'
d_crypt_r='$d_crypt_r'
d_csh='$d_csh'
d_ctermid_r='$d_ctermid_r'
d_ctime_r='$d_ctime_r'
d_cuserid='$d_cuserid'
d_dbl_dig='$d_dbl_dig'
d_dbminitproto='$d_dbminitproto'
d_difftime='$d_difftime'
d_dirfd='$d_dirfd'
d_dirnamlen='$d_dirnamlen'
d_dlerror='$d_dlerror'
d_dlopen='$d_dlopen'
d_dlsymun='$d_dlsymun'
d_dosuid='$d_dosuid'
d_drand48_r='$d_drand48_r'
d_drand48proto='$d_drand48proto'
d_dup2='$d_dup2'
d_eaccess='$d_eaccess'
d_endgrent='$d_endgrent'
d_endgrent_r='$d_endgrent_r'
d_endhent='$d_endhent'
d_endhostent_r='$d_endhostent_r'
d_endnent='$d_endnent'
d_endnetent_r='$d_endnetent_r'
d_endpent='$d_endpent'
d_endprotoent_r='$d_endprotoent_r'
d_endpwent='$d_endpwent'
d_endpwent_r='$d_endpwent_r'
d_endsent='$d_endsent'
d_endservent_r='$d_endservent_r'
d_eofnblk='$d_eofnblk'
d_eunice='$d_eunice'
d_faststdio='$d_faststdio'
d_fchdir='$d_fchdir'
d_fchmod='$d_fchmod'
d_fchown='$d_fchown'
d_fcntl='$d_fcntl'
d_fcntl_can_lock='$d_fcntl_can_lock'
d_fd_macros='$d_fd_macros'
d_fd_set='$d_fd_set'
d_fds_bits='$d_fds_bits'
d_fgetpos='$d_fgetpos'
d_finite='$d_finite'
d_finitel='$d_finitel'
d_flexfnam='$d_flexfnam'
d_flock='$d_flock'
d_flockproto='$d_flockproto'
d_fork='$d_fork'
d_fp_class='$d_fp_class'
d_fpathconf='$d_fpathconf'
d_fpclass='$d_fpclass'
d_fpclassify='$d_fpclassify'
d_fpclassl='$d_fpclassl'
d_fpos64_t='$d_fpos64_t'
d_frexpl='$d_frexpl'
d_fs_data_s='$d_fs_data_s'
d_fseeko='$d_fseeko'
d_fsetpos='$d_fsetpos'
d_fstatfs='$d_fstatfs'
d_fstatvfs='$d_fstatvfs'
d_fsync='$d_fsync'
d_ftello='$d_ftello'
d_ftime='$d_ftime'
d_getcwd='$d_getcwd'
d_getespwnam='$d_getespwnam'
d_getfsstat='$d_getfsstat'
d_getgrent='$d_getgrent'
d_getgrent_r='$d_getgrent_r'
d_getgrgid_r='$d_getgrgid_r'
d_getgrnam_r='$d_getgrnam_r'
d_getgrps='$d_getgrps'
d_gethbyaddr='$d_gethbyaddr'
d_gethbyname='$d_gethbyname'
d_gethent='$d_gethent'
d_gethname='$d_gethname'
d_gethostbyaddr_r='$d_gethostbyaddr_r'
d_gethostbyname_r='$d_gethostbyname_r'
d_gethostent_r='$d_gethostent_r'
d_gethostprotos='$d_gethostprotos'
d_getitimer='$d_getitimer'
d_getlogin='$d_getlogin'
d_getlogin_r='$d_getlogin_r'
d_getmnt='$d_getmnt'
d_getmntent='$d_getmntent'
d_getnbyaddr='$d_getnbyaddr'
d_getnbyname='$d_getnbyname'
d_getnent='$d_getnent'
d_getnetbyaddr_r='$d_getnetbyaddr_r'
d_getnetbyname_r='$d_getnetbyname_r'
d_getnetent_r='$d_getnetent_r'
d_getnetprotos='$d_getnetprotos'
d_getpagsz='$d_getpagsz'
d_getpbyname='$d_getpbyname'
d_getpbynumber='$d_getpbynumber'
d_getpent='$d_getpent'
d_getpgid='$d_getpgid'
d_getpgrp2='$d_getpgrp2'
d_getpgrp='$d_getpgrp'
d_getppid='$d_getppid'
d_getprior='$d_getprior'
d_getprotobyname_r='$d_getprotobyname_r'
d_getprotobynumber_r='$d_getprotobynumber_r'
d_getprotoent_r='$d_getprotoent_r'
d_getprotoprotos='$d_getprotoprotos'
d_getprpwnam='$d_getprpwnam'
d_getpwent='$d_getpwent'
d_getpwent_r='$d_getpwent_r'
d_getpwnam_r='$d_getpwnam_r'
d_getpwuid_r='$d_getpwuid_r'
d_getsbyname='$d_getsbyname'
d_getsbyport='$d_getsbyport'
d_getsent='$d_getsent'
d_getservbyname_r='$d_getservbyname_r'
d_getservbyport_r='$d_getservbyport_r'
d_getservent_r='$d_getservent_r'
d_getservprotos='$d_getservprotos'
d_getspnam='$d_getspnam'
d_getspnam_r='$d_getspnam_r'
d_gettimeod='$d_gettimeod'
d_gmtime_r='$d_gmtime_r'
d_gnulibc='$d_gnulibc'
d_grpasswd='$d_grpasswd'
d_hasmntopt='$d_hasmntopt'
d_htonl='$d_htonl'
d_ilogbl='$d_ilogbl'
d_index='$d_index'
d_inetaton='$d_inetaton'
d_int64_t='$d_int64_t'
d_isascii='$d_isascii'
d_isfinite='$d_isfinite'
d_isinf='$d_isinf'
d_isnan='$d_isnan'
d_isnanl='$d_isnanl'
d_killpg='$d_killpg'
d_lchown='$d_lchown'
d_ldbl_dig='$d_ldbl_dig'
d_link='$d_link'
d_localtime_r='$d_localtime_r'
d_locconv='$d_locconv'
d_lockf='$d_lockf'
d_longdbl='$d_longdbl'
d_longlong='$d_longlong'
d_lseekproto='$d_lseekproto'
d_lstat='$d_lstat'
d_madvise='$d_madvise'
d_mblen='$d_mblen'
d_mbstowcs='$d_mbstowcs'
d_mbtowc='$d_mbtowc'
d_memchr='$d_memchr'
d_memcmp='$d_memcmp'
d_memcpy='$d_memcpy'
d_memmove='$d_memmove'
d_memset='$d_memset'
d_mkdir='$d_mkdir'
d_mkdtemp='$d_mkdtemp'
d_mkfifo='$d_mkfifo'
d_mkstemp='$d_mkstemp'
d_mkstemps='$d_mkstemps'
d_mktime='$d_mktime'
d_mmap='$d_mmap'
d_modfl='$d_modfl'
d_modfl_pow32_bug='$d_modfl_pow32_bug'
d_modflproto='$d_modflproto'
d_mprotect='$d_mprotect'
d_msg='$d_msg'
d_msg_ctrunc='$d_msg_ctrunc'
d_msg_dontroute='$d_msg_dontroute'
d_msg_oob='$d_msg_oob'
d_msg_peek='$d_msg_peek'
d_msg_proxy='$d_msg_proxy'
d_msgctl='$d_msgctl'
d_msgget='$d_msgget'
d_msghdr_s='$d_msghdr_s'
d_msgrcv='$d_msgrcv'
d_msgsnd='$d_msgsnd'
d_msync='$d_msync'
d_munmap='$d_munmap'
d_mymalloc='$d_mymalloc'
d_nice='$d_nice'
d_nl_langinfo='$d_nl_langinfo'
d_nv_preserves_uv='$d_nv_preserves_uv'
d_off64_t='$d_off64_t'
d_old_pthread_create_joinable='$d_old_pthread_create_joinable'
d_oldpthreads='$d_oldpthreads'
d_oldsock='$d_oldsock'
d_open3='$d_open3'
d_pathconf='$d_pathconf'
d_pause='$d_pause'
d_perl_otherlibdirs='$d_perl_otherlibdirs'
d_phostname='$d_phostname'
d_pipe='$d_pipe'
d_poll='$d_poll'
d_portable='$d_portable'
d_procselfexe='$d_procselfexe'
d_pthread_atfork='$d_pthread_atfork'
d_pthread_attr_setscope='$d_pthread_attr_setscope'
d_pthread_yield='$d_pthread_yield'
d_pwage='$d_pwage'
d_pwchange='$d_pwchange'
d_pwclass='$d_pwclass'
d_pwcomment='$d_pwcomment'
d_pwexpire='$d_pwexpire'
d_pwgecos='$d_pwgecos'
d_pwpasswd='$d_pwpasswd'
d_pwquota='$d_pwquota'
d_qgcvt='$d_qgcvt'
d_quad='$d_quad'
d_random_r='$d_random_r'
d_readdir64_r='$d_readdir64_r'
d_readdir='$d_readdir'
d_readdir_r='$d_readdir_r'
d_readlink='$d_readlink'
d_readv='$d_readv'
d_recvmsg='$d_recvmsg'
d_rename='$d_rename'
d_rewinddir='$d_rewinddir'
d_rmdir='$d_rmdir'
d_safebcpy='$d_safebcpy'
d_safemcpy='$d_safemcpy'
d_sanemcmp='$d_sanemcmp'
d_sbrkproto='$d_sbrkproto'
d_scalbnl='$d_scalbnl'
d_sched_yield='$d_sched_yield'
d_scm_rights='$d_scm_rights'
d_seekdir='$d_seekdir'
d_select='$d_select'
d_sem='$d_sem'
d_semctl='$d_semctl'
d_semctl_semid_ds='$d_semctl_semid_ds'
d_semctl_semun='$d_semctl_semun'
d_semget='$d_semget'
d_semop='$d_semop'
d_sendmsg='$d_sendmsg'
d_setegid='$d_setegid'
d_seteuid='$d_seteuid'
d_setgrent='$d_setgrent'
d_setgrent_r='$d_setgrent_r'
d_setgrps='$d_setgrps'
d_sethent='$d_sethent'
d_sethostent_r='$d_sethostent_r'
d_setitimer='$d_setitimer'
d_setlinebuf='$d_setlinebuf'
d_setlocale='$d_setlocale'
d_setlocale_r='$d_setlocale_r'
d_setnent='$d_setnent'
d_setnetent_r='$d_setnetent_r'
d_setpent='$d_setpent'
d_setpgid='$d_setpgid'
d_setpgrp2='$d_setpgrp2'
d_setpgrp='$d_setpgrp'
d_setprior='$d_setprior'
d_setproctitle='$d_setproctitle'
d_setprotoent_r='$d_setprotoent_r'
d_setpwent='$d_setpwent'
d_setpwent_r='$d_setpwent_r'
d_setregid='$d_setregid'
d_setresgid='$d_setresgid'
d_setresuid='$d_setresuid'
d_setreuid='$d_setreuid'
d_setrgid='$d_setrgid'
d_setruid='$d_setruid'
d_setsent='$d_setsent'
d_setservent_r='$d_setservent_r'
d_setsid='$d_setsid'
d_setvbuf='$d_setvbuf'
d_sfio='$d_sfio'
d_shm='$d_shm'
d_shmat='$d_shmat'
d_shmatprototype='$d_shmatprototype'
d_shmctl='$d_shmctl'
d_shmdt='$d_shmdt'
d_shmget='$d_shmget'
d_sigaction='$d_sigaction'
d_sigprocmask='$d_sigprocmask'
d_sigsetjmp='$d_sigsetjmp'
d_sockatmark='$d_sockatmark'
d_sockatmarkproto='$d_sockatmarkproto'
d_socket='$d_socket'
d_socklen_t='$d_socklen_t'
d_sockpair='$d_sockpair'
d_socks5_init='$d_socks5_init'
d_sqrtl='$d_sqrtl'
d_srand48_r='$d_srand48_r'
d_srandom_r='$d_srandom_r'
d_sresgproto='$d_sresgproto'
d_sresuproto='$d_sresuproto'
d_statblks='$d_statblks'
d_statfs_f_flags='$d_statfs_f_flags'
d_statfs_s='$d_statfs_s'
d_statvfs='$d_statvfs'
d_stdio_cnt_lval='$d_stdio_cnt_lval'
d_stdio_ptr_lval='$d_stdio_ptr_lval'
d_stdio_ptr_lval_nochange_cnt='$d_stdio_ptr_lval_nochange_cnt'
d_stdio_ptr_lval_sets_cnt='$d_stdio_ptr_lval_sets_cnt'
d_stdio_stream_array='$d_stdio_stream_array'
d_stdiobase='$d_stdiobase'
d_stdstdio='$d_stdstdio'
d_strchr='$d_strchr'
d_strcoll='$d_strcoll'
d_strctcpy='$d_strctcpy'
d_strerrm='$d_strerrm'
d_strerror='$d_strerror'
d_strerror_r='$d_strerror_r'
d_strftime='$d_strftime'
d_strtod='$d_strtod'
d_strtol='$d_strtol'
d_strtold='$d_strtold'
d_strtoll='$d_strtoll'
d_strtoq='$d_strtoq'
d_strtoul='$d_strtoul'
d_strtoull='$d_strtoull'
d_strtouq='$d_strtouq'
d_strxfrm='$d_strxfrm'
d_suidsafe='$d_suidsafe'
d_symlink='$d_symlink'
d_syscall='$d_syscall'
d_syscallproto='$d_syscallproto'
d_sysconf='$d_sysconf'
d_sysernlst='$d_sysernlst'
d_syserrlst='$d_syserrlst'
d_system='$d_system'
d_tcgetpgrp='$d_tcgetpgrp'
d_tcsetpgrp='$d_tcsetpgrp'
d_telldir='$d_telldir'
d_telldirproto='$d_telldirproto'
d_time='$d_time'
d_times='$d_times'
d_tm_tm_gmtoff='$d_tm_tm_gmtoff'
d_tm_tm_zone='$d_tm_tm_zone'
d_tmpnam_r='$d_tmpnam_r'
d_truncate='$d_truncate'
d_ttyname_r='$d_ttyname_r'
d_tzname='$d_tzname'
d_u32align='$d_u32align'
d_ualarm='$d_ualarm'
d_umask='$d_umask'
d_uname='$d_uname'
d_union_semun='$d_union_semun'
d_unordered='$d_unordered'
d_usleep='$d_usleep'
d_usleepproto='$d_usleepproto'
d_ustat='$d_ustat'
d_vendorarch='$d_vendorarch'
d_vendorbin='$d_vendorbin'
d_vendorlib='$d_vendorlib'
d_vendorscript='$d_vendorscript'
d_vfork='$d_vfork'
d_void_closedir='$d_void_closedir'
d_voidsig='$d_voidsig'
d_voidtty='$d_voidtty'
d_volatile='$d_volatile'
d_vprintf='$d_vprintf'
d_wait4='$d_wait4'
d_waitpid='$d_waitpid'
d_wcstombs='$d_wcstombs'
d_wctomb='$d_wctomb'
d_writev='$d_writev'
d_xenix='$d_xenix'
date='$date'
db_hashtype='$db_hashtype'
db_prefixtype='$db_prefixtype'
db_version_major='$db_version_major'
db_version_minor='$db_version_minor'
db_version_patch='$db_version_patch'
defvoidused='$defvoidused'
direntrytype='$direntrytype'
dlext='$dlext'
dlsrc='$dlsrc'
doublesize='$doublesize'
drand01='$drand01'
drand48_r_proto='$drand48_r_proto'
dynamic_ext='$dynamic_ext'
eagain='$eagain'
ebcdic='$ebcdic'
echo='$echo'
egrep='$egrep'
emacs='$emacs'
endgrent_r_proto='$endgrent_r_proto'
endhostent_r_proto='$endhostent_r_proto'
endnetent_r_proto='$endnetent_r_proto'
endprotoent_r_proto='$endprotoent_r_proto'
endpwent_r_proto='$endpwent_r_proto'
endservent_r_proto='$endservent_r_proto'
eunicefix='$eunicefix'
exe_ext='$exe_ext'
expr='$expr'
extensions='$extensions'
extras='$extras'
fflushNULL='$fflushNULL'
fflushall='$fflushall'
find='$find'
firstmakefile='$firstmakefile'
flex='$flex'
fpossize='$fpossize'
fpostype='$fpostype'
freetype='$freetype'
from='$from'
full_ar='$full_ar'
full_csh='$full_csh'
full_sed='$full_sed'
gccansipedantic='$gccansipedantic'
gccosandvers='$gccosandvers'
gccversion='$gccversion'
getgrent_r_proto='$getgrent_r_proto'
getgrgid_r_proto='$getgrgid_r_proto'
getgrnam_r_proto='$getgrnam_r_proto'
gethostbyaddr_r_proto='$gethostbyaddr_r_proto'
gethostbyname_r_proto='$gethostbyname_r_proto'
gethostent_r_proto='$gethostent_r_proto'
getlogin_r_proto='$getlogin_r_proto'
getnetbyaddr_r_proto='$getnetbyaddr_r_proto'
getnetbyname_r_proto='$getnetbyname_r_proto'
getnetent_r_proto='$getnetent_r_proto'
getprotobyname_r_proto='$getprotobyname_r_proto'
getprotobynumber_r_proto='$getprotobynumber_r_proto'
getprotoent_r_proto='$getprotoent_r_proto'
getpwent_r_proto='$getpwent_r_proto'
getpwnam_r_proto='$getpwnam_r_proto'
getpwuid_r_proto='$getpwuid_r_proto'
getservbyname_r_proto='$getservbyname_r_proto'
getservbyport_r_proto='$getservbyport_r_proto'
getservent_r_proto='$getservent_r_proto'
getspnam_r_proto='$getspnam_r_proto'
gidformat='$gidformat'
gidsign='$gidsign'
gidsize='$gidsize'
gidtype='$gidtype'
glibpth='$glibpth'
gmake='$gmake'
gmtime_r_proto='$gmtime_r_proto'
gnulibc_version='$gnulibc_version'
grep='$grep'
groupcat='$groupcat'
groupstype='$groupstype'
gzip='$gzip'
h_fcntl='$h_fcntl'
h_sysfile='$h_sysfile'
hint='$hint'
hostcat='$hostcat'
html1dir='$html1dir'
html1direxp='$html1direxp'
html3dir='$html3dir'
html3direxp='$html3direxp'
i16size='$i16size'
i16type='$i16type'
i32size='$i32size'
i32type='$i32type'
i64size='$i64size'
i64type='$i64type'
i8size='$i8size'
i8type='$i8type'
i_arpainet='$i_arpainet'
i_bsdioctl='$i_bsdioctl'
i_crypt='$i_crypt'
i_db='$i_db'
i_dbm='$i_dbm'
i_dirent='$i_dirent'
i_dld='$i_dld'
i_dlfcn='$i_dlfcn'
i_fcntl='$i_fcntl'
i_float='$i_float'
i_fp='$i_fp'
i_fp_class='$i_fp_class'
i_gdbm='$i_gdbm'
i_grp='$i_grp'
i_ieeefp='$i_ieeefp'
i_inttypes='$i_inttypes'
i_langinfo='$i_langinfo'
i_libutil='$i_libutil'
i_limits='$i_limits'
i_locale='$i_locale'
i_machcthr='$i_machcthr'
i_malloc='$i_malloc'
i_math='$i_math'
i_memory='$i_memory'
i_mntent='$i_mntent'
i_ndbm='$i_ndbm'
i_netdb='$i_netdb'
i_neterrno='$i_neterrno'
i_netinettcp='$i_netinettcp'
i_niin='$i_niin'
i_poll='$i_poll'
i_prot='$i_prot'
i_pthread='$i_pthread'
i_pwd='$i_pwd'
i_rpcsvcdbm='$i_rpcsvcdbm'
i_sfio='$i_sfio'
i_sgtty='$i_sgtty'
i_shadow='$i_shadow'
i_socks='$i_socks'
i_stdarg='$i_stdarg'
i_stddef='$i_stddef'
i_stdlib='$i_stdlib'
i_string='$i_string'
i_sunmath='$i_sunmath'
i_sysaccess='$i_sysaccess'
i_sysdir='$i_sysdir'
i_sysfile='$i_sysfile'
i_sysfilio='$i_sysfilio'
i_sysin='$i_sysin'
i_sysioctl='$i_sysioctl'
i_syslog='$i_syslog'
i_sysmman='$i_sysmman'
i_sysmode='$i_sysmode'
i_sysmount='$i_sysmount'
i_sysndir='$i_sysndir'
i_sysparam='$i_sysparam'
i_sysresrc='$i_sysresrc'
i_syssecrt='$i_syssecrt'
i_sysselct='$i_sysselct'
i_syssockio='$i_syssockio'
i_sysstat='$i_sysstat'
i_sysstatfs='$i_sysstatfs'
i_sysstatvfs='$i_sysstatvfs'
i_systime='$i_systime'
i_systimek='$i_systimek'
i_systimes='$i_systimes'
i_systypes='$i_systypes'
i_sysuio='$i_sysuio'
i_sysun='$i_sysun'
i_sysutsname='$i_sysutsname'
i_sysvfs='$i_sysvfs'
i_syswait='$i_syswait'
i_termio='$i_termio'
i_termios='$i_termios'
i_time='$i_time'
i_unistd='$i_unistd'
i_ustat='$i_ustat'
i_utime='$i_utime'
i_values='$i_values'
i_varargs='$i_varargs'
i_varhdr='$i_varhdr'
i_vfork='$i_vfork'
ignore_versioned_solibs='$ignore_versioned_solibs'
inc_version_list='$inc_version_list'
inc_version_list_init='$inc_version_list_init'
incpath='$incpath'
inews='$inews'
installarchlib='$installarchlib'
installbin='$installbin'
installhtml1dir='$installhtml1dir'
installhtml3dir='$installhtml3dir'
installman1dir='$installman1dir'
installman3dir='$installman3dir'
installprefix='$installprefix'
installprefixexp='$installprefixexp'
installprivlib='$installprivlib'
installscript='$installscript'
installsitearch='$installsitearch'
installsitebin='$installsitebin'
installsitehtml1dir='$installsitehtml1dir'
installsitehtml3dir='$installsitehtml3dir'
installsitelib='$installsitelib'
installsiteman1dir='$installsiteman1dir'
installsiteman3dir='$installsiteman3dir'
installsitescript='$installsitescript'
installstyle='$installstyle'
installusrbinperl='$installusrbinperl'
installvendorarch='$installvendorarch'
installvendorbin='$installvendorbin'
installvendorhtml1dir='$installvendorhtml1dir'
installvendorhtml3dir='$installvendorhtml3dir'
installvendorlib='$installvendorlib'
installvendorman1dir='$installvendorman1dir'
installvendorman3dir='$installvendorman3dir'
installvendorscript='$installvendorscript'
intsize='$intsize'
issymlink='$issymlink'
ivdformat='$ivdformat'
ivsize='$ivsize'
ivtype='$ivtype'
known_extensions='$known_extensions'
ksh='$ksh'
ld='$ld'
lddlflags='$lddlflags'
ldflags='$ldflags'
ldflags_uselargefiles='$ldflags_uselargefiles'
ldlibpthname='$ldlibpthname'
less='$less'
lib_ext='$lib_ext'
libc='$libc'
libperl='$libperl'
libpth='$libpth'
libs='$libs'
libsdirs='$libsdirs'
libsfiles='$libsfiles'
libsfound='$libsfound'
libspath='$libspath'
libswanted='$libswanted'
libswanted_uselargefiles='$libswanted_uselargefiles'
line='$line'
lint='$lint'
lkflags='$lkflags'
ln='$ln'
lns='$lns'
localtime_r_proto='$localtime_r_proto'
locincpth='$locincpth'
loclibpth='$loclibpth'
longdblsize='$longdblsize'
longlongsize='$longlongsize'
longsize='$longsize'
lp='$lp'
lpr='$lpr'
ls='$ls'
lseeksize='$lseeksize'
lseektype='$lseektype'
mail='$mail'
mailx='$mailx'
make='$make'
make_set_make='$make_set_make'
mallocobj='$mallocobj'
mallocsrc='$mallocsrc'
malloctype='$malloctype'
man1dir='$man1dir'
man1direxp='$man1direxp'
man1ext='$man1ext'
man3dir='$man3dir'
man3direxp='$man3direxp'
man3ext='$man3ext'
mips_type='$mips_type'
mistrustnm='$mistrustnm'
mkdir='$mkdir'
mmaptype='$mmaptype'
modetype='$modetype'
more='$more'
multiarch='$multiarch'
mv='$mv'
myarchname='$myarchname'
mydomain='$mydomain'
myhostname='$myhostname'
myuname='$myuname'
n='$n'
need_va_copy='$need_va_copy'
netdb_hlen_type='$netdb_hlen_type'
netdb_host_type='$netdb_host_type'
netdb_name_type='$netdb_name_type'
netdb_net_type='$netdb_net_type'
nm='$nm'
nm_opt='$nm_opt'
nm_so_opt='$nm_so_opt'
nonxs_ext='$nonxs_ext'
nroff='$nroff'
nvEUformat='$nvEUformat'
nvFUformat='$nvFUformat'
nvGUformat='$nvGUformat'
nv_preserves_uv_bits='$nv_preserves_uv_bits'
nveformat='$nveformat'
nvfformat='$nvfformat'
nvgformat='$nvgformat'
nvsize='$nvsize'
nvtype='$nvtype'
o_nonblock='$o_nonblock'
obj_ext='$obj_ext'
old_pthread_create_joinable='$old_pthread_create_joinable'
optimize='$optimize'
orderlib='$orderlib'
osname='$osname'
osvers='$osvers'
otherlibdirs='$otherlibdirs'
package='$package'
pager='$pager'
passcat='$passcat'
patchlevel='$patchlevel'
path_sep='$path_sep'
perl5='$perl5'
perl='$perl'
perl_patchlevel='$perl_patchlevel'
perladmin='$perladmin'
perllibs='$perllibs'
perlpath='$perlpath'
pg='$pg'
phostname='$phostname'
pidtype='$pidtype'
plibpth='$plibpth'
pmake='$pmake'
pr='$pr'
prefix='$prefix'
prefixexp='$prefixexp'
privlib='$privlib'
privlibexp='$privlibexp'
procselfexe='$procselfexe'
prototype='$prototype'
ptrsize='$ptrsize'
quadkind='$quadkind'
quadtype='$quadtype'
randbits='$randbits'
randfunc='$randfunc'
random_r_proto='$random_r_proto'
randseedtype='$randseedtype'
ranlib='$ranlib'
rd_nodata='$rd_nodata'
readdir64_r_proto='$readdir64_r_proto'
readdir_r_proto='$readdir_r_proto'
revision='$revision'
rm='$rm'
rmail='$rmail'
run='$run'
runnm='$runnm'
sPRIEUldbl='$sPRIEUldbl'
sPRIFUldbl='$sPRIFUldbl'
sPRIGUldbl='$sPRIGUldbl'
sPRIXU64='$sPRIXU64'
sPRId64='$sPRId64'
sPRIeldbl='$sPRIeldbl'
sPRIfldbl='$sPRIfldbl'
sPRIgldbl='$sPRIgldbl'
sPRIi64='$sPRIi64'
sPRIo64='$sPRIo64'
sPRIu64='$sPRIu64'
sPRIx64='$sPRIx64'
sSCNfldbl='$sSCNfldbl'
sched_yield='$sched_yield'
scriptdir='$scriptdir'
scriptdirexp='$scriptdirexp'
sed='$sed'
seedfunc='$seedfunc'
selectminbits='$selectminbits'
selecttype='$selecttype'
sendmail='$sendmail'
setgrent_r_proto='$setgrent_r_proto'
sethostent_r_proto='$sethostent_r_proto'
setlocale_r_proto='$setlocale_r_proto'
setnetent_r_proto='$setnetent_r_proto'
setprotoent_r_proto='$setprotoent_r_proto'
setpwent_r_proto='$setpwent_r_proto'
setservent_r_proto='$setservent_r_proto'
sh='$sh'
shar='$shar'
sharpbang='$sharpbang'
shmattype='$shmattype'
shortsize='$shortsize'
shrpenv='$shrpenv'
shsharp='$shsharp'
sig_count='$sig_count'
sig_name='$sig_name'
sig_name_init='$sig_name_init'
sig_num='$sig_num'
sig_num_init='$sig_num_init'
sig_size='$sig_size'
signal_t='$signal_t'
sitearch='$sitearch'
sitearchexp='$sitearchexp'
sitebin='$sitebin'
sitebinexp='$sitebinexp'
sitehtml1dir='$sitehtml1dir'
sitehtml1direxp='$sitehtml1direxp'
sitehtml3dir='$sitehtml3dir'
sitehtml3direxp='$sitehtml3direxp'
sitelib='$sitelib'
sitelib_stem='$sitelib_stem'
sitelibexp='$sitelibexp'
siteman1dir='$siteman1dir'
siteman1direxp='$siteman1direxp'
siteman3dir='$siteman3dir'
siteman3direxp='$siteman3direxp'
siteprefix='$siteprefix'
siteprefixexp='$siteprefixexp'
sitescript='$sitescript'
sitescriptexp='$sitescriptexp'
sizesize='$sizesize'
sizetype='$sizetype'
sleep='$sleep'
smail='$smail'
so='$so'
sockethdr='$sockethdr'
socketlib='$socketlib'
socksizetype='$socksizetype'
sort='$sort'
spackage='$spackage'
spitshell='$spitshell'
srand48_r_proto='$srand48_r_proto'
srandom_r_proto='$srandom_r_proto'
src='$src'
ssizetype='$ssizetype'
startperl='$startperl'
startsh='$startsh'
static_ext='$static_ext'
stdchar='$stdchar'
stdio_base='$stdio_base'
stdio_bufsiz='$stdio_bufsiz'
stdio_cnt='$stdio_cnt'
stdio_filbuf='$stdio_filbuf'
stdio_ptr='$stdio_ptr'
stdio_stream_array='$stdio_stream_array'
strerror_r_proto='$strerror_r_proto'
strings='$strings'
submit='$submit'
subversion='$subversion'
sysman='$sysman'
tail='$tail'
tar='$tar'
targetarch='$targetarch'
tbl='$tbl'
tee='$tee'
test='$test'
timeincl='$timeincl'
timetype='$timetype'
tmpnam_r_proto='$tmpnam_r_proto'
to='$to'
touch='$touch'
tr='$tr'
trnl='$trnl'
troff='$troff'
ttyname_r_proto='$ttyname_r_proto'
u16size='$u16size'
u16type='$u16type'
u32size='$u32size'
u32type='$u32type'
u64size='$u64size'
u64type='$u64type'
u8size='$u8size'
u8type='$u8type'
uidformat='$uidformat'
uidsign='$uidsign'
uidsize='$uidsize'
uidtype='$uidtype'
uname='$uname'
uniq='$uniq'
uquadtype='$uquadtype'
use5005threads='$use5005threads'
use64bitall='$use64bitall'
use64bitint='$use64bitint'
usecrosscompile='$usecrosscompile'
usedl='$usedl'
usefaststdio='$usefaststdio'
useithreads='$useithreads'
uselargefiles='$uselargefiles'
uselongdouble='$uselongdouble'
usemallocwrap='$usemallocwrap'
usemorebits='$usemorebits'
usemultiplicity='$usemultiplicity'
usemymalloc='$usemymalloc'
usenm='$usenm'
useopcode='$useopcode'
useperlio='$useperlio'
useposix='$useposix'
usereentrant='$usereentrant'
usesfio='$usesfio'
useshrplib='$useshrplib'
usesocks='$usesocks'
usethreads='$usethreads'
usevendorprefix='$usevendorprefix'
usevfork='$usevfork'
usrinc='$usrinc'
uuname='$uuname'
uvXUformat='$uvXUformat'
uvoformat='$uvoformat'
uvsize='$uvsize'
uvtype='$uvtype'
uvuformat='$uvuformat'
uvxformat='$uvxformat'
vendorarch='$vendorarch'
vendorarchexp='$vendorarchexp'
vendorbin='$vendorbin'
vendorbinexp='$vendorbinexp'
vendorhtml1dir='$vendorhtml1dir'
vendorhtml1direxp='$vendorhtml1direxp'
vendorhtml3dir='$vendorhtml3dir'
vendorhtml3direxp='$vendorhtml3direxp'
vendorlib='$vendorlib'
vendorlib_stem='$vendorlib_stem'
vendorlibexp='$vendorlibexp'
vendorman1dir='$vendorman1dir'
vendorman1direxp='$vendorman1direxp'
vendorman3dir='$vendorman3dir'
vendorman3direxp='$vendorman3direxp'
vendorprefix='$vendorprefix'
vendorprefixexp='$vendorprefixexp'
vendorscript='$vendorscript'
vendorscriptexp='$vendorscriptexp'
version='$version'
version_patchlevel_string='$version_patchlevel_string'
versiononly='$versiononly'
vi='$vi'
voidflags='$voidflags'
xlibpth='$xlibpth'
yacc='$yacc'
yaccflags='$yaccflags'
zcat='$zcat'
zip='$zip'
EOT

: Add in command line options if available
$test -f UU/cmdline.opt && $cat UU/cmdline.opt >> config.sh

: add special variables
$test -f $src/patchlevel.h && \
awk '/^#define[         ]+PERL_/ {printf "%s=%s\n",$2,$3}' $src/patchlevel.h >>config.sh
echo "PERL_PATCHLEVEL=$perl_patchlevel" >>config.sh
echo "PERL_CONFIG_SH=true" >>config.sh

: propagate old symbols
if $test -f UU/config.sh; then
        <UU/config.sh $sort | $uniq >UU/oldconfig.sh
        sed -n 's/^\([a-zA-Z_0-9]*\)=.*/\1/p' config.sh config.sh UU/oldconfig.sh |\
        $sort | $uniq -u >UU/oldsyms
        set X `cat UU/oldsyms`
        shift
        case $# in
        0) ;;
        *)
                cat <<EOM
Hmm...You had some extra variables I don't know about...I'll try to keep 'em...
EOM
                echo "# Variables propagated from previous config.sh file." >>config.sh
                for sym in `cat UU/oldsyms`; do
                        echo "    Propagating $hint variable "'$'"$sym..."
                        eval 'tmp="$'"${sym}"'"'
                        echo "$tmp" | \
                                sed -e "s/'/'\"'\"'/g" -e "s/^/$sym='/" -e "s/$/'/" >>config.sh
                done
                ;;
        esac
fi

: Finish up by extracting the .SH files
case "$alldone" in
exit)
        $rm -rf UU
        echo "Extraction done."
        exit 0
        ;;
cont)
        ;;
'')
        dflt=''
        nostick=true
        $cat <<EOM

If you'd like to make any changes to the config.sh file before I begin
to configure things, do it as a shell escape now (e.g. !vi config.sh).

EOM
        rp="Press return or use a shell escape to edit config.sh:"
        . UU/myread
        nostick=''
        case "$ans" in
        '') ;;
        *) : in case they cannot read
                sh 1>&4 -c "$ans";;
        esac
        ;;
esac

: if this fails, just run all the .SH files by hand
. ./config.sh

echo " "
exec 1>&4
pwd=`pwd`
. ./UU/extract
cd "$pwd"

if $contains '^depend:' [Mm]akefile >/dev/null 2>&1; then
        dflt=y
        case "$silent" in
        true) ;;
        *)
                $cat <<EOM

Now you need to generate make dependencies by running "$make depend".
You might prefer to run it in background: "$make depend > makedepend.out &"
It can take a while, so you might not want to run it right now.

EOM
                ;;
        esac
        rp="Run $make depend now?"
        . UU/myread
        case "$ans" in
        y*)
                $make depend && echo "Now you must run '$make'."
                ;;
        *)
                echo "You must run '$make depend' then '$make'."
                ;;
        esac
elif test -f [Mm]akefile; then
        echo " "
        echo "Now you must run a $make."
else
        echo "Configure done."
fi

if $test -f Policy.sh; then
    $cat <<EOM

If you compile $package on a different machine or from a different object
directory, copy the Policy.sh file from this object directory to the
new one before you run Configure -- this will help you with most of
the policy defaults.

EOM
fi
if $test -f config.msg; then
    echo "Hmm.  I also noted the following information while running:"
    echo " "
    $cat config.msg >&4
    $rm -f config.msg
fi
$rm -f kit*isdone ark*isdone
$rm -rf UU

: End of Configure

