# This shell script emits a C file. -*- C -*-
# It does some substitutions.
# This file is now misnamed, because it supports both 32 bit and 64 bit
# ELF emulations.
test -z "${ELFSIZE}" && ELFSIZE=32
if [ -z "$MACHINE" ]; then
  OUTPUT_ARCH=${ARCH}
else
  OUTPUT_ARCH=${ARCH}:${MACHINE}
fi
cat >e${EMULATION_NAME}.c <<EOF
/* This file is is generated by a shell script.  DO NOT EDIT! */

/* ${ELFSIZE} bit ELF emulation code for ${EMULATION_NAME}
   Copyright 1991, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
   2002 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>
   MorphOS support by Emmanuel Lesueur <lesueur@club-internet.fr>

This file is part of GLD, the Gnu Linker.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#define TARGET_IS_${EMULATION_NAME}

#include "bfd.h"
#include "sysdep.h"
#include "libiberty.h"
#include "safe-ctype.h"

#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include <ldgram.h>
#include "elf/common.h"

static void gld${EMULATION_NAME}_before_parse
  PARAMS ((void));
static void gld${EMULATION_NAME}_set_symbols
  PARAMS ((void));
static lang_output_section_statement_type *output_rel_find
  PARAMS ((asection *));
static asection *output_prev_sec_find
  PARAMS ((lang_output_section_statement_type *));
static boolean gld${EMULATION_NAME}_place_orphan
  PARAMS ((lang_input_statement_type *, asection *));
static void gld${EMULATION_NAME}_finish
  PARAMS ((void));
static char *gld${EMULATION_NAME}_get_script
  PARAMS ((int *isfile));

extern void ldfile_add_flavor (char*);
static int morphos_resident;

EOF

# Import any needed special functions and/or overrides.
#
if test -n "$EXTRA_EM_FILE" ; then
. ${srcdir}/emultempl/${EXTRA_EM_FILE}.em
fi

# Functions in this file can be overridden by setting the LDEMUL_* shell
# variables.  If the name of the overriding function is the same as is
# defined in this file, then don't output this file's version.
# If a different overriding name is given then output the standard function
# as presumably it is called from the overriding function.
#
if test x"$LDEMUL_BEFORE_PARSE" != xgld"$EMULATION_NAME"_before_parse; then
cat >>e${EMULATION_NAME}.c <<EOF

static void
gld${EMULATION_NAME}_before_parse ()
{
  const bfd_arch_info_type *arch = bfd_scan_arch ("${OUTPUT_ARCH}");
  if (arch)
    {
      ldfile_output_architecture = arch->arch;
      ldfile_output_machine = arch->mach;
      ldfile_output_machine_name = arch->printable_name;
    }
  else
    ldfile_output_architecture = bfd_arch_`echo ${ARCH} | sed -e 's/:.*//'`;
  config.dynamic_link = ${DYNAMIC_LINK-true};
  config.has_shared = `if test -n "$GENERATE_SHLIB_SCRIPT" ; then echo true ; else echo false ; fi`;
  sort_flavors();
}

EOF
fi

if test x"$LDEMUL_SET_SYMBOLS" != xgld"$EMULATION_NAME"_set_symbols; then
cat >>e${EMULATION_NAME}.c <<EOF
static void
gld${EMULATION_NAME}_set_symbols()
{
  if (link_info.strip == strip_all)
    {
      link_info.keep_hash = ((struct bfd_hash_table *)
			     xmalloc (sizeof (struct bfd_hash_table)));

      if (! bfd_hash_table_init (link_info.keep_hash, bfd_hash_newfunc))
	einfo ("%P%F: bfd_hash_table_init failed: %E\n");
 
      if (bfd_hash_lookup (link_info.keep_hash, "__amigappc__", true, true)
	  == (struct bfd_hash_entry *) NULL)
	einfo ("%P%F: bfd_hash_lookup for insertion failed: %E\n");

      link_info.strip = strip_some;
    }
}
EOF
fi

if test x"$LDEMUL_AFTER_OPEN" != xgld"$EMULATION_NAME"_after_open; then
cat >>e${EMULATION_NAME}.c <<EOF

/* This is called after all the input files have been opened.  */

static void
gld${EMULATION_NAME}_after_open ()
{
  struct bfd_link_needed_list *needed, *l;

  /* We only need to worry about this when doing a final link.  */
  if (link_info.relocateable || link_info.shared)
    return;

  /* Get the list of files which appear in DT_NEEDED entries in
     dynamic objects included in the link (often there will be none).
     For each such file, we want to track down the corresponding
     library, and include the symbol table in the link.  This is what
     the runtime dynamic linker will do.  Tracking the files down here
     permits one dynamic object to include another without requiring
     special action by the person doing the link.  Note that the
     needed list can actually grow while we are stepping through this
     loop.  */
  needed = bfd_elf_get_needed_list (output_bfd, &link_info);
  for (l = needed; l != NULL; l = l->next)
    {
      struct bfd_link_needed_list *ll;
      int force = 0;

      /* If we've already seen this file, skip it.  */
      for (ll = needed; ll != l; ll = ll->next)
	if (strcmp (ll->name, l->name) == 0)
	  break;
      if (ll != l)
	continue;

#if 0
      /* See if this file was included in the link explicitly.  */
      global_needed = l;
      global_found = false;
      lang_for_each_input_file (gld${EMULATION_NAME}_check_needed);
      if (global_found)
	continue;

      if (trace_file_tries)
	info_msg (_("%s needed by %B\n"), l->name, l->by);

      /* We need to find this file and include the symbol table.  We
	 want to search for the file in the same way that the dynamic
	 linker will search.  That means that we want to use
	 rpath_link, rpath, then the environment variable
	 LD_LIBRARY_PATH (native only), then the DT_RPATH/DT_RUNPATH
	 entries (native only), then the linker script LIB_SEARCH_DIRS.
	 We do not search using the -L arguments.

	 We search twice.  The first time, we skip objects which may
	 introduce version mismatches.  The second time, we force
	 their use.  See gld${EMULATION_NAME}_vercheck comment.  */
      for (force = 0; force < 2; force++)
	{
	  size_t len;
	  search_dirs_type *search;
EOF
if [ "x${host}" = "x${target}" ] ; then
  case " ${EMULATION_LIBPATH} " in
  *" ${EMULATION_NAME} "*)
cat >>e${EMULATION_NAME}.c <<EOF
	  const char *lib_path;
	  struct bfd_link_needed_list *rp;
	  int found;
EOF
  ;;
  esac
fi
cat >>e${EMULATION_NAME}.c <<EOF

	  if (gld${EMULATION_NAME}_search_needed (command_line.rpath_link,
						  l->name, force))
	    break;
EOF
if [ "x${host}" = "x${target}" ] ; then
  case " ${EMULATION_LIBPATH} " in
  *" ${EMULATION_NAME} "*)
cat >>e${EMULATION_NAME}.c <<EOF
	  if (gld${EMULATION_NAME}_search_needed (command_line.rpath,
						  l->name, force))
	    break;
	  if (command_line.rpath_link == NULL
	      && command_line.rpath == NULL)
	    {
	      lib_path = (const char *) getenv ("LD_RUN_PATH");
	      if (gld${EMULATION_NAME}_search_needed (lib_path, l->name,
						      force))
		break;
	    }
	  lib_path = (const char *) getenv ("LD_LIBRARY_PATH");
	  if (gld${EMULATION_NAME}_search_needed (lib_path, l->name, force))
	    break;

	  found = 0;
	  rp = bfd_elf_get_runpath_list (output_bfd, &link_info);
	  for (; !found && rp != NULL; rp = rp->next)
	    {
	      found = (rp->by == l->by
		       && gld${EMULATION_NAME}_search_needed (rp->name,
							      l->name,
							      force));
	    }
	  if (found)
	    break;

EOF
  ;;
  esac
fi
cat >>e${EMULATION_NAME}.c <<EOF
	  len = strlen (l->name);
	  for (search = search_head; search != NULL; search = search->next)
	    {
	      char *filename;

	      if (search->cmdline)
		continue;
	      filename = (char *) xmalloc (strlen (search->name) + len + 2);
	      sprintf (filename, "%s/%s", search->name, l->name);
	      if (gld${EMULATION_NAME}_try_needed (filename, force))
		break;
	      free (filename);
	    }
	  if (search != NULL)
	    break;
EOF
if [ "x${host}" = "x${target}" ] ; then
  case " ${EMULATION_LIBPATH} " in
  *" ${EMULATION_NAME} "*)
    case ${target} in
      *-*-linux-gnu*)
	cat >>e${EMULATION_NAME}.c <<EOF
	  if (gld${EMULATION_NAME}_check_ld_so_conf (l->name, force))
	    break;
EOF
	# Linux
        ;;
    esac
  ;;
  esac
fi
cat >>e${EMULATION_NAME}.c <<EOF
	}
#endif
      if (force < 2)
	continue;

      einfo ("%P: warning: %s, needed by %B, not found (try using -rpath or -rpath-link)\n",
	     l->name, l->by);
    }
}

EOF
fi


if test x"$LDEMUL_BEFORE_ALLOCATION" != xgld"$EMULATION_NAME"_before_allocation; then
  if test x"${ELF_INTERPRETER_NAME+set}" = xset; then
    ELF_INTERPRETER_SET_DEFAULT="
  if (sinterp != NULL)
    {
      sinterp->contents = ${ELF_INTERPRETER_NAME};
      sinterp->_raw_size = strlen (sinterp->contents) + 1;
    }

"
  else
    ELF_INTERPRETER_SET_DEFAULT=
  fi
cat >>e${EMULATION_NAME}.c <<EOF

/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gld${EMULATION_NAME}_before_allocation ()
{
  const char *rpath;
  asection *sinterp;

  /* If we are going to make any variable assignments, we need to let
     the ELF backend know about them in case the variables are
     referred to by dynamic objects.  */
  /*lang_for_each_statement (gld${EMULATION_NAME}_find_statement_assignment);*/

  /* Add the data->data relocation table... */
  if (morphos_resident)
    {
      asection *sec = bfd_make_section(output_bfd, "ddrelocs");
      struct bfd_link_hash_entry *sym;

      if (sec)
	{
	  bfd_set_section_flags(output_bfd, sec, SEC_ALLOC | SEC_LOAD | SEC_READONLY | 
				SEC_DATA | SEC_HAS_CONTENTS);
	  sec->output_section = sec;
	  sec->output_offset = 0;
	  sym = bfd_link_hash_lookup(link_info.hash, "__datadata_relocs", true, false, false);
	  if (sym)
	    {
	      sym->type = bfd_link_hash_defined;
	      sym->u.def.value = 0;
	      sym->u.def.section = sec;
	    }
	}
    }

  /* Let the ELF backend work out the sizes of any sections required
     by dynamic linking.  */
  rpath = command_line.rpath;
  /*if (rpath == NULL)
    rpath = (const char *) getenv ("LD_RUN_PATH");*/
  if (! (bfd_elf${ELFSIZE}_size_dynamic_sections
         (output_bfd, command_line.soname, rpath,
	  command_line.filter_shlib,
	  (const char * const *) command_line.auxiliary_filters,
	  &link_info, &sinterp, lang_elf_version_info)))
    einfo ("%P%F: failed to set dynamic section sizes: %E\n");
${ELF_INTERPRETER_SET_DEFAULT}
  /* Let the user override the dynamic linker we are using.  */
  if (command_line.interpreter != NULL
      && sinterp != NULL)
    {
      sinterp->contents = (bfd_byte *) command_line.interpreter;
      sinterp->_raw_size = strlen (command_line.interpreter) + 1;
    }

  /* Look for any sections named .gnu.warning.  As a GNU extensions,
     we treat such sections as containing warning messages.  We print
     out the warning message, and then zero out the section size so
     that it does not get copied into the output file.  */

  {
    LANG_FOR_EACH_INPUT_STATEMENT (is)
      {
	asection *s;
	bfd_size_type sz;
	char *msg;
	boolean ret;

	if (is->just_syms_flag)
	  continue;

	s = bfd_get_section_by_name (is->the_bfd, ".gnu.warning");
	if (s == NULL)
	  continue;

	sz = bfd_section_size (is->the_bfd, s);
	msg = xmalloc ((size_t) sz + 1);
	if (! bfd_get_section_contents (is->the_bfd, s, msg, (file_ptr) 0, sz))
	  einfo ("%F%B: Can't read contents of section .gnu.warning: %E\n",
		 is->the_bfd);
	msg[sz] = '\0';
	ret = link_info.callbacks->warning (&link_info, msg,
					    (const char *) NULL,
					    is->the_bfd, (asection *) NULL,
					    (bfd_vma) 0);
	ASSERT (ret);
	free (msg);

	/* Clobber the section size, so that we don't waste copying the
	   warning into the output file.  */
	s->_raw_size = 0;
      }
  }
}

EOF
fi


if test x"$LDEMUL_PLACE_ORPHAN" != xgld"$EMULATION_NAME"_place_orphan; then
cat >>e${EMULATION_NAME}.c <<EOF

/* A variant of lang_output_section_find.  Used by place_orphan.  */

static lang_output_section_statement_type *
output_rel_find (sec)
     asection *sec;
{
  lang_statement_union_type *u;
  lang_output_section_statement_type *lookup;
  lang_output_section_statement_type *last = NULL;
  lang_output_section_statement_type *last_rel = NULL;
  lang_output_section_statement_type *last_rel_alloc = NULL;
  int rela = sec->name[4] == 'a';

  for (u = lang_output_section_statement.head; u; u = lookup->next)
    {
      lookup = &u->output_section_statement;
      if (strncmp (".rel", lookup->name, 4) == 0)
	{
	  /* Don't place after .rel.plt as doing so results in wrong
	     dynamic tags.  Also, place allocated reloc sections before
	     non-allocated.  */
	  int lookrela = lookup->name[4] == 'a';

	  if (strcmp (".plt", lookup->name + 4 + lookrela) == 0
	      || (lookup->bfd_section != NULL
		  && (lookup->bfd_section->flags & SEC_ALLOC) == 0))
	    break;
	  last = lookup;
	  if (rela == lookrela)
	    last_rel = lookup;
	  if (lookup->bfd_section != NULL
	      && (lookup->bfd_section->flags & SEC_ALLOC) != 0)
	    last_rel_alloc = lookup;
	}
    }

  if (last_rel_alloc)
    return last_rel_alloc;

  if (last_rel)
    return last_rel;

  return last;
}

/* Find the last output section before given output statement.
   Used by place_orphan.  */

static asection *
output_prev_sec_find (os)
     lang_output_section_statement_type *os;
{
  asection *s = (asection *) NULL;
  lang_statement_union_type *u;
  lang_output_section_statement_type *lookup;

  for (u = lang_output_section_statement.head;
       u != (lang_statement_union_type *) NULL;
       u = lookup->next)
    {
      lookup = &u->output_section_statement;
      if (lookup == os)
	return s;

      if (lookup->bfd_section != NULL && lookup->bfd_section->owner != NULL)
	s = lookup->bfd_section;
    }

  return NULL;
}

/* Place an orphan section.  We use this to put random SHF_ALLOC
   sections in the right segment.  */

struct orphan_save {
  lang_output_section_statement_type *os;
  asection **section;
  lang_statement_union_type **stmt;
};

static boolean
gld${EMULATION_NAME}_place_orphan (file, s)
     lang_input_statement_type *file;
     asection *s;
{
  static struct orphan_save hold_text;
  static struct orphan_save hold_rodata;
  static struct orphan_save hold_data;
  static struct orphan_save hold_bss;
  static struct orphan_save hold_rel;
  static struct orphan_save hold_interp;
  static struct orphan_save hold_sdata;
  static int count = 1;
  struct orphan_save *place;
  lang_statement_list_type *old;
  lang_statement_list_type add;
  etree_type *address;
  const char *secname;
  const char *ps = NULL;
  lang_output_section_statement_type *os;
  int isdyn = 0;

  secname = bfd_get_section_name (s->owner, s);
  if (! link_info.relocateable
      && link_info.combreloc
      && (s->flags & SEC_ALLOC)
      && strncmp (secname, ".rel", 4) == 0)
    {
      if (secname[4] == 'a')
	secname = ".rela.dyn";
      else
	secname = ".rel.dyn";
      isdyn = 1;
    }

  if (isdyn || (!config.unique_orphan_sections && !unique_section_p (secname)))
    {
      /* Look through the script to see where to place this section.  */
      os = lang_output_section_find (secname);

      if (os != NULL
	  && (os->bfd_section == NULL
	      || ((s->flags ^ os->bfd_section->flags)
		  & (SEC_LOAD | SEC_ALLOC)) == 0))
	{
	  /* We already have an output section statement with this
	     name, and its bfd section, if any, has compatible flags.  */
	  lang_add_section (&os->children, s, os, file);
	  return true;
	}
    }

  if (hold_text.os == NULL)
    hold_text.os = lang_output_section_find (".text");

  /* If this is a final link, then always put .gnu.warning.SYMBOL
     sections into the .text section to get them out of the way.  */
  if (! link_info.shared
      && ! link_info.relocateable
      && strncmp (secname, ".gnu.warning.", sizeof ".gnu.warning." - 1) == 0
      && hold_text.os != NULL)
    {
      lang_add_section (&hold_text.os->children, s, hold_text.os, file);
      return true;
    }

  /* Decide which segment the section should go in based on the
     section name and section flags.  We put loadable .note sections
     right after the .interp section, so that the PT_NOTE segment is
     stored right after the program headers where the OS can read it
     in the first page.  */
#define HAVE_SECTION(hold, name) \
(hold.os != NULL || (hold.os = lang_output_section_find (name)) != NULL)

  if ((s->flags & SEC_EXCLUDE) != 0 && !link_info.relocateable)
    {
      if (s->output_section == NULL)
	s->output_section = bfd_abs_section_ptr;
      return true;
    }

  place = NULL;
  if ((s->flags & SEC_ALLOC) == 0)
    ;
  else if ((s->flags & SEC_LOAD) != 0
	   && strncmp (secname, ".note", 5) == 0
	   && HAVE_SECTION (hold_interp, ".interp"))
    place = &hold_interp;
  else if ((s->flags & SEC_HAS_CONTENTS) == 0
	   && HAVE_SECTION (hold_bss, ".bss"))
    place = &hold_bss;
  else if ((s->flags & SEC_SMALL_DATA) != 0
	   && HAVE_SECTION (hold_sdata, ".sdata"))
    place = &hold_sdata;
  else if ((s->flags & SEC_READONLY) == 0
	   && HAVE_SECTION (hold_data, ".data"))
    place = &hold_data;
  else if (strncmp (secname, ".rel", 4) == 0
	   && (s->flags & SEC_LOAD) != 0
	   && (hold_rel.os != NULL
	       || (hold_rel.os = output_rel_find (s)) != NULL))
    place = &hold_rel;
  else if ((s->flags & (SEC_CODE | SEC_READONLY)) == SEC_READONLY
	   && HAVE_SECTION (hold_rodata, ".rodata"))
    place = &hold_rodata;
  else if ((s->flags & (SEC_CODE | SEC_READONLY)) == (SEC_CODE | SEC_READONLY)
	   && hold_text.os != NULL)
    place = &hold_text;

#undef HAVE_SECTION

  /* Choose a unique name for the section.  This will be needed if the
     same section name appears in the input file with different
     loadable or allocatable characteristics.  */
  if (bfd_get_section_by_name (output_bfd, secname) != NULL)
    {
      secname = bfd_get_unique_section_name (output_bfd, secname, &count);
      if (secname == NULL)
	einfo ("%F%P: place_orphan failed: %E\n");
    }

  /* Start building a list of statements for this section.
     First save the current statement pointer.  */
  old = stat_ptr;

  /* If we have found an appropriate place for the output section
     statements for this orphan, add them to our own private list,
     inserting them later into the global statement list.  */
  if (place != NULL)
    {
      stat_ptr = &add;
      lang_list_init (stat_ptr);
    }

  if (config.build_constructors)
    {
      /* If the name of the section is representable in C, then create
	 symbols to mark the start and the end of the section.  */
      for (ps = secname; *ps != '\0'; ps++)
	if (! ISALNUM (*ps) && *ps != '_')
	  break;
      if (*ps == '\0')
	{
	  char *symname;
	  etree_type *e_align;

	  symname = (char *) xmalloc (ps - secname + sizeof "__start_");
	  sprintf (symname, "__start_%s", secname);
	  e_align = exp_unop (ALIGN_K,
			      exp_intop ((bfd_vma) 1 << s->alignment_power));
	  lang_add_assignment (exp_assop ('=', symname, e_align));
	}
    }

  if (link_info.relocateable || (s->flags & (SEC_LOAD | SEC_ALLOC)) == 0)
    address = exp_intop ((bfd_vma) 0);
  else
    address = NULL;

  os = lang_enter_output_section_statement (secname, address, 0,
					    (bfd_vma) 0,
					    (etree_type *) NULL,
					    (etree_type *) NULL,
					    (etree_type *) NULL);

  lang_add_section (&os->children, s, os, file);

  lang_leave_output_section_statement
    ((bfd_vma) 0, "*default*",
     (struct lang_output_section_phdr_list *) NULL, NULL);

  if (config.build_constructors && *ps == '\0')
    {
      char *symname;

      /* lang_leave_ouput_section_statement resets stat_ptr.  Put
	 stat_ptr back where we want it.  */
      if (place != NULL)
	stat_ptr = &add;

      symname = (char *) xmalloc (ps - secname + sizeof "__stop_");
      sprintf (symname, "__stop_%s", secname);
      lang_add_assignment (exp_assop ('=', symname,
				      exp_nameop (NAME, ".")));
    }

  /* Restore the global list pointer.  */
  stat_ptr = old;

  if (place != NULL && os->bfd_section != NULL)
    {
      asection *snew, **pps;

      snew = os->bfd_section;

      /* Shuffle the bfd section list to make the output file look
	 neater.  This is really only cosmetic.  */
      if (place->section == NULL)
	{
	  asection *bfd_section = place->os->bfd_section;

	  /* If the output statement hasn't been used to place
	     any input sections (and thus doesn't have an output
	     bfd_section), look for the closest prior output statement
	     having an output section.  */
	  if (bfd_section == NULL)
	    bfd_section = output_prev_sec_find (place->os);

	  if (bfd_section != NULL && bfd_section != snew)
	    place->section = &bfd_section->next;
	}

      if (place->section != NULL)
	{
	  /* Unlink the section.  */
	  for (pps = &output_bfd->sections; *pps != snew; pps = &(*pps)->next)
	    ;
	  bfd_section_list_remove (output_bfd, pps);

	  /* Now tack it on to the "place->os" section list.  */
	  bfd_section_list_insert (output_bfd, place->section, snew);
	}

      /* Save the end of this list.  Further ophans of this type will
	 follow the one we've just added.  */
      place->section = &snew->next;

      /* The following is non-cosmetic.  We try to put the output
	 statements in some sort of reasonable order here, because
	 they determine the final load addresses of the orphan
	 sections.  In addition, placing output statements in the
	 wrong order may require extra segments.  For instance,
	 given a typical situation of all read-only sections placed
	 in one segment and following that a segment containing all
	 the read-write sections, we wouldn't want to place an orphan
	 read/write section before or amongst the read-only ones.  */
      if (add.head != NULL)
	{
	  if (place->stmt == NULL)
	    {
	      /* Put the new statement list right at the head.  */
	      *add.tail = place->os->header.next;
	      place->os->header.next = add.head;
	    }
	  else
	    {
	      /* Put it after the last orphan statement we added.  */
	      *add.tail = *place->stmt;
	      *place->stmt = add.head;
	    }

	  /* Fix the global list pointer if we happened to tack our
	     new list at the tail.  */
	  if (*old->tail == add.head)
	    old->tail = add.tail;

	  /* Save the end of this list.  */
	  place->stmt = add.tail;
	}
    }

  return true;
}
EOF
fi

if test x"$LDEMUL_FINISH" != xgld"$EMULATION_NAME"_finish; then
cat >>e${EMULATION_NAME}.c <<EOF

static void
gld${EMULATION_NAME}_finish ()
{
  if (bfd_elf${ELFSIZE}_discard_info (output_bfd, &link_info))
    {
      lang_reset_memory_regions ();

      /* Resize the sections.  */
      lang_size_sections (stat_ptr->head, abs_output_section,
			  &stat_ptr->head, 0, (bfd_vma) 0, NULL);

      /* Redo special stuff.  */
      ldemul_after_allocation ();

      /* Do the assignments again.  */
      lang_do_assignments (stat_ptr->head, abs_output_section,
			   (fill_type *) 0, (bfd_vma) 0);
    }
}
EOF
fi

if test x"$LDEMUL_GET_SCRIPT" != xgld"$EMULATION_NAME"_get_script; then
cat >>e${EMULATION_NAME}.c <<EOF

static char *
gld${EMULATION_NAME}_get_script (isfile)
     int *isfile;
EOF

if test -n "$COMPILE_IN"
then
# Scripts compiled in.

# sed commands to quote an ld script as a C string.
sc="-f stringify.sed"

cat >>e${EMULATION_NAME}.c <<EOF
{
  *isfile = 0;

  if (link_info.relocateable == true && config.build_constructors == true)
    return
EOF
sed $sc ldscripts/${EMULATION_NAME}.xu                     >> e${EMULATION_NAME}.c
echo '  ; else if (link_info.relocateable == true) return' >> e${EMULATION_NAME}.c
sed $sc ldscripts/${EMULATION_NAME}.xr                     >> e${EMULATION_NAME}.c
echo '  ; else return'                                     >> e${EMULATION_NAME}.c
sed $sc ldscripts/${EMULATION_NAME}.x                      >> e${EMULATION_NAME}.c
echo '; }'                                                 >> e${EMULATION_NAME}.c

else
# Scripts read from the filesystem.

cat >>e${EMULATION_NAME}.c <<EOF
{
  *isfile = 1;

  if (link_info.relocateable == true && config.build_constructors == true)
    return "ldscripts/${EMULATION_NAME}.xu";
  else if (link_info.relocateable == true)
    return "ldscripts/${EMULATION_NAME}.xr";
  else
    return "ldscripts/${EMULATION_NAME}.x";
}

EOF
fi
fi

if test -n "$PARSE_AND_LIST_ARGS_CASES" -o x"$GENERATE_SHLIB_SCRIPT" = xyes; then

if test x"$LDEMUL_PARSE_ARGS" != xgld"$EMULATION_NAME"_parse_args; then

if test -n "$PARSE_AND_LIST_PROLOGUE" ; then
cat >>e${EMULATION_NAME}.c <<EOF
 $PARSE_AND_LIST_PROLOGUE
EOF
fi

cat >>e${EMULATION_NAME}.c <<EOF

#include "getopt.h"

#define OPTION_IGNORE (300)
#define OPTION_MORPHOS_DATADATA_RELOC  (OPTION_IGNORE + 1)
#define OPTION_MORPHOS_BASEREL32       (OPTION_IGNORE + 2)
#define OPTION_FLAVOR                  (OPTION_IGNORE + 3)
  
#define OPTION_DISABLE_NEW_DTAGS	(400)
#define OPTION_ENABLE_NEW_DTAGS		(OPTION_DISABLE_NEW_DTAGS + 1)
#define OPTION_GROUP			(OPTION_ENABLE_NEW_DTAGS + 1)
#define OPTION_EH_FRAME_HDR		(OPTION_GROUP + 1)

static struct option longopts[] =
{
  {"datadata-reloc", no_argument, NULL, OPTION_MORPHOS_DATADATA_RELOC},
  /*    '\0', NULL, "Relocate for resident program", ONE_DASH },*/
  {"flavor", required_argument, NULL, OPTION_FLAVOR},
  /*'\0', NULL, "Select a library flavor", ONE_DASH },*/
  /*{"baserel32", no_argument, NULL, OPTION_MORPHOS_BASEREL32},*/
  /*    '\0', NULL, "Build a large-data base relative executable", ONE_DASH },*/
EOF

if test x"$GENERATE_SHLIB_SCRIPT" = xyes; then
cat >>e${EMULATION_NAME}.c <<EOF
  /* getopt allows abbreviations, so we do this to stop it from
     treating -d/-e as abbreviations for these options. */
  {"disable-new-dtags", no_argument, NULL, OPTION_DISABLE_NEW_DTAGS},
  {"disable-new-dtags", no_argument, NULL, OPTION_DISABLE_NEW_DTAGS},
  {"enable-new-dtags", no_argument, NULL, OPTION_ENABLE_NEW_DTAGS},
  {"enable-new-dtags", no_argument, NULL, OPTION_ENABLE_NEW_DTAGS},
  {"eh-frame-hdr", no_argument, NULL, OPTION_EH_FRAME_HDR},
  {"Bgroup", no_argument, NULL, OPTION_GROUP},
  {"Bgroup", no_argument, NULL, OPTION_GROUP},
EOF
fi

if test -n "$PARSE_AND_LIST_LONGOPTS" ; then
cat >>e${EMULATION_NAME}.c <<EOF
 $PARSE_AND_LIST_LONGOPTS
EOF
fi

cat >>e${EMULATION_NAME}.c <<EOF
  {NULL, no_argument, NULL, 0}
};


static int gld${EMULATION_NAME}_parse_args PARAMS ((int, char **));

static int
gld${EMULATION_NAME}_parse_args (argc, argv)
     int argc;
     char ** argv;
{
  int longind;
  int optc;
  static int prevoptind = -1;
  int prevopterr = opterr;
  int wanterror;

  if (prevoptind != optind)
    opterr = 0;

  wanterror = opterr;
  prevoptind = optind;

  optc = getopt_long_only (argc, argv,
			   "-${PARSE_AND_LIST_SHORTOPTS}z:", longopts,
			   &longind);
  opterr = prevopterr;

  switch (optc)
    {
    default:
      if (wanterror)
	xexit (1);
      optind = prevoptind;
      return 0;

    case OPTION_MORPHOS_DATADATA_RELOC:
      morphos_resident=1; /* Write out datadata_reloc array */
      break;

     /*case OPTION_MORPHOS_BASEREL32:
      morphos_baserel32=1;
      break;*/
      
    case OPTION_FLAVOR:
      ldfile_add_flavor (optarg);
      break;
EOF

if test x"$GENERATE_SHLIB_SCRIPT" = xyes; then
cat >>e${EMULATION_NAME}.c <<EOF
    case OPTION_DISABLE_NEW_DTAGS:
      link_info.new_dtags = false;
      break;

    case OPTION_ENABLE_NEW_DTAGS:
      link_info.new_dtags = true;
      break;

    case OPTION_EH_FRAME_HDR:
      link_info.eh_frame_hdr = true;
      break;

    case OPTION_GROUP:
      link_info.flags_1 |= (bfd_vma) DF_1_GROUP;
      /* Groups must be self-contained.  */
      link_info.no_undefined = true;
      break;

    case 'z':
      if (strcmp (optarg, "initfirst") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INITFIRST;
      else if (strcmp (optarg, "interpose") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INTERPOSE;
      else if (strcmp (optarg, "loadfltr") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_LOADFLTR;
      else if (strcmp (optarg, "nodefaultlib") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODEFLIB;
      else if (strcmp (optarg, "nodelete") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODELETE;
      else if (strcmp (optarg, "nodlopen") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NOOPEN;
      else if (strcmp (optarg, "nodump") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODUMP;
      else if (strcmp (optarg, "now") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 |= (bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "origin") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_ORIGIN;
	  link_info.flags_1 |= (bfd_vma) DF_1_ORIGIN;
	}
      else if (strcmp (optarg, "defs") == 0)
	link_info.no_undefined = true;
      else if (strcmp (optarg, "muldefs") == 0)
	link_info.allow_multiple_definition = true;
      else if (strcmp (optarg, "combreloc") == 0)
	link_info.combreloc = true;
      else if (strcmp (optarg, "nocombreloc") == 0)
	link_info.combreloc = false;
      else if (strcmp (optarg, "nocopyreloc") == 0)
        link_info.nocopyreloc = true;
      /* What about the other Solaris -z options? FIXME.  */
      break;
EOF
fi

if test -n "$PARSE_AND_LIST_ARGS_CASES" ; then
cat >>e${EMULATION_NAME}.c <<EOF
 $PARSE_AND_LIST_ARGS_CASES
EOF
fi

cat >>e${EMULATION_NAME}.c <<EOF
    }

  return 1;
}

EOF
fi

if test x"$LDEMUL_LIST_OPTIONS" != xgld"$EMULATION_NAME"_list_options; then
cat >>e${EMULATION_NAME}.c <<EOF

static void gld${EMULATION_NAME}_list_options PARAMS ((FILE * file));

static void
gld${EMULATION_NAME}_list_options (file)
     FILE * file;
{
EOF

if test x"$GENERATE_SHLIB_SCRIPT" = xyes; then
cat >>e${EMULATION_NAME}.c <<EOF
  fprintf (file, _("  -Bgroup\t\tSelects group name lookup rules for DSO\n"));
  fprintf (file, _("  --disable-new-dtags\tDisable new dynamic tags\n"));
  fprintf (file, _("  --enable-new-dtags\tEnable new dynamic tags\n"));
  fprintf (file, _("  --eh-frame-hdr\tCreate .eh_frame_hdr section\n"));
  fprintf (file, _("  -z combreloc\t\tMerge dynamic relocs into one section and sort\n"));
  fprintf (file, _("  -z defs\t\tDisallows undefined symbols\n"));
  fprintf (file, _("  -z initfirst\t\tMark DSO to be initialized first at runtime\n"));
  fprintf (file, _("  -z interpose\t\tMark object to interpose all DSOs but executable\n"));
  fprintf (file, _("  -z loadfltr\t\tMark object requiring immediate process\n"));
  fprintf (file, _("  -z muldefs\t\tAllow multiple definitions\n"));
  fprintf (file, _("  -z nocombreloc\tDon't merge dynamic relocs into one section\n"));
  fprintf (file, _("  -z nocopyreloc\tDon't create copy relocs\n"));
  fprintf (file, _("  -z nodefaultlib\tMark object not to use default search paths\n"));
  fprintf (file, _("  -z nodelete\t\tMark DSO non-deletable at runtime\n"));
  fprintf (file, _("  -z nodlopen\t\tMark DSO not available to dlopen\n"));
  fprintf (file, _("  -z nodump\t\tMark DSO not available to dldump\n"));
  fprintf (file, _("  -z now\t\tMark object non-lazy runtime binding\n"));
  fprintf (file, _("  -z origin\t\tMark object requiring immediate \$ORIGIN processing\n\t\t\t  at runtime\n"));
  fprintf (file, _("  -z KEYWORD\t\tIgnored for Solaris compatibility\n"));
EOF
fi

if test -n "$PARSE_AND_LIST_OPTIONS" ; then
cat >>e${EMULATION_NAME}.c <<EOF
 $PARSE_AND_LIST_OPTIONS
EOF
fi

cat >>e${EMULATION_NAME}.c <<EOF
}
EOF

if test -n "$PARSE_AND_LIST_EPILOGUE" ; then
cat >>e${EMULATION_NAME}.c <<EOF
 $PARSE_AND_LIST_EPILOGUE
EOF
fi
fi
else
if test x"$LDEMUL_PARSE_ARGS" != xgld"$EMULATION_NAME"_parse_args; then
cat >>e${EMULATION_NAME}.c <<EOF
#define gld${EMULATION_NAME}_parse_args   NULL
EOF
fi
if test x"$LDEMUL_LIST_OPTIONS" != xgld"$EMULATION_NAME"_list_options; then
cat >>e${EMULATION_NAME}.c <<EOF
#define gld${EMULATION_NAME}_list_options NULL
EOF
fi
fi

cat >>e${EMULATION_NAME}.c <<EOF

struct ld_emulation_xfer_struct ld_${EMULATION_NAME}_emulation =
{
  ${LDEMUL_BEFORE_PARSE-gld${EMULATION_NAME}_before_parse},
  ${LDEMUL_SYSLIB-syslib_default},
  ${LDEMUL_HLL-hll_default},
  ${LDEMUL_AFTER_PARSE-after_parse_default},
  ${LDEMUL_AFTER_OPEN-gld${EMULATION_NAME}_after_open},
  ${LDEMUL_AFTER_ALLOCATION-after_allocation_default},
  ${LDEMUL_SET_OUTPUT_ARCH-set_output_arch_default},
  ${LDEMUL_CHOOSE_TARGET-ldemul_default_target},
  ${LDEMUL_BEFORE_ALLOCATION-gld${EMULATION_NAME}_before_allocation},
  ${LDEMUL_GET_SCRIPT-gld${EMULATION_NAME}_get_script},
  "${EMULATION_NAME}",
  "${OUTPUT_FORMAT}",
  ${LDEMUL_FINISH-gld${EMULATION_NAME}_finish},
  ${LDEMUL_CREATE_OUTPUT_SECTION_STATEMENTS-NULL},
  ${LDEMUL_OPEN_DYNAMIC_ARCHIVE-NULL},
  ${LDEMUL_PLACE_ORPHAN-gld${EMULATION_NAME}_place_orphan},
  ${LDEMUL_SET_SYMBOLS-gld${EMULATION_NAME}_set_symbols},
  ${LDEMUL_PARSE_ARGS-gld${EMULATION_NAME}_parse_args},
  ${LDEMUL_UNRECOGNIZED_FILE-NULL},
  ${LDEMUL_LIST_OPTIONS-gld${EMULATION_NAME}_list_options},
  ${LDEMUL_RECOGNIZED_FILE-NULL},
  ${LDEMUL_FIND_POTENTIAL_LIBRARIES-NULL},
  ${LDEMUL_NEW_VERS_PATTERN-NULL}
};
EOF
