/* ==== machdep.h ============================================================
 * Copyright (c) 1993 Chris Provenzano, proven@athena.mit.edu
 *
 * $Id: engine-m68000-netbsd.h,v 1.51 1994/11/08 15:39:15 proven Exp $
 *
 */

#include <unistd.h>
#include <setjmp.h>
#include <sys/time.h>
#include <machine/reg.h>

/*
 * The first machine dependent functions are the SEMAPHORES
 * needing the test and set instruction.
 */
#define SEMAPHORE_CLEAR 0
#define SEMAPHORE_SET   0x80;

#define SEMAPHORE_TEST_AND_SET(lock)    \
({										\
volatile long temp = SEMAPHORE_CLEAR;   \
										\
__asm__ volatile("tas (%2);	bpl 0f; movl #1,%0; 0:" \
        :"=r" (temp)                    \
        :"0" (temp),"r" (lock));        \
temp;                                   \
})

#define SEMAPHORE_RESET(lock)           *lock = SEMAPHORE_CLEAR

/*
 * New types
 */
typedef char    semaphore;

/*
 * sigset_t macros
 */
#define	SIG_ANY(sig)		(sig)
#define SIGMAX				31

/*
 * New Strutures
 */
struct machdep_pthread {
    void        		*(*start_routine)(void *);
    void        		*start_argument;
    void        		*machdep_stack;
    struct itimerval		machdep_timer;
    jmp_buf     		machdep_state;
    struct fpreg		machdep_float_state;
    unsigned long 		dummy;
};

/*
 * Min pthread stacksize
 */
#define PTHREAD_STACK_MIN	16384

/*
 * Static machdep_pthread initialization values.
 * For initial thread only.
 */
#define MACHDEP_PTHREAD_INIT    \
{ NULL, NULL, NULL, { { 0, 0 }, { 0, 100000 } }, 0 }

/*
 * New functions
 */

__BEGIN_DECLS

#if defined(PTHREAD_KERNEL)

#define __machdep_stack_get(x)		(x)->machdep_stack
#define __machdep_stack_set(x,y)	(x)->machdep_stack = y
#define __machdep_stack_repl(x, y)                          \
{                                                           \
	if (stack = __machdep_stack_get(x)) {               \
		__machdep_stack_free(stack);                \
	}                                                   \
	__machdep_stack_set(x, y);                          \
}

void *  __machdep_stack_alloc		__P((size_t));
void	__machdep_stack_free		__P((void *));

int machdep_save_state      __P((void));

#define __FD_NONBLOCK O_NONBLOCK
#endif

__END_DECLS
