//////////////////////////////////////////////////////////////////////
// Demo1 ARM9 Code - Based on an example shipped with NDSLIB.
// Chris Double (chris.double@double.co.nz)
//////////////////////////////////////////////////////////////////////

#include <nds.h>
#include <nds/arm9/console.h>
#include <stdio.h>

int main(void)
{
  powerON(POWER_ALL);
  
  // Use the main screen for output
  videoSetMode(MODE_0_2D | DISPLAY_BG0_ACTIVE);
  vramSetBankA(VRAM_A_MAIN_BG);
  BG0_CR = BG_MAP_BASE(31);

  // Set the colour of the font to White.
  BG_PALETTE[255] = RGB15(31,31,31);

  consoleInitDefault((u16*)SCREEN_BASE_BLOCK(31), (u16*)CHAR_BASE_BLOCK(0), 16);

  printf("\n\n\tHello World!\n");
  while(1) {
    touchPosition touchXY = touchReadXY();

    printf("\x1b[10;0H");
    printf("Touch x = %d   \n", touchXY.px);
    printf("Touch y = %d   \n", touchXY.py);			
  }
  return 0;
}
