/*
C64-sprite picture to data converter

- Buch: Commodore_64_Step_by_Step_Programming_Graphics_Book_4.pdf
- PDF mit Sprite öffnen und Seite vergrößern
- Sprite ausschneiden und in Paint einfügen
- in Paint in Einstellungen die Seitengröße auf 480x420 ändern
- und Sprite auf die Größe anpassen 
- Speichern

- in Sprite converter dieses Sprite eintragen 
  meinBild = loadImage("Sprite_Rex.png"); 
*/

PImage meinBild;
int index;
int [] sprite_data = new int [21*3]; // 21 Zeilen a 3 Byte

void setup() {   
  size(600, 500);
  meinBild = loadImage("Sprite_Rex.png");   
  sprite_show();
  sprite_grid();  
  sprite_data_build();
  sprite_ausgabe();  
}

void sprite_show(){
  background(255);
  image(meinBild, 0, 0);
  stroke(255,0,0,255);
  fill(0,0,0,20);
  rect(0,0,meinBild.width,meinBild.height);
}

void sprite_grid() {
  int kastenbreite= meinBild.width/24;
  int kastenhoehe= (meinBild.height)/21;
  
  for (int n=0; n<21; n++) {  
    for (int m=0; m<24; m++) {       
      rect(kastenbreite*m, kastenhoehe*n, kastenbreite, kastenhoehe); 
    }
  }
}

void sprite_data_build(){
  int kastenbreite= meinBild.width/24;
  int kastenhoehe= (meinBild.height)/21;
  int byte_nr=0; int byte_pos=0; 
  int akt_positionswert = 0b10000000; 
  for (int n=0; n<21; n++) {  
    for (int m=0; m<24; m++) {         
    int x = kastenbreite*m+10;
    int zeile = kastenhoehe*n+10;
     index = x+zeile*600;
// --- Sprite Pixel black ---     
    loadPixels();
    color col2 = pixels[index];
    updatePixels();
    float v=0;
    v=red(col2)+green(col2)+blue(col2);
       
    if (v>600) {col2=0xFFFFFF;} else{col2=0;} 
      fill(col2);
      rect(kastenbreite*m, kastenhoehe*n, kastenbreite, kastenhoehe); 
// --- Sprite Data build ---    
    if(byte_pos == 8) {byte_nr++; byte_pos=0; akt_positionswert = 0b10000000; } // alle 8 ein neues Byte zusammenbauen
      byte_pos++;  
    if(col2==0){
      sprite_data[byte_nr] = sprite_data[byte_nr] | akt_positionswert;}    
    //println("byte_nr "+byte_nr+" byte_pos "+byte_pos+" akt_Poswert "+hex(akt_positionswert,2)+" Byte_data "+sprite_data[byte_nr]);    
    akt_positionswert>>=1;   // vorbereiten für nächsten Durchlauf         
    }
  }  
}

void sprite_ausgabe(){
  print("Sprite:");
  for (int i=0;i<21*3;i++){
    if (i % 7==0) { println(""); print("DATA  "+sprite_data[i]+", ");
    }else{ if ((i+1) % 7==0) {
         print(sprite_data[i]);}
           else{
         print(sprite_data[i]+", ");
      }
    }
  }
}
