
//-------------------------------------------------------------------
// P1 - ermittelt die Farbwerte aus WinUAE
//-------------------------------------------------------------------
void color_parser() { println("P1 - Ausgabe");
  String[] text_File_lines = loadStrings(load_Colors); 

  println("Colors:");
  for (int j= 0; j < text_File_lines.length; j++) {
    text1[j]=text_File_lines[j].substring(0, 3);    // 000  
    text2[j]=text_File_lines[j].substring(4, 11);   // BLTDDAT
    text3[j]=text_File_lines[j].substring(16, 20);  // 0000  
    text4[j]=text_File_lines[j].substring(24, 27);  // 106  
    text5[j]=text_File_lines[j].substring(28, 35);  // BPLCON3 
    text6[j]=text_File_lines[j].substring(40, 44);  // 0C00
  }
   
  for (int j= 0; j < text_File_lines.length; j++) {
       println("dc.w  $"+text4[j]+",$"+text6[j]+" ; "+text5[j]);
  }
}

//-------------------------------------------------------------------
// P2 - wandelt die Amiga Farbwerte in Farbwerte in Processing um
//-------------------------------------------------------------------
void color_convertion() {
  for (int j= 0; j < 32; j++) {
    AmigaR[j]=(unhex(text6[j].substring(1, 2)));
    AmigaG[j]=(unhex(text6[j].substring(2, 3)));
    AmigaB[j]=(unhex(text6[j].substring(3, 4)));

    ProcR[j] = int(map(AmigaR[j], 0, 15, 0, 255));
    ProcG[j] = int(map(AmigaG[j], 0, 15, 0, 255));
    ProcB[j] = int(map(AmigaB[j], 0, 15, 0, 255));
    }
}

//-------------------------------------------------------------------
// P3 - ermittelt den Farbwert und speichert ihn in einem String
//-------------------------------------------------------------------
void color_original(){
  for (n=0; n<32; n++) {
    String s = hex(ProcR[n],1)+hex(ProcG[n],1)+hex(ProcB[n],1);
    col_ori[n]=s;
    s="";
  }    
}

//-------------------------------------------------------------------
// P4 - zeigt die Amiga Palette an Color00 bis Color31
//-------------------------------------------------------------------
void color_show() {
  int v=0;
  for (n=0; n<2; n++) {
    for (m=0; m<16; m++) {   
      fill(color(ProcR[v], ProcG[v], ProcB[v]));      
      rect(790+(2*kastenbreite)*m, (2*kastenhoehe)*n, 280+(2*kastenbreite), (2*kastenhoehe)); 
      v++;
    }
  }
  
// nur Spriterelevante Farbregister ohne Schrägstrich anzeigen
  stroke(255);
  for (m=0; m<16; m++) { line(790+(2*kastenbreite)*m, 0 , 790+20+(2*kastenbreite)*m, 20 ); }
  if (attached==0){
    for (m=4; m<16; m++) { line(790+(2*kastenbreite)*m, 20 , 790+20+(2*kastenbreite)*m, 40 ); }  
  }  
  stroke(0);
}

//-------------------------------------------------------------------
// P5 - zeigt das Register und den Farbwert als Text an
//-------------------------------------------------------------------
void color_info(){    
    fill(color(ProcR[v], ProcG[v], ProcB[v]));
    rect(rechter_Rand-60, 42, 60, 60);
    String s = hex(ProcR[v],1)+hex(ProcG[v],1)+hex(ProcB[v],1);
    fill(255,255,255);    rect(rechter_Rand-90,42, 30,20);    fill(0,0,0);    text("C"+v,rechter_Rand-85,57);    
    fill(255,255,255);    rect(rechter_Rand-90,62, 30,20);    fill(0,0,0);    text(s,rechter_Rand-85,77);
    fill(255,255,255);    rect(rechter_Rand-90,82, 30,20);    fill(0,0,0);    text(col_ori[v],rechter_Rand-85,97);    
}

//-------------------------------------------------------------------
// P6 - zeigt die drei Farbverschieber
//-------------------------------------------------------------------
void color_select(){
 //Schieber 1
   fill (180,180,180);   rect(but1ax,but1ay,breite1,hoehe1);
   fill (120,120,120);   rect(but1bx,but1by,breite2,hoehe2);
                         rect(but1cx,but1cy,breite3,hoehe3); 
 // Schieber 2
   fill (180,180,180);   rect(but2ax,but2ay,breite1,hoehe1);
   fill (120,120,120);   rect(but2bx,but2by,breite2,hoehe2);
                         rect(but2cx,but2cy,breite3,hoehe3);
// Schieber 3
   fill (180,180,180);   rect(but3ax,but3ay,breite1,hoehe1); 
   fill (120,120,120);   rect(but3bx,but3by,breite2,hoehe2);
                         rect(but3cx,but3cy,breite3,hoehe3);  
}

//-------------------------------------------------------------------
// P7 - den RGB Farbanteil der ausgewählten Farbe an
//-------------------------------------------------------------------
void color_v_info(){
// Color 0
   fill(255,255,255);    rect(890,42, 30,20);    fill(0,0,0);    text(hex(ProcR[v],1),895,57);
   fill(255,255,255);    rect(890,62, 30,20);    fill(0,0,0);    text(hex(ProcG[v],1),895,77); 
   fill(255,255,255);    rect(890,82, 30,20);    fill(0,0,0);    text(hex(ProcB[v],1),895,97);
}

//-------------------------------------------------------------------
// P8 - Farbe einstellen 
//-------------------------------------------------------------------
void farbwahl(){
// Schieber 1 #############################################################
    if((mouseX > but1cx) &  (mouseX < (but1cx+breite3)) & 
       (mouseY > but1cy) &  (mouseY < (but1cy+hoehe3)& flag1==0)){
         //println("Schieber 1");
         diffx1=  mouseX - but1cx; flag1=1;  
       }
    
      if(mouseX > (but1ax +10) & mouseX < (but1ax + breite1-10)& flag1==1){
         fill (180,180,180);     rect(but1ax, but1ay,breite1,hoehe1,2);
         fill (120,120,120);     rect(but1bx, but1by,breite2,hoehe2);
         but1cx= mouseX-diffx1;  rect(mouseX-diffx1, but1cy, breite3, hoehe3,2);  
         value1= but1cx-but1ax;
       
         value1=int(map(value1,4, 84, 0, 15));
         //println("value1= "+value1);//+"        value2= "+value2);          
         flag4=1;
      }
      
// Schieber 2 #############################################################
    if((mouseX > but2cx) & (mouseX < (but2cx+breite3)) & 
       (mouseY > but2cy) & (mouseY < (but2cy+hoehe3)& flag2==0)){
        diffx2=  mouseX - but2cx; flag2=1;  
       } 
     
      if(mouseX > (but2ax +10) & mouseX < (but2ax + breite1-10)& flag2==1){
        fill (180,180,180);    rect(but2ax, but2ay,breite1,hoehe1,2);
        fill (120,120,120);    rect(but2bx, but2by,breite2,hoehe2);
        but2cx= mouseX-diffx2; rect(mouseX-diffx2, but2cy, breite3, hoehe3,2);  
        value2= but2cx-but2ax;

         value2=int(map(value2,4, 84, 0, 15));
         //println("value2= "+value2);//+"        value2= "+value2);  
         flag4=1;
      }
      
 // Schieber 3 #############################################################
    if((mouseX > but3cx) & (mouseX < (but3cx+breite3)) &
       (mouseY > but3cy) & (mouseY < (but3cy+hoehe3)& flag3==0)){     
        diffx3=  mouseX - but3cx; flag3=1; 
   } 
    
      if(mouseX > (but3ax +10) & mouseX < (but3ax + breite1-10)& flag3==1){
        fill (180,180,180);    rect(but3ax, but3ay,breite1,hoehe1,2);
        fill (120,120,120);    rect(but3bx, but3by,breite2,hoehe2); 
        but3cx= mouseX-diffx3; rect(mouseX-diffx3, but3cy, breite3, hoehe3,2);  
        value3= but3cx-but3ax;

         value3=int(map(value3,4, 84, 0, 15));
         //println("value3= "+value3);//+"        value2= "+value2);  
         flag4=1;
      }

    //println("\n\n"+" 0"+hex(value1,1)+hex(value2,1)+hex(value3,1));
    
    // Color 0
    if (flag4==1){    
         ProcR[v] = int(map(value1, 0, 15, 0, 255));
         ProcG[v] = int(map(value2, 0, 15, 0, 255));
         ProcB[v] = int(map(value3, 0, 15, 0, 255));
         
    // Farben nur ändern wenn auch Mauszeiger im Feld Farbauswahl war     
    color_show();    // color P4 - zeigt die Amiga Palette an Color00 bis Color31      
    color_info();    // color P5 - zeigt das Register und den Farbwert als Text an  
    color_v_info();  // color P7 - den RGB Farbanteil der ausgewählten Farbe an
    sprite_zeichnen();  // sprite P3 - eingelesenes Sprite grafisch anzeigen
        
    flag4=0;    
    }    
}

//-------------------------------------------------------------------
// P9 - Farbwert aus der Palette wählen
//-------------------------------------------------------------------
void color_pick() {
  if (mouseX > 790 & mouseY < 40) {
    v=int(mouseY/20)*16+int((mouseX-790)/20);
    color_info();    // color P5 - zeigt das Register und den Farbwert als Text an
  }
}

//-------------------------------------------------------------------
// P10 - Original Farbwert zurücksetzen
//-------------------------------------------------------------------
void color_original_back(){
    fill(255,255,255);    rect(rechter_Rand-90,62, 30,20);    fill(0,0,0);    text(col_ori[v],rechter_Rand-85,77);
 
    ProcR[v]=int(map(unhex(col_ori[v].substring(0, 1)), 0, 15, 0, 255));
    ProcG[v]=int(map(unhex(col_ori[v].substring(1, 2)), 0, 15, 0, 255));
    ProcB[v]=int(map(unhex(col_ori[v].substring(2, 3)), 0, 15, 0, 255));
        
    fill(color(ProcR[v], ProcG[v], ProcB[v]));
    rect(rechter_Rand-60, 42, 60, 60);
    color_show(); sprite_zeichnen();
}
