// setup
/*
1.
(0,1) Amiga 1000, (0,0) other machines

2.
$000~$05B hard blank (*)
$05c~$080 left soft blank
$081~$1c0 (320px)
$1c1~$1d3 right soft blank

grand total:
($1d4-$05c=376px) max overscan

(*) as the CCK are $e3 -> $1c6 'virtual lo-res pixels', from >=$1c6 you are already on the 'next line'
you can notice this using copper colors, and also using DIWSTOP(x)>=[($e4*2)mod256] that 'open the borders' (§)

(§) you may notice a small discrepancy here because in theory $1c6 should be the value [next line, 'open the border']
in fact Denise's internal counters range from 2 to 455 (they are advanced by 2) and therefore the last reachable position for DIWSTOP(x) is actually $c7.

3.
$000~$019 hard blank (on $019 you get first DMA sprite fetches)
$01a~$02b upper soft blank
$02c~$12b (256py)
$12c~$137 lower soft blank
$138 LOF last line (A1000 usable, other systems only COLOR00)
grand total: ($138-$01a=286px) max overscan  
*/

int sprite_hoehe=13;
int sprite_breite=16;

void setup() {  
  size(468, 312); // horizontal: $0 to $1d3 = 468, vertical. $0 to $137 = 312
  
  stroke(0,0,255);  fill(10);   rect(0x00,0x00,0x5b,0x138); // hard blank horizontal
  stroke(0,0,255);  fill(10);   rect(0x00,0x00,0x1d3,0x19); // hard blank horizontal
  stroke(0,255,0);  fill(100);  rect(0x5c,0x1a,375,286);    // black border  (soft blank)
  stroke(255,0,0);  fill(255);  rect(0x81,0x2c,320,256);    // lowres-screen  DIWSTART $2c81 
  // grand total: ($1d4-$05c=376px) and ($138-$01a=286px) max overscan max overscan
  
 //-------------------------------------------------------------------------------------------
 //  DIWSTRT($5c1a)  DIWSTRT upper left corner
 //  DIWSTRT($5c37)  DIWSTRT lower left corner  y=$138-256 =$38 (56)     56+255=311 = $137
 //  DIWSTRT($931a)  DIWSTRT upper right corner x=$1d4-320 =$94 (148)    148+320= 468 = $1d4
 //  DIWSTRT($9337)  DIWSTRT lower right corner 
// stroke(255,0,0);  fill(0,100,0);  rect(0x5c,0x1a,320,256);    // lowres-screen  DIWSTART $1a5c
// stroke(255,0,0);  fill(0,100,0);  rect(0x5c,0x38,320,256);    // lowres-screen  DIWSTART $385c
// stroke(255,0,0);  fill(0,100,0);  rect(0x94,0x1a,320,256);    // lowres-screen  DIWSTART $1a94
//  stroke(255,0,0);  fill(0,100,0);  rect(0x94,0x38,320,256);    // lowres-screen  DIWSTART $1a94
//-------------------------------------------------------------------------------------------
  //sprite();
  sprite2();
}

void sprite(){
 int screen_width=320;
 //int screen_high=256;
 int sprite_width=16;
 int sprite_high=13; 
 int x_offset=0x81;
 int y_offset=0x2c;
 int x_grenze=x_offset+screen_width-sprite_width;
 int y_grenze=0xFF-sprite_high;
 
 stroke(100,0,0);
 rect(x_offset,y_offset,sprite_width,sprite_high);   //sprite left up
 rect(x_grenze,y_offset,sprite_width,sprite_high);   //sprite right up
 rect(x_offset,y_grenze,sprite_width,sprite_high);   //sprite left down
 rect(x_grenze,y_grenze,sprite_width,sprite_high);   //sprite right down
 
 stroke(0,0,100);  
 line(0x81,0xFF,0x81+320,0xFF);    // vertikale Begrenzung im Augenblick 0xFF
 
 println("x_grenze ="+hex(x_grenze/2));
 println("y_grenze ="+hex(y_grenze)); 
}

void sprite2(){  
  stroke(0,0,100);  
  line(0x81,0xFF,0x81+320,0xFF); 
    
  stroke(100,0,0); rect(0x81,0x2c,sprite_breite,sprite_hoehe);                       //sprite left up
  stroke(100,0,0); rect(0x81+320-sprite_breite,0x2c,sprite_breite,sprite_hoehe);     //sprite left up
  stroke(100,0,0); rect(0x81,0xFF-sprite_hoehe,sprite_breite,sprite_hoehe);          //sprite right down  
  stroke(100,0,0); rect(0x81+320-sprite_breite,0xFF-sprite_hoehe,sprite_breite,sprite_hoehe); //sprite right down  
}
