// 8x8Pixel Font-Viewer

int n, m, v, value;
int kastenbreite=10;
int kastenhoehe=10;
byte b[];             //byte b[] = loadBytes("nice.fnt");       // Open a file and read its binary data 

void setup() { 
  size(1000, 1000);   
  background(200, 200, 200);
  Werte();
  grid_dim();
  //grid_dim_test();
  Fontdaten_ausgeben();
}

//-------------------------------------------------------------------
// P1 - liest die Font-Datei ein (die Bytes)
//-------------------------------------------------------------------
void Werte() {
  b = loadBytes("nice.fnt");               // nice.fnt, logo.fnt
  for (int i = 0; i < b.length; i++) {     // Print each value, 
    // Every eights number, start a new line 
    if ((i % 8) == 0) {println(); } 
    // bytes are from -128 to 127, this converts to 0 to 255 
    // int a = b[i] & 0xff;  //print(hex(a) + " "); 
    print(hex(b[i]) + " ");
  }
}

//-------------------------------------------------------------------
// P2 - zeigt Gitter für Font-Daten an
//-------------------------------------------------------------------
void grid_dim() {
  int zeilen = 8*10;    // font_Y * kastenhoehe
  int spalten = 8*10;   // font_X * kastenbreite
  for (n=0; n<zeilen; n++) {    // Anzahl der Zeilen
    for (m=0; m<spalten; m++) {      // "Pixel" Felder pro Zeile        
      fill(200, 200, 200);
      rect(kastenbreite*m, kastenhoehe*n, kastenbreite, kastenhoehe);
    }
  }
}

//-------------------------------------------------------------------
// für dickere Felder um die einzelnen Zeichen
void grid_dim_test(){
  int zeilen = 8*10;
  strokeWeight(1);
  for (n=0; n<zeilen; n++) {
    for (m=0; m<8*10; m++) {  
      if ((n%8==0) && (m%8==0)) {
        strokeWeight(2); 
        fill(200, 200, 200);
        rect(kastenbreite*m, kastenhoehe*n, kastenbreite*8, kastenhoehe*8);
      } else {
        strokeWeight(1); 
        fill(200, 200, 200);
        rect(kastenbreite*m, kastenhoehe*n, kastenbreite, kastenhoehe);
      }
    }
  }  
}

void Fontdaten_ausgeben() {
  m=0; n=0;
  int z=0;  int l=0;  int o=0;
  println();
  println("Länge "+b.length+" /8= "+b.length/8);    // Länge und Anzahl zeichen ausgeben

  //println();
  //println("Element 8 "+hex(b[24], 2));              // Wert aus Hex-Wert zur Kontrolle  
  //println("Element 8 "+binary(b[24], 8));           // Wert aus Bin-Wert zur Kontrolle
  
  for (int k=0; k<b.length/8; k++) {                      // k = das aktuelle Zeichen
    z++;                                                  // Anzahl Zeichen = Zeichenzähler
    for (int j=0; j<=7; j++) {                            // Schleife über alle 8 Bytes eines Zeichens
      int shiftwert =7;
      m=0;                                                // mit erstem Pixel in Zeile beginnen
      for (int i=0; i<=7; i++) {                          // das Byte Bit für Bit (ein Byte ist eine Zeile)
        int einzelwert = (b[k*8+j]>>shiftwert) & 0x01;    // das Zeichen*8+Zeile
        shiftwert--;

        if (einzelwert == 1) {                            // Wenn Pixel 1 ist
          fill(color(0, 0, 200));                         // dann zeichnen
          rect(kastenbreite*m+(l*80), kastenhoehe*n+(o*80), kastenbreite, kastenhoehe);
        }
        m++;                                              // nächster Pixel in der Zeile  
      }                                                   // Schleife Zeile zu Ende 
      n++;                                                // eine Zeile tiefer
    }
    l++;                                                  // horizontaler Offset (Abstand) des Zeichens im Gitter, jeweils 8Pixel weiter 
    if (z>0 && (z%10)==0) {                               // alle 10 Zeichen neue Reihe beginnen
      o++;
      l=0;                                                // wenn neue Reihe, dann wieder von vorn beginnen
    }
    n=0;                                                  // n=aktuelle Zeile des Charakters (wieder von vorn) 
  }
}
