
// Screen
int DIWSTRT_Y = 0x2c;
int DIWSTRT_X = 0x81;
int DIWSTOP_Y = 0x2c;
int DIWSTOP_X = 0xc1;
int DDFSTRT  = 0x38;
int DDFSTOP  = 0xd0;
int NBPLS=0;              // <- screen colordepth in bitplanes

// Constants
int CCKS_PER_LINE = 227;              // color clocks / dma slots per PAL line
int PAL_LINES_LOF = 313;              // number of long frame PAL lines (standard PAL mode setup by Kickstart)

void setup(){
                                                     println("CCKS_PER_LINE="+CCKS_PER_LINE);
int CLKS_PER_LINE = CCKS_PER_LINE*2;                 println("CLKS_PER_LINE="+CLKS_PER_LINE);       // CPU clock ticks per PAL line
int NOPS_PER_NBLINE = CLKS_PER_LINE/4;               println("NOPS_PER_NBLINE="+NOPS_PER_NBLINE);   // Number of NOP instructions fitting into a non-display line

int DIWSTRT = (DIWSTRT_Y<<8)|(DIWSTRT_X);            println("DIWSTRT="+hex(DIWSTRT,4));            // 0x2c81
int DIWSTOP = (DIWSTOP_Y<<8)|(DIWSTOP_X);            println("DIWSTOP="+hex(DIWSTOP,4));            // 0x2cc1
int Y_END   = ((~DIWSTOP_Y & 0x80)<<1)|DIWSTOP_Y;    println("Y_END="+hex(Y_END,4));                // 0x12c
//-----------
int BPL_LINES = Y_END-DIWSTRT_Y;                     println("BPL_LINES="+BPL_LINES);               // how many lines of display?
int NOT_BPL_LINES = PAL_LINES_LOF-BPL_LINES;         println("NOT_BPL_LINES="+NOT_BPL_LINES);       // number of lines that are not used for bitplane display
int NBLINE_NOPS = NOPS_PER_NBLINE*NOT_BPL_LINES;     println("NBLINE_NOPS="+NBLINE_NOPS);           // Calculate the number of NOPs and available CPU clocks/frame
//-----------
int BPL_DMA_WORDS = 1+((DDFSTOP-DDFSTRT)>>3);         println("BPL_DMA_WORDS="+BPL_DMA_WORDS);       // how many words per line will be fetched for a single bitplane:
int NUM_COLOR_REGS = (1<<NBPLS)-((5-NBPLS)>>3); //&32; 
                                                      println("NUM_COLOR_REGS="+NUM_COLOR_REGS);     // how many color registers do we need to set for this screen?
int ODD_CCKSperWORD = ((NBPLS&4)*(NBPLS-4))>>2;       println("ODD_CCKSperWORD="+ODD_CCKSperWORD);   // for each 16 pixels, how many dma fetches will fall on an odd cycle?                  
int ODD_CCKSperLINE = ODD_CCKSperWORD*BPL_DMA_WORDS;  println("ODD_CCKSperLINE="+ODD_CCKSperLINE);   // for each line of display, how many odd cycle dma fetches do we have?                  
int ODD_NOPSperLINE = ODD_CCKSperLINE;                println("ODD_NOPSperLINE="+ODD_NOPSperLINE);   // how many nops will we fail to do during a bitplane dma fetch per line?                         
int NOPS_PER_BLINE = NOPS_PER_NBLINE-ODD_NOPSperLINE; println("NOPS_PER_BLINE="+NOPS_PER_BLINE);     // Number of NOP instructions fitting into a display line           
int BLINE_NOPS = NOPS_PER_BLINE*BPL_LINES;            println("BLINE_NOPS="+BLINE_NOPS);                 
int NOPS_PER_FRAME = (NBLINE_NOPS+BLINE_NOPS);        println("NOPS_PER_FRAME="+hex(NOPS_PER_FRAME,5)+"  NOPS_PER_FRAME="+NOPS_PER_FRAME);                

int CYCLES = (NBLINE_NOPS+BLINE_NOPS)*4;              println("CYCLES="+CYCLES); 
//-----------
int SETCOLORS_CLKS = 2*8 ;                                                                           // count non-nop code that we have to do in each frame
int JMP_IMM_CLKS = 12;
int WANT_MOUSE = 0;
int MOUSETST_CLKS =  WANT_MOUSE*28;
int INSN_CLKS = SETCOLORS_CLKS+JMP_IMM_CLKS+MOUSETST_CLKS;
int INSN_NOPS = INSN_CLKS/4;
//-----------
int nops = NOPS_PER_FRAME-INSN_NOPS;                 println("NOPS="+hex(nops,5)+" NOPS="+nops);     // number of nops we will generate for our per-frame code
int nops_dif=(NOPS_PER_FRAME-nops)*4;                println("nops_dif="+nops_dif);
}
