
; Listing28b2.s - Zeichen seriell empfangen (ohne Interrupt)
; Achtung: es mssen mindestens drei Zeichen empfangen werden

	SECTION	SERIAL,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; Speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ %1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)


Start:
	lea		$dff000,a6			; Custom Register Base in a6
	move.l	#Copperlist,$80(a6)	; Zeiger Copperlist	
	move.w	#DMASET,$96(a6)		; DMACON - aktivieren Copper und Bitplane DMA
	;move.w	#0,$1fc(a6)			; AGA "deaktivieren"
	;move.w	#$c00,$106(a6)		; AGA "deaktivieren"
	;move.w	#$11,$10c(a6)		; AGA "deaktivieren"
	;move.w  #$7fff,$9a(a6)		; INTENA - disable all interrupts
	move.w  #$0800,$9a(a6)		; es gengt das
	move.w  #$7fff,$9c(a6)		; INTREQ - clear all pending interrupts
	
Init:
	; *** SET SERIAL PORT SETTINGS
	move.w	#368,$32(a6)		; SERPER	; set baud rate (bit 15=parity bit) 9600 on PAL
	;move.w	#183,SERPER	; 19200 BAUD

WarteY:							
	bsr		ReadSerial			; das empfangene Zeichen auslesen ('A')
	bsr		Zeichen				; Zeichen auswerten

	bsr		ReadSerial			; das empfangene Zeichen auslesen ('B')
	bsr		Zeichen				; Zeichen auswerten
	
	bsr		ReadSerial			; das empfangene Zeichen auslesen ('C')	
	bsr		Zeichen				; Zeichen auswerten

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt? 
	bne.s	Mouse	


	rts							; Exit

*******************************************************************************
* In dieser Routine wird das Zeichen empfangen				                  *
*******************************************************************************

; Bit 7-0 -> DB7-DB0 Low 8 data bits of received data. Data is TRUE (data
; you read is the same polarity as the data expected).

; *** Reads serial port subroutine
	; **
	; * Returns d0=read character
	; *
ReadSerial:
	lea $dff018,a5			; SERDATR
.rs
	btst #14-8,(a5)			; SERDATR - RBF, wenn '1' dann zur Abholung bereit
	;btst #14-8,(a5)		; ist das geiche wie
	;btst #6,(a5)			; ist das geiche wie
	beq .rs
	move.b 1(a5),d0			; SERDATR
	move.w #$0800,$9c(a6)	; reset RBF in INTREQ
	
	rts

*******************************************************************************
* In dieser Routine wird das Zeichen ausgewertet			                  *
*******************************************************************************

Zeichen:
	cmp.b	#'A',d0
	beq	Red
	cmp.b	#'B',d0
	beq	Green
	cmp.b	#'C',d0
	beq	Blue
	rts
Red:
	move.w	#$f00,Col
	rts
Green:
	move.w	#$0f0,Col
	rts
Blue:
	move.w	#$00f,Col
	rts

*******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:						; hier nicht bentigt
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180				; COLOR00
Col:
	dc.w	$00e				; COLOR00 blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end

