
; Listing28b.s - ein Zeichen seriell ausgeben (ohne Interrupt)

	SECTION	SERIAL,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; Speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000000000000000	; kein DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)


Start:
	lea		$dff000,a6			; Custom Register Base in a6
	;move.l	#Copperlist,$80(a6)	; Zeiger Copperlist	
	move.w	#DMASET,$96(a6)		; DMACON - aktivieren Copper und Bitplane DMA
	;move.w	#0,$1fc(a6)			; AGA "deaktivieren"
	;move.w	#$c00,$106(a6)		; AGA "deaktivieren"
	;move.w	#$11,$10c(a6)		; AGA "deaktivieren"
	move.w  #$7fff,$9a(a6)		; INTENA - disable all interrupts
	move.w  #$7fff,$9c(a6)		; INTREQ - clear all pending interrupts
	
Init:
	; *** SET SERIAL PORT SETTINGS
	move.w	#368,$32(a6)		; SERPER	; set baud rate (bit 15=parity bit) 9600 on PAL
	;move.w	#183,SERPER	; 19200 BAUD

WarteY:							
	move.l	4(a6),d0			; $dff004 - VPOSR/VHPOSR
	andi.l	#$1ff00,d0			; wirkt sich nur auf die Bits der vertikalen Zeile aus
	cmpi.l	#$02c00,d0			; warte auf Zeile  $2c
	bne.s	WarteY

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse	
				
	bsr		WriteSerial			; das Zeichen 'A' senden

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt? 
	bne.s	WarteY				
	
	rts							; Exit


*******************************************************************************
* In dieser Routine wird das Zeichen gesendet				                  *
*******************************************************************************
	
	; *** Write serial port subroutine
	; **
	; * Parameter d0.b=write character

WriteSerial:
	move.w	$18(a6),d1			; SERDATR
	btst	#13,d1
	;btst	#13,$18(a6)			; SERDATR Bit 13 TBE
	beq		WriteSerial

; Solange Bit 13 in SERDATR (TBE TRANSMIT BUFFER EMPTY) Null ist, warte ich;
; dann schreibe ich meine Daten in SERDAT.

	move.w	  #'A',d0			; 0x60 = ASCII = A
	ori.w	#$0100,d0			; Stopp-Bit setzen 8N1
	move.w		d0,$30(a6)		; SERDAT	030
	;move.w #$0160,$dff030		; 0x60 = ASCII = A	
	
	rts

*******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:						; hier nicht bentigt
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$00e			; COLOR00 blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end


Durch Schreiben von Daten in SERDAT ($dff030) startet das Senden sofort nach
dem die Daten in SERDAT bertragen wurden. Nach dem Schreiben wird das TBE 
Interrupt Bit gesetzt und signalisiert das, der Sendepuffer wieder frei ist.
Solange wir eine Null auslesen ist der serielle Schiebepuffer noch nicht leer
und wir knnen noch kein neues Zeichen bertragen.

Das Bit 'TBE' Transmitter Buffer Empty wird auf '1' gesetzt nach der
abgeschlossenen bertragung. 