
; Listing27c5.s		PowerSupply Frequenz ermitteln 50Hz/60Hz	
	
	SECTION	CIA,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; Speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper und Bitplane DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Bitplane,d0		; Adresse des Bitplane in d0
	lea	Bplpointers,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea		$dff000,a6			; Custom Register Base in a6
	move.l	#Copperlist,$80(a6)	; Zeiger Copperlist	
	move.w	#DMASET,$96(a6)		; DMACON - aktivieren Copper und Bitplane DMA
	move.w	#0,$1fc(a6)			; AGA "deaktivieren"
	move.w	#$c00,$106(a6)		; AGA "deaktivieren"
	move.w	#$11,$10c(a6)		; AGA "deaktivieren"
	;move.w  #$7fff,$9a(a6)		; INTENA - disable all interrupts
	;move.w  #$7fff,$9c(a6)		; INTREQ - clear all pending interrupts
		
Init:
	bsr CIA_					; die PowerSupply Frequenz ermitteln

WarteY:							
	move.l	4(a6),d0			; $dff004 - VPOSR/VHPOSR
	andi.l	#$1ff00,d0			; wirkt sich nur auf die Bits der vertikalen Zeile aus
	cmpi.l	#$02c00,d0			; warte auf Zeile  $10
	bne.s	WarteY

	bsr	Zeit

Mouse:
	btst	#6,$bfe001			; Maus gedrckt? (Der Prozessor 
	bne.s	WarteY				; unterbricht die Schleife alle 10ms um die Farbe zu ndern

	rts							; Exit

*******************************************************************************
* In dieser Routine wird die untere Warteposition Y2Wert ermittelt            *
*******************************************************************************
	
Zeit: 
	movem.l d0-d2/a0-a3,-(sp)
;--- Zeile ermitteln ---------
	move.w	Frequenz(pc),d0			; Rasterzeile
	;move.w #$45,d0					; zu Testzwecken - den festen Wert $45 = 69 ausgeben
_timeDisplayCounter:
	and.l #$0000FFFF,d0
	moveq #0,d1
	moveq #3-1,d2
_timeLoopNumber:
	divu #10,d0						; => d0=remainder:quotient of the division of d0 coded on 32 bits
	swap d0
	add.b #$30-$20,d0				; ASCII code for "0" minus the first character offset in font8 ($20)
	move.b d0,d1
	lsl.l #8,d1
	clr.w d0
	swap d0
	dbf d2,_timeLoopNumber
	
	divu #10,d0						; => d0=remainder:quotient of the division of d0 coded on 32 bits
	swap d0
	add.b #$30-$20,d0				; ASCII code for "0" minus the first character offset in font8 ($20)
	move.b d0,d1

									; => d1 : d1 : sequence of 4 ASCII offsets in the font for the 4
									; characters to display, but in reverse order (ex: 123 => "3210")
									
;--- Zeichen drucken ---------
	;move.l #$11191210,d1			; zu Testzwecken Zeichen  0291
	lea font8,a0					; Adresse Font 8x8 Pixel			
	lea Bitplane,a1					; Startadresse Bitplane
	moveq #4-1,d0					; Anzahl der Zeichen
_timeLoopDisplay:					; Label Schleife
	clr.w d2	
	move.b d1,d2					; zu druckendes Zeichen in d2 kopieren
	lsl.w #3,d2						; *8, weil Zeichen 8x8 Pixel hat um zu berspringen
	lea (a0,d2.w),a2				; das entsprechende Zeichen im Font finden (Anfangsadresse)
	move.l a1,a3					; Adresse Bitplane kopieren
	moveq #8-1,d2					; Schleife ber 8 Zeilen des Zeichens
_timeLoopDisplayChar:				; Label Schleife Charakter
	move.b (a2)+,(a3)				; Zeichen nach Bitplane kopieren		
	lea 320>>3(a3),a3				; 320>>3=$28 = 40Bytes --> nchste Zeile
	dbf d2,_timeLoopDisplayChar
	lea 1(a1),a1					; 1 Byte vor in Bitplane
	lsr.l #8,d1						; in d1 stehen 4 Werte, den nchsten Wert auswhlen
	dbf d0,_timeLoopDisplay

	movem.l (sp)+,d0-d2/a0-a3
	rts
	
*******************************************************************************
* In dieser Routine wird PowerSupply Frequenz ermittelt (original)			  * 
*******************************************************************************

; timer.device

Cia:
	lea $bfe001,a0			; lea	_ciaa,a0
	lea $bfe001,a1			; lea	_ciaa,a1
	
	bclr.b	#7,$f00(a1)		; bclr.b	#CIACRBB_ALARM,ciacrb(a1)
	move.b	#0,$a00(a1)		; move.b	#0,ciatodhi(a1)
	move.b	#0,$900(a1)		; move.b	#0,ciatodmid(a1)
	move.b	#0,$800(a1)		; move.b	#0,ciatodlow(a1)

	;------ now check for the power supply frequency
	
	move.b	#$00,$f00(a0)	; MOVE.B	#CIACRBF_RUNMODE,ciacrb(A0)	
	move.b	#$ff,$600(a0)	; MOVE.B	#$FF,ciatblo(A0)
	move.b	#$ff,$700(a0)	; MOVE.B	#$FF,ciatbhi(A0)

	;------ here is how we are going to tell the time in
	;------ a processor independent fashion: we will count
	;------ the time between two ticks of the tod register

	move.b	$800(a1),d0		; move.b	ciatodlow(a1),d0
waitTODl1:
	tst.b	$700(a0)		; tst.b	ciatbhi(a0)
	beq.s	NoTOD
	cmp.b	$800(a1),d0		; cmp.b	ciatodlow(a1),d0
	beq.s	waitTODl1
waitTODe1:

	move.b	#%00010001,$f00(a0)		; Timer B starten
	;MOVE.B	#CIACRBF_RUNMODE!CIACRBF_START!CIACRBF_LOAD,ciacrb(A0)

	move.b	$800(a1),d0		; move.b	ciatodlow(a1),d0
waitTODl2:
	tst.b	$700(a0)		; tst.b	ciatbhi(a0)
	beq.s	NoTOD
	cmp.b	$800(a1),d0		; cmp.b	ciatodlow(a1),d0
	beq.s	waitTODl2
waitTODe2:
							; stoppen	
	move.b  #%00000000,$f00(a0)		; MOVE.B	#CIACRBF_RUNMODE,ciacrb(A0)

	;------ look at the count value and make a guess
	;------ at the power supply value
	moveq	#0,d0			; clear d0
	move.b	$700(a0),d0		; MOVE.B	ciatbhi(A0),D0
	lsl.l	#8,d0
	move.b	$600(a0),d0		; MOVE.B	ciatblo(A0),D0

	;------	Hertz	NTSC	PAL		count	test
	;------ 60		11932	11923	13060	$ccfc		; 11923 --> falsch --> 11823 ist richtig
	;------ 50		14318	14188	18982	$b5da
	;------ 30		23864	23646	26120	$99f8
	;------ 25		28636	28375


; >?$ffff-$ccfc
; $00003303 = %00000000`00000000`00110011`00000011 = 13059 = 13059

;>?$ffff-$b5da
; $00004A25 = %00000000`00000000`01001010`00100101 = 18981 = 18981


Try60Hz:
	cmp.w	#$ccfc,d0
	bcs.s	Try50Hz		; bcs=blo	=> OP2 < OP1, ohne Vorzeichen
	move.w	#60,d0
	move.w	#16667,d1
	bra.s	StuffTOD	; Ergebnis
Try50Hz:
	cmp.w	#$b5da,d0
	bcs.s	Try30Hz
	move.w	#50,d0
	move.w	#20000,d1
	bra.s	StuffTOD
Try30Hz:
	cmp.w	#$99f8,d0
	bcs.s	Try25Hz
	move.w	#30,d0
	move.w	#33333,d1
	bra.s	StuffTOD
Try25Hz:
	move.w	#25,d0
	move.w	#40000,d1

StuffTOD:
	move.w	d0,Frequenz
	;move.w	d0,TD_TODHERTZ(a2)
	;move.w	d1,TD_TIMEPERTOD(a2)
NoTOD:
	rts

*******************************************************************************
* In dieser Routine wird die PowerSupply Frequenz ermittelt				      * 
*******************************************************************************

Cia_:
	lea $bfe001,a0			; CIA-A Base	
	bclr.b	#7,$f00(a0)		; Tod Clock CIA-A CRB Clock/ALARM-Bit
	move.b	#0,$800(a0)		; todlow

	;------ now check for the power supply frequency
	
	; Timer B - Stop und Runmode
	andi.b  #%11000000,$f00(a0)	; setzt Bit 0-5 zurck
	move.b	#$ff,$600(a0)	; tblo
	move.b	#$ff,$700(a0)	; tbhi

	;------ here is how we are going to tell the time in
	;------ a processor independent fashion: we will count
	;------ the time between two ticks of the tod register

	move.b	#%00010001,d1	; Timer Start
	move.b	#%11000000,d2	; Timer Stop
	lea		$bfef01,a1

	move.b	$800(a0),d0		; todlow aktuell
waitTODl1_:	
	cmp.b	$800(a0),d0		; warten bis Vsync auftritt - neues Frame
	beq.s	waitTODl1_

	ori.b	d1,(a1)			; jetzt Timer B starten (mit $ffff)
	
	move.b	$800(a0),d0		; todlow - neue Startwert 
waitTODl2_:
	cmp.b	$800(a0),d0		; warten bis Vsync auftritt - neues Frame
	beq.s	waitTODl2_

	and.b  d2,(a1)			; jetzt Timer B stoppen			

	;------ look at the count value and make a guess
	;------ at the power supply value
	move.b	$700(a0),d0		; tbhi auslesen
	lsl.l	#8,d0
	move.b	$600(a0),d0		; tblo auslesen
		
	move.w  d0,CountValue		; der aus Timer B ausgelesene Wert
Try60Hz_:	
	move.w	#$d134,CmpValue		; der feste Vergleichswert	
	cmp.w	#$d134,d0			
	bcs.s	Try50Hz_			; bcs=blo	=> OP2 < OP1, ohne Vorzeichen
	move.w	#60,Frequenz		; Frequenz
	;move.w	#16667,d1			; nicht daran interessiert
	bra.s	StuffTOD_			; Ergebnis
Try50Hz_:
	move.w	#$c874,CmpValue		; der feste Vergleichswert
	cmp.w	#$c874,d0			; c87b < c874	
	bcs.s	NoTOD_
	move.w	#50,Frequenz		; Frequenz
	;move.w	#20000,d1			; nicht daran interessiert
StuffTOD_:
	moveq	#-1,d5				; $ffff
	sub.w	d0,d5				; d5=d5-d1
	move.w  d5,TimerTakte		; von 0 gezhlte Takte
NoTOD_:
	rts

Frequenz:		dc.w	0	; 50Hz / 60Hz
CountValue:		dc.w	0	; der aus Timer B ausgelesene Wert 
CmpValue:		dc.w	0	; der feste Vergleichswert			#$d144   oder  #$c874
TimerTakte:		dc.w	0	; die gezhlten Timer B Timertakte

*******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81	; DiwStrt
	dc.w	$90,$2cc1	; DiwStop	
	dc.w	$92,$38		; DdfStart
	dc.w	$94,$d0		; DdfStop
	dc.w	$102,0		; BplCon1
	dc.w	$104,0		; BplCon2
	dc.w	$108,0		; Bpl1Mod
	dc.w	$10a,0		; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres	

Bplpointers:
	dc.w	$e0,0,$e2,0	; erste Bitplane

	dc.w	$180,$00f	; Color0	; Hintergrund Schwarz
	dc.w	$182,$0f0	; Color1	; Farbe 1 der Bitplane
	
	dc.w	$3401,$fffe
	dc.w	$0100,$0200
							
	dc.w	$ffff,$fffe	; Ende der Copperlist

Font8:		
	incbin "/Sources/font8.fnt"

******************************************************************************

	SECTION LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres
	
	end

	
;------------------------------------------------------------------

;------	Hertz	NTSC	PAL		count			test						 cmp       gemessen 
;------ 60		11932	11823	(11932+40)		?$ffff-!11972-1 => $d134 -> 5)3562		
;------ 50		14318	14188	(14188+30)		?$ffff-!14218-1 => $c874 -> 5)1316		1327


; NTSC 60Hz - 11932  (Test 11940 ?)
>?$ffff-!11932
$0000D163 = %00000000`00000000`11010001`01100011 = 53603 = 53603
>?$ffff-!11940
$0000D15B = %00000000`00000000`11010001`01011011 = 53595 = 53595
>

; PAL 50Hz - 14188  (Test 14204)
>?$ffff-!14188
$0000C893 = %00000000`00000000`11001000`10010011 = 51347 = 51347
>?$ffff-!14204
$0000C883 = %00000000`00000000`11001000`10000011 = 51331 = 51331
>

>?$ffff-!14218-1
$0000C874 = %00000000`00000000`11001000`01110100 = 51316 = 51316
>11001000`10000011 = 51331 = 51331
>

>?$ffff-!14218-1
$0000C874 = %00000000`00000000`11001000`01110100 = 51316 = 51316
>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
