
; Listing27b.s
; Portausgang schalten - Power LED ein-/ ausschalten

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; disable
	lea	$bfe001,a5				; CIAA base is also CIAAPRA

Mouse:
	btst	#6,$bfe001
	bne.s	Mouse				; /FIR0 - linke Maustaste
	
	bchg.b	#1,(a5)				; /LED - Power LED toggel ein/aus
	
Mouse2:
	btst	#2,$dff016			; rechte Maustaste
	bne.s	Mouse2

	bchg.b	#1,(a5)				; /LED - Power LED toggel ein/aus

Mouse3:
	btst	#6,$bfe001			; /FIR0 - linke Maustaste
	bne.s	Mouse3
	;btst	#7,$bfe001			; /FIR1 - Feuerknopf Joystick
	;bne.s	Mouse3
	
	move.l	4.w,a6				; Execbase in a6
	jsr	-$7e(a6)				; enable
	rts
			
	end
	
Das Datenrichtungsregister DDRA ist voreingestellt.
Der Portausgang ist low-aktiv (/LED). Dh.
bset.b #1,(a4)				; Power LED aus (low-aktiv)
bclr.b #1,(a4)				; Power LED ein

Genauso wie das Abfragen, der Maustaste (/FIR0) auch low-aktiv ist.
Wenn die Maustaste nicht gedrckt wird lesen wir eine '1' an Bit 6.

BNE oder BEQ wertet das Z-Flag aus. Die Anweisung BTST testet ob das angegebene
Bit ZERO ist. Wenn eine '1' an der Bitstelle ausgelesen wird, wird das Z-Flag
nicht gesetzt. Somit wre die Bedingung 'ungleich' erfllt. Erst beim
Auslesen einer '0' wre die Bedingung 'gleich' erfllt.

$BFE001		CIAAPRA		/FIR1 /FIR0 /RDY /TK0 /WPRO /CHNG /LED OVL
$BFE101		CIAAPRB		Parallel port
$BFE201		CIAADDRA	Direction for port A (BFE001);1=output (set to 0x03)
$BFE301		CIAADDRB	Direction for port B (BFE101);1=output (can be in or out)

>c		; WinUAE Debugger
A: CRA 00 CRB 08 ICR 00 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00													; PRA und DDRA
   TOD 001184 (001184) ALARM 000000 -- CYC=000013BA4B603000
B: CRA 08 CRB 88 ICR 04 IM 00 TA 0140 (0140) TB 07d0 (07d0)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 000069 (00ffff) ALARM 0000ac --

PRA c0 PRB 00 DDRA 03 DDRB 00
>?$c0	= %11000000 	; Wert PRA	
>?$03	= %00000011		; Wert DDRA

CIA-A  Address BFEr01  data bits 7-0  (A12*) (INT2)

PA7..	game port 1, pin 6 (fire button*)
PA6..	game port 0, pin 6 (fire button*)
PA5..	RDY*      disk ready*
PA4..	TK0*      disk track 00*
PA3..	WPRO*     write protect*
PA2..	CHNG*     disk change*
PA1..	LED*      led light (0=bright)
PA0..	OVL       memory overlay bit
SP...	KDAT      keyboard data
CNT..	KCLK      keyboard clock

PB7..	P7         data 7
PB6..	P6         data 6
PB5..	P5         data 5     Centronics parallel interface
PB4..	P4         data 4          data
PB3..	P3         data 3
PB2..	P2         data 2
PB1..	P1         data 1
PB0..	P0         data 0
PC...	drdy*                Centronics control
F....	ack* 