
; Listing25g2.s		attached Sprites berlappen sich nicht
; Farbzuordnung bei sich nicht berlappenden Attacht Sprites

	SECTION ROCK'NROLL,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte COP

	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	
	bsr InitSprites				; Sprites vorbereiten

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

*******************************************************************************
* Diese Routine stellt die Sprites ein									      *
*******************************************************************************

InitSprites:
	;move.w  #$18,Ddfstrt+2			; Verhalten DDFSTRT 
	;move.b	#$50,Hstart1			; Sprites berlappen sich nicht
	;move.b	#$40,Hstart1			; Sprites berlappen sich voll
	;bset	#7,MeinSprite0+3	; hat keinen Einfluss
	bset	#7,MeinSprite1+3	; Setzt das Bit fr Attached beim
								; Sprite 1. Ohne ihm sind die Sprites
								; nicht ATTACHED, sondern "normal"

	lea	SpritePointers,a0	; Pointer in der Copperlist
	move.l	#MeinSprite0,d0	; Adresse des Sprite in d0	
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	;rts ; bei DDFSTRT $18
	
	move.l	#MeinSprite1,d0	; Adresse des Sprite in d0
	addq.w	#8,a0			; nchsten Spritepointer
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	rts


******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DIWSTRT
	dc.w	$90,$3891		; DIWSTOP
Ddfstrt:
	dc.w	$92,$38			; DDFSTRT
	dc.w	$94,$40			; DDFSTOP
	dc.w	$102,0			; BPLCON1
	dc.w	$104,0			; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an, 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

;	Palette der PIC

	dc.w	$180,$000		; Color0	; schwarzer Hintergrund
	dc.w	$182,$123		; Color1	; Color 1 des Bitplane, das
							; in diesem Fall leer ist,
							; also nicht erscheint

;	Palette der ATTACHED-SPRITE
;---	
	dc.w	$1a2,$000		; COLOR16, - Color0 der Sprite0/1 -schwarz (transparent)
	dc.w	$1a2,$f00		; COLOR17, - Color1 der Sprite0/1 -rot
	dc.w	$1a4,$0f0		; COLOR18, - Color2 der Sprite0/1 -grn
	dc.w	$1a6,$00f		; COLOR19, - Color3 der Sprite0/1 -blau
;---
	dc.w	$1a8,$fff		; COLOR20, - Color0 der Sprite2/3 -wei (transparent)
	dc.w	$1aa,$ff0		; COLOR21, - Color1 der Sprite2/3 -mangenta
	dc.w	$1ac,$0ff		; COLOR22, - Color2 der Sprite2/3 -gelb	
	dc.w	$1ae,$f0f		; COLOR23, - Color3 der Sprite2/3 -cyan
;---
	dc.w	$1b0,$888		; COLOR24, - Color0 der Sprite4/5 -hellgrau (transparent)
	dc.w	$1b2,$800		; COLOR25, - Color1 der Sprite4/5 -hellrot
	dc.w	$1b4,$080		; COLOR26, - Color2 der Sprite4/5 -hellgrn
	dc.w	$1b6,$008		; COLOR27, - Color3 der Sprite4/5 -hellblau
;---
	dc.w	$1b8,$333		; COLOR28, - Color0 der Sprite6/7 -dunkelgrau (transparent)
	dc.w	$1ba,$880		; COLOR29, - Color1 der Sprite6/7 -hell mangenta
	dc.w	$1bc,$088		; COLOR30, - Color2 der Sprite6/7 -hell gelb
	dc.w	$1be,$808		; COLOR31, - Color3 der Sprite6/7 -hell cyan

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier die Sprites: KLARERWEISE in CHIP RAM! **********

MeinSprite0:	; Lnge 4 Zeilen
Vstart0:
	dc.b $30	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart0:
	dc.b $40	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop0:
	dc.b $34	; Vertikale Endposition des Sprite
	dc.b $00

	dc.w	%0000000000000000,%0000000000000000 ; Binres Format fr ev. nderungen  ;0
	dc.w	%0000000000000000,%1111111111111111										 ;2
	dc.w	%1111111111111111,%0000000000000000										 ;1	
	dc.w	%1111111111111111,%1111111111111111										 ;3 	
	dc.w	0,0	; 2 auf 0 gesetzte Word markieren das Ende des Sprite


MeinSprite1:	; Lnge 4 Zeilen
Vstart1:
	dc.b $30	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart1:
	dc.b $44	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop1:
	dc.b $34	; $50+13=$5d	; Vertikale Endposition des Sprite
	dc.b $00	; Bit 7 setzen, um die Sprites 0 und 1 zu vermhlen

	dc.w	%0000000000000000,%0000000000000000 ; Binres Format fr ev. nderungen
	dc.w	%0000000000000000,%1111111111111111
	dc.w	%1111111111111111,%0000000000000000
	dc.w	%1111111111111111,%1111111111111111 
	dc.w	0,0	; 2 auf 0 gesetzte Word markieren das Ende des Sprites

******************************************************************************	

	SECTION LEERESPLANE,BSS_C 

Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end

Erklrung:

Allgemein: Sprite-Struktur und Farbzuordnung

	(dc.w p1,p2)	
	dc.w $0,$0	-> Color 0
	dc.w $0,$1	-> Color 2
	dc.w $1,$0	-> Color 1
	dc.w $1,$1	-> Color 3
		
	dc.w	%0000000000000000,%0000000000000000 ; Binres Format fr ev. nderungen  ;0
	dc.w	%0000000000000000,%1111111111111111										 ;2
	dc.w	%1111111111111111,%0000000000000000										 ;1	
	dc.w	%1111111111111111,%1111111111111111										 ;3 	
		
WinUAE Debugger
	>sp 6a580
    06A580 3040 3400
 48 06A584 0000000000000000		
 49 06A588 2222222222222222
 50 06A58C 1111111111111111
 51 06A590 3333333333333333

;------------------------------------------------------------------------------

Attached-Sprites die sich vollstndig berlappen

	dc.w	%0000000000000000,%0000000000000000 ; Binres Format fr ev. nderungen  ;0
	dc.w	%0000000000000000,%1111111111111111										 ;2
	dc.w	%1111111111111111,%0000000000000000										 ;1	
	dc.w	%1111111111111111,%1111111111111111										 ;3 	

	dc.w	%0000000000000000,%0000000000000000 ; Binres Format fr ev. nderungen  ;0
	dc.w	%0000000000000000,%1111111111111111										 ;2
	dc.w	%1111111111111111,%0000000000000000										 ;1	
	dc.w	%1111111111111111,%1111111111111111										 ;3 	

WinUAE Debugger

>sp 6a598 6a580
    06A598 3040 3400
 48 06A59C 0000000000000000	; COLOR16
 49 06A5A0 AAAAAAAAAAAAAAAA	; COLOR26
 50 06A5A4 5555555555555555	; COLOR21
 51 06A5A8 FFFFFFFFFFFFFFFF	; COLOR31
 
;------------------------------------------------------------------------------

Farbzuordnung:

resultierendes Farbregister =  ColorBasis+Offset	; z.B. 16+5=COLOR21

;---Farbbank 1	
	dc.w	$1a2,$000		; COLOR16, - Color0 der Sprite0/1 -schwarz (transparent)
	dc.w	$1a2,$f00		; COLOR17, - Color1 der Sprite0/1 -rot
	dc.w	$1a4,$0f0		; COLOR18, - Color2 der Sprite0/1 -grn
	dc.w	$1a6,$00f		; COLOR19, - Color3 der Sprite0/1 -blau
;---Farbbank 2
	dc.w	$1a8,$fff		; COLOR20, - Color0 der Sprite2/3 -wei (transparent)
	dc.w	$1aa,$ff0		; COLOR21, - Color1 der Sprite2/3 -mangenta
	dc.w	$1ac,$0ff		; COLOR22, - Color2 der Sprite2/3 -gelb	
	dc.w	$1ae,$f0f		; COLOR23, - Color3 der Sprite2/3 -cyan
;---Farbbank 3
	dc.w	$1b0,$888		; COLOR24, - Color0 der Sprite4/5 -hellgrau (transparent)
	dc.w	$1b2,$800		; COLOR25, - Color1 der Sprite4/5 -hellrot
	dc.w	$1b4,$080		; COLOR26, - Color2 der Sprite4/5 -hellgrn
	dc.w	$1b6,$008		; COLOR27, - Color3 der Sprite4/5 -hellblau
;---Farbbank 4
	dc.w	$1b8,$333		; COLOR28, - Color0 der Sprite6/7 -dunkelgrau (transparent)
	dc.w	$1ba,$880		; COLOR29, - Color1 der Sprite6/7 -hell mangenta
	dc.w	$1bc,$088		; COLOR30, - Color2 der Sprite6/7 -hell gelb
	dc.w	$1be,$808		; COLOR31, - Color3 der Sprite6/7 -hell cyan

;------------------------------------------------------------------------------
	dc.w $0,$0	entspricht dc.w p1,p2	oder dc.w SPRxDATA,SPRxDATB

		p2,p1
Color0	0,0		; Farbbank 1	fr Sprite0/1 
Color1	0,1
Color2	1,0
Color3	1,1
--
Color0	0,0		; Farbbank 2	fr Sprite2/3 
Color1	0,1
Color2	1,0
Color3	1,1
--
Color0	0,0		; Farbbank 3	fr Sprite4/5 
Color1	0,1
Color2	1,0
Color3	1,1
--
Color0	0,0		; Farbbank 4	fr Sprite6/7 
Color1	0,1
Color2	1,0
Color3	1,1

;------------------------------------------------------------------------------
; Attached

	dc.w $0,$0	--> in dc.w p1,p2	sprite0		dc.w SPR0DATA,SPR0DATB
	dc.w $0,$0	--> in dc.w p3,p4	sprite1		dc.w SPR1DATA,SPR1DATB

			p4,p3,p2,p1
Color0		0,0,0,0	 
Color1		0,0,0,1
Color2		0,0,0,0
Color3		0,0,1,1
Color4		0,1,0,0
Color5		0,1,0,1
Color6		0,1,0,0
Color7		0,1,1,1
Color8		1,0,0,0
Color9		1,0,0,1
Color10		1,0,1,0
Color11		1,0,1,1
Color12		1,1,0,0
Color13		1,1,0,1
Color14		1,1,1,0
Color15		1,1,1,1

;------------------------------------------------------------------------------

Farbzugang bei nicht berlappenden Attached Sprites

(Das Attacht-Bit hat nur bei ungeraden Sprites einen Einfluss.)
Bei allen Spritepaaren 0/1, 2/3, 4/5, 6/7 die im angehngten (attached) Modus
betrieben werden ndert sich die Farbregister Zuordnung, wenn die Punkte der
Sprites sich nicht berlappen wie folgt:

Nicht berlappende Punkte werden behandelt, als stnde das entsprechende Bit
bei 0. Dies bedeutet, dass fr alle geraden Sprites die Farben [1/2/3] der 
Bank verwendet werden und fr die ungeraden Sprites die Farben [4/8/12].

Das ATT-Bit in SPRxCTL ermglicht dadurch die Verwendung der gesamten Sprite-
Farbbank, auch wenn es keine berlappung zwischen den geraden und ungeraden 
Sprites im gewhlten Paar gibt.

fr alle geraden Sprites (also Sprite 0, 2, 4, 6) die Farben [1/2/3]
	dc.w $0,$0	--> in dc.w p1,p2	sprite0		dc.w SPR0DATA,SPR0DATB

			p4,p3,p2,p1
Color0		0,0,0,0		--> x,x,0,0		; 0
Color1		0,0,0,1		--> x,x,0,0		; 1
Color2		0,0,0,0		--> x,x,0,0		; 2
Color3		0,0,1,1		--> x,x,0,0		; 3
Color4		0,1,0,0		-----------	
Color5		0,1,0,1		-----------	
Color6		0,1,0,0		-----------	
Color7		0,1,1,1		-----------	
Color8		1,0,0,0		-----------	
Color9		1,0,0,1		-----------	
Color10		1,0,1,0		-----------	
Color11		1,0,1,1		-----------	
Color12		1,1,0,0		-----------	
Color13		1,1,0,1		-----------	
Color14		1,1,1,0		-----------	
Color15		1,1,1,1		-----------	

fr alle ungeraden Sprites (also Sprite 1, 3, 5, 7) die Farben [4/8/12]
	dc.w $0,$0	--> in dc.w p3,p4	sprite1		dc.w SPR1DATA,SPR1DATB

			p4,p3,p2,p1
Color0		0,0,0,0		--> 0,0,0,0		; 0			; COLOR16
Color1		0,0,0,1		-----------	
Color2		0,0,0,0		-----------	
Color3		0,0,1,1		-----------	
Color4		0,1,0,0		--> 0,1,0,0		; 1			; COLOR20
Color5		0,1,0,1		-----------	
Color6		0,1,0,0		-----------	
Color7		0,1,1,1		-----------	
Color8		1,0,0,0		--> 1,0,0,0		; 2			; COLOR24
Color9		1,0,0,1		-----------	
Color10		1,0,1,0		-----------	
Color11		1,0,1,1		-----------	
Color12		1,1,0,0		--> 1,1,0,0		; 3			; COLOR28
Color13		1,1,0,1		-----------	
Color14		1,1,1,0		-----------	
Color15		1,1,1,1		-----------	
