
; Listing25g.s		Sprite und Overscan

; Listing7f.s als Grundlage genommen	
;   ANZEIGEN ALLER 8 Sprite DES AMIGA

;	In diesem Listing wird gezeigt, da alle 8 Sprites ihre Palette
;	in Paaren gemeinsam haben, also Sprite 0 die gleiche wie Sprite1
;	hat, Sprite 2 die gleichen Farben wie Sprite 3 und so weiter.
;	Es wird auch gezeigt, wie die Prioritten bei berlagerungen
;	verteilt sind, also da der mit der kleineren Nummer ber dem
;	mit einer greren Vorrang hat, also ber diesem angezeigt wird.
;	Sprite 0 wird also ber allen anderen angezeigt, Sprite 7 hingegen
;	kann von allen anderen berdeckt werden. Sprite 3 z.B. berdeckt
;	die Sprites 4,5,6,7, wird aber selbst von 0,1 und 2 berdeckt.
;	Durch Drcken der linken Maustaste berlappen sich die Sprites
;	und die Prioritten sind gut erkennbar. Rechte Maustaste zum
;	Aussteigen.

	SECTION ROCK'NROLL,CODE

Start:

	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; speichern die alte COP

	move.l	#Bitplane,d0		; wohin pointen
	lea	Bplpointers,a1			; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf die Sprites

	move.l	#MeinSprite0,d0		; Adresse des Sprite in d0
	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite1,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite2,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite3,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite4,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite5,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite6,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite7,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	moveq	#$60,d0			; Anfangskoordinate Hstart
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
						    ; (zu Bemerken, da das Byte Hstart immer 2 Pixel
						    ; nimmt, wenn wir uns also um 10 Pixel verstellen
						    ; wollen mssen wir nur 5 zu Hstart dazuzhlen!)
	move.b	d0,Hstart1
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart2
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart3
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart4
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart5
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart6
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart7

Mouse2:
	btst	#2,$dff016
	bne.s	Mouse2

	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	;dc.w $8e,$2c81,$90,$2cc1,$92,$38,$94,$d0	; 1. DDFSTRT = $38
	dc.w $8e,$2c71,$90,$2cc1,$92,$30,$94,$d0	; 2. DDFSTRT = $30
	;dc.w $8e,$2c61,$90,$2cc1,$92,$28,$94,$d0	; 3. DDFSTRT = $28
	;dc.w $8e,$1a5c,$90,$38d4,$92,$20,$94,$d8	; 4. DDFSTRT = $20
	;dc.w $8e,$1a5c,$90,$38d4,$92,$18,$94,$d8	; 5. DDFSTRT = $18

	;dc.w	$8e,$2c81		; DIWSTRT
	;dc.w	$90,$2cc1		; DIWSTOP
	;dc.w	$92,$38			; DDFSTRT
	;dc.w	$94,$d0			; DDFSTOP
	dc.w	$102,0			; BPLCON1
	dc.w	$104,0			; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD
	
				; 5432109876543210
	dc.w	$100,%0001001000000000  ; bit 12 an!! 1 bitplane lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste	bitplane

	dc.w	$180,$000		; Color0	; schwarzer Hintergrund
	dc.w	$182,$123		; Color1	; Color1 des Bitplane, das
							; hier leer ist, es erscheint
							; also nicht.

	dc.w	$1a2,$f00		; COLOR17, - Color1 der Sprite0/1 -rot
	dc.w	$1a4,$0f0		; COLOR18, - Color2 der Sprite0/1 -grn
	dc.w	$1a6,$ff0		; COLOR19, - Color3 der Sprite0/1 -gelb

	dc.w	$1aa,$fff		; COLOR21, - Color1 der Sprite2/3 -wei
	dc.w	$1ac,$0bd		; COLOR22, - Color2 der Sprite2/3 -Wasser
	dc.w	$1ae,$d50		; COLOR23, - Color3 der Sprite2/3 -orange

	dc.w	$1b2,$00f		; COLOR25, - Color1 der Sprite4/5 -blau
	dc.w	$1b4,$f0f		; COLOR26, - Color2 der Sprite4/5 -violett
	dc.w	$1b6,$bbb		; COLOR27, - Color3 der Sprite4/5 -grau

	dc.w	$1ba,$8e0		; COLOR29, - Color1 der Sprite6/7 -hellgrn
	dc.w	$1bc,$a70		; COLOR30, - Color2 der Sprite6/7 -braun
	dc.w	$1be,$d00		; COLOR31, - Color3 der Sprite6/7 -dunkelrot

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier die Sprite: KLARERWEISE in CHIP RAM! ************

; Referenztabelle zur Definition der Farben:


; fr die Sprite 0 und 1
; binr 00=Color 0 (TRANSPARENT)
; binr 10=Color 1 (rot)
; binr 01=Color 2 (grn)
; binr 11=Color 3 (gelb)

MeinSprite0:				; Lnge: 8 Zeilen
Vstart0:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart0:
	dc.b $60				; Horizontale Pos. (von $40 bis $d8)
Vstop0:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite


MeinSprite1:				; Lnge: 8 Zeilen
Vstart1:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart1:
	dc.b $60+14				; Horizontale Pos. (von $40 bis $d8)
Vstop1:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000010001111
 dc.w	%0011111111111100,%1100000110000011
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0011111111111100,%1100000010000011
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

 ; fr die Sprite 2 und 3
 ; binr 00=Color 0 (TRANSPARENT)
 ; binr 10=Color 1 (WEI)
 ; binr 01=Color 2 (WASSER)
 ; binr 11=Color 3 (ORANGE)

MeinSprite2:				; Lnge: 8 Zeilen
Vstart2:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart2:
	dc.b $60+(14*2)			; Horizontale Pos. (von $40 bis $d8)
Vstop2:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0011111111111100,%1100001000100011
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0111111111111110,%1000000111000001
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MeinSprite3:				; Lnge: 8 Zeilen
Vstart3:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart3:
	dc.b $60+(14*3)			; Horizontale Pos. (von $40 bis $d8)
Vstop3:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0111111111111110,%1000000111100001
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0				; Ende des Sprite

 ; fr die Sprite 4 und 5
 ; binr 00=Color 0 (TRANSPARENT)
 ; binr 10=Color 1 (BLAU)
 ; binr 01=Color 2 (VIOLETT)
 ; binr 11=Color 3 (GRAU)

MeinSprite4:				; Lnge: 8 Zeilen
Vstart4:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart4:
	dc.b $60+(14*4)			; Horizontale Pos. (von $40 bis $d8)
Vstop4:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001001001111
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MeinSprite5:				; Lnge: 8 Zeilen
Vstart5:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart5:
	dc.b $60+(14*5)			; Horizontale Pos. (von $40 bis $d8)
Vstop5:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

 ; fr die Sprite 6 und 7
 ; binr 00=Color 0 (TRANSPARENT)
 ; binr 10=Color 1 (HELLGRN)
 ; binr 01=Color 2 (BRAUN)
 ; binr 11=Color 3 (DUNKELROT)

MeinSprite6:				; Lnge: 8 Zeilen
Vstart6:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart6:
	dc.b $60+(14*6)			; Horizontale Pos. (von $40 bis $d8)
Vstop6:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000001001000001
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MeinSprite7:				; Lnge: 8 Zeilen
Vstart7:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart7:
	dc.b $60+(14*7)			; Horizontale Pos. (von $40 bis $d8)
Vstop7:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

******************************************************************************

		SECTION LEEREPLANE,BSS_C
							
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end


Erklrung:

In  diesem  Listing werden alle 8 Sprites "gepointet", jeder von ihnen hat
die Nummer gezeichnet. Wie schon  in  der  Theorie  erklrt  haben  die  8
Sprites 4 separate Paletten, deswegen teilen sich immer zwei nebenstehende
Sprites eine Palette:

	dc.w	$1a2,$f00		; COLOR17, - Color1 der Sprite0/1 -rot
	dc.w	$1a4,$0f0		; COLOR18, - Color2 der Sprite0/1 -grn
	dc.w	$1a6,$ff0		; COLOR19, - Color3 der Sprite0/1 -gelb

	dc.w	$1aa,$fff		; COLOR21, - Color1 der Sprite2/3 -wei
	dc.w	$1ac,$0bd		; COLOR22, - Color2 der Sprite2/3 -Wasser
	dc.w	$1ae,$d50		; COLOR23, - Color3 der Sprite2/3 -orange

	dc.w	$1b2,$00f		; COLOR25, - Color1 der Sprite4/5 -blau
	dc.w	$1b4,$f0f		; COLOR26, - Color2 der Sprite4/5 -violett
	dc.w	$1b6,$bbb		; COLOR27, - Color3 der Sprite4/5 -grau

	dc.w	$1ba,$8e0		; COLOR29, - Color1 der Sprite6/7 -hellgrn
	dc.w	$1bc,$a70		; COLOR30, - Color2 der Sprite6/7 -braun
	dc.w	$1be,$d00		; COLOR31, - Color3 der Sprite6/7 -dunkelrot

Zu Bemerken ist, da die Farben 16, 20, 24 und 28 nicht  von  den  Sprites
verwendet  werden,  sie  werden bersprungen, da sie dem Color0 des Sprite
entsprechen wrden, also  dem  TRANSPARENT,  das  eben  keine  Farbe  ist,
sondern  eher  als  "LOCH"  aufgefasst werden kann. Er nimmt die Farbe des
darunterliegenden Bitplane (oder Sprite) an. Jeder Sprite hat sein Vstart,
Vstop und Hstart, sehen wir z.B. Sprite2:


MeinSprite2:				; Lnge: 8 Zeilen
Vstart2:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart2:
	dc.b $60+(14*2)			; Horizontale Pos. (von $40 bis $d8)
Vstop2:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00

Jeder  Sprite  ist  von  den  anderen distanziert, indem wir zu Hstart ein
(14*x) dazugezhlt haben. Nach dem linken  Mausdruck  werden  alle  Hstart
auer  dem ersten gendert, um sie alle zu berlagern. Das Veranschaulicht
dann die Priotitten.

;------------------------------------------------------------------------------

Sprite und Overscan

Bei einem frheren DDFSTRT zeigen Sprites gegebenfalls Beschdigungen.

Es handelt sich dabei um einen OCS-Fehler. Der Fehler ist in ECS/AGA behoben
und zwar weisen alle OCS Agnus-Varianten Sprite-DMA-Fehler-Funktionen auf:

Der Fehler ist:
Ein einzelner Zyklus kurz vor dem Start von Bitplane-DMA ist fr Sprites nicht
verfgbar. Sprite-DMA beendet die DMA-bertragung zum zweiten Steuerwort/
Datenwort des Sprites, wenn der Bitplane-DMA-Start frh genug erfolgt, wodurch
das Sprite beschdigt wird, z.B. ist ein zuvor geladenes DATB sichtbar.
 
Mit anderen Worten, wenn in der Dokumentation angegeben ist, dass nur Sprite 7
aufgrund von Bitplane-DMA gestohlen wird, wird auch der Sprite 6 DMA-Slot 
durch Bitplane-DMA gestohlen und so weiter.

Dies betrifft wie gesagt nur OCS, wenn der Chipsatz in WinUAE auf ECS Agnus
gestellt wird, funktioniert es.

DDFSTRT $38 - keine Sprite slots werden gestohlen
DDFSTRT $30 - Sprite-DMA-Slot fr Sprite 7 wird gestohlen
			- Sprite 6 beschdigt
DDFSTRT $28 - Sprite-DMA-Slot fr Sprite 5 bis 7 wird gestohlen
			- Sprite 4 beschdigt
DDFSTRT $20 - Sprite-DMA-Slot fr Sprite 3 bis 7 wird gestohlen
			- Sprite 2 beschdigt
DDFSTRT $18 - Sprite-DMA-Slot fr Sprite 1 bis 7 wird gestohlen 
              (nur Sprite 0 bleibt)

Abhilfe wre z.B.

DDFSTRT $38 - keine Sprite slots werden gestohlen
DDFSTRT $34 - Sprite 7 beschdigt
DDFSTRT $24 - Sprite 3 beschdigt

http://eab.abime.net/showpost.php?p=995744&postcount=9

;------------------------------------------------------------------------------
>v-1
>v $60 $18 7

1. DDFSTRT = $38
   dc.w $8e,$2c81,$90,$2cc1,$92,$38,$94,$d0
>v $60 $18 7

Line: 60  96 HPOS 18  24:
 [18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
              SPR0   144                SPR0   146                SPR1   14C                SPR1   14E
                    03C0                      7C3E                      03C0                      7C3E
                0002BD84                  0002BD86                  0002BDAC                  0002BDAE

               1C2   05E                 1C3   05E                 1D6   05E                 1D7   05E

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
              SPR2   154                SPR2   156                SPR3   15C                SPR3   15E
                    03C0                      7C3E   (                  03C0                      7C3E
                0002BDD4                  0002BDD6                  0002BDFC                  0002BDFE

               1EA   05E                 1EB   05E                 1FE   05E                 1FF   05E

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
              SPR4   164                SPR4   166                SPR5   16C                SPR5   16E
                    03C0                      7C3E                      03C0                      7C3E
                0002BE24                  0002BE26                  0002BE4C                  0002BE4E

               112   05F                 113   05F                 126   05F                 127   05F

 [30 058 -]   [31 05A -]   [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
              SPR6   174                SPR6   176                SPR7   17C                SPR7   17E
                    03C0                      7C3E                      03C0                      7C3E
                0002BE74                  0002BE76                  0002BE9C                  0002BE9E

               13A   05F                 13B   05F                 14E   05F                 14F   05F

 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]

 0




 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
                                        BPL1   110
                                              0000
                                          0002C6E0

                                         170   063

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
                                        BPL1   110
                                              0000
                                          0002C6E2

                                         171   063

;----------------
2. DDFSTRT = $30
   dc.w $8e,$2c71,$90,$2cc1,$92,$30,$94,$d0

>v
Line: 60  96 HPOS 18  24:
 [18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
              SPR0   144                SPR0   146                SPR1   14C                SPR1   14E
                    03C0                      7C3E                      03C0                      7C3E
                0002BD84                  0002BD86                  0002BDAC                  0002BDAE

               1C2   05E                 1C3   05E                 1D6   05E                 1D7   05E

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
              SPR2   154                SPR2   156                SPR3   15C                SPR3   15E
 (                  03C0                      7C3E                      03C0                      7C3E
                0002BDD4                  0002BDD6                  0002BDFC                  0002BDFE

               1EA   05E                 1EB   05E                 1FE   05E                 1FF   05E

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
              SPR4   164                SPR4   166                SPR5   16C                SPR5   16E
                    03C0                      7C3E                      03C0                      7C3E
                0002BE24                  0002BE26                  0002BE4C                  0002BE4E

               112   05F                 113   05F                 126   05F                 127   05F

 [30 058 -]   [31 05A -]   [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
              SPR6   174
 0                  03C0
                0002BE74

               13A   05F

 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                        BPL1   110
                                              0000
                                          0002C748

                                         1A4   063

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
                                        BPL1   110
                                              0000
                                          0002C74A

                                         1A5   063

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
                                        BPL1   110
                                              0000
                                          0002C74C

                                         1A6   063

;----------------
3. DDFSTRT = $28
   dc.w $8e,$2c61,$90,$2cc1,$92,$28,$94,$d0
   
>v
Line: 60  96 HPOS 18  24:
 [18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
              SPR0   144                SPR0   146                SPR1   14C                SPR1   14E
                    03C0                      7C3E   (                  03C0                      7C3E
                0002BD84                  0002BD86                  0002BDAC                  0002BDAE

               1C2   05E                 1C3   05E                 1D6   05E                 1D7   05E

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
              SPR2   154                SPR2   156                SPR3   15C                SPR3   15E
                    03C0                      7C3E                      03C0                      7C3E
                0002BDD4                  0002BDD6                  0002BDFC                  0002BDFE

               1EA   05E                 1EB   05E                 1FE   05E                 1FF   05E

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
              SPR4   164
 0                  03C0
                0002BE24

               112   05F

 [30 058 -]   [31 05A -]   [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
                                        BPL1   110
                                              0000
                                          0002C7B0

                                         1D8   063

 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                        BPL1   110
                                              0000
                                          0002C7B2

                                         1D9   063

;-----------
; 4. DDFSTRT = $20
 dc.w $8e,$1a5c,$90,$38d4,$92,$20,$94,$d8

>v
Line: 60  96 HPOS 18  24:
 [18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
              SPR0   144                SPR0   146                SPR1   14C                SPR1   14E
                    03C0                      7C3E                      03C0                      7C3E
                0002BD84                  0002BD86                  0002BDAC                  0002BDAE

               1C2   05E                 1C3   05E                 1D6   05E                 1D7   05E

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
              SPR2   154
 0                  03C0
                0002BDD4

               1EA   05E

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
                                        BPL1   110
                                              0000
                                          0002CBE0

                                         1F0   065

 [30 058 -]   [31 05A -]   [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
                                        BPL1   110
                                              0000
                                          0002CBE2

                                         1F1   065

;-----------
; 5. DDFSTRT = $18

>v
Line: 60  96 HPOS 18  24:
 [18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
              SPR0   144
 0                  03C0
                0002BD84

               1C2   05E

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
                                        BPL1   110
                                              0000
                                          0002CC6C

                                         136   066

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
                                        BPL1   110
                                              0000
                                          0002CC6E

                                         137   066