
; Listing25e2.s		Sprite anzeigen mit wenig Bitplane DMA
; ein einmaliger Bitplane DMA Abruf reicht aus um Spritedaten anzuzeigen
; dies ist eine weitere Mglichkeit zum einmaliges Schreiben in BPL1DAT
; vor dem Anzeigen des Sprites durch eine Copperliste

	SECTION ROCK'NROLL,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; speichern der alten Cop

	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf den Sprite
	move.l	#MeinSprite,d0		; Adresse des Sprite in d0
	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	
	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maustaste gedrckt?
	bne.s	Mouse
	
	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts					

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0
	
******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DIWSTRT
	dc.w	$90,$2cc1		; DIWSTOP
	dc.w	$92,$20			; DDFSTRT - wir reduzieren DDF auf 2x16 Abrufe
	dc.w	$94,$28			; DDFSTOP - wir reduzieren DDF auf 2x16 Abrufe
;----------------------------------------------------------
	dc.w	$102,0			; BPLCON1
	dc.w	$104,$24		; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD

			    ; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres
	
Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR00	; Hintergrund Schwarz
	dc.w	$182,$080		; COLOR01	; Farbe 1 der Bitplane

	dc.w	$1a2,$f00		; COLOR17, oder COLOR1 des Sprite0 - rot
	dc.w	$1a4,$0f0		; COLOR18, oder COLOR2 des Sprite0 - grn
	dc.w	$1a6,$ff0		; COLOR19, oder COLOR3 des Sprite0 - gelb
									
	dc.w	$ffff,$fffe		; Ende der Copperlist


 ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ************

MeinSprite:	  ; Lnge 13 Zeilen
Vstart:
	dc.b $2c  ; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $a0  ; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $39  ; $30+13=$3d - Vertikale Endposition des Sprite
	dc.b $00																						
																						
 dc.w	%0000000000000000,%0000110000110000 ; Binres Format fr ev. nderungen			
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; binr 00=Color 0 (Transparent)
 dc.w	%0000011111100000,%0110011111100110 ; binr 10=Color 1 (rot)
 dc.w	%0000011111100000,%1100100110010011 ; binr 01=Color 2 (grn)
 dc.w	%0000110110110000,%1111100110011111 ; binr 11=Color 3 (gelb)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0	; 2 word auf NULL definieren das Ende des Sprite.

Bitplane:
	blk.b 10240,$ff		; fr 320x256	$FF fr Vollbild
	
	end


Erklrung:

In diesem Beispiel wird gezeigt wie es mglich ist ein Sprite anzuzeigen ohne 
"extensiv" Bitplane DMA Abrufe zu ttigen. Es reicht aus, so wenig wie mglich
Bitplane DMA Abrufe pro Zeile vorzunehmen um trotzdem die Sprites im durch DIW 
geffneten Fenster sichtbar werden zu lassen.
