
; Listing25d2.s		horizontales Spritemultiplexing mit wait und SPRxPOS
; mit Copperloop

	SECTION ROCK'NROLL,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte COP

	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	; Pointen auf den Sprite

	move.l	#MeinSprite,d0		; Adresse des Sprite in d0
	move.l	#MeinSprite+4,d1	; Adresse des Sprite in d0
	
	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)
	move.w	d1,SprPtr+2			; Spritepointer zurcksetzen
	swap	d0
	move.w	d0,2(a1)
		
	move.l	#CopperLoop1,d0
	move	d0,CopPtr1+6
	swap	d0
	move	d0,CopPtr1+2

	move.l	#CopperLoop2,d0
	move	d0,CopPtr2+6
	swap	d0
	move	d0,CopPtr2+2

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0
	
GfxBase:
	dc.l	0

OldCop:
	dc.l	0

******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DIWSTRT
	dc.w	$90,$2cc1		; DIWSTOP
	dc.w	$92,$38			; DDFSTRT
	dc.w	$94,$d0			; DDFSTOP
	dc.w	$102,0			; BPLCON1
	dc.w	$104,0			; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR00	; Hintergrund Schwarz
	dc.w	$182,$123		; COLOR01	; Farbe 1 der Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; COLOR17, oder COLOR1 des Sprite0 - rot
	dc.w	$1a4,$0f0		; COLOR18, oder COLOR2 des Sprite0 - grn
	dc.w	$1a6,$ff0		; COLOR19, oder COLOR3 des Sprite0 - gelb
	
CopPtr1
	dc.w	$084,0			; COP2LCH
	dc.w	$086,0			; COP2LCL
	
	dc.w	$8001,$fffe		; wait, wo die Sprites beginnen sollen
CopperLoop1:
	dc.w	$0140,$0040		; SPR0POS neue horizontale Startposition	
	dc.w	$8041,$80fe
	dc.w	$0140,$0060		; SPR0POS neue horizontale Startposition		
	dc.w	$8061,$80fe
	dc.w	$0140,$0080		; SPR0POS neue horizontale Startposition		
	dc.w	$8081,$80fe
	dc.w	$0140,$00a0		; SPR0POS neue horizontale Startposition		
	dc.w	$80a1,$80fe
	dc.w	$0140,$00c0		; SPR0POS neue horizontale Startposition			
	dc.w	$80e1,$80fe		; warte auf Ende der Zeile			

	dc.w	$8ce1,$ffff     ; skip loop wenn Spriteende erreicht ist                                                          
	dc.w	$8a,$0			; COPJMP2 Start
;-------------------------------------------------
SprPtr:	
	dc.w	$0122,0			; Spritepointer zurcksetzen

	dc.w	$0140,$8e40		; SPR0POS neue horizontale Startposition 
	dc.w	$0142,$9b00		; SPR0CTL Start
CopPtr2
	dc.w	$084,0			; COP2LCH
	dc.w	$086,0			; COP2LCH
CopperLoop2:
	dc.w	$0140,$0040		; SPR0POS neue horizontale Startposition	
	dc.w	$8d41,$80fe
	dc.w	$0140,$0060		; SPR0POS neue horizontale Startposition		
	dc.w	$8d61,$80fe
	dc.w	$0140,$0080		; SPR0POS neue horizontale Startposition		
	dc.w	$8d81,$80fe
	dc.w	$0140,$00a0		; SPR0POS neue horizontale Startposition		
	dc.w	$8da1,$80fe
	dc.w	$0140,$00c0		; SPR0POS neue horizontale Startposition			
	dc.w	$8de1,$80fe		; warte auf Ende der Zeile			

	dc.w	$9ae1,$ffff     ; skip loop am Ende der Zeile $9a                                                         
	dc.w	$8a,$0			; COPJMP2 Start

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ************

MeinSprite:		; Lnge 13 Zeilen
Vstart:
	dc.b $80	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $00	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $9a	; $1a+13=$27 - Vertikale Endposition des Sprite
	dc.b $00
 dc.w	%0000000000000000,%1000110000110001 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; binr 00=Color 0 (durchsichtig)
 dc.w	%0000011111100000,%0110011111100110 ; binr 10=Color 1 (rot)
 dc.w	%0000011111100000,%1100100110010011 ; binr 01=Color 2 (grn)
 dc.w	%0000110110110000,%1111100110011111 ; binr 11=Color 3 (gelb)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0	; 2 word auf NULL definieren das Ende des Sprite.

******************************************************************************

	SECTION LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane auf 0 Lowres

	end
	

Erklrung:

Hier sehen wir horizontales und vertikales Spritemultiplexing mit Copperloop.

>?$80+!13
$0000008D = %00000000`00000000`00000000`10001101 = 141 = 141
>?$80+!13+!13
$0000009A = %00000000`00000000`00000000`10011010 = 154 = 154
>

Das Sprite ist 13 Zeilen hoch. Wir geben jedoch die doppelte Hhe an, weil wir
das Sprite vertikal sofort wiederholen wollen. Sprite-DMA wird dadurch erst 
nach der Anzeige des wiederholten Sprites beendet. Vor der Anzeige des zu
wiederholenden Sprites muss nur der Spritepointer auf den Beginn der Bilddaten
zurckgesetzt werden.

Ansonsten erfolgt die Anzeige durch zwei Copperschleifen.
Die erste im Bereich von $80 bis $8c und die zweite von $8d bis $9a.
