
; Listing24d.s		Copper Blitt, wo wir Rechtecke auf dem Bildschirm zeichnen

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA
WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#1-1,d1				; Anzahl der Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	bsr BlittInit				; Blitter Register voreinstellen
	
	moveq	#0,d5
	lea CopBlt,a2

; Parameter fr die Zeichenroutine

	move.w	#200,d0				; X obere linke Ecke
	move.w	#10,d1				; Y obere linke Ecke
	move.w	#48,d2				; Breite
	move.w	#20,d3				; Hhe
	bsr.s	BlittRect			; Zeichenroutine ausfhren 
	
; Parameter fr die Zeichenroutine

	move.w	#64,d0				; X obere linke Ecke
	move.w	#70,d1				; Y obere linke Ecke
	move.w	#32,d2				; Breite
	move.w	#40,d3				; Hhe
	bsr.s	BlittRect			; Zeichenroutine ausfhren 
	
; Parameter fr die Zeichenroutine

	move.w	#164,d0				; X obere linke Ecke
	move.w	#170,d1				; Y obere linke Ecke
	move.w	#32,d2				; Breite
	move.w	#80,d3				; Hhe
	bsr.s	BlittRect			; Zeichenroutine ausfhren 
	
Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse				; wenn nicht, gehe zurck zu Mouse2:

	rts

;****************************************************************************
; Diese Routine initialisiert die Register die unverndert bleiben.
;****************************************************************************

BlittInit:
	move.w  #$0002,$2e(a5)		; COPCON - ermglich den Zugriff des Coppers
								; auf die Blitter-Register

	btst	#6,2(a5)			; DMACONR
WaitBlit:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit

	move.l	#$01ff0000,$40(a5)	; BLTCON0 und BLTCON1
								; benutze Kanal D
								; LF=$FF (Operation alles)
								; Mode ascending

	rts	

;****************************************************************************
; Diese Routine zeichnet ein Rechteck auf dem Bildschirm.
;
; d0 - X Koordinate des oberen linken Eckpunkts
; d1 - Y-Koordinate des oberen linken Eckpunkts
; d2 - Rechteckbreite in Pixel
; d3 - Rechteckhhe
;****************************************************************************

;	  _____     .
;	 / ___ \____.
;	 (___)___ |
;	| | o Y___) |
;	| l___|  | 
;	|   , `---' `;
;	|  C__.     _)
;	| _______   T
;	| l_l_l_|   |
;	| .,   |
;	| (_|_)_|   |
;	l___________|
;	   _T    T_
;	  / `-^--' \
;	_/          \_
;	|       xCz  |

BlittRect:
; Berechnung der Startadresse des Blitters

	lea	Bitplane,a1				; Adresse Bitplane
	mulu.w	#40,d1				; Offset Y
	add.l	d1,a1				; zur Adresse hinzufgen
	lsr.w	#3,d0				; teile das X durch 8
	and.w	#$fffe,d0			; mach es gerade
	add.w	d0,a1				; Summe zur Adresse der Bitebene, Finden
								; der richtigen Zieladresse

; Blitter Modulo Berechnung

	lsr.w	#3,d2				; dividiere die Breite durch 8
	and.w	#$fffe,d2			; Ich nulle Bit 0 (gerade)
	move.w	#40,d4				; Bildschirmbreite in Bytes
	sub.w	d2,d4				; Modulo = Bildschirmbreite - Rechteckbreite

; Berechnung der Gre des Blitts

	lsl.w	#6,d3				; Hhe multipliziert mit 64
	lsr.w	#1,d2				; Breite in Pixel dividiert durch 16
								; das heisst, Breite in Worten
	or	d2,d3					; lege die Dimension zusammen

; Register laden ber die Copperlist

	move.l	a1,d1				; Kopie	
	move.w	d4,6(a2,d5.w)		; BLTDMOD
	move.w	d1,14(a2,d5.w)		; BLTDPTL
	swap	d1
	move.w	d1,10(a2,d5.w)		; BLTDPTH
	move.w	d3,18(a2,d5.w)		; BLTSIZE
	add.w	#20,d5

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$aaa			; COLOR01
		
CopBlt:	
	dc.w    $0001,$7ffe         ; wait for blitter
	dc.w	$0066,$0			; BLTDMOD
	dc.w	$0054,$0			; BLTDPTH
	dc.w	$0056,$0			; BLTDPTL
	dc.w	$0058,$0			; BLTSIZE

	dc.w    $0001,$7ffe         ; wait for blitter
	dc.w	$0066,$0			; BLTDMOD
	dc.w	$0054,$0			; BLTDPTH
	dc.w	$0056,$0			; BLTDPTL
	dc.w	$0058,$0			; BLTSIZE

	dc.w    $0001,$7ffe         ; wait for blitter
	dc.w	$0066,$0			; BLTDMOD
	dc.w	$0054,$0			; BLTDPTH
	dc.w	$0056,$0			; BLTDPTL
	dc.w	$0058,$0			; BLTSIZE

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256

;****************************************************************************

	end

In diesem Beispiel verwenden wir den Blitter, um Rechtecke auf dem Bildschirm 
zu zeichnen. Wir verwenden eine Routine mit Parameterbergabe, die ein Rechteck
an die Koordinaten des oberen linken Eckpunkts mit den Abmessungen (Breite und
Hhe) des Rechtecks zeichnet. Zur Vereinfachung der Routine ist die Breite und
die Position X mit einem Vielfachen von 16 angenhert.
Die Zeichnung wird mit einem Blitt gemacht, der den Ausgang immer auf 1 setzt.
Dies erhalten wir durch das Setzen von LF = $ff, wie in der Lektion erlutert.

Wir blitten die Rechtecke ber die Copperliste. Damit die Copperliste auf 
die Blitterregister zugreifen kann muss das einzige Bit im Register COPCON,
das Bit 1 (DANG) gesetzt sein.

In der Copperliste setzen wir vor jedem neuen Blit ein Wait was grundstzlich
von der vertikalen und horizontalen Position immer erfllt ist und setzen das
BFD Bit auf Null. Damit muss der Copper warten bis der Blitter mit dem letzten
Blit fertig ist.

BFD = Blitter finished disable. Wenn dieses Bit wahr ist, hat das Blitter
finished flag keine Auswirkung auf den Coprozessor. Wenn dieses Bit Null ist,
muss das Blitter-Fertig-Flag wahr sein (zustzlich zu den brigen Bit-
Vergleichen), bevor der Copper seinen Wartezustand verlassen oder einen 
Befehl berspringen kann. Hinweis: Position V7 kann nicht maskiert werden.