
; Listing23a5.s
; vertikale Positionierung eines Lowres-Screens 320x256
; dynamisch	- im oberen, unteren und mittleren Bereich gleichzeitig
; dynamische nderung der DDFSTRT-DDFSTOP Werte

	SECTION SCREEN,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte Copperlist

	move.l	#Bitplane,d0		; Adresse des Bitplane in d0
	lea	Bplpointers,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist	
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Init:
	move #$20,d0				; Start y1 Position oben
	move #$81,d1				; Start y2 Position mitte
	move #$20,d2				; Start y3 Position unten
	move #1,d3					; y1 add
	move #1,d4					; y2 add
	move #1,d5					; y3 add
	move #$5c,d6				; Start x Position
	move #$d4,d7				; Ende x Position

MainLoop:
	cmpi.b	#$aa,$dff006		; Zeile $aa?
	bne.s	MainLoop

Warte:
	cmpi.b	#$aa,$dff006		; Zeile $aa?
	beq.s	Warte

	bsr.w   BewegeDiwHoriz		; bewege Screen auch horizontal
	bsr.w	BewegeDiwOben		; Bewege Screen vertikal (oben)
	bsr.w	BewegeDiwMitte		; Bewege Screen vertikal (mitte)
	bsr.w	BewegeDiwUnten		; Bewege Screen vertikal (unten)
		
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	MainLoop
	
	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

*******************************************************************************
* In diesen Routinen werden die DIW Y-Werte in der Copperliste gendert       *
*******************************************************************************

BewegeDiwOben:
	add.b d3,d0
	cmp.b #$80,d0		; bottom check - sind wir unten?		$80
	bne Ok1				; 				
	neg d3				; change direction	1 wird -1
Ok1:
	cmp.b #$1a,d0		; sind wir oben?						$1a
	bne Ok2				; 
	neg d3				; change direction
Ok2:	
	move.b d0,WaitDiw1
	;move.b d0,WaitDiw2 ; teste das
	rts
	
BewegeDiwMitte:
	add.b d4,d1
	cmp.b #$ff,d1		; bottom check - sind wir unten?		$FF
	bne Ok3				; 			
	neg d4				; change direction	1 wird -1
Ok3:
	cmp.b #$81,d1		; sind wir oben?						$81
	bne Ok4				; 
	neg d4				; change direction
Ok4:	
	move.b d1,WaitDiw3
	;move.b d1,WaitDiw4 ; teste das
	rts
	
BewegeDiwUnten:
	add.b d5,d2
	cmp.b #$37,d2		; bottom check - sind wir unten?		$37
	bne Ok5				; 			
	neg d5				; change direction	1 wird -1
Ok5:
	cmp.b #$0,d2		; sind wir oben?						$0
	bne Ok6				; 
	neg d5				; change direction
Ok6:	
	;move.b d2,WaitDiw5 ; teste das
	move.b d2,WaitDiw6
	rts

BewegeDiwHoriz:
	add.b XaddStart,d6
	sub.b XaddEnde,d7
	cmp.b #$ff,d6		; sind wir rechts?		$80
	bne Ok7				; 				
	neg.b XaddStart		; change direction	1 wird -1
	neg.b XaddEnde
Ok7:
	cmp.b #$5c,d6		; sind wir links?		$5c
	bne Ok8				; 
	neg.b XaddStart		; change direction
	neg.b XaddEnde
Ok8:		
	lea WaitDiw1,a0
	move.b d6,1(a0)
	move.b d7,5(a0)
	bsr DdfBerechnung	; zum Vergleich mit und ohne DDF-Berechnung
	
	lea WaitDiw3,a0
	move.b d6,1(a0)
	move.b d7,5(a0)
	;move.w d7,24(a0)	; change color

	lea WaitDiw5,a0
	move.b d6,1(a0)
	move.b d7,5(a0)
	rts	
	
*******************************************************************************
* In diesen Routinen werden die DDF-Werte berechnet und in der Copperliste	  *
* gendert																	  *
*******************************************************************************

DdfBerechnung:
	movem.l d0-d2,-(a7)
; Eingangswerte	
	moveq	#0,d0
	move.w	d6,d0		; move.w  #$5c,d0		; H_START in d0	
	move.w	d7,d1		; move.w  #$d4,d1		; H_ENDE in d1
; --- DDFSTRT-Berechnung ---
	move.w	d0,d2		; Kopie
	;mulu	#10,d0		; erweitert mit 10	wegen -8.5
	lsl.w	#3,d0		; d0=d0*8	; mulu optimieren
	add.w	d2,d0		; d0=d0*9
	add.w	d2,d0		; d0=d0*10
	lsr.w	#1,d0		; /2
	sub.w	#85,d0		; wegen -8.5
	divu	#10,d0		; 	 
	and.w	#$fff8,d0	; Ergebnis in d0    DDFSTRT
; --- DDFSTOP-Berechnung ---	
	add.w	#$100,d1	; DIWSTOP richtige Gre
	sub.w	d2,d1		; Pixelentfernung  d2=d2-d0  $1d4-$5c=$178
	lsr.l	#1,d1		; /2
	;sub.w	#8,d1		; -8	; ruckelt am rechten Rand
	add		d0,d1		; Ergebnis in d1	DDFSTOP

	;move.b #$20,9(a0)	; DDFSTRT=(HSTRT/2)-8,5 AND $FFF8        //  ($81/2)-8,5 AND $FFF8	 =$38
	;move.b #$d8,13(a0)	; DDFSTOP=DDFSTRT+(PixelproZeile/2-8)    //  $38+(320/2-8)			 =$d0
	
	move.b d0,9(a0)		; DDFSTRT eintragen
	move.b d1,13(a0)	; DDFSTOP eintragen

	movem.l (a7)+,d0-d2
	rts
	
; Variablen
XaddStart:
	dc.b	$1
XaddEnde:
	dc.b	$1
	
******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0
;----------------------------------------------------------		
	dc.w	$8e
WaitDiw1:
	dc.w	$1a5c		; DIWSTRT		; $1a
	dc.w	$90
WaitDiw2:
	dc.w	$80d4		; DIWSTOP		; $80
;----------------------------------------------------------	
	dc.w	$92,$20		; DDFSTRT
	dc.w	$94,$d8		; DDFSTOP
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2
	dc.w	$108,0		; BPL1MOD
	dc.w	$10a,0		; BPL2MOD	
	
				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres
	
Bplpointers:
	dc.w	$e0,0,$e2,0	; erste Bitplane

	dc.w	$180,$000	; COLOR00	; Hintergrund schwarz
	dc.w	$182,$0f0	; COLOR01	; Farbe 1 der Bitplane
	
	dc.w	$7f21,$fffe	; 7f bis hier her kann DIWSTRT VV verschoben werden
	dc.w	$180,$aaa
	dc.w	$7f3f,$fffe	
	dc.w	$180,$000

	dc.w	$8021,$fffe	; FF Zeile 255
	dc.w	$182,$00f	
;----------------------------------------------------------	
	dc.w	$8e
WaitDiw3:
	dc.w	$8181		; DIWSTRT		; $81
	dc.w	$90
WaitDiw4:
	dc.w	$ffc1		; DIWSTOP		; $ff
;----------------------------------------------------------	
	dc.w	$ff21,$fffe	; ff Zeile 255
	dc.w	$180,$aaa
	dc.w	$ff3f,$fffe	
	dc.w	$180,$000
	dc.w	$182,$0ff
;----------------------------------------------------------	
	dc.w	$8e
WaitDiw5:
	dc.w	$ff81		; DIWSTRT		; $ff
	dc.w	$90
WaitDiw6:
	dc.w	$37c1		; DIWSTOP		; $37 
;----------------------------------------------------------	
	dc.w	$ffdf,$fffe ; > Zeile 255

	dc.w	$3721,$fffe	; 37 ist die letzt Zeile die angesprochen werden kann
	dc.W	$180,$aaa
	dc.w	$373f,$fffe	
	dc.w	$180,$000	
							
	dc.w	$ffff,$fffe	; Ende der Copperlist

Bitplane:
	blk.b 10240,$55
	blk.b 10240,$55
	;incbin "/Sources/320x256x1_raster.raw"
	end