
; Listing23a4.s
; vertikale Positionierung eines Lowres-Screens 320x256
; dynamisch	- im oberen, unteren und mittleren Bereich gleichzeitig
; keine nderung der DDFSTRT-DDFSTOP Werte

	SECTION SCREEN,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte Copperlist

	move.l	#Bitplane,d0		; Adresse des Bitplane in d0
	lea	Bplpointers,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist	
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Init:
	move #$20,d0				; Start y1 Position oben
	move #$81,d1				; Start y2 Position mitte
	move #$20,d2				; Start y3 Position unten
	move #1,d3					; y1 add
	move #1,d4					; y2 add
	move #1,d5					; y3 add

MainLoop:
	cmpi.b	#$aa,$dff006		; Zeile $aa?
	bne.s	MainLoop

Warte:
	cmpi.b	#$aa,$dff006		; Zeile $aa?
	beq.s	Warte

	bsr.w	BewegeDiwOben		; Bewege Screen vertikal (oben)
	bsr.w	BewegeDiwMitte		; Bewege Screen vertikal (mitte)
	bsr.w	BewegeDiwUnten		; Bewege Screen vertikal (unten)
		
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	MainLoop
	
	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

*******************************************************************************
* In diesen Routinen werden die DIW Y-Werte in der Copperliste gendert       *
*******************************************************************************

BewegeDiwOben:
	add.b d3,d0
	cmp.b #$80,d0		; bottom check - sind wir unten?		$80
	bne Ok1				; 				
	neg d3				; change direction	1 wird -1
Ok1:
	cmp.b #$1a,d0		; sind wir oben?						$1a
	bne Ok2				; 
	neg d3				; change direction
Ok2:	
	move.b d0,WaitDiw1
	;move.b d0,WaitDiw2 ; teste das
	rts
	

BewegeDiwMitte:
	add.b d4,d1
	cmp.b #$ff,d1		; bottom check - sind wir unten?		$FF
	bne Ok3				; 			
	neg d4				; change direction	1 wird -1
Ok3:
	cmp.b #$81,d1		; sind wir oben?						$81
	bne Ok4				; 
	neg d4				; change direction
Ok4:	
	move.b d1,WaitDiw3
	;move.b d1,WaitDiw4 ; teste das
	rts


BewegeDiwUnten:
	add.b d5,d2
	cmp.b #$37,d2		; bottom check - sind wir unten?		$37
	bne Ok5				; 			
	neg d5				; change direction	1 wird -1
Ok5:
	cmp.b #$0,d2		; sind wir oben?						$0
	bne Ok6				; 
	neg d5				; change direction
Ok6:	
	;move.b d2,WaitDiw5 ; teste das
	move.b d2,WaitDiw6
	rts
	
******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0
;----------------------------------------------------------		
	dc.w	$8e
WaitDiw1:
	dc.w	$1a81		; DIWSTRT		; $1a
	dc.w	$90
WaitDiw2:
	dc.w	$80c1		; DIWSTOP		; $80
;----------------------------------------------------------	
	dc.w	$92,$38		; DDFSTRT
	dc.w	$94,$d0		; DDFSTOP
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2
	dc.w	$108,0		; BPL1MOD
	dc.w	$10a,0		; BPL2MOD	
	
				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres
	
Bplpointers:
	dc.w	$e0,0,$e2,0	; erste Bitplane

	dc.w	$180,$000	; COLOR00	; Hintergrund schwarz
	dc.w	$182,$0f0	; COLOR01	; Farbe 1 der Bitplane
	
	dc.w	$7f21,$fffe	; bis $7F kann DIWSTRT VV verschoben werden
	dc.w	$180,$aaa
	dc.w	$7f3f,$fffe	
	dc.w	$180,$000

	dc.w	$8021,$fffe	; FF Zeile 255
	dc.w	$182,$00f	
;----------------------------------------------------------	
	dc.w	$8e
WaitDiw3:
	dc.w	$8181		; DIWSTRT		; $81
	dc.w	$90
WaitDiw4:
	dc.w	$ffc1		; DIWSTOP		; $ff
;----------------------------------------------------------	
	dc.w	$ff21,$fffe	; ff Zeile 255
	dc.w	$180,$aaa
	dc.w	$ff3f,$fffe	
	dc.w	$180,$000
	dc.w	$182,$0ff
;----------------------------------------------------------	
	dc.w	$8e
WaitDiw5:
	dc.w	$FF81		; DIWSTRT		; $ff
	dc.w	$90
WaitDiw6:
	dc.w	$37c1		; DIWSTOP		; $37 
;----------------------------------------------------------	
	dc.w	$ffdf,$fffe ; > Zeile 255

	dc.w	$3721,$fffe	; 37 ist die letzt Zeile die angesprochen werden kann
	dc.W	$180,$aaa
	dc.w	$373f,$fffe	
	dc.w	$180,$000	
							
	dc.w	$ffff,$fffe	; Ende der Copperlist

Bitplane:
	blk.b 10240,$55
	;incbin "/Sources/320x256x1_raster.raw"
	end   
