
; Listing20c.s		; bootfhige Diskette erstellen und ein Demo mittels DoIo()
;					 von der Diskette in den Speicher laden und starten 
; Originalautor: fstarred , modifiziert: Rock'n Roll

MAIN_ADDRESS = $70000
DoIo = -456
ProgSectors=2        ; program expected size expressed in sectors
Writeflag = 1

	IF WriteFlag = 1
	AUTO        WS\BOOTBLOCK\0\ProgSectors+2\CC\
	ENDC
       
bootblock:
	dc.b	'DOS',0
	dc.l	0
	dc.l	880
       
bootEntry:
	lea	MAIN_ADDRESS,a5

	move.l	#(ProgSECTORS)*512,36(a1)	; Length
	move.l	a5,40(a1)                   ; ReadBuffer
	move.l	#1024,44(a1)                ; Offset
	jsr	DoIo(a6)                        ; execute

	move.l	#0,36(a1)			; motor off
	move.w	#9,28(a1)			; command: MOTOR
	jsr	DoIo(a6)

	jmp	(a5)					; Jmp to sysoff

bootEnd:
	ds.b	1024-(bootEnd-bootBlock)	; fill remaining space
										; of first 2 sectors with $00
mainStart:
	include	"Listing20c_prg.s"
mainEnd:
	ds.b	(ProgSectors*512)-(mainEnd-mainStart)       
								; fill remaining space
								; of prog sectors with $00
	end

	PRINTT	"BOOTBLOCK REAL SIZE..."
	PRINTV	bootEnd
	PRINTT	"MAIN PROG REAL SIZE..."
	PRINTV	mainEnd-mainStart

	end

Bei diesem Listing handelt es sich um ein Programm, das neben dem Bootblock 
weitere Sektoren der Diskette mit Programmcode beschreibt.
- (Sektoren 1 und 2) 1024Bytes	-> Bootblock
- (Sektoren 3 und 4) 1024Bytes  -> weiterer Programmcode 

Das Programm im Bootblock ldt ber die Systemfunktion DoIO() diesen 
Programmcode an eine vorher festgelegte Speicheradresse $70000 und startet dann
ber einen Sprung an diese Adresse das Programm von dort. 

;------------------------------------------------------------------------------
; zunchst die Diskette erstellen

ber eine Variable Writeflag kann der Prozess zur Erstellung der Diskette durch
das Programm automatisiert erfolgen.

Jeweils:
Diskette erstellen unter:
WinUAE/Floppy/new floppy image/ create standard disk
Disk label: bootdisk1
kein Haken bei Bootblock,
kein Haken bei FFS

Diskette unter Floppy drives/ DF0: einlegen

;------------------------------------------------------------------------------
; Test - WriteFlag = 1		; 1 to write bootblock

>a			
Pass1
Include : "Listing20c_prg.s"	= 7307 (=$0001C8B)
Pass2
$000026E	622 "...n" %...
No Errors
>WS
RAM PTR>BOOTBLOCK		; Ziel	
DISK PTR>0				; in Sector 0 speichern
LENGTH>ProgSectors+2	; 2 Sectoren speichern
>CC						; checksum

;------------------------------------------------------------------------------
; danach die Diskette einlegen