
; Listing20.s
; it's for testing various commandline parameters - testresults
; based on WinUAE 5.3


;------------------------------------------------------------------------------
; 1. winuae64.exe 
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM winuae64.exe																			; ok - open Quickstart page

;##############################################################################
; Configfile/Options: Listing20a.bat
;##############################################################################
;------------------------------------------------------------------------------
; 2. -config=<configfile.uae> ; load a config-file
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -config=<configfile.uae>	; Load the given configuration file during startup.
REM -config=					; load a config-file
winuae64.exe -config=A1200_Assembler.uae													; ok - open  Configuration *1)
winuae64.exe -config=A500_Assembler.uae -s use_gui=no										; ok - 100%
winuae64.exe -config=A500_Assembler.uae -s use_gui=no -s floppy_speed=200					; ok - 100%  *2)
winuae64.exe -config=A500_Assembler.uae -s statefile=Savestates\asm-kurs.uss -s use_gui=no	; ok - 100%  *3)
winuae64.exe -config=A500_Assembler.uae -s statefile=Savestates\asm-kurs.uss -G				; ok - 100%  *3)
winuae64.exe -config=%CD%\A500_Assembler.uae -G												; 
winuae64.exe -s statefile=Savestates\asm-kurs.uss -G										; ok - 100%  *4)

;------------------------------------------------------------------------------
; 3. -f <configfile> ; load a config-file
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -f <configfile> ; load a config-file
winuae64.exe -f A1200_Assembler.uae															; ok - open  Configuration *1)
winuae64.exe -f configs\A1200_Assembler.uae													; doesn't work *5)
winuae64.exe -f Configurations\A1200_Assembler.uae											; ok - open  Configuration *1)
winuae64.exe -f Configurations\A500_Assembler.uae -G										; ok - 100%
winuae64.exe -f Configurations\A500\A500_Assembler.uae -s use_gui=no						; ok - 100%

;------------------------------------------------------------------------------
; 4. -cfgparam=
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -cfgparam=
REM -cfgparam
winuae64.exe -cfgparam=quickstart=A500,1													; doesn't work *6)
winuae64.exe -cfgparam=quickstart=A1200,3 -s use_gui=no										; doesn't work *6)										
winuae64.exe -cfgparam quickstart=A1200,3 -s use_gui=no										; doesn't work *6)
winuae64.exe -config=A1200_Assembler.uae -cfgparam use_gui=no								; ok - 100%
winuae64.exe -config=A500_Assembler.uae -cfgparam use_gui=no -cfgparam chipset=aga			; works ! but be aware!

;------------------------------------------------------------------------------
; 5. -s quickstart=
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -s quickstart=
winuae64.exe -s quickstart=A500,1 -G														; works ! *7)
winuae64.exe -s quickstart=A1200,1 -s use_gui=no											; works ! *7)
winuae64.exe -s quickstart=A1200,3 -s floppy_speed=100	-G									; works ! *7)


;------------------------------------------------------------------------------
; remarks
;-----------------------------------------------------------------------------

*1) after starting, the selected configuration starts
    Name in Configuration is not changed when opening  GUI/configurations
*2) also changes in GUI/Floppy drives/ to 200% correctly!!
*3) also changes the name of the selected savestate in GUI/Miscs
*4) works just as well
*5) C:\Users\Public\Documents\Amiga Files\WinUAE\Configurations
*6)
	https://eab.abime.net/printthread.php?t=115702
	https://eab.abime.net/showpost.php?p=1644206&postcount=3
*7) The (selected) settings are not displayed
    in Emulated Hardware: Model or Configuration
	otherwise it works: 
	Tick for Start in Qickstart mode does not matter whether it is set or not
*8)	neither WinUAE starts nor help is opened


 _________________
| | ___________ |o|
| | ___________ | |
| | ___________ | |
| | ___________ | |
| |_____________| |
|     _______     |
|    |       |   ||
| DD |       |   V|
|____|_______|____|
      Robert Craggs

;##############################################################################
; Disk: Listing20a2.bat
;##############################################################################

;------------------------------------------------------------------------------
; 6. -help
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -h
REM -help
winuae64.exe -h																				; doesn't work *8)
winuae64.exe -help																			; doesn't work *8)


;------------------------------------------------------------------------------
; 7. -0
;-----------------------------------------------------------------------------


REM ---------------------------------------------------------------
REM -0																						; works
winuae64.exe -0 "G:\Amiga\Spiele\RocknRoll.adf" -G


;------------------------------------------------------------------------------
; 8. -diskswapper=
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -diskswapper=
winuae64.exe -f A500_Assembler.uae
			 -diskswapper="D:\Amiga\Demos\RSI-MegademoB.adf"
			 -0 "D:\Amiga\Demos\RSI-MegademoA.adf"
			 -G																				; works


;------------------------------------------------------------------------------
; 9. -cdimage=
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM 
-cdimage=image.iso			; Inserts the given image into the emulated						; not tested
							; CD-ROM drive.


            __
           (  )
            ||
            ||
        ___|""|__.._
       /____________\
	   \____________/~~~.

;##############################################################################
; Debugger relevant: Listing20b.cmd
;##############################################################################

;------------------------------------------------------------------------------
; 10. -D
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -D ; Start the debugger.
winuae64.exe -config=A500_Assembler.uae -G -D												; doesn't work

;------------------------------------------------------------------------------
; 11. -s cycle_exact
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -w value	; CPU emulation speed. Possible values: 0 for 
				; cycle exact, -1 for maximum speed. 
winuae64.exe -config=A500_Assembler.uae -w 1 -G												; doesn't work													
winuae64.exe -config=A500_Assembler.uae -s cycle_exact=false -G								; works

;------------------------------------------------------------------------------
; 12. -conlogfile <path to file> 
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -conlogfile <path to file> 
winuae64.exe  -config=A500_Assembler.uae -G -conlogfile "D:\Amiga\log.txt"					; works

;------------------------------------------------------------------------------
; 13. -inputdevicelog x
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM -inputdevicelog 16	; debug switches
winuae64.exe  -config=A500_Assembler.uae -log -inputdevicelog 16 -G							; works
winuae64.exe  -config=A500_Assembler.uae -log -inputdevicelog 1 -G							; works

		16 - that allowed to write the POTINP read/write in the log, which
		     allowed me to find an issue
			 T.W. Most of them are undocumented debugging options that keep
			 changing between versions.

;------------------------------------------------------------------------------
; 14. -i
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM  -i							; Enable illegal memory.
winuae64.exe  -config=A500_Assembler.uae -log -i -G		


;------------------------------------------------------------------------------
; 15. -i
;-----------------------------------------------------------------------------

REM ---------------------------------------------------------------
REM  -i	
winuae64.exe  -config=A500_Assembler.uae -log -blitterdebug 1 -G								; not tested

You can use -blitterdebug 1 to enable blitter log messages which should help to						
find out when blitter was started and used parameters.

-blitterdebug 16" command line will break to debugger if blitter registers are
written while blitter is active. It is not "official" debug option but probably
good enough for this task.


     _____              .---...-.
   ,'  -. `.          ,' _____...'
  /   - _ - \        : .' _   _ \\
 :    ' _)'  :       | :-(_).(_)::
(_           ;)      | |    -'  ||
  \     _   /        ; |    _   ||
   `..___..'         `-'..____.'`'
      ;._:               _; :_
     /    \ SSt        ,'  `' `. SSt

;##############################################################################
; -0: Listing20c.bat
;##############################################################################
;------------------------------------------------------------------------------
; 16. -0 (over floppy)
;-----------------------------------------------------------------------------

@REM Loading Amiga exe via command line like Disk -0
@echo off

H:
cd H:\Amiga\WinUAE_5300

REM ---------------------------------------------------------------
REM 
winuae64.exe -config=A1200_Assembler.uae -0 "D:\Amiga\L15c" -G								; works  

; (vasmm68k_mot -m68020 -Fhunkexe -nocase -quiet -o L15c Listing15c.s)


;##############################################################################
; Filesystem: Listing20d.bat
;##############################################################################
;------------------------------------------------------------------------------
; 17. -s filesystem (over s/startup-sequence)
;-----------------------------------------------------------------------------

uaedbg from commandline: 2nd example:
Starting WinUAE from the command line
It's just a quick way to get 68040 setup ("Blizzard 1240 quickstart") 
with hard drive mounted from folder (you'd need to do an installation/copy files
there if you want to run other commands/need libraries from disk).
 
REM ---------------------------------------------------------------
REM 
winuae64.exe -s quickstart=a1200,3 
			 -s filesystem2=rw,DH0:DH0:"D:\Amiga\uaedbg\hd",0								; works 
			 -s use_gui=no
			 -s debug_mem=true
			 
; %CD% - it's current directory

winuae64.exe -s quickstart=a1200,3 
			-s filesystem2=rw,DH0:DH0:%CD%\hd,0
			-s uaehf0=dir,rw,DH0:DH0:%CD%\hd,0
			-s use_gui=no -s   
			-s debug_mem=true
