
; Listing19p1.s
; 
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

; il [<mask>]           Exception breakpoint.
;------------------------------------------------------------------------------

start:
	btst	#2,$dff016			; right mousebutton?
	bne.s	start
	
	bsr exc1					; Division by Zero												; $00000014 05:    DIV BY 0
	;bsr exc2					; Privilege Violation (im User Mode)       reset				; $00000020 08:    PRIVIL VIO
	;bsr exc3					; Adress Error (68000 and 68010)								; $0000000C 03:    ADR ERROR
	;bsr exc4					; Illegaler Opcode												; $00000010 04:    ILLEG OPC
	;bsr exc5					; Line-A														; $00000028 10:    LINEA EMU	

	nop
	rts

;------------------------------------------------------------------------------
; 1. Division by Zero        divu    #0,d0
exc1:
	move.b	#10,d0
	move.b	#2,d1
	divu    d1,d0			; d0=10/2=5
	sub.b	#1,d1
	divu    d1,d0			; d0=10/1=10
	sub.b	#1,d1
	divu    d1,d0			; d0=10/0= --> Exception
	nop
	rts
	
;------------------------------------------------------------------------------
; 2. Privilege Violation (im User Mode)       reset
exc2:
	reset
	nop						; for fi nop
	rts

;------------------------------------------------------------------------------
; 3. Adress Error (data access only with 68000 and 68010)
exc3:     
	move.w  $1,d0
	nop
	rts

;------------------------------------------------------------------------------
; 4. Illegaler Opcode
exc4:
	dc.w    $4afc			; illegal
	nop
	rts

;------------------------------------------------------------------------------
; 5. Line-A
exc5:
	dc.w    $a000
	nop
	rts

	end

;------------------------------------------------------------------------------
; g-run
;------------------------------------------------------------------------------
>r
Filename:Listing19p1.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is waiting for the right mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - set breakpoint
>d pc
00021294 66f6                     bne.b #$f6 == $0002128c (T)
00021296 6100 0016                bsr.w #$0016 == $000212ae
0002129a 6100 002c                bsr.w #$002c == $000212c8
0002129e 6100 002e                bsr.w #$002e == $000212ce
000212a2 6100 0034                bsr.w #$0034 == $000212d8
000212a6 6100 0036                bsr.w #$0036 == $000212de
000212aa 4e71                     nop
000212ac 4e75                     rts  == $00c4f748
;------------------------------------------------------------------------------
>f 21296
Breakpoint added.
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 4194303 Chip, 8388607 CPU. (V=105 H=5 -> V=105 H=47)
VPOS: 105 ($069) HPOS: 047 ($02f) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 6100 (BSR) 0016 (OR) Chip latch 00000000
00021296 6100 0016                bsr.w #$0016 == $000212ae
Next PC: 0002129a
;------------------------------------------------------------------------------
>il																				; without il the program runs into the exception without a break.
Exception breakpoint mask: FFFFFFFF 00FFFFFF
>
;------------------------------------------------------------------------------
>g
; Exception 5, PC=000212c4						; but this info message is missed here
Cycles: 159 Chip, 318 CPU. (V=105 H=47 -> V=105 H=206)
VPOS: 105 ($069) HPOS: 225 ($0e1) COP: $0001ede4
  D0 00000005   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C60E62
USP  00C5FE64 ISP  00C60E62
SR=2004 T=00 S=1 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 616c (BSR) 616a (BSR) Chip latch 00000000
00fc081e 616c                     bsr.b #$6c == $00fc088c
Next PC: 00fc0820
;------------------------------------------------------------------------------
>H 2
 0 206/105 000212c2 80c1                     divu.w d1,d0
-1 225/105 00fc081e 616c                     bsr.b #$6c == $00fc088c
;------------------------------------------------------------------------------
>d 212ae
000212ae 103c 000a                move.b #$0a,d0
000212b2 123c 0002                move.b #$02,d1
000212b6 80c1                     divu.w d1,d0
000212b8 0401 0001                sub.b #$01,d1
000212bc 80c1                     divu.w d1,d0
000212be 0401 0001                sub.b #$01,d1
000212c2 80c1                     divu.w d1,d0									; Exception 5, PC=000212c2
000212c4 4e71                     nop
000212c6 4e75                     rts  == $00040002
;------------------------------------------------------------------------------
>il
Exception breakpoint mask: 00000000 00000000
																				; on the end, disable the exception breakpoint with >il
																				; Exception breakpoint mask: 00000000 00000000
																				; otherwise the debugger reopens again and it can't be closed with >x
;------------------------------------------------------------------------------
>fd
All breakpoints removed.
>x

;------------------------------------------------------------------------------
; Single-Step
;------------------------------------------------------------------------------
>r
Filename:Listing19p1.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is waiting for the right mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - set breakpoint
>d pc
00021fdc 66f6                     bne.b #$f6 == $00021fd4 (T)
00021fde 6100 0006                bsr.w #$0006 == $00021fe6
00021fe2 4e71                     nop
00021fe4 4e75                     rts  == $00c4f748
00021fe6 103c 000a                move.b #$0a,d0
00021fea 123c 0002                move.b #$02,d1
00021fee 80c1                     divu.w d1,d0
00021ff0 0401 0001                sub.b #$01,d1
00021ff4 80c1                     divu.w d1,d0
00021ff6 0401 0001                sub.b #$01,d1
>d
00021ffa 80c1                     divu.w d1,d0									; Exception 5, PC=00021FFC
00021ffc 4e71                     nop
00021ffe 4e75                     rts  == $00c4f748
;------------------------------------------------------------------------------
>f 21fde
Breakpoint added.
>g
Breakpoint 0 triggered.
Cycles: 4194303 Chip, 8388607 CPU. (V=105 H=5 -> V=105 H=50)
VPOS: 105 ($069) HPOS: 050 ($032) COP: $0001ede4
  D0 00000005   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 6100 (BSR) 0006 (OR) Chip latch 00000000
00021fde 6100 0006                bsr.w #$0006 == $00021fe6
Next PC: 00021fe2
;------------------------------------------------------------------------------
>il
Exception breakpoint mask: FFFFFFFF 00FFFFFF
;------------------------------------------------------------------------------
>t --> Cycles: 9 Chip, 18 CPU. (V=105 H=50 -> V=105 H=59)
>t --> Cycles: 4 Chip, 8 CPU. (V=105 H=59 -> V=105 H=63)
>t --> Cycles: 4 Chip, 8 CPU. (V=105 H=63 -> V=105 H=67)
>t --> Cycles: 67 Chip, 134 CPU. (V=105 H=67 -> V=105 H=134)
>t --> Cycles: 4 Chip, 8 CPU. (V=105 H=134 -> V=105 H=138)
>t --> Cycles: 67 Chip, 134 CPU. (V=105 H=138 -> V=105 H=205)
>t --> Cycles: 4 Chip, 8 CPU. (V=105 H=205 -> V=105 H=209)
>t
Exception 5, PC=00021FFC														; here comes this info message!		
Cycles: 0 Chip, 0 CPU. (V=105 H=209 -> V=105 H=209)
VPOS: 106 ($06a) HPOS: 001 ($001) COP: $0001ede4
  D0 00000005   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C60E62
USP  00C5FE64 ISP  00C60E62
SR=2004 T=00 S=1 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 616c (BSR) 616a (BSR) Chip latch 00000000
00fc081e 616c                     bsr.b #$6c == $00fc088c
Next PC: 00fc0820
>
;------------------------------------------------------------------------------
>il
Exception breakpoint mask: 00000000 00000000
																				; on the end, disable the exception breakpoint with >il
																				; Exception breakpoint mask: 00000000 00000000
																				; otherwise the debugger reopens again and it can't be closed with >x
;------------------------------------------------------------------------------
>fd
All breakpoints removed.
>x


;------------------------------------------------------------------------------
; tx - if you only break on any next exception, then use the tx-command.
;------------------------------------------------------------------------------
>r
Filename:Listing19p1.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is waiting for the right mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - set breakpoint
>d pc
00022d50 0839 0002 00df f016      btst.b #$0002,$00dff016
00022d58 66f6                     bne.b #$f6 == $00022d50 (T)
00022d5a 6100 0006                bsr.w #$0006 == $00022d62
00022d5e 4e71                     nop
00022d60 4e75                     rts  == $00c4f748
00022d62 103c 000a                move.b #$0a,d0
00022d66 123c 0002                move.b #$02,d1
00022d6a 80c1                     divu.w d1,d0
00022d6c 0401 0001                sub.b #$01,d1
00022d70 80c1                     divu.w d1,d0
>d
00022d72 0401 0001                sub.b #$01,d1
00022d76 80c1                     divu.w d1,d0									; Exception 5, PC=00022D78
00022d78 4e71                     nop	
00022d7a 4e75                     rts  == $00c4f748
00022d7c 4e70                     reset
00022d7e 4e71                     nop
00022d80 4e75                     rts  == $00c4f748
00022d82 3039 0000 0001           move.w $00000001 [0000],d0
00022d88 4e71                     nop
00022d8a 4e75                     rts  == $00c4f748
;------------------------------------------------------------------------------
>f 22d5a
Breakpoint added.
>g																				
Breakpoint 0 triggered.															; and right mouse button
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=3 -> V=105 H=53)
VPOS: 105 ($069) HPOS: 053 ($035) COP: $0001ede4
  D0 00000005   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 6100 (BSR) 0006 (OR) Chip latch 00000000
00022d5a 6100 0006                bsr.w #$0006 == $00022d62
Next PC: 00022d5e
;------------------------------------------------------------------------------
>tx
Exception 5, PC=00022D78
Cycles: 0 Chip, 0 CPU. (V=105 H=53 -> V=105 H=53)
VPOS: 106 ($06a) HPOS: 004 ($004) COP: $0001ede4
  D0 00000005   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C60E62
USP  00C5FE64 ISP  00C60E62
SR=2004 T=00 S=1 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 616c (BSR) 616a (BSR) Chip latch 00000000
00fc081e 616c                     bsr.b #$6c == $00fc088c
Next PC: 00fc0820
;------------------------------------------------------------------------------
>fd
All breakpoints removed.
>x


;------------------------------------------------------------------------------
How does the 64Bit-Exception breakpoint mask: FFFFFFFF 00FFFFFF works?

>i
$00000000 00:    Reset:SSP $00000000  $00000080 32:      TRAP 00 $00FC0836
$00000004 01:     EXECBASE $00C00276  $00000084 33:      TRAP 01 $00FC0838
$00000008 02:    BUS ERROR $00FC0818  $00000088 34:      TRAP 02 $00FC083A
$0000000C 03:    ADR ERROR $00FC081A  $0000008C 35:      TRAP 03 $00FC083C
$00000010 04:    ILLEG OPC $00FC081C  $00000090 36:      TRAP 04 $00FC083E
$00000014 05:     DIV BY 0 $00FC081E  $00000094 37:      TRAP 05 $00FC0840
$00000018 06:          CHK $00FC0820  $00000098 38:      TRAP 06 $00FC0842
$0000001C 07:        TRAPV $00FC0822  $0000009C 39:      TRAP 07 $00FC0844
$00000020 08:   PRIVIL VIO $00FC090E  $000000A0 40:      TRAP 08 $00FC0846
$00000024 09:        TRACE $00FC0826  $000000A4 41:      TRAP 09 $00FC0848
$00000028 10:    LINEA EMU $00FC0828  $000000A8 42:      TRAP 10 $00FC084A
$0000002C 11:    LINEF EMU $00FC082A  $000000AC 43:      TRAP 11 $00FC084C
$00000038 14:   FORMAT ERR $00FC0830  $000000B0 44:      TRAP 12 $00FC084E
$0000003C 15:   INT Uninit $00FC0832  $000000B4 45:      TRAP 13 $00FC0850
$00000060 24:   INT Unjust $00FC0834  $000000B8 46:      TRAP 14 $00FC0852
$00000064 25:    Lvl 1 Int $00FC0C8E  $000000BC 47:      TRAP 15 $00FC0854
$00000068 26:    Lvl 2 Int $00FC0CE2
$0000006C 27:    Lvl 3 Int $00FC0D14
$00000070 28:    Lvl 4 Int $00FC0D6C
$00000074 29:    Lvl 5 Int $00FC0DFA
$00000078 30:    Lvl 6 Int $00FC0E40
$0000007C 31:          NMI $00FC0E86
>
;------------------------------------------------------------------------------
...
$00000014 05:     DIV BY 0 $00FC081E
...
;------------------------------------------------------------------------------
>m 14 1
00000014 00FC 081E 00FC 0820 00FC 0822 00FC 090E  ....... ..."....
>d FC081E 1
00fc081e 616c                     bsr.b #$6c == $00fc088c
>d rl($14) 1
00fc081e 616c                     bsr.b #$6c == $00fc088c
;------------------------------------------------------------------------------
																				; Set the exception mask

>?$ffff		; for all Exceptions from 0 to 15
$0000FFFF = %00000000`00000000`11111111`11111111 = 65535 = 65535
>?$0020		; Bit 5 is set for Exception 5
$00000020 = %00000000`00000000`00000000`00100000 = 32 = 32	
>il $20
Exception breakpoint mask: 00000000 00000020

The maskvalue is a little bit complicated. but this can help:
>?1<<5		; for Exception 5
$00000020 = %00000000`00000000`00000000`00100000 = 32 = 32
>?1<<27		; for Exception 27
$08000000 = %00001000`00000000`00000000`00000000 = 134217728 = 134217728
>il			; disable the exception breakpoint
Exception breakpoint mask: 00000000 00000000
>il			; enables the exception breakpoint with default mask
Exception breakpoint mask: FFFFFFFF 00FFFFFF
>

With default mask, Exception 27: Lvl 3 Int doesn't break, therefore change the maskvalue to
>il $8FFFFFF
Exception breakpoint mask: 00000000 08FFFFFF

>?1<<(47-32)		; for Exceptions from 32 to 47
>il $FFFFFFFF		; 0 bis 31
Exception breakpoint mask: 00000000 FFFFFFFF
>il $FFFFFFFFFFFF	; >32Bit masks are not possible
Exception breakpoint mask: 00000000 FFFFFFFF
>
