
; Listig19o1.s
; 
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
;
; dj [<level bitmask>] Enable joystick/mouse input debugging. 

;------------------------------------------------------------------------------
from https://www.markwrobel.dk/post/amiga-machine-code-letter11/

Before booting up the Amiga, make sure to enable debug logging in WinUAE under
properties. I have choosen to select "Log window", so that I can see the
updates in a separate window.
WinUAE/Settings/Paths/Debug logging	"Log window"


dj [<level bitmask>] Enable joystick/mouse input debugging. 

// 01 = host events
// 02 = joystick
// 04 = cia buttons
// 16 = potgo r/w
// 32 = vsync
// 128 = potgo write
// 256 = cia buttons write

;------------------------------------------------------------------------------	
																				; WinUAE F12 open GUI
																				; Load configuration or make a configuration
																				; WinUAE/Settings/Paths/Debug logging	"Log window"
																				; enable "Log window"
																				; press Start
;------------------------------------------------------------------------------	
KS ver = 34 (0x22)																; Log Window with lot of information
Stored port 0/2 d=0: added 200 0 Windows mouse WINMOUSE1
Port0: COMBO 'Windows mouse' + 'WINMOUSE1' matched
Stored port 1/2 d=0: added 0 0
Stored port 1/2 d=0: added 0 0
Port1: ID 'kbd1' matched
....
																				; Shift + F12 to get the prompt >
;------------------------------------------------------------------------------
>dj 1		
>x																				
																				; WinUAE has debugging feature for input events ..
																				; - run in windowed mode
																				; - start emulation, do not insert any disks etc..
																				; - press SHIFT+F12
																				; - type "dj 1" and press return
																				; - type x and press return	
	
																				; Now you should see all input events in console log window.															

STATE=00112 MAX=00000 AF=0 QUAL=000000 'Mouse1 Horizontal'
STATE=-0403 MAX=00000 AF=0 QUAL=000000 'Mouse1 Vertical'
STATE=00001 MAX=00001 AF=0 QUAL=000000 'Joy1 Fire/Mouse1 Left Button'
STATE=00112 MAX=00000 AF=0 QUAL=000000 'Mouse1 Horizontal'
STATE=-0403 MAX=00000 AF=0 QUAL=000000 'Mouse1 Vertical'
STATE=00000 MAX=00001 AF=0 QUAL=000000 'Joy1 Fire/Mouse1 Left Button'
STATE=00001 MAX=00001 AF=0 QUAL=000000 'CTRL'
Amiga key 63 0
STATE=00001 MAX=00001 AF=0 QUAL=100000 'C'
Amiga key 33 0
STATE=00000 MAX=00001 AF=0 QUAL=100000 'C'
Amiga key 33 1
STATE=00000 MAX=00001 AF=0 QUAL=000000 'CTRL'
Amiga key 63 1
...
;------------------------------------------------------------------------------
>dj 0																			; to break
Input logging level 0
>x
																				; Shift + F12
;------------------------------------------------------------------------------
>dj 2
Input logging level 2
>g
JOY0DAT=f84a 00fc0f94
JOY1DAT=0000 00fc0f94
...

JOY0DAT=uplr	; up & down left & right	

Mouse to the left		
horizontal share decreases	Difference=new mouse position-old mouse position	
JOY0DAT=8220			
JOY0DAT=8210			$10-$20=16-32= -16
JOY0DAT=82ff	; overflow	$ff-$10=-1-16= -17 = $FFEF 	

Mouse to the right		
Horizontal share increases
JOY0DAT=82d4
JOY0DAT=82f5			$f5-$d4=-11-(-44)=33
JOY0DAT=8203	; overflow	$03-$f5=  3-(-11)=14

Mouse up
JOY0DAT=4502
JOY0DAT=1202			$12-$45= 18-69=-51 = $FFCD
JOY0DAT=f102	; overflow	$f1-$12=-15-(18)= -33      

Mouse down
JOY0DAT=df02
JOY0DAT=fa02			$fa-$df=(-6)-(-33)=27
JOY0DAT=0102	; overflow	$01-$fa=1-(-6)=7	
																				; Shift + F12
;------------------------------------------------------------------------------
>dj 0
Input logging level 0
;------------------------------------------------------------------------------
>dj 4  // 04 = cia buttons
Input logging level 4
>x

BFE001 R: 03:C0 fe5a72
BFE001 R: 03:80 fe5a72
																				; Shift + F12
;------------------------------------------------------------------------------
>dj 6  // 02 = joystick & // 04 = cia buttons
Input logging level 6
>x

JOY0DAT=f6a1 00fe5a56
BFE001 R: 03:C0 fe5a72
JOY0DAT=f6a1 00fe5a56
BFE001 R: 03:C0 fe5a72
																				; Shift + F12
;------------------------------------------------------------------------------
>dj 32  // 32 = vsync
Input logging level 32
>x

*
*
*
*
*
*

																				; Shift + F12
;------------------------------------------------------------------------------