
; Listing19l2.s
; Copper Debugger, Copper Tracing, Copper Breakpoint
; 
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  o <0-2|addr> [<lines>] View memory as Copper instructions.
;  od                    Enable/disable Copper vpos/hpos tracing.
;  ot                    Copper single step trace.
;  ob <addr>             Copper breakpoint.

;------------------------------------------------------------------------------
; source from the danish-asm-course

start:

	move.w #$4000,$dff09a		; Interrupts disable
	lea.l	copperlist,a1		; start up our own copper list.
	move.l	a1,$dff080			; COP1LCH		
	move.w	#$8080,$dff096		; DMACON		

;waitline:
waitmouse:
	cmp.b	#$8F,$dff006		; vhposr - wait for line 144
	bne.s	waitmouse			; Waitline
;Aspetta:
;	cmp.b	#$8F,$dff006		; vhposr - noch Zeile 144?
;	beq.s	Aspetta
	nop						

somethingtodo:					; some work in line $8F, $90, ...
	move.b	#0,d0
	move.l	#0,d0	

	lea	Table,a0				; 12 cycles
	movem.l	(a0)+,d3-d7/a3-a6	; 84(21/0)		; 42 cycles 5*42=210
	movem.l	(a0)+,d3-d7/a3-a6
	movem.l	(a0)+,d3-d7/a3-a6
	movem.l	(a0)+,d3-d7/a3-a6
	movem.l	(a0)+,d3-d7/a3-a6
	movem.l	(a0)+,d3-d7/a3-a6


	btst	#2,$dff016			; right mousebutton?
	bne.s	waitmouse		 

	move.w	#$0080,$dff096		; DMACON		Retrieving the old copper 
								; settings back (as to reactivate the workbench) and
	move.l	$04,a6				; start the copper.
	move.l	156(a6),a1					
	move.l	38(a1),$dff080		; COP1LCH		
	move.w	#$81a0,$dff096		; DMACON	

	nop	
	move.w #$C000,$dff09a		; Interrupts enable
	rts

copperlist:						
	dc.w	$9001,$fffe
	dc.w	$0180,$0f00
	dc.w	$a001,$fffe
	dc.w	$0180,$0fff
	dc.w	$0180,$000f
	dc.w	$aa01,$fffe
	dc.w	$0180,$0fff
	dc.w	$ae01,$fffe
	dc.w	$0180,$0f00
	dc.w	$be01,$fffe
	dc.w	$0180,$0000
	dc.w	$ffff,$fffe				
	
table:
	blk.w 1200,$ffff	
				
	end


;------------------------------------------------------------------------------
>r
Filename:Listing19l2.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm
																				; the program is showing the norwegian flag
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12

VPOS: 210 ($0d2) HPOS: 006 ($006) COP: $000215c0
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66f6 (Bcc) 4e71 (NOP) Chip latch 0000FFFE
0002152c 66f6                     bne.b #$f6 == $00021524 (T)
Next PC: 0002152e
;------------------------------------------------------------------------------
>o0 1																			; actual copperpinter (end of frame)	
*000215c0: ffff ffff            ;  Skip if vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
;------------------------------------------------------------------------------
>o1 !13																			; copperlist without VPOS/HPOS-information
 00021590: 9001 fffe            ;  Wait for vpos >= 0x90 and hpos >= 0x00
                                ;  VP 90, VE 7f; HP 00, HE fe; BFD 1
 00021594: 0180 0f00            ;  COLOR00 := 0x0f00
 00021598: a001 fffe            ;  Wait for vpos >= 0xa0 and hpos >= 0x00
                                ;  VP a0, VE 7f; HP 00, HE fe; BFD 1
 0002159c: 0180 0fff            ;  COLOR00 := 0x0fff
 000215a0: 0180 000f            ;  COLOR00 := 0x000f
 000215a4: aa01 fffe            ;  Wait for vpos >= 0xaa and hpos >= 0x00
                                ;  VP aa, VE 7f; HP 00, HE fe; BFD 1
 000215a8: 0180 0fff            ;  COLOR00 := 0x0fff
 000215ac: ae01 fffe            ;  Wait for vpos >= 0xae and hpos >= 0x00
                                ;  VP ae, VE 7f; HP 00, HE fe; BFD 1
 000215b0: 0180 0f00            ;  COLOR00 := 0x0f00
 000215b4: be01 fffe            ;  Wait for vpos >= 0xbe and hpos >= 0x00
                                ;  VP be, VE 7f; HP 00, HE fe; BFD 1
 000215b8: 0180 0000            ;  COLOR00 := 0x0000
 000215bc: ffff fffe            ;  Wait for vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
                                ;  End of Copperlist
*000215c0: ffff ffff            ;  Skip if vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
;------------------------------------------------------------------------------
>od
Copper debugger enabled.
;------------------------------------------------------------------------------
>fs 313																			; run one frame forward	
Cycles: 71051 Chip, 142102 CPU. (V=210 H=6 -> V=210 H=6)
VPOS: 210 ($0d2) HPOS: 009 ($009) COP: $000215c0
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66f6 (Bcc) 4e71 (NOP) Chip latch 0000FFFE
0002152c 66f6                     bne.b #$f6 == $00021524 (T)
Next PC: 0002152e
;------------------------------------------------------------------------------
>o1 !13																			; now copperlist with VPOS/HPOS-information
 00021590: 9001 fffe [000 008]  ;  Wait for vpos >= 0x90 and hpos >= 0x00		; Copper breakpoint @0x00021590
                                ;  VP 90, VE 7f; HP 00, HE fe; BFD 1
 00021594: 0180 0f00 [090 008]  ;  COLOR00 := 0x0f00
 00021598: a001 fffe [090 00c]  ;  Wait for vpos >= 0xa0 and hpos >= 0x00
                                ;  VP a0, VE 7f; HP 00, HE fe; BFD 1
 0002159c: 0180 0fff [0a0 008]  ;  COLOR00 := 0x0fff
 000215a0: 0180 000f [0a0 00c]  ;  COLOR00 := 0x000f
 000215a4: aa01 fffe [0a0 010]  ;  Wait for vpos >= 0xaa and hpos >= 0x00
                                ;  VP aa, VE 7f; HP 00, HE fe; BFD 1
 000215a8: 0180 0fff [0aa 008]  ;  COLOR00 := 0x0fff
 000215ac: ae01 fffe [0aa 00c]  ;  Wait for vpos >= 0xae and hpos >= 0x00
                                ;  VP ae, VE 7f; HP 00, HE fe; BFD 1
 000215b0: 0180 0f00 [0ae 008]  ;  COLOR00 := 0x0f00
 000215b4: be01 fffe [0ae 00c]  ;  Wait for vpos >= 0xbe and hpos >= 0x00
                                ;  VP be, VE 7f; HP 00, HE fe; BFD 1
 000215b8: 0180 0000 [0be 008]  ;  COLOR00 := 0x0000
 000215bc: ffff fffe [0be 00c]  ;  Wait for vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
                                ;  End of Copperlist
*000215c0: ffff ffff            ;  Skip if vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
>
;------------------------------------------------------------------------------
>x and Shift+F12																; if you don't see cycle data, close and reopen
																				; the debugger again, sometimes it happens.
																				; maybe if start session from savestate?
;------------------------------------------------------------------------------
>ob 21590																		; copper breakpoint on first Copper address
Copper breakpoint @0x00021590
;------------------------------------------------------------------------------
																				; Copper tracing
>ot																				; 00021590: 9001 fffe [000 008]	- wait
Cycles: 23385 Chip, 46770 CPU. (V=210 H=9 -> V=0 H=13)							; VPOS: 000 ($000) HPOS: 013 
VPOS: 000 ($000) HPOS: 013 ($00d) COP: $00021594								; COP: $00021594 - actual Copperpointer
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0001 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 66f6 (Bcc) 4e71 (NOP) Chip latch 0000FFFE
0002152c 66f6                     bne.b #$f6 == $00021524 (T)
Next PC: 0002152e
;------------------------------------------------------------------------------
>o0 1
*00021594: 0180 0f00 [090 008]  ;  COLOR00 := 0x0f00
;------------------------------------------------------------------------------
>ot
Cycles: 32688 Chip, 65376 CPU. (V=0 H=13 -> V=144 H=13)							; 00021594: 0180 0f00 [090 008]  ;  COLOR00 := 0x0f00
VPOS: 144 ($090) HPOS: 017 ($011) COP: $0002159c								; VPOS: 144 ($090) HPOS: 017 ($011)
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021674   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4cd8 (MVMEL) 78f8 (MOVE) Chip latch 0000FFFE
00021554 4cd8 78f8                movem.l (a0)+,d3-d7/a3-a6
Next PC: 00021558
;------------------------------------------------------------------------------
>o0 1
*0002159c: 0180 0fff [0a0 008]  ;  COLOR00 := 0x0fff
;------------------------------------------------------------------------------
>ot
Cycles: 3622 Chip, 7244 CPU. (V=144 H=17 -> V=160 H=7)							; 0002159c: 0180 0fff [0a0 008]  ;  COLOR00 := 0x0fff
VPOS: 160 ($0a0) HPOS: 012 ($00c) COP: $000215a2								; VPOS: 160 ($0a0) HPOS: 012 ($00c)
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0c39 (CMP) 008f (ILLEGAL) Chip latch 00000180
00021524 0c39 008f 00df f006      cmp.b #$8f,$00dff006
Next PC: 0002152c
;------------------------------------------------------------------------------
>o0 1
*000215a2: 000f aa01            ;  Skip if , ignore horizontal
                                ;  VP 00, VE 2a; HP 0e, HE 00; BFD 1
;------------------------------------------------------------------------------
>ot																				; 000215a2: 000f aa01            ;  Skip if - alignmend???
Cycles: 1 Chip, 2 CPU. (V=160 H=12 -> V=160 H=13)								; 000215a0: 0180 000f [0a0 00c]  ;  COLOR00 := 0x000f
VPOS: 160 ($0a0) HPOS: 022 ($016) COP: $000215a8								; VPOS: 160 ($0a0) HPOS: 022 ($016) 
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66f6 (Bcc) 4e71 (NOP) Chip latch 0000FFFE
0002152c 66f6                     bne.b #$f6 == $00021524 (T)
Next PC: 0002152e
;------------------------------------------------------------------------------
>o0 1
*000215a8: 0180 0fff [0aa 008]  ;  COLOR00 := 0x0fff
;------------------------------------------------------------------------------
>ot
Cycles: 2255 Chip, 4510 CPU. (V=160 H=22 -> V=170 H=7)							; 000215a8: 0180 0fff [0aa 008]  ;  COLOR00 := 0x0fff		
VPOS: 170 ($0aa) HPOS: 017 ($011) COP: $000215b0								; VPOS: 170 ($0aa) HPOS: 017 ($011)
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66f6 (Bcc) 4e71 (NOP) Chip latch 0000FFFE
00021524 0c39 008f 00df f006      cmp.b #$8f,$00dff006
0002152c 66f6                     bne.b #$f6 == $00021524 (T)
Next PC: 0002152e
;------------------------------------------------------------------------------
>o0 1
*000215b0: 0180 0f00 [0ae 008]  ;  COLOR00 := 0x0f00
;------------------------------------------------------------------------------
>ot
Cycles: 900 Chip, 1800 CPU. (V=170 H=17 -> V=174 H=9)							; 000215b0: 0180 0f00 [0ae 008]  ;  COLOR00 := 0x0f00
VPOS: 174 ($0ae) HPOS: 014 ($00e) COP: $000215b8								; VPOS: 174 ($0ae) HPOS: 014 ($00e)
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0c39 (CMP) 008f (ILLEGAL) Chip latch 0000FFFE
00021524 0c39 008f 00df f006      cmp.b #$8f,$00dff006
Next PC: 0002152c
;------------------------------------------------------------------------------
>o0 1
*000215b8: 0180 0000 [0be 008]  ;  COLOR00 := 0x0000
;------------------------------------------------------------------------------
>ot
Cycles: 3625 Chip, 7250 CPU. (V=174 H=14 -> V=190 H=7)							; 000215b8: 0180 0000 [0be 008]  ;  COLOR00 := 0x0000	
VPOS: 190 ($0be) HPOS: 012 ($00c) COP: $000215be								; VPOS: 190 ($0be) HPOS: 012 ($00c)
  D0 00000000   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00021698   A1 00021590   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0c39 (CMP) 008f (ILLEGAL) Chip latch 0000FFFF
00021524 0c39 008f 00df f006      cmp.b #$8f,$00dff006
Next PC: 0002152c
;------------------------------------------------------------------------------
>o0 1
*000215be: fffe ffff            ;  NULL := 0xffff
;------------------------------------------------------------------------------
>ob