
; Listing19k4.s
; DMA Debugger - DMA and CPU-Usage - blitter cycle sequence
; cycle-exact mode must be activated
;
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger	
;
;------------------------------------------------------------------------------
; Listing9a1.s - Lschen von $10 Wrter mit dem BLITTER (dient als Vorlage)
; Bevor Sie dieses Beispiel sich ansehen, schauen Sie sich Listing2fs an, wo es herkommt
; gelschter Speicher mit dem 68000

	SECTION Blit,CODE

Inizio:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - stop multitasking
	lea	GfxName,a1				; Adresse des Namens der zu ffnenden Bibliothek in a1
	jsr	-$198(a6)				; OpenLibrary
	move.l	d0,a6				; benutze eine Routine von graphics library:

	jsr	-$1c8(a6)				; OwnBlitter, 
								; das gibt uns den exklusiven Zugang auf dem Blitter
								; verhindert, das es vom Betriebssystem verwendet wird.
								; Wir mssen warten, bevor wir den Blitter benutzen
								; das es einen laufenden BLittervorgang beendet hat.
								; Die folgenden Anweisungen erledigen das							    
;------------------------------------------------------------------------------
WaitWblank:
	move.l $dff004,d0
	and.l #$000fff00,d0
	cmp.l #$00005000,d0			; $50
	;cmp.l #$000001000,d0		; $10  (ohne Bitplanearea) 
	bne.s	WaitWblank

	btst	#6,$dff002			; warte auf das Ende des Blitters (leerer Test)
								; fr den BUG von Agnus
waitblit:
	btst	#6,$dff002			; freier Blitter?
	bne.s	waitblit

; Hier ist, wie man einen Blitt macht !!! 
; Nur 5 Anweisungen zum Zurcksetzen !!!
;	     __
;	__  /_/\   __
;	\/  \_\/  /\_\
;	 __   __  \/_/   __
;	/\_\ /\_\  __   /\_\
;	\/_/ \/_/ /_/\  \/_/
;	     __   \_\/
;	    /\_\  __
;	    \/_/  \/

	move.w	#$0100,$dff040		; BLTCON0: nur Ziel D ist aktiviert				
								; die MINTERMS (dh die Bits 0-7) sind alle
								; zurckgesetzt. Auf diese Weise ist die 
								; Lschoperation definiert					

	move.w	#$0000,$dff042		; BLTCON1: Wir werden dieses Register spter erklren
	move.l	#START,$dff054		; BLTDPT: Adresse des Zielkanals
	move.w	#$0000,$dff066		; BLTDMOD: Wir werden dieses Register spter erklren
	move.w	#(1*64)+$10,$dff058 ; BLTSIZE: definiert die Dimension des
								; Rechtecks. In diesem Fall haben wir
								; $10 Wrter Breite und 1 Zeilenhhe.
								; Weil die Hhe des Rechtecks in die Bits 6-15 von 
								; BLTSIZE ??geschrieben wird
								; mssen wir es 6 Bits nach links verschieben.
								; Dies entspricht der Multiplikation seines Wertes
								; mit 64. Die Breite wird in die niedrigen
								; 6 Bits geschrieben und werden daher nicht
								; gendert.
								; Auerdem beginnt diese Anweisung die Blittata					 

	;btst	#6,$dff002			; warte auf das Ende des Blitters (leerer Test)
;waitblit2:
	;btst	#6,$dff002			; freier Blitter?
	;bne.s	waitblit2

	btst	#2,$dff016			; right mousebutton?
	bne.s	WaitWblank	
;------------------------------------------------------------------------------

	jsr	-$1ce(a6)				; DisOwnBlitter, das Betriebssystem
								; kann den Blitter jetzt wieder benutzen
	move.l	a6,a1				; Basis der Grafikbibliothek zum Schlieen
	move.l	4.w,a6
	jsr	-$19e(a6)				; Closelibrary - schliee die Grafikbibliothek
	jsr	-$7e(a6)				; Enable - Multitasking einschalten
	rts

******************************************************************************

	SECTION THE_DATA,DATA_C

; Beachten Sie, dass die gelschten Daten im CHIP-Speicher liegen mssen
; Tatschlich funktioniert der Blitter nur im CHIP-Speicher

START:
	dcb.b	$20,$fe
THEEND:
	dc.b	'Hier loeschen wir nicht'

	even

GfxName:
	dc.b	"graphics.library",0,0

	end


;------------------------------------------------------------------------------
; 1. Test - Blitteroperation inside bitplane
; Waitblank here: cmp.l #$00005000,d0		; line $50
;------------------------------------------------------------------------------

>r
Filename:Listing19k4.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm				   
																				; Shift+F12 open the Debugger
;------------------------------------------------------------------------------
>v-4
DMA debugger enabled, mode=4.
>x																				
;------------------------------------------------------------------------------
																				; GUI, chipset/cycle-exact on
;------------------------------------------------------------------------------
																				; Shift+F12 open the Debugger
>vm
0,0: 00222222 * -
1,0: 00444444 * Refresh
1,1: 00444444 * Refresh
1,2: 00444444 * Refresh
1,3: 00444444 * Refresh
2,0: 00a25342 * CPU
2,1: 00ad98d6 * CPU
3,0: 00eeee00 * Copper
3,1: 00aaaa22 * Copper
3,2: 00666644 * Copper
4,0: 00ff0000 * Audio
4,1: 00ff0000 * Audio
4,2: 00ff0000 * Audio
4,3: 00ff0000 * Audio
5,0: 00008888 * Blitter
5,1: 00008888 * Blitter
6,0: 000000ff * Bitplane
6,1: 000000ff * Bitplane
6,2: 000000ff * Bitplane
6,3: 000000ff * Bitplane
6,4: 000000ff * Bitplane
6,5: 000000ff * Bitplane
6,6: 000000ff * Bitplane
6,7: 000000ff * Bitplane
7,0: 00ff00ff * Sprite
7,1: 00ff00ff * Sprite
7,2: 00ff00ff * Sprite
7,3: 00ff00ff * Sprite
7,4: 00ff00ff * Sprite
7,5: 00ff00ff * Sprite
7,6: 00ff00ff * Sprite
7,7: 00ff00ff * Sprite
8,0: 00ffffff * Disk
8,1: 00ffffff * Disk
8,2: 00ffffff * Disk
;------------------------------------------------------------------------------
>vm 5 00ff00																	; change blitter color to green
5,0: 0000ff00 * Blitter
>x
;------------------------------------------------------------------------------
>v $50																			; watch DMA-Debugger Info
Line: 50  80 HPOS 00   0:
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -] A
                 CPU-RWD                RFS0   03C      CPU-RWD   RFS1   1FE      CPU-RWI   RFS2   1FE N
                    8000                        *=         5005           *F         000F              D
                00DFF004                  00021888     00DFF006     0002188A     0002A6CC     0002188C

               102   1F8                 144   00C    103   1F8    145   00C    166   053    146   00C

 [08 008 -]   [09 00A -]   [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -]   [0E 014 -]   [0F 016 -] C
    CPU-RWI   RFS3   1FE      CPU-RWI                   CPU-RWI                                        M
       FF00                      0C80                      0000                                        P
   0002A6CE     0002188E     0002A6D0                  0002A6D2

  167   053    147   00C    168   053                 169   053

 [10 018 -]   [11 01A -]   [12 01C -]   [13 01E -]   [14 020 -]   [15 022 -]   [16 024 -] B [17 026 -]
    CPU-RWI                   CPU-RWI                   CPU-RWI                           c
       5000                      66EC                      0839                           c
   0002A6D4                  0002A6D6                  0002A6D8

  16A   053                 16B   053                 16C   053

 [18 028 -]   [19 02A -]   [1A 02C -] B [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
                 CPU-RWI              T    CPU-RWI                   CPU-RWI                   CPU-RWI
                    0006              S       00DF                      F002                      0839
                0002A6DA              T   0002A6DC                  0002A6DE                  0002A6E0

               16D   053                 16E   053                 16F   053                 170   053

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -] B [25 042 -]   [26 044 -]   [27 046 -]
                 CPU-RBD                   CPU-RWI              T    CPU-RWI                   CPU-RWI
                    0023                      0006   (          S       00DF                      F002
                00DFF002                  0002A6E2              T   0002A6E4                  0002A6E6

               101   1F8                 171   053                 172   053                 173   053

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -] B [2F 056 -]
                 CPU-RWI                   CPU-RBD                   CPU-RWI              c
                    66F6                      0023                      33FC              c
                0002A6E8                  00DFF002                  0002A6EA

               174   053                 101   1F8                 175   053

 [30 058 -]   [31 05A -]   [32 05C -] M [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
                 CPU-RWI              O    CPU-RWI                   CPU-RWI                   CPU-RWI
                    0100              V       00DF                      F040                      33FC
                0002A6EC              E   0002A6EE                  0002A6F0                  0002A6F2

               176   053                 177   053                 178   053                 179   053

 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -] M [3D 072 -]   [3E 074 -]   [3F 076 -]
                 CPU-WWD                   CPU-RWI              O    CPU-RWI                   CPU-RWI
                    0100                      0000   0          V       00DF                      F042
                00DFF040                  0002A6F4              E   0002A6F6                  0002A6F8

               120   1F8                 17A   053                 17B   053                 17C   053

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -] M
              BPL2   112      CPU-RWI   BPL1   110      CPU-WWD   BPL2   112      CPU-RWI   BPL1   110 O
                    0000         23FC         1800         0000         0000         0001         0000 V
                0001A890     0002A6FA     00015890     00DFF042     0001A892     0002A6FC     00015892 E

               048   0D4    17D   053    048   0AC    121   1F8    049   0D4    17E   053    049   0AC

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
       0508         0000         00DF         0000         F054         0000         33FC         0000
   0002A6FE     0001A894     0002A700     00015894     0002A702     0001A896     0002A704     00015896

  17F   053    04A   0D4    180   053    04A   0AC    181   053    04B   0D4    182   053    04B   0AC
;------------------------------------------------------------------------------
>v $50 $48
Line: 50  80 HPOS 48  72:
 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
       0508         0000         00DF         0000         F054         0000         33FC         0000
   0002A6FE     0001A894     0002A700     00015894     0002A702     0001A896     0002A704     00015896

  17F   053    04A   0D4    180   053    04A   0AC    181   053    04B   0D4    182   053    04B   0AC

 [50 098 -]   [51 09A -]   [52 09C -]   [53 09E -]   [54 0A0 -]   [55 0A2 -] M [56 0A4 -]   [57 0A6 -]
    CPU-WWD   BPL2   112      CPU-WWD   BPL1   110      CPU-RWI   BPL2   112 O    CPU-RWI   BPL1   110
       0001         0000         0508         0000         0000         0000 V       00DF         0000
   00DFF054     0001A898     00DFF056     00015898     0002A706     0001A89A E   0002A708     0001589A

  12A   1F8    04C   0D4    12B   1F8    04C   0AC    183   053    04D   0D4    184   053    04D   0AC

 [58 0A8 -]   [59 0AA -]   [5A 0AC -]   [5B 0AE -]   [5C 0B0 -]   [5D 0B2 -]   [5E 0B4 -]   [5F 0B6 -] M
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-WWD   BPL2   112      CPU-RWI   BPL1   110 O
       F066         0000         33FC         0000         0000         0000         0050         0000 V
   0002A70A     0001A89C     0002A70C     0001589C     00DFF066     0001A89E     0002A70E     0001589E E

  185   053    04E   0D4    186   053    04E   0AC    133   1F8    04F   0D4    187   053    04F   0AC

 [60 0B8 -]   [61 0BA -]   [62 0BC -]   [63 0BE -]   [64 0C0 -]   [65 0C2 -]   [66 0C4 -]   [67 0C6 -]
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-WWD   BPL1   110
       00DF         0000         F058         0000         0839         0000         0050         0000
   0002A710     0001A8A0     0002A712     000158A0     0002A714     0001A8A2     00DFF058     000158A2

  188   053    050   0D4    189   053    050   0AC    18A   053    051   0D4    12C   1F8    051   0AC

 [68 0C8 -]   [69 0CA -] B [6A 0CC -]   [6B 0CE -]   [6C 0D0 -]   [6D 0D2 -]   [6E 0D4 -]   [6F 0D6 -]
    CPU-RWI   BPL2   112 T    CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
  B    0002         0000 S  B    00DF         0000    B    F016         0000    B    66A6         0000
   0002A716     0001A8A4 T   0002A718     000158A4     0002A71A     0001A8A6     0002A71C     000158A6

  18B   053    052   0D4    18C   053    052   0AC    18D   053    053   0D4    18E   053    053   0AC

 [70 0D8 -]   [71 0DA -]   [72 0DC -]   [73 0DE -]   [74 0E0 -]   [75 0E2 -] B [76 0E4 -]   [77 0E6 -]
    CPU-RBD   BPL2   112   BLT-D   00   BPL1   110      CPU-RWI   BPL2   112 c BLT-D   00   BPL1   110
  B    0005         0000         0000         0000    B)   4EAE         0000 c       0000         0000
   00DFF016     0001A8A8     00010508     000158A8     0002A71E     0001A8AA     0001050A     000158AA

  10B   1F8    054   0D4    084   082    054   0AC    18F   053    055   0D4    085   082    055   0AC

 [78 0E8 -]   [79 0EA -]   [7A 0EC -]   [7B 0EE -]   [7C 0F0 -]   [7D 0F2 -] M [7E 0F4 -]   [7F 0F6 -]
    CPU-RWI   BPL2   112   BLT-D   00   BPL1   110      CPU-RWI   BPL2   112 O BLT-D   00   BPL1   110
  B    2039         0000         0000         0000    B    00DF         0000 V       0000         0000
   0002A6C4     0001A8AC     0001050C     000158AC     0002A6C6     0001A8AE E   0001050E     000158AE

  162   053    056   0D4    086   082    056   0AC    163   053    057   0D4    087   082    057   0AC

 [80 0F8 -]   [81 0FA -]   [82 0FC -]   [83 0FE -]   [84 100 -]   [85 102 -]   [86 104 -]   [87 106 -]
    CPU-RWI   BPL2   112   BLT-D   00   BPL1   110      CPU-RWI   BPL2   112   BLT-D   00   BPL1   110
  B    F004         0000         0000         0000    B    0280         0000         0000         0000
   0002A6C8     0001A8B0     00010510     000158B0     0002A6CA     0001A8B2     00010512     000158B2

  164   053    058   0D4    088   082    058   0AC    165   053    059   0D4    089   082    059   0AC

 [88 108 -]   [89 10A -]   [8A 10C -]   [8B 10E -]   [8C 110 -]   [8D 112 -]   [8E 114 -]   [8F 116 -]
    CPU-RWD   BPL2   112   BLT-D   00   BPL1   110      CPU-RWD   BPL2   112   BLT-D   00   BPL1   110
  B    8000         0000         0000         0000    B    508D         0000         0000         0000
   00DFF004     0001A8B4     00010514     000158B4     00DFF006     0001A8B6     00010516     000158B6

  102   1F8    05A   0D4    08A   082    05A   0AC    103   1F8    05B   0D4    08B   082    05B   0AC

 [90 118 -]   [91 11A -] A [92 11C -]   [93 11E -]   [94 120 -]   [95 122 -]   [96 124 -]   [97 126 -]
    CPU-RWI   BPL2   112 N BLT-D   00   BPL1   110      CPU-RWI   BPL2   112   BLT-D   00   BPL1   110
  B    000F         0000 D       0000         0000    B    FF00         0000         0000         0000
   0002A6CC     0001A8B8     00010518     000158B8     0002A6CE     0001A8BA     0001051A     000158BA

  166   053    05C   0D4    08C   082    05C   0AC    167   053    05D   0D4    08D   082    05D   0AC
;------------------------------------------------------------------------------
>v $50 $90
Line: 50  80 HPOS 90 144:
 [90 118 -]   [91 11A -] A [92 11C -]   [93 11E -]   [94 120 -]   [95 122 -]   [96 124 -]   [97 126 -]
    CPU-RWI   BPL2   112 N BLT-D   00   BPL1   110      CPU-RWI   BPL2   112   BLT-D   00   BPL1   110
  B    000F         0000 D       0000         0000    B    FF00         0000         0000         0000
   0002A6CC     0001A8B8     00010518     000158B8     0002A6CE     0001A8BA     0001051A     000158BA

  166   053    05C   0D4    08C   082    05C   0AC    167   053    05D   0D4    08D   082    05D   0AC

 [98 128 -]   [99 12A -]   [9A 12C -]   [9B 12E -]   [9C 130 -]   [9D 132 -]   [9E 134 -]   [9F 136 -] C
    CPU-RWI   BPL2   112   BLT-D   00   BPL1   110      CPU-RWI   BPL2   112   BLT-D   00   BPL1   110 M	; (B=BPL, d=blit D ch, "-" cycles are free for the CPU)
  B    0C80         0000         0000         0000    B    0000         0000         0000         0000 P	; = B-BdB-BdB-BdB-Bd (this is correct!)
   0002A6D0     0001A8BC     0001051C     000158BC     0002A6D2     0001A8BE     0001051E     000158BE		; -BdB-BdB
																											; Any blitter cycle needs free cycle, even if it is idle cycle.
  168   053    05E   0D4    08E   082    05E   0AC    169   053    05F   0D4    08F   082    05F   0AC		; CPU can use any idle blitter cycle.

 [A0 138 -]   [A1 13A -]   [A2 13C -]   [A3 13E -]   [A4 140 -]   [A5 142 -]   [A6 144 -]   [A7 146 -]
    CPU-RWI   BPL2   112   BLT-D   00   BPL1   110      CPU-RWI   BPL2   112   BLT-D   00   BPL1   110		; search for BLT-D
  B    5000         0000         0000         0000    B    66EC         0000         0000         0000		; B
   0002A6D4     0001A8C0     00010520     000158C0     0002A6D6     0001A8C2     00010522     000158C2

  16A   053    060   0D4    090   082    060   0AC    16B   053    061   0D4    091   082    061   0AC

 [A8 148 -]   [A9 14A -]   [AA 14C -] B [AB 14E -]   [AC 150 -]   [AD 152 -]   [AE 154 -]   [AF 156 -] B
    CPU-RWI   BPL2   112   BLT-D   00 c BPL1   110   BLT-D   00   BPL2   112      CPU-RWI   BPL1   110 T
  B    0839    b    0000         0000 c       0000    D    0000         0000         0006         0000 S	; b D
   0002A6D8     0001A8C4     00010524     000158C4     00010526     0001A8C6     0002A6DA     000158C6 T

  16C   053    062   0D4    092   082    062   0AC    093   082    063   0D4    16D   053    063   0AC

 [B0 158 -]   [B1 15A -]   [B2 15C -]   [B3 15E -]   [B4 160 -]   [B5 162 -]   [B6 164 -]   [B7 166 -]
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-RBD   BPL1   110
       00DF         0000         F002         0000         0839         0000         0023         0000
   0002A6DC     0001A8C8     0002A6DE     000158C8     0002A6E0     0001A8CA     00DFF002     000158CA

  16E   053    064   0D4    16F   053    064   0AC    170   053    065   0D4    101   1F8    065   0AC

 [B8 168 -]   [B9 16A -] B [BA 16C -]   [BB 16E -]   [BC 170 -]   [BD 172 -]   [BE 174 -]   [BF 176 -]
    CPU-RWI   BPL2   112 T    CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
       0006         0000 S       00DF         0000         F002         0000         66F6         0000
   0002A6E2     0001A8CC T   0002A6E4     000158CC     0002A6E6     0001A8CE     0002A6E8     000158CE

  171   053    066   0D4    172   053    066   0AC    173   053    067   0D4    174   053    067   0AC

 [C0 178 -]   [C1 17A -]   [C2 17C -]   [C3 17E -] B [C4 180 -]   [C5 182 -]   [C6 184 -]   [C7 186 -] M
    CPU-RBD   BPL2   112      CPU-RWI   BPL1   110 c              BPL2   112      CPU-RWI   BPL1   110 O
       0023         0000         33FC         0000 c                    0000         0100         0000 V
   00DFF002     0001A8D0     0002A6EA     000158D0                  0001A8D2     0002A6EC     000158D2 E

  101   1F8    068   0D4    175   053    068   0AC                 069   0D4    176   053    069   0AC

 [C8 188 -]   [C9 18A -]   [CA 18C -]   [CB 18E -]   [CC 190 -]   [CD 192 -]   [CE 194 -]   [CF 196 -]
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-WWD   BPL1   110
       00DF         0000         F040         0000         33FC         0000         0100         0000
   0002A6EE     0001A8D4     0002A6F0     000158D4     0002A6F2     0001A8D6     00DFF040     000158D6

  177   053    06A   0D4    178   053    06A   0AC    179   053    06B   0D4    120   1F8    06B   0AC

 [D0 198 -]   [D1 19A -] M [D2 19C -]   [D3 19E -]   [D4 1A0 -]   [D5 1A2 -]   [D6 1A4 -]   [D7 1A6 -]
    CPU-RWI   BPL2   112 O    CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
  1    0000         0000 V       00DF         0000         F042         0000         23FC         0000	; 1 - DDFSTOP	
   0002A6F4     0001A8D8 E   0002A6F6     000158D8     0002A6F8     0001A8DA     0002A6FA     000158DA

  17A   053    06C   0D4    17B   053    06C   0AC    17C   053    06D   0D4    17D   053    06D   0AC

 [D8 1A8 -]   [D9 1AA -]   [DA 1AC -]   [DB 1AE -] M [DC 1B0 -]   [DD 1B2 -]   [DE 1B4 -]   [DF 1B6 -]
    CPU-WWD   BPL2   112      CPU-RWI   BPL1   110 O    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
       0000         0000         0001         0000 V       0508         0000         00DF         0000
   00DFF042     0001A8DC     0002A6FC     000158DC E   0002A6FE     0001A8DE     0002A700     000158DE

  121   1F8    06E   0D4    17E   053    06E   0AC    17F   053    06F   0D4    180   053    06F   0AC
;------------------------------------------------------------------------------
>v $50 $d8
Line: 50  80 HPOS D8 216:
 [D8 1A8 -]   [D9 1AA -]   [DA 1AC -]   [DB 1AE -] M [DC 1B0 -]   [DD 1B2 -]   [DE 1B4 -]   [DF 1B6 -]
    CPU-WWD   BPL2   112      CPU-RWI   BPL1   110 O    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110
       0000         0000         0001         0000 V       0508         0000         00DF         0000
   00DFF042     0001A8DC     0002A6FC     000158DC E   0002A6FE     0001A8DE     0002A700     000158DE

  121   1F8    06E   0D4    17E   053    06E   0AC    17F   053    06F   0D4    180   053    06F   0AC

 [E0 1B8 -]   [E1 1BA -]   [E2 1BC -]
    CPU-RWI                   CPU-RWI
       F054                      33FC
   0002A702                  0002A704

  181   053                 182   053

>


;------------------------------------------------------------------------------
; 2. Test - Blitter outside bitplane
; Waitblank change to	cmp.l #$00001000,d0		; line $10
;------------------------------------------------------------------------------
 
>r
Filename:Listing19k4.s
>a
Pass1
Pass2
No Errors
>j
;------------------------------------------------------------------------------
>v $10 $80 3
Line: 10  16 HPOS 80 128:
 [80 0F8 -]   [81 0FA -]   [82 0FC -]   [83 0FE -]   [84 100 -]   [85 102 -]   [86 104 -] B [87 106 -]
 BLT-D   00      CPU-RWI   BLT-D   00      CPU-RBD   BLT-D   00      CPU-RWI   BLT-D   00 c				; = d-d-d-d-
       0000    B    66A6         0000    B    0005         0000    B    4EAE         0000 c B			
   00010508     00026CC4     0001050A     00DFF016     0001050C     00026CC6     0001050E

  084   082    162   036    085   082    10B   1F8    086   082    163   036    087   082

 [88 108 -]   [89 10A -]   [8A 10C -]   [8B 10E -]   [8C 110 -] M [8D 112 -]   [8E 114 -]   [8F 116 -]
 BLT-D   00      CPU-RWI   BLT-D   00      CPU-RWI   BLT-D   00 O    CPU-RWI   BLT-D   00      CPU-RWI
       0000    B    2039         0000    B    00DF         0000 V  B    F004         0000    B    0280
   00010510     00026C6C     00010512     00026C6E     00010514 E   00026C70     00010516     00026C72

  088   082    136   036    089   082    137   036    08A   082    138   036    08B   082    139   036

 [90 118 -]   [91 11A -]   [92 11C -]   [93 11E -]   [94 120 -]   [95 122 -]   [96 124 -] A [97 126 -]
 BLT-D   00      CPU-RWD   BLT-D   00      CPU-RWD   BLT-D   00      CPU-RWI   BLT-D   00 N    CPU-RWI
       0000    B    8000         0000    B    1094         0000    B    000F         0000 D  B    FF00
   00010518     00DFF004     0001051A     00DFF006     0001051C     00026C74     0001051E     00026C76

  08C   082    102   1F8    08D   082    103   1F8    08E   082    13A   036    08F   082    13B   036
   
;------------------------------------------------------------------------------
>v $10 $90 2
Line: 10  16 HPOS 90 144:
 [90 118 -]   [91 11A -]   [92 11C -]   [93 11E -]   [94 120 -]   [95 122 -]   [96 124 -] A [97 126 -]
 BLT-D   00      CPU-RWD   BLT-D   00      CPU-RWD   BLT-D   00      CPU-RWI   BLT-D   00 N    CPU-RWI
       0000    B    8000         0000    B    1094         0000    B    000F         0000 D  B    FF00
   00010518     00DFF004     0001051A     00DFF006     0001051C     00026C74     0001051E     00026C76

  08C   082    102   1F8    08D   082    103   1F8    08E   082    13A   036    08F   082    13B   036

 [98 128 -]   [99 12A -]   [9A 12C -]   [9B 12E -]   [9C 130 -]   [9D 132 -]   [9E 134 -] C [9F 136 -]
 BLT-D   00      CPU-RWI   BLT-D   00      CPU-RWI   BLT-D   00                BLT-D   00 M    CPU-RWI
       0000    B    0C80         0000    Bb   0000         0000                 D    0000 P       1000	; Bb
   00010520     00026C78     00010522     00026C7A     00010524                  00010526     00026C7C	; D - last Blitter cycle

  090   082    13C   036    091   082    13D   036    092   082                 093   082    13E   036
;------------------------------------------------------------------------------
 
>vo
DMA debugger disabled
>x

